//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Bayesian
 *
 *  Copyright 2005-2019 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTBAYESIAN_HXX
#define OPENTURNS_OTBAYESIAN_HXX

#include "openturns/GaussianLinearCalibration.hxx"
#include "openturns/CalibrationAlgorithm.hxx"
#include "openturns/CalibrationAlgorithmImplementation.hxx"
#include "openturns/CalibrationResult.hxx"
#include "openturns/CalibrationStrategy.hxx"
#include "openturns/CalibrationStrategyImplementation.hxx"
#include "openturns/LinearLeastSquaresCalibration.hxx"
#include "openturns/MCMC.hxx"
#include "openturns/NonLinearLeastSquaresCalibration.hxx"
#include "openturns/RandomWalkMetropolisHastings.hxx"
#include "openturns/GaussianNonLinearCalibration.hxx"

#endif /* OPENTURNS_OTBAYESIAN_HXX */
