<?php
/**
*
* install [Serbian]
*
* @package language
* @version $Id$
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'ADMIN_CONFIG'				=> 'Админ конфигурација',
	'ADMIN_PASSWORD'			=> 'Лозинка администратора',
	'ADMIN_PASSWORD_CONFIRM'	=> 'Потврди лозинку администратора',
	'ADMIN_PASSWORD_EXPLAIN'	=> 'Молимо вас да унесете лозинку дужине између 6 и 30 знакова.',
	'ADMIN_TEST'				=> 'Провери поставке администратора',
	'ADMIN_USERNAME'			=> 'Корисничко име администратора',
	'ADMIN_USERNAME_EXPLAIN'	=> 'Молимо вас да унесете корисничко име дужине између 3 и 20 знакова.',
	'APP_MAGICK'				=> 'Imagemagick подршка [ Прилози ]',
	'AUTHOR_NOTES'				=> 'Белешке аутора<br />» %s',
	'AVAILABLE'					=> 'Доступно',
	'AVAILABLE_CONVERTORS'		=> 'Доступни пребацивачи',

	'BEGIN_CONVERT'					=> 'Започни пребацивање',
	'BLANK_PREFIX_FOUND'			=> 'Скенирање ваших табела је показало исправну инсталацију без коришћења префикса табела.',
	'BOARD_NOT_INSTALLED'			=> 'Није пронађена инсталација',
	'BOARD_NOT_INSTALLED_EXPLAIN'	=> 'phpBB Unified Convertor Framework захтева задату инсталацију phpBB3 како би радио, молимо вас <a href="%s">наставите са првом инсталацијом phpBB3</a>.',
	'BACKUP_NOTICE'					=> 'Молимо направите резервну копију вашег форума пре ажурирања а за случај да се појаве сметње током поступка ажурирања.',

	'CATEGORY'					=> 'Категорија',
	'CACHE_STORE'				=> 'Тип кеша',
	'CACHE_STORE_EXPLAIN'		=> 'Физичко место где се подаци кеширају, препоручујемо систем датотека.',
	'CAT_CONVERT'				=> 'Пребаци',
	'CAT_INSTALL'				=> 'Инсталирај',
	'CAT_OVERVIEW'				=> 'Преглед',
	'CAT_UPDATE'				=> 'Ажурирај',
	'CHANGE'					=> 'Промени',
	'CHECK_TABLE_PREFIX'		=> 'Проверите префикс табеле и покушајте поново.',
	'CLEAN_VERIFY'				=> 'Чишћење и проверавање завршног састава',
	'CLEANING_USERNAMES'		=> 'Чишћење корисничких имена',
	'COLLIDING_CLEAN_USERNAME'	=> '<strong>%s</strong> је очишћено корисничко име за:',
	'COLLIDING_USERNAMES_FOUND'	=> 'Сукобљавајућа корисничка имена су пронађена на вашем старом форуму. Да бисте употпунили пребацивање молимо вас да обришете или преименујете ове кориснике тако да има само један корисник на вашем старом форуму за свако корисничко име.',
	'COLLIDING_USER'			=> '» корисников id: <strong>%d</strong> корисничко име: <strong>%s</strong> (%d порука)',
	'CONFIG_CONVERT'			=> 'Пребацивање конфигурације',
	'CONFIG_FILE_UNABLE_WRITE'	=> 'Није било могуће уписивање конфигурационе датотеке. Други начини како да направите ову датотеку су приказани испод.',
	'CONFIG_FILE_WRITTEN'		=> 'Конфигурационa датотека је уписанa. Сада можете наставити на следећи корак инсталације.',
	'CONFIG_PHPBB_EMPTY'		=> 'phpBB3 конфигурациона променљива за “%s” је празна.',
	'CONFIG_RETRY'				=> 'Покушај поново',
	'CONTACT_EMAIL_CONFIRM'		=> 'Потврди контакт e-mail',
	'CONTINUE_CONVERT'			=> 'Настави пребацивање',
	'CONTINUE_CONVERT_BODY'		=> 'Откривен је претходни покушај пребацивања. Сада можете изабрати између покретања новог пребацивања или настављања старог.',
	'CONTINUE_LAST'				=> 'Настави последње изјаве',
	'CONTINUE_OLD_CONVERSION'	=> 'Настави претходно покренуто пребацивање',
	'CONVERT'					=> 'Пребаци',
	'CONVERT_COMPLETE'			=> 'Пребацивање завршено',
	'CONVERT_COMPLETE_EXPLAIN'	=> 'Успешно сте пребацили ваш форум у phpBB 3.0. Сада се можете пријавити и <a href="../">приступити вашем форуму</a>. Молимо проверите да ли су поставке пребачене исправно пре омогућавања вашег форума брисањем install фасцикле. Молимо знајте да је помоћ за коришћење phpBB доступна на вези преко <a href="https://www.phpbb.com/support/documentation/3.0/">Documentation</a> и <a href="https://www.phpbb.com/community/viewforum.php?f=46">support forums</a>.',
	'CONVERT_INTRO'				=> 'Добро дошли на phpBB Unified Convertor Framework',
	'CONVERT_INTRO_BODY'		=> 'Одавде, можете увести податке са осталих (инсталираних) форума. Списак испод приказује све тренутно доступне модуле за пребацивање. Ако не постоји пребацивач приказан на овом списку за програм форума који желите да пребаците, молимо вас да посетите нашу веб страницу где накнадни модули за пребацивање могу бити доступни за преузимање.',
	'CONVERT_NEW_CONVERSION'	=> 'Ново пребацивање',
	'CONVERT_NOT_EXIST'			=> 'Одабрани пребацивач не постоји.',
	'CONVERT_OPTIONS'			=> 'Options',
	'CONVERT_SETTINGS_VERIFIED'	=> 'Информација коју сте унели је проверена. Да бисте почели са поступком пребацивања, молимо притисните дугме испод.',
	'CONV_ERR_FATAL'			=> 'Фатална грешка пребацивања',

	'CONV_ERROR_ATTACH_FTP_DIR'			=> 'FTP додавање прилога је омогућено на старом форуму. Молимо вас да онемогућите поставку FTP додавања и проверите да ли је изабрана исправна фасцикла за додавање, па потом копирајте све прилоге у ову нову веб приступљиву фасциклу. Када једном ово урадите, рестартујте пребацивач.',
	'CONV_ERROR_CONFIG_EMPTY'			=> 'Нема конфигурационих података доступних за пребацивање.',
	'CONV_ERROR_FORUM_ACCESS'			=> 'Не могу да добијем податак о приступу форуму.',
	'CONV_ERROR_GET_CATEGORIES'			=> 'Не могу да добијем категорије.',
	'CONV_ERROR_GET_CONFIG'				=> 'Не могу да добијем конфигурацију вашег форума.',
	'CONV_ERROR_COULD_NOT_READ'			=> 'Не могу да приступим/прочитам “%s”.',
	'CONV_ERROR_GROUP_ACCESS'			=> 'Не могу да добијем податке о потврди групе.',
	'CONV_ERROR_INCONSISTENT_GROUPS'	=> 'Недоследност у табели са групама откривена у add_bots() - треба да додате све посебне групе уколико то радите ручно.',
	'CONV_ERROR_INSERT_BOT'				=> 'Не могу да убацим робота у табелу корисника.',
	'CONV_ERROR_INSERT_BOTGROUP'		=> 'Не могу да убацим робота у bots табелу.',
	'CONV_ERROR_INSERT_USER_GROUP'		=> 'Не могу да убацим корисника у user_group табелу.',
	'CONV_ERROR_MESSAGE_PARSER'			=> 'Грешка у прослеђивачу порука',
	'CONV_ERROR_NO_AVATAR_PATH'			=> 'За развијаче: морате одредити $convertor[\'avatar_path\'] да бисте користили %s.',
	'CONV_ERROR_NO_FORUM_PATH'			=> 'Релативна путања до изворног форума није одређена.',
	'CONV_ERROR_NO_GALLERY_PATH'		=> 'За развијаче: морате одредити $convertor[\'avatar_gallery_path\'] да бисте користили %s.',
	'CONV_ERROR_NO_GROUP'				=> 'Група “%1$s” не може бити пронађена у %2$s.',
	'CONV_ERROR_NO_RANKS_PATH'			=> 'За развијаче: морате одредити $convertor[\'ranks_path\'] да бисте користили %s.',
	'CONV_ERROR_NO_SMILIES_PATH'		=> 'За развијаче: морате одредити $convertor[\'smilies_path\'] да бисте користили %s.',
	'CONV_ERROR_NO_UPLOAD_DIR'			=> 'За развијаче: морате одредити $convertor[\'upload_path\'] да бисте користили %s.',
	'CONV_ERROR_PERM_SETTING'			=> 'Не могу да убацим/ажурирам поставку дозвола.',
	'CONV_ERROR_PM_COUNT'				=> 'Не могу да изаберем фасциклу pm count.',
	'CONV_ERROR_REPLACE_CATEGORY'		=> 'Не могу да убацим нови форум да замени стару категорију.',
	'CONV_ERROR_REPLACE_FORUM'			=> 'Не могу да убацим нови форум да замени стари форум.',
	'CONV_ERROR_USER_ACCESS'			=> 'Не могу да добијем податак о потврди корисника.',
	'CONV_ERROR_WRONG_GROUP'			=> 'Погрешна група “%1$s” одређена у %2$s.',
	'CONV_OPTIONS_BODY'					=> 'Ова страница сакупља податке неопходне за приступ изворном форуму. Унесите појединости о бази вашег бившег форума; пребацивач неће променити ништа у бази датој испод. Изворни форум би требало да буде онемогућен како би се омогућило доследно пребацивање.',
	'CONV_SAVED_MESSAGES'				=> 'Сачуване поруке',

	'COULD_NOT_COPY'			=> 'Не могу да копирам датотеку <strong>%1$s</strong> у <strong>%2$s</strong><br /><br />Молимо проверите да ли одредишна фасцикла постоји и да ли је уписљива од веб сервера.',
	'COULD_NOT_FIND_PATH'		=> 'Не могу да пронађем путању до вашег бившег форума. Молимо проверите ваше поставке и пробајте поново.<br />» %s је била изабрана као изворна путања.',

	'DBMS'						=> 'Тип базе',
	'DB_CONFIG'					=> 'Конфигурација базе',
	'DB_CONNECTION'				=> 'Повезивање са базом',
	'DB_ERR_INSERT'				=> 'Грешка при обради <code>INSERT</code> упита.',
	'DB_ERR_LAST'				=> 'Грешка при обради <var>query_last</var>.',
	'DB_ERR_QUERY_FIRST'		=> 'Грешка током извршавања <var>query_first</var>.',
	'DB_ERR_QUERY_FIRST_TABLE'	=> 'Грешка током извршавања <var>query_first</var>, %s (“%s”).',
	'DB_ERR_SELECT'				=> 'Грешка током покретања <code>SELECT</code> упита.',
	'DB_HOST'					=> 'Име сервера базе или DSN',
	'DB_HOST_EXPLAIN'			=> 'DSN је скраћеница за Data Source Name и важи само за ODBC инсталације. На PostgreSQL, користите localhost за повезивање на local server преко UNIX domain socket и 127.0.0.1 за повезивање преко TCP. За SQLite, унесите пуну путању до датотеке ваше базе.',
	'DB_NAME'					=> 'Име базе',
	'DB_PASSWORD'				=> 'Лозинка базе',
	'DB_PORT'					=> 'Порт сервера базе',
	'DB_PORT_EXPLAIN'			=> 'Оставите ово празно осим уколико знате да сервер ради на не-стандардном порту.',
	'DB_UPDATE_NOT_SUPPORTED'	=> 'Жао нам је, али ова скрипта не подржава ажурирање верзија phpBB старијих од “%1$s”. Верзија коју тренутно имате инсталирану је “%2$s”. Молимо ажурирајте на претходну верзију пре покретања ове скрипте. Помоћ са овим је доступна на Форуму Подршке на phpBB.com.',
	'DB_USERNAME'				=> 'Корисничко име базе',
	'DB_TEST'					=> 'Испробај везу',
	'DEFAULT_LANG'				=> 'Задати језик форума',
	'DEFAULT_PREFIX_IS'			=> 'Пребацивач није у могућности да нађе табеле са одабраним префиксом. Молимо проверите да ли сте унели исправне појединости за форум који пребацујете. Задати префикс табеле за %1$s је <strong>%2$s</strong>.',
	'DEV_NO_TEST_FILE'			=> 'Није изабрана вредност за променљиву test_file у пребацивачу. Уколико сте корисник овог пребацивача, не би требало да видите ову грешку, молимо вас да пријавите ову поруку аутору пребацивача. Уколико сте ви аутор пребацивача, морате одредити име датотеке која постоји у изворном форуму како бисте омогућили проверу путање до ње.',
	'DIRECTORIES_AND_FILES'		=> 'Поставке фасцикли и датотека',
	'DISABLE_KEYS'				=> 'Онемогућавање тастатуре',
	'DLL_FIREBIRD'				=> 'Firebird',
	'DLL_FTP'					=> 'Удаљена FTP подршка [ Инсталација ]',
	'DLL_GD'					=> 'GD graphics подршка [ Визуелна Потврда ]',
	'DLL_MBSTRING'				=> 'Multi-byte знак подршка',
	'DLL_MSSQL'					=> 'MSSQL Сервер 2000+',
	'DLL_MSSQL_ODBC'			=> 'MSSQL Сервер 2000+ преко ODBC',
	'DLL_MSSQLNATIVE'			=> 'MSSQL Сервер 2005+ [ Native ]',
	'DLL_MYSQL'					=> 'MySQL',
	'DLL_MYSQLI'				=> 'MySQL са MySQLi Екстензијом',
	'DLL_ORACLE'				=> 'Oracle',
	'DLL_POSTGRES'				=> 'PostgreSQL',
	'DLL_SQLITE'				=> 'SQLite',
	'DLL_XML'					=> 'XML подршка [ Jabber ]',
	'DLL_ZLIB'					=> 'zlib сабијање подршка [ gz, .tar.gz, .zip ]',
	'DL_CONFIG'					=> 'Преузимање конфига',
	'DL_CONFIG_EXPLAIN'			=> 'Можете преузети потпун config.php на ваш рачунар. Онда ћете морати да додате датотеку ручно, замењујући постојећи config.php у вашој phpBB 3.0 root фасцикли. Молимо запамтите да датотеку додате у ASCII облику (погледајте документацију вашег FTP програма уколико нисте сигурни како да ово урадите). Када сте додали config.php молимо кликните на “Завршено” за померање ка следећем кораку.',
	'DL_DOWNLOAD'				=> 'Преузимање',
	'DONE'						=> 'Завршено',

	'ENABLE_KEYS'				=> 'Поновно-омогућавање тастатуре. Ово може мало да потраје.',

	'FILES_OPTIONAL'			=> 'Датотекe и фасцикле по избору',
	'FILES_OPTIONAL_EXPLAIN'	=> '<strong>По избору</strong> - Овe датотекe, фасцикле или поставке дозвола нису обавезне. Инсталациони систем ће покушати да их коришћењем разних техника направи уколико не постоје или нису уписљиве. У сваком случају, присуство овога ће убрзати инсталацију.',
	'FILES_REQUIRED'			=> 'Датотеке и Фасцикле',
	'FILES_REQUIRED_EXPLAIN'	=> '<strong>Обавезно</strong> - Да би исправно функционисао phpBB треба да има могућност да приступи или уписује у одређене датотеке или фасцикле. Уколико видите “Није Пронађено” онда треба да направите одговарајућу датотеку или фасциклу. Уколико видите “Неуписљиво” онда треба да промените дозволе датотеке или фасцикле да бисте омогућили да phpBB уписује у њих.',
	'FILLING_TABLE'				=> 'Попуњавам табелу <strong>%s</strong>',
	'FILLING_TABLES'			=> 'Попуњавам табеле',

	'FIREBIRD_DBMS_UPDATE_REQUIRED'		=> 'phpBB више не подржава Firebird/Interbase старије од Верзије 2.1. Молимо ажурирајте вашу Firebird инсталацију на бар 2.1.0 пре него што наставите са ажурирањем.',

	'FINAL_STEP'				=> 'Завршни корак',
	'FORUM_ADDRESS'				=> 'Адреса форума',
	'FORUM_ADDRESS_EXPLAIN'		=> 'Ово је URL вашег бившег форума, на пример <samp>http://www.example.com/phpBB2/</samp>. Уколико је овде унета адреса и није остављено празно онда ће свака појава ове адресе бити замењена адресом вашег новог форума у порукама, приватним порукама и потписима.',
	'FORUM_PATH'				=> 'Путања форума',
	'FORUM_PATH_EXPLAIN'		=> 'Ово је <strong>релативна</strong> путања на диску до вашег бившег форума од <strong>root ове phpBB3 инсталације</strong>.',
	'FOUND'						=> 'Нађено',
	'FTP_CONFIG'				=> 'Пребаци конфигурацију путем FTP',
	'FTP_CONFIG_EXPLAIN'		=> 'phpBB је пронашао постојање FTP модула на овом серверу. Можете покушати да инсталирате ваш config.php преко њега уколико желите. Мораћете да приложите податке приказане испод. Запамтите да су ваше корисничко име и лозинка они са вашег сервера! (питајте вашег провајдера за појединости уколико нисте сигурни који су).',
	'FTP_PATH'					=> 'FTP путања',
	'FTP_PATH_EXPLAIN'			=> 'Ово је путања од ваше root фасцикле до те од phpBB, н.пр. <samp>htdocs/phpBB3/</samp>.',
	'FTP_UPLOAD'				=> 'Додавање',

	'GPL'						=> 'General Public License',

	'INITIAL_CONFIG'			=> 'Основна конфигурација',
	'INITIAL_CONFIG_EXPLAIN'	=> 'Сада када је инсталација утврдила да ваш сервер може покренути phpBB треба да доставите и неке податке. Ако не знате како да се повежете на вашу базу молимо вас да се повежете са вашим провајдером (првом згодом) или користите phpBB форум за подршку. При уносу података молимо вас да их пажљиво прегледате пре него што наставите даље.',
	'INSTALL_CONGRATS'			=> 'Честитамо!',
	'INSTALL_CONGRATS_EXPLAIN'	=> '
		Успешно сте инсталирали phpBB %1$s. Молимо наставите одабиром једне од следећих могућности:</p>
		<h2>Пребацивање постојећег форума у phpBB3</h2>
		<p>phpBB Unified Convertor Framework подржава пребацивање phpBB 2.0.x и других форумских система у phpBB3. Уколико имате постојећи форум који желите да пребаците, молимо <a href="%2$s">продужите до пребацивача</a>.</p>
		<h2>Идите уживо са вашим phpBB3!</h2>
		<p>Клик на дугме испод одвешће вас до обрасца за слање статистичких података phpBB у вашој Админ Контролној Плочи (АКП). Ценили бисмо ако бисте могли да нам помогнете слањем тих података. Након свега треба вам мало времена да испитате могућности које су вам доступне. Молимо знајте да је помоћ на вези доступна преко <a href="https://www.phpbb.com/support/documentation/3.0/">Documentation</a>, <a href="%3$s">README</a> и <a href="https://www.phpbb.com/community/viewforum.php?f=46">Support Forums</a>.</p><p><strong>Молимо вас обришите, померите или преименујете install фасциклу пре него што почнете да користите форум. Док ова фасцикла постоји, само ће Админ Контролна Плоча (АКП) бити доступна.</strong>',
	'INSTALL_INTRO'				=> 'Добро дошли на Инсталацију',

	'INSTALL_INTRO_BODY'		=> 'Са овим избором, могуће је инсталирати phpBB3 на ваш сервер.</p><p>Како бисте наставили, требају вам поставке ваше базе. Уколико не знате поставке ваше базе, молимо вас да се повежете са вашим провајдером и питате за њих. Нећете бити у могућности да наставите без њих. Требају вам:</p>

	<ul>
		<li>Тип Базе - база коју ћете користити.</li>
		<li>Име Сервера базе или DSN - адреса сервера базе.</li>
		<li>Порт Сервера базе - порт сервера базе (у већини случајева ово није неопходно).</li>
		<li>Име Базе - име базе на серверу.</li>
		<li>Корисничко име Базе и лозинка Базе - подаци пријаве за приступ бази.</li>
	</ul>

	<p><strong>Белешка:</strong> уколико инсталирате користећи SQLite, требало би да унесете пуну стазу до датотеке ваше базе у DSN пољу и оставите празна поља за корисничко име и лозинку. Из сигурносних разлога, требало би да се осигурате да датотека базе није сачувана на месту приступачном са мреже.</p>

	<p>phpBB3 подржава следеће базе:</p>
	<ul>
		<li>MySQL 3.23 или већи (MySQLi подржано)</li>
		<li>PostgreSQL 7.3+</li>
		<li>SQLite 2.8.2+</li>
		<li>Firebird 2.1+</li>
		<li>MS SQL Сервер 2000 или већи (непосредно или преко ODBC)</li>
		<li>MS SQL Сервер 2005 или већи (native)</li>
		<li>Oracle</li>
	</ul>

	<p>Само оне базе које су подржане на вашем серверу ће бити приказане.',
	'INSTALL_INTRO_NEXT'		=> 'За почињање инсталације, молимо притисните дугме испод.',
	'INSTALL_LOGIN'				=> 'Пријава',
	'INSTALL_NEXT'				=> 'Следећи корак',
	'INSTALL_NEXT_FAIL'			=> 'Неке пробе нису прошле и требало би да исправите те сметње пре него што наставите са следећим кораком. Уколико тако не урадите може доћи до тога да имате непотпуну инсталацију.',
	'INSTALL_NEXT_PASS'			=> 'Све основне пробе су прошле и можете наставити са следећим кораком инсталације. Уколико сте променили дозволе, модуле, итд. и желите да их поново-испробате можете урадити тако уколико то желите.',
	'INSTALL_PANEL'				=> 'Инсталациона Плоча',
	'INSTALL_SEND_CONFIG'		=> 'На жалост phpBB не може да упише конфигурационе податке непосредно у ваш config.php. Ово може бити зато што датотека или не постоји или је неуписљива. Неке могућности ће вам бити приказане испод како бисте могли да завршите инсталацију config.php.',
	'INSTALL_START'				=> 'Почни инсталацију',
	'INSTALL_TEST'				=> 'Испробај поново',
	'INST_ERR'					=> 'Грешка при инсталацији',
	'INST_ERR_DB_CONNECT'		=> 'Не могу да се повежем на базу, погледајте поруку о грешци испод.',
	'INST_ERR_DB_FORUM_PATH'	=> 'Одабрана датотека базе података је у фасцикли вашег форума. Ову датотеку би требало да поставите на-месту које нема приступ мрежи.',
	'INST_ERR_DB_INVALID_PREFIX'=> 'Префикс који сте унели није ваљан. Мора да почиње са словом и мора да садржи само слова, бројеве и цртице за подвлачење.',
	'INST_ERR_DB_NO_ERROR'		=> 'Није дата порука о грешци.',
	'INST_ERR_DB_NO_MYSQLI'		=> 'Верзија MySQL инсталирана на овом рачунару је неускладљива са избором “MySQL са MySQLi Екстензијом” који сте одабрали. Молимо вас да покушате са “MySQL” уместо тога.',
	'INST_ERR_DB_NO_SQLITE'		=> 'Верзија SQLite екстензије коју имате инсталирану је престара, и мора бити надограђена најмање на верзију 2.8.2.',
	'INST_ERR_DB_NO_ORACLE'		=> 'Верзија Oracle инсталирана на овом рачунару захтева од вас да подесите <var>NLS_CHARACTERSET</var> параметар у <var>UTF8</var>. Или надоградите вашу инсталацију на 9.2+ или промените параметар.',
	'INST_ERR_DB_NO_FIREBIRD'	=> 'Верзија Firebird инсталирана на овом рачунару је старија од верзије 2.1, молимо вас да надоградите на новију верзију.',
	'INST_ERR_DB_NO_FIREBIRD_PS'=> 'База коју сте изабрали за Firebird има величину стране мању од 8192, а мора бити бар 8192.',
	'INST_ERR_DB_NO_POSTGRES'	=> 'База коју сте изабрали није направљена у <var>UNICODE</var> или <var>UTF8</var> енкодингу. Покушајте инсталацију са базом у <var>UNICODE</var> или <var>UTF8</var> енкодингу.',
	'INST_ERR_DB_NO_NAME'		=> 'Нисте одредили име базе.',
	'INST_ERR_EMAIL_INVALID'	=> 'Адреса e-mail коју сте унели је неисправна.',
	'INST_ERR_EMAIL_MISMATCH'	=> 'Адресе e-mail које сте унели се не поклапају.',
	'INST_ERR_FATAL'			=> 'Фатална инсталациона грешка',
	'INST_ERR_FATAL_DB'			=> 'Појавила се фатална и непоправљива грешка у бази. Ово може бити зато што изабрани корисник нема одговарајуће дозволе за <code>CREATE TABLES</code> или <code>INSERT</code> података, итд. Ближи подаци могу бити дати испод. Молимо вас да се повежете са вашим провајдером у првом реду или форумима подршке phpBB за даљу помоћ.',
	'INST_ERR_FTP_PATH'			=> 'Не могу да променим у дату фасциклу, молимо вас да проверите путању.',
	'INST_ERR_FTP_LOGIN'		=> 'Не могу да се пријавим на FTP сервер, проверите ваше корисничко име и лозинку.',
	'INST_ERR_MISSING_DATA'		=> 'Морате попунити сва поља у овом блоку.',
	'INST_ERR_NO_DB'			=> 'Не могу да учитам PHP модул за изабрани тип базе.',
	'INST_ERR_PASSWORD_MISMATCH'	=> 'Лозинке које сте унели се не поклапају.',
	'INST_ERR_PASSWORD_TOO_LONG'	=> 'Лозинка коју сте унели је предугачка. Највећа дужина је 30 знакова.',
	'INST_ERR_PASSWORD_TOO_SHORT'	=> 'Лозинка коју сте унели је прекратка. Најмања дужина је 6 знакова.',
	'INST_ERR_PREFIX'			=> 'Табеле са изабраним префиксом већ постоје, молимо вас да изаберете други.',
	'INST_ERR_PREFIX_INVALID'	=> 'Префикс табеле који сте изабрали је неисправан за вашу базу. Молимо вас да покушате са неким другим, уклањајући недозвољене знакове као што је хифен.',
	'INST_ERR_PREFIX_TOO_LONG'	=> 'Префикс табеле који сте изабрали је предугачак. Највећа дужина је %d знакова.',
	'INST_ERR_USER_TOO_LONG'	=> 'Корисничко име које сте унели је предугачко. Највећа дужина је 20 знакова.',
	'INST_ERR_USER_TOO_SHORT'	=> 'Корисничко име које сте унели је прекратко. Најмања дужина је 3 знака.',
	'INVALID_PRIMARY_KEY'		=> 'Неисправан основни кључ : %s',

	'LONG_SCRIPT_EXECUTION'		=> 'Молимо знајте да ово може да потраје... Молимо вас да не заустављате скрипту.',

	// mbstring
	'MBSTRING_CHECK'						=> '<samp>mbstring</samp> провера екстензије',
	'MBSTRING_CHECK_EXPLAIN'				=> '<strong>Обавезна</strong> - <samp>mbstring</samp> је PHP екстензија која омогућује multibyte стринг функције. Неке могућности mbstring нису ускладљиве са phpBB и морају бити онемогућене.',
	'MBSTRING_FUNC_OVERLOAD'				=> 'Функција overloading',
	'MBSTRING_FUNC_OVERLOAD_EXPLAIN'		=> '<var>mbstring.func_overload</var> мора бити постављена или на 0 или на 4.',
	'MBSTRING_ENCODING_TRANSLATION'			=> 'Транспарентни енкодинг знакова',
	'MBSTRING_ENCODING_TRANSLATION_EXPLAIN'	=> '<var>mbstring.encoding_translation</var> мора бити постављен на 0.',
	'MBSTRING_HTTP_INPUT'					=> 'Пребацивање знакова HTTP улаза',
	'MBSTRING_HTTP_INPUT_EXPLAIN'			=> '<var>mbstring.http_input</var> мора бити постављено на <samp>pass</samp>.',
	'MBSTRING_HTTP_OUTPUT'					=> 'Пребацивање знакова HTTP излаза',
	'MBSTRING_HTTP_OUTPUT_EXPLAIN'			=> '<var>mbstring.http_output</var> мора бити постављено на <samp>pass</samp>.',

	'MAKE_FOLDER_WRITABLE'		=> 'Молимо проверите да ли ова фасцикла постоји и да ли је уписљива од веб сервера а онда покушајте поново:<br />»<strong>%s</strong>.',
	'MAKE_FOLDERS_WRITABLE'		=> 'Молимо проверите да ли ове фасцикле постоје и да ли су уписљиве од веб сервера а онда покушајте поново:<br />»<strong>%s</strong>.',

	'MYSQL_SCHEMA_UPDATE_REQUIRED'	=> 'Ваша MySQL шема базе за phpBB је застарела. phpBB је открио шему за MySQL 3.x/4.x, али сервер извршава на MySQL %2$s.<br /><strong>Пре него што наставите са ажурирањем, треба да надоградите шему.</strong><br /><br />Молимо вас да обратите пажњу на <a href="https://www.phpbb.com/kb/article/doesnt-have-a-default-value-errors/">Knowledge Base article about upgrading the MySQL schema</a>. Уколико будете имали сметњи, молимо користите <a href="https://www.phpbb.com/community/viewforum.php?f=46">наше форуме подршке</a>.',

	'NAMING_CONFLICT'			=> 'Сукоб имена: %s и %s су оба алиаси<br /><br />%s',
	'NEXT_STEP'					=> 'Настави следећи корак',
	'NOT_FOUND'					=> 'Не могу да пронађем',
	'NOT_UNDERSTAND'			=> 'Не могу да разумем %s #%d, табела %s (“%s”)',
	'NO_CONVERTORS'				=> 'Нема пребацивача доступних за употребу.',
	'NO_CONVERT_SPECIFIED'		=> 'Није изабран пребацивач.',
	'NO_LOCATION'				=> 'Не могу да одредим место. Ако знате да је Imagemagick инсталиран, можете одредити његово место касније у вашој админ контролној плочи',
	'NO_TABLES_FOUND'			=> 'Није пронађена ниједна табела.',

	'OVERVIEW_BODY'				=> 'Добро дошли на phpBB3!<br /><br />phpBB® је најраспрострањеније коришћен форум на свету. phpBB3 је најновија инсталација у линији пакета почев од 2000. Као и његови претходници, phpBB3 је пре-пун могућности, лак за-руковање, и са пуном подршком од phpBB Тима. phpBB3 је увелико унапређен у односу на популарни phpBB2, и даје често захтеване могућности које нису биле присутне у претходним верзијама. Надамо се да ће превазићи ваша очекивања.<br /><br />Овај инсталациони систем ће вас водити кроз инсталацију phpBB3, ажурирање прошлих верзија у најновију верзију phpBB3, као и пребацивање у phpBB3 других форумских система (укључујући phpBB2). За више података, подстичемо вас да прочитате <a href="../docs/INSTALL.html">водич кроз инсталацију</a>.<br /><br />За читање phpBB3 лиценце или учење о добијању подршке и нашем ставу о њој, молимо одаберите одговарајуће могућности у менију са стране. За наставак, молимо одаберите одговарајући језичак изнад.',

	'PCRE_UTF_SUPPORT'				=> 'PCRE UTF-8 подршка',
	'PCRE_UTF_SUPPORT_EXPLAIN'		=> 'phpBB <strong>неће</strong> радити уколико ваша PHP инсталација није састављена са UTF-8 подршком у PCRE екстензији.',
	'PHP_GETIMAGESIZE_SUPPORT'			=> 'PHP функција getimagesize() је доступна',
	'PHP_GETIMAGESIZE_SUPPORT_EXPLAIN'	=> '<strong>Обавезно</strong> - Како би phpBB исправно радио, getimagesize функција треба да буде доступна.',
	'PHP_OPTIONAL_MODULE'			=> 'Модули по избору',
	'PHP_OPTIONAL_MODULE_EXPLAIN'	=> '<strong>По избору</strong> - Ови модули или апликације су по избору. Међутим, уколико су доступни они ће омогућити додатне могућности.',
	'PHP_SUPPORTED_DB'				=> 'Подржане базе',
	'PHP_SUPPORTED_DB_EXPLAIN'		=> '<strong>Обавезно</strong> - Морате имати подршку за бар једну ускладљиву базу у PHP. Ако нема модула база приказаних као доступних требало би да се повежете са вашим провајдером или прегледате одговарајућу PHP инсталациону документацију за савет.',
	'PHP_REGISTER_GLOBALS'			=> 'PHP поставка <var>register_globals</var> је онемогућена',
	'PHP_REGISTER_GLOBALS_EXPLAIN'	=> 'phpBB ће и даље радити уколико је ова поставка омогућена, али уколико је могуће, препоручљиво је да register_globals буде онемогућено у вашој PHP инсталацији из сигурносних разлога.',
	'PHP_SAFE_MODE'					=> 'Safe mode',
	'PHP_SETTINGS'					=> 'PHP верзија и поставке',
	'PHP_SETTINGS_EXPLAIN'			=> '<strong>Обавезно</strong> - Морате имати бар 4.3.3 верзију PHP да бисте инсталирали phpBB. Ако је <var>safe mode</var> приказано испод ваша PHP инсталација ради у том моду. Ово ће проузроковати ограничења при удаљеној администрацији и сличним могућностима.',
	'PHP_URL_FOPEN_SUPPORT'			=> 'PHP поставка <var>allow_url_fopen</var> је омогућена',
	'PHP_URL_FOPEN_SUPPORT_EXPLAIN'	=> '<strong>По избору</strong> - Ова поставка је по избору, мада неке phpBB функције као грбови ван-веб странице неће радити исправно без ње.',
	'PHP_VERSION_REQD'				=> 'PHP верзија >= 4.3.3',
	'POST_ID'						=> 'ID Поруке',
	'PREFIX_FOUND'					=> 'Скенирање ваших табела показало је исправну инсталацију користећи <strong>%s</strong> као префикс табеле.',
	'PREPROCESS_STEP'				=> 'Извршавање пред-обрадних функција/упита',
	'PRE_CONVERT_COMPLETE'			=> 'Сви кораци пред-пребацивања су успешно употпуњени. Сада можете почети поступак пребацивања. Молимо знајте да може морати да то урадите ручно и подесите неколико ствари. Након пребацивања, посебно проверите додељене дозволе, обновите ваш индекс претраге који није пребачен и такође проверите да ли су датотеке исправно копиране, на пример грбови и смајлићи.',
	'PROCESS_LAST'					=> 'Обрађујем последње поступке',

	'REFRESH_PAGE'				=> 'Освежите страницу за наставак пребацивања',
	'REFRESH_PAGE_EXPLAIN'		=> 'Ако је подешено на да, пребацивач ће освежити страницу како би наставио пребацивање по завршетку корака. Ако је ово ваше прво пребацивање у сврху испробавања и утврђивања било каквих грешака, предлажемо да изаберете Не.',
	'REQUIREMENTS_TITLE'		=> 'Ускладљивост инсталације',
	'REQUIREMENTS_EXPLAIN'		=> 'Пре почетка пуне инсталације phpBB ће извршити неке пробе на конфигурацији вашег сервера и датотекама како би осигурао да можете да инсталирате и покренете phpBB. Молимо пажљиво прочитајте резултате и немојте настављати даље док све обавезне пробе не прођу. Уколико желите да користите било коју од могућности у зависности од проби по избору, требало би да проверите да ли су и те пробе такође прошле.',
	'RETRY_WRITE'				=> 'Покушај поново уписивање конфигурације',
	'RETRY_WRITE_EXPLAIN'		=> 'Уколико желите можете променити дозволе за config.php како бисте омогућили phpBB да уписује у ту датотеку. Ако желите то да урадите можете кликнути на Покушај поново испод да пробате поново. Запамтите да вратите дозволе за config.php после phpBB инсталације.',

	'SCRIPT_PATH'				=> 'Путања скрипте',
	'SCRIPT_PATH_EXPLAIN'		=> 'Путања где је phpBB смештен у односу на назив домена, н.пр. <samp>/phpBB3</samp>.',
	'SELECT_LANG'				=> 'Изаберите језик',
	'SERVER_CONFIG'				=> 'Конфигурација сервера',
	'SEARCH_INDEX_UNCONVERTED'	=> 'Индекс претраге није пребачен',
	'SEARCH_INDEX_UNCONVERTED_EXPLAIN'	=> 'Ваш стари индекс претраге није пребачен. Претрага ће увек дати празан резултат. Да бисте направили нови индекс претраге идите на Админ Контролну Плочу, означите Одржавање и онда изаберите Индекс претраге из подменија.',
	'SOFTWARE'					=> 'Програм форума',
	'SPECIFY_OPTIONS'			=> 'Избор поставки пребацивања',
	'STAGE_ADMINISTRATOR'		=> 'Појединости администратора',
	'STAGE_ADVANCED'			=> 'Напредне поставке',
	'STAGE_ADVANCED_EXPLAIN'	=> 'Поставке на овој страници су неопходне да се подесе само уколико знате да вам је потребно нешто другачије од задатог. Ако нисте сигурни, само продужите на следећу страницу, пошто ове поставке можете мењати из Админ Контролне Плоче касније.',
	'STAGE_CONFIG_FILE'			=> 'Конфигурациона датотека',
	'STAGE_CREATE_TABLE'		=> 'Прављење табела базе',
	'STAGE_CREATE_TABLE_EXPLAIN'	=> 'Табеле које користи phpBB 3.0 су направљене и попуњене са неким почетним подацима. Наставите са следећим кораком како бисте завршили инсталацију phpBB.',
	'STAGE_DATABASE'			=> 'Поставке базе',
	'STAGE_FINAL'				=> 'Завршни корак',
	'STAGE_INTRO'				=> 'Увод',
	'STAGE_IN_PROGRESS'			=> 'Пребацивање је у току',
	'STAGE_REQUIREMENTS'		=> 'Технички услови',
	'STAGE_SETTINGS'			=> 'Поставке',
	'STARTING_CONVERT'			=> 'Почињем поступак пребацивања',
	'STEP_PERCENT_COMPLETED'	=> 'Корак <strong>%d</strong> од <strong>%d</strong>',
	'SUB_INTRO'					=> 'Увод',
	'SUB_LICENSE'				=> 'Лиценца',
	'SUB_SUPPORT'				=> 'Подршка',
	'SUCCESSFUL_CONNECT'		=> 'Успешно повезивање',
	'SUPPORT_BODY'				=> 'Пуна подршка ће бити пружена за тренутну стабилну верзију phpBB3, без наплате. Ово укључује:</p><ul><li>инсталацију</li><li>конфигурацију</li><li>техничка питања</li><li>сметње повезане са могућим кваровима у овом програму</li><li>ажурирање из Release Candidate (RC) верзија у најновију стабилну верзију</li><li>пребацивање phpBB 2.0.x у phpBB3</li><li>пребацивање других форумских програма у phpBB3 (молимо погледајте <a href="https://www.phpbb.com/community/viewforum.php?f=65">Convertors Forum</a>)</li></ul><p>Подстичемо кориснике који још увек користе пробне односно бета верзије phpBB3 да замене њихове инсталације са свежом копијом најновије верзије.</p><h2>MODs / Styles</h2><p>За питања повезана са MODs, молимо пишите у одговарајући <a href="https://www.phpbb.com/community/viewforum.php?f=81">Modifications Forum</a>.<br />За питања повезана са стиловима, предлошцима и комплетима слика, молимо пишите у одговарајући <a href="https://www.phpbb.com/community/viewforum.php?f=80">Styles Forum</a>.<br /><br />Уколико је ваше питање у вези са одређеним пакетом, молимо пишите непосредно у тему посвећену пакету.</p><h2>Obtaining Support</h2><p><a href="https://www.phpbb.com/community/viewtopic.php?f=14&amp;t=571070">The phpBB Welcome Package</a><br /><a href="https://www.phpbb.com/support/">Support Section</a><br /><a href="https://www.phpbb.com/support/documentation/3.0/quickstart/">Quick Start Guide</a><br /><br />Како бисте се осигурали да увек имате најновије вести и ажурирања програма, зашто се не би <a href="https://www.phpbb.com/support/">пријавили на нашу мејлинг листу</a>?<br /><br />',
	'SYNC_FORUMS'				=> 'Почињем синхронизацију форума',
	'SYNC_POST_COUNT'			=> 'Синхронизовање post_counts',
	'SYNC_POST_COUNT_ID'		=> 'Синхронизовање post_counts од <var>уноса</var> %1$s до %2$s.',
	'SYNC_TOPICS'				=> 'Почињем синхронизацију тема',
	'SYNC_TOPIC_ID'				=> 'Синхронизација тема од <var>topic_id</var> %1$s до %2$s.',

	'TABLES_MISSING'			=> 'Не могу да пронађем ове табеле<br />» <strong>%s</strong>.',
	'TABLE_PREFIX'				=> 'Префикс за табеле у бази',
	'TABLE_PREFIX_EXPLAIN'		=> 'Префикс мора да почиње са словом и мора да садржи само слова, бројеве и цртице за подвлачење.',
	'TABLE_PREFIX_SAME'			=> 'Префикс табеле треба да буде онај који се користи у програму који желите да пребаците.<br />» Префикс табеле је био %s.',
	'TESTS_PASSED'				=> 'Пробе успешне',
	'TESTS_FAILED'				=> 'Пробе неуспешне',

	'UNABLE_WRITE_LOCK'			=> 'Не могу да напишем lock датотеку.',
	'UNAVAILABLE'				=> 'Недоступно',
	'UNWRITABLE'				=> 'Неуписљиво',
	'UPDATE_TOPICS_POSTED'		=> 'Извођење податка о послатим темама',
	'UPDATE_TOPICS_POSTED_ERR'	=> 'Дошло је до грешке приликом извођења податка о послатим темама. Можете поново покушати овај корак у АКП после завршетка поступка пребацивања.',
	'VERIFY_OPTIONS'			=> 'Провера поставки пребацивања',
	'VERSION'					=> 'Верзија',

	'WELCOME_INSTALL'			=> 'Добро дошли на phpBB3 Инсталацију',
	'WRITABLE'					=> 'Уписљиво',
));

// Updater
$lang = array_merge($lang, array(
	'ALL_FILES_UP_TO_DATE'		=> 'Све датотеке су ажуриране у најновију верзију phpBB. Требало би да се сада <a href="../ucp.php?mode=login">пријавите на ваш форум</a> и проверите да ли све лепо ради. Немојте заборавити да обришете, преименујете или померите вашу install фасциклу! Молимо пошаљите нам ажуриране податке о вашем серверу и конфигурацијама форума преко <a href="../ucp.php?mode=login&amp;redirect=adm/index.php%3Fi=send_statistics%26mode=send_statistics">Слање статистика</a> модула у вашој АКП.',
	'ARCHIVE_FILE'				=> 'Изворна датотека у архиви',

	'BACK'				=> 'Назад',
	'BINARY_FILE'		=> 'Бинарна датотека',
	'BOT'				=> 'Паук/Робот',

	'CHANGE_CLEAN_NAMES'			=> 'Начин коришћен да се провери да корисничко име није коришћено од вишеструких корисника је промењен. Има неколико корисника који имају исто име када се пореде на нов начин. Морате да обришете или преименујете ове кориснике како бисте се осигурали да је свако име коришћено само од једног корисника пре него што могнете наставити.',
	'CHECK_FILES'					=> 'Провери датотеке',
	'CHECK_FILES_AGAIN'				=> 'Провери датотеке поново',
	'CHECK_FILES_EXPLAIN'			=> 'У следећем кораку све датотеке ће бити проверене у односу на ажурне датотеке - ово може мало потрајати уколико се провера датотека ради први пут.',
	'CHECK_FILES_UP_TO_DATE'		=> 'По вашој бази ваша верзија је ажурна. Можда ћете желети да наставите са провером датотека како бисте били сигурни да су све датотеке ажурне са најновијом верзијом phpBB.',
	'CHECK_UPDATE_DATABASE'			=> 'Настави поступак ажурирања',
	'COLLECTED_INFORMATION'			=> 'Подаци о датотеци',
	'COLLECTED_INFORMATION_EXPLAIN'	=> 'Списак испод показује податке о датотекама које треба да се ажурирају. Молимо вас да прочитате податке испред сваког статусног блока како бисте видели шта они значе и шта треба да урадите за успешно извођење ажурирања.',
	'COLLECTING_FILE_DIFFS'			=> 'Сакупљам разлике у датотекама',
	'COMPLETE_LOGIN_TO_BOARD'		=> 'Сада би требало <a href="../ucp.php?mode=login">да се пријавите на ваш форум</a> и проверите да ли све лепо ради. Не заборавите да обришете, преименујете или померите install фасциклу!',
	'CONTINUE_UPDATE_NOW'			=> 'Наставите поступак ажурирања сада',		// Shown within the database update script at the end if called from the updater
	'CONTINUE_UPDATE'				=> 'Наставите ажурирање сада',					// Shown after file upload to indicate the update process is not yet finished
	'CURRENT_FILE'					=> 'Почетак Сукоба - Код Изворне датотеке пре ажурирања',
	'CURRENT_VERSION'				=> 'Тренутна верзија',

	'DATABASE_TYPE'						=> 'Тип базе',
	'DATABASE_UPDATE_INFO_OLD'			=> 'Датотека за ажурирање базе у install фасцикли је застарела. Молимо проверите да ли сте додали исправну верзију датотеке.',
	'DELETE_USER_REMOVE'				=> 'Обриши корисника и уклони поруке',
	'DELETE_USER_RETAIN'				=> 'Обриши корисника али задржи поруке',
	'DESTINATION'						=> 'Одредишна датотека',
	'DIFF_INLINE'						=> 'Линијски',
	'DIFF_RAW'							=> 'Raw unified diff',
	'DIFF_SEP_EXPLAIN'					=> 'Кодови коришћени унутар ажурне/нове датотеке',
	'DIFF_SIDE_BY_SIDE'					=> 'Упоредо',
	'DIFF_UNIFIED'						=> 'Unified diff',
	'DO_NOT_UPDATE'						=> 'Немој да ажурираш ову датотеку',
	'DONE'								=> 'Готово',
	'DOWNLOAD'							=> 'Преузми',
	'DOWNLOAD_AS'						=> 'Преузми као',
	'DOWNLOAD_UPDATE_METHOD_BUTTON'		=> 'Преузми архиву измењених датотека (препоручљиво)',
	'DOWNLOAD_CONFLICTS'				=> 'Преузми сукобе за ову датотеку',
	'DOWNLOAD_CONFLICTS_EXPLAIN'		=> 'Претрага за &lt;&lt;&lt; сукоба',
	'DOWNLOAD_UPDATE_METHOD'			=> 'Преузми архиву измењених датотека',
	'DOWNLOAD_UPDATE_METHOD_EXPLAIN'	=> 'Једном преузету требало би да распакујете архиву. Пронаћи ћете у њој измењене датотеке које треба да додате у вашу phpBB root фасциклу. Молимо вас да онда додате датотеке на њихова одговарајућа места. Након што сте додали све датотеке, молимо вас да проверите датотеке поново кликом на дугме испод.',

	'ERROR'			=> 'Грешка',
	'EDIT_USERNAME'	=> 'Учитај корисничко име',

	'FILE_ALREADY_UP_TO_DATE'		=> 'Датотека је ажурна.',
	'FILE_DIFF_NOT_ALLOWED'			=> 'Датотеку није могуће мењати.',
	'FILE_USED'						=> 'Податак коришћен из',			// Single file
	'FILES_CONFLICT'				=> 'Сукобљене датотеке',
	'FILES_CONFLICT_EXPLAIN'		=> 'Следеће датотеке су измењене и не представљају изворне датотеке из старе верзије. phpBB је утврдио да те датотеке праве сукоб уколико се покуша њихово спајање. Молимо вас да истражите сукобе и покушате да их ручно решите или наставите да ажурирате избором жељеног начина за спајање. Ако ручно решавате сукобе проверите датотеке поново након што их измените. Такође сте у могућности да изаберете жељени начин спајања за сваку датотеку. Први ће исходити датотеком где ће сукобљене линије из ваше старе датотеке бити изгубљене, док ће други довести до губљења промена из новије датотеке.',
	'FILES_MODIFIED'				=> 'Измењене датотеке',
	'FILES_MODIFIED_EXPLAIN'		=> 'Следеће датотеке су измењене и не представљају изворне датотеке из старе верзије. Ажурирана датотека ће бити спој између ваших промена и нове датотеке.',
	'FILES_NEW'						=> 'Нове датотеке',
	'FILES_NEW_EXPLAIN'				=> 'Следеће датотеке тренутно не постоје у вашој инсталацији. Ове датотеке ће бити додате вашој инсталацији.',
	'FILES_NEW_CONFLICT'			=> 'Нове сукобљене датотеке',
	'FILES_NEW_CONFLICT_EXPLAIN'	=> 'Следеће датотеке су нове унутар најновије верзије али је утврђено да већ постоји датотека са истим именом унутар истог места. Ова датотека ће бити прегажена новом датотеком.',
	'FILES_NOT_MODIFIED'			=> 'Неизмењене датотеке',
	'FILES_NOT_MODIFIED_EXPLAIN'	=> 'Следеће датотеке нису измењене и представљају изворне phpBB датотеке из верзије коју желите да ажурирате.',
	'FILES_UP_TO_DATE'				=> 'Већ ажуриране датотеке',
	'FILES_UP_TO_DATE_EXPLAIN'		=> 'Следеће датотеке су већ ажурне и нема потребе да се ажурирају.',
	'FTP_SETTINGS'					=> 'FTP поставке',
	'FTP_UPDATE_METHOD'				=> 'FTP додавање',

	'INCOMPATIBLE_UPDATE_FILES'		=> 'Ажурне датотеке нису ускладљиве са вашом инсталираном верзијом. Ваша инсталирана верзија је %1$s а ажурна датотека је за ажурирање phpBB %2$s у %3$s.',
	'INCOMPLETE_UPDATE_FILES'		=> 'Ажурне датотеке су непотпуне.',
	'INLINE_UPDATE_SUCCESSFUL'		=> 'Ажурирање базе је било успешно. Сада треба да наставите поступак ажурирања.',

	'KEEP_OLD_NAME'		=> 'Задржи корисничко име',

	'LATEST_VERSION'		=> 'Најновија верзија',
	'LINE'					=> 'Линија',
	'LINE_ADDED'			=> 'Додато',
	'LINE_MODIFIED'			=> 'Измењено',
	'LINE_REMOVED'			=> 'Уклоњено',
	'LINE_UNMODIFIED'		=> 'Непромењено',
	'LOGIN_UPDATE_EXPLAIN'	=> 'У настојању да ажурирате вашу инсталацију морате се прво пријавити.',

	'MAPPING_FILE_STRUCTURE'	=> 'Како бисте олакшали додавање овде се налазе места датотека што представља мапу ваше phpBB инсталације.',

	'MERGE_MODIFICATIONS_OPTION'	=> 'Спој измене',

	'MERGE_NO_MERGE_NEW_OPTION'	=> 'Не спајај - користи нову датотеку',
	'MERGE_NO_MERGE_MOD_OPTION'	=> 'Не спајај - користи тренутно инсталирану датотеку',
	'MERGE_MOD_FILE_OPTION'		=> 'Спој измене (уклања нови phpBB код у сукобљавајућем блоку)',
	'MERGE_NEW_FILE_OPTION'		=> 'Спој измене (уклања измењени код у сукобљавајућем блоку)',
	'MERGE_SELECT_ERROR'		=> 'Начини за спајање сукобљених датотека нису изабрани.',
	'MERGING_FILES'				=> 'Спајање разлика',
	'MERGING_FILES_EXPLAIN'		=> 'Тренутно сакупљам коначне измене датотека.<br /><br />Молимо вас да сачекате док phpBB не употпуни све поступке на измењеним датотекама.',

	'NEW_FILE'						=> 'Завршетак Сукоба',
	'NEW_USERNAME'					=> 'Ново корисничко име',
	'NO_AUTH_UPDATE'				=> 'Нисте овлашћени да ажурирате',
	'NO_ERRORS'						=> 'Нема грешака',
	'NO_UPDATE_FILES'				=> 'Не ажурирам следеће датотеке',
	'NO_UPDATE_FILES_EXPLAIN'		=> 'Следеће датотеке су нове или измењене али фасцикла у којој оне обично стоје не може бити пронађена у вашој инсталацији. Уколико овај списак садржи датотеке до других фасцикли осим language/ или styles/ онда сте можда изменили структуру фасцикли и ажурирање може бити непотпуно.',
	'NO_UPDATE_FILES_OUTDATED'		=> 'Није пронађена исправна update фасцикла, молимо вас да проверите да ли сте додали одговарајуће датотеке.<br /><br />Ваша инсталација <strong>не</strong> изгледа да је ажурна. Ажурирања су доступна за вашу верзију phpBB %1$s, молимо посетите <a href="https://www.phpbb.com/downloads/" rel="external">https://www.phpbb.com/downloads/</a> како бисте прибавили исправан пакет за ажурирање са Верзије %2$s у Верзију %3$s.',
	'NO_UPDATE_FILES_UP_TO_DATE'	=> 'Ваша верзија је ажурна. Нема потребе да покрећете алат за ажурирање. Ако желите да проверите интегритет ваших датотека проверите да ли сте додали исправне датотеке за ажурирање.',
	'NO_UPDATE_INFO'				=> 'Податак о ажурној датотеци није пронађен.',
	'NO_UPDATES_REQUIRED'			=> 'Никакво ажурирање није неопходно',
	'NO_VISIBLE_CHANGES'			=> 'Нема видљивих промена',
	'NOTICE'						=> 'Белешка',
	'NUM_CONFLICTS'					=> 'Број сукоба',
	'NUMBER_OF_FILES_COLLECTED'		=> 'Тренутне разлике из %1$d од %2$d датотека су проверене.<br />Молимо сачекајте док све датотеке буду проверене.',

	'OLD_UPDATE_FILES'		=> 'Ажурне датотеке су застареле. Нађене датотеке су за ажурирање са phpBB %1$s у phpBB %2$s али најновија верзија phpBB је %3$s.',

	'PACKAGE_UPDATES_TO'				=> 'Тренутни пакет се ажурира у верзију',
	'PERFORM_DATABASE_UPDATE'			=> 'Изврши ажурирање базе',
	'PERFORM_DATABASE_UPDATE_EXPLAIN'	=> 'Испод ћете наћи дугме за скрипту ажурирања базе. Ажурирање базе може да потраје, па вас зато молимо да не заустављате извршавање уколико изгледа да стаје. Након што се изврши ажурирање базе само следите упутства за наставак поступка ажурирања.',
	'PREVIOUS_VERSION'					=> 'Претходна верзија',
	'PROGRESS'							=> 'У току',

	'RESULT'					=> 'Резултат',
	'RUN_DATABASE_SCRIPT'		=> 'Ажурирај моју базу сад',

	'SELECT_DIFF_MODE'			=> 'Изаберите начин разлике',
	'SELECT_DOWNLOAD_FORMAT'	=> 'Изаберите облик преузимања архиве',
	'SELECT_FTP_SETTINGS'		=> 'Изаберите FTP поставке',
	'SHOW_DIFF_CONFLICT'		=> 'Прикажи разлике/сукобе',
	'SHOW_DIFF_FINAL'			=> 'Прикажи исходну датотеку',
	'SHOW_DIFF_MODIFIED'		=> 'Прикажи спојене разлике',
	'SHOW_DIFF_NEW'				=> 'Прикажи садржај датотеке',
	'SHOW_DIFF_NEW_CONFLICT'	=> 'Прикажи разлике',
	'SHOW_DIFF_NOT_MODIFIED'	=> 'Прикажи разлике',
	'SOME_QUERIES_FAILED'		=> 'Неки упити нису успели, извештај и грешке су приказани испод.',
	'SQL'						=> 'SQL',
	'SQL_FAILURE_EXPLAIN'		=> 'Ово вероватно није нешто због чега бисте требали да се бринете, ажурирање ће се наставити. Не успе ли ово да се заврши може вам требати да потражите помоћ на нашим форумима подршке. Погледајте <a href="../docs/README.html">README</a> за појединости како да добијете савет.',
	'STAGE_FILE_CHECK'			=> 'Провери датотеке',
	'STAGE_UPDATE_DB'			=> 'Ажурирај базу',
	'STAGE_UPDATE_FILES'		=> 'Ажурирај датотеке',
	'STAGE_VERSION_CHECK'		=> 'Провера верзије',
	'STATUS_CONFLICT'			=> 'Измењена датотека прави сукобе',
	'STATUS_MODIFIED'			=> 'Измењена датотека',
	'STATUS_NEW'				=> 'Нова датотека',
	'STATUS_NEW_CONFLICT'		=> 'Сукоб нове датотеке',
	'STATUS_NOT_MODIFIED'		=> 'Неизмењена датотека',
	'STATUS_UP_TO_DATE'			=> 'Већ ажурирана датотека',

	'TOGGLE_DISPLAY'			=> 'Прикажи/Сакриј списак датотека',
	'TRY_DOWNLOAD_METHOD'		=> 'Можда желите да испробате начин за преузимање измењених датотека.<br />Овај начин увек ради и такође је препоручљив пут за ажурирање.',
	'TRY_DOWNLOAD_METHOD_BUTTON'=> 'Пробај овај начин сада',

	'UPDATE_COMPLETED'				=> 'Ажурирање завршено',
	'UPDATE_DATABASE'				=> 'Ажурирај базу',
	'UPDATE_DATABASE_EXPLAIN'		=> 'У следећем кораку база ће бити ажурирана.',
	'UPDATE_DATABASE_SCHEMA'		=> 'Ажурирам шему базе',
	'UPDATE_FILES'					=> 'Ажурирај датотеке',
	'UPDATE_FILES_NOTICE'			=> 'Молимо проверите да ли сте ажурирали и датотеке вашег форума, ова датотека само надограђује вашу базу.',
	'UPDATE_INSTALLATION'			=> 'Ажурирај phpBB инсталацију',
	'UPDATE_INSTALLATION_EXPLAIN'	=> 'Са овом поставком, могуће је да ажурирате вашу phpBB инсталацију у најновију верзију.<br />Током поступка свим вашим датотекама ће бити проверен интегритет. У могућности сте да прегледате све разлике и датотеке пре ажурирања.<br /><br />Само ажурирање датотеке може се извршити на два различита начина.</p><h2>Ручно Ажурирање</h2><p>Са овим ажурирањем само преузмете ваш лични комплет промењених датотека како бисте били сигурни да не губите промене које сте можда направили. Након преузимања овог пакета треба да ручно додате датотеке на њихово исправно место у phpBB root фасцикли. Када то урадите, можете поново урадити корак провере датотека како бисте видели да ли сте померили датотеке на њихово исправно место.</p><h2>Аутоматско Ажурирање са FTP</h2><p>Овај начин је сличан првом али без потребе да преузимате промењене датотеке и додајете их сами на ваш сервер. Ово ће бити урађено уместо вас. Како бисте користили овај начин потребно је да знате појединости вашег FTP налога јер ће вам бити тражене. Када завршите бићете преусмерени поново на проверу датотека како бисте се уверили да је све исправно ажурирано.<br /><br />',
	'UPDATE_INSTRUCTIONS'			=> '

		<h1>Обавештење о издању</h1>

		<p>Молимо вас да прочитате <a href="%1$s" title="%1$s"><strong>обавештење о издању за најновију верзију</strong></a> пре него што наставите ваш поступак ажурирања, може да садржи корисне податке. Такође садржи и потпуне везе за преузимање као и запис о изменама.</p>

		<br />

		<h1>Како да ажурирате вашу инсталацију са Automatic Update Package</h1>

		<p>Препоручени начин ажурирања ваше инсталације овде приказан је ваљан само за пакет аутоматског ажурирања. Такође можете да ажурирате вашу инсталацију користећи начине приказане у INSTALL.html документу. Кораци за аутоматско надограђивање phpBB3 су:</p>

		<ul style="margin-left: 20px; font-size: 1.1em;">
			<li>Идите до <a href="https://www.phpbb.com/downloads/" title="https://www.phpbb.com/downloads/">phpBB.com downloads page</a> и преузмите "Automatic Update Package" архиву.<br /><br /></li>
			<li>Распакујете архиву.<br /><br /></li>
			<li>Додајте потпуну несабијену install фасциклу у вашу phpBB root фасциклу (где је и ваша config.php датотека).<br /><br /></li>
		</ul>

		<p>Када то додате ваш форум неће бити на вези за обичне кориснике због тога што је install фасцикла коју сте додали сада присутна.<br /><br />
		<strong><a href="%2$s" title="%2$s">Сада започните поступак ажурирања тако што ћете усмерити ваш веб прегледач на install фасциклу</a>.</strong><br />
		<br />
		Потом ћете бити вођени кроз поступак ажурирања. Бићете обавештени када се ажурирање заврши.
		</p>
	',
	'UPDATE_INSTRUCTIONS_INCOMPLETE'	=> '

		<h1>Откривено непотпуно ажурирање</h1>

		<p>phpBB је открио непотпуно аутоматско ажурирање. Молимо проверите да ли сте следили сваки корак у алату за аутоматско ажурирање. Испод ћете наћи везу поново, или идите непосредно у вашу install фасциклу.</p>
	',
	'UPDATE_METHOD'					=> 'Начин ажурирања',
	'UPDATE_METHOD_EXPLAIN'			=> 'Сада можете да изаберете жељени начин ажурирања. Користећи FTP додавање представиће вам образац у који треба да унесете појединости вашег FTP налога. Са овим начином датотеке ће бити аутоматски померене на нова места и резервне копије старих датотека ће бити направљене тако што ће се називу датотеке додати наставак .bak. Уколико изаберете да преузмете измењене датотеке можете их распаковати и касније ручно додати на њихово ваљано место.',
	'UPDATE_REQUIRES_FILE'			=> 'Ажурер захтева да следећа датотека буде присутна: %s',
	'UPDATE_SUCCESS'				=> 'Ажурирање је било успешно',
	'UPDATE_SUCCESS_EXPLAIN'		=> 'Успешно су ажуриране све датотеке. Следећи корак проверава све датотеке поново како би били сигурни да су датотеке исправно ажуриране.',
	'UPDATE_VERSION_OPTIMIZE'		=> 'Надограђујем верзију и оптимизујем табеле',
	'UPDATING_DATA'					=> 'Ажурирам податке',
	'UPDATING_TO_LATEST_STABLE'		=> 'Надограђујем базу у најновију стабилну верзију',
	'UPDATED_VERSION'				=> 'Ажурирана верзија',
	'UPGRADE_INSTRUCTIONS'			=> 'Ново издање <strong>%1$s</strong> је доступно. Молимо прочитајте <a href="%2$s" title="%2$s"><strong>издато саопштење</strong></a> како бисте научили о томе шта се нуди, и како да надоградите.',
	'UPLOAD_METHOD'					=> 'Начин додавања',

	'UPDATE_DB_SUCCESS'				=> 'Ажурирање базе је било успешно.',
	'USER_ACTIVE'					=> 'Активан корисник',
	'USER_INACTIVE'					=> 'Неактиван корисник',

	'VERSION_CHECK'					=> 'Провера верзије',
	'VERSION_CHECK_EXPLAIN'			=> 'Проверава да ли је ваша инсталација phpBB ажурна.',
	'VERSION_NOT_UP_TO_DATE'		=> 'Ваша инсталација phpBB није ажурна. Молимо вас да наставите са поступком ажурирања.',
	'VERSION_NOT_UP_TO_DATE_ACP'	=> 'Ваша инсталација phpBB није ажурна.<br />Испод је веза до обавештења, које садржи више података као и упутства како да изведете ажурирање.',
	'VERSION_NOT_UP_TO_DATE_TITLE'	=> 'Ваша phpBB инсталација није ажурна.',
	'VERSION_UP_TO_DATE'			=> 'Ваша phpBB инсталација је ажурна. Иако тренутно нема доступних измена, можете да наставите у настојању да изведете проверу ваљаности датотека.',
	'VERSION_UP_TO_DATE_ACP'		=> 'Ваша phpBB инсталација је ажурна. Тренутно нема доступних измена.',
	'VIEWING_FILE_CONTENTS'			=> 'Прегледање садржаја датотека',
	'VIEWING_FILE_DIFF'				=> 'Прегледање разлика датотека',

	'WRONG_INFO_FILE_FORMAT'	=> 'Погрешан облик информационе датотеке',
));

// Default database schema entries...
$lang = array_merge($lang, array(
	'CONFIG_BOARD_EMAIL_SIG'		=> 'Хвала, Управа',
	'CONFIG_SITE_DESC'				=> 'Кратак текст за опис вашег форума',
	'CONFIG_SITENAME'				=> 'vasdomen.com',

	'DEFAULT_INSTALL_POST'			=> 'Ово је пробна порука у вашој phpBB3 инсталацији. Изгледа да све ради. Можете обрисати ову поруку уколико то желите и наставити са подешавањима вашег форума. Током поступка инсталације вашој првој категорији и вашем првом форуму су додељени одговарајући комплети дозвола за посебне корисничке групе администратора, робота, општих уредника, госта, регистрованих корисника и регистрованих COPPA корисника. Уколико такође изаберете да обришете вашу прву категорију и ваш први форум, немојте заборавити да доделите дозволе свим тим корисничким групама за све нове категорије и форуме које направите. Препоручљиво је да преименујете вашу прву категорију и ваш први форум и копирате дозволе из њих док правите нове категорије и форуме. Пријатно!',

	'FORUMS_FIRST_CATEGORY'			=> 'Моја прва категорија',
	'FORUMS_TEST_FORUM_DESC'		=> 'Опис вашег првог форума.',
	'FORUMS_TEST_FORUM_TITLE'		=> 'Мој први форум',

	'RANKS_SITE_ADMIN_TITLE'		=> 'Админ Веб странице',
	'REPORT_WAREZ'					=> 'Порука садржи везе ка незаконитом или пиратском програму.',
	'REPORT_SPAM'					=> 'Пријављена порука има само сврху да рекламира неку веб страницу или неки производ.',
	'REPORT_OFF_TOPIC'				=> 'Пријављена порука је о промашеној теми.',
	'REPORT_OTHER'					=> 'Пријављена порука се не уклапа ни у једну другу категорију, молимо вас да користите поље за више података.',

	'SMILIES_ARROW'					=> 'Стрелица',
	'SMILIES_CONFUSED'				=> 'Збуњен',
	'SMILIES_COOL'					=> 'Олађен',
	'SMILIES_CRYING'				=> 'Плакање или Веома Тужан',
	'SMILIES_EMARRASSED'			=> 'Непријатно',
	'SMILIES_EVIL'					=> 'Зао или Веома Бесан',
	'SMILIES_EXCLAMATION'			=> 'Узвик',
	'SMILIES_GEEK'					=> 'Џибер',
	'SMILIES_IDEA'					=> 'Идеја',
	'SMILIES_LAUGHING'				=> 'Смех',
	'SMILIES_MAD'					=> 'Бесан',
	'SMILIES_MR_GREEN'				=> 'Госп. Зелени',
	'SMILIES_NEUTRAL'				=> 'Неутралан',
	'SMILIES_QUESTION'				=> 'Питање',
	'SMILIES_RAZZ'					=> 'Ругање',
	'SMILIES_ROLLING_EYES'			=> 'Колутање Очима',
	'SMILIES_SAD'					=> 'Тужан',
	'SMILIES_SHOCKED'				=> 'Шокиран',
	'SMILIES_SMILE'					=> 'Осмех',
	'SMILIES_SURPRISED'				=> 'Изненађен',
	'SMILIES_TWISTED_EVIL'			=> 'Скривено Зло',
	'SMILIES_UBER_GEEK'				=> 'Џибер Џибер',
	'SMILIES_VERY_HAPPY'			=> 'Веома Срећан',
	'SMILIES_WINK'					=> 'Намиг',

	'TOPICS_TOPIC_TITLE'			=> 'Добро дошли на phpBB3',
));

?>