/* Copyright (c) 1997-2015
   Ewgenij Gawrilow, Michael Joswig (Technische Universitaet Berlin, Germany)
   http://www.polymake.org

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version: http://www.gnu.org/licenses/gpl.txt.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
--------------------------------------------------------------------------------
*/

#include "polymake/client.h"
#include "polymake/group/orbit.h"

namespace polymake { namespace group { 


UserFunctionTemplate4perl("# @category Utilities\n"
                         "# The image of an object //O// under a group element //g//."
                         "# @param Any g Group element"
                         "# @param Object O"
			 "# @tparam action_type one of: [[on_container]], [[on_elements]], [[on_rows]], [[on_cols]]"
                         "# @return Object",
                         "action<action_type=on_container>(*, *)");

UserFunctionTemplate4perl("# @category Utilities\n"
                         "# The image of an object //O// under the inverse of a"
                         "# permutation //p//."
                         "# @param Array<Int> p permutation"
                         "# @param Object O"
			 "# @tparam action_type one of: [[on_container]], [[on_elements]], [[on_rows]], [[on_cols]]"
                         "# @return Object",
                         "action_inv<action_type=on_container>(Array<Int>, *)");

UserFunctionTemplate4perl("# @category Orbits\n"
                         "# The orbit of an object //O// under a group generated by //G//."
                         "# @param Array G Group generators"
                         "# @param Object O"
			 "# @tparam action_type one of: [[on_container]], [[on_elements]], [[on_rows]], [[on_cols]]"
                         "# @return Set<Object>",
                         "orbit<action_type=on_container>(Array, *)");

InsertEmbeddedRule("# @category Orbits\n"
                  "# The orbit of an container //C// under a group//G//.\n"
                  "# @param Group G\n"
                  "# @param Any C\n"
                  "# @return Set<container>\n"
                   "user_function orbit<action_type=on_container>(Group, $) {\n"
                   "   orbit<action_type>($_[0]->GENERATORS, $_[1]);\n"
                   "}\n");
    /*
UserFunctionTemplate4perl("# @category Orbits\n"
                  "# The orbit of a vector //V// under a group generated by //G//."
                  "# @param Array<Matrix<Rational>> G Generators of the group"
                  "# @param Vector V"
                  "# @return Set",
                  (&orbit<Matrix<Rational>, Vector<Rational> >), "orbit(Array<Matrix>, Vector)");
    */
} } // end namespaces
