IF(Python_EXECUTABLE)
  execute_process(
    COMMAND "${Python_EXECUTABLE}" -c "import sphinx; print(sphinx.__version__)"
    RESULT_VARIABLE SPHINX_NOT_FOUND
    OUTPUT_VARIABLE VERSION_STRING
    ERROR_QUIET
    OUTPUT_STRIP_TRAILING_WHITESPACE  
  )
  if (SPHINX_NOT_FOUND)
    set(SPHINX_FOUND FALSE)
  else (SPHINX_NOT_FOUND)
    set(SPHINX_FOUND TRUE)
    set(SPHINX_VERSION ${VERSION_STRING})
  endif (SPHINX_NOT_FOUND)
ENDIF(Python_EXECUTABLE)

if (SPHINX_FOUND)
  message(STATUS "Sphinx version: " ${SPHINX_VERSION})
else (SPHINX_FOUND)
  if (Sphinx_FIND_REQUIRED)
    message (FATAL_ERROR "Could not import sphinx in " ${Python_EXECUTABLE}
             " make it available or disable documentation with -DDISABLE_DOCUMENTATION")
  endif (Sphinx_FIND_REQUIRED)
endif (SPHINX_FOUND)

