from __future__ import print_function
from __future__ import unicode_literals

import os
import sys

ROOT = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

def open_include(fn):
    """
    Opens the file in the include directory named `fn` for writing. Writes a
    standard header to the file.
    """

    f = open(os.path.join(ROOT, "include", fn), "w")

    f.write("# Automatically generated by {}\n".format(os.path.basename(sys.argv[0])))
    f.write("# Do not edit!\n")
    f.write("\n")

    return f
