# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AddressResponse(_serialization.Model):
    """Describes main public IP address and any extra virtual IPs.

    :ivar service_ip_address: Main public virtual IP.
    :vartype service_ip_address: str
    :ivar internal_ip_address: Virtual Network internal IP address of the App Service Environment
     if it is in internal load-balancing mode.
    :vartype internal_ip_address: str
    :ivar outbound_ip_addresses: IP addresses appearing on outbound connections.
    :vartype outbound_ip_addresses: list[str]
    :ivar vip_mappings: Additional virtual IPs.
    :vartype vip_mappings: list[~azure.mgmt.web.v2016_09_01.models.VirtualIPMapping]
    """

    _attribute_map = {
        "service_ip_address": {"key": "serviceIpAddress", "type": "str"},
        "internal_ip_address": {"key": "internalIpAddress", "type": "str"},
        "outbound_ip_addresses": {"key": "outboundIpAddresses", "type": "[str]"},
        "vip_mappings": {"key": "vipMappings", "type": "[VirtualIPMapping]"},
    }

    def __init__(
        self,
        *,
        service_ip_address: Optional[str] = None,
        internal_ip_address: Optional[str] = None,
        outbound_ip_addresses: Optional[List[str]] = None,
        vip_mappings: Optional[List["_models.VirtualIPMapping"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_ip_address: Main public virtual IP.
        :paramtype service_ip_address: str
        :keyword internal_ip_address: Virtual Network internal IP address of the App Service
         Environment if it is in internal load-balancing mode.
        :paramtype internal_ip_address: str
        :keyword outbound_ip_addresses: IP addresses appearing on outbound connections.
        :paramtype outbound_ip_addresses: list[str]
        :keyword vip_mappings: Additional virtual IPs.
        :paramtype vip_mappings: list[~azure.mgmt.web.v2016_09_01.models.VirtualIPMapping]
        """
        super().__init__(**kwargs)
        self.service_ip_address = service_ip_address
        self.internal_ip_address = internal_ip_address
        self.outbound_ip_addresses = outbound_ip_addresses
        self.vip_mappings = vip_mappings


class ApiDefinitionInfo(_serialization.Model):
    """Information about the formal API definition for the app.

    :ivar url: The URL of the API definition.
    :vartype url: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword url: The URL of the API definition.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.url = url


class AppServiceEnvironmentCollection(_serialization.Model):
    """Collection of App Service Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_09_01.models.AppServiceEnvironmentResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceEnvironmentResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppServiceEnvironmentResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_09_01.models.AppServiceEnvironmentResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProxyOnlyResource(_serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.type = None


class AppServiceEnvironmentPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a app service environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of the App Service Environment.
    :vartype name_properties_name: str
    :ivar location: Location of the App Service Environment, e.g. "West US".
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2016_09_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Known values are: "Preparing",
     "Ready", "Scaling", and "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentStatus
    :ivar vnet_name: Name of the Virtual Network for the App Service Environment.
    :vartype vnet_name: str
    :ivar vnet_resource_group_name: Resource group of the Virtual Network.
    :vartype vnet_resource_group_name: str
    :ivar vnet_subnet_name: Subnet of the Virtual Network.
    :vartype vnet_subnet_name: str
    :ivar virtual_network: Description of the Virtual Network.
    :vartype virtual_network: ~azure.mgmt.web.v2016_09_01.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Known values are: "None", "Web", and
     "Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2016_09_01.models.InternalLoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar worker_pools: Description of worker pools with worker size IDs, VM sizes, and number of
     workers in each pool.
    :vartype worker_pools: list[~azure.mgmt.web.v2016_09_01.models.WorkerPool]
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar database_edition: Edition of the metadata database for the App Service Environment, e.g.
     "Standard".
    :vartype database_edition: str
    :ivar database_service_objective: Service objective of the metadata database for the App
     Service Environment, e.g. "S0".
    :vartype database_service_objective: str
    :ivar upgrade_domains: Number of upgrade domains of the App Service Environment.
    :vartype upgrade_domains: int
    :ivar subscription_id: Subscription of the App Service Environment.
    :vartype subscription_id: str
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar last_action: Last deployment action on the App Service Environment.
    :vartype last_action: str
    :ivar last_action_result: Result of the last deployment action on the App Service Environment.
    :vartype last_action_result: str
    :ivar allowed_multi_sizes: List of comma separated strings describing which VM sizes are
     allowed for front-ends.
    :vartype allowed_multi_sizes: str
    :ivar allowed_worker_sizes: List of comma separated strings describing which VM sizes are
     allowed for workers.
    :vartype allowed_worker_sizes: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar vip_mappings: Description of IP SSL mapping for the App Service Environment.
    :vartype vip_mappings: list[~azure.mgmt.web.v2016_09_01.models.VirtualIPMapping]
    :ivar environment_capacities: Current total, used, and available worker capacities.
    :vartype environment_capacities: list[~azure.mgmt.web.v2016_09_01.models.StampCapacity]
    :ivar network_access_control_list: Access control list for controlling traffic to the App
     Service Environment.
    :vartype network_access_control_list:
     list[~azure.mgmt.web.v2016_09_01.models.NetworkAccessControlEntry]
    :ivar environment_is_healthy: True/false indicating whether the App Service Environment is
     healthy.
    :vartype environment_is_healthy: bool
    :ivar environment_status: Detailed message about with results of the last check of the App
     Service Environment.
    :vartype environment_status: str
    :ivar resource_group: Resource group of the App Service Environment.
    :vartype resource_group: str
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar default_front_end_scale_factor: Default Scale Factor for FrontEnds.
    :vartype default_front_end_scale_factor: int
    :ivar api_management_account_id: API Management Account associated with the App Service
     Environment.
    :vartype api_management_account_id: str
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar dynamic_cache_enabled: True/false indicating whether the App Service Environment is
     suspended. The environment can be suspended e.g. when the management endpoint is no longer
     available
     (most likely because NSG blocked the incoming traffic).
    :vartype dynamic_cache_enabled: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2016_09_01.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "database_edition": {"readonly": True},
        "database_service_objective": {"readonly": True},
        "upgrade_domains": {"readonly": True},
        "subscription_id": {"readonly": True},
        "last_action": {"readonly": True},
        "last_action_result": {"readonly": True},
        "allowed_multi_sizes": {"readonly": True},
        "allowed_worker_sizes": {"readonly": True},
        "maximum_number_of_machines": {"readonly": True},
        "vip_mappings": {"readonly": True},
        "environment_capacities": {"readonly": True},
        "environment_is_healthy": {"readonly": True},
        "environment_status": {"readonly": True},
        "resource_group": {"readonly": True},
        "default_front_end_scale_factor": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "location": {"key": "properties.location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "vnet_resource_group_name": {"key": "properties.vnetResourceGroupName", "type": "str"},
        "vnet_subnet_name": {"key": "properties.vnetSubnetName", "type": "str"},
        "virtual_network": {"key": "properties.virtualNetwork", "type": "VirtualNetworkProfile"},
        "internal_load_balancing_mode": {"key": "properties.internalLoadBalancingMode", "type": "str"},
        "multi_size": {"key": "properties.multiSize", "type": "str"},
        "multi_role_count": {"key": "properties.multiRoleCount", "type": "int"},
        "worker_pools": {"key": "properties.workerPools", "type": "[WorkerPool]"},
        "ipssl_address_count": {"key": "properties.ipsslAddressCount", "type": "int"},
        "database_edition": {"key": "properties.databaseEdition", "type": "str"},
        "database_service_objective": {"key": "properties.databaseServiceObjective", "type": "str"},
        "upgrade_domains": {"key": "properties.upgradeDomains", "type": "int"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
        "dns_suffix": {"key": "properties.dnsSuffix", "type": "str"},
        "last_action": {"key": "properties.lastAction", "type": "str"},
        "last_action_result": {"key": "properties.lastActionResult", "type": "str"},
        "allowed_multi_sizes": {"key": "properties.allowedMultiSizes", "type": "str"},
        "allowed_worker_sizes": {"key": "properties.allowedWorkerSizes", "type": "str"},
        "maximum_number_of_machines": {"key": "properties.maximumNumberOfMachines", "type": "int"},
        "vip_mappings": {"key": "properties.vipMappings", "type": "[VirtualIPMapping]"},
        "environment_capacities": {"key": "properties.environmentCapacities", "type": "[StampCapacity]"},
        "network_access_control_list": {
            "key": "properties.networkAccessControlList",
            "type": "[NetworkAccessControlEntry]",
        },
        "environment_is_healthy": {"key": "properties.environmentIsHealthy", "type": "bool"},
        "environment_status": {"key": "properties.environmentStatus", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "front_end_scale_factor": {"key": "properties.frontEndScaleFactor", "type": "int"},
        "default_front_end_scale_factor": {"key": "properties.defaultFrontEndScaleFactor", "type": "int"},
        "api_management_account_id": {"key": "properties.apiManagementAccountId", "type": "str"},
        "suspended": {"key": "properties.suspended", "type": "bool"},
        "dynamic_cache_enabled": {"key": "properties.dynamicCacheEnabled", "type": "bool"},
        "cluster_settings": {"key": "properties.clusterSettings", "type": "[NameValuePair]"},
        "user_whitelisted_ip_ranges": {"key": "properties.userWhitelistedIpRanges", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        location: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_resource_group_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        virtual_network: Optional["_models.VirtualNetworkProfile"] = None,
        internal_load_balancing_mode: Optional[Union[str, "_models.InternalLoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        multi_role_count: Optional[int] = None,
        worker_pools: Optional[List["_models.WorkerPool"]] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        network_access_control_list: Optional[List["_models.NetworkAccessControlEntry"]] = None,
        front_end_scale_factor: Optional[int] = None,
        api_management_account_id: Optional[str] = None,
        suspended: Optional[bool] = None,
        dynamic_cache_enabled: Optional[bool] = None,
        cluster_settings: Optional[List["_models.NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword name_properties_name: Name of the App Service Environment.
        :paramtype name_properties_name: str
        :keyword location: Location of the App Service Environment, e.g. "West US".
        :paramtype location: str
        :keyword vnet_name: Name of the Virtual Network for the App Service Environment.
        :paramtype vnet_name: str
        :keyword vnet_resource_group_name: Resource group of the Virtual Network.
        :paramtype vnet_resource_group_name: str
        :keyword vnet_subnet_name: Subnet of the Virtual Network.
        :paramtype vnet_subnet_name: str
        :keyword virtual_network: Description of the Virtual Network.
        :paramtype virtual_network: ~azure.mgmt.web.v2016_09_01.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Known values are: "None", "Web", and
         "Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2016_09_01.models.InternalLoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword multi_role_count: Number of front-end instances.
        :paramtype multi_role_count: int
        :keyword worker_pools: Description of worker pools with worker size IDs, VM sizes, and number
         of workers in each pool.
        :paramtype worker_pools: list[~azure.mgmt.web.v2016_09_01.models.WorkerPool]
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword network_access_control_list: Access control list for controlling traffic to the App
         Service Environment.
        :paramtype network_access_control_list:
         list[~azure.mgmt.web.v2016_09_01.models.NetworkAccessControlEntry]
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword api_management_account_id: API Management Account associated with the App Service
         Environment.
        :paramtype api_management_account_id: str
        :keyword suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
         otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
         management endpoint is no longer available
          (most likely because NSG blocked the incoming traffic).
        :paramtype suspended: bool
        :keyword dynamic_cache_enabled: True/false indicating whether the App Service Environment is
         suspended. The environment can be suspended e.g. when the management endpoint is no longer
         available
         (most likely because NSG blocked the incoming traffic).
        :paramtype dynamic_cache_enabled: bool
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2016_09_01.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        """
        super().__init__(kind=kind, **kwargs)
        self.name_properties_name = name_properties_name
        self.location = location
        self.provisioning_state = None
        self.status = None
        self.vnet_name = vnet_name
        self.vnet_resource_group_name = vnet_resource_group_name
        self.vnet_subnet_name = vnet_subnet_name
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = multi_role_count
        self.worker_pools = worker_pools
        self.ipssl_address_count = ipssl_address_count
        self.database_edition = None
        self.database_service_objective = None
        self.upgrade_domains = None
        self.subscription_id = None
        self.dns_suffix = dns_suffix
        self.last_action = None
        self.last_action_result = None
        self.allowed_multi_sizes = None
        self.allowed_worker_sizes = None
        self.maximum_number_of_machines = None
        self.vip_mappings = None
        self.environment_capacities = None
        self.network_access_control_list = network_access_control_list
        self.environment_is_healthy = None
        self.environment_status = None
        self.resource_group = None
        self.front_end_scale_factor = front_end_scale_factor
        self.default_front_end_scale_factor = None
        self.api_management_account_id = api_management_account_id
        self.suspended = suspended
        self.dynamic_cache_enabled = dynamic_cache_enabled
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges


class Resource(_serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self, *, location: str, kind: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.location = location
        self.type = None
        self.tags = tags


class AppServiceEnvironmentResource(Resource):  # pylint: disable=too-many-instance-attributes
    """App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar name_properties_name: Name of the App Service Environment.
    :vartype name_properties_name: str
    :ivar location_properties_location: Location of the App Service Environment, e.g. "West US".
    :vartype location_properties_location: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2016_09_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Known values are: "Preparing",
     "Ready", "Scaling", and "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentStatus
    :ivar vnet_name: Name of the Virtual Network for the App Service Environment.
    :vartype vnet_name: str
    :ivar vnet_resource_group_name: Resource group of the Virtual Network.
    :vartype vnet_resource_group_name: str
    :ivar vnet_subnet_name: Subnet of the Virtual Network.
    :vartype vnet_subnet_name: str
    :ivar virtual_network: Description of the Virtual Network.
    :vartype virtual_network: ~azure.mgmt.web.v2016_09_01.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Known values are: "None", "Web", and
     "Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2016_09_01.models.InternalLoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar worker_pools: Description of worker pools with worker size IDs, VM sizes, and number of
     workers in each pool.
    :vartype worker_pools: list[~azure.mgmt.web.v2016_09_01.models.WorkerPool]
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar database_edition: Edition of the metadata database for the App Service Environment, e.g.
     "Standard".
    :vartype database_edition: str
    :ivar database_service_objective: Service objective of the metadata database for the App
     Service Environment, e.g. "S0".
    :vartype database_service_objective: str
    :ivar upgrade_domains: Number of upgrade domains of the App Service Environment.
    :vartype upgrade_domains: int
    :ivar subscription_id: Subscription of the App Service Environment.
    :vartype subscription_id: str
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar last_action: Last deployment action on the App Service Environment.
    :vartype last_action: str
    :ivar last_action_result: Result of the last deployment action on the App Service Environment.
    :vartype last_action_result: str
    :ivar allowed_multi_sizes: List of comma separated strings describing which VM sizes are
     allowed for front-ends.
    :vartype allowed_multi_sizes: str
    :ivar allowed_worker_sizes: List of comma separated strings describing which VM sizes are
     allowed for workers.
    :vartype allowed_worker_sizes: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar vip_mappings: Description of IP SSL mapping for the App Service Environment.
    :vartype vip_mappings: list[~azure.mgmt.web.v2016_09_01.models.VirtualIPMapping]
    :ivar environment_capacities: Current total, used, and available worker capacities.
    :vartype environment_capacities: list[~azure.mgmt.web.v2016_09_01.models.StampCapacity]
    :ivar network_access_control_list: Access control list for controlling traffic to the App
     Service Environment.
    :vartype network_access_control_list:
     list[~azure.mgmt.web.v2016_09_01.models.NetworkAccessControlEntry]
    :ivar environment_is_healthy: True/false indicating whether the App Service Environment is
     healthy.
    :vartype environment_is_healthy: bool
    :ivar environment_status: Detailed message about with results of the last check of the App
     Service Environment.
    :vartype environment_status: str
    :ivar resource_group: Resource group of the App Service Environment.
    :vartype resource_group: str
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar default_front_end_scale_factor: Default Scale Factor for FrontEnds.
    :vartype default_front_end_scale_factor: int
    :ivar api_management_account_id: API Management Account associated with the App Service
     Environment.
    :vartype api_management_account_id: str
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar dynamic_cache_enabled: True/false indicating whether the App Service Environment is
     suspended. The environment can be suspended e.g. when the management endpoint is no longer
     available
     (most likely because NSG blocked the incoming traffic).
    :vartype dynamic_cache_enabled: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2016_09_01.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "database_edition": {"readonly": True},
        "database_service_objective": {"readonly": True},
        "upgrade_domains": {"readonly": True},
        "subscription_id": {"readonly": True},
        "last_action": {"readonly": True},
        "last_action_result": {"readonly": True},
        "allowed_multi_sizes": {"readonly": True},
        "allowed_worker_sizes": {"readonly": True},
        "maximum_number_of_machines": {"readonly": True},
        "vip_mappings": {"readonly": True},
        "environment_capacities": {"readonly": True},
        "environment_is_healthy": {"readonly": True},
        "environment_status": {"readonly": True},
        "resource_group": {"readonly": True},
        "default_front_end_scale_factor": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "location_properties_location": {"key": "properties.location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "vnet_resource_group_name": {"key": "properties.vnetResourceGroupName", "type": "str"},
        "vnet_subnet_name": {"key": "properties.vnetSubnetName", "type": "str"},
        "virtual_network": {"key": "properties.virtualNetwork", "type": "VirtualNetworkProfile"},
        "internal_load_balancing_mode": {"key": "properties.internalLoadBalancingMode", "type": "str"},
        "multi_size": {"key": "properties.multiSize", "type": "str"},
        "multi_role_count": {"key": "properties.multiRoleCount", "type": "int"},
        "worker_pools": {"key": "properties.workerPools", "type": "[WorkerPool]"},
        "ipssl_address_count": {"key": "properties.ipsslAddressCount", "type": "int"},
        "database_edition": {"key": "properties.databaseEdition", "type": "str"},
        "database_service_objective": {"key": "properties.databaseServiceObjective", "type": "str"},
        "upgrade_domains": {"key": "properties.upgradeDomains", "type": "int"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
        "dns_suffix": {"key": "properties.dnsSuffix", "type": "str"},
        "last_action": {"key": "properties.lastAction", "type": "str"},
        "last_action_result": {"key": "properties.lastActionResult", "type": "str"},
        "allowed_multi_sizes": {"key": "properties.allowedMultiSizes", "type": "str"},
        "allowed_worker_sizes": {"key": "properties.allowedWorkerSizes", "type": "str"},
        "maximum_number_of_machines": {"key": "properties.maximumNumberOfMachines", "type": "int"},
        "vip_mappings": {"key": "properties.vipMappings", "type": "[VirtualIPMapping]"},
        "environment_capacities": {"key": "properties.environmentCapacities", "type": "[StampCapacity]"},
        "network_access_control_list": {
            "key": "properties.networkAccessControlList",
            "type": "[NetworkAccessControlEntry]",
        },
        "environment_is_healthy": {"key": "properties.environmentIsHealthy", "type": "bool"},
        "environment_status": {"key": "properties.environmentStatus", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "front_end_scale_factor": {"key": "properties.frontEndScaleFactor", "type": "int"},
        "default_front_end_scale_factor": {"key": "properties.defaultFrontEndScaleFactor", "type": "int"},
        "api_management_account_id": {"key": "properties.apiManagementAccountId", "type": "str"},
        "suspended": {"key": "properties.suspended", "type": "bool"},
        "dynamic_cache_enabled": {"key": "properties.dynamicCacheEnabled", "type": "bool"},
        "cluster_settings": {"key": "properties.clusterSettings", "type": "[NameValuePair]"},
        "user_whitelisted_ip_ranges": {"key": "properties.userWhitelistedIpRanges", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        name_properties_name: Optional[str] = None,
        location_properties_location: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_resource_group_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        virtual_network: Optional["_models.VirtualNetworkProfile"] = None,
        internal_load_balancing_mode: Optional[Union[str, "_models.InternalLoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        multi_role_count: Optional[int] = None,
        worker_pools: Optional[List["_models.WorkerPool"]] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        network_access_control_list: Optional[List["_models.NetworkAccessControlEntry"]] = None,
        front_end_scale_factor: Optional[int] = None,
        api_management_account_id: Optional[str] = None,
        suspended: Optional[bool] = None,
        dynamic_cache_enabled: Optional[bool] = None,
        cluster_settings: Optional[List["_models.NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword name_properties_name: Name of the App Service Environment.
        :paramtype name_properties_name: str
        :keyword location_properties_location: Location of the App Service Environment, e.g. "West US".
        :paramtype location_properties_location: str
        :keyword vnet_name: Name of the Virtual Network for the App Service Environment.
        :paramtype vnet_name: str
        :keyword vnet_resource_group_name: Resource group of the Virtual Network.
        :paramtype vnet_resource_group_name: str
        :keyword vnet_subnet_name: Subnet of the Virtual Network.
        :paramtype vnet_subnet_name: str
        :keyword virtual_network: Description of the Virtual Network.
        :paramtype virtual_network: ~azure.mgmt.web.v2016_09_01.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Known values are: "None", "Web", and
         "Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2016_09_01.models.InternalLoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword multi_role_count: Number of front-end instances.
        :paramtype multi_role_count: int
        :keyword worker_pools: Description of worker pools with worker size IDs, VM sizes, and number
         of workers in each pool.
        :paramtype worker_pools: list[~azure.mgmt.web.v2016_09_01.models.WorkerPool]
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword network_access_control_list: Access control list for controlling traffic to the App
         Service Environment.
        :paramtype network_access_control_list:
         list[~azure.mgmt.web.v2016_09_01.models.NetworkAccessControlEntry]
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword api_management_account_id: API Management Account associated with the App Service
         Environment.
        :paramtype api_management_account_id: str
        :keyword suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
         otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
         management endpoint is no longer available
          (most likely because NSG blocked the incoming traffic).
        :paramtype suspended: bool
        :keyword dynamic_cache_enabled: True/false indicating whether the App Service Environment is
         suspended. The environment can be suspended e.g. when the management endpoint is no longer
         available
         (most likely because NSG blocked the incoming traffic).
        :paramtype dynamic_cache_enabled: bool
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2016_09_01.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.name_properties_name = name_properties_name
        self.location_properties_location = location_properties_location
        self.provisioning_state = None
        self.status = None
        self.vnet_name = vnet_name
        self.vnet_resource_group_name = vnet_resource_group_name
        self.vnet_subnet_name = vnet_subnet_name
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = multi_role_count
        self.worker_pools = worker_pools
        self.ipssl_address_count = ipssl_address_count
        self.database_edition = None
        self.database_service_objective = None
        self.upgrade_domains = None
        self.subscription_id = None
        self.dns_suffix = dns_suffix
        self.last_action = None
        self.last_action_result = None
        self.allowed_multi_sizes = None
        self.allowed_worker_sizes = None
        self.maximum_number_of_machines = None
        self.vip_mappings = None
        self.environment_capacities = None
        self.network_access_control_list = network_access_control_list
        self.environment_is_healthy = None
        self.environment_status = None
        self.resource_group = None
        self.front_end_scale_factor = front_end_scale_factor
        self.default_front_end_scale_factor = None
        self.api_management_account_id = api_management_account_id
        self.suspended = suspended
        self.dynamic_cache_enabled = dynamic_cache_enabled
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges


class AppServicePlan(Resource):  # pylint: disable=too-many-instance-attributes
    """App Service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Description of a SKU for a scalable resource.
    :vartype sku: ~azure.mgmt.web.v2016_09_01.models.SkuDescription
    :ivar name_properties_name: Name for the App Service plan.
    :vartype name_properties_name: str
    :ivar worker_tier_name: Target worker tier assigned to the App Service plan.
    :vartype worker_tier_name: str
    :ivar status: App Service plan status. Known values are: "Ready", "Pending", and "Creating".
    :vartype status: str or ~azure.mgmt.web.v2016_09_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :ivar admin_site_name: App Service plan administration site.
    :vartype admin_site_name: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     App Service plan.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :ivar per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :vartype per_site_scaling: bool
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :ivar is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :vartype is_spot: bool
    :ivar spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :vartype spot_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :ivar reserved: If Linux app service plan :code:`<code>true</code>`, :code:`<code>false</code>`
     otherwise.
    :vartype reserved: bool
    :ivar target_worker_count: Scaling worker count.
    :vartype target_worker_count: int
    :ivar target_worker_size_id: Scaling worker size ID.
    :vartype target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2016_09_01.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "subscription": {"readonly": True},
        "maximum_number_of_workers": {"readonly": True},
        "geo_region": {"readonly": True},
        "number_of_sites": {"readonly": True},
        "resource_group": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "SkuDescription"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "worker_tier_name": {"key": "properties.workerTierName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "admin_site_name": {"key": "properties.adminSiteName", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "maximum_number_of_workers": {"key": "properties.maximumNumberOfWorkers", "type": "int"},
        "geo_region": {"key": "properties.geoRegion", "type": "str"},
        "per_site_scaling": {"key": "properties.perSiteScaling", "type": "bool"},
        "number_of_sites": {"key": "properties.numberOfSites", "type": "int"},
        "is_spot": {"key": "properties.isSpot", "type": "bool"},
        "spot_expiration_time": {"key": "properties.spotExpirationTime", "type": "iso-8601"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "target_worker_count": {"key": "properties.targetWorkerCount", "type": "int"},
        "target_worker_size_id": {"key": "properties.targetWorkerSizeId", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.SkuDescription"] = None,
        name_properties_name: Optional[str] = None,
        worker_tier_name: Optional[str] = None,
        admin_site_name: Optional[str] = None,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        per_site_scaling: bool = False,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        reserved: bool = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Description of a SKU for a scalable resource.
        :paramtype sku: ~azure.mgmt.web.v2016_09_01.models.SkuDescription
        :keyword name_properties_name: Name for the App Service plan.
        :paramtype name_properties_name: str
        :keyword worker_tier_name: Target worker tier assigned to the App Service plan.
        :paramtype worker_tier_name: str
        :keyword admin_site_name: App Service plan administration site.
        :paramtype admin_site_name: str
        :keyword hosting_environment_profile: Specification for the App Service Environment to use for
         the App Service plan.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentProfile
        :keyword per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
         can be scaled independently.
         If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
         instances of the plan.
        :paramtype per_site_scaling: bool
        :keyword is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
        :paramtype is_spot: bool
        :keyword spot_expiration_time: The time when the server farm expires. Valid only if it is a
         spot server farm.
        :paramtype spot_expiration_time: ~datetime.datetime
        :keyword reserved: If Linux app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype reserved: bool
        :keyword target_worker_count: Scaling worker count.
        :paramtype target_worker_count: int
        :keyword target_worker_size_id: Scaling worker size ID.
        :paramtype target_worker_size_id: int
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.name_properties_name = name_properties_name
        self.worker_tier_name = worker_tier_name
        self.status = None
        self.subscription = None
        self.admin_site_name = admin_site_name
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = per_site_scaling
        self.number_of_sites = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.resource_group = None
        self.reserved = reserved
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state = None


class AppServicePlanCollection(_serialization.Model):
    """Collection of App Service plans.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_09_01.models.AppServicePlan]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServicePlan]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AppServicePlan"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_09_01.models.AppServicePlan]
        :keyword next_link: Link to next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AppServicePlanPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a app service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name for the App Service plan.
    :vartype name_properties_name: str
    :ivar worker_tier_name: Target worker tier assigned to the App Service plan.
    :vartype worker_tier_name: str
    :ivar status: App Service plan status. Known values are: "Ready", "Pending", and "Creating".
    :vartype status: str or ~azure.mgmt.web.v2016_09_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :ivar admin_site_name: App Service plan administration site.
    :vartype admin_site_name: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     App Service plan.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :ivar per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :vartype per_site_scaling: bool
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :ivar is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :vartype is_spot: bool
    :ivar spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :vartype spot_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :ivar reserved: If Linux app service plan :code:`<code>true</code>`, :code:`<code>false</code>`
     otherwise.
    :vartype reserved: bool
    :ivar target_worker_count: Scaling worker count.
    :vartype target_worker_count: int
    :ivar target_worker_size_id: Scaling worker size ID.
    :vartype target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2016_09_01.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "subscription": {"readonly": True},
        "maximum_number_of_workers": {"readonly": True},
        "geo_region": {"readonly": True},
        "number_of_sites": {"readonly": True},
        "resource_group": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "worker_tier_name": {"key": "properties.workerTierName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "admin_site_name": {"key": "properties.adminSiteName", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "maximum_number_of_workers": {"key": "properties.maximumNumberOfWorkers", "type": "int"},
        "geo_region": {"key": "properties.geoRegion", "type": "str"},
        "per_site_scaling": {"key": "properties.perSiteScaling", "type": "bool"},
        "number_of_sites": {"key": "properties.numberOfSites", "type": "int"},
        "is_spot": {"key": "properties.isSpot", "type": "bool"},
        "spot_expiration_time": {"key": "properties.spotExpirationTime", "type": "iso-8601"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "target_worker_count": {"key": "properties.targetWorkerCount", "type": "int"},
        "target_worker_size_id": {"key": "properties.targetWorkerSizeId", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        worker_tier_name: Optional[str] = None,
        admin_site_name: Optional[str] = None,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        per_site_scaling: bool = False,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        reserved: bool = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword name_properties_name: Name for the App Service plan.
        :paramtype name_properties_name: str
        :keyword worker_tier_name: Target worker tier assigned to the App Service plan.
        :paramtype worker_tier_name: str
        :keyword admin_site_name: App Service plan administration site.
        :paramtype admin_site_name: str
        :keyword hosting_environment_profile: Specification for the App Service Environment to use for
         the App Service plan.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentProfile
        :keyword per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
         can be scaled independently.
         If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
         instances of the plan.
        :paramtype per_site_scaling: bool
        :keyword is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
        :paramtype is_spot: bool
        :keyword spot_expiration_time: The time when the server farm expires. Valid only if it is a
         spot server farm.
        :paramtype spot_expiration_time: ~datetime.datetime
        :keyword reserved: If Linux app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype reserved: bool
        :keyword target_worker_count: Scaling worker count.
        :paramtype target_worker_count: int
        :keyword target_worker_size_id: Scaling worker size ID.
        :paramtype target_worker_size_id: int
        """
        super().__init__(kind=kind, **kwargs)
        self.name_properties_name = name_properties_name
        self.worker_tier_name = worker_tier_name
        self.status = None
        self.subscription = None
        self.admin_site_name = admin_site_name
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = per_site_scaling
        self.number_of_sites = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.resource_group = None
        self.reserved = reserved
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state = None


class AutoHealActions(_serialization.Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :ivar action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent", and
     "CustomAction".
    :vartype action_type: str or ~azure.mgmt.web.v2016_09_01.models.AutoHealActionType
    :ivar custom_action: Custom action to be taken.
    :vartype custom_action: ~azure.mgmt.web.v2016_09_01.models.AutoHealCustomAction
    :ivar min_process_execution_time: Minimum time the process must execute
     before taking the action.
    :vartype min_process_execution_time: str
    """

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "custom_action": {"key": "customAction", "type": "AutoHealCustomAction"},
        "min_process_execution_time": {"key": "minProcessExecutionTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.AutoHealActionType"]] = None,
        custom_action: Optional["_models.AutoHealCustomAction"] = None,
        min_process_execution_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent",
         and "CustomAction".
        :paramtype action_type: str or ~azure.mgmt.web.v2016_09_01.models.AutoHealActionType
        :keyword custom_action: Custom action to be taken.
        :paramtype custom_action: ~azure.mgmt.web.v2016_09_01.models.AutoHealCustomAction
        :keyword min_process_execution_time: Minimum time the process must execute
         before taking the action.
        :paramtype min_process_execution_time: str
        """
        super().__init__(**kwargs)
        self.action_type = action_type
        self.custom_action = custom_action
        self.min_process_execution_time = min_process_execution_time


class AutoHealCustomAction(_serialization.Model):
    """Custom action to be executed
    when an auto heal rule is triggered.

    :ivar exe: Executable to be run.
    :vartype exe: str
    :ivar parameters: Parameters for the executable.
    :vartype parameters: str
    """

    _attribute_map = {
        "exe": {"key": "exe", "type": "str"},
        "parameters": {"key": "parameters", "type": "str"},
    }

    def __init__(self, *, exe: Optional[str] = None, parameters: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword exe: Executable to be run.
        :paramtype exe: str
        :keyword parameters: Parameters for the executable.
        :paramtype parameters: str
        """
        super().__init__(**kwargs)
        self.exe = exe
        self.parameters = parameters


class AutoHealRules(_serialization.Model):
    """Rules that can be defined for auto-heal.

    :ivar triggers: Conditions that describe when to execute the auto-heal actions.
    :vartype triggers: ~azure.mgmt.web.v2016_09_01.models.AutoHealTriggers
    :ivar actions: Actions to be executed when a rule is triggered.
    :vartype actions: ~azure.mgmt.web.v2016_09_01.models.AutoHealActions
    """

    _attribute_map = {
        "triggers": {"key": "triggers", "type": "AutoHealTriggers"},
        "actions": {"key": "actions", "type": "AutoHealActions"},
    }

    def __init__(
        self,
        *,
        triggers: Optional["_models.AutoHealTriggers"] = None,
        actions: Optional["_models.AutoHealActions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword triggers: Conditions that describe when to execute the auto-heal actions.
        :paramtype triggers: ~azure.mgmt.web.v2016_09_01.models.AutoHealTriggers
        :keyword actions: Actions to be executed when a rule is triggered.
        :paramtype actions: ~azure.mgmt.web.v2016_09_01.models.AutoHealActions
        """
        super().__init__(**kwargs)
        self.triggers = triggers
        self.actions = actions


class AutoHealTriggers(_serialization.Model):
    """Triggers for auto-heal.

    :ivar requests: A rule based on total requests.
    :vartype requests: ~azure.mgmt.web.v2016_09_01.models.RequestsBasedTrigger
    :ivar private_bytes_in_kb: A rule based on private bytes.
    :vartype private_bytes_in_kb: int
    :ivar status_codes: A rule based on status codes.
    :vartype status_codes: list[~azure.mgmt.web.v2016_09_01.models.StatusCodesBasedTrigger]
    :ivar slow_requests: A rule based on request execution time.
    :vartype slow_requests: ~azure.mgmt.web.v2016_09_01.models.SlowRequestsBasedTrigger
    """

    _attribute_map = {
        "requests": {"key": "requests", "type": "RequestsBasedTrigger"},
        "private_bytes_in_kb": {"key": "privateBytesInKB", "type": "int"},
        "status_codes": {"key": "statusCodes", "type": "[StatusCodesBasedTrigger]"},
        "slow_requests": {"key": "slowRequests", "type": "SlowRequestsBasedTrigger"},
    }

    def __init__(
        self,
        *,
        requests: Optional["_models.RequestsBasedTrigger"] = None,
        private_bytes_in_kb: Optional[int] = None,
        status_codes: Optional[List["_models.StatusCodesBasedTrigger"]] = None,
        slow_requests: Optional["_models.SlowRequestsBasedTrigger"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword requests: A rule based on total requests.
        :paramtype requests: ~azure.mgmt.web.v2016_09_01.models.RequestsBasedTrigger
        :keyword private_bytes_in_kb: A rule based on private bytes.
        :paramtype private_bytes_in_kb: int
        :keyword status_codes: A rule based on status codes.
        :paramtype status_codes: list[~azure.mgmt.web.v2016_09_01.models.StatusCodesBasedTrigger]
        :keyword slow_requests: A rule based on request execution time.
        :paramtype slow_requests: ~azure.mgmt.web.v2016_09_01.models.SlowRequestsBasedTrigger
        """
        super().__init__(**kwargs)
        self.requests = requests
        self.private_bytes_in_kb = private_bytes_in_kb
        self.status_codes = status_codes
        self.slow_requests = slow_requests


class Capability(_serialization.Model):
    """Describes the capabilities/features allowed for a specific SKU.

    :ivar name: Name of the SKU capability.
    :vartype name: str
    :ivar value: Value of the SKU capability.
    :vartype value: str
    :ivar reason: Reason of the SKU capability.
    :vartype reason: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, value: Optional[str] = None, reason: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the SKU capability.
        :paramtype name: str
        :keyword value: Value of the SKU capability.
        :paramtype value: str
        :keyword reason: Reason of the SKU capability.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.reason = reason


class CloningInfo(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to Azure.

    :ivar correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
     operations
     together to use the same snapshot.
    :vartype correlation_id: str
    :ivar overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
     :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from source
     app; otherwise, :code:`<code>false</code>`.
    :vartype clone_custom_host_names: bool
    :ivar clone_source_control: :code:`<code>true</code>` to clone source control from source app;
     otherwise, :code:`<code>false</code>`.
    :vartype clone_source_control: bool
    :ivar source_web_app_id: ARM resource ID of the source app. App resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots. Required.
    :vartype source_web_app_id: str
    :ivar hosting_environment: App Service Environment.
    :vartype hosting_environment: str
    :ivar app_settings_overrides: Application setting overrides for cloned app. If specified, these
     settings override the settings cloned
     from source app. Otherwise, application settings from source app are retained.
    :vartype app_settings_overrides: dict[str, str]
    :ivar configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
     source and destination app.
    :vartype configure_load_balancing: bool
    :ivar traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it
     exists. Traffic Manager resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :vartype traffic_manager_profile_id: str
    :ivar traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
     needed if Traffic Manager profile does not already exist.
    :vartype traffic_manager_profile_name: str
    :ivar ignore_quotas: :code:`<code>true</code>` if quotas should be ignored; otherwise,
     :code:`<code>false</code>`.
    :vartype ignore_quotas: bool
    """

    _validation = {
        "source_web_app_id": {"required": True},
    }

    _attribute_map = {
        "correlation_id": {"key": "correlationId", "type": "str"},
        "overwrite": {"key": "overwrite", "type": "bool"},
        "clone_custom_host_names": {"key": "cloneCustomHostNames", "type": "bool"},
        "clone_source_control": {"key": "cloneSourceControl", "type": "bool"},
        "source_web_app_id": {"key": "sourceWebAppId", "type": "str"},
        "hosting_environment": {"key": "hostingEnvironment", "type": "str"},
        "app_settings_overrides": {"key": "appSettingsOverrides", "type": "{str}"},
        "configure_load_balancing": {"key": "configureLoadBalancing", "type": "bool"},
        "traffic_manager_profile_id": {"key": "trafficManagerProfileId", "type": "str"},
        "traffic_manager_profile_name": {"key": "trafficManagerProfileName", "type": "str"},
        "ignore_quotas": {"key": "ignoreQuotas", "type": "bool"},
    }

    def __init__(
        self,
        *,
        source_web_app_id: str,
        correlation_id: Optional[str] = None,
        overwrite: Optional[bool] = None,
        clone_custom_host_names: Optional[bool] = None,
        clone_source_control: Optional[bool] = None,
        hosting_environment: Optional[str] = None,
        app_settings_overrides: Optional[Dict[str, str]] = None,
        configure_load_balancing: Optional[bool] = None,
        traffic_manager_profile_id: Optional[str] = None,
        traffic_manager_profile_name: Optional[str] = None,
        ignore_quotas: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
         operations
         together to use the same snapshot.
        :paramtype correlation_id: str
        :keyword overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
         :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from
         source app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_custom_host_names: bool
        :keyword clone_source_control: :code:`<code>true</code>` to clone source control from source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_source_control: bool
        :keyword source_web_app_id: ARM resource ID of the source app. App resource ID is of the form
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots. Required.
        :paramtype source_web_app_id: str
        :keyword hosting_environment: App Service Environment.
        :paramtype hosting_environment: str
        :keyword app_settings_overrides: Application setting overrides for cloned app. If specified,
         these settings override the settings cloned
         from source app. Otherwise, application settings from source app are retained.
        :paramtype app_settings_overrides: dict[str, str]
        :keyword configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
         source and destination app.
        :paramtype configure_load_balancing: bool
        :keyword traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if
         it exists. Traffic Manager resource ID is of the form
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
        :paramtype traffic_manager_profile_id: str
        :keyword traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
         needed if Traffic Manager profile does not already exist.
        :paramtype traffic_manager_profile_name: str
        :keyword ignore_quotas: :code:`<code>true</code>` if quotas should be ignored; otherwise,
         :code:`<code>false</code>`.
        :paramtype ignore_quotas: bool
        """
        super().__init__(**kwargs)
        self.correlation_id = correlation_id
        self.overwrite = overwrite
        self.clone_custom_host_names = clone_custom_host_names
        self.clone_source_control = clone_source_control
        self.source_web_app_id = source_web_app_id
        self.hosting_environment = hosting_environment
        self.app_settings_overrides = app_settings_overrides
        self.configure_load_balancing = configure_load_balancing
        self.traffic_manager_profile_id = traffic_manager_profile_id
        self.traffic_manager_profile_name = traffic_manager_profile_name
        self.ignore_quotas = ignore_quotas


class ConnStringInfo(_serialization.Model):
    """Database connection string information.

    :ivar name: Name of connection string.
    :vartype name: str
    :ivar connection_string: Connection string value.
    :vartype connection_string: str
    :ivar type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
     "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and "PostgreSQL".
    :vartype type: str or ~azure.mgmt.web.v2016_09_01.models.ConnectionStringType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        connection_string: Optional[str] = None,
        type: Optional[Union[str, "_models.ConnectionStringType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of connection string.
        :paramtype name: str
        :keyword connection_string: Connection string value.
        :paramtype connection_string: str
        :keyword type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
         "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and "PostgreSQL".
        :paramtype type: str or ~azure.mgmt.web.v2016_09_01.models.ConnectionStringType
        """
        super().__init__(**kwargs)
        self.name = name
        self.connection_string = connection_string
        self.type = type


class CorsSettings(_serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :ivar allowed_origins: Gets or sets the list of origins that should be allowed to make
     cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :vartype allowed_origins: list[str]
    """

    _attribute_map = {
        "allowed_origins": {"key": "allowedOrigins", "type": "[str]"},
    }

    def __init__(self, *, allowed_origins: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword allowed_origins: Gets or sets the list of origins that should be allowed to make
         cross-origin
         calls (for example: http://example.com:12345). Use "*" to allow all.
        :paramtype allowed_origins: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins


class CsmUsageQuota(_serialization.Model):
    """Usage of the quota resource.

    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: int
    :ivar limit: The resource limit.
    :vartype limit: int
    :ivar name: Quota name.
    :vartype name: ~azure.mgmt.web.v2016_09_01.models.LocalizableString
    """

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "next_reset_time": {"key": "nextResetTime", "type": "iso-8601"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "LocalizableString"},
    }

    def __init__(
        self,
        *,
        unit: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["_models.LocalizableString"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unit: Units of measurement for the quota resource.
        :paramtype unit: str
        :keyword next_reset_time: Next reset time for the resource counter.
        :paramtype next_reset_time: ~datetime.datetime
        :keyword current_value: The current value of the resource counter.
        :paramtype current_value: int
        :keyword limit: The resource limit.
        :paramtype limit: int
        :keyword name: Quota name.
        :paramtype name: ~azure.mgmt.web.v2016_09_01.models.LocalizableString
        """
        super().__init__(**kwargs)
        self.unit = unit
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class CsmUsageQuotaCollection(_serialization.Model):
    """Collection of CSM usage quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_09_01.models.CsmUsageQuota]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmUsageQuota]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CsmUsageQuota"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_09_01.models.CsmUsageQuota]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ErrorEntity(_serialization.Model):
    """Body of the error response returned from the API.

    :ivar extended_code: Type of error.
    :vartype extended_code: str
    :ivar message_template: Message template.
    :vartype message_template: str
    :ivar parameters: Parameters for the template.
    :vartype parameters: list[str]
    :ivar inner_errors: Inner errors.
    :vartype inner_errors: list[~azure.mgmt.web.v2016_09_01.models.ErrorEntity]
    :ivar code: Basic error code.
    :vartype code: str
    :ivar message: Any details of the error.
    :vartype message: str
    """

    _attribute_map = {
        "extended_code": {"key": "extendedCode", "type": "str"},
        "message_template": {"key": "messageTemplate", "type": "str"},
        "parameters": {"key": "parameters", "type": "[str]"},
        "inner_errors": {"key": "innerErrors", "type": "[ErrorEntity]"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        extended_code: Optional[str] = None,
        message_template: Optional[str] = None,
        parameters: Optional[List[str]] = None,
        inner_errors: Optional[List["_models.ErrorEntity"]] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extended_code: Type of error.
        :paramtype extended_code: str
        :keyword message_template: Message template.
        :paramtype message_template: str
        :keyword parameters: Parameters for the template.
        :paramtype parameters: list[str]
        :keyword inner_errors: Inner errors.
        :paramtype inner_errors: list[~azure.mgmt.web.v2016_09_01.models.ErrorEntity]
        :keyword code: Basic error code.
        :paramtype code: str
        :keyword message: Any details of the error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.extended_code = extended_code
        self.message_template = message_template
        self.parameters = parameters
        self.inner_errors = inner_errors
        self.code = code
        self.message = message


class Experiments(_serialization.Model):
    """Routing rules in production experiments.

    :ivar ramp_up_rules: List of ramp-up rules.
    :vartype ramp_up_rules: list[~azure.mgmt.web.v2016_09_01.models.RampUpRule]
    """

    _attribute_map = {
        "ramp_up_rules": {"key": "rampUpRules", "type": "[RampUpRule]"},
    }

    def __init__(self, *, ramp_up_rules: Optional[List["_models.RampUpRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword ramp_up_rules: List of ramp-up rules.
        :paramtype ramp_up_rules: list[~azure.mgmt.web.v2016_09_01.models.RampUpRule]
        """
        super().__init__(**kwargs)
        self.ramp_up_rules = ramp_up_rules


class HandlerMapping(_serialization.Model):
    """The IIS handler mappings used to define which handler processes HTTP requests with certain
    extension.
    For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php
    extension.

    :ivar extension: Requests with this extension will be handled using the specified FastCGI
     application.
    :vartype extension: str
    :ivar script_processor: The absolute path to the FastCGI application.
    :vartype script_processor: str
    :ivar arguments: Command-line arguments to be passed to the script processor.
    :vartype arguments: str
    """

    _attribute_map = {
        "extension": {"key": "extension", "type": "str"},
        "script_processor": {"key": "scriptProcessor", "type": "str"},
        "arguments": {"key": "arguments", "type": "str"},
    }

    def __init__(
        self,
        *,
        extension: Optional[str] = None,
        script_processor: Optional[str] = None,
        arguments: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extension: Requests with this extension will be handled using the specified FastCGI
         application.
        :paramtype extension: str
        :keyword script_processor: The absolute path to the FastCGI application.
        :paramtype script_processor: str
        :keyword arguments: Command-line arguments to be passed to the script processor.
        :paramtype arguments: str
        """
        super().__init__(**kwargs)
        self.extension = extension
        self.script_processor = script_processor
        self.arguments = arguments


class HostingEnvironmentDiagnostics(_serialization.Model):
    """Diagnostics for an App Service Environment.

    :ivar name: Name/identifier of the diagnostics.
    :vartype name: str
    :ivar diagnosics_output: Diagnostics output.
    :vartype diagnosics_output: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "diagnosics_output": {"key": "diagnosicsOutput", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, diagnosics_output: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name/identifier of the diagnostics.
        :paramtype name: str
        :keyword diagnosics_output: Diagnostics output.
        :paramtype diagnosics_output: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.diagnosics_output = diagnosics_output


class HostingEnvironmentProfile(_serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the App Service Environment.
    :vartype id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the App Service Environment.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None


class HostNameSslState(_serialization.Model):
    """SSL-enabled hostname.

    :ivar name: Hostname.
    :vartype name: str
    :ivar ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.web.v2016_09_01.models.SslState
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar to_update: Set to :code:`<code>true</code>` to update existing hostname.
    :vartype to_update: bool
    :ivar host_type: Indicates whether the hostname is a standard or repository hostname. Known
     values are: "Standard" and "Repository".
    :vartype host_type: str or ~azure.mgmt.web.v2016_09_01.models.HostType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "ssl_state": {"key": "sslState", "type": "str"},
        "virtual_ip": {"key": "virtualIP", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "to_update": {"key": "toUpdate", "type": "bool"},
        "host_type": {"key": "hostType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ssl_state: Optional[Union[str, "_models.SslState"]] = None,
        virtual_ip: Optional[str] = None,
        thumbprint: Optional[str] = None,
        to_update: Optional[bool] = None,
        host_type: Optional[Union[str, "_models.HostType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Hostname.
        :paramtype name: str
        :keyword ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.web.v2016_09_01.models.SslState
        :keyword virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
        :paramtype virtual_ip: str
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        :keyword to_update: Set to :code:`<code>true</code>` to update existing hostname.
        :paramtype to_update: bool
        :keyword host_type: Indicates whether the hostname is a standard or repository hostname. Known
         values are: "Standard" and "Repository".
        :paramtype host_type: str or ~azure.mgmt.web.v2016_09_01.models.HostType
        """
        super().__init__(**kwargs)
        self.name = name
        self.ssl_state = ssl_state
        self.virtual_ip = virtual_ip
        self.thumbprint = thumbprint
        self.to_update = to_update
        self.host_type = host_type


class HybridConnection(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_bus_namespace: The name of the Service Bus namespace.
    :vartype service_bus_namespace: str
    :ivar relay_name: The name of the Service Bus relay.
    :vartype relay_name: str
    :ivar relay_arm_uri: The ARM URI to the Service Bus relay.
    :vartype relay_arm_uri: str
    :ivar hostname: The hostname of the endpoint.
    :vartype hostname: str
    :ivar port: The port of the endpoint.
    :vartype port: int
    :ivar send_key_name: The name of the Service Bus key which has Send permissions. This is used
     to authenticate to Service Bus.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the Service Bus key. This is used to authenticate to Service
     Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :vartype send_key_value: str
    :ivar service_bus_suffix: The suffix for the service bus endpoint. By default this is
     .servicebus.windows.net.
    :vartype service_bus_suffix: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_bus_namespace": {"key": "properties.serviceBusNamespace", "type": "str"},
        "relay_name": {"key": "properties.relayName", "type": "str"},
        "relay_arm_uri": {"key": "properties.relayArmUri", "type": "str"},
        "hostname": {"key": "properties.hostname", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "send_key_name": {"key": "properties.sendKeyName", "type": "str"},
        "send_key_value": {"key": "properties.sendKeyValue", "type": "str"},
        "service_bus_suffix": {"key": "properties.serviceBusSuffix", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        service_bus_namespace: Optional[str] = None,
        relay_name: Optional[str] = None,
        relay_arm_uri: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        send_key_name: Optional[str] = None,
        send_key_value: Optional[str] = None,
        service_bus_suffix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword service_bus_namespace: The name of the Service Bus namespace.
        :paramtype service_bus_namespace: str
        :keyword relay_name: The name of the Service Bus relay.
        :paramtype relay_name: str
        :keyword relay_arm_uri: The ARM URI to the Service Bus relay.
        :paramtype relay_arm_uri: str
        :keyword hostname: The hostname of the endpoint.
        :paramtype hostname: str
        :keyword port: The port of the endpoint.
        :paramtype port: int
        :keyword send_key_name: The name of the Service Bus key which has Send permissions. This is
         used to authenticate to Service Bus.
        :paramtype send_key_name: str
        :keyword send_key_value: The value of the Service Bus key. This is used to authenticate to
         Service Bus. In ARM this key will not be returned
         normally, use the POST /listKeys API instead.
        :paramtype send_key_value: str
        :keyword service_bus_suffix: The suffix for the service bus endpoint. By default this is
         .servicebus.windows.net.
        :paramtype service_bus_suffix: str
        """
        super().__init__(kind=kind, **kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.relay_name = relay_name
        self.relay_arm_uri = relay_arm_uri
        self.hostname = hostname
        self.port = port
        self.send_key_name = send_key_name
        self.send_key_value = send_key_value
        self.service_bus_suffix = service_bus_suffix


class HybridConnectionCollection(_serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_09_01.models.HybridConnection]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HybridConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.HybridConnection"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_09_01.models.HybridConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "send_key_name": {"readonly": True},
        "send_key_value": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "send_key_name": {"key": "properties.sendKeyName", "type": "str"},
        "send_key_value": {"key": "properties.sendKeyValue", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.send_key_name = None
        self.send_key_value = None


class HybridConnectionLimits(ProxyOnlyResource):
    """Hybrid Connection limits contract. This is used to return the plan limits of Hybrid
    Connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar current: The current number of Hybrid Connections.
    :vartype current: int
    :ivar maximum: The maximum number of Hybrid Connections allowed.
    :vartype maximum: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "current": {"readonly": True},
        "maximum": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "current": {"key": "properties.current", "type": "int"},
        "maximum": {"key": "properties.maximum", "type": "int"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.current = None
        self.maximum = None


class IpSecurityRestriction(_serialization.Model):
    """IP security restriction on an app.

    All required parameters must be populated in order to send to Azure.

    :ivar ip_address: IP address the security restriction is valid for. Required.
    :vartype ip_address: str
    :ivar subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
    :vartype subnet_mask: str
    """

    _validation = {
        "ip_address": {"required": True},
    }

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "subnet_mask": {"key": "subnetMask", "type": "str"},
    }

    def __init__(self, *, ip_address: str, subnet_mask: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_address: IP address the security restriction is valid for. Required.
        :paramtype ip_address: str
        :keyword subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
        :paramtype subnet_mask: str
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.subnet_mask = subnet_mask


class LocalizableString(_serialization.Model):
    """Localizable string object containing the name and a localized value.

    :ivar value: Non-localized name.
    :vartype value: str
    :ivar localized_value: Localized name.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Non-localized name.
        :paramtype value: str
        :keyword localized_value: Localized name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of managed service identity. "SystemAssigned"
    :vartype type: str or ~azure.mgmt.web.v2016_09_01.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    """

    _validation = {
        "tenant_id": {"readonly": True},
        "principal_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity. "SystemAssigned"
        :paramtype type: str or ~azure.mgmt.web.v2016_09_01.models.ManagedServiceIdentityType
        """
        super().__init__(**kwargs)
        self.type = type
        self.tenant_id = None
        self.principal_id = None


class MetricAvailabilily(_serialization.Model):
    """Metric availability and retention.

    :ivar time_grain: Time grain.
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "retention": {"key": "retention", "type": "str"},
    }

    def __init__(self, *, time_grain: Optional[str] = None, retention: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword time_grain: Time grain.
        :paramtype time_grain: str
        :keyword retention: Retention period for the current time grain.
        :paramtype retention: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention


class MetricDefinition(ProxyOnlyResource):
    """Metadata for a metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of the metric.
    :vartype name_properties_name: str
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities: list[~azure.mgmt.web.v2016_09_01.models.MetricAvailabilily]
    :ivar display_name: Friendly name shown in the UI.
    :vartype display_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "name_properties_name": {"readonly": True},
        "unit": {"readonly": True},
        "primary_aggregation_type": {"readonly": True},
        "metric_availabilities": {"readonly": True},
        "display_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "unit": {"key": "properties.unit", "type": "str"},
        "primary_aggregation_type": {"key": "properties.primaryAggregationType", "type": "str"},
        "metric_availabilities": {"key": "properties.metricAvailabilities", "type": "[MetricAvailabilily]"},
        "display_name": {"key": "properties.displayName", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.name_properties_name = None
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.display_name = None


class NameValuePair(_serialization.Model):
    """Name value pair.

    :ivar name: Pair name.
    :vartype name: str
    :ivar value: Pair value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Pair name.
        :paramtype name: str
        :keyword value: Pair value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class NetworkAccessControlEntry(_serialization.Model):
    """Network access control entry.

    :ivar action: Action object. Known values are: "Permit" and "Deny".
    :vartype action: str or ~azure.mgmt.web.v2016_09_01.models.AccessControlEntryAction
    :ivar description: Description of network access control entry.
    :vartype description: str
    :ivar order: Order of precedence.
    :vartype order: int
    :ivar remote_subnet: Remote subnet.
    :vartype remote_subnet: str
    """

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "remote_subnet": {"key": "remoteSubnet", "type": "str"},
    }

    def __init__(
        self,
        *,
        action: Optional[Union[str, "_models.AccessControlEntryAction"]] = None,
        description: Optional[str] = None,
        order: Optional[int] = None,
        remote_subnet: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action: Action object. Known values are: "Permit" and "Deny".
        :paramtype action: str or ~azure.mgmt.web.v2016_09_01.models.AccessControlEntryAction
        :keyword description: Description of network access control entry.
        :paramtype description: str
        :keyword order: Order of precedence.
        :paramtype order: int
        :keyword remote_subnet: Remote subnet.
        :paramtype remote_subnet: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.description = description
        self.order = order
        self.remote_subnet = remote_subnet


class Operation(_serialization.Model):
    """An operation on a resource.

    :ivar id: Operation ID.
    :vartype id: str
    :ivar name: Operation name.
    :vartype name: str
    :ivar status: The current status of the operation. Known values are: "InProgress", "Failed",
     "Succeeded", "TimedOut", and "Created".
    :vartype status: str or ~azure.mgmt.web.v2016_09_01.models.OperationStatus
    :ivar errors: Any errors associate with the operation.
    :vartype errors: list[~azure.mgmt.web.v2016_09_01.models.ErrorEntity]
    :ivar created_time: Time when operation has started.
    :vartype created_time: ~datetime.datetime
    :ivar modified_time: Time when operation has been updated.
    :vartype modified_time: ~datetime.datetime
    :ivar expiration_time: Time when operation will expire.
    :vartype expiration_time: ~datetime.datetime
    :ivar geo_master_operation_id: Applicable only for stamp operation ids.
    :vartype geo_master_operation_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "errors": {"key": "errors", "type": "[ErrorEntity]"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "modified_time": {"key": "modifiedTime", "type": "iso-8601"},
        "expiration_time": {"key": "expirationTime", "type": "iso-8601"},
        "geo_master_operation_id": {"key": "geoMasterOperationId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        status: Optional[Union[str, "_models.OperationStatus"]] = None,
        errors: Optional[List["_models.ErrorEntity"]] = None,
        created_time: Optional[datetime.datetime] = None,
        modified_time: Optional[datetime.datetime] = None,
        expiration_time: Optional[datetime.datetime] = None,
        geo_master_operation_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Operation ID.
        :paramtype id: str
        :keyword name: Operation name.
        :paramtype name: str
        :keyword status: The current status of the operation. Known values are: "InProgress", "Failed",
         "Succeeded", "TimedOut", and "Created".
        :paramtype status: str or ~azure.mgmt.web.v2016_09_01.models.OperationStatus
        :keyword errors: Any errors associate with the operation.
        :paramtype errors: list[~azure.mgmt.web.v2016_09_01.models.ErrorEntity]
        :keyword created_time: Time when operation has started.
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time: Time when operation has been updated.
        :paramtype modified_time: ~datetime.datetime
        :keyword expiration_time: Time when operation will expire.
        :paramtype expiration_time: ~datetime.datetime
        :keyword geo_master_operation_id: Applicable only for stamp operation ids.
        :paramtype geo_master_operation_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.errors = errors
        self.created_time = created_time
        self.modified_time = modified_time
        self.expiration_time = expiration_time
        self.geo_master_operation_id = geo_master_operation_id


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
    :vartype is_push_enabled: bool
    :ivar tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are in the
     allowed list for use by the push registration endpoint.
    :vartype tag_whitelist_json: str
    :ivar tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
     user authentication to be used in the push registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :vartype tags_requiring_auth: str
    :ivar dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that will
     be evaluated from user claims in the push registration endpoint.
    :vartype dynamic_tags_json: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_push_enabled": {"key": "properties.isPushEnabled", "type": "bool"},
        "tag_whitelist_json": {"key": "properties.tagWhitelistJson", "type": "str"},
        "tags_requiring_auth": {"key": "properties.tagsRequiringAuth", "type": "str"},
        "dynamic_tags_json": {"key": "properties.dynamicTagsJson", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        is_push_enabled: Optional[bool] = None,
        tag_whitelist_json: Optional[str] = None,
        tags_requiring_auth: Optional[str] = None,
        dynamic_tags_json: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
        :paramtype is_push_enabled: bool
        :keyword tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are in
         the allowed list for use by the push registration endpoint.
        :paramtype tag_whitelist_json: str
        :keyword tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
         user authentication to be used in the push registration endpoint.
         Tags can consist of alphanumeric characters and the following:
         '_', '@', '#', '.', ':', '-'.
         Validation should be performed at the PushRequestHandler.
        :paramtype tags_requiring_auth: str
        :keyword dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that
         will be evaluated from user claims in the push registration endpoint.
        :paramtype dynamic_tags_json: str
        """
        super().__init__(kind=kind, **kwargs)
        self.is_push_enabled = is_push_enabled
        self.tag_whitelist_json = tag_whitelist_json
        self.tags_requiring_auth = tags_requiring_auth
        self.dynamic_tags_json = dynamic_tags_json


class RampUpRule(_serialization.Model):
    """Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or
    to gradually change routing % based on performance.

    :ivar action_host_name: Hostname of a slot to which the traffic will be redirected if decided
     to. E.g. myapp-stage.azurewebsites.net.
    :vartype action_host_name: str
    :ivar reroute_percentage: Percentage of the traffic which will be redirected to
     :code:`<code>ActionHostName</code>`.
    :vartype reroute_percentage: float
    :ivar change_step: In auto ramp up scenario this is the step to add/remove from
     :code:`<code>ReroutePercentage</code>` until it reaches
     :code:`<code>MinReroutePercentage</code>` or :code:`<code>MaxReroutePercentage</code>`. Site
     metrics are checked every N minutes specified in :code:`<code>ChangeIntervalInMinutes</code>`.
     Custom decision algorithm can be provided in TiPCallback site extension which URL can be
     specified in :code:`<code>ChangeDecisionCallbackUrl</code>`.
    :vartype change_step: float
    :ivar change_interval_in_minutes: Specifies interval in minutes to reevaluate
     ReroutePercentage.
    :vartype change_interval_in_minutes: int
    :ivar min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will stay.
    :vartype min_reroute_percentage: float
    :ivar max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will stay.
    :vartype max_reroute_percentage: float
    :ivar change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
     site extension which URL can be specified. See TiPCallback site extension for the scaffold and
     contracts.
     https://www.siteextensions.net/packages/TiPCallback/.
    :vartype change_decision_callback_url: str
    :ivar name: Name of the routing rule. The recommended name would be to point to the slot which
     will receive the traffic in the experiment.
    :vartype name: str
    """

    _attribute_map = {
        "action_host_name": {"key": "actionHostName", "type": "str"},
        "reroute_percentage": {"key": "reroutePercentage", "type": "float"},
        "change_step": {"key": "changeStep", "type": "float"},
        "change_interval_in_minutes": {"key": "changeIntervalInMinutes", "type": "int"},
        "min_reroute_percentage": {"key": "minReroutePercentage", "type": "float"},
        "max_reroute_percentage": {"key": "maxReroutePercentage", "type": "float"},
        "change_decision_callback_url": {"key": "changeDecisionCallbackUrl", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_host_name: Optional[str] = None,
        reroute_percentage: Optional[float] = None,
        change_step: Optional[float] = None,
        change_interval_in_minutes: Optional[int] = None,
        min_reroute_percentage: Optional[float] = None,
        max_reroute_percentage: Optional[float] = None,
        change_decision_callback_url: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_host_name: Hostname of a slot to which the traffic will be redirected if
         decided to. E.g. myapp-stage.azurewebsites.net.
        :paramtype action_host_name: str
        :keyword reroute_percentage: Percentage of the traffic which will be redirected to
         :code:`<code>ActionHostName</code>`.
        :paramtype reroute_percentage: float
        :keyword change_step: In auto ramp up scenario this is the step to add/remove from
         :code:`<code>ReroutePercentage</code>` until it reaches
         :code:`<code>MinReroutePercentage</code>` or :code:`<code>MaxReroutePercentage</code>`. Site
         metrics are checked every N minutes specified in :code:`<code>ChangeIntervalInMinutes</code>`.
         Custom decision algorithm can be provided in TiPCallback site extension which URL can be
         specified in :code:`<code>ChangeDecisionCallbackUrl</code>`.
        :paramtype change_step: float
        :keyword change_interval_in_minutes: Specifies interval in minutes to reevaluate
         ReroutePercentage.
        :paramtype change_interval_in_minutes: int
        :keyword min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will
         stay.
        :paramtype min_reroute_percentage: float
        :keyword max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will
         stay.
        :paramtype max_reroute_percentage: float
        :keyword change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
         site extension which URL can be specified. See TiPCallback site extension for the scaffold and
         contracts.
         https://www.siteextensions.net/packages/TiPCallback/.
        :paramtype change_decision_callback_url: str
        :keyword name: Name of the routing rule. The recommended name would be to point to the slot
         which will receive the traffic in the experiment.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.action_host_name = action_host_name
        self.reroute_percentage = reroute_percentage
        self.change_step = change_step
        self.change_interval_in_minutes = change_interval_in_minutes
        self.min_reroute_percentage = min_reroute_percentage
        self.max_reroute_percentage = max_reroute_percentage
        self.change_decision_callback_url = change_decision_callback_url
        self.name = name


class RequestsBasedTrigger(_serialization.Model):
    """Trigger based on total requests.

    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(self, *, count: Optional[int] = None, time_interval: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.count = count
        self.time_interval = time_interval


class ResourceCollection(_serialization.Model):
    """Collection of resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[str]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List[str], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[str]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceMetric(_serialization.Model):
    """Object representing a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of metric.
    :vartype name: ~azure.mgmt.web.v2016_09_01.models.ResourceMetricName
    :ivar unit: Metric unit.
    :vartype unit: str
    :ivar time_grain: Metric granularity. E.g PT1H, PT5M, P1D.
    :vartype time_grain: str
    :ivar start_time: Metric start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Metric end time.
    :vartype end_time: ~datetime.datetime
    :ivar resource_id: Metric resource Id.
    :vartype resource_id: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar metric_values: Metric values.
    :vartype metric_values: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetricValue]
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetricProperty]
    """

    _validation = {
        "name": {"readonly": True},
        "unit": {"readonly": True},
        "time_grain": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "resource_id": {"readonly": True},
        "id": {"readonly": True},
        "metric_values": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "ResourceMetricName"},
        "unit": {"key": "unit", "type": "str"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "metric_values": {"key": "metricValues", "type": "[ResourceMetricValue]"},
        "properties": {"key": "properties", "type": "[ResourceMetricProperty]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.unit = None
        self.time_grain = None
        self.start_time = None
        self.end_time = None
        self.resource_id = None
        self.id = None
        self.metric_values = None
        self.properties = None


class ResourceMetricAvailability(_serialization.Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        "time_grain": {"readonly": True},
        "retention": {"readonly": True},
    }

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "retention": {"key": "retention", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class ResourceMetricCollection(_serialization.Model):
    """Collection of metric responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetric]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceMetric]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceMetric"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetric]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceMetricDefinition(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of the metric.
    :vartype name_properties_name: ~azure.mgmt.web.v2016_09_01.models.ResourceMetricName
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.v2016_09_01.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar id_properties_id: Resource ID.
    :vartype id_properties_id: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "name_properties_name": {"readonly": True},
        "unit": {"readonly": True},
        "primary_aggregation_type": {"readonly": True},
        "metric_availabilities": {"readonly": True},
        "resource_uri": {"readonly": True},
        "id_properties_id": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "ResourceMetricName"},
        "unit": {"key": "properties.unit", "type": "str"},
        "primary_aggregation_type": {"key": "properties.primaryAggregationType", "type": "str"},
        "metric_availabilities": {"key": "properties.metricAvailabilities", "type": "[ResourceMetricAvailability]"},
        "resource_uri": {"key": "properties.resourceUri", "type": "str"},
        "id_properties_id": {"key": "properties.id", "type": "str"},
        "properties": {"key": "properties.properties", "type": "{str}"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.name_properties_name = None
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.resource_uri = None
        self.id_properties_id = None
        self.properties = None


class ResourceMetricDefinitionCollection(_serialization.Model):
    """Collection of metric definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetricDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceMetricDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceMetricDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetricDefinition]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ResourceMetricName(_serialization.Model):
    """Name of a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: metric name value.
    :vartype value: str
    :ivar localized_value: Localized metric name value.
    :vartype localized_value: str
    """

    _validation = {
        "value": {"readonly": True},
        "localized_value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.localized_value = None


class ResourceMetricProperty(_serialization.Model):
    """Resource metric property.

    :ivar key: Key for resource metric property.
    :vartype key: str
    :ivar value: Value of pair.
    :vartype value: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: Key for resource metric property.
        :paramtype key: str
        :keyword value: Value of pair.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class ResourceMetricValue(_serialization.Model):
    """Value of resource metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: Value timestamp.
    :vartype timestamp: str
    :ivar average: Value average.
    :vartype average: float
    :ivar minimum: Value minimum.
    :vartype minimum: float
    :ivar maximum: Value maximum.
    :vartype maximum: float
    :ivar total: Value total.
    :vartype total: float
    :ivar count: Value count.
    :vartype count: float
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2016_09_01.models.ResourceMetricProperty]
    """

    _validation = {
        "timestamp": {"readonly": True},
        "average": {"readonly": True},
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "total": {"readonly": True},
        "count": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "str"},
        "average": {"key": "average", "type": "float"},
        "minimum": {"key": "minimum", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "total": {"key": "total", "type": "float"},
        "count": {"key": "count", "type": "float"},
        "properties": {"key": "properties", "type": "[ResourceMetricProperty]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.timestamp = None
        self.average = None
        self.minimum = None
        self.maximum = None
        self.total = None
        self.count = None
        self.properties = None


class Site(Resource):  # pylint: disable=too-many-instance-attributes
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.web.v2016_09_01.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Known values are: "Normal" and "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2016_09_01.models.UsageState
    :ivar enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :vartype enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Known values
     are: "Normal", "Limited", and "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2016_09_01.models.SiteAvailabilityState
    :ivar host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :vartype host_name_ssl_states: list[~azure.mgmt.web.v2016_09_01.models.HostNameSslState]
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :vartype reserved: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar site_config: Configuration of the app.
    :vartype site_config: ~azure.mgmt.web.v2016_09_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :ivar scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :vartype scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :ivar hosting_environment_profile: App Service Environment to use for the app.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentProfile
    :ivar client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :vartype client_affinity_enabled: bool
    :ivar client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :vartype client_cert_enabled: bool
    :ivar host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :vartype host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants. Read-only.
    :vartype possible_outbound_ip_addresses: str
    :ivar container_size: Size of the function container.
    :vartype container_size: int
    :ivar daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :vartype daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :ivar cloning_info: If specified during app creation, the app is cloned from a source app.
    :vartype cloning_info: ~azure.mgmt.web.v2016_09_01.models.CloningInfo
    :ivar snapshot_info: If specified during app creation, the app is created from a previous
     snapshot.
    :vartype snapshot_info: ~azure.mgmt.web.v2016_09_01.models.SnapshotRecoveryRequest
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2016_09_01.models.SlotSwapStatus
    :ivar https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :vartype https_only: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "state": {"readonly": True},
        "host_names": {"readonly": True},
        "repository_site_name": {"readonly": True},
        "usage_state": {"readonly": True},
        "enabled_host_names": {"readonly": True},
        "availability_state": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
        "traffic_manager_host_names": {"readonly": True},
        "target_swap_slot": {"readonly": True},
        "outbound_ip_addresses": {"readonly": True},
        "possible_outbound_ip_addresses": {"readonly": True},
        "suspended_till": {"readonly": True},
        "max_number_of_workers": {"readonly": True},
        "resource_group": {"readonly": True},
        "is_default_container": {"readonly": True},
        "default_host_name": {"readonly": True},
        "slot_swap_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "state": {"key": "properties.state", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "repository_site_name": {"key": "properties.repositorySiteName", "type": "str"},
        "usage_state": {"key": "properties.usageState", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "enabled_host_names": {"key": "properties.enabledHostNames", "type": "[str]"},
        "availability_state": {"key": "properties.availabilityState", "type": "str"},
        "host_name_ssl_states": {"key": "properties.hostNameSslStates", "type": "[HostNameSslState]"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
        "site_config": {"key": "properties.siteConfig", "type": "SiteConfig"},
        "traffic_manager_host_names": {"key": "properties.trafficManagerHostNames", "type": "[str]"},
        "scm_site_also_stopped": {"key": "properties.scmSiteAlsoStopped", "type": "bool"},
        "target_swap_slot": {"key": "properties.targetSwapSlot", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "client_affinity_enabled": {"key": "properties.clientAffinityEnabled", "type": "bool"},
        "client_cert_enabled": {"key": "properties.clientCertEnabled", "type": "bool"},
        "host_names_disabled": {"key": "properties.hostNamesDisabled", "type": "bool"},
        "outbound_ip_addresses": {"key": "properties.outboundIpAddresses", "type": "str"},
        "possible_outbound_ip_addresses": {"key": "properties.possibleOutboundIpAddresses", "type": "str"},
        "container_size": {"key": "properties.containerSize", "type": "int"},
        "daily_memory_time_quota": {"key": "properties.dailyMemoryTimeQuota", "type": "int"},
        "suspended_till": {"key": "properties.suspendedTill", "type": "iso-8601"},
        "max_number_of_workers": {"key": "properties.maxNumberOfWorkers", "type": "int"},
        "cloning_info": {"key": "properties.cloningInfo", "type": "CloningInfo"},
        "snapshot_info": {"key": "properties.snapshotInfo", "type": "SnapshotRecoveryRequest"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "is_default_container": {"key": "properties.isDefaultContainer", "type": "bool"},
        "default_host_name": {"key": "properties.defaultHostName", "type": "str"},
        "slot_swap_status": {"key": "properties.slotSwapStatus", "type": "SlotSwapStatus"},
        "https_only": {"key": "properties.httpsOnly", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["_models.HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: bool = False,
        site_config: Optional["_models.SiteConfig"] = None,
        scm_site_also_stopped: bool = False,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        host_names_disabled: Optional[bool] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["_models.CloningInfo"] = None,
        snapshot_info: Optional["_models.SnapshotRecoveryRequest"] = None,
        https_only: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity.
        :paramtype identity: ~azure.mgmt.web.v2016_09_01.models.ManagedServiceIdentity
        :keyword enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
         :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
         offline).
        :paramtype enabled: bool
        :keyword host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for
         app's hostnames.
        :paramtype host_name_ssl_states: list[~azure.mgmt.web.v2016_09_01.models.HostNameSslState]
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword reserved: :code:`<code>true</code>` if reserved; otherwise,
         :code:`<code>false</code>`.
        :paramtype reserved: bool
        :keyword site_config: Configuration of the app.
        :paramtype site_config: ~azure.mgmt.web.v2016_09_01.models.SiteConfig
        :keyword scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app
         is stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
        :paramtype scm_site_also_stopped: bool
        :keyword hosting_environment_profile: App Service Environment to use for the app.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2016_09_01.models.HostingEnvironmentProfile
        :keyword client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
         :code:`<code>false</code>` to stop sending session affinity cookies, which route client
         requests in the same session to the same instance. Default is :code:`<code>true</code>`.
        :paramtype client_affinity_enabled: bool
        :keyword client_cert_enabled: :code:`<code>true</code>` to enable client certificate
         authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
         :code:`<code>false</code>`.
        :paramtype client_cert_enabled: bool
        :keyword host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
         app; otherwise, :code:`<code>false</code>`.
          If :code:`<code>true</code>`, the app is only accessible via API management process.
        :paramtype host_names_disabled: bool
        :keyword container_size: Size of the function container.
        :paramtype container_size: int
        :keyword daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on
         dynamic apps only).
        :paramtype daily_memory_time_quota: int
        :keyword cloning_info: If specified during app creation, the app is cloned from a source app.
        :paramtype cloning_info: ~azure.mgmt.web.v2016_09_01.models.CloningInfo
        :keyword snapshot_info: If specified during app creation, the app is created from a previous
         snapshot.
        :paramtype snapshot_info: ~azure.mgmt.web.v2016_09_01.models.SnapshotRecoveryRequest
        :keyword https_only: HttpsOnly: configures a web site to accept only https requests. Issues
         redirect for
         http requests.
        :paramtype https_only: bool
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.identity = identity
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = enabled
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.last_modified_time_utc = None
        self.site_config = site_config
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.host_names_disabled = host_names_disabled
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = cloning_info
        self.snapshot_info = snapshot_info
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = https_only


class SiteConfig(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar number_of_workers: Number of workers.
    :vartype number_of_workers: int
    :ivar default_documents: Default documents.
    :vartype default_documents: list[str]
    :ivar net_framework_version: .NET Framework version.
    :vartype net_framework_version: str
    :ivar php_version: Version of PHP.
    :vartype php_version: str
    :ivar python_version: Version of Python.
    :vartype python_version: str
    :ivar node_version: Version of Node.js.
    :vartype node_version: str
    :ivar linux_fx_version: Linux App Framework and version.
    :vartype linux_fx_version: str
    :ivar request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype request_tracing_enabled: bool
    :ivar request_tracing_expiration_time: Request tracing expiration time.
    :vartype request_tracing_expiration_time: ~datetime.datetime
    :ivar remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_enabled: bool
    :ivar remote_debugging_version: Remote debugging version.
    :vartype remote_debugging_version: str
    :ivar http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype http_logging_enabled: bool
    :ivar logs_directory_size_limit: HTTP logs directory size limit.
    :vartype logs_directory_size_limit: int
    :ivar detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :vartype detailed_error_logging_enabled: bool
    :ivar publishing_username: Publishing user name.
    :vartype publishing_username: str
    :ivar app_settings: Application settings.
    :vartype app_settings: list[~azure.mgmt.web.v2016_09_01.models.NameValuePair]
    :ivar connection_strings: Connection strings.
    :vartype connection_strings: list[~azure.mgmt.web.v2016_09_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2016_09_01.models.SiteMachineKey
    :ivar handler_mappings: Handler mappings.
    :vartype handler_mappings: list[~azure.mgmt.web.v2016_09_01.models.HandlerMapping]
    :ivar document_root: Document root.
    :vartype document_root: str
    :ivar scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
     "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
     "OneDrive", and "VSO".
    :vartype scm_type: str or ~azure.mgmt.web.v2016_09_01.models.ScmType
    :ivar use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype web_sockets_enabled: bool
    :ivar always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype always_on: bool
    :ivar java_version: Java version.
    :vartype java_version: str
    :ivar java_container: Java container.
    :vartype java_container: str
    :ivar java_container_version: Java container version.
    :vartype java_container_version: str
    :ivar app_command_line: App command line to launch.
    :vartype app_command_line: str
    :ivar managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
     "Classic".
    :vartype managed_pipeline_mode: str or ~azure.mgmt.web.v2016_09_01.models.ManagedPipelineMode
    :ivar virtual_applications: Virtual applications.
    :vartype virtual_applications: list[~azure.mgmt.web.v2016_09_01.models.VirtualApplication]
    :ivar load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", and "RequestHash".
    :vartype load_balancing: str or ~azure.mgmt.web.v2016_09_01.models.SiteLoadBalancing
    :ivar experiments: This is work around for polymorphic types.
    :vartype experiments: ~azure.mgmt.web.v2016_09_01.models.Experiments
    :ivar limits: Site limits.
    :vartype limits: ~azure.mgmt.web.v2016_09_01.models.SiteLimits
    :ivar auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype auto_heal_enabled: bool
    :ivar auto_heal_rules: Auto Heal rules.
    :vartype auto_heal_rules: ~azure.mgmt.web.v2016_09_01.models.AutoHealRules
    :ivar tracing_options: Tracing options.
    :vartype tracing_options: str
    :ivar vnet_name: Virtual Network name.
    :vartype vnet_name: str
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.web.v2016_09_01.models.CorsSettings
    :ivar push: Push endpoint settings.
    :vartype push: ~azure.mgmt.web.v2016_09_01.models.PushSettings
    :ivar api_definition: Information about the formal API definition for the app.
    :vartype api_definition: ~azure.mgmt.web.v2016_09_01.models.ApiDefinitionInfo
    :ivar auto_swap_slot_name: Auto-swap slot name.
    :vartype auto_swap_slot_name: str
    :ivar local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :vartype local_my_sql_enabled: bool
    :ivar ip_security_restrictions: IP security restrictions.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.web.v2016_09_01.models.IpSecurityRestriction]
    :ivar http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :vartype http20_enabled: bool
    :ivar min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Known values are: "1.0", "1.1", and "1.2".
    :vartype min_tls_version: str or ~azure.mgmt.web.v2016_09_01.models.SupportedTlsVersions
    """

    _validation = {
        "machine_key": {"readonly": True},
    }

    _attribute_map = {
        "number_of_workers": {"key": "numberOfWorkers", "type": "int"},
        "default_documents": {"key": "defaultDocuments", "type": "[str]"},
        "net_framework_version": {"key": "netFrameworkVersion", "type": "str"},
        "php_version": {"key": "phpVersion", "type": "str"},
        "python_version": {"key": "pythonVersion", "type": "str"},
        "node_version": {"key": "nodeVersion", "type": "str"},
        "linux_fx_version": {"key": "linuxFxVersion", "type": "str"},
        "request_tracing_enabled": {"key": "requestTracingEnabled", "type": "bool"},
        "request_tracing_expiration_time": {"key": "requestTracingExpirationTime", "type": "iso-8601"},
        "remote_debugging_enabled": {"key": "remoteDebuggingEnabled", "type": "bool"},
        "remote_debugging_version": {"key": "remoteDebuggingVersion", "type": "str"},
        "http_logging_enabled": {"key": "httpLoggingEnabled", "type": "bool"},
        "logs_directory_size_limit": {"key": "logsDirectorySizeLimit", "type": "int"},
        "detailed_error_logging_enabled": {"key": "detailedErrorLoggingEnabled", "type": "bool"},
        "publishing_username": {"key": "publishingUsername", "type": "str"},
        "app_settings": {"key": "appSettings", "type": "[NameValuePair]"},
        "connection_strings": {"key": "connectionStrings", "type": "[ConnStringInfo]"},
        "machine_key": {"key": "machineKey", "type": "SiteMachineKey"},
        "handler_mappings": {"key": "handlerMappings", "type": "[HandlerMapping]"},
        "document_root": {"key": "documentRoot", "type": "str"},
        "scm_type": {"key": "scmType", "type": "str"},
        "use32_bit_worker_process": {"key": "use32BitWorkerProcess", "type": "bool"},
        "web_sockets_enabled": {"key": "webSocketsEnabled", "type": "bool"},
        "always_on": {"key": "alwaysOn", "type": "bool"},
        "java_version": {"key": "javaVersion", "type": "str"},
        "java_container": {"key": "javaContainer", "type": "str"},
        "java_container_version": {"key": "javaContainerVersion", "type": "str"},
        "app_command_line": {"key": "appCommandLine", "type": "str"},
        "managed_pipeline_mode": {"key": "managedPipelineMode", "type": "str"},
        "virtual_applications": {"key": "virtualApplications", "type": "[VirtualApplication]"},
        "load_balancing": {"key": "loadBalancing", "type": "str"},
        "experiments": {"key": "experiments", "type": "Experiments"},
        "limits": {"key": "limits", "type": "SiteLimits"},
        "auto_heal_enabled": {"key": "autoHealEnabled", "type": "bool"},
        "auto_heal_rules": {"key": "autoHealRules", "type": "AutoHealRules"},
        "tracing_options": {"key": "tracingOptions", "type": "str"},
        "vnet_name": {"key": "vnetName", "type": "str"},
        "cors": {"key": "cors", "type": "CorsSettings"},
        "push": {"key": "push", "type": "PushSettings"},
        "api_definition": {"key": "apiDefinition", "type": "ApiDefinitionInfo"},
        "auto_swap_slot_name": {"key": "autoSwapSlotName", "type": "str"},
        "local_my_sql_enabled": {"key": "localMySqlEnabled", "type": "bool"},
        "ip_security_restrictions": {"key": "ipSecurityRestrictions", "type": "[IpSecurityRestriction]"},
        "http20_enabled": {"key": "http20Enabled", "type": "bool"},
        "min_tls_version": {"key": "minTlsVersion", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: str = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["_models.NameValuePair"]] = None,
        connection_strings: Optional[List["_models.ConnStringInfo"]] = None,
        handler_mappings: Optional[List["_models.HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "_models.ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "_models.ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["_models.VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "_models.SiteLoadBalancing"]] = None,
        experiments: Optional["_models.Experiments"] = None,
        limits: Optional["_models.SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["_models.AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        cors: Optional["_models.CorsSettings"] = None,
        push: Optional["_models.PushSettings"] = None,
        api_definition: Optional["_models.ApiDefinitionInfo"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: bool = False,
        ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        http20_enabled: bool = True,
        min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number_of_workers: Number of workers.
        :paramtype number_of_workers: int
        :keyword default_documents: Default documents.
        :paramtype default_documents: list[str]
        :keyword net_framework_version: .NET Framework version.
        :paramtype net_framework_version: str
        :keyword php_version: Version of PHP.
        :paramtype php_version: str
        :keyword python_version: Version of Python.
        :paramtype python_version: str
        :keyword node_version: Version of Node.js.
        :paramtype node_version: str
        :keyword linux_fx_version: Linux App Framework and version.
        :paramtype linux_fx_version: str
        :keyword request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype request_tracing_enabled: bool
        :keyword request_tracing_expiration_time: Request tracing expiration time.
        :paramtype request_tracing_expiration_time: ~datetime.datetime
        :keyword remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype remote_debugging_enabled: bool
        :keyword remote_debugging_version: Remote debugging version.
        :paramtype remote_debugging_version: str
        :keyword http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype http_logging_enabled: bool
        :keyword logs_directory_size_limit: HTTP logs directory size limit.
        :paramtype logs_directory_size_limit: int
        :keyword detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
         enabled; otherwise, :code:`<code>false</code>`.
        :paramtype detailed_error_logging_enabled: bool
        :keyword publishing_username: Publishing user name.
        :paramtype publishing_username: str
        :keyword app_settings: Application settings.
        :paramtype app_settings: list[~azure.mgmt.web.v2016_09_01.models.NameValuePair]
        :keyword connection_strings: Connection strings.
        :paramtype connection_strings: list[~azure.mgmt.web.v2016_09_01.models.ConnStringInfo]
        :keyword handler_mappings: Handler mappings.
        :paramtype handler_mappings: list[~azure.mgmt.web.v2016_09_01.models.HandlerMapping]
        :keyword document_root: Document root.
        :paramtype document_root: str
        :keyword scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
         "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
         "OneDrive", and "VSO".
        :paramtype scm_type: str or ~azure.mgmt.web.v2016_09_01.models.ScmType
        :keyword use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
         otherwise, :code:`<code>false</code>`.
        :paramtype use32_bit_worker_process: bool
        :keyword web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype web_sockets_enabled: bool
        :keyword always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype always_on: bool
        :keyword java_version: Java version.
        :paramtype java_version: str
        :keyword java_container: Java container.
        :paramtype java_container: str
        :keyword java_container_version: Java container version.
        :paramtype java_container_version: str
        :keyword app_command_line: App command line to launch.
        :paramtype app_command_line: str
        :keyword managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
         "Classic".
        :paramtype managed_pipeline_mode: str or ~azure.mgmt.web.v2016_09_01.models.ManagedPipelineMode
        :keyword virtual_applications: Virtual applications.
        :paramtype virtual_applications: list[~azure.mgmt.web.v2016_09_01.models.VirtualApplication]
        :keyword load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
         "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", and "RequestHash".
        :paramtype load_balancing: str or ~azure.mgmt.web.v2016_09_01.models.SiteLoadBalancing
        :keyword experiments: This is work around for polymorphic types.
        :paramtype experiments: ~azure.mgmt.web.v2016_09_01.models.Experiments
        :keyword limits: Site limits.
        :paramtype limits: ~azure.mgmt.web.v2016_09_01.models.SiteLimits
        :keyword auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype auto_heal_enabled: bool
        :keyword auto_heal_rules: Auto Heal rules.
        :paramtype auto_heal_rules: ~azure.mgmt.web.v2016_09_01.models.AutoHealRules
        :keyword tracing_options: Tracing options.
        :paramtype tracing_options: str
        :keyword vnet_name: Virtual Network name.
        :paramtype vnet_name: str
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.web.v2016_09_01.models.CorsSettings
        :keyword push: Push endpoint settings.
        :paramtype push: ~azure.mgmt.web.v2016_09_01.models.PushSettings
        :keyword api_definition: Information about the formal API definition for the app.
        :paramtype api_definition: ~azure.mgmt.web.v2016_09_01.models.ApiDefinitionInfo
        :keyword auto_swap_slot_name: Auto-swap slot name.
        :paramtype auto_swap_slot_name: str
        :keyword local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
         :code:`<code>false</code>`.
        :paramtype local_my_sql_enabled: bool
        :keyword ip_security_restrictions: IP security restrictions.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.web.v2016_09_01.models.IpSecurityRestriction]
        :keyword http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
         http2.0.
        :paramtype http20_enabled: bool
        :keyword min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
         requests. Known values are: "1.0", "1.1", and "1.2".
        :paramtype min_tls_version: str or ~azure.mgmt.web.v2016_09_01.models.SupportedTlsVersions
        """
        super().__init__(**kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.linux_fx_version = linux_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.connection_strings = connection_strings
        self.machine_key = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.ip_security_restrictions = ip_security_restrictions
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version


class SiteLimits(_serialization.Model):
    """Metric limits set on an app.

    :ivar max_percentage_cpu: Maximum allowed CPU usage percentage.
    :vartype max_percentage_cpu: float
    :ivar max_memory_in_mb: Maximum allowed memory usage in MB.
    :vartype max_memory_in_mb: int
    :ivar max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :vartype max_disk_size_in_mb: int
    """

    _attribute_map = {
        "max_percentage_cpu": {"key": "maxPercentageCpu", "type": "float"},
        "max_memory_in_mb": {"key": "maxMemoryInMb", "type": "int"},
        "max_disk_size_in_mb": {"key": "maxDiskSizeInMb", "type": "int"},
    }

    def __init__(
        self,
        *,
        max_percentage_cpu: Optional[float] = None,
        max_memory_in_mb: Optional[int] = None,
        max_disk_size_in_mb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_percentage_cpu: Maximum allowed CPU usage percentage.
        :paramtype max_percentage_cpu: float
        :keyword max_memory_in_mb: Maximum allowed memory usage in MB.
        :paramtype max_memory_in_mb: int
        :keyword max_disk_size_in_mb: Maximum allowed disk size usage in MB.
        :paramtype max_disk_size_in_mb: int
        """
        super().__init__(**kwargs)
        self.max_percentage_cpu = max_percentage_cpu
        self.max_memory_in_mb = max_memory_in_mb
        self.max_disk_size_in_mb = max_disk_size_in_mb


class SiteMachineKey(_serialization.Model):
    """MachineKey of an app.

    :ivar validation: MachineKey validation.
    :vartype validation: str
    :ivar validation_key: Validation key.
    :vartype validation_key: str
    :ivar decryption: Algorithm used for decryption.
    :vartype decryption: str
    :ivar decryption_key: Decryption key.
    :vartype decryption_key: str
    """

    _attribute_map = {
        "validation": {"key": "validation", "type": "str"},
        "validation_key": {"key": "validationKey", "type": "str"},
        "decryption": {"key": "decryption", "type": "str"},
        "decryption_key": {"key": "decryptionKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        validation: Optional[str] = None,
        validation_key: Optional[str] = None,
        decryption: Optional[str] = None,
        decryption_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword validation: MachineKey validation.
        :paramtype validation: str
        :keyword validation_key: Validation key.
        :paramtype validation_key: str
        :keyword decryption: Algorithm used for decryption.
        :paramtype decryption: str
        :keyword decryption_key: Decryption key.
        :paramtype decryption_key: str
        """
        super().__init__(**kwargs)
        self.validation = validation
        self.validation_key = validation_key
        self.decryption = decryption
        self.decryption_key = decryption_key


class SkuCapacity(_serialization.Model):
    """Description of the App Service plan scale options.

    :ivar minimum: Minimum number of workers for this App Service plan SKU.
    :vartype minimum: int
    :ivar maximum: Maximum number of workers for this App Service plan SKU.
    :vartype maximum: int
    :ivar default: Default number of workers for this App Service plan SKU.
    :vartype default: int
    :ivar scale_type: Available scale configurations for an App Service plan.
    :vartype scale_type: str
    """

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum: Optional[int] = None,
        maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword minimum: Minimum number of workers for this App Service plan SKU.
        :paramtype minimum: int
        :keyword maximum: Maximum number of workers for this App Service plan SKU.
        :paramtype maximum: int
        :keyword default: Default number of workers for this App Service plan SKU.
        :paramtype default: int
        :keyword scale_type: Available scale configurations for an App Service plan.
        :paramtype scale_type: str
        """
        super().__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type


class SkuDescription(_serialization.Model):
    """Description of a SKU for a scalable resource.

    :ivar name: Name of the resource SKU.
    :vartype name: str
    :ivar tier: Service tier of the resource SKU.
    :vartype tier: str
    :ivar size: Size specifier of the resource SKU.
    :vartype size: str
    :ivar family: Family code of the resource SKU.
    :vartype family: str
    :ivar capacity: Current number of instances assigned to the resource.
    :vartype capacity: int
    :ivar sku_capacity: Min, max, and default scale values of the SKU.
    :vartype sku_capacity: ~azure.mgmt.web.v2016_09_01.models.SkuCapacity
    :ivar locations: Locations of the SKU.
    :vartype locations: list[str]
    :ivar capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :vartype capabilities: list[~azure.mgmt.web.v2016_09_01.models.Capability]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
        "sku_capacity": {"key": "skuCapacity", "type": "SkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[Capability]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        sku_capacity: Optional["_models.SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        capabilities: Optional[List["_models.Capability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the resource SKU.
        :paramtype name: str
        :keyword tier: Service tier of the resource SKU.
        :paramtype tier: str
        :keyword size: Size specifier of the resource SKU.
        :paramtype size: str
        :keyword family: Family code of the resource SKU.
        :paramtype family: str
        :keyword capacity: Current number of instances assigned to the resource.
        :paramtype capacity: int
        :keyword sku_capacity: Min, max, and default scale values of the SKU.
        :paramtype sku_capacity: ~azure.mgmt.web.v2016_09_01.models.SkuCapacity
        :keyword locations: Locations of the SKU.
        :paramtype locations: list[str]
        :keyword capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
        :paramtype capabilities: list[~azure.mgmt.web.v2016_09_01.models.Capability]
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.sku_capacity = sku_capacity
        self.locations = locations
        self.capabilities = capabilities


class SkuInfo(_serialization.Model):
    """SKU discovery information.

    :ivar resource_type: Resource type that this SKU applies to.
    :vartype resource_type: str
    :ivar sku: Name and tier of the SKU.
    :vartype sku: ~azure.mgmt.web.v2016_09_01.models.SkuDescription
    :ivar capacity: Min, max, and default scale values of the SKU.
    :vartype capacity: ~azure.mgmt.web.v2016_09_01.models.SkuCapacity
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "sku": {"key": "sku", "type": "SkuDescription"},
        "capacity": {"key": "capacity", "type": "SkuCapacity"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        sku: Optional["_models.SkuDescription"] = None,
        capacity: Optional["_models.SkuCapacity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: Resource type that this SKU applies to.
        :paramtype resource_type: str
        :keyword sku: Name and tier of the SKU.
        :paramtype sku: ~azure.mgmt.web.v2016_09_01.models.SkuDescription
        :keyword capacity: Min, max, and default scale values of the SKU.
        :paramtype capacity: ~azure.mgmt.web.v2016_09_01.models.SkuCapacity
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.sku = sku
        self.capacity = capacity


class SkuInfoCollection(_serialization.Model):
    """Collection of SKU information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_09_01.models.SkuInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SkuInfo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SkuInfo"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_09_01.models.SkuInfo]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SlotSwapStatus(_serialization.Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: ~datetime.datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        "timestamp_utc": {"readonly": True},
        "source_slot_name": {"readonly": True},
        "destination_slot_name": {"readonly": True},
    }

    _attribute_map = {
        "timestamp_utc": {"key": "timestampUtc", "type": "iso-8601"},
        "source_slot_name": {"key": "sourceSlotName", "type": "str"},
        "destination_slot_name": {"key": "destinationSlotName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.timestamp_utc = None
        self.source_slot_name = None
        self.destination_slot_name = None


class SlowRequestsBasedTrigger(_serialization.Model):
    """Trigger based on request execution time.

    :ivar time_taken: Time taken.
    :vartype time_taken: str
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "time_taken": {"key": "timeTaken", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(
        self,
        *,
        time_taken: Optional[str] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_taken: Time taken.
        :paramtype time_taken: str
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.time_taken = time_taken
        self.count = count
        self.time_interval = time_interval


class SnapshotRecoveryRequest(ProxyOnlyResource):
    """Details about app recovery operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar snapshot_time: Point in time in which the app recovery should be attempted, formatted as
     a DateTime string.
    :vartype snapshot_time: str
    :ivar recovery_target: Specifies the web app that snapshot contents will be written to.
    :vartype recovery_target: ~azure.mgmt.web.v2016_09_01.models.SnapshotRecoveryTarget
    :ivar overwrite: If :code:`<code>true</code>` the recovery operation can overwrite source app;
     otherwise, :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar recover_configuration: If true, site configuration, in addition to content, will be
     reverted.
    :vartype recover_configuration: bool
    :ivar ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
     recovering to a target web app.
     This setting is only necessary when RecoverConfiguration is enabled.
    :vartype ignore_conflicting_host_names: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "snapshot_time": {"key": "properties.snapshotTime", "type": "str"},
        "recovery_target": {"key": "properties.recoveryTarget", "type": "SnapshotRecoveryTarget"},
        "overwrite": {"key": "properties.overwrite", "type": "bool"},
        "recover_configuration": {"key": "properties.recoverConfiguration", "type": "bool"},
        "ignore_conflicting_host_names": {"key": "properties.ignoreConflictingHostNames", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        snapshot_time: Optional[str] = None,
        recovery_target: Optional["_models.SnapshotRecoveryTarget"] = None,
        overwrite: Optional[bool] = None,
        recover_configuration: Optional[bool] = None,
        ignore_conflicting_host_names: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword snapshot_time: Point in time in which the app recovery should be attempted, formatted
         as a DateTime string.
        :paramtype snapshot_time: str
        :keyword recovery_target: Specifies the web app that snapshot contents will be written to.
        :paramtype recovery_target: ~azure.mgmt.web.v2016_09_01.models.SnapshotRecoveryTarget
        :keyword overwrite: If :code:`<code>true</code>` the recovery operation can overwrite source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword recover_configuration: If true, site configuration, in addition to content, will be
         reverted.
        :paramtype recover_configuration: bool
        :keyword ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
         recovering to a target web app.
         This setting is only necessary when RecoverConfiguration is enabled.
        :paramtype ignore_conflicting_host_names: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.snapshot_time = snapshot_time
        self.recovery_target = recovery_target
        self.overwrite = overwrite
        self.recover_configuration = recover_configuration
        self.ignore_conflicting_host_names = ignore_conflicting_host_names


class SnapshotRecoveryTarget(_serialization.Model):
    """Specifies the web app that snapshot contents will be written to.

    :ivar location: Geographical location of the target web app, e.g. SouthEastAsia,
     SouthCentralUS.
    :vartype location: str
    :ivar id: ARM resource ID of the target app.
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :vartype id: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Geographical location of the target web app, e.g. SouthEastAsia,
         SouthCentralUS.
        :paramtype location: str
        :keyword id: ARM resource ID of the target app.
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
        /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.id = id


class StampCapacity(_serialization.Model):
    """Stamp capacity information.

    :ivar name: Name of the stamp.
    :vartype name: str
    :ivar available_capacity: Available capacity (# of machines, bytes of storage etc...).
    :vartype available_capacity: int
    :ivar total_capacity: Total capacity (# of machines, bytes of storage etc...).
    :vartype total_capacity: int
    :ivar unit: Name of the unit.
    :vartype unit: str
    :ivar compute_mode: Shared/dedicated workers. Known values are: "Shared", "Dedicated", and
     "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2016_09_01.models.ComputeModeOptions
    :ivar worker_size: Size of the machines. Known values are: "Default", "Small", "Medium",
     "Large", "D1", "D2", and "D3".
    :vartype worker_size: str or ~azure.mgmt.web.v2016_09_01.models.WorkerSizeOptions
    :ivar worker_size_id: Size ID of machines:
     0 - Small
     1 - Medium
     2 - Large.
    :vartype worker_size_id: int
    :ivar exclude_from_capacity_allocation: If :code:`<code>true</code>`, it includes basic apps.
     Basic apps are not used for capacity allocation.
    :vartype exclude_from_capacity_allocation: bool
    :ivar is_applicable_for_all_compute_modes: :code:`<code>true</code>` if capacity is applicable
     for all apps; otherwise, :code:`<code>false</code>`.
    :vartype is_applicable_for_all_compute_modes: bool
    :ivar site_mode: Shared or Dedicated.
    :vartype site_mode: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "available_capacity": {"key": "availableCapacity", "type": "int"},
        "total_capacity": {"key": "totalCapacity", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
        "compute_mode": {"key": "computeMode", "type": "str"},
        "worker_size": {"key": "workerSize", "type": "str"},
        "worker_size_id": {"key": "workerSizeId", "type": "int"},
        "exclude_from_capacity_allocation": {"key": "excludeFromCapacityAllocation", "type": "bool"},
        "is_applicable_for_all_compute_modes": {"key": "isApplicableForAllComputeModes", "type": "bool"},
        "site_mode": {"key": "siteMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        available_capacity: Optional[int] = None,
        total_capacity: Optional[int] = None,
        unit: Optional[str] = None,
        compute_mode: Optional[Union[str, "_models.ComputeModeOptions"]] = None,
        worker_size: Optional[Union[str, "_models.WorkerSizeOptions"]] = None,
        worker_size_id: Optional[int] = None,
        exclude_from_capacity_allocation: Optional[bool] = None,
        is_applicable_for_all_compute_modes: Optional[bool] = None,
        site_mode: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the stamp.
        :paramtype name: str
        :keyword available_capacity: Available capacity (# of machines, bytes of storage etc...).
        :paramtype available_capacity: int
        :keyword total_capacity: Total capacity (# of machines, bytes of storage etc...).
        :paramtype total_capacity: int
        :keyword unit: Name of the unit.
        :paramtype unit: str
        :keyword compute_mode: Shared/dedicated workers. Known values are: "Shared", "Dedicated", and
         "Dynamic".
        :paramtype compute_mode: str or ~azure.mgmt.web.v2016_09_01.models.ComputeModeOptions
        :keyword worker_size: Size of the machines. Known values are: "Default", "Small", "Medium",
         "Large", "D1", "D2", and "D3".
        :paramtype worker_size: str or ~azure.mgmt.web.v2016_09_01.models.WorkerSizeOptions
        :keyword worker_size_id: Size ID of machines:
         0 - Small
         1 - Medium
         2 - Large.
        :paramtype worker_size_id: int
        :keyword exclude_from_capacity_allocation: If :code:`<code>true</code>`, it includes basic
         apps.
         Basic apps are not used for capacity allocation.
        :paramtype exclude_from_capacity_allocation: bool
        :keyword is_applicable_for_all_compute_modes: :code:`<code>true</code>` if capacity is
         applicable for all apps; otherwise, :code:`<code>false</code>`.
        :paramtype is_applicable_for_all_compute_modes: bool
        :keyword site_mode: Shared or Dedicated.
        :paramtype site_mode: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.available_capacity = available_capacity
        self.total_capacity = total_capacity
        self.unit = unit
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_size_id = worker_size_id
        self.exclude_from_capacity_allocation = exclude_from_capacity_allocation
        self.is_applicable_for_all_compute_modes = is_applicable_for_all_compute_modes
        self.site_mode = site_mode


class StampCapacityCollection(_serialization.Model):
    """Collection of stamp capacities.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_09_01.models.StampCapacity]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StampCapacity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.StampCapacity"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_09_01.models.StampCapacity]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class StatusCodesBasedTrigger(_serialization.Model):
    """Trigger based on status code.

    :ivar status: HTTP status code.
    :vartype status: int
    :ivar sub_status: Request Sub Status.
    :vartype sub_status: int
    :ivar win32_status: Win32 error code.
    :vartype win32_status: int
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "int"},
        "sub_status": {"key": "subStatus", "type": "int"},
        "win32_status": {"key": "win32Status", "type": "int"},
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[int] = None,
        sub_status: Optional[int] = None,
        win32_status: Optional[int] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: HTTP status code.
        :paramtype status: int
        :keyword sub_status: Request Sub Status.
        :paramtype sub_status: int
        :keyword win32_status: Win32 error code.
        :paramtype win32_status: int
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.sub_status = sub_status
        self.win32_status = win32_status
        self.count = count
        self.time_interval = time_interval


class Usage(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """Usage of the quota resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Friendly name shown in the UI.
    :vartype display_name: str
    :ivar name_properties_name: Name of the quota.
    :vartype name_properties_name: str
    :ivar resource_name: Name of the quota resource.
    :vartype resource_name: str
    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: int
    :ivar limit: The resource limit.
    :vartype limit: int
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar compute_mode: Compute mode used for this usage. Known values are: "Shared", "Dedicated",
     and "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2016_09_01.models.ComputeModeOptions
    :ivar site_mode: Site mode used for this usage.
    :vartype site_mode: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "name_properties_name": {"readonly": True},
        "resource_name": {"readonly": True},
        "unit": {"readonly": True},
        "current_value": {"readonly": True},
        "limit": {"readonly": True},
        "next_reset_time": {"readonly": True},
        "compute_mode": {"readonly": True},
        "site_mode": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "resource_name": {"key": "properties.resourceName", "type": "str"},
        "unit": {"key": "properties.unit", "type": "str"},
        "current_value": {"key": "properties.currentValue", "type": "int"},
        "limit": {"key": "properties.limit", "type": "int"},
        "next_reset_time": {"key": "properties.nextResetTime", "type": "iso-8601"},
        "compute_mode": {"key": "properties.computeMode", "type": "str"},
        "site_mode": {"key": "properties.siteMode", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.display_name = None
        self.name_properties_name = None
        self.resource_name = None
        self.unit = None
        self.current_value = None
        self.limit = None
        self.next_reset_time = None
        self.compute_mode = None
        self.site_mode = None


class UsageCollection(_serialization.Model):
    """Collection of usages.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_09_01.models.Usage]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Usage"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_09_01.models.Usage]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualApplication(_serialization.Model):
    """Virtual application in an app.

    :ivar virtual_path: Virtual path.
    :vartype virtual_path: str
    :ivar physical_path: Physical path.
    :vartype physical_path: str
    :ivar preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype preload_enabled: bool
    :ivar virtual_directories: Virtual directories for virtual application.
    :vartype virtual_directories: list[~azure.mgmt.web.v2016_09_01.models.VirtualDirectory]
    """

    _attribute_map = {
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "physical_path": {"key": "physicalPath", "type": "str"},
        "preload_enabled": {"key": "preloadEnabled", "type": "bool"},
        "virtual_directories": {"key": "virtualDirectories", "type": "[VirtualDirectory]"},
    }

    def __init__(
        self,
        *,
        virtual_path: Optional[str] = None,
        physical_path: Optional[str] = None,
        preload_enabled: Optional[bool] = None,
        virtual_directories: Optional[List["_models.VirtualDirectory"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_path: Virtual path.
        :paramtype virtual_path: str
        :keyword physical_path: Physical path.
        :paramtype physical_path: str
        :keyword preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype preload_enabled: bool
        :keyword virtual_directories: Virtual directories for virtual application.
        :paramtype virtual_directories: list[~azure.mgmt.web.v2016_09_01.models.VirtualDirectory]
        """
        super().__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path
        self.preload_enabled = preload_enabled
        self.virtual_directories = virtual_directories


class VirtualDirectory(_serialization.Model):
    """Directory for virtual application.

    :ivar virtual_path: Path to virtual application.
    :vartype virtual_path: str
    :ivar physical_path: Physical path.
    :vartype physical_path: str
    """

    _attribute_map = {
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "physical_path": {"key": "physicalPath", "type": "str"},
    }

    def __init__(
        self, *, virtual_path: Optional[str] = None, physical_path: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword virtual_path: Path to virtual application.
        :paramtype virtual_path: str
        :keyword physical_path: Physical path.
        :paramtype physical_path: str
        """
        super().__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path


class VirtualIPMapping(_serialization.Model):
    """Virtual IP mapping.

    :ivar virtual_ip: Virtual IP address.
    :vartype virtual_ip: str
    :ivar internal_http_port: Internal HTTP port.
    :vartype internal_http_port: int
    :ivar internal_https_port: Internal HTTPS port.
    :vartype internal_https_port: int
    :ivar in_use: Is virtual IP mapping in use.
    :vartype in_use: bool
    """

    _attribute_map = {
        "virtual_ip": {"key": "virtualIP", "type": "str"},
        "internal_http_port": {"key": "internalHttpPort", "type": "int"},
        "internal_https_port": {"key": "internalHttpsPort", "type": "int"},
        "in_use": {"key": "inUse", "type": "bool"},
    }

    def __init__(
        self,
        *,
        virtual_ip: Optional[str] = None,
        internal_http_port: Optional[int] = None,
        internal_https_port: Optional[int] = None,
        in_use: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_ip: Virtual IP address.
        :paramtype virtual_ip: str
        :keyword internal_http_port: Internal HTTP port.
        :paramtype internal_http_port: int
        :keyword internal_https_port: Internal HTTPS port.
        :paramtype internal_https_port: int
        :keyword in_use: Is virtual IP mapping in use.
        :paramtype in_use: bool
        """
        super().__init__(**kwargs)
        self.virtual_ip = virtual_ip
        self.internal_http_port = internal_http_port
        self.internal_https_port = internal_https_port
        self.in_use = in_use


class VirtualNetworkProfile(_serialization.Model):
    """Specification for using a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id of the Virtual Network.
    :vartype id: str
    :ivar name: Name of the Virtual Network (read-only).
    :vartype name: str
    :ivar type: Resource type of the Virtual Network (read-only).
    :vartype type: str
    :ivar subnet: Subnet within the Virtual Network.
    :vartype subnet: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet": {"key": "subnet", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        subnet: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource id of the Virtual Network.
        :paramtype id: str
        :keyword subnet: Subnet within the Virtual Network.
        :paramtype subnet: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.subnet = subnet


class VnetGateway(ProxyOnlyResource):
    """The Virtual Network gateway contract. This is used to give the Virtual Network gateway access
    to the VPN package.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_name: The Virtual Network name.
    :vartype vnet_name: str
    :ivar vpn_package_uri: The URI where the VPN package can be downloaded.
    :vartype vpn_package_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "vpn_package_uri": {"key": "properties.vpnPackageUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vpn_package_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_name: The Virtual Network name.
        :paramtype vnet_name: str
        :keyword vpn_package_uri: The URI where the VPN package can be downloaded.
        :paramtype vpn_package_uri: str
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_name = vnet_name
        self.vpn_package_uri = vpn_package_uri


class VnetInfo(ProxyOnlyResource):
    """Virtual Network information contract.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_resource_id: The Virtual Network's resource ID.
    :vartype vnet_resource_id: str
    :ivar cert_thumbprint: The client certificate thumbprint.
    :vartype cert_thumbprint: str
    :ivar cert_blob: A certificate file (.cer) blob containing the public key of the private key
     used to authenticate a
     Point-To-Site VPN connection.
    :vartype cert_blob: bytes
    :ivar routes: The routes that this Virtual Network connection uses.
    :vartype routes: list[~azure.mgmt.web.v2016_09_01.models.VnetRoute]
    :ivar resync_required: :code:`<code>true</code>` if a resync is required; otherwise,
     :code:`<code>false</code>`.
    :vartype resync_required: bool
    :ivar dns_servers: DNS servers to be used by this Virtual Network. This should be a
     comma-separated list of IP addresses.
    :vartype dns_servers: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "cert_thumbprint": {"readonly": True},
        "routes": {"readonly": True},
        "resync_required": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_resource_id": {"key": "properties.vnetResourceId", "type": "str"},
        "cert_thumbprint": {"key": "properties.certThumbprint", "type": "str"},
        "cert_blob": {"key": "properties.certBlob", "type": "bytearray"},
        "routes": {"key": "properties.routes", "type": "[VnetRoute]"},
        "resync_required": {"key": "properties.resyncRequired", "type": "bool"},
        "dns_servers": {"key": "properties.dnsServers", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_resource_id: Optional[str] = None,
        cert_blob: Optional[bytes] = None,
        dns_servers: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_resource_id: The Virtual Network's resource ID.
        :paramtype vnet_resource_id: str
        :keyword cert_blob: A certificate file (.cer) blob containing the public key of the private key
         used to authenticate a
         Point-To-Site VPN connection.
        :paramtype cert_blob: bytes
        :keyword dns_servers: DNS servers to be used by this Virtual Network. This should be a
         comma-separated list of IP addresses.
        :paramtype dns_servers: str
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_resource_id = vnet_resource_id
        self.cert_thumbprint = None
        self.cert_blob = cert_blob
        self.routes = None
        self.resync_required = None
        self.dns_servers = dns_servers


class VnetRoute(ProxyOnlyResource):
    """Virtual Network route contract used to pass routing information for a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_route_name: The name of this route. This is only returned by the server and does not
     need to be set by the client.
    :vartype vnet_route_name: str
    :ivar start_address: The starting address for this route. This may also include a CIDR
     notation, in which case the end address must not be specified.
    :vartype start_address: str
    :ivar end_address: The ending address for this route. If the start address is specified in CIDR
     notation, this must be omitted.
    :vartype end_address: str
    :ivar route_type: The type of route this is:
     DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     INHERITED - Routes inherited from the real Virtual Network routes
     STATIC - Static route set on the app only

     These values will be used for syncing an app's routes with those from a Virtual Network. Known
     values are: "DEFAULT", "INHERITED", and "STATIC".
    :vartype route_type: str or ~azure.mgmt.web.v2016_09_01.models.RouteType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_route_name": {"key": "properties.name", "type": "str"},
        "start_address": {"key": "properties.startAddress", "type": "str"},
        "end_address": {"key": "properties.endAddress", "type": "str"},
        "route_type": {"key": "properties.routeType", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_route_name: Optional[str] = None,
        start_address: Optional[str] = None,
        end_address: Optional[str] = None,
        route_type: Optional[Union[str, "_models.RouteType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_route_name: The name of this route. This is only returned by the server and does
         not need to be set by the client.
        :paramtype vnet_route_name: str
        :keyword start_address: The starting address for this route. This may also include a CIDR
         notation, in which case the end address must not be specified.
        :paramtype start_address: str
        :keyword end_address: The ending address for this route. If the start address is specified in
         CIDR notation, this must be omitted.
        :paramtype end_address: str
        :keyword route_type: The type of route this is:
         DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
         INHERITED - Routes inherited from the real Virtual Network routes
         STATIC - Static route set on the app only

         These values will be used for syncing an app's routes with those from a Virtual Network. Known
         values are: "DEFAULT", "INHERITED", and "STATIC".
        :paramtype route_type: str or ~azure.mgmt.web.v2016_09_01.models.RouteType
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_route_name = vnet_route_name
        self.start_address = start_address
        self.end_address = end_address
        self.route_type = route_type


class WebAppCollection(_serialization.Model):
    """Collection of App Service apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_09_01.models.Site]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Site]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Site"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_09_01.models.Site]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class WorkerPool(_serialization.Model):
    """Worker pool of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar worker_size_id: Worker size ID for referencing this worker pool.
    :vartype worker_size_id: int
    :ivar compute_mode: Shared or dedicated app hosting. Known values are: "Shared", "Dedicated",
     and "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2016_09_01.models.ComputeModeOptions
    :ivar worker_size: VM size of the worker pool instances.
    :vartype worker_size: str
    :ivar worker_count: Number of instances in the worker pool.
    :vartype worker_count: int
    :ivar instance_names: Names of all instances in the worker pool (read only).
    :vartype instance_names: list[str]
    """

    _validation = {
        "instance_names": {"readonly": True},
    }

    _attribute_map = {
        "worker_size_id": {"key": "workerSizeId", "type": "int"},
        "compute_mode": {"key": "computeMode", "type": "str"},
        "worker_size": {"key": "workerSize", "type": "str"},
        "worker_count": {"key": "workerCount", "type": "int"},
        "instance_names": {"key": "instanceNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        worker_size_id: Optional[int] = None,
        compute_mode: Optional[Union[str, "_models.ComputeModeOptions"]] = None,
        worker_size: Optional[str] = None,
        worker_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword worker_size_id: Worker size ID for referencing this worker pool.
        :paramtype worker_size_id: int
        :keyword compute_mode: Shared or dedicated app hosting. Known values are: "Shared",
         "Dedicated", and "Dynamic".
        :paramtype compute_mode: str or ~azure.mgmt.web.v2016_09_01.models.ComputeModeOptions
        :keyword worker_size: VM size of the worker pool instances.
        :paramtype worker_size: str
        :keyword worker_count: Number of instances in the worker pool.
        :paramtype worker_count: int
        """
        super().__init__(**kwargs)
        self.worker_size_id = worker_size_id
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_count = worker_count
        self.instance_names = None


class WorkerPoolCollection(_serialization.Model):
    """Collection of worker pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_09_01.models.WorkerPoolResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkerPoolResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.WorkerPoolResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_09_01.models.WorkerPoolResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class WorkerPoolResource(ProxyOnlyResource):
    """Worker pool of an App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sku: Description of a SKU for a scalable resource.
    :vartype sku: ~azure.mgmt.web.v2016_09_01.models.SkuDescription
    :ivar worker_size_id: Worker size ID for referencing this worker pool.
    :vartype worker_size_id: int
    :ivar compute_mode: Shared or dedicated app hosting. Known values are: "Shared", "Dedicated",
     and "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2016_09_01.models.ComputeModeOptions
    :ivar worker_size: VM size of the worker pool instances.
    :vartype worker_size: str
    :ivar worker_count: Number of instances in the worker pool.
    :vartype worker_count: int
    :ivar instance_names: Names of all instances in the worker pool (read only).
    :vartype instance_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "instance_names": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "sku", "type": "SkuDescription"},
        "worker_size_id": {"key": "properties.workerSizeId", "type": "int"},
        "compute_mode": {"key": "properties.computeMode", "type": "str"},
        "worker_size": {"key": "properties.workerSize", "type": "str"},
        "worker_count": {"key": "properties.workerCount", "type": "int"},
        "instance_names": {"key": "properties.instanceNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional["_models.SkuDescription"] = None,
        worker_size_id: Optional[int] = None,
        compute_mode: Optional[Union[str, "_models.ComputeModeOptions"]] = None,
        worker_size: Optional[str] = None,
        worker_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword sku: Description of a SKU for a scalable resource.
        :paramtype sku: ~azure.mgmt.web.v2016_09_01.models.SkuDescription
        :keyword worker_size_id: Worker size ID for referencing this worker pool.
        :paramtype worker_size_id: int
        :keyword compute_mode: Shared or dedicated app hosting. Known values are: "Shared",
         "Dedicated", and "Dynamic".
        :paramtype compute_mode: str or ~azure.mgmt.web.v2016_09_01.models.ComputeModeOptions
        :keyword worker_size: VM size of the worker pool instances.
        :paramtype worker_size: str
        :keyword worker_count: Number of instances in the worker pool.
        :paramtype worker_count: int
        """
        super().__init__(kind=kind, **kwargs)
        self.sku = sku
        self.worker_size_id = worker_size_id
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_count = worker_count
        self.instance_names = None
