# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class DevicePropertiesFormat(_serialization.Model):
    """Device properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureStackEdgeFormat

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: The current device status. Known values are: "Unknown", "NotRegistered",
     "Registered", and "Deleted".
    :vartype status: str or ~azure.mgmt.hybridnetwork.models.Status
    :ivar provisioning_state: The provisioning state of the device resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.hybridnetwork.models.ProvisioningState
    :ivar device_type: The type of the device. Required. Known values are: "Unknown" and
     "AzureStackEdge".
    :vartype device_type: str or ~azure.mgmt.hybridnetwork.models.DeviceType
    :ivar network_functions: The list of network functions deployed on the device.
    :vartype network_functions: list[~azure.mgmt.hybridnetwork.models.SubResource]
    """

    _validation = {
        "status": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "device_type": {"required": True},
        "network_functions": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "network_functions": {"key": "networkFunctions", "type": "[SubResource]"},
    }

    _subtype_map = {"device_type": {"AzureStackEdge": "AzureStackEdgeFormat"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.provisioning_state = None
        self.device_type: Optional[str] = None
        self.network_functions = None


class AzureStackEdgeFormat(DevicePropertiesFormat):
    """The reference to the Azure stack edge device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: The current device status. Known values are: "Unknown", "NotRegistered",
     "Registered", and "Deleted".
    :vartype status: str or ~azure.mgmt.hybridnetwork.models.Status
    :ivar provisioning_state: The provisioning state of the device resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.hybridnetwork.models.ProvisioningState
    :ivar device_type: The type of the device. Required. Known values are: "Unknown" and
     "AzureStackEdge".
    :vartype device_type: str or ~azure.mgmt.hybridnetwork.models.DeviceType
    :ivar network_functions: The list of network functions deployed on the device.
    :vartype network_functions: list[~azure.mgmt.hybridnetwork.models.SubResource]
    :ivar azure_stack_edge: The reference to the Azure stack edge device. Required.
    :vartype azure_stack_edge: ~azure.mgmt.hybridnetwork.models.SubResource
    """

    _validation = {
        "status": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "device_type": {"required": True},
        "network_functions": {"readonly": True},
        "azure_stack_edge": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "network_functions": {"key": "networkFunctions", "type": "[SubResource]"},
        "azure_stack_edge": {"key": "azureStackEdge", "type": "SubResource"},
    }

    def __init__(self, *, azure_stack_edge: "_models.SubResource", **kwargs):
        """
        :keyword azure_stack_edge: The reference to the Azure stack edge device. Required.
        :paramtype azure_stack_edge: ~azure.mgmt.hybridnetwork.models.SubResource
        """
        super().__init__(**kwargs)
        self.device_type: str = "AzureStackEdge"
        self.azure_stack_edge = azure_stack_edge


class CustomProfile(_serialization.Model):
    """Specifies the custom settings for the virtual machine.

    :ivar metadata_configuration_path: Path for metadata configuration.
    :vartype metadata_configuration_path: str
    """

    _attribute_map = {
        "metadata_configuration_path": {"key": "metadataConfigurationPath", "type": "str"},
    }

    def __init__(self, *, metadata_configuration_path: Optional[str] = None, **kwargs):
        """
        :keyword metadata_configuration_path: Path for metadata configuration.
        :paramtype metadata_configuration_path: str
        """
        super().__init__(**kwargs)
        self.metadata_configuration_path = metadata_configuration_path


class DataDisk(_serialization.Model):
    """Specifies information about the operating system disk used by the virtual machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.

    :ivar create_option: Specifies how the virtual machine should be created. Known values are:
     "Unknown" and "Empty".
    :vartype create_option: str or ~azure.mgmt.hybridnetwork.models.DiskCreateOptionTypes
    :ivar name: The name of data disk.
    :vartype name: str
    :ivar disk_size_gb: Specifies the size of an empty disk in gigabytes. This element can be used
     to overwrite the size of the disk in a virtual machine image.
    :vartype disk_size_gb: int
    """

    _attribute_map = {
        "create_option": {"key": "createOption", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
    }

    def __init__(
        self,
        *,
        create_option: Optional[Union[str, "_models.DiskCreateOptionTypes"]] = None,
        name: Optional[str] = None,
        disk_size_gb: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword create_option: Specifies how the virtual machine should be created. Known values are:
         "Unknown" and "Empty".
        :paramtype create_option: str or ~azure.mgmt.hybridnetwork.models.DiskCreateOptionTypes
        :keyword name: The name of data disk.
        :paramtype name: str
        :keyword disk_size_gb: Specifies the size of an empty disk in gigabytes. This element can be
         used to overwrite the size of the disk in a virtual machine image.
        :paramtype disk_size_gb: int
        """
        super().__init__(**kwargs)
        self.create_option = create_option
        self.name = name
        self.disk_size_gb = disk_size_gb


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Device(TrackedResource):
    """Device resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridnetwork.models.SystemData
    :ivar status: The current device status. Known values are: "Unknown", "NotRegistered",
     "Registered", and "Deleted".
    :vartype status: str or ~azure.mgmt.hybridnetwork.models.Status
    :ivar provisioning_state: The provisioning state of the device resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.hybridnetwork.models.ProvisioningState
    :ivar device_type: The type of the device. Known values are: "Unknown" and "AzureStackEdge".
    :vartype device_type: str or ~azure.mgmt.hybridnetwork.models.DeviceType
    :ivar network_functions: The list of network functions deployed on the device.
    :vartype network_functions: list[~azure.mgmt.hybridnetwork.models.SubResource]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "status": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "network_functions": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "status": {"key": "properties.status", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "device_type": {"key": "properties.deviceType", "type": "str"},
        "network_functions": {"key": "properties.networkFunctions", "type": "[SubResource]"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.status = None
        self.provisioning_state = None
        self.device_type: Optional[str] = None
        self.network_functions = None


class DeviceListResult(_serialization.Model):
    """Response for devices API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of devices.
    :vartype value: list[~azure.mgmt.hybridnetwork.models.Device]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Device]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Device"]] = None, **kwargs):
        """
        :keyword value: A list of devices.
        :paramtype value: list[~azure.mgmt.hybridnetwork.models.Device]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DeviceRegistrationKey(_serialization.Model):
    """The device registration key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar registration_key: The registration key for the device.
    :vartype registration_key: str
    """

    _validation = {
        "registration_key": {"readonly": True},
    }

    _attribute_map = {
        "registration_key": {"key": "registrationKey", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.registration_key = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.hybridnetwork.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.hybridnetwork.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.hybridnetwork.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.hybridnetwork.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExecuteRequestParameters(_serialization.Model):
    """Payload for execute request post call.

    All required parameters must be populated in order to send to Azure.

    :ivar service_endpoint: The endpoint of service to call. Required.
    :vartype service_endpoint: str
    :ivar request_metadata: The request metadata. Required.
    :vartype request_metadata: ~azure.mgmt.hybridnetwork.models.RequestMetadata
    """

    _validation = {
        "service_endpoint": {"required": True},
        "request_metadata": {"required": True},
    }

    _attribute_map = {
        "service_endpoint": {"key": "serviceEndpoint", "type": "str"},
        "request_metadata": {"key": "requestMetadata", "type": "RequestMetadata"},
    }

    def __init__(self, *, service_endpoint: str, request_metadata: "_models.RequestMetadata", **kwargs):
        """
        :keyword service_endpoint: The endpoint of service to call. Required.
        :paramtype service_endpoint: str
        :keyword request_metadata: The request metadata. Required.
        :paramtype request_metadata: ~azure.mgmt.hybridnetwork.models.RequestMetadata
        """
        super().__init__(**kwargs)
        self.service_endpoint = service_endpoint
        self.request_metadata = request_metadata


class ImageReference(_serialization.Model):
    """The image reference properties.

    :ivar publisher: The image publisher.
    :vartype publisher: str
    :ivar offer: Specifies the offer of the image used to create the virtual machine.
    :vartype offer: str
    :ivar sku: The image SKU.
    :vartype sku: str
    :ivar version: Specifies the version of the image used to create the virtual machine. The
     allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers.
     Specify 'latest' to use the latest version of an image available at deploy time. Even if you
     use 'latest', the VM image will not automatically update after deploy time even if a new
     version becomes available.
    :vartype version: str
    :ivar exact_version: Specifies in decimal numbers, the exact version of image used to create
     the virtual machine.
    :vartype exact_version: str
    """

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "exact_version": {"key": "exactVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        exact_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword publisher: The image publisher.
        :paramtype publisher: str
        :keyword offer: Specifies the offer of the image used to create the virtual machine.
        :paramtype offer: str
        :keyword sku: The image SKU.
        :paramtype sku: str
        :keyword version: Specifies the version of the image used to create the virtual machine. The
         allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers.
         Specify 'latest' to use the latest version of an image available at deploy time. Even if you
         use 'latest', the VM image will not automatically update after deploy time even if a new
         version becomes available.
        :paramtype version: str
        :keyword exact_version: Specifies in decimal numbers, the exact version of image used to create
         the virtual machine.
        :paramtype exact_version: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version
        self.exact_version = exact_version


class LinuxConfiguration(_serialization.Model):
    """Specifies the Linux operating system settings on the virtual machine.

    :ivar ssh: Specifies the ssh key configuration for a Linux OS.
    :vartype ssh: ~azure.mgmt.hybridnetwork.models.SshConfiguration
    """

    _attribute_map = {
        "ssh": {"key": "ssh", "type": "SshConfiguration"},
    }

    def __init__(self, *, ssh: Optional["_models.SshConfiguration"] = None, **kwargs):
        """
        :keyword ssh: Specifies the ssh key configuration for a Linux OS.
        :paramtype ssh: ~azure.mgmt.hybridnetwork.models.SshConfiguration
        """
        super().__init__(**kwargs)
        self.ssh = ssh


class NetworkFunction(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Network function resource response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridnetwork.models.SystemData
    :ivar provisioning_state: The provisioning state of the network function resource. Known values
     are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.hybridnetwork.models.ProvisioningState
    :ivar device: The reference to the device resource. Once set, it cannot be updated.
    :vartype device: ~azure.mgmt.hybridnetwork.models.SubResource
    :ivar sku_name: The sku name for the network function. Once set, it cannot be updated.
    :vartype sku_name: str
    :ivar sku_type: The sku type for the network function. Known values are: "Unknown",
     "EvolvedPacketCore", "SDWAN", and "Firewall".
    :vartype sku_type: str or ~azure.mgmt.hybridnetwork.models.SkuType
    :ivar vendor_name: The vendor name for the network function. Once set, it cannot be updated.
    :vartype vendor_name: str
    :ivar service_key: The service key for the network function resource.
    :vartype service_key: str
    :ivar vendor_provisioning_state: The vendor provisioning state for the network function
     resource. Known values are: "Unknown", "NotProvisioned", "Provisioning", "Provisioned",
     "Deprovisioned", and "UserDataValidationFailed".
    :vartype vendor_provisioning_state: str or
     ~azure.mgmt.hybridnetwork.models.VendorProvisioningState
    :ivar managed_application: The resource URI of the managed application.
    :vartype managed_application: ~azure.mgmt.hybridnetwork.models.SubResource
    :ivar managed_application_parameters: The parameters for the managed application.
    :vartype managed_application_parameters: JSON
    :ivar network_function_container_configurations: The network function container configurations
     from the user.
    :vartype network_function_container_configurations: JSON
    :ivar network_function_user_configurations: The network function configurations from the user.
    :vartype network_function_user_configurations:
     list[~azure.mgmt.hybridnetwork.models.NetworkFunctionUserConfiguration]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "sku_type": {"readonly": True},
        "service_key": {"readonly": True},
        "vendor_provisioning_state": {"readonly": True},
        "managed_application": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "device": {"key": "properties.device", "type": "SubResource"},
        "sku_name": {"key": "properties.skuName", "type": "str"},
        "sku_type": {"key": "properties.skuType", "type": "str"},
        "vendor_name": {"key": "properties.vendorName", "type": "str"},
        "service_key": {"key": "properties.serviceKey", "type": "str"},
        "vendor_provisioning_state": {"key": "properties.vendorProvisioningState", "type": "str"},
        "managed_application": {"key": "properties.managedApplication", "type": "SubResource"},
        "managed_application_parameters": {"key": "properties.managedApplicationParameters", "type": "object"},
        "network_function_container_configurations": {
            "key": "properties.networkFunctionContainerConfigurations",
            "type": "object",
        },
        "network_function_user_configurations": {
            "key": "properties.networkFunctionUserConfigurations",
            "type": "[NetworkFunctionUserConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        device: Optional["_models.SubResource"] = None,
        sku_name: Optional[str] = None,
        vendor_name: Optional[str] = None,
        managed_application_parameters: Optional[JSON] = None,
        network_function_container_configurations: Optional[JSON] = None,
        network_function_user_configurations: Optional[List["_models.NetworkFunctionUserConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword device: The reference to the device resource. Once set, it cannot be updated.
        :paramtype device: ~azure.mgmt.hybridnetwork.models.SubResource
        :keyword sku_name: The sku name for the network function. Once set, it cannot be updated.
        :paramtype sku_name: str
        :keyword vendor_name: The vendor name for the network function. Once set, it cannot be updated.
        :paramtype vendor_name: str
        :keyword managed_application_parameters: The parameters for the managed application.
        :paramtype managed_application_parameters: JSON
        :keyword network_function_container_configurations: The network function container
         configurations from the user.
        :paramtype network_function_container_configurations: JSON
        :keyword network_function_user_configurations: The network function configurations from the
         user.
        :paramtype network_function_user_configurations:
         list[~azure.mgmt.hybridnetwork.models.NetworkFunctionUserConfiguration]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.etag = etag
        self.system_data = None
        self.provisioning_state = None
        self.device = device
        self.sku_name = sku_name
        self.sku_type = None
        self.vendor_name = vendor_name
        self.service_key = None
        self.vendor_provisioning_state = None
        self.managed_application = None
        self.managed_application_parameters = managed_application_parameters
        self.network_function_container_configurations = network_function_container_configurations
        self.network_function_user_configurations = network_function_user_configurations


class NetworkFunctionListResult(_serialization.Model):
    """Response for network function API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of network function resources in a subscription or resource group.
    :vartype value: list[~azure.mgmt.hybridnetwork.models.NetworkFunction]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkFunction]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.NetworkFunction"]] = None, **kwargs):
        """
        :keyword value: A list of network function resources in a subscription or resource group.
        :paramtype value: list[~azure.mgmt.hybridnetwork.models.NetworkFunction]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkFunctionRoleConfiguration(_serialization.Model):
    """Network function role configuration.

    :ivar role_name: The name of the network function role.
    :vartype role_name: str
    :ivar role_type: Role type. Known values are: "Unknown" and "VirtualMachine".
    :vartype role_type: str or
     ~azure.mgmt.hybridnetwork.models.NetworkFunctionRoleConfigurationType
    :ivar virtual_machine_size: The size of the virtual machine. Known values are: "Unknown",
     "Standard_D1_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2",
     "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_DS1_v2", "Standard_DS2_v2",
     "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2",
     "Standard_DS12_v2", "Standard_DS13_v2", "Standard_F1", "Standard_F2", "Standard_F4",
     "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
     and "Standard_F16s".
    :vartype virtual_machine_size: str or ~azure.mgmt.hybridnetwork.models.VirtualMachineSizeTypes
    :ivar os_profile: Specifies the operating system settings for the role instance. This value can
     be updated during the deployment of network function.
    :vartype os_profile: ~azure.mgmt.hybridnetwork.models.OsProfile
    :ivar user_data_template: The user data template for customers. This is a json schema template
     describing the format and data type of user data parameters.
    :vartype user_data_template: JSON
    :ivar user_data_parameters: The user parameters for customers. The format of user data
     parameters has to be matched with the provided user data template.
    :vartype user_data_parameters: JSON
    :ivar network_interfaces: The network interface configurations.
    :vartype network_interfaces: list[~azure.mgmt.hybridnetwork.models.NetworkInterface]
    :ivar storage_profile: Specifies the storage settings for the virtual machine disks.
    :vartype storage_profile: ~azure.mgmt.hybridnetwork.models.StorageProfile
    :ivar custom_profile: Specifies the custom settings for the virtual machine.
    :vartype custom_profile: ~azure.mgmt.hybridnetwork.models.CustomProfile
    """

    _attribute_map = {
        "role_name": {"key": "roleName", "type": "str"},
        "role_type": {"key": "roleType", "type": "str"},
        "virtual_machine_size": {"key": "virtualMachineSize", "type": "str"},
        "os_profile": {"key": "osProfile", "type": "OsProfile"},
        "user_data_template": {"key": "userDataTemplate", "type": "object"},
        "user_data_parameters": {"key": "userDataParameters", "type": "object"},
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterface]"},
        "storage_profile": {"key": "storageProfile", "type": "StorageProfile"},
        "custom_profile": {"key": "customProfile", "type": "CustomProfile"},
    }

    def __init__(
        self,
        *,
        role_name: Optional[str] = None,
        role_type: Optional[Union[str, "_models.NetworkFunctionRoleConfigurationType"]] = None,
        virtual_machine_size: Optional[Union[str, "_models.VirtualMachineSizeTypes"]] = None,
        os_profile: Optional["_models.OsProfile"] = None,
        user_data_template: Optional[JSON] = None,
        user_data_parameters: Optional[JSON] = None,
        network_interfaces: Optional[List["_models.NetworkInterface"]] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        custom_profile: Optional["_models.CustomProfile"] = None,
        **kwargs
    ):
        """
        :keyword role_name: The name of the network function role.
        :paramtype role_name: str
        :keyword role_type: Role type. Known values are: "Unknown" and "VirtualMachine".
        :paramtype role_type: str or
         ~azure.mgmt.hybridnetwork.models.NetworkFunctionRoleConfigurationType
        :keyword virtual_machine_size: The size of the virtual machine. Known values are: "Unknown",
         "Standard_D1_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2",
         "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_DS1_v2", "Standard_DS2_v2",
         "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2",
         "Standard_DS12_v2", "Standard_DS13_v2", "Standard_F1", "Standard_F2", "Standard_F4",
         "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
         and "Standard_F16s".
        :paramtype virtual_machine_size: str or
         ~azure.mgmt.hybridnetwork.models.VirtualMachineSizeTypes
        :keyword os_profile: Specifies the operating system settings for the role instance. This value
         can be updated during the deployment of network function.
        :paramtype os_profile: ~azure.mgmt.hybridnetwork.models.OsProfile
        :keyword user_data_template: The user data template for customers. This is a json schema
         template describing the format and data type of user data parameters.
        :paramtype user_data_template: JSON
        :keyword user_data_parameters: The user parameters for customers. The format of user data
         parameters has to be matched with the provided user data template.
        :paramtype user_data_parameters: JSON
        :keyword network_interfaces: The network interface configurations.
        :paramtype network_interfaces: list[~azure.mgmt.hybridnetwork.models.NetworkInterface]
        :keyword storage_profile: Specifies the storage settings for the virtual machine disks.
        :paramtype storage_profile: ~azure.mgmt.hybridnetwork.models.StorageProfile
        :keyword custom_profile: Specifies the custom settings for the virtual machine.
        :paramtype custom_profile: ~azure.mgmt.hybridnetwork.models.CustomProfile
        """
        super().__init__(**kwargs)
        self.role_name = role_name
        self.role_type = role_type
        self.virtual_machine_size = virtual_machine_size
        self.os_profile = os_profile
        self.user_data_template = user_data_template
        self.user_data_parameters = user_data_parameters
        self.network_interfaces = network_interfaces
        self.storage_profile = storage_profile
        self.custom_profile = custom_profile


class NetworkFunctionRoleInstanceListResult(_serialization.Model):
    """List of role instances of vendor network function.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of role instances.
    :vartype value: list[~azure.mgmt.hybridnetwork.models.RoleInstance]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RoleInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class NetworkFunctionSkuDetails(_serialization.Model):
    """The network function sku details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku_type: The network function sku type. Known values are: "Unknown",
     "EvolvedPacketCore", "SDWAN", and "Firewall".
    :vartype sku_type: str or ~azure.mgmt.hybridnetwork.models.SkuType
    :ivar value: The network function sku role details.
    :vartype value: list[~azure.mgmt.hybridnetwork.models.NetworkFunctionSkuRoleDetails]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "sku_type": {"key": "skuType", "type": "str"},
        "value": {"key": "value", "type": "[NetworkFunctionSkuRoleDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        sku_type: Optional[Union[str, "_models.SkuType"]] = None,
        value: Optional[List["_models.NetworkFunctionSkuRoleDetails"]] = None,
        **kwargs
    ):
        """
        :keyword sku_type: The network function sku type. Known values are: "Unknown",
         "EvolvedPacketCore", "SDWAN", and "Firewall".
        :paramtype sku_type: str or ~azure.mgmt.hybridnetwork.models.SkuType
        :keyword value: The network function sku role details.
        :paramtype value: list[~azure.mgmt.hybridnetwork.models.NetworkFunctionSkuRoleDetails]
        """
        super().__init__(**kwargs)
        self.sku_type = sku_type
        self.value = value
        self.next_link = None


class NetworkFunctionSkuListResult(_serialization.Model):
    """A list of available network function skus.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The network function vendor sku overview properties.
    :vartype value: list[~azure.mgmt.hybridnetwork.models.SkuOverview]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SkuOverview]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.SkuOverview"]] = None, **kwargs):
        """
        :keyword value: The network function vendor sku overview properties.
        :paramtype value: list[~azure.mgmt.hybridnetwork.models.SkuOverview]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkFunctionSkuRoleDetails(_serialization.Model):
    """The network function user configuration.

    :ivar role_name: The name of the network function role.
    :vartype role_name: str
    :ivar user_data_template: The user data template for customers.
    :vartype user_data_template: JSON
    :ivar user_data_parameters: The user parameters for customers.
    :vartype user_data_parameters: JSON
    :ivar network_interfaces: The network interface configuration.
    :vartype network_interfaces: list[~azure.mgmt.hybridnetwork.models.NetworkInterface]
    """

    _attribute_map = {
        "role_name": {"key": "roleName", "type": "str"},
        "user_data_template": {"key": "userDataTemplate", "type": "object"},
        "user_data_parameters": {"key": "userDataParameters", "type": "object"},
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterface]"},
    }

    def __init__(
        self,
        *,
        role_name: Optional[str] = None,
        user_data_template: Optional[JSON] = None,
        user_data_parameters: Optional[JSON] = None,
        network_interfaces: Optional[List["_models.NetworkInterface"]] = None,
        **kwargs
    ):
        """
        :keyword role_name: The name of the network function role.
        :paramtype role_name: str
        :keyword user_data_template: The user data template for customers.
        :paramtype user_data_template: JSON
        :keyword user_data_parameters: The user parameters for customers.
        :paramtype user_data_parameters: JSON
        :keyword network_interfaces: The network interface configuration.
        :paramtype network_interfaces: list[~azure.mgmt.hybridnetwork.models.NetworkInterface]
        """
        super().__init__(**kwargs)
        self.role_name = role_name
        self.user_data_template = user_data_template
        self.user_data_parameters = user_data_parameters
        self.network_interfaces = network_interfaces


class NetworkFunctionTemplate(_serialization.Model):
    """The network function template.

    :ivar network_function_role_configurations: An array of network function role definitions.
    :vartype network_function_role_configurations:
     list[~azure.mgmt.hybridnetwork.models.NetworkFunctionRoleConfiguration]
    """

    _attribute_map = {
        "network_function_role_configurations": {
            "key": "networkFunctionRoleConfigurations",
            "type": "[NetworkFunctionRoleConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        network_function_role_configurations: Optional[List["_models.NetworkFunctionRoleConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword network_function_role_configurations: An array of network function role definitions.
        :paramtype network_function_role_configurations:
         list[~azure.mgmt.hybridnetwork.models.NetworkFunctionRoleConfiguration]
        """
        super().__init__(**kwargs)
        self.network_function_role_configurations = network_function_role_configurations


class NetworkFunctionUserConfiguration(_serialization.Model):
    """The network function user configuration.

    :ivar role_name: The name of the network function role.
    :vartype role_name: str
    :ivar user_data_parameters: The user data parameters from the customer.
    :vartype user_data_parameters: JSON
    :ivar network_interfaces: The network interface configuration.
    :vartype network_interfaces: list[~azure.mgmt.hybridnetwork.models.NetworkInterface]
    :ivar os_profile: Specifies the operating system settings for the role instance.
    :vartype os_profile: ~azure.mgmt.hybridnetwork.models.NetworkFunctionUserConfigurationOsProfile
    """

    _attribute_map = {
        "role_name": {"key": "roleName", "type": "str"},
        "user_data_parameters": {"key": "userDataParameters", "type": "object"},
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterface]"},
        "os_profile": {"key": "osProfile", "type": "NetworkFunctionUserConfigurationOsProfile"},
    }

    def __init__(
        self,
        *,
        role_name: Optional[str] = None,
        user_data_parameters: Optional[JSON] = None,
        network_interfaces: Optional[List["_models.NetworkInterface"]] = None,
        os_profile: Optional["_models.NetworkFunctionUserConfigurationOsProfile"] = None,
        **kwargs
    ):
        """
        :keyword role_name: The name of the network function role.
        :paramtype role_name: str
        :keyword user_data_parameters: The user data parameters from the customer.
        :paramtype user_data_parameters: JSON
        :keyword network_interfaces: The network interface configuration.
        :paramtype network_interfaces: list[~azure.mgmt.hybridnetwork.models.NetworkInterface]
        :keyword os_profile: Specifies the operating system settings for the role instance.
        :paramtype os_profile:
         ~azure.mgmt.hybridnetwork.models.NetworkFunctionUserConfigurationOsProfile
        """
        super().__init__(**kwargs)
        self.role_name = role_name
        self.user_data_parameters = user_data_parameters
        self.network_interfaces = network_interfaces
        self.os_profile = os_profile


class NetworkFunctionUserConfigurationOsProfile(_serialization.Model):
    """Specifies the operating system settings for the role instance.

    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the virtual machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` **Note: Do not pass any
     secrets or passwords in customData property** :code:`<br>`:code:`<br>` This property cannot be
     updated after the VM is created. :code:`<br>`:code:`<br>` customData is passed to the VM to be
     saved as a file. For more information see `Custom Data on Azure VMs
     <https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/>`_
     :code:`<br>`:code:`<br>` For using cloud-init for your Linux VM, see `Using cloud-init to
     customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype custom_data: str
    """

    _attribute_map = {
        "custom_data": {"key": "customData", "type": "str"},
    }

    def __init__(self, *, custom_data: Optional[str] = None, **kwargs):
        """
        :keyword custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
         string is decoded to a binary array that is saved as a file on the virtual machine. The maximum
         length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` **Note: Do not pass any
         secrets or passwords in customData property** :code:`<br>`:code:`<br>` This property cannot be
         updated after the VM is created. :code:`<br>`:code:`<br>` customData is passed to the VM to be
         saved as a file. For more information see `Custom Data on Azure VMs
         <https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/>`_
         :code:`<br>`:code:`<br>` For using cloud-init for your Linux VM, see `Using cloud-init to
         customize a Linux VM during creation
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype custom_data: str
        """
        super().__init__(**kwargs)
        self.custom_data = custom_data


class NetworkFunctionVendor(_serialization.Model):
    """The network function vendor.

    :ivar vendor_name: The network function vendor name.
    :vartype vendor_name: str
    :ivar sku_list: The network function sku list.
    :vartype sku_list: list[~azure.mgmt.hybridnetwork.models.SkuOverview]
    """

    _attribute_map = {
        "vendor_name": {"key": "properties.vendorName", "type": "str"},
        "sku_list": {"key": "properties.skuList", "type": "[SkuOverview]"},
    }

    def __init__(
        self, *, vendor_name: Optional[str] = None, sku_list: Optional[List["_models.SkuOverview"]] = None, **kwargs
    ):
        """
        :keyword vendor_name: The network function vendor name.
        :paramtype vendor_name: str
        :keyword sku_list: The network function sku list.
        :paramtype sku_list: list[~azure.mgmt.hybridnetwork.models.SkuOverview]
        """
        super().__init__(**kwargs)
        self.vendor_name = vendor_name
        self.sku_list = sku_list


class NetworkFunctionVendorConfiguration(_serialization.Model):
    """Network function vendor configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar role_name: The name of the vendor network function role.
    :vartype role_name: str
    :ivar os_profile: Specifies the operating system settings for the role instance.
    :vartype os_profile: ~azure.mgmt.hybridnetwork.models.OsProfile
    :ivar user_data_parameters: The user parameters from the customer.
    :vartype user_data_parameters: JSON
    :ivar network_interfaces: The network interface configurations.
    :vartype network_interfaces: list[~azure.mgmt.hybridnetwork.models.NetworkInterface]
    """

    _validation = {
        "user_data_parameters": {"readonly": True},
    }

    _attribute_map = {
        "role_name": {"key": "roleName", "type": "str"},
        "os_profile": {"key": "osProfile", "type": "OsProfile"},
        "user_data_parameters": {"key": "userDataParameters", "type": "object"},
        "network_interfaces": {"key": "networkInterfaces", "type": "[NetworkInterface]"},
    }

    def __init__(
        self,
        *,
        role_name: Optional[str] = None,
        os_profile: Optional["_models.OsProfile"] = None,
        network_interfaces: Optional[List["_models.NetworkInterface"]] = None,
        **kwargs
    ):
        """
        :keyword role_name: The name of the vendor network function role.
        :paramtype role_name: str
        :keyword os_profile: Specifies the operating system settings for the role instance.
        :paramtype os_profile: ~azure.mgmt.hybridnetwork.models.OsProfile
        :keyword network_interfaces: The network interface configurations.
        :paramtype network_interfaces: list[~azure.mgmt.hybridnetwork.models.NetworkInterface]
        """
        super().__init__(**kwargs)
        self.role_name = role_name
        self.os_profile = os_profile
        self.user_data_parameters = None
        self.network_interfaces = network_interfaces


class NetworkFunctionVendorListResult(_serialization.Model):
    """The network function vendor list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of available network function vendors and skus.
    :vartype value: list[~azure.mgmt.hybridnetwork.models.NetworkFunctionVendor]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkFunctionVendor]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.NetworkFunctionVendor"]] = None, **kwargs):
        """
        :keyword value: A list of available network function vendors and skus.
        :paramtype value: list[~azure.mgmt.hybridnetwork.models.NetworkFunctionVendor]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class NetworkInterface(_serialization.Model):
    """Network interface properties.

    :ivar network_interface_name: The name of the network interface.
    :vartype network_interface_name: str
    :ivar mac_address: The MAC address of the network interface.
    :vartype mac_address: str
    :ivar ip_configurations: A list of IP configurations of the network interface.
    :vartype ip_configurations:
     list[~azure.mgmt.hybridnetwork.models.NetworkInterfaceIPConfiguration]
    :ivar vm_switch_type: The type of the VM switch. Known values are: "Unknown", "Management",
     "Wan", and "Lan".
    :vartype vm_switch_type: str or ~azure.mgmt.hybridnetwork.models.VMSwitchType
    """

    _attribute_map = {
        "network_interface_name": {"key": "networkInterfaceName", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "ip_configurations": {"key": "ipConfigurations", "type": "[NetworkInterfaceIPConfiguration]"},
        "vm_switch_type": {"key": "vmSwitchType", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_interface_name: Optional[str] = None,
        mac_address: Optional[str] = None,
        ip_configurations: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None,
        vm_switch_type: Optional[Union[str, "_models.VMSwitchType"]] = None,
        **kwargs
    ):
        """
        :keyword network_interface_name: The name of the network interface.
        :paramtype network_interface_name: str
        :keyword mac_address: The MAC address of the network interface.
        :paramtype mac_address: str
        :keyword ip_configurations: A list of IP configurations of the network interface.
        :paramtype ip_configurations:
         list[~azure.mgmt.hybridnetwork.models.NetworkInterfaceIPConfiguration]
        :keyword vm_switch_type: The type of the VM switch. Known values are: "Unknown", "Management",
         "Wan", and "Lan".
        :paramtype vm_switch_type: str or ~azure.mgmt.hybridnetwork.models.VMSwitchType
        """
        super().__init__(**kwargs)
        self.network_interface_name = network_interface_name
        self.mac_address = mac_address
        self.ip_configurations = ip_configurations
        self.vm_switch_type = vm_switch_type


class NetworkInterfaceIPConfiguration(_serialization.Model):
    """Network interface IP configuration properties.

    :ivar ip_allocation_method: IP address allocation method. Known values are: "Unknown",
     "Static", and "Dynamic".
    :vartype ip_allocation_method: str or ~azure.mgmt.hybridnetwork.models.IPAllocationMethod
    :ivar ip_address: The value of the IP address.
    :vartype ip_address: str
    :ivar subnet: The value of the subnet.
    :vartype subnet: str
    :ivar gateway: The value of the gateway.
    :vartype gateway: str
    :ivar ip_version: IP address version. Known values are: "Unknown" and "IPv4".
    :vartype ip_version: str or ~azure.mgmt.hybridnetwork.models.IPVersion
    :ivar dns_servers: The list of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "ip_allocation_method": {"key": "ipAllocationMethod", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "subnet": {"key": "subnet", "type": "str"},
        "gateway": {"key": "gateway", "type": "str"},
        "ip_version": {"key": "ipVersion", "type": "str"},
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        ip_address: Optional[str] = None,
        subnet: Optional[str] = None,
        gateway: Optional[str] = None,
        ip_version: Optional[Union[str, "_models.IPVersion"]] = None,
        dns_servers: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword ip_allocation_method: IP address allocation method. Known values are: "Unknown",
         "Static", and "Dynamic".
        :paramtype ip_allocation_method: str or ~azure.mgmt.hybridnetwork.models.IPAllocationMethod
        :keyword ip_address: The value of the IP address.
        :paramtype ip_address: str
        :keyword subnet: The value of the subnet.
        :paramtype subnet: str
        :keyword gateway: The value of the gateway.
        :paramtype gateway: str
        :keyword ip_version: IP address version. Known values are: "Unknown" and "IPv4".
        :paramtype ip_version: str or ~azure.mgmt.hybridnetwork.models.IPVersion
        :keyword dns_servers: The list of DNS servers IP addresses.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.ip_allocation_method = ip_allocation_method
        self.ip_address = ip_address
        self.subnet = subnet
        self.gateway = gateway
        self.ip_version = ip_version
        self.dns_servers = dns_servers


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.hybridnetwork.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.hybridnetwork.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.hybridnetwork.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.hybridnetwork.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.hybridnetwork.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OsDisk(_serialization.Model):
    """Specifies information about the operating system disk used by the virtual machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.

    :ivar os_type: The OS type. Known values are: "Unknown", "Windows", and "Linux".
    :vartype os_type: str or ~azure.mgmt.hybridnetwork.models.OperatingSystemTypes
    :ivar name: The VHD name.
    :vartype name: str
    :ivar vhd: The virtual hard disk.
    :vartype vhd: ~azure.mgmt.hybridnetwork.models.VirtualHardDisk
    :ivar disk_size_gb: Specifies the size of os disk in gigabytes. This is the fully expanded disk
     size needed of the VHD image on the ASE. This disk size should be greater than the size of the
     VHD provided in vhdUri.
    :vartype disk_size_gb: int
    """

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "vhd": {"key": "vhd", "type": "VirtualHardDisk"},
        "disk_size_gb": {"key": "diskSizeGB", "type": "int"},
    }

    def __init__(
        self,
        *,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        name: Optional[str] = None,
        vhd: Optional["_models.VirtualHardDisk"] = None,
        disk_size_gb: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword os_type: The OS type. Known values are: "Unknown", "Windows", and "Linux".
        :paramtype os_type: str or ~azure.mgmt.hybridnetwork.models.OperatingSystemTypes
        :keyword name: The VHD name.
        :paramtype name: str
        :keyword vhd: The virtual hard disk.
        :paramtype vhd: ~azure.mgmt.hybridnetwork.models.VirtualHardDisk
        :keyword disk_size_gb: Specifies the size of os disk in gigabytes. This is the fully expanded
         disk size needed of the VHD image on the ASE. This disk size should be greater than the size of
         the VHD provided in vhdUri.
        :paramtype disk_size_gb: int
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.name = name
        self.vhd = vhd
        self.disk_size_gb = disk_size_gb


class OsProfile(_serialization.Model):
    """Specifies the operating system settings for the role instance.

    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     **Windows-only restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character
     :code:`<br>`:code:`<br>` **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>`
     **Max-length (Windows):** 20 characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access
     to the Linux VM, see `Using root privileges on Linux virtual machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_\
     :code:`<br>`:code:`<li>` For a list of built-in system users on Linux that should not be used
     in this field, see `Selecting User Names for Linux on Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype admin_username: str
    :ivar linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_
     :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for
     Non-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype linux_configuration: ~azure.mgmt.hybridnetwork.models.LinuxConfiguration
    :ivar custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the virtual machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` **Note: Do not pass any
     secrets or passwords in customData property** :code:`<br>`:code:`<br>` This property cannot be
     updated after the VM is created. :code:`<br>`:code:`<br>` customData is passed to the VM to be
     saved as a file. For more information see `Custom Data on Azure VMs
     <https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/>`_
     :code:`<br>`:code:`<br>` For using cloud-init for your Linux VM, see `Using cloud-init to
     customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype custom_data: str
    :ivar custom_data_required: Indicates if custom data is required to deploy this role.
    :vartype custom_data_required: bool
    """

    _attribute_map = {
        "admin_username": {"key": "adminUsername", "type": "str"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "LinuxConfiguration"},
        "custom_data": {"key": "customData", "type": "str"},
        "custom_data_required": {"key": "customDataRequired", "type": "bool"},
    }

    def __init__(
        self,
        *,
        admin_username: Optional[str] = None,
        linux_configuration: Optional["_models.LinuxConfiguration"] = None,
        custom_data: Optional[str] = None,
        custom_data_required: bool = True,
        **kwargs
    ):
        """
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
         :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
         "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
         "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
         "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
         :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
         **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
         characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access to the Linux VM, see `Using
         root privileges on Linux virtual machines in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_\
         :code:`<br>`:code:`<li>` For a list of built-in system users on Linux that should not be used
         in this field, see `Selecting User Names for Linux on Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype admin_username: str
        :keyword linux_configuration: Specifies the Linux operating system settings on the virtual
         machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
         Azure-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_
         :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for
         Non-Endorsed Distributions
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype linux_configuration: ~azure.mgmt.hybridnetwork.models.LinuxConfiguration
        :keyword custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
         string is decoded to a binary array that is saved as a file on the virtual machine. The maximum
         length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` **Note: Do not pass any
         secrets or passwords in customData property** :code:`<br>`:code:`<br>` This property cannot be
         updated after the VM is created. :code:`<br>`:code:`<br>` customData is passed to the VM to be
         saved as a file. For more information see `Custom Data on Azure VMs
         <https://azure.microsoft.com/en-us/blog/custom-data-and-cloud-init-on-windows-azure/>`_
         :code:`<br>`:code:`<br>` For using cloud-init for your Linux VM, see `Using cloud-init to
         customize a Linux VM during creation
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype custom_data: str
        :keyword custom_data_required: Indicates if custom data is required to deploy this role.
        :paramtype custom_data_required: bool
        """
        super().__init__(**kwargs)
        self.admin_username = admin_username
        self.linux_configuration = linux_configuration
        self.custom_data = custom_data
        self.custom_data_required = custom_data_required


class PreviewSubscription(_serialization.Model):
    """Customer subscription which can use a sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The preview subscription ID.
    :vartype name: str
    :ivar id: The ARM ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridnetwork.models.SystemData
    :ivar provisioning_state: The provisioning state of the PreviewSubscription resource. Known
     values are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and
     "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.hybridnetwork.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.system_data = None
        self.provisioning_state = None


class PreviewSubscriptionsList(_serialization.Model):
    """A list of customer subscriptions which can use a sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of preview subscriptions.
    :vartype value: list[~azure.mgmt.hybridnetwork.models.PreviewSubscription]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PreviewSubscription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PreviewSubscription"]] = None, **kwargs):
        """
        :keyword value: A list of preview subscriptions.
        :paramtype value: list[~azure.mgmt.hybridnetwork.models.PreviewSubscription]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class RequestMetadata(_serialization.Model):
    """Request metadata of execute request post call payload.

    All required parameters must be populated in order to send to Azure.

    :ivar relative_path: The relative path of the request. Required.
    :vartype relative_path: str
    :ivar http_method: The http method of the request. Required. Known values are: "Unknown",
     "Post", "Put", "Get", "Patch", and "Delete".
    :vartype http_method: str or ~azure.mgmt.hybridnetwork.models.HttpMethod
    :ivar serialized_body: The serialized body of the request. Required.
    :vartype serialized_body: str
    :ivar api_version: The api version of the request.
    :vartype api_version: str
    """

    _validation = {
        "relative_path": {"required": True},
        "http_method": {"required": True},
        "serialized_body": {"required": True},
    }

    _attribute_map = {
        "relative_path": {"key": "relativePath", "type": "str"},
        "http_method": {"key": "httpMethod", "type": "str"},
        "serialized_body": {"key": "serializedBody", "type": "str"},
        "api_version": {"key": "apiVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        relative_path: str,
        http_method: Union[str, "_models.HttpMethod"],
        serialized_body: str,
        api_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword relative_path: The relative path of the request. Required.
        :paramtype relative_path: str
        :keyword http_method: The http method of the request. Required. Known values are: "Unknown",
         "Post", "Put", "Get", "Patch", and "Delete".
        :paramtype http_method: str or ~azure.mgmt.hybridnetwork.models.HttpMethod
        :keyword serialized_body: The serialized body of the request. Required.
        :paramtype serialized_body: str
        :keyword api_version: The api version of the request.
        :paramtype api_version: str
        """
        super().__init__(**kwargs)
        self.relative_path = relative_path
        self.http_method = http_method
        self.serialized_body = serialized_body
        self.api_version = api_version


class RoleInstance(_serialization.Model):
    """The role instance sub resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The role instance name.
    :vartype name: str
    :ivar id: The ARM ID of the resource.
    :vartype id: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridnetwork.models.SystemData
    :ivar provisioning_state: The provisioning state of the RoleInstance resource. Known values
     are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.hybridnetwork.models.ProvisioningState
    :ivar operational_state: The operational state of the role instance. Known values are:
     "Unknown", "Stopped", "Running", "Stopping", and "Starting".
    :vartype operational_state: str or ~azure.mgmt.hybridnetwork.models.OperationalState
    """

    _validation = {
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "operational_state": {"key": "properties.operationalState", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        operational_state: Optional[Union[str, "_models.OperationalState"]] = None,
        **kwargs
    ):
        """
        :keyword name: The role instance name.
        :paramtype name: str
        :keyword id: The ARM ID of the resource.
        :paramtype id: str
        :keyword type: The type of the resource.
        :paramtype type: str
        :keyword operational_state: The operational state of the role instance. Known values are:
         "Unknown", "Stopped", "Running", "Stopping", and "Starting".
        :paramtype operational_state: str or ~azure.mgmt.hybridnetwork.models.OperationalState
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.system_data = None
        self.provisioning_state = None
        self.operational_state = operational_state


class SkuCredential(_serialization.Model):
    """The Sku credential definition.

    :ivar username: The username of the sku credential.
    :vartype username: str
    :ivar acr_token: The credential value.
    :vartype acr_token: str
    :ivar acr_server_url: The Acr server url.
    :vartype acr_server_url: str
    :ivar repositories: The repositories that could be accessed using the current credential.
    :vartype repositories: list[str]
    :ivar expiry: The UTC time when credential will expire.
    :vartype expiry: ~datetime.datetime
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "acr_token": {"key": "acrToken", "type": "str"},
        "acr_server_url": {"key": "acrServerUrl", "type": "str"},
        "repositories": {"key": "repositories", "type": "[str]"},
        "expiry": {"key": "expiry", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        acr_token: Optional[str] = None,
        acr_server_url: Optional[str] = None,
        repositories: Optional[List[str]] = None,
        expiry: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword username: The username of the sku credential.
        :paramtype username: str
        :keyword acr_token: The credential value.
        :paramtype acr_token: str
        :keyword acr_server_url: The Acr server url.
        :paramtype acr_server_url: str
        :keyword repositories: The repositories that could be accessed using the current credential.
        :paramtype repositories: list[str]
        :keyword expiry: The UTC time when credential will expire.
        :paramtype expiry: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.username = username
        self.acr_token = acr_token
        self.acr_server_url = acr_server_url
        self.repositories = repositories
        self.expiry = expiry


class SkuOverview(_serialization.Model):
    """The network function sku overview.

    :ivar sku_name: The vendor sku name.
    :vartype sku_name: str
    :ivar sku_type: The vendor sku type. Known values are: "Unknown", "EvolvedPacketCore", "SDWAN",
     and "Firewall".
    :vartype sku_type: str or ~azure.mgmt.hybridnetwork.models.SkuType
    """

    _attribute_map = {
        "sku_name": {"key": "skuName", "type": "str"},
        "sku_type": {"key": "skuType", "type": "str"},
    }

    def __init__(
        self, *, sku_name: Optional[str] = None, sku_type: Optional[Union[str, "_models.SkuType"]] = None, **kwargs
    ):
        """
        :keyword sku_name: The vendor sku name.
        :paramtype sku_name: str
        :keyword sku_type: The vendor sku type. Known values are: "Unknown", "EvolvedPacketCore",
         "SDWAN", and "Firewall".
        :paramtype sku_type: str or ~azure.mgmt.hybridnetwork.models.SkuType
        """
        super().__init__(**kwargs)
        self.sku_name = sku_name
        self.sku_type = sku_type


class SshConfiguration(_serialization.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :ivar public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :vartype public_keys: list[~azure.mgmt.hybridnetwork.models.SshPublicKey]
    """

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[SshPublicKey]"},
    }

    def __init__(self, *, public_keys: Optional[List["_models.SshPublicKey"]] = None, **kwargs):
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        :paramtype public_keys: list[~azure.mgmt.hybridnetwork.models.SshPublicKey]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys


class SshPublicKey(_serialization.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.

    :ivar path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :vartype path: str
    :ivar key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
     ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :vartype key_data: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, path: Optional[str] = None, key_data: Optional[str] = None, **kwargs):
        """
        :keyword path: Specifies the full path on the created VM where ssh public key is stored. If the
         file already exists, the specified key is appended to the file. Example:
         /home/user/.ssh/authorized_keys.
        :paramtype path: str
        :keyword key_data: SSH public key certificate used to authenticate with the VM through ssh. The
         key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
         ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
         <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.key_data = key_data


class StorageProfile(_serialization.Model):
    """Specifies the storage settings for the virtual machine disks.

    :ivar image_reference: The image reference properties.
    :vartype image_reference: ~azure.mgmt.hybridnetwork.models.ImageReference
    :ivar os_disk: Specifies information about the operating system disk used by the virtual
     machine.
    :vartype os_disk: ~azure.mgmt.hybridnetwork.models.OsDisk
    :ivar data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine.
    :vartype data_disks: list[~azure.mgmt.hybridnetwork.models.DataDisk]
    """

    _attribute_map = {
        "image_reference": {"key": "imageReference", "type": "ImageReference"},
        "os_disk": {"key": "osDisk", "type": "OsDisk"},
        "data_disks": {"key": "dataDisks", "type": "[DataDisk]"},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["_models.ImageReference"] = None,
        os_disk: Optional["_models.OsDisk"] = None,
        data_disks: Optional[List["_models.DataDisk"]] = None,
        **kwargs
    ):
        """
        :keyword image_reference: The image reference properties.
        :paramtype image_reference: ~azure.mgmt.hybridnetwork.models.ImageReference
        :keyword os_disk: Specifies information about the operating system disk used by the virtual
         machine.
        :paramtype os_disk: ~azure.mgmt.hybridnetwork.models.OsDisk
        :keyword data_disks: Specifies the parameters that are used to add a data disk to a virtual
         machine.
        :paramtype data_disks: list[~azure.mgmt.hybridnetwork.models.DataDisk]
        """
        super().__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class SubResource(_serialization.Model):
    """Reference to another sub resource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.hybridnetwork.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.hybridnetwork.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.hybridnetwork.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.hybridnetwork.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsObject(_serialization.Model):
    """Tags object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class Vendor(ProxyResource):
    """Vendor resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridnetwork.models.SystemData
    :ivar provisioning_state: The provisioning state of the vendor resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.hybridnetwork.models.ProvisioningState
    :ivar skus: A list of IDs of the vendor skus offered by the vendor.
    :vartype skus: list[~azure.mgmt.hybridnetwork.models.SubResource]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "skus": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "skus": {"key": "properties.skus", "type": "[SubResource]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.skus = None


class VendorListResult(_serialization.Model):
    """Response for vendors API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of vendors.
    :vartype value: list[~azure.mgmt.hybridnetwork.models.Vendor]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Vendor]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Vendor"]] = None, **kwargs):
        """
        :keyword value: A list of vendors.
        :paramtype value: list[~azure.mgmt.hybridnetwork.models.Vendor]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VendorNetworkFunction(ProxyResource):
    """Vendor network function sub resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridnetwork.models.SystemData
    :ivar provisioning_state: The provisioning state of the vendor network function sub resource.
     Known values are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and
     "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.hybridnetwork.models.ProvisioningState
    :ivar vendor_provisioning_state: The vendor controlled provisioning state of the vendor network
     function. Known values are: "Unknown", "NotProvisioned", "Provisioning", "Provisioned",
     "Deprovisioned", and "UserDataValidationFailed".
    :vartype vendor_provisioning_state: str or
     ~azure.mgmt.hybridnetwork.models.VendorProvisioningState
    :ivar sku_name: The name of the sku. Once set, it cannot be updated.
    :vartype sku_name: str
    :ivar sku_type: The sku type. Known values are: "Unknown", "EvolvedPacketCore", "SDWAN", and
     "Firewall".
    :vartype sku_type: str or ~azure.mgmt.hybridnetwork.models.SkuType
    :ivar network_function_vendor_configurations: An array of network function vendor
     configurations.
    :vartype network_function_vendor_configurations:
     list[~azure.mgmt.hybridnetwork.models.NetworkFunctionVendorConfiguration]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "sku_name": {"readonly": True},
        "sku_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "vendor_provisioning_state": {"key": "properties.vendorProvisioningState", "type": "str"},
        "sku_name": {"key": "properties.skuName", "type": "str"},
        "sku_type": {"key": "properties.skuType", "type": "str"},
        "network_function_vendor_configurations": {
            "key": "properties.networkFunctionVendorConfigurations",
            "type": "[NetworkFunctionVendorConfiguration]",
        },
    }

    def __init__(
        self,
        *,
        vendor_provisioning_state: Optional[Union[str, "_models.VendorProvisioningState"]] = None,
        network_function_vendor_configurations: Optional[List["_models.NetworkFunctionVendorConfiguration"]] = None,
        **kwargs
    ):
        """
        :keyword vendor_provisioning_state: The vendor controlled provisioning state of the vendor
         network function. Known values are: "Unknown", "NotProvisioned", "Provisioning", "Provisioned",
         "Deprovisioned", and "UserDataValidationFailed".
        :paramtype vendor_provisioning_state: str or
         ~azure.mgmt.hybridnetwork.models.VendorProvisioningState
        :keyword network_function_vendor_configurations: An array of network function vendor
         configurations.
        :paramtype network_function_vendor_configurations:
         list[~azure.mgmt.hybridnetwork.models.NetworkFunctionVendorConfiguration]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.vendor_provisioning_state = vendor_provisioning_state
        self.sku_name = None
        self.sku_type = None
        self.network_function_vendor_configurations = network_function_vendor_configurations


class VendorNetworkFunctionListResult(_serialization.Model):
    """Response for vendors API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of vendor network functions.
    :vartype value: list[~azure.mgmt.hybridnetwork.models.VendorNetworkFunction]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VendorNetworkFunction]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VendorNetworkFunction"]] = None, **kwargs):
        """
        :keyword value: A list of vendor network functions.
        :paramtype value: list[~azure.mgmt.hybridnetwork.models.VendorNetworkFunction]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VendorSku(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Sku sub resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridnetwork.models.SystemData
    :ivar provisioning_state: The provisioning state of the vendor sku sub resource. Known values
     are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.hybridnetwork.models.ProvisioningState
    :ivar sku_type: The sku type. Known values are: "Unknown", "EvolvedPacketCore", "SDWAN", and
     "Firewall".
    :vartype sku_type: str or ~azure.mgmt.hybridnetwork.models.SkuType
    :ivar deployment_mode: The sku deployment mode. Known values are: "Unknown", "Azure", and
     "PrivateEdgeZone".
    :vartype deployment_mode: str or ~azure.mgmt.hybridnetwork.models.SkuDeploymentMode
    :ivar network_function_type: The network function type. Known values are: "Unknown",
     "VirtualNetworkFunction", and "ContainerizedNetworkFunction".
    :vartype network_function_type: str or ~azure.mgmt.hybridnetwork.models.NetworkFunctionType
    :ivar preview: Indicates if the vendor sku is in preview mode.
    :vartype preview: bool
    :ivar managed_application_parameters: The parameters for the managed application to be supplied
     by the vendor.
    :vartype managed_application_parameters: JSON
    :ivar managed_application_template: The template for the managed application deployment.
    :vartype managed_application_template: JSON
    :ivar network_function_template: The template definition of the network function.
    :vartype network_function_template: ~azure.mgmt.hybridnetwork.models.NetworkFunctionTemplate
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sku_type": {"key": "properties.skuType", "type": "str"},
        "deployment_mode": {"key": "properties.deploymentMode", "type": "str"},
        "network_function_type": {"key": "properties.networkFunctionType", "type": "str"},
        "preview": {"key": "properties.preview", "type": "bool"},
        "managed_application_parameters": {"key": "properties.managedApplicationParameters", "type": "object"},
        "managed_application_template": {"key": "properties.managedApplicationTemplate", "type": "object"},
        "network_function_template": {"key": "properties.networkFunctionTemplate", "type": "NetworkFunctionTemplate"},
    }

    def __init__(
        self,
        *,
        sku_type: Optional[Union[str, "_models.SkuType"]] = None,
        deployment_mode: Optional[Union[str, "_models.SkuDeploymentMode"]] = None,
        network_function_type: Optional[Union[str, "_models.NetworkFunctionType"]] = None,
        preview: Optional[bool] = None,
        managed_application_parameters: Optional[JSON] = None,
        managed_application_template: Optional[JSON] = None,
        network_function_template: Optional["_models.NetworkFunctionTemplate"] = None,
        **kwargs
    ):
        """
        :keyword sku_type: The sku type. Known values are: "Unknown", "EvolvedPacketCore", "SDWAN", and
         "Firewall".
        :paramtype sku_type: str or ~azure.mgmt.hybridnetwork.models.SkuType
        :keyword deployment_mode: The sku deployment mode. Known values are: "Unknown", "Azure", and
         "PrivateEdgeZone".
        :paramtype deployment_mode: str or ~azure.mgmt.hybridnetwork.models.SkuDeploymentMode
        :keyword network_function_type: The network function type. Known values are: "Unknown",
         "VirtualNetworkFunction", and "ContainerizedNetworkFunction".
        :paramtype network_function_type: str or ~azure.mgmt.hybridnetwork.models.NetworkFunctionType
        :keyword preview: Indicates if the vendor sku is in preview mode.
        :paramtype preview: bool
        :keyword managed_application_parameters: The parameters for the managed application to be
         supplied by the vendor.
        :paramtype managed_application_parameters: JSON
        :keyword managed_application_template: The template for the managed application deployment.
        :paramtype managed_application_template: JSON
        :keyword network_function_template: The template definition of the network function.
        :paramtype network_function_template: ~azure.mgmt.hybridnetwork.models.NetworkFunctionTemplate
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.sku_type = sku_type
        self.deployment_mode = deployment_mode
        self.network_function_type = network_function_type
        self.preview = preview
        self.managed_application_parameters = managed_application_parameters
        self.managed_application_template = managed_application_template
        self.network_function_template = network_function_template


class VendorSkuListResult(_serialization.Model):
    """Response for list vendor sku API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of vendor skus offered by the vendor.
    :vartype value: list[~azure.mgmt.hybridnetwork.models.VendorSku]
    :ivar next_link: The URI to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VendorSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VendorSku"]] = None, **kwargs):
        """
        :keyword value: A list of vendor skus offered by the vendor.
        :paramtype value: list[~azure.mgmt.hybridnetwork.models.VendorSku]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VirtualHardDisk(_serialization.Model):
    """Describes the uri of a disk.

    :ivar uri: Specifies the virtual hard disk's uri.
    :vartype uri: str
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(self, *, uri: Optional[str] = None, **kwargs):
        """
        :keyword uri: Specifies the virtual hard disk's uri.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.uri = uri
