# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g. "Microsoft.SignalRService/SignalR".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than
    required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g. "Microsoft.SignalRService/SignalR".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class CustomCertificate(ProxyResource):
    """A custom certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g. "Microsoft.SignalRService/SignalR".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.signalr.models.SystemData
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Running", "Creating", "Updating", "Deleting", and "Moving".
    :vartype provisioning_state: str or ~azure.mgmt.signalr.models.ProvisioningState
    :ivar key_vault_base_uri: Base uri of the KeyVault that stores certificate. Required.
    :vartype key_vault_base_uri: str
    :ivar key_vault_secret_name: Certificate secret name. Required.
    :vartype key_vault_secret_name: str
    :ivar key_vault_secret_version: Certificate secret version.
    :vartype key_vault_secret_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "key_vault_base_uri": {"required": True},
        "key_vault_secret_name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "key_vault_base_uri": {"key": "properties.keyVaultBaseUri", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "key_vault_secret_version": {"key": "properties.keyVaultSecretVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_vault_base_uri: str,
        key_vault_secret_name: str,
        key_vault_secret_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_base_uri: Base uri of the KeyVault that stores certificate. Required.
        :paramtype key_vault_base_uri: str
        :keyword key_vault_secret_name: Certificate secret name. Required.
        :paramtype key_vault_secret_name: str
        :keyword key_vault_secret_version: Certificate secret version.
        :paramtype key_vault_secret_version: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.key_vault_base_uri = key_vault_base_uri
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_version = key_vault_secret_version


class CustomCertificateList(_serialization.Model):
    """Custom certificates list.

    :ivar value: List of custom certificates of this resource.
    :vartype value: list[~azure.mgmt.signalr.models.CustomCertificate]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomCertificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.CustomCertificate"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of custom certificates of this resource.
        :paramtype value: list[~azure.mgmt.signalr.models.CustomCertificate]
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CustomDomain(ProxyResource):
    """A custom domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g. "Microsoft.SignalRService/SignalR".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.signalr.models.SystemData
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Running", "Creating", "Updating", "Deleting", and "Moving".
    :vartype provisioning_state: str or ~azure.mgmt.signalr.models.ProvisioningState
    :ivar domain_name: The custom domain name. Required.
    :vartype domain_name: str
    :ivar custom_certificate: Reference to a resource. Required.
    :vartype custom_certificate: ~azure.mgmt.signalr.models.ResourceReference
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "domain_name": {"required": True},
        "custom_certificate": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "domain_name": {"key": "properties.domainName", "type": "str"},
        "custom_certificate": {"key": "properties.customCertificate", "type": "ResourceReference"},
    }

    def __init__(self, *, domain_name: str, custom_certificate: "_models.ResourceReference", **kwargs: Any) -> None:
        """
        :keyword domain_name: The custom domain name. Required.
        :paramtype domain_name: str
        :keyword custom_certificate: Reference to a resource. Required.
        :paramtype custom_certificate: ~azure.mgmt.signalr.models.ResourceReference
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.domain_name = domain_name
        self.custom_certificate = custom_certificate


class CustomDomainList(_serialization.Model):
    """Custom domains list.

    :ivar value: List of custom domains that bind to this resource.
    :vartype value: list[~azure.mgmt.signalr.models.CustomDomain]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomDomain]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.CustomDomain"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of custom domains that bind to this resource.
        :paramtype value: list[~azure.mgmt.signalr.models.CustomDomain]
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Dimension(_serialization.Model):
    """Specifications of the Dimension of metrics.

    :ivar name: The public facing name of the dimension.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the dimension.
    :vartype display_name: str
    :ivar internal_name: Name of the dimension as it appears in MDM.
    :vartype internal_name: str
    :ivar to_be_exported_for_shoebox: A Boolean flag indicating whether this dimension should be
     included for the shoebox export scenario.
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The public facing name of the dimension.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the dimension.
        :paramtype display_name: str
        :keyword internal_name: Name of the dimension as it appears in MDM.
        :paramtype internal_name: str
        :keyword to_be_exported_for_shoebox: A Boolean flag indicating whether this dimension should be
         included for the shoebox export scenario.
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.signalr.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.signalr.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.signalr.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.signalr.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class LiveTraceCategory(_serialization.Model):
    """Live trace category configuration of a Microsoft.SignalRService resource.

    :ivar name: Gets or sets the live trace category's name.
     Available values: ConnectivityLogs, MessagingLogs.
     Case insensitive.
    :vartype name: str
    :ivar enabled: Indicates whether or the live trace category is enabled.
     Available values: true, false.
     Case insensitive.
    :vartype enabled: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "enabled": {"key": "enabled", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, enabled: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Gets or sets the live trace category's name.
         Available values: ConnectivityLogs, MessagingLogs.
         Case insensitive.
        :paramtype name: str
        :keyword enabled: Indicates whether or the live trace category is enabled.
         Available values: true, false.
         Case insensitive.
        :paramtype enabled: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.enabled = enabled


class LiveTraceConfiguration(_serialization.Model):
    """Live trace configuration of a Microsoft.SignalRService resource.

    :ivar enabled: Indicates whether or not enable live trace.
     When it's set to true, live trace client can connect to the service.
     Otherwise, live trace client can't connect to the service, so that you are unable to receive
     any log, no matter what you configure in "categories".
     Available values: true, false.
     Case insensitive.
    :vartype enabled: str
    :ivar categories: Gets or sets the list of category configurations.
    :vartype categories: list[~azure.mgmt.signalr.models.LiveTraceCategory]
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "str"},
        "categories": {"key": "categories", "type": "[LiveTraceCategory]"},
    }

    def __init__(
        self, *, enabled: str = "false", categories: Optional[List["_models.LiveTraceCategory"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Indicates whether or not enable live trace.
         When it's set to true, live trace client can connect to the service.
         Otherwise, live trace client can't connect to the service, so that you are unable to receive
         any log, no matter what you configure in "categories".
         Available values: true, false.
         Case insensitive.
        :paramtype enabled: str
        :keyword categories: Gets or sets the list of category configurations.
        :paramtype categories: list[~azure.mgmt.signalr.models.LiveTraceCategory]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.categories = categories


class LogSpecification(_serialization.Model):
    """Specifications of the Logs for Azure Monitoring.

    :ivar name: Name of the log.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the log.
    :vartype display_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, display_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the log.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the log.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class ManagedIdentity(_serialization.Model):
    """A class represent managed identities used for request and response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Represents the identity type: systemAssigned, userAssigned, None. Known values are:
     "None", "SystemAssigned", and "UserAssigned".
    :vartype type: str or ~azure.mgmt.signalr.models.ManagedIdentityType
    :ivar user_assigned_identities: Get or set the user assigned identities.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.signalr.models.UserAssignedIdentityProperty]
    :ivar principal_id: Get the principal id for the system assigned identity.
     Only be used in response.
    :vartype principal_id: str
    :ivar tenant_id: Get the tenant id for the system assigned identity.
     Only be used in response.
    :vartype tenant_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentityProperty}"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentityProperty"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Represents the identity type: systemAssigned, userAssigned, None. Known values
         are: "None", "SystemAssigned", and "UserAssigned".
        :paramtype type: str or ~azure.mgmt.signalr.models.ManagedIdentityType
        :keyword user_assigned_identities: Get or set the user assigned identities.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.signalr.models.UserAssignedIdentityProperty]
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned_identities = user_assigned_identities
        self.principal_id = None
        self.tenant_id = None


class ManagedIdentitySettings(_serialization.Model):
    """Managed identity settings for upstream.

    :ivar resource: The Resource indicating the App ID URI of the target resource.
     It also appears in the aud (audience) claim of the issued token.
    :vartype resource: str
    """

    _attribute_map = {
        "resource": {"key": "resource", "type": "str"},
    }

    def __init__(self, *, resource: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource: The Resource indicating the App ID URI of the target resource.
         It also appears in the aud (audience) claim of the issued token.
        :paramtype resource: str
        """
        super().__init__(**kwargs)
        self.resource = resource


class MetricSpecification(_serialization.Model):
    """Specifications of the Metrics for Azure Monitoring.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the metric.
    :vartype display_name: str
    :ivar display_description: Localized friendly description of the metric.
    :vartype display_description: str
    :ivar unit: The unit that makes sense for the metric.
    :vartype unit: str
    :ivar aggregation_type: Only provide one value for this field. Valid values: Average, Minimum,
     Maximum, Total, Count.
    :vartype aggregation_type: str
    :ivar fill_gap_with_zero: Optional. If set to true, then zero will be returned for time
     duration where no metric is emitted/published.
     Ex. a metric that returns the number of times a particular error code was emitted. The error
     code may not appear
     often, instead of the RP publishing 0, Shoebox can auto fill in 0s for time periods where
     nothing was emitted.
    :vartype fill_gap_with_zero: str
    :ivar category: The name of the metric category that the metric belongs to. A metric can only
     belong to a single category.
    :vartype category: str
    :ivar dimensions: The dimensions of the metrics.
    :vartype dimensions: list[~azure.mgmt.signalr.models.Dimension]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        fill_gap_with_zero: Optional[str] = None,
        category: Optional[str] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the metric.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the metric.
        :paramtype display_name: str
        :keyword display_description: Localized friendly description of the metric.
        :paramtype display_description: str
        :keyword unit: The unit that makes sense for the metric.
        :paramtype unit: str
        :keyword aggregation_type: Only provide one value for this field. Valid values: Average,
         Minimum, Maximum, Total, Count.
        :paramtype aggregation_type: str
        :keyword fill_gap_with_zero: Optional. If set to true, then zero will be returned for time
         duration where no metric is emitted/published.
         Ex. a metric that returns the number of times a particular error code was emitted. The error
         code may not appear
         often, instead of the RP publishing 0, Shoebox can auto fill in 0s for time periods where
         nothing was emitted.
        :paramtype fill_gap_with_zero: str
        :keyword category: The name of the metric category that the metric belongs to. A metric can
         only belong to a single category.
        :paramtype category: str
        :keyword dimensions: The dimensions of the metrics.
        :paramtype dimensions: list[~azure.mgmt.signalr.models.Dimension]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.fill_gap_with_zero = fill_gap_with_zero
        self.category = category
        self.dimensions = dimensions


class NameAvailability(_serialization.Model):
    """Result of the request to check name availability. It contains a flag and possible reason of
    failure.

    :ivar name_available: Indicates whether the name is available or not.
    :vartype name_available: bool
    :ivar reason: The reason of the availability. Required if name is not available.
    :vartype reason: str
    :ivar message: The message of the operation.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Indicates whether the name is available or not.
        :paramtype name_available: bool
        :keyword reason: The reason of the availability. Required if name is not available.
        :paramtype reason: str
        :keyword message: The message of the operation.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class NameAvailabilityParameters(_serialization.Model):
    """Data POST-ed to the nameAvailability action.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The resource type. Can be "Microsoft.SignalRService/SignalR" or
     "Microsoft.SignalRService/webPubSub". Required.
    :vartype type: str
    :ivar name: The resource name to validate. e.g."my-resource-name". Required.
    :vartype name: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: str, name: str, **kwargs: Any) -> None:
        """
        :keyword type: The resource type. Can be "Microsoft.SignalRService/SignalR" or
         "Microsoft.SignalRService/webPubSub". Required.
        :paramtype type: str
        :keyword name: The resource name to validate. e.g."my-resource-name". Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class NetworkACL(_serialization.Model):
    """Network ACL.

    :ivar allow: Allowed request types. The value can be one or more of: ClientConnection,
     ServerConnection, RESTAPI.
    :vartype allow: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
    :ivar deny: Denied request types. The value can be one or more of: ClientConnection,
     ServerConnection, RESTAPI.
    :vartype deny: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
    """

    _attribute_map = {
        "allow": {"key": "allow", "type": "[str]"},
        "deny": {"key": "deny", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        allow: Optional[List[Union[str, "_models.SignalRRequestType"]]] = None,
        deny: Optional[List[Union[str, "_models.SignalRRequestType"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allow: Allowed request types. The value can be one or more of: ClientConnection,
         ServerConnection, RESTAPI.
        :paramtype allow: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
        :keyword deny: Denied request types. The value can be one or more of: ClientConnection,
         ServerConnection, RESTAPI.
        :paramtype deny: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
        """
        super().__init__(**kwargs)
        self.allow = allow
        self.deny = deny


class Operation(_serialization.Model):
    """REST API operation supported by resource provider.

    :ivar name: Name of the operation with format: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: If the operation is a data action. (for data plane rbac).
    :vartype is_data_action: bool
    :ivar display: The object that describes a operation.
    :vartype display: ~azure.mgmt.signalr.models.OperationDisplay
    :ivar origin: Optional. The intended executor of the operation; governs the display of the
     operation in the RBAC UX and the audit logs UX.
    :vartype origin: str
    :ivar properties: Extra Operation properties.
    :vartype properties: ~azure.mgmt.signalr.models.OperationProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "OperationProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.OperationProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation with format: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword is_data_action: If the operation is a data action. (for data plane rbac).
        :paramtype is_data_action: bool
        :keyword display: The object that describes a operation.
        :paramtype display: ~azure.mgmt.signalr.models.OperationDisplay
        :keyword origin: Optional. The intended executor of the operation; governs the display of the
         operation in the RBAC UX and the audit logs UX.
        :paramtype origin: str
        :keyword properties: Extra Operation properties.
        :paramtype properties: ~azure.mgmt.signalr.models.OperationProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDisplay(_serialization.Model):
    """The object that describes a operation.

    :ivar provider: Friendly name of the resource provider.
    :vartype provider: str
    :ivar resource: Resource type on which the operation is performed.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Friendly name of the resource provider.
        :paramtype provider: str
        :keyword resource: Resource type on which the operation is performed.
        :paramtype resource: str
        :keyword operation: The localized friendly name for the operation.
        :paramtype operation: str
        :keyword description: The localized friendly description for the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationList(_serialization.Model):
    """Result of the request to list REST API operations. It contains a list of operations.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.signalr.models.Operation]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of operations supported by the resource provider.
        :paramtype value: list[~azure.mgmt.signalr.models.Operation]
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationProperties(_serialization.Model):
    """Extra Operation properties.

    :ivar service_specification: An object that describes a specification.
    :vartype service_specification: ~azure.mgmt.signalr.models.ServiceSpecification
    """

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self, *, service_specification: Optional["_models.ServiceSpecification"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_specification: An object that describes a specification.
        :paramtype service_specification: ~azure.mgmt.signalr.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.service_specification = service_specification


class PrivateEndpoint(_serialization.Model):
    """Private endpoint.

    :ivar id: Full qualified Id of the private endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Full qualified Id of the private endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointACL(NetworkACL):
    """ACL for a private endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar allow: Allowed request types. The value can be one or more of: ClientConnection,
     ServerConnection, RESTAPI.
    :vartype allow: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
    :ivar deny: Denied request types. The value can be one or more of: ClientConnection,
     ServerConnection, RESTAPI.
    :vartype deny: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
    :ivar name: Name of the private endpoint connection. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "allow": {"key": "allow", "type": "[str]"},
        "deny": {"key": "deny", "type": "[str]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        allow: Optional[List[Union[str, "_models.SignalRRequestType"]]] = None,
        deny: Optional[List[Union[str, "_models.SignalRRequestType"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allow: Allowed request types. The value can be one or more of: ClientConnection,
         ServerConnection, RESTAPI.
        :paramtype allow: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
        :keyword deny: Denied request types. The value can be one or more of: ClientConnection,
         ServerConnection, RESTAPI.
        :paramtype deny: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
        :keyword name: Name of the private endpoint connection. Required.
        :paramtype name: str
        """
        super().__init__(allow=allow, deny=deny, **kwargs)
        self.name = name


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection to an azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g. "Microsoft.SignalRService/SignalR".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.signalr.models.SystemData
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Running", "Creating", "Updating", "Deleting", and "Moving".
    :vartype provisioning_state: str or ~azure.mgmt.signalr.models.ProvisioningState
    :ivar private_endpoint: Private endpoint.
    :vartype private_endpoint: ~azure.mgmt.signalr.models.PrivateEndpoint
    :ivar group_ids: Group IDs.
    :vartype group_ids: list[str]
    :ivar private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.signalr.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "group_ids": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: Private endpoint.
        :paramtype private_endpoint: ~azure.mgmt.signalr.models.PrivateEndpoint
        :keyword private_link_service_connection_state: Connection state of the private endpoint
         connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.signalr.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.group_ids = None
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateEndpointConnectionList(_serialization.Model):
    """A list of private endpoint connections.

    :ivar value: The list of the private endpoint connections.
    :vartype value: list[~azure.mgmt.signalr.models.PrivateEndpointConnection]
    :ivar next_link: Request URL that can be used to query next page of private endpoint
     connections. Returned when the total number of requested private endpoint connections exceed
     maximum page size.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of the private endpoint connections.
        :paramtype value: list[~azure.mgmt.signalr.models.PrivateEndpointConnection]
        :keyword next_link: Request URL that can be used to query next page of private endpoint
         connections. Returned when the total number of requested private endpoint connections exceed
         maximum page size.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(ProxyResource):
    """Private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g. "Microsoft.SignalRService/SignalR".
    :vartype type: str
    :ivar group_id: Group Id of the private link resource.
    :vartype group_id: str
    :ivar required_members: Required members of the private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required private DNS zone names.
    :vartype required_zone_names: list[str]
    :ivar shareable_private_link_resource_types: The list of resources that are onboarded to
     private link service.
    :vartype shareable_private_link_resource_types:
     list[~azure.mgmt.signalr.models.ShareablePrivateLinkResourceType]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
        "shareable_private_link_resource_types": {
            "key": "properties.shareablePrivateLinkResourceTypes",
            "type": "[ShareablePrivateLinkResourceType]",
        },
    }

    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        shareable_private_link_resource_types: Optional[List["_models.ShareablePrivateLinkResourceType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword group_id: Group Id of the private link resource.
        :paramtype group_id: str
        :keyword required_members: Required members of the private link resource.
        :paramtype required_members: list[str]
        :keyword required_zone_names: Required private DNS zone names.
        :paramtype required_zone_names: list[str]
        :keyword shareable_private_link_resource_types: The list of resources that are onboarded to
         private link service.
        :paramtype shareable_private_link_resource_types:
         list[~azure.mgmt.signalr.models.ShareablePrivateLinkResourceType]
        """
        super().__init__(**kwargs)
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names
        self.shareable_private_link_resource_types = shareable_private_link_resource_types


class PrivateLinkResourceList(_serialization.Model):
    """Contains a list of PrivateLinkResource and a possible link to query more results.

    :ivar value: List of PrivateLinkResource.
    :vartype value: list[~azure.mgmt.signalr.models.PrivateLinkResource]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of PrivateLinkResource.
        :paramtype value: list[~azure.mgmt.signalr.models.PrivateLinkResource]
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkServiceConnectionState(_serialization.Model):
    """Connection state of the private endpoint connection.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.signalr.models.PrivateLinkServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateLinkServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or ~azure.mgmt.signalr.models.PrivateLinkServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class RegenerateKeyParameters(_serialization.Model):
    """Parameters describes the request to regenerate access keys.

    :ivar key_type: The type of access key. Known values are: "Primary", "Secondary", and "Salt".
    :vartype key_type: str or ~azure.mgmt.signalr.models.KeyType
    """

    _attribute_map = {
        "key_type": {"key": "keyType", "type": "str"},
    }

    def __init__(self, *, key_type: Optional[Union[str, "_models.KeyType"]] = None, **kwargs: Any) -> None:
        """
        :keyword key_type: The type of access key. Known values are: "Primary", "Secondary", and
         "Salt".
        :paramtype key_type: str or ~azure.mgmt.signalr.models.KeyType
        """
        super().__init__(**kwargs)
        self.key_type = key_type


class ResourceLogCategory(_serialization.Model):
    """Resource log category configuration of a Microsoft.SignalRService resource.

    :ivar name: Gets or sets the resource log category's name.
     Available values: ConnectivityLogs, MessagingLogs.
     Case insensitive.
    :vartype name: str
    :ivar enabled: Indicates whether or the resource log category is enabled.
     Available values: true, false.
     Case insensitive.
    :vartype enabled: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "enabled": {"key": "enabled", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, enabled: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Gets or sets the resource log category's name.
         Available values: ConnectivityLogs, MessagingLogs.
         Case insensitive.
        :paramtype name: str
        :keyword enabled: Indicates whether or the resource log category is enabled.
         Available values: true, false.
         Case insensitive.
        :paramtype enabled: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.enabled = enabled


class ResourceLogConfiguration(_serialization.Model):
    """Resource log configuration of a Microsoft.SignalRService resource.

    :ivar categories: Gets or sets the list of category configurations.
    :vartype categories: list[~azure.mgmt.signalr.models.ResourceLogCategory]
    """

    _attribute_map = {
        "categories": {"key": "categories", "type": "[ResourceLogCategory]"},
    }

    def __init__(self, *, categories: Optional[List["_models.ResourceLogCategory"]] = None, **kwargs: Any) -> None:
        """
        :keyword categories: Gets or sets the list of category configurations.
        :paramtype categories: list[~azure.mgmt.signalr.models.ResourceLogCategory]
        """
        super().__init__(**kwargs)
        self.categories = categories


class ResourceReference(_serialization.Model):
    """Reference to a resource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ResourceSku(_serialization.Model):
    """The billing information of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the SKU. Required.

     Allowed values: Standard_S1, Free_F1, Premium_P1. Required.
    :vartype name: str
    :ivar tier: Optional tier of this particular SKU. 'Standard' or 'Free'.

     ``Basic`` is deprecated, use ``Standard`` instead. Known values are: "Free", "Basic",
     "Standard", and "Premium".
    :vartype tier: str or ~azure.mgmt.signalr.models.SignalRSkuTier
    :ivar size: Not used. Retained for future use.
    :vartype size: str
    :ivar family: Not used. Retained for future use.
    :vartype family: str
    :ivar capacity: Optional, integer. The unit count of the resource. 1 by default.

     If present, following values are allowed:
         Free: 1;
         Standard: 1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;
         Premium:  1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
        "size": {"readonly": True},
        "family": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "_models.SignalRSkuTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SKU. Required.

         Allowed values: Standard_S1, Free_F1, Premium_P1. Required.
        :paramtype name: str
        :keyword tier: Optional tier of this particular SKU. 'Standard' or 'Free'.

         ``Basic`` is deprecated, use ``Standard`` instead. Known values are: "Free", "Basic",
         "Standard", and "Premium".
        :paramtype tier: str or ~azure.mgmt.signalr.models.SignalRSkuTier
        :keyword capacity: Optional, integer. The unit count of the resource. 1 by default.

         If present, following values are allowed:
             Free: 1;
             Standard: 1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;
             Premium:  1,2,3,4,5,6,7,8,9,10,20,30,40,50,60,70,80,90,100;.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = None
        self.family = None
        self.capacity = capacity


class ServerlessSettings(_serialization.Model):
    """Serverless settings.

    :ivar connection_timeout_in_seconds: Gets or sets Client Connection Timeout. Optional to be
     set.
     Value in seconds.
     Default value is 30 seconds.
     Customer should set the timeout to a shorter period if messages are expected to be sent in
     shorter intervals,
     and want the client to disconnect more quickly after the last message is sent.
     You can set the timeout to a longer period if messages are expected to be sent in longer
     intervals,
     and they want to keep the same client connection alive during this session.
     The service considers the client disconnected if it hasn't received a message (including
     keep-alive) in this interval.
    :vartype connection_timeout_in_seconds: int
    """

    _validation = {
        "connection_timeout_in_seconds": {"maximum": 120, "minimum": 1},
    }

    _attribute_map = {
        "connection_timeout_in_seconds": {"key": "connectionTimeoutInSeconds", "type": "int"},
    }

    def __init__(self, *, connection_timeout_in_seconds: int = 30, **kwargs: Any) -> None:
        """
        :keyword connection_timeout_in_seconds: Gets or sets Client Connection Timeout. Optional to be
         set.
         Value in seconds.
         Default value is 30 seconds.
         Customer should set the timeout to a shorter period if messages are expected to be sent in
         shorter intervals,
         and want the client to disconnect more quickly after the last message is sent.
         You can set the timeout to a longer period if messages are expected to be sent in longer
         intervals,
         and they want to keep the same client connection alive during this session.
         The service considers the client disconnected if it hasn't received a message (including
         keep-alive) in this interval.
        :paramtype connection_timeout_in_seconds: int
        """
        super().__init__(**kwargs)
        self.connection_timeout_in_seconds = connection_timeout_in_seconds


class ServerlessUpstreamSettings(_serialization.Model):
    """The settings for the Upstream when the service is in server-less mode.

    :ivar templates: Gets or sets the list of Upstream URL templates. Order matters, and the first
     matching template takes effects.
    :vartype templates: list[~azure.mgmt.signalr.models.UpstreamTemplate]
    """

    _attribute_map = {
        "templates": {"key": "templates", "type": "[UpstreamTemplate]"},
    }

    def __init__(self, *, templates: Optional[List["_models.UpstreamTemplate"]] = None, **kwargs: Any) -> None:
        """
        :keyword templates: Gets or sets the list of Upstream URL templates. Order matters, and the
         first matching template takes effects.
        :paramtype templates: list[~azure.mgmt.signalr.models.UpstreamTemplate]
        """
        super().__init__(**kwargs)
        self.templates = templates


class ServiceSpecification(_serialization.Model):
    """An object that describes a specification.

    :ivar metric_specifications: Specifications of the Metrics for Azure Monitoring.
    :vartype metric_specifications: list[~azure.mgmt.signalr.models.MetricSpecification]
    :ivar log_specifications: Specifications of the Logs for Azure Monitoring.
    :vartype log_specifications: list[~azure.mgmt.signalr.models.LogSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications: Specifications of the Metrics for Azure Monitoring.
        :paramtype metric_specifications: list[~azure.mgmt.signalr.models.MetricSpecification]
        :keyword log_specifications: Specifications of the Logs for Azure Monitoring.
        :paramtype log_specifications: list[~azure.mgmt.signalr.models.LogSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class ShareablePrivateLinkResourceProperties(_serialization.Model):
    """Describes the properties of a resource type that has been onboarded to private link service.

    :ivar description: The description of the resource type that has been onboarded to private link
     service.
    :vartype description: str
    :ivar group_id: The resource provider group id for the resource that has been onboarded to
     private link service.
    :vartype group_id: str
    :ivar type: The resource provider type for the resource that has been onboarded to private link
     service.
    :vartype type: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "group_id": {"key": "groupId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        group_id: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The description of the resource type that has been onboarded to private
         link service.
        :paramtype description: str
        :keyword group_id: The resource provider group id for the resource that has been onboarded to
         private link service.
        :paramtype group_id: str
        :keyword type: The resource provider type for the resource that has been onboarded to private
         link service.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.group_id = group_id
        self.type = type


class ShareablePrivateLinkResourceType(_serialization.Model):
    """Describes a  resource type that has been onboarded to private link service.

    :ivar name: The name of the resource type that has been onboarded to private link service.
    :vartype name: str
    :ivar properties: Describes the properties of a resource type that has been onboarded to
     private link service.
    :vartype properties: ~azure.mgmt.signalr.models.ShareablePrivateLinkResourceProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "ShareablePrivateLinkResourceProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.ShareablePrivateLinkResourceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the resource type that has been onboarded to private link service.
        :paramtype name: str
        :keyword properties: Describes the properties of a resource type that has been onboarded to
         private link service.
        :paramtype properties: ~azure.mgmt.signalr.models.ShareablePrivateLinkResourceProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class SharedPrivateLinkResource(ProxyResource):
    """Describes a Shared Private Link Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g. "Microsoft.SignalRService/SignalR".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.signalr.models.SystemData
    :ivar group_id: The group id from the provider of resource the shared private link resource is
     for.
    :vartype group_id: str
    :ivar private_link_resource_id: The resource id of the resource the shared private link
     resource is for.
    :vartype private_link_resource_id: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Running", "Creating", "Updating", "Deleting", and "Moving".
    :vartype provisioning_state: str or ~azure.mgmt.signalr.models.ProvisioningState
    :ivar request_message: The request message for requesting approval of the shared private link
     resource.
    :vartype request_message: str
    :ivar status: Status of the shared private link resource. Known values are: "Pending",
     "Approved", "Rejected", "Disconnected", and "Timeout".
    :vartype status: str or ~azure.mgmt.signalr.models.SharedPrivateLinkResourceStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "private_link_resource_id": {"key": "properties.privateLinkResourceId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "request_message": {"key": "properties.requestMessage", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
    }

    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        private_link_resource_id: Optional[str] = None,
        request_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword group_id: The group id from the provider of resource the shared private link resource
         is for.
        :paramtype group_id: str
        :keyword private_link_resource_id: The resource id of the resource the shared private link
         resource is for.
        :paramtype private_link_resource_id: str
        :keyword request_message: The request message for requesting approval of the shared private
         link resource.
        :paramtype request_message: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.group_id = group_id
        self.private_link_resource_id = private_link_resource_id
        self.provisioning_state = None
        self.request_message = request_message
        self.status = None


class SharedPrivateLinkResourceList(_serialization.Model):
    """A list of shared private link resources.

    :ivar value: The list of the shared private link resources.
    :vartype value: list[~azure.mgmt.signalr.models.SharedPrivateLinkResource]
    :ivar next_link: Request URL that can be used to query next page of private endpoint
     connections. Returned when the total number of requested private endpoint connections exceed
     maximum page size.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SharedPrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SharedPrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of the shared private link resources.
        :paramtype value: list[~azure.mgmt.signalr.models.SharedPrivateLinkResource]
        :keyword next_link: Request URL that can be used to query next page of private endpoint
         connections. Returned when the total number of requested private endpoint connections exceed
         maximum page size.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SignalRCorsSettings(_serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings.

    :ivar allowed_origins: Gets or sets the list of origins that should be allowed to make
     cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted,
     allow all by default.
    :vartype allowed_origins: list[str]
    """

    _attribute_map = {
        "allowed_origins": {"key": "allowedOrigins", "type": "[str]"},
    }

    def __init__(self, *, allowed_origins: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword allowed_origins: Gets or sets the list of origins that should be allowed to make
         cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted,
         allow all by default.
        :paramtype allowed_origins: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins


class SignalRFeature(_serialization.Model):
    """Feature of a resource, which controls the runtime behavior.

    All required parameters must be populated in order to send to Azure.

    :ivar flag: FeatureFlags is the supported features of Azure SignalR service.


     * ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have
     your own backend server; "Serverless": your application doesn't have a backend server;
     "Classic": for backward compatibility. Support both Default and Serverless mode but not
     recommended; "PredefinedOnly": for future use.
     * EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category
     respectively.
     * EnableMessagingLogs: "true"/"false", to enable/disable the connectivity log category
     respectively.
     * EnableLiveTrace: Live Trace allows you to know what's happening inside Azure SignalR
     service, it will give you live traces in real time, it will be helpful when you developing your
     own Azure SignalR based web application or self-troubleshooting some issues. Please note that
     live traces are counted as outbound messages that will be charged. Values allowed:
     "true"/"false", to enable/disable live trace feature. Required. Known values are:
     "ServiceMode", "EnableConnectivityLogs", "EnableMessagingLogs", and "EnableLiveTrace".
    :vartype flag: str or ~azure.mgmt.signalr.models.FeatureFlags
    :ivar value: Value of the feature flag. See Azure SignalR service document
     https://docs.microsoft.com/azure/azure-signalr/ for allowed values. Required.
    :vartype value: str
    :ivar properties: Optional properties related to this feature.
    :vartype properties: dict[str, str]
    """

    _validation = {
        "flag": {"required": True},
        "value": {"required": True, "max_length": 128, "min_length": 1},
    }

    _attribute_map = {
        "flag": {"key": "flag", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        flag: Union[str, "_models.FeatureFlags"],
        value: str,
        properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword flag: FeatureFlags is the supported features of Azure SignalR service.


         * ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have
         your own backend server; "Serverless": your application doesn't have a backend server;
         "Classic": for backward compatibility. Support both Default and Serverless mode but not
         recommended; "PredefinedOnly": for future use.
         * EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category
         respectively.
         * EnableMessagingLogs: "true"/"false", to enable/disable the connectivity log category
         respectively.
         * EnableLiveTrace: Live Trace allows you to know what's happening inside Azure SignalR
         service, it will give you live traces in real time, it will be helpful when you developing your
         own Azure SignalR based web application or self-troubleshooting some issues. Please note that
         live traces are counted as outbound messages that will be charged. Values allowed:
         "true"/"false", to enable/disable live trace feature. Required. Known values are:
         "ServiceMode", "EnableConnectivityLogs", "EnableMessagingLogs", and "EnableLiveTrace".
        :paramtype flag: str or ~azure.mgmt.signalr.models.FeatureFlags
        :keyword value: Value of the feature flag. See Azure SignalR service document
         https://docs.microsoft.com/azure/azure-signalr/ for allowed values. Required.
        :paramtype value: str
        :keyword properties: Optional properties related to this feature.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.flag = flag
        self.value = value
        self.properties = properties


class SignalRKeys(_serialization.Model):
    """A class represents the access keys of the resource.

    :ivar primary_key: The primary access key.
    :vartype primary_key: str
    :ivar secondary_key: The secondary access key.
    :vartype secondary_key: str
    :ivar primary_connection_string: Connection string constructed via the primaryKey.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: Connection string constructed via the secondaryKey.
    :vartype secondary_connection_string: str
    """

    _attribute_map = {
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
        "primary_connection_string": {"key": "primaryConnectionString", "type": "str"},
        "secondary_connection_string": {"key": "secondaryConnectionString", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        primary_connection_string: Optional[str] = None,
        secondary_connection_string: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_key: The primary access key.
        :paramtype primary_key: str
        :keyword secondary_key: The secondary access key.
        :paramtype secondary_key: str
        :keyword primary_connection_string: Connection string constructed via the primaryKey.
        :paramtype primary_connection_string: str
        :keyword secondary_connection_string: Connection string constructed via the secondaryKey.
        :paramtype secondary_connection_string: str
        """
        super().__init__(**kwargs)
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.primary_connection_string = primary_connection_string
        self.secondary_connection_string = secondary_connection_string


class SignalRNetworkACLs(_serialization.Model):
    """Network ACLs for the resource.

    :ivar default_action: Azure Networking ACL Action. Known values are: "Allow" and "Deny".
    :vartype default_action: str or ~azure.mgmt.signalr.models.ACLAction
    :ivar public_network: Network ACL.
    :vartype public_network: ~azure.mgmt.signalr.models.NetworkACL
    :ivar private_endpoints: ACLs for requests from private endpoints.
    :vartype private_endpoints: list[~azure.mgmt.signalr.models.PrivateEndpointACL]
    """

    _attribute_map = {
        "default_action": {"key": "defaultAction", "type": "str"},
        "public_network": {"key": "publicNetwork", "type": "NetworkACL"},
        "private_endpoints": {"key": "privateEndpoints", "type": "[PrivateEndpointACL]"},
    }

    def __init__(
        self,
        *,
        default_action: Optional[Union[str, "_models.ACLAction"]] = None,
        public_network: Optional["_models.NetworkACL"] = None,
        private_endpoints: Optional[List["_models.PrivateEndpointACL"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default_action: Azure Networking ACL Action. Known values are: "Allow" and "Deny".
        :paramtype default_action: str or ~azure.mgmt.signalr.models.ACLAction
        :keyword public_network: Network ACL.
        :paramtype public_network: ~azure.mgmt.signalr.models.NetworkACL
        :keyword private_endpoints: ACLs for requests from private endpoints.
        :paramtype private_endpoints: list[~azure.mgmt.signalr.models.PrivateEndpointACL]
        """
        super().__init__(**kwargs)
        self.default_action = default_action
        self.public_network = public_network
        self.private_endpoints = private_endpoints


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g. "Microsoft.SignalRService/SignalR".
    :vartype type: str
    :ivar location: The GEO location of the resource. e.g. West US | East US | North Central US |
     South Central US.
    :vartype location: str
    :ivar tags: Tags of the service which is a list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The GEO location of the resource. e.g. West US | East US | North Central US
         | South Central US.
        :paramtype location: str
        :keyword tags: Tags of the service which is a list of key value pairs that describe the
         resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class SignalRResource(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A class represent a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g. "Microsoft.SignalRService/SignalR".
    :vartype type: str
    :ivar location: The GEO location of the resource. e.g. West US | East US | North Central US |
     South Central US.
    :vartype location: str
    :ivar tags: Tags of the service which is a list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar sku: The billing information of the resource.
    :vartype sku: ~azure.mgmt.signalr.models.ResourceSku
    :ivar kind: The kind of the service, it can be SignalR or RawWebSockets. Known values are:
     "SignalR" and "RawWebSockets".
    :vartype kind: str or ~azure.mgmt.signalr.models.ServiceKind
    :ivar identity: A class represent managed identities used for request and response.
    :vartype identity: ~azure.mgmt.signalr.models.ManagedIdentity
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.signalr.models.SystemData
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Unknown",
     "Succeeded", "Failed", "Canceled", "Running", "Creating", "Updating", "Deleting", and "Moving".
    :vartype provisioning_state: str or ~azure.mgmt.signalr.models.ProvisioningState
    :ivar external_ip: The publicly accessible IP of the resource.
    :vartype external_ip: str
    :ivar host_name: FQDN of the service instance.
    :vartype host_name: str
    :ivar public_port: The publicly accessible port of the resource which is designed for
     browser/client side usage.
    :vartype public_port: int
    :ivar server_port: The publicly accessible port of the resource which is designed for customer
     server side usage.
    :vartype server_port: int
    :ivar version: Version of the resource. Probably you need the same or higher version of client
     SDKs.
    :vartype version: str
    :ivar private_endpoint_connections: Private endpoint connections to the resource.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.signalr.models.PrivateEndpointConnection]
    :ivar shared_private_link_resources: The list of shared private link resources.
    :vartype shared_private_link_resources:
     list[~azure.mgmt.signalr.models.SharedPrivateLinkResource]
    :ivar tls: TLS settings for the resource.
    :vartype tls: ~azure.mgmt.signalr.models.SignalRTlsSettings
    :ivar host_name_prefix: Deprecated.
    :vartype host_name_prefix: str
    :ivar features: List of the featureFlags.

     FeatureFlags that are not included in the parameters for the update operation will not be
     modified.
     And the response will only include featureFlags that are explicitly set.
     When a featureFlag is not explicitly set, its globally default value will be used
     But keep in mind, the default value doesn't mean "false". It varies in terms of different
     FeatureFlags.
    :vartype features: list[~azure.mgmt.signalr.models.SignalRFeature]
    :ivar live_trace_configuration: Live trace configuration of a Microsoft.SignalRService
     resource.
    :vartype live_trace_configuration: ~azure.mgmt.signalr.models.LiveTraceConfiguration
    :ivar resource_log_configuration: Resource log configuration of a Microsoft.SignalRService
     resource.
    :vartype resource_log_configuration: ~azure.mgmt.signalr.models.ResourceLogConfiguration
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.signalr.models.SignalRCorsSettings
    :ivar serverless: Serverless settings.
    :vartype serverless: ~azure.mgmt.signalr.models.ServerlessSettings
    :ivar upstream: The settings for the Upstream when the service is in server-less mode.
    :vartype upstream: ~azure.mgmt.signalr.models.ServerlessUpstreamSettings
    :ivar network_ac_ls: Network ACLs for the resource.
    :vartype network_ac_ls: ~azure.mgmt.signalr.models.SignalRNetworkACLs
    :ivar public_network_access: Enable or disable public network access. Default to "Enabled".
     When it's Enabled, network ACLs still apply.
     When it's Disabled, public network access is always disabled no matter what you set in network
     ACLs.
    :vartype public_network_access: str
    :ivar disable_local_auth: DisableLocalAuth
     Enable or disable local auth with AccessKey
     When set as true, connection with AccessKey=xxx won't work.
    :vartype disable_local_auth: bool
    :ivar disable_aad_auth: DisableLocalAuth
     Enable or disable aad auth
     When set as true, connection with AuthType=aad won't work.
    :vartype disable_aad_auth: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "external_ip": {"readonly": True},
        "host_name": {"readonly": True},
        "public_port": {"readonly": True},
        "server_port": {"readonly": True},
        "version": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "shared_private_link_resources": {"readonly": True},
        "host_name_prefix": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ResourceSku"},
        "kind": {"key": "kind", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedIdentity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "external_ip": {"key": "properties.externalIP", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "public_port": {"key": "properties.publicPort", "type": "int"},
        "server_port": {"key": "properties.serverPort", "type": "int"},
        "version": {"key": "properties.version", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "shared_private_link_resources": {
            "key": "properties.sharedPrivateLinkResources",
            "type": "[SharedPrivateLinkResource]",
        },
        "tls": {"key": "properties.tls", "type": "SignalRTlsSettings"},
        "host_name_prefix": {"key": "properties.hostNamePrefix", "type": "str"},
        "features": {"key": "properties.features", "type": "[SignalRFeature]"},
        "live_trace_configuration": {"key": "properties.liveTraceConfiguration", "type": "LiveTraceConfiguration"},
        "resource_log_configuration": {
            "key": "properties.resourceLogConfiguration",
            "type": "ResourceLogConfiguration",
        },
        "cors": {"key": "properties.cors", "type": "SignalRCorsSettings"},
        "serverless": {"key": "properties.serverless", "type": "ServerlessSettings"},
        "upstream": {"key": "properties.upstream", "type": "ServerlessUpstreamSettings"},
        "network_ac_ls": {"key": "properties.networkACLs", "type": "SignalRNetworkACLs"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "disable_aad_auth": {"key": "properties.disableAadAuth", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ResourceSku"] = None,
        kind: Optional[Union[str, "_models.ServiceKind"]] = None,
        identity: Optional["_models.ManagedIdentity"] = None,
        tls: Optional["_models.SignalRTlsSettings"] = None,
        features: Optional[List["_models.SignalRFeature"]] = None,
        live_trace_configuration: Optional["_models.LiveTraceConfiguration"] = None,
        resource_log_configuration: Optional["_models.ResourceLogConfiguration"] = None,
        cors: Optional["_models.SignalRCorsSettings"] = None,
        serverless: Optional["_models.ServerlessSettings"] = None,
        upstream: Optional["_models.ServerlessUpstreamSettings"] = None,
        network_ac_ls: Optional["_models.SignalRNetworkACLs"] = None,
        public_network_access: str = "Enabled",
        disable_local_auth: bool = False,
        disable_aad_auth: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The GEO location of the resource. e.g. West US | East US | North Central US
         | South Central US.
        :paramtype location: str
        :keyword tags: Tags of the service which is a list of key value pairs that describe the
         resource.
        :paramtype tags: dict[str, str]
        :keyword sku: The billing information of the resource.
        :paramtype sku: ~azure.mgmt.signalr.models.ResourceSku
        :keyword kind: The kind of the service, it can be SignalR or RawWebSockets. Known values are:
         "SignalR" and "RawWebSockets".
        :paramtype kind: str or ~azure.mgmt.signalr.models.ServiceKind
        :keyword identity: A class represent managed identities used for request and response.
        :paramtype identity: ~azure.mgmt.signalr.models.ManagedIdentity
        :keyword tls: TLS settings for the resource.
        :paramtype tls: ~azure.mgmt.signalr.models.SignalRTlsSettings
        :keyword features: List of the featureFlags.

         FeatureFlags that are not included in the parameters for the update operation will not be
         modified.
         And the response will only include featureFlags that are explicitly set.
         When a featureFlag is not explicitly set, its globally default value will be used
         But keep in mind, the default value doesn't mean "false". It varies in terms of different
         FeatureFlags.
        :paramtype features: list[~azure.mgmt.signalr.models.SignalRFeature]
        :keyword live_trace_configuration: Live trace configuration of a Microsoft.SignalRService
         resource.
        :paramtype live_trace_configuration: ~azure.mgmt.signalr.models.LiveTraceConfiguration
        :keyword resource_log_configuration: Resource log configuration of a Microsoft.SignalRService
         resource.
        :paramtype resource_log_configuration: ~azure.mgmt.signalr.models.ResourceLogConfiguration
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.signalr.models.SignalRCorsSettings
        :keyword serverless: Serverless settings.
        :paramtype serverless: ~azure.mgmt.signalr.models.ServerlessSettings
        :keyword upstream: The settings for the Upstream when the service is in server-less mode.
        :paramtype upstream: ~azure.mgmt.signalr.models.ServerlessUpstreamSettings
        :keyword network_ac_ls: Network ACLs for the resource.
        :paramtype network_ac_ls: ~azure.mgmt.signalr.models.SignalRNetworkACLs
        :keyword public_network_access: Enable or disable public network access. Default to "Enabled".
         When it's Enabled, network ACLs still apply.
         When it's Disabled, public network access is always disabled no matter what you set in network
         ACLs.
        :paramtype public_network_access: str
        :keyword disable_local_auth: DisableLocalAuth
         Enable or disable local auth with AccessKey
         When set as true, connection with AccessKey=xxx won't work.
        :paramtype disable_local_auth: bool
        :keyword disable_aad_auth: DisableLocalAuth
         Enable or disable aad auth
         When set as true, connection with AuthType=aad won't work.
        :paramtype disable_aad_auth: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.kind = kind
        self.identity = identity
        self.system_data = None
        self.provisioning_state = None
        self.external_ip = None
        self.host_name = None
        self.public_port = None
        self.server_port = None
        self.version = None
        self.private_endpoint_connections = None
        self.shared_private_link_resources = None
        self.tls = tls
        self.host_name_prefix = None
        self.features = features
        self.live_trace_configuration = live_trace_configuration
        self.resource_log_configuration = resource_log_configuration
        self.cors = cors
        self.serverless = serverless
        self.upstream = upstream
        self.network_ac_ls = network_ac_ls
        self.public_network_access = public_network_access
        self.disable_local_auth = disable_local_auth
        self.disable_aad_auth = disable_aad_auth


class SignalRResourceList(_serialization.Model):
    """Object that includes an array of resources and a possible link for next set.

    :ivar value: List of the resources.
    :vartype value: list[~azure.mgmt.signalr.models.SignalRResource]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SignalRResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SignalRResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of the resources.
        :paramtype value: list[~azure.mgmt.signalr.models.SignalRResource]
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SignalRTlsSettings(_serialization.Model):
    """TLS settings for the resource.

    :ivar client_cert_enabled: Request client certificate during TLS handshake if enabled.
    :vartype client_cert_enabled: bool
    """

    _attribute_map = {
        "client_cert_enabled": {"key": "clientCertEnabled", "type": "bool"},
    }

    def __init__(self, *, client_cert_enabled: bool = True, **kwargs: Any) -> None:
        """
        :keyword client_cert_enabled: Request client certificate during TLS handshake if enabled.
        :paramtype client_cert_enabled: bool
        """
        super().__init__(**kwargs)
        self.client_cert_enabled = client_cert_enabled


class SignalRUsage(_serialization.Model):
    """Object that describes a specific usage of the resources.

    :ivar id: Fully qualified ARM resource id.
    :vartype id: str
    :ivar current_value: Current value for the usage quota.
    :vartype current_value: int
    :ivar limit: The maximum permitted value for the usage quota. If there is no limit, this value
     will be -1.
    :vartype limit: int
    :ivar name: Localizable String object containing the name and a localized value.
    :vartype name: ~azure.mgmt.signalr.models.SignalRUsageName
    :ivar unit: Representing the units of the usage quota. Possible values are: Count, Bytes,
     Seconds, Percent, CountPerSecond, BytesPerSecond.
    :vartype unit: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "SignalRUsageName"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["_models.SignalRUsageName"] = None,
        unit: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ARM resource id.
        :paramtype id: str
        :keyword current_value: Current value for the usage quota.
        :paramtype current_value: int
        :keyword limit: The maximum permitted value for the usage quota. If there is no limit, this
         value will be -1.
        :paramtype limit: int
        :keyword name: Localizable String object containing the name and a localized value.
        :paramtype name: ~azure.mgmt.signalr.models.SignalRUsageName
        :keyword unit: Representing the units of the usage quota. Possible values are: Count, Bytes,
         Seconds, Percent, CountPerSecond, BytesPerSecond.
        :paramtype unit: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.current_value = current_value
        self.limit = limit
        self.name = name
        self.unit = unit


class SignalRUsageList(_serialization.Model):
    """Object that includes an array of the resource usages and a possible link for next set.

    :ivar value: List of the resource usages.
    :vartype value: list[~azure.mgmt.signalr.models.SignalRUsage]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SignalRUsage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SignalRUsage"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of the resource usages.
        :paramtype value: list[~azure.mgmt.signalr.models.SignalRUsage]
        :keyword next_link: The URL the client should use to fetch the next page (per server side
         paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SignalRUsageName(_serialization.Model):
    """Localizable String object containing the name and a localized value.

    :ivar value: The identifier of the usage.
    :vartype value: str
    :ivar localized_value: Localized name of the usage.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The identifier of the usage.
        :paramtype value: str
        :keyword localized_value: Localized name of the usage.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class Sku(_serialization.Model):
    """Describes an available sku.".

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The resource type that this object applies to.
    :vartype resource_type: str
    :ivar sku: The billing information of the resource.
    :vartype sku: ~azure.mgmt.signalr.models.ResourceSku
    :ivar capacity: Describes scaling information of a sku.
    :vartype capacity: ~azure.mgmt.signalr.models.SkuCapacity
    """

    _validation = {
        "resource_type": {"readonly": True},
        "sku": {"readonly": True},
        "capacity": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "sku": {"key": "sku", "type": "ResourceSku"},
        "capacity": {"key": "capacity", "type": "SkuCapacity"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class SkuCapacity(_serialization.Model):
    """Describes scaling information of a sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The lowest permitted capacity for this resource.
    :vartype minimum: int
    :ivar maximum: The highest permitted capacity for this resource.
    :vartype maximum: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar allowed_values: Allows capacity value list.
    :vartype allowed_values: list[int]
    :ivar scale_type: The scale type applicable to the sku. Known values are: "None", "Manual", and
     "Automatic".
    :vartype scale_type: str or ~azure.mgmt.signalr.models.ScaleType
    """

    _validation = {
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "default": {"readonly": True},
        "allowed_values": {"readonly": True},
        "scale_type": {"readonly": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "allowed_values": {"key": "allowedValues", "type": "[int]"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.allowed_values = None
        self.scale_type = None


class SkuList(_serialization.Model):
    """The list skus operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of skus available for the resource.
    :vartype value: list[~azure.mgmt.signalr.models.Sku]
    :ivar next_link: The URL the client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Sku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.signalr.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.signalr.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.signalr.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.signalr.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UpstreamAuthSettings(_serialization.Model):
    """Upstream auth settings. If not set, no auth is used for upstream messages.

    :ivar type: Upstream auth type enum. Known values are: "None" and "ManagedIdentity".
    :vartype type: str or ~azure.mgmt.signalr.models.UpstreamAuthType
    :ivar managed_identity: Managed identity settings for upstream.
    :vartype managed_identity: ~azure.mgmt.signalr.models.ManagedIdentitySettings
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "managed_identity": {"key": "managedIdentity", "type": "ManagedIdentitySettings"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.UpstreamAuthType"]] = None,
        managed_identity: Optional["_models.ManagedIdentitySettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Upstream auth type enum. Known values are: "None" and "ManagedIdentity".
        :paramtype type: str or ~azure.mgmt.signalr.models.UpstreamAuthType
        :keyword managed_identity: Managed identity settings for upstream.
        :paramtype managed_identity: ~azure.mgmt.signalr.models.ManagedIdentitySettings
        """
        super().__init__(**kwargs)
        self.type = type
        self.managed_identity = managed_identity


class UpstreamTemplate(_serialization.Model):
    """Upstream template item settings. It defines the Upstream URL of the incoming requests.
    The template defines the pattern of the event, the hub or the category of the incoming request
    that matches current URL template.

    All required parameters must be populated in order to send to Azure.

    :ivar hub_pattern: Gets or sets the matching pattern for hub names. If not set, it matches any
     hub.
     There are 3 kind of patterns supported:

     .. code-block::

        1. "*", it to matches any hub name.
        2. Combine multiple hubs with ",", for example "hub1,hub2", it matches "hub1" and "hub2".
        3. The single hub name, for example, "hub1", it matches "hub1".
    :vartype hub_pattern: str
    :ivar event_pattern: Gets or sets the matching pattern for event names. If not set, it matches
     any event.
     There are 3 kind of patterns supported:

     .. code-block::

        1. "*", it to matches any event name.
        2. Combine multiple events with ",", for example "connect,disconnect", it matches event
     "connect" and "disconnect".
        3. The single event name, for example, "connect", it matches "connect".
    :vartype event_pattern: str
    :ivar category_pattern: Gets or sets the matching pattern for category names. If not set, it
     matches any category.
     There are 3 kind of patterns supported:

     .. code-block::

        1. "*", it to matches any category name.
        2. Combine multiple categories with ",", for example "connections,messages", it matches
     category "connections" and "messages".
        3. The single category name, for example, "connections", it matches the category
     "connections".
    :vartype category_pattern: str
    :ivar url_template: Gets or sets the Upstream URL template. You can use 3 predefined parameters
     {hub}, {category} {event} inside the template, the value of the Upstream URL is dynamically
     calculated when the client request comes in.
     For example, if the urlTemplate is ``http://example.com/{hub}/api/{event}``\ , with a client
     request from hub ``chat`` connects, it will first POST to this URL:
     ``http://example.com/chat/api/connect``. Required.
    :vartype url_template: str
    :ivar auth: Upstream auth settings. If not set, no auth is used for upstream messages.
    :vartype auth: ~azure.mgmt.signalr.models.UpstreamAuthSettings
    """

    _validation = {
        "url_template": {"required": True},
    }

    _attribute_map = {
        "hub_pattern": {"key": "hubPattern", "type": "str"},
        "event_pattern": {"key": "eventPattern", "type": "str"},
        "category_pattern": {"key": "categoryPattern", "type": "str"},
        "url_template": {"key": "urlTemplate", "type": "str"},
        "auth": {"key": "auth", "type": "UpstreamAuthSettings"},
    }

    def __init__(
        self,
        *,
        url_template: str,
        hub_pattern: Optional[str] = None,
        event_pattern: Optional[str] = None,
        category_pattern: Optional[str] = None,
        auth: Optional["_models.UpstreamAuthSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hub_pattern: Gets or sets the matching pattern for hub names. If not set, it matches
         any hub.
         There are 3 kind of patterns supported:

         .. code-block::

            1. "*", it to matches any hub name.
            2. Combine multiple hubs with ",", for example "hub1,hub2", it matches "hub1" and "hub2".
            3. The single hub name, for example, "hub1", it matches "hub1".
        :paramtype hub_pattern: str
        :keyword event_pattern: Gets or sets the matching pattern for event names. If not set, it
         matches any event.
         There are 3 kind of patterns supported:

         .. code-block::

            1. "*", it to matches any event name.
            2. Combine multiple events with ",", for example "connect,disconnect", it matches event
         "connect" and "disconnect".
            3. The single event name, for example, "connect", it matches "connect".
        :paramtype event_pattern: str
        :keyword category_pattern: Gets or sets the matching pattern for category names. If not set, it
         matches any category.
         There are 3 kind of patterns supported:

         .. code-block::

            1. "*", it to matches any category name.
            2. Combine multiple categories with ",", for example "connections,messages", it matches
         category "connections" and "messages".
            3. The single category name, for example, "connections", it matches the category
         "connections".
        :paramtype category_pattern: str
        :keyword url_template: Gets or sets the Upstream URL template. You can use 3 predefined
         parameters {hub}, {category} {event} inside the template, the value of the Upstream URL is
         dynamically calculated when the client request comes in.
         For example, if the urlTemplate is ``http://example.com/{hub}/api/{event}``\ , with a client
         request from hub ``chat`` connects, it will first POST to this URL:
         ``http://example.com/chat/api/connect``. Required.
        :paramtype url_template: str
        :keyword auth: Upstream auth settings. If not set, no auth is used for upstream messages.
        :paramtype auth: ~azure.mgmt.signalr.models.UpstreamAuthSettings
        """
        super().__init__(**kwargs)
        self.hub_pattern = hub_pattern
        self.event_pattern = event_pattern
        self.category_pattern = category_pattern
        self.url_template = url_template
        self.auth = auth


class UserAssignedIdentityProperty(_serialization.Model):
    """Properties of user assigned identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Get the principal id for the user assigned identity.
    :vartype principal_id: str
    :ivar client_id: Get the client id for the user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
