#Copyright ReportLab Europe Ltd. 2000-2017
#see license.txt for license details
"""Tests for reportlab.lib.utils
"""
__version__='3.3.18'
from reportlab.lib.testutils import setOutDir,makeSuiteForClasses, printLocation
setOutDir(__name__)
import os, time, sys, operator
import reportlab
import unittest
from reportlab.lib import normalDate
ND=normalDate.NormalDate

class NormalDateTestCase(unittest.TestCase):
    def setUp(self):
        #the comparison data was obtained by running this in python27
        #from reportlab.lib import normalDate
        #import operator, sys
        #ND=normalDate.NormalDate
        #samples = (0,-2,2,3,None,ND(20160912),ND(20160911),ND(20160913))
        #OPN = 'lt le eq ne ge gt'.split()
        #
        #def v(x):
        #   return 'ND(%r)' % x if hasattr(x,'normalDate') else repr(x)
        #for opn in OPN:
        #   op = getattr(operator,opn)
        #   for left in samples:
        #       if opn not in ('ne','eq') and not hasattr(left,'normalDate'): continue
        #       for right in samples:
        #           sys.stdout.write('(%r,%s,%s,%s),\n' % (opn,v(left),v(right),repr(op(left,right))))
        self.comparisons = [
                ('lt',ND(20160912),0,False),
                ('lt',ND(20160912),-2,False),
                ('lt',ND(20160912),2,False),
                ('lt',ND(20160912),3,False),
                ('lt',ND(20160912),None,False),
                ('lt',ND(20160912),ND(20160912),False),
                ('lt',ND(20160912),ND(20160911),False),
                ('lt',ND(20160912),ND(20160913),True),
                ('lt',ND(20160911),0,False),
                ('lt',ND(20160911),-2,False),
                ('lt',ND(20160911),2,False),
                ('lt',ND(20160911),3,False),
                ('lt',ND(20160911),None,False),
                ('lt',ND(20160911),ND(20160912),True),
                ('lt',ND(20160911),ND(20160911),False),
                ('lt',ND(20160911),ND(20160913),True),
                ('lt',ND(20160913),0,False),
                ('lt',ND(20160913),-2,False),
                ('lt',ND(20160913),2,False),
                ('lt',ND(20160913),3,False),
                ('lt',ND(20160913),None,False),
                ('lt',ND(20160913),ND(20160912),False),
                ('lt',ND(20160913),ND(20160911),False),
                ('lt',ND(20160913),ND(20160913),False),
                ('le',ND(20160912),0,False),
                ('le',ND(20160912),-2,False),
                ('le',ND(20160912),2,False),
                ('le',ND(20160912),3,False),
                ('le',ND(20160912),None,False),
                ('le',ND(20160912),ND(20160912),True),
                ('le',ND(20160912),ND(20160911),False),
                ('le',ND(20160912),ND(20160913),True),
                ('le',ND(20160911),0,False),
                ('le',ND(20160911),-2,False),
                ('le',ND(20160911),2,False),
                ('le',ND(20160911),3,False),
                ('le',ND(20160911),None,False),
                ('le',ND(20160911),ND(20160912),True),
                ('le',ND(20160911),ND(20160911),True),
                ('le',ND(20160911),ND(20160913),True),
                ('le',ND(20160913),0,False),
                ('le',ND(20160913),-2,False),
                ('le',ND(20160913),2,False),
                ('le',ND(20160913),3,False),
                ('le',ND(20160913),None,False),
                ('le',ND(20160913),ND(20160912),False),
                ('le',ND(20160913),ND(20160911),False),
                ('le',ND(20160913),ND(20160913),True),
                ('eq',0,0,True),
                ('eq',0,-2,False),
                ('eq',0,2,False),
                ('eq',0,3,False),
                ('eq',0,None,False),
                ('eq',0,ND(20160912),False),
                ('eq',0,ND(20160911),False),
                ('eq',0,ND(20160913),False),
                ('eq',-2,0,False),
                ('eq',-2,-2,True),
                ('eq',-2,2,False),
                ('eq',-2,3,False),
                ('eq',-2,None,False),
                ('eq',-2,ND(20160912),False),
                ('eq',-2,ND(20160911),False),
                ('eq',-2,ND(20160913),False),
                ('eq',2,0,False),
                ('eq',2,-2,False),
                ('eq',2,2,True),
                ('eq',2,3,False),
                ('eq',2,None,False),
                ('eq',2,ND(20160912),False),
                ('eq',2,ND(20160911),False),
                ('eq',2,ND(20160913),False),
                ('eq',3,0,False),
                ('eq',3,-2,False),
                ('eq',3,2,False),
                ('eq',3,3,True),
                ('eq',3,None,False),
                ('eq',3,ND(20160912),False),
                ('eq',3,ND(20160911),False),
                ('eq',3,ND(20160913),False),
                ('eq',None,0,False),
                ('eq',None,-2,False),
                ('eq',None,2,False),
                ('eq',None,3,False),
                ('eq',None,None,True),
                ('eq',None,ND(20160912),False),
                ('eq',None,ND(20160911),False),
                ('eq',None,ND(20160913),False),
                ('eq',ND(20160912),0,False),
                ('eq',ND(20160912),-2,False),
                ('eq',ND(20160912),2,False),
                ('eq',ND(20160912),3,False),
                ('eq',ND(20160912),None,False),
                ('eq',ND(20160912),ND(20160912),True),
                ('eq',ND(20160912),ND(20160911),False),
                ('eq',ND(20160912),ND(20160913),False),
                ('eq',ND(20160911),0,False),
                ('eq',ND(20160911),-2,False),
                ('eq',ND(20160911),2,False),
                ('eq',ND(20160911),3,False),
                ('eq',ND(20160911),None,False),
                ('eq',ND(20160911),ND(20160912),False),
                ('eq',ND(20160911),ND(20160911),True),
                ('eq',ND(20160911),ND(20160913),False),
                ('eq',ND(20160913),0,False),
                ('eq',ND(20160913),-2,False),
                ('eq',ND(20160913),2,False),
                ('eq',ND(20160913),3,False),
                ('eq',ND(20160913),None,False),
                ('eq',ND(20160913),ND(20160912),False),
                ('eq',ND(20160913),ND(20160911),False),
                ('eq',ND(20160913),ND(20160913),True),
                ('ne',0,0,False),
                ('ne',0,-2,True),
                ('ne',0,2,True),
                ('ne',0,3,True),
                ('ne',0,None,True),
                ('ne',0,ND(20160912),True),
                ('ne',0,ND(20160911),True),
                ('ne',0,ND(20160913),True),
                ('ne',-2,0,True),
                ('ne',-2,-2,False),
                ('ne',-2,2,True),
                ('ne',-2,3,True),
                ('ne',-2,None,True),
                ('ne',-2,ND(20160912),True),
                ('ne',-2,ND(20160911),True),
                ('ne',-2,ND(20160913),True),
                ('ne',2,0,True),
                ('ne',2,-2,True),
                ('ne',2,2,False),
                ('ne',2,3,True),
                ('ne',2,None,True),
                ('ne',2,ND(20160912),True),
                ('ne',2,ND(20160911),True),
                ('ne',2,ND(20160913),True),
                ('ne',3,0,True),
                ('ne',3,-2,True),
                ('ne',3,2,True),
                ('ne',3,3,False),
                ('ne',3,None,True),
                ('ne',3,ND(20160912),True),
                ('ne',3,ND(20160911),True),
                ('ne',3,ND(20160913),True),
                ('ne',None,0,True),
                ('ne',None,-2,True),
                ('ne',None,2,True),
                ('ne',None,3,True),
                ('ne',None,None,False),
                ('ne',None,ND(20160912),True),
                ('ne',None,ND(20160911),True),
                ('ne',None,ND(20160913),True),
                ('ne',ND(20160912),0,True),
                ('ne',ND(20160912),-2,True),
                ('ne',ND(20160912),2,True),
                ('ne',ND(20160912),3,True),
                ('ne',ND(20160912),None,True),
                ('ne',ND(20160912),ND(20160912),False),
                ('ne',ND(20160912),ND(20160911),True),
                ('ne',ND(20160912),ND(20160913),True),
                ('ne',ND(20160911),0,True),
                ('ne',ND(20160911),-2,True),
                ('ne',ND(20160911),2,True),
                ('ne',ND(20160911),3,True),
                ('ne',ND(20160911),None,True),
                ('ne',ND(20160911),ND(20160912),True),
                ('ne',ND(20160911),ND(20160911),False),
                ('ne',ND(20160911),ND(20160913),True),
                ('ne',ND(20160913),0,True),
                ('ne',ND(20160913),-2,True),
                ('ne',ND(20160913),2,True),
                ('ne',ND(20160913),3,True),
                ('ne',ND(20160913),None,True),
                ('ne',ND(20160913),ND(20160912),True),
                ('ne',ND(20160913),ND(20160911),True),
                ('ne',ND(20160913),ND(20160913),False),
                ('ge',ND(20160912),0,True),
                ('ge',ND(20160912),-2,True),
                ('ge',ND(20160912),2,True),
                ('ge',ND(20160912),3,True),
                ('ge',ND(20160912),None,True),
                ('ge',ND(20160912),ND(20160912),True),
                ('ge',ND(20160912),ND(20160911),True),
                ('ge',ND(20160912),ND(20160913),False),
                ('ge',ND(20160911),0,True),
                ('ge',ND(20160911),-2,True),
                ('ge',ND(20160911),2,True),
                ('ge',ND(20160911),3,True),
                ('ge',ND(20160911),None,True),
                ('ge',ND(20160911),ND(20160912),False),
                ('ge',ND(20160911),ND(20160911),True),
                ('ge',ND(20160911),ND(20160913),False),
                ('ge',ND(20160913),0,True),
                ('ge',ND(20160913),-2,True),
                ('ge',ND(20160913),2,True),
                ('ge',ND(20160913),3,True),
                ('ge',ND(20160913),None,True),
                ('ge',ND(20160913),ND(20160912),True),
                ('ge',ND(20160913),ND(20160911),True),
                ('ge',ND(20160913),ND(20160913),True),
                ('gt',ND(20160912),0,True),
                ('gt',ND(20160912),-2,True),
                ('gt',ND(20160912),2,True),
                ('gt',ND(20160912),3,True),
                ('gt',ND(20160912),None,True),
                ('gt',ND(20160912),ND(20160912),False),
                ('gt',ND(20160912),ND(20160911),True),
                ('gt',ND(20160912),ND(20160913),False),
                ('gt',ND(20160911),0,True),
                ('gt',ND(20160911),-2,True),
                ('gt',ND(20160911),2,True),
                ('gt',ND(20160911),3,True),
                ('gt',ND(20160911),None,True),
                ('gt',ND(20160911),ND(20160912),False),
                ('gt',ND(20160911),ND(20160911),False),
                ('gt',ND(20160911),ND(20160913),False),
                ('gt',ND(20160913),0,True),
                ('gt',ND(20160913),-2,True),
                ('gt',ND(20160913),2,True),
                ('gt',ND(20160913),3,True),
                ('gt',ND(20160913),None,True),
                ('gt',ND(20160913),ND(20160912),True),
                ('gt',ND(20160913),ND(20160911),True),
                ('gt',ND(20160913),ND(20160913),False),
                ]

    def test1(self):
        '''test that normalDate comparisions work in the old python 2.x way'''
        for opn,left,right,gresult in self.comparisons:
            result = getattr(operator,opn)(left,right)
            self.assertEqual(gresult,result,"comparison test %s %s %s failed, expected %s got %s" % (left, opn, right, gresult, result))
 
def makeSuite():
    return makeSuiteForClasses(NormalDateTestCase)

if __name__ == "__main__": #noruntests
    unittest.TextTestRunner().run(makeSuite())
    printLocation()
