% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decontam.R
\name{isContaminant}
\alias{isContaminant}
\alias{isContaminant,ANY-method}
\title{Identify contaminant sequences.}
\usage{
isContaminant(seqtab, ...)

\S4method{isContaminant}{ANY}(
  seqtab,
  conc = NULL,
  neg = NULL,
  method = c("auto", "frequency", "prevalence", "combined", "minimum", "either",
    "both"),
  batch = NULL,
  batch.combine = c("minimum", "product", "fisher"),
  threshold = 0.1,
  normalize = TRUE,
  detailed = TRUE
)
}
\arguments{
\item{seqtab}{(Required). \code{Integer matrix} or \code{phyloseq} object.
A feature table recording the observed abundances of each sequence variant (or OTU) in each sample.
Rows should correspond to samples, and columns to sequences (or OTUs).
If a phyloseq object is provided, the otu-table component will be extracted.}

\item{...}{Not used currently}

\item{conc}{(Optional). \code{numeric}. Required if performing frequency-based testing.
A quantitative measure of the concentration of amplified DNA in each sample prior to sequencing.
All values must be greater than zero. Zero is assumed to represent the complete absence of DNA.
If \code{seqtab} was prodivded as a phyloseq object, the name of the appropriate sample-variable in that
phyloseq object can be provided.}

\item{neg}{(Optional). \code{logical}. Required if performing prevalence-based testing.
TRUE if sample is a negative control, and FALSE if not (NA entries are not included in the testing).
Extraction controls give the best results.
If \code{seqtab} was provided as a phyloseq object, the name of the appropriate sample-variable in that
phyloseq object can be provided.}

\item{method}{(Optional). \code{character}. The method used to test for contaminants.
\describe{
  \item{auto}{(Default). frequency, prevalence or combined will be automatically selected based on whether
              just \code{conc}, just \code{neg}, or both were provided.}
  \item{frequency}{Contaminants are identified by frequency that varies inversely with sample DNA concentration.}
  \item{prevalence}{Contaminants are identified by increased prevalence in negative controls.}
  \item{combined}{The frequency and prevalence probabilities are combined with Fisher's method and used to identify contaminants.}
  \item{minimum}{The minimum of the frequency and prevalence probabilities is used to identify contaminants.}
  \item{either}{Contaminants are called if identified by either the frequency or prevalance methods.}
  \item{both}{Contaminants are called if identified by both the frequency and prevalance methods.}
}}

\item{batch}{(Optional). \code{factor}, or any type coercible to a \code{factor}. Default NULL.
If provided, should be a vector of length equal to the number of input samples which specifies which batch
each sample belongs to (eg. sequencing run). Contaminants identification will be performed independently
within each batch.
If \code{seqtab} was provided as a phyloseq object, the name of the appropriate sample-variable in that
phyloseq object can be provided.}

\item{batch.combine}{(Optional). Default "minimum".
For each input sequence variant (or OTU) the probabilities calculated in each batch are combined into a
single probability that is compared to `code{threshold}` to classify contaminants.
Valid values: "minimum", "product", "fisher".}

\item{threshold}{(Optional). Default \code{0.1}.
The probability threshold below which (strictly less than) the null-hypothesis (not a contaminant) should be rejected in favor of the
alternate hypothesis (contaminant). A length-two vector can be provided when using the \code{either} or \code{both} methods:
the first value is the threshold for the frequency test and the second for the prevalence test.}

\item{normalize}{(Optional). Default TRUE.
If TRUE, the input \code{seqtab} is normalized so that each row sums to 1 (converted to frequency).
If FALSE, no normalization is performed (the data should already be frequencies or counts from equal-depth samples).}

\item{detailed}{(Optional). Default TRUE.
If TRUE, the return value is a \code{data.frame} containing diagnostic information on the contaminant decision.
If FALSE, the return value is a \code{logical} vector containing the binary contaminant classifications.}
}
\value{
If \code{detailed=TRUE} a \code{data.frame} with classification information.
If \code{detailed=FALSE} a \code{logical} vector is returned, with TRUE indicating contaminants.
}
\description{
The frequency of each sequence (or OTU) in the input feature table as a function of the concentration of
amplified DNA in each sample is used to identify contaminant sequences.
}
\examples{
st <- readRDS(system.file("extdata", "st.rds", package="decontam"))
# conc should be positive and non-zero
conc <- c(6413, 3581.0, 5375, 4107, 4291, 4260, 4171, 2765, 33, 48)
neg <- c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE)
# Use frequency or frequency and prevalence to identify contaminants
isContaminant(st, conc=conc, method="frequency", threshold=0.2)
isContaminant(st, conc=conc, neg=neg, method="both", threshold=c(0.1,0.5))

}
