% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/colAnyMissings.R,
%   R/rowAnyMissings.R
\name{DelayedMatrixStats-deprecated}
\alias{DelayedMatrixStats-deprecated}
\alias{colAnyMissings}
\alias{rowAnyMissings}
\alias{colAnyMissings,DelayedMatrix-method}
\alias{colAnyMissings,matrix-method}
\alias{rowAnyMissings,DelayedMatrix-method}
\alias{rowAnyMissings,matrix-method}
\title{Deprecated functions in package \sQuote{DelayedMatrixStats}}
\usage{
colAnyMissings(x, rows = NULL, cols = NULL, ..., useNames = NA)

rowAnyMissings(x, rows = NULL, cols = NULL, ..., useNames = NA)

\S4method{colAnyMissings}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{colAnyMissings}{matrix}(x, rows = NULL, cols = NULL, ..., useNames = TRUE)

\S4method{rowAnyMissings}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowAnyMissings}{matrix}(x, rows = NULL, cols = NULL, ..., useNames = TRUE)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}
}
\value{
Returns a \code{\link{logical}} \code{\link{vector}} of length N (K).
}
\description{
These functions are provided for compatibility with older
versions of \sQuote{DelayedMatrixStats} only, and will be defunct at the
next release.
}
\details{
The following functions are deprecated and will be made defunct;
use the replacement indicated below:
\itemize{
\item{colAnyMissings: \code{\link{colAnyNAs}}}
\item{rowAnyMissings: \code{\link{rowAnyNAs}}}
}
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowAnyNAs(mat)
colAnyNAs(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:anyMissing]{rowAnyNAs}()} and
\code{matrixStats::\link[matrixStats:anyMissing]{colAnyNAs}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For checks if any element is equal to a value, see
\code{\link[MatrixGenerics]{rowAnys}()}.
\item \code{base::\link{is.na}()} and \code{base::\link{any}()}.
}
}
