% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{estimateDispersions}
\alias{estimateDispersions}
\alias{estimateDispersions,DESeqDataSet-method}
\title{Estimate the dispersions for a DESeqDataSet}
\usage{
\S4method{estimateDispersions}{DESeqDataSet}(object,
  fitType = c("parametric", "local", "mean"), maxit = 100,
  quiet = FALSE, modelMatrix = NULL, minmu = 0.5)
}
\arguments{
\item{object}{a DESeqDataSet}

\item{fitType}{either "parametric", "local", or "mean"
for the type of fitting of dispersions to the mean intensity.
\itemize{
  \item parametric - fit a dispersion-mean relation of the form:
    \deqn{dispersion = asymptDisp + extraPois / mean}
    via a robust gamma-family GLM. The coefficients \code{asymptDisp} and \code{extraPois}
    are given in the attribute \code{coefficients} of the \code{\link{dispersionFunction}}
    of the object.
  \item local - use the locfit package to fit a local regression
    of log dispersions over log base mean (normal scale means and dispersions
    are input and output for \code{\link{dispersionFunction}}). The points
    are weighted by normalized mean count in the local regression.
  \item mean - use the mean of gene-wise dispersion estimates.
}}

\item{maxit}{control parameter: maximum number of iterations to allow for convergence}

\item{quiet}{whether to print messages at each step}

\item{modelMatrix}{an optional matrix which will be used for fitting the expected counts.
by default, the model matrix is constructed from \code{design(object)}}

\item{minmu}{lower bound on the estimated count for fitting gene-wise dispersion}
}
\value{
The DESeqDataSet passed as parameters, with the dispersion information
filled in as metadata columns, accessible via \code{mcols}, or the final dispersions
accessible via \code{\link{dispersions}}.
}
\description{
This function obtains dispersion estimates for Negative Binomial distributed data.
}
\details{
Typically the function is called with the idiom:

\code{dds <- estimateDispersions(dds)}

The fitting proceeds as follows: for each gene, an estimate of the dispersion
is found which maximizes the Cox Reid-adjusted profile likelihood
(the methods of Cox Reid-adjusted profile likelihood maximization for
estimation of dispersion in RNA-Seq data were developed by McCarthy,
et al. (2012), first implemented in the edgeR package in 2010);
a trend line capturing the dispersion-mean relationship is fit to the maximum likelihood estimates;
a normal prior is determined for the log dispersion estimates centered
on the predicted value from the trended fit
with variance equal to the difference between the observed variance of the
log dispersion estimates and the expected sampling variance;
finally maximum a posteriori dispersion estimates are returned.
This final dispersion parameter is used in subsequent tests.
The final dispersion estimates can be accessed from an object using \code{\link{dispersions}}.
The fitted dispersion-mean relationship is also used in
\code{\link{varianceStabilizingTransformation}}.
All of the intermediate values (gene-wise dispersion estimates, fitted dispersion
estimates from the trended fit, etc.) are stored in \code{mcols(dds)}, with
information about these columns in \code{mcols(mcols(dds))}.

The log normal prior on the dispersion parameter has been proposed
by Wu, et al. (2012) and is also implemented in the DSS package.

In DESeq2, the dispersion estimation procedure described above replaces the
different methods of dispersion from the previous version of the DESeq package.

\code{estimateDispersions} checks for the case of an analysis
with as many samples as the number of coefficients to fit,
and will temporarily substitute a design formula \code{~ 1} for the
purposes of dispersion estimation. Note that analysis of designs without
replicates will be removed in the Oct 2018 release: DESeq2 v1.22.0,
after which DESeq2 will give an error.

The lower-level functions called by \code{estimateDispersions} are:
\code{\link{estimateDispersionsGeneEst}},
\code{\link{estimateDispersionsFit}}, and
\code{\link{estimateDispersionsMAP}}.
}
\examples{

dds <- makeExampleDESeqDataSet()
dds <- estimateSizeFactors(dds)
dds <- estimateDispersions(dds)
head(dispersions(dds))

}
\references{
\itemize{
  \item Simon Anders, Wolfgang Huber: Differential expression analysis for sequence count data.
Genome Biology 11 (2010) R106, \url{http://dx.doi.org/10.1186/gb-2010-11-10-r106}
  \item McCarthy, DJ, Chen, Y, Smyth, GK: Differential expression analysis of multifactor RNA-Seq
experiments with respect to biological variation. Nucleic Acids Research 40 (2012), 4288-4297,
\url{http://dx.doi.org/10.1093/nar/gks042}
  \item Wu, H., Wang, C. & Wu, Z. A new shrinkage estimator for dispersion improves differential
expression detection in RNA-seq data. Biostatistics (2012).
\url{http://dx.doi.org/10.1093/biostatistics/kxs033}
}
}
