% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/ssgseaParam.R
\docType{class}
\name{ssgseaParam-class}
\alias{ssgseaParam-class}
\alias{ssgseaParam}
\title{\code{ssgseaParam} class}
\usage{
ssgseaParam(
  exprData,
  geneSets,
  assay = NA_character_,
  annotation = NA_character_,
  minSize = 1,
  maxSize = Inf,
  alpha = 0.25,
  normalize = TRUE
)
}
\arguments{
\item{exprData}{The expression data.  Must be one of the classes
supported by \code{\linkS4class{GsvaExprData}}.}

\item{geneSets}{The gene sets.  Must be one of the classes supported by
\code{\linkS4class{GsvaGeneSets}}.}

\item{assay}{The name of the assay to use in case \code{exprData} is a multi-assay
container, otherwise ignored.  By default, the first assay is used.}

\item{annotation}{The name of a Bioconductor annotation package for the gene
identifiers occurring in the row names of the expression data matrix.  This
can be used to map gene identifiers occurring in the gene sets if those are
provided in a \code{\link{GeneSetCollection}}.  By default gene identifiers used in
expression data matrix and gene sets are matched directly.}

\item{minSize}{Minimum size of the resulting gene sets after gene identifier
mapping. By default, the minimum size is 1.}

\item{maxSize}{Maximum size of the resulting gene sets after gene identifier
mapping. By default, the maximum size is \code{Inf}.}

\item{alpha}{Numeric vector of length 1.  The exponent defining the
weight of the tail in the random walk performed by the \code{ssGSEA} (Barbie et
al., 2009) method.  The default value is 0.25 as described in the paper.}

\item{normalize}{Logical vector of length 1; if \code{TRUE}  runs the \code{ssGSEA} method
from Barbie et al. (2009) normalizing the scores by the absolute difference
between the minimum and the maximum, as described in their paper. Otherwise
this last normalization step is skipped.}
}
\value{
A new \code{\linkS4class{ssgseaParam}} object.
}
\description{
Method-specific parameters for the ssGSEA method.

Objects of class \code{ssgseaParam} contain the parameters for running
the \code{ssGSEA} method.
}
\details{
In addition to the two common parameter slots inherited from
\verb{[GsvaMethodParam]}, this class has slots for the two method-specific
parameters of the \code{ssGSEA} method described below.

In addition to an expression data set and a collection of
gene sets, \code{ssGSEA} takes two method-specific parameters as described below.
}
\section{Slots}{

\describe{
\item{\code{alpha}}{Numeric vector of length 1.  The exponent defining the
weight of the tail in the random walk performed by the ssGSEA (Barbie et
al., 2009) method.}

\item{\code{normalize}}{Logical vector of length 1.  If \code{TRUE} runs the ssGSEA
method from Barbie et al. (2009) normalizing the scores by the absolute
difference between the minimum and the maximum, as described in their paper.
Otherwise this last normalization step is skipped.}
}}

\examples{
library(GSVA)
library(GSVAdata)

data(leukemia)
data(c2BroadSets)

## for simplicity, use only a subset of the sample data
ses <- leukemia_eset[1:1000, ]
gsc <- c2BroadSets[1:100]
sp1 <- ssgseaParam(ses, gsc)
sp1

}
\references{
Barbie, D.A. et al. Systematic RNA interference reveals that
oncogenic KRAS-driven cancers require TBK1.
\emph{Nature}, 462(5):108-112, 2009.
\href{https://doi.org/10.1038/nature08460}{DOI}
}
\seealso{
\code{\linkS4class{GsvaExprData}},
\code{\linkS4class{GsvaGeneSets}},
\code{\linkS4class{GsvaMethodParam}},
\code{\linkS4class{plageParam}},
\code{\linkS4class{zscoreParam}},
\code{\linkS4class{gsvaParam}}
}
