% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute}
\alias{impute}
\title{Impute missing values from a fitted MOFA}
\usage{
impute(
  object,
  views = "all",
  groups = "all",
  factors = "all",
  add_intercept = TRUE
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{views}{character vector with the view name(s), or numeric vector with view index(es).}

\item{groups}{character vector with the group name(s), or numeric vector with group index(es).}

\item{factors}{character vector with the factor names, or numeric vector with the factor index(es).
\itemize{
\item \strong{response}:{gives mean for gaussian and poisson and probabilities for bernoulli.}
\item \strong{link}: {gives the linear predictions.}
\item \strong{inRange}: {rounds the fitted values from "terms" for integer-valued distributions to the next integer (default).}
}}

\item{add_intercept}{add feature intercepts to the imputation (default is TRUE).}
}
\value{
This method fills the \code{imputed_data} slot by replacing the missing values in the input data with the model predictions.
}
\description{
This function uses the latent factors and the loadings to impute missing values.
}
\details{
MOFA generates a denoised and condensed low-dimensional representation of the data that captures the main sources of heterogeneity of the data.
This representation can be used to reconstruct the data, simply using the equation \code{Y = WX}. 
For more details read the supplementary methods of the manuscript. \cr
Note that with \code{\link{impute}} you can only generate the point estimates (the means of the posterior distributions). 
If you want to add uncertainity estimates (the variance) you need to set \code{impute=TRUE} in the training options.
See \code{\link{get_default_training_options}}.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Impute missing values in all data modalities
imputed_data <- impute(model, views = "all")

# Impute missing values in all data modalities using factors 1:3
imputed_data <- impute(model, views = "all", factors = 1:3)
}
