% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_original_vs_reconstructed.R
\name{plot_original_vs_reconstructed}
\alias{plot_original_vs_reconstructed}
\title{Plot the similarity between a mutation matrix and its reconstructed profile}
\usage{
plot_original_vs_reconstructed(
  mut_matrix,
  reconstructed,
  y_intercept = 0.95,
  ylims = c(0.6, 1)
)
}
\arguments{
\item{mut_matrix}{mutation count matrix (dimensions: x mutation types
X n samples)}

\item{reconstructed}{A reconstructed mutation count matrix}

\item{y_intercept}{The y intercept of the plotted horizontal line. Default: 0.95.}

\item{ylims}{The limits of the y axis. Default: c(0.6, 1)}
}
\value{
A ggplot figure
}
\description{
When a reconstructed profile has a cosine similarity of more than 0.95 with
original, the reconstructed profile is considered very good.
}
\examples{

## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))

## Extracting signatures can be computationally intensive, so
## we use pre-computed data generated with the following command:
# nmf_res <- extract_signatures(mut_mat, rank = 2)

nmf_res <- readRDS(system.file("states/nmf_res_data.rds",
  package = "MutationalPatterns"
))

## Create figure
plot_original_vs_reconstructed(mut_mat, nmf_res$reconstructed)

## You can also use the results of signature refitting.
## Here we load some data as an example
fit_res <- readRDS(system.file("states/snv_refit.rds",
  package = "MutationalPatterns"
))
plot_original_vs_reconstructed(mut_mat, fit_res$reconstructed)

## You can also change the height of the horizontal line
plot_original_vs_reconstructed(mut_mat, fit_res$reconstructed, y_intercept = 0.90)

## It's also possible to change the limits of the y axis
plot_original_vs_reconstructed(mut_mat, fit_res$reconstructed, ylims = c(0, 1))
}
