% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_signatures.R
\name{cluster_signatures}
\alias{cluster_signatures}
\title{Signature clustering function}
\usage{
cluster_signatures(signatures, method = "complete")
}
\arguments{
\item{signatures}{Matrix with 96 trinucleotides (rows) and any number of
signatures (columns)}

\item{method}{The agglomeration method to be used for hierarchical
clustering. This should be one of "ward.D", "ward.D2", "single", "complete",
"average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or
"centroid" (= UPGMC). Default = "complete".}
}
\value{
hclust object
}
\description{
Hierarchical clustering of signatures based on cosine similarity
}
\examples{
## Get signatures
signatures <- get_known_signatures()

## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))


## Hierarchically cluster the cancer signatures based on cosine similarity
hclust_signatures <- cluster_signatures(signatures)

## Plot dendrogram
plot(hclust_signatures)
}
\seealso{
\code{\link{plot_contribution_heatmap}}
}
