% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDots.R
\name{plotDots}
\alias{plotDots}
\title{Create a dot plot of expression values}
\usage{
plotDots(
  object,
  features,
  group = NULL,
  block = NULL,
  exprs_values = "logcounts",
  detection_limit = 0,
  zlim = NULL,
  colour = color,
  color = NULL,
  max_detected = NULL,
  other_fields = list(),
  by_exprs_values = exprs_values,
  swap_rownames = NULL,
  center = FALSE,
  scale = FALSE,
  assay.type = exprs_values,
  by.assay.type = by_exprs_values
)
}
\arguments{
\item{object}{A \linkS4class{SingleCellExperiment} object.}

\item{features}{A character (or factor) vector of row names, a logical vector, or integer vector of indices specifying rows of \code{object} to visualize. When using character or integer vectors, the ordering specified by the user is retained. When using factor vectors, ordering is controlled by the factor levels.}

\item{group}{String specifying the field of \code{\link{colData}(object)} containing the grouping factor, e.g., cell types or clusters.
Alternatively, any value that can be used in the \code{by} argument to \code{\link{retrieveCellInfo}}.}

\item{block}{String specifying the field of \code{\link{colData}(object)} containing a blocking factor (e.g., batch of origin).
Alternatively, any value that can be used in the \code{by} argument to \code{\link{retrieveCellInfo}}.}

\item{exprs_values}{Alias to \code{assay.type}.}

\item{detection_limit}{Numeric scalar providing the value above which observations are deemed to be expressed.}

\item{zlim}{A numeric vector of length 2, specifying the upper and lower bounds for colour mapping of expression values.
Values outside this range are set to the most extreme colour.
If \code{NULL}, it defaults to the range of the expression matrix.
If \code{center=TRUE}, this defaults to the range of the centered expression matrix, made symmetric around zero.}

\item{colour}{A vector of colours specifying the palette to use for increasing expression. 
This defaults to \link[viridis]{viridis} if \code{center=FALSE}, and the the \code{"RdYlBu"}
colour palette from \code{\link[RColorBrewer]{brewer.pal}} otherwise.}

\item{color}{Alias to \code{colour}.}

\item{max_detected}{Numeric value specifying the cap on the proportion of 
detected expression values.}

\item{other_fields}{Additional feature-based fields to include in the data.frame, see \code{?"\link{scater-plot-args}"} for details.
Note that any \link{AsIs} vectors or data.frames must be of length equal to \code{nrow(object)}, not \code{features}.}

\item{by_exprs_values}{Alias for \code{by.assay.type}.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to 
identify features instead of \code{rownames(object)} when labelling plot 
elements.}

\item{center}{A logical scalar indicating whether each feature should have its mean expression 
(specifically, the mean of averages across all groups) centered at zero prior to plotting.}

\item{scale}{A logical scalar specifying whether each row should have its
average expression values scaled to unit variance prior to plotting.}

\item{assay.type}{A string or integer scalar indicating which assay of \code{object} should be used as expression values.}

\item{by.assay.type}{A string or integer scalar specifying which assay to obtain expression values from, for entries of \code{other_fields}. Also alias \code{by_exprs_values} is accepted as argument name.}
}
\value{
A \link{ggplot} object containing a dot plot.
}
\description{
Create a dot plot of expression values for a grouping of cells,
where the size and colour of each dot represents the proportion of detected expression values and the average expression,
respectively, for each feature in each group of cells.
}
\details{
This implements a \pkg{Seurat}-style \dQuote{dot plot} that creates a dot for each feature (row) in each group of cells (column).
The proportion of detected expression values and the average expression for each feature in each group of cells is visualized efficiently using the size and colour, respectively, of each dot.
If \code{block} is specified, batch-corrected averages and proportions for each group are computed with \code{\link{correctGroupSummary}}.

Some caution is required during interpretation due to the difficulty of simultaneously interpreting both size and colour.
For example, if we coloured by z-score on a conventional blue-white-red colour axis, a gene that is downregulated in a group of cells would show up as a small blue dot.
If the background colour was also white, this could be easily mistaken for a gene that is not downregulated at all.
We suggest choosing a colour scale that remains distinguishable from the background colour at all points.
Admittedly, that is easier said than done as many colour scales will approach a lighter colour at some stage, so some magnifying glasses may be required.

We can also cap the colour and size scales using \code{zlim} and \code{max_detected}, respectively.
This aims to preserve resolution for low-abundance genes by preventing domination of the scales by high-abundance features.
}
\examples{
sce <- mockSCE()
sce <- logNormCounts(sce)

plotDots(sce, features=rownames(sce)[1:10], group="Cell_Cycle")
plotDots(sce, features=rownames(sce)[1:10], group="Cell_Cycle", center=TRUE)
plotDots(sce, features=rownames(sce)[1:10], group="Cell_Cycle", scale=TRUE)
plotDots(sce, features=rownames(sce)[1:10], group="Cell_Cycle", center=TRUE, scale=TRUE)

plotDots(sce, features=rownames(sce)[1:10], group="Treatment", block="Cell_Cycle")

}
\seealso{
\code{\link{plotExpression}} and \code{\link{plotHeatmap}}, 
for alternatives to visualizing group-level expression values.
}
\author{
Aaron Lun
}
