% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{background_grid}
\alias{background_grid}
\title{Add/modify/remove the background grid in a ggplot2 plot}
\usage{
background_grid(major = c("xy", "x", "y", "only_minor", "none"),
  minor = c("none", "xy", "x", "y"), size.major = 0.5,
  size.minor = 0.2, color.major = "grey85", color.minor = "grey85",
  colour.major, colour.minor)
}
\arguments{
\item{major}{Specifies along which axes you would like to plot major grid lines. Options are "xy", "x",
"y", "none".}

\item{minor}{Specifies along which axes you would like to plot minor grid lines. Options are "xy", "x",
"y", "none".}

\item{size.major}{Size of the major grid lines.}

\item{size.minor}{Size of the minor grid lines.}

\item{color.major, colour.major}{Color of the major grid lines.}

\item{color.minor, colour.minor}{Color of the minor grid lines.}
}
\description{
This function provides a simple way to set the background grid in ggplot2. It
doesn't do anything that can't be done just the same with \code{\link[=theme]{theme()}}. However, it simplifies
creation of the most commonly needed variations.
}
\details{
Note: This function completely overwrites all background grid settings of the current theme. If that
is not what you want, you may be better off using \code{\link[=theme]{theme()}} directly.
}
\examples{
library(ggplot2)

ggplot(iris, aes(Sepal.Length, Sepal.Width)) +
 geom_point() +
 theme_half_open() +
 background_grid()
}
