% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_edge_df.R
\name{create_edge_df}
\alias{create_edge_df}
\title{Create an edge data frame}
\usage{
create_edge_df(from, to, rel = NULL, ...)
}
\arguments{
\item{from}{A vector of node ID values from which edges are outbound. The
vector length must equal that of the \code{to} vector.}

\item{to}{A vector of node ID values to which edges are incoming. The vector
length must equal that of the \code{from} vector.}

\item{rel}{An optional \code{rel} label for each edge.}

\item{...}{One or more vectors for associated edge attributes. Can be some of \code{\link[=edge_aes]{edge_aes()}}}
}
\value{
An edge data frame (edf).
}
\description{
Combine several vectors for edges and their attributes into a data frame,
which can be combined with other similarly-generated data frames, or, added
to a graph object. An edge data frame, or edf, has at least the following
columns:
\itemize{
\item \code{id} (of type \code{integer})
\item \code{from} (of type \code{integer})
\item \code{to} (of type \code{integer})
\item \code{rel} (of type \code{character})
}

An arbitrary number of additional columns containing aesthetic or data
attributes can be part of the edf, so long as they follow the aforementioned
columns. Some examples are included in \code{\link[=edge_aes]{edge_aes()}}
}
\examples{
# Create a simple edge data frame (edf) and
# view the results
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "a")

# Display the edge data frame
edf

# Create an edf with additional edge
# attributes (where their classes will
# be inferred from the input vectors)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "a",
    length = c(50, 100, 250),
    color = "green",
    width = c(1, 5, 2))

# Display the edge data frame
edf

}
\seealso{
Other edge creation and removal: 
\code{\link{add_edge}()},
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{delete_edge}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir}()},
\code{\link{rev_edge_dir_ws}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs}()},
\code{\link{set_edge_attrs_ws}()}
}
\concept{edge creation and removal}
