% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_pd.R
\name{interpret_pd}
\alias{interpret_pd}
\title{Interpret Probability of Direction (pd)}
\usage{
interpret_pd(pd, rules = "default", ...)
}
\arguments{
\item{pd}{Value or vector of probabilities of direction.}

\item{rules}{Can be \code{"default"}, \code{"makowski2019"} or a custom set of
\code{\link[=rules]{rules()}}.}

\item{...}{Not directly used.}
}
\description{
Interpret Probability of Direction (pd)
}
\section{Rules}{

\itemize{
\item Default (i.e., equivalent to p-values)
\itemize{
\item \strong{pd <= 0.975} - not significant
\item \strong{pd > 0.975} - significant
}
\item Makowski et al. (2019) (\code{"makowski2019"})
\itemize{
\item \strong{pd <= 0.95} - uncertain
\item \strong{pd > 0.95} - possibly existing
\item \strong{pd > 0.97} - likely existing
\item \strong{pd > 0.99} - probably existing
\item \strong{pd > 0.999} - certainly existing
}
}
}

\examples{
interpret_pd(.98)
interpret_pd(c(.96, .99), rules = "makowski2019")
}
\references{
\itemize{
\item Makowski, D., Ben-Shachar, M. S., Chen, S. H., and Lüdecke, D. (2019). Indices of effect existence and significance in the Bayesian framework. Frontiers in psychology, 10, 2767.
}
}
\keyword{interpreters}
