% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-extractData.R
\name{extractData}
\alias{extractData}
\alias{extractData.lvmfit}
\title{Extract Data From a Latent Variable Model}
\usage{
extractData(object, design.matrix, as.data.frame, envir, rm.na)

\method{extractData}{lvmfit}(
  object,
  design.matrix = FALSE,
  as.data.frame = TRUE,
  envir = environment(),
  rm.na = TRUE
)
}
\arguments{
\item{object}{the fitted model.}

\item{design.matrix}{[logical] should the data be extracted after transformation (e.g. conversion of categorical variables to dummy variables)?
Otherwise the original data will be returned.}

\item{as.data.frame}{[logical] should the output be converted into a \code{data.frame} object?}

\item{envir}{[environment] the environment from which to search the data.}

\item{rm.na}{[logical] should the lines containing missing values in the dataset be removed?}
}
\value{
a dataset.
}
\description{
Extract data from a latent variable model.
}
\examples{
#### simulate data ####
set.seed(10)
n <- 101

Y1 <- rnorm(n, mean = 0)
Y2 <- rnorm(n, mean = 0.3)
Id <- findInterval(runif(n), seq(0.1,1,0.1))
data.df <- rbind(data.frame(Y=Y1,G="1",Id = Id),
           data.frame(Y=Y2,G="2",Id = Id)       
           )

#### latent variable model ####
library(lava)
e.lvm <- estimate(lvm(Y ~ G), data = data.df)
extractData(e.lvm)
extractData(e.lvm, design.matrix = TRUE)

}
\concept{extractor}
