% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmvt.R
\name{dmvt}
\alias{dmvt}
\title{Fast computation of the multivariate Student's t density.}
\usage{
dmvt(X, mu, sigma, df, log = FALSE, ncores = 1, isChol = FALSE)
}
\arguments{
\item{X}{matrix n by d where each row is a d dimensional random vector. Alternatively \code{X} can be a d-dimensional vector.}

\item{mu}{vector of length d, representing the mean of the distribution.}

\item{sigma}{scale matrix (d x d). Alternatively it can be the cholesky decomposition
of the scale matrix. In that case isChol should be set to TRUE. Notice that ff the degrees of 
freedom (the argument \code{df}) is larger than 2, the \code{Cov(X)=sigma*df/(df-2)}.}

\item{df}{a positive scalar representing the degrees of freedom.}

\item{log}{boolean set to true the logarithm of the pdf is required.}

\item{ncores}{Number of cores used. The parallelization will take place only if OpenMP is supported.}

\item{isChol}{boolean set to true is \code{sigma} is the cholesky decomposition of the covariance matrix.}
}
\value{
A vector of length n where the i-the entry contains the pdf of the i-th random vector.
}
\description{
Fast computation of the multivariate Student's t density.
}
\details{
There are many candidates for the multivariate generalization of Student's t-distribution, here we use
         the parametrization described here \url{https://en.wikipedia.org/wiki/Multivariate_t-distribution}. NB: at the moment 
         the parallelization does not work properly on Solaris OS when \code{ncores>1}. Hence, \code{dmvt()} checks if the OS 
         is Solaris and, if this the case, it imposes \code{ncores==1}.
}
\examples{
N <- 100
d <- 5
mu <- 1:d
df <- 4
X <- t(t(matrix(rnorm(N*d), N, d)) + mu)
tmp <- matrix(rnorm(d^2), d, d)
mcov <- tcrossprod(tmp, tmp)  + diag(0.5, d)
myChol <- chol(mcov)

head(dmvt(X, mu, mcov, df = df), 10)
head(dmvt(X, mu, myChol, df = df, isChol = TRUE), 10)

}
\author{
Matteo Fasiolo <matteo.fasiolo@gmail.com>
}
