% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write.molecules}
\alias{write.molecules}
\title{Write molecules to disk.}
\usage{
write.molecules(mols, filename, together = TRUE, write.props = FALSE)
}
\arguments{
\item{mols}{A `list` of `jobjRef` objects representing  `IAtomContainer` objects}

\item{filename}{The name of the SD file to write. Note that if
`together` is `FALSE` then this argument is taken as a prefix for
the name of the individual files}

\item{together}{If `TRUE` then all the molecules are written to a
single SD file. If `FALSE` each molecule is written to an
individual file}

\item{write.props}{If `TRUE`, keyed properties are included in the SD file output}
}
\description{
This function writes one or more molecules to an SD file on disk,
which can be of the single- or multi-molecule variety. In
addition, if the molecule has keyed properties, they can also be
written out as SD tags.
}
\details{
In case individual SD files are desired the
\code{together} argument can be set ot \code{FALSE}. In this case, the
value of \code{filename} is used as a prefix, to which a numeric
identifier and the suffix of ".sdf" is appended.
}
\seealso{
\code{\link{load.molecules}}, \code{\link{parse.smiles}}, \code{\link{iload.molecules}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
