# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Ade.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# interface
class Ade(Interface):
    idlType = "pdumodel.Ade:1.0.0"

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.Ade.MetaData:1.0.0"
        elements = ["adeType", "channels", "currentDivider", "voltageDivider", "energyDivider"]

        def __init__(self, adeType="", channels=0, currentDivider=0.0, voltageDivider=0.0, energyDivider=0.0):
            typecheck.is_string(adeType, AssertionError)
            typecheck.is_int(channels, AssertionError)
            typecheck.is_double(currentDivider, AssertionError)
            typecheck.is_double(voltageDivider, AssertionError)
            typecheck.is_double(energyDivider, AssertionError)

            self.adeType = adeType
            self.channels = channels
            self.currentDivider = currentDivider
            self.voltageDivider = voltageDivider
            self.energyDivider = energyDivider

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                adeType = json['adeType'],
                channels = json['channels'],
                currentDivider = json['currentDivider'],
                voltageDivider = json['voltageDivider'],
                energyDivider = json['energyDivider'],
            )
            return obj

        def encode(self):
            json = {}
            json['adeType'] = self.adeType
            json['channels'] = self.channels
            json['currentDivider'] = self.currentDivider
            json['voltageDivider'] = self.voltageDivider
            json['energyDivider'] = self.energyDivider
            return json

    # structure
    class Sample(Structure):
        idlType = "pdumodel.Ade.Sample:1.0.0"
        elements = ["vrms", "irms", "watt", "va", "wh", "vah"]

        def __init__(self, vrms=0, irms=0, watt=0, va=0, wh=0, vah=0):
            typecheck.is_long(vrms, AssertionError)
            typecheck.is_long(irms, AssertionError)
            typecheck.is_long(watt, AssertionError)
            typecheck.is_long(va, AssertionError)
            typecheck.is_long(wh, AssertionError)
            typecheck.is_long(vah, AssertionError)

            self.vrms = vrms
            self.irms = irms
            self.watt = watt
            self.va = va
            self.wh = wh
            self.vah = vah

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                vrms = int(json['vrms']),
                irms = int(json['irms']),
                watt = int(json['watt']),
                va = int(json['va']),
                wh = int(json['wh']),
                vah = int(json['vah']),
            )
            return obj

        def encode(self):
            json = {}
            json['vrms'] = self.vrms
            json['irms'] = self.irms
            json['watt'] = self.watt
            json['va'] = self.va
            json['wh'] = self.wh
            json['vah'] = self.vah
            return json

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Ade.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Ade.MetaData, DecodeException)
            return _ret_

    class _getLatestSample(Interface.Method):
        name = 'getLatestSample'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.pdumodel.Ade.Sample.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Ade.Sample, DecodeException)
            return _ret_

    class _getCalibrationData(Interface.Method):
        name = 'getCalibrationData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = dict([(
                elem['key'],
                int(elem['value']))
                for elem in rsp['_ret_']])
            return _ret_

    class _setCalibrationData(Interface.Method):
        name = 'setCalibrationData'

        @staticmethod
        def encode(regs):
            args = {}
            args['regs'] = [dict(
                key = k,
                value = v)
                for k, v in regs.items()]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Ade, self).__init__(target, agent)
        self.getMetaData = Ade._getMetaData(self)
        self.getLatestSample = Ade._getLatestSample(self)
        self.getCalibrationData = Ade._getCalibrationData(self)
        self.setCalibrationData = Ade._setCalibrationData(self)

#
# Section generated by IdlC from "Cascade.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# interface
class Cascade(Interface):
    idlType = "pdumodel.Cascade:1.0.0"

    # structure
    class Info(Structure):
        idlType = "pdumodel.Cascade.Info:1.0.0"
        elements = ["pduIds"]

        def __init__(self, pduIds=[]):
            for x0 in pduIds:
                typecheck.is_int(x0, AssertionError)

            self.pduIds = pduIds

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                pduIds = [x0 for x0 in json['pduIds']],
            )
            return obj

        def encode(self):
            json = {}
            json['pduIds'] = [x0 for x0 in self.pduIds]
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Cascade.Info.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Cascade.Info, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Cascade, self).__init__(target, agent)
        self.getInfo = Cascade._getInfo(self)

#
# Section generated by IdlC from "ResidualCurrentStateSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.sensors


# interface
class ResidualCurrentStateSensor(raritan.rpc.sensors.StateSensor):
    idlType = "pdumodel.ResidualCurrentStateSensor:2.0.6"

    STATE_NORMAL = 0

    STATE_WARNING = 1

    STATE_CRITICAL = 2

    STATE_SELFTEST = 3

    STATE_FAILURE = 4

    class _startSelfTest(Interface.Method):
        name = 'startSelfTest'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(ResidualCurrentStateSensor, self).__init__(target, agent)
        self.startSelfTest = ResidualCurrentStateSensor._startSelfTest(self)

#
# Section generated by IdlC from "Pole.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel

import raritan.rpc.sensors


# enumeration
class PowerLine(Enumeration):
    idlType = "pdumodel.PowerLine:3.0.0"
    values = ["L1", "L2", "L3", "NEUTRAL", "EARTH", "PLUS", "MINUS"]

PowerLine.L1 = PowerLine(0)
PowerLine.L2 = PowerLine(1)
PowerLine.L3 = PowerLine(2)
PowerLine.NEUTRAL = PowerLine(3)
PowerLine.EARTH = PowerLine(4)
PowerLine.PLUS = PowerLine(5)
PowerLine.MINUS = PowerLine(6)

# structure
class Pole(Structure):
    idlType = "pdumodel.Pole:10.0.0"
    elements = ["label", "line", "nodeId", "voltage", "voltageLN", "current", "peakCurrent", "activePower", "reactivePower", "apparentPower", "powerFactor", "phaseAngle", "displacementPowerFactor", "activeEnergy", "apparentEnergy", "residualCurrent", "residualACCurrent", "residualDCCurrent", "crestFactor", "voltageThd", "currentThd", "residualCurrentStatus"]

    def __init__(self, label="", line=None, nodeId=0, voltage=None, voltageLN=None, current=None, peakCurrent=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, phaseAngle=None, displacementPowerFactor=None, activeEnergy=None, apparentEnergy=None, residualCurrent=None, residualACCurrent=None, residualDCCurrent=None, crestFactor=None, voltageThd=None, currentThd=None, residualCurrentStatus=None):
        if line is None:
            line = raritan.rpc.pdumodel.PowerLine.L1
        typecheck.is_string(label, AssertionError)
        typecheck.is_enum(line, raritan.rpc.pdumodel.PowerLine, AssertionError)
        typecheck.is_int(nodeId, AssertionError)
        typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(voltageLN, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(residualCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(residualACCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(residualDCCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(voltageThd, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(currentThd, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(residualCurrentStatus, raritan.rpc.pdumodel.ResidualCurrentStateSensor, AssertionError)

        self.label = label
        self.line = line
        self.nodeId = nodeId
        self.voltage = voltage
        self.voltageLN = voltageLN
        self.current = current
        self.peakCurrent = peakCurrent
        self.activePower = activePower
        self.reactivePower = reactivePower
        self.apparentPower = apparentPower
        self.powerFactor = powerFactor
        self.phaseAngle = phaseAngle
        self.displacementPowerFactor = displacementPowerFactor
        self.activeEnergy = activeEnergy
        self.apparentEnergy = apparentEnergy
        self.residualCurrent = residualCurrent
        self.residualACCurrent = residualACCurrent
        self.residualDCCurrent = residualDCCurrent
        self.crestFactor = crestFactor
        self.voltageThd = voltageThd
        self.currentThd = currentThd
        self.residualCurrentStatus = residualCurrentStatus

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            label = json['label'],
            line = raritan.rpc.pdumodel.PowerLine.decode(json['line']),
            nodeId = json['nodeId'],
            voltage = Interface.decode(json['voltage'], agent),
            voltageLN = Interface.decode(json['voltageLN'], agent),
            current = Interface.decode(json['current'], agent),
            peakCurrent = Interface.decode(json['peakCurrent'], agent),
            activePower = Interface.decode(json['activePower'], agent),
            reactivePower = Interface.decode(json['reactivePower'], agent),
            apparentPower = Interface.decode(json['apparentPower'], agent),
            powerFactor = Interface.decode(json['powerFactor'], agent),
            phaseAngle = Interface.decode(json['phaseAngle'], agent),
            displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent),
            activeEnergy = Interface.decode(json['activeEnergy'], agent),
            apparentEnergy = Interface.decode(json['apparentEnergy'], agent),
            residualCurrent = Interface.decode(json['residualCurrent'], agent),
            residualACCurrent = Interface.decode(json['residualACCurrent'], agent),
            residualDCCurrent = Interface.decode(json['residualDCCurrent'], agent),
            crestFactor = Interface.decode(json['crestFactor'], agent),
            voltageThd = Interface.decode(json['voltageThd'], agent),
            currentThd = Interface.decode(json['currentThd'], agent),
            residualCurrentStatus = Interface.decode(json['residualCurrentStatus'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['label'] = self.label
        json['line'] = raritan.rpc.pdumodel.PowerLine.encode(self.line)
        json['nodeId'] = self.nodeId
        json['voltage'] = Interface.encode(self.voltage)
        json['voltageLN'] = Interface.encode(self.voltageLN)
        json['current'] = Interface.encode(self.current)
        json['peakCurrent'] = Interface.encode(self.peakCurrent)
        json['activePower'] = Interface.encode(self.activePower)
        json['reactivePower'] = Interface.encode(self.reactivePower)
        json['apparentPower'] = Interface.encode(self.apparentPower)
        json['powerFactor'] = Interface.encode(self.powerFactor)
        json['phaseAngle'] = Interface.encode(self.phaseAngle)
        json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
        json['activeEnergy'] = Interface.encode(self.activeEnergy)
        json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
        json['residualCurrent'] = Interface.encode(self.residualCurrent)
        json['residualACCurrent'] = Interface.encode(self.residualACCurrent)
        json['residualDCCurrent'] = Interface.encode(self.residualDCCurrent)
        json['crestFactor'] = Interface.encode(self.crestFactor)
        json['voltageThd'] = Interface.encode(self.voltageThd)
        json['currentThd'] = Interface.encode(self.currentThd)
        json['residualCurrentStatus'] = Interface.encode(self.residualCurrentStatus)
        return json

# structure
class MeteredLinePair(Structure):
    idlType = "pdumodel.MeteredLinePair:3.0.0"
    elements = ["leftLine", "rightLine", "leftNodeId", "rightNodeId", "voltage", "current", "peakCurrent", "activePower", "reactivePower", "apparentPower", "powerFactor", "phaseAngle", "displacementPowerFactor", "activeEnergy", "apparentEnergy", "crestFactor", "voltageThd", "currentThd"]

    def __init__(self, leftLine=None, rightLine=None, leftNodeId=0, rightNodeId=0, voltage=None, current=None, peakCurrent=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, phaseAngle=None, displacementPowerFactor=None, activeEnergy=None, apparentEnergy=None, crestFactor=None, voltageThd=None, currentThd=None):
        if leftLine is None:
            leftLine = raritan.rpc.pdumodel.PowerLine.L1
        if rightLine is None:
            rightLine = raritan.rpc.pdumodel.PowerLine.L1
        typecheck.is_enum(leftLine, raritan.rpc.pdumodel.PowerLine, AssertionError)
        typecheck.is_enum(rightLine, raritan.rpc.pdumodel.PowerLine, AssertionError)
        typecheck.is_int(leftNodeId, AssertionError)
        typecheck.is_int(rightNodeId, AssertionError)
        typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(voltageThd, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(currentThd, raritan.rpc.sensors.NumericSensor, AssertionError)

        self.leftLine = leftLine
        self.rightLine = rightLine
        self.leftNodeId = leftNodeId
        self.rightNodeId = rightNodeId
        self.voltage = voltage
        self.current = current
        self.peakCurrent = peakCurrent
        self.activePower = activePower
        self.reactivePower = reactivePower
        self.apparentPower = apparentPower
        self.powerFactor = powerFactor
        self.phaseAngle = phaseAngle
        self.displacementPowerFactor = displacementPowerFactor
        self.activeEnergy = activeEnergy
        self.apparentEnergy = apparentEnergy
        self.crestFactor = crestFactor
        self.voltageThd = voltageThd
        self.currentThd = currentThd

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            leftLine = raritan.rpc.pdumodel.PowerLine.decode(json['leftLine']),
            rightLine = raritan.rpc.pdumodel.PowerLine.decode(json['rightLine']),
            leftNodeId = json['leftNodeId'],
            rightNodeId = json['rightNodeId'],
            voltage = Interface.decode(json['voltage'], agent),
            current = Interface.decode(json['current'], agent),
            peakCurrent = Interface.decode(json['peakCurrent'], agent),
            activePower = Interface.decode(json['activePower'], agent),
            reactivePower = Interface.decode(json['reactivePower'], agent),
            apparentPower = Interface.decode(json['apparentPower'], agent),
            powerFactor = Interface.decode(json['powerFactor'], agent),
            phaseAngle = Interface.decode(json['phaseAngle'], agent),
            displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent),
            activeEnergy = Interface.decode(json['activeEnergy'], agent),
            apparentEnergy = Interface.decode(json['apparentEnergy'], agent),
            crestFactor = Interface.decode(json['crestFactor'], agent),
            voltageThd = Interface.decode(json['voltageThd'], agent),
            currentThd = Interface.decode(json['currentThd'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['leftLine'] = raritan.rpc.pdumodel.PowerLine.encode(self.leftLine)
        json['rightLine'] = raritan.rpc.pdumodel.PowerLine.encode(self.rightLine)
        json['leftNodeId'] = self.leftNodeId
        json['rightNodeId'] = self.rightNodeId
        json['voltage'] = Interface.encode(self.voltage)
        json['current'] = Interface.encode(self.current)
        json['peakCurrent'] = Interface.encode(self.peakCurrent)
        json['activePower'] = Interface.encode(self.activePower)
        json['reactivePower'] = Interface.encode(self.reactivePower)
        json['apparentPower'] = Interface.encode(self.apparentPower)
        json['powerFactor'] = Interface.encode(self.powerFactor)
        json['phaseAngle'] = Interface.encode(self.phaseAngle)
        json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
        json['activeEnergy'] = Interface.encode(self.activeEnergy)
        json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
        json['crestFactor'] = Interface.encode(self.crestFactor)
        json['voltageThd'] = Interface.encode(self.voltageThd)
        json['currentThd'] = Interface.encode(self.currentThd)
        return json

# structure
class DoublePole(Structure):
    idlType = "pdumodel.DoublePole:9.0.0"
    elements = ["label", "line", "inNodeId", "outNodeId", "voltage", "voltageLN", "current", "peakCurrent", "activePower", "apparentPower", "powerFactor", "activeEnergy", "apparentEnergy"]

    def __init__(self, label="", line=None, inNodeId=0, outNodeId=0, voltage=None, voltageLN=None, current=None, peakCurrent=None, activePower=None, apparentPower=None, powerFactor=None, activeEnergy=None, apparentEnergy=None):
        if line is None:
            line = raritan.rpc.pdumodel.PowerLine.L1
        typecheck.is_string(label, AssertionError)
        typecheck.is_enum(line, raritan.rpc.pdumodel.PowerLine, AssertionError)
        typecheck.is_int(inNodeId, AssertionError)
        typecheck.is_int(outNodeId, AssertionError)
        typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(voltageLN, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
        typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)

        self.label = label
        self.line = line
        self.inNodeId = inNodeId
        self.outNodeId = outNodeId
        self.voltage = voltage
        self.voltageLN = voltageLN
        self.current = current
        self.peakCurrent = peakCurrent
        self.activePower = activePower
        self.apparentPower = apparentPower
        self.powerFactor = powerFactor
        self.activeEnergy = activeEnergy
        self.apparentEnergy = apparentEnergy

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            label = json['label'],
            line = raritan.rpc.pdumodel.PowerLine.decode(json['line']),
            inNodeId = json['inNodeId'],
            outNodeId = json['outNodeId'],
            voltage = Interface.decode(json['voltage'], agent),
            voltageLN = Interface.decode(json['voltageLN'], agent),
            current = Interface.decode(json['current'], agent),
            peakCurrent = Interface.decode(json['peakCurrent'], agent),
            activePower = Interface.decode(json['activePower'], agent),
            apparentPower = Interface.decode(json['apparentPower'], agent),
            powerFactor = Interface.decode(json['powerFactor'], agent),
            activeEnergy = Interface.decode(json['activeEnergy'], agent),
            apparentEnergy = Interface.decode(json['apparentEnergy'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['label'] = self.label
        json['line'] = raritan.rpc.pdumodel.PowerLine.encode(self.line)
        json['inNodeId'] = self.inNodeId
        json['outNodeId'] = self.outNodeId
        json['voltage'] = Interface.encode(self.voltage)
        json['voltageLN'] = Interface.encode(self.voltageLN)
        json['current'] = Interface.encode(self.current)
        json['peakCurrent'] = Interface.encode(self.peakCurrent)
        json['activePower'] = Interface.encode(self.activePower)
        json['apparentPower'] = Interface.encode(self.apparentPower)
        json['powerFactor'] = Interface.encode(self.powerFactor)
        json['activeEnergy'] = Interface.encode(self.activeEnergy)
        json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
        return json

# structure
class ThrowPole(Structure):
    idlType = "pdumodel.ThrowPole:3.0.0"
    elements = ["label", "line", "inNodeIds", "outNodeId"]

    def __init__(self, label="", line=None, inNodeIds=[], outNodeId=0):
        if line is None:
            line = raritan.rpc.pdumodel.PowerLine.L1
        typecheck.is_string(label, AssertionError)
        typecheck.is_enum(line, raritan.rpc.pdumodel.PowerLine, AssertionError)
        for x0 in inNodeIds:
            typecheck.is_int(x0, AssertionError)
        typecheck.is_int(outNodeId, AssertionError)

        self.label = label
        self.line = line
        self.inNodeIds = inNodeIds
        self.outNodeId = outNodeId

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            label = json['label'],
            line = raritan.rpc.pdumodel.PowerLine.decode(json['line']),
            inNodeIds = [x0 for x0 in json['inNodeIds']],
            outNodeId = json['outNodeId'],
        )
        return obj

    def encode(self):
        json = {}
        json['label'] = self.label
        json['line'] = raritan.rpc.pdumodel.PowerLine.encode(self.line)
        json['inNodeIds'] = [x0 for x0 in self.inNodeIds]
        json['outNodeId'] = self.outNodeId
        return json

#
# Section generated by IdlC from "Circuit.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class Circuit(Interface):
    idlType = "pdumodel.Circuit:2.0.2"

    ERR_INVALID_PARAM = 1

    ERR_METER_CHANNEL_BUSY = 2

    # enumeration
    class Type(Enumeration):
        idlType = "pdumodel.Circuit_2_0_2.Type:1.0.0"
        values = ["ONE_PHASE_LN", "ONE_PHASE_LL", "ONE_PHASE_LLN", "THREE_PHASE"]

    Type.ONE_PHASE_LN = Type(0)
    Type.ONE_PHASE_LL = Type(1)
    Type.ONE_PHASE_LLN = Type(2)
    Type.THREE_PHASE = Type(3)

    # structure
    class Config(Structure):
        idlType = "pdumodel.Circuit_2_0_2.Config:1.0.0"
        elements = ["position", "type"]

        def __init__(self, position=0, type=None):
            if type is None:
                type = raritan.rpc.pdumodel.Circuit.Type.ONE_PHASE_LN
            typecheck.is_int(position, AssertionError)
            typecheck.is_enum(type, raritan.rpc.pdumodel.Circuit.Type, AssertionError)

            self.position = position
            self.type = type

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                position = json['position'],
                type = raritan.rpc.pdumodel.Circuit.Type.decode(json['type']),
            )
            return obj

        def encode(self):
            json = {}
            json['position'] = self.position
            json['type'] = raritan.rpc.pdumodel.Circuit.Type.encode(self.type)
            return json

    class _getConfig(Interface.Method):
        name = 'getConfig'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Circuit.Config.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Circuit.Config, DecodeException)
            return _ret_

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.Circuit_2_0_2.Sensors:1.0.0"
        elements = ["current", "activePower", "reactivePower", "apparentPower", "powerFactor", "phaseAngle", "displacementPowerFactor", "activeEnergy", "unbalancedCurrent", "crestFactor", "activePowerDemand"]

        def __init__(self, current=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, phaseAngle=None, displacementPowerFactor=None, activeEnergy=None, unbalancedCurrent=None, crestFactor=None, activePowerDemand=None):
            typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePowerDemand, raritan.rpc.sensors.NumericSensor, AssertionError)

            self.current = current
            self.activePower = activePower
            self.reactivePower = reactivePower
            self.apparentPower = apparentPower
            self.powerFactor = powerFactor
            self.phaseAngle = phaseAngle
            self.displacementPowerFactor = displacementPowerFactor
            self.activeEnergy = activeEnergy
            self.unbalancedCurrent = unbalancedCurrent
            self.crestFactor = crestFactor
            self.activePowerDemand = activePowerDemand

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                current = Interface.decode(json['current'], agent),
                activePower = Interface.decode(json['activePower'], agent),
                reactivePower = Interface.decode(json['reactivePower'], agent),
                apparentPower = Interface.decode(json['apparentPower'], agent),
                powerFactor = Interface.decode(json['powerFactor'], agent),
                phaseAngle = Interface.decode(json['phaseAngle'], agent),
                displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent),
                activeEnergy = Interface.decode(json['activeEnergy'], agent),
                unbalancedCurrent = Interface.decode(json['unbalancedCurrent'], agent),
                crestFactor = Interface.decode(json['crestFactor'], agent),
                activePowerDemand = Interface.decode(json['activePowerDemand'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['current'] = Interface.encode(self.current)
            json['activePower'] = Interface.encode(self.activePower)
            json['reactivePower'] = Interface.encode(self.reactivePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['powerFactor'] = Interface.encode(self.powerFactor)
            json['phaseAngle'] = Interface.encode(self.phaseAngle)
            json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['unbalancedCurrent'] = Interface.encode(self.unbalancedCurrent)
            json['crestFactor'] = Interface.encode(self.crestFactor)
            json['activePowerDemand'] = Interface.encode(self.activePowerDemand)
            return json

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Circuit.Sensors.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Circuit.Sensors, DecodeException)
            return _ret_

    class _getPoles(Interface.Method):
        name = 'getPoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.pdumodel.Pole.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Pole, DecodeException)
            return _ret_

    # structure
    class PoleSettings(Structure):
        idlType = "pdumodel.Circuit_2_0_2.PoleSettings:1.0.0"
        elements = ["line", "meterChannel"]

        def __init__(self, line=None, meterChannel=0):
            if line is None:
                line = raritan.rpc.pdumodel.PowerLine.L1
            typecheck.is_enum(line, raritan.rpc.pdumodel.PowerLine, AssertionError)
            typecheck.is_int(meterChannel, AssertionError)

            self.line = line
            self.meterChannel = meterChannel

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                line = raritan.rpc.pdumodel.PowerLine.decode(json['line']),
                meterChannel = json['meterChannel'],
            )
            return obj

        def encode(self):
            json = {}
            json['line'] = raritan.rpc.pdumodel.PowerLine.encode(self.line)
            json['meterChannel'] = self.meterChannel
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.Circuit_2_0_2.Settings:1.0.0"
        elements = ["name", "rating", "ctRating", "poleSettings"]

        def __init__(self, name="", rating=0, ctRating=0, poleSettings=[]):
            typecheck.is_string(name, AssertionError)
            typecheck.is_int(rating, AssertionError)
            typecheck.is_int(ctRating, AssertionError)
            for x0 in poleSettings:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Circuit.PoleSettings, AssertionError)

            self.name = name
            self.rating = rating
            self.ctRating = ctRating
            self.poleSettings = poleSettings

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                rating = json['rating'],
                ctRating = json['ctRating'],
                poleSettings = [raritan.rpc.pdumodel.Circuit.PoleSettings.decode(x0, agent) for x0 in json['poleSettings']],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['rating'] = self.rating
            json['ctRating'] = self.ctRating
            json['poleSettings'] = [raritan.rpc.pdumodel.Circuit.PoleSettings.encode(x0) for x0 in self.poleSettings]
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Circuit_2_0_2.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Circuit.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.Circuit.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.Circuit.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Circuit.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.Circuit.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.pdumodel.Circuit.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.Circuit.SettingsChangedEvent, self).listElements()
            return elements

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Circuit.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Circuit.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Circuit, self).__init__(target, agent)
        self.getConfig = Circuit._getConfig(self)
        self.getSensors = Circuit._getSensors(self)
        self.getPoles = Circuit._getPoles(self)
        self.getSettings = Circuit._getSettings(self)
        self.setSettings = Circuit._setSettings(self)

#
# Section generated by IdlC from "Controller.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.pdumodel


# structure
class CtrlStatistic(Structure):
    idlType = "pdumodel.CtrlStatistic:2.0.0"
    elements = ["mainCSumErrCnt", "subCSumErrCnt", "timeoutCnt", "resetCnt", "emResetCnt"]

    def __init__(self, mainCSumErrCnt=0, subCSumErrCnt=0, timeoutCnt=0, resetCnt=0, emResetCnt=0):
        typecheck.is_int(mainCSumErrCnt, AssertionError)
        typecheck.is_int(subCSumErrCnt, AssertionError)
        typecheck.is_int(timeoutCnt, AssertionError)
        typecheck.is_int(resetCnt, AssertionError)
        typecheck.is_int(emResetCnt, AssertionError)

        self.mainCSumErrCnt = mainCSumErrCnt
        self.subCSumErrCnt = subCSumErrCnt
        self.timeoutCnt = timeoutCnt
        self.resetCnt = resetCnt
        self.emResetCnt = emResetCnt

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            mainCSumErrCnt = json['mainCSumErrCnt'],
            subCSumErrCnt = json['subCSumErrCnt'],
            timeoutCnt = json['timeoutCnt'],
            resetCnt = json['resetCnt'],
            emResetCnt = json['emResetCnt'],
        )
        return obj

    def encode(self):
        json = {}
        json['mainCSumErrCnt'] = self.mainCSumErrCnt
        json['subCSumErrCnt'] = self.subCSumErrCnt
        json['timeoutCnt'] = self.timeoutCnt
        json['resetCnt'] = self.resetCnt
        json['emResetCnt'] = self.emResetCnt
        return json

# interface
class Controller(Interface):
    idlType = "pdumodel.Controller:5.0.0"

    ERR_NOT_SUPPORTED = 1

    # enumeration
    class Status(Enumeration):
        idlType = "pdumodel.Controller_5_0_0.Status:1.0.0"
        values = ["OK", "COMMUNICATION_UNSTABLE", "COMMUNICATION_FAILURE", "UNKNOWN", "INCOMPATIBLE", "FIRMWARE_UPDATE"]

    Status.OK = Status(0)
    Status.COMMUNICATION_UNSTABLE = Status(1)
    Status.COMMUNICATION_FAILURE = Status(2)
    Status.UNKNOWN = Status(3)
    Status.INCOMPATIBLE = Status(4)
    Status.FIRMWARE_UPDATE = Status(5)

    # enumeration
    class Type(Enumeration):
        idlType = "pdumodel.Controller_5_0_0.Type:1.0.0"
        values = ["OUTLET_CTRL", "INLET_CTRL", "METER_CTRL"]

    Type.OUTLET_CTRL = Type(0)
    Type.INLET_CTRL = Type(1)
    Type.METER_CTRL = Type(2)

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.Controller_5_0_0.MetaData:1.0.0"
        elements = ["type", "address", "magic", "versionAvailable", "fwAppVersion", "fwBootVersion", "hwVersion", "serial", "haveResetCnt", "haveEmResetCnt"]

        def __init__(self, type=None, address="", magic=0, versionAvailable=False, fwAppVersion=0, fwBootVersion=0, hwVersion=0, serial="", haveResetCnt=False, haveEmResetCnt=False):
            if type is None:
                type = raritan.rpc.pdumodel.Controller.Type.OUTLET_CTRL
            typecheck.is_enum(type, raritan.rpc.pdumodel.Controller.Type, AssertionError)
            typecheck.is_string(address, AssertionError)
            typecheck.is_int(magic, AssertionError)
            typecheck.is_bool(versionAvailable, AssertionError)
            typecheck.is_int(fwAppVersion, AssertionError)
            typecheck.is_int(fwBootVersion, AssertionError)
            typecheck.is_int(hwVersion, AssertionError)
            typecheck.is_string(serial, AssertionError)
            typecheck.is_bool(haveResetCnt, AssertionError)
            typecheck.is_bool(haveEmResetCnt, AssertionError)

            self.type = type
            self.address = address
            self.magic = magic
            self.versionAvailable = versionAvailable
            self.fwAppVersion = fwAppVersion
            self.fwBootVersion = fwBootVersion
            self.hwVersion = hwVersion
            self.serial = serial
            self.haveResetCnt = haveResetCnt
            self.haveEmResetCnt = haveEmResetCnt

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                type = raritan.rpc.pdumodel.Controller.Type.decode(json['type']),
                address = json['address'],
                magic = json['magic'],
                versionAvailable = json['versionAvailable'],
                fwAppVersion = json['fwAppVersion'],
                fwBootVersion = json['fwBootVersion'],
                hwVersion = json['hwVersion'],
                serial = json['serial'],
                haveResetCnt = json['haveResetCnt'],
                haveEmResetCnt = json['haveEmResetCnt'],
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.pdumodel.Controller.Type.encode(self.type)
            json['address'] = self.address
            json['magic'] = self.magic
            json['versionAvailable'] = self.versionAvailable
            json['fwAppVersion'] = self.fwAppVersion
            json['fwBootVersion'] = self.fwBootVersion
            json['hwVersion'] = self.hwVersion
            json['serial'] = self.serial
            json['haveResetCnt'] = self.haveResetCnt
            json['haveEmResetCnt'] = self.haveEmResetCnt
            return json

    # value object
    class StatusChangedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.Controller_5_0_0.StatusChangedEvent:1.0.0"

        def __init__(self, oldStatus=None, newStatus=None, source=None):
            super(raritan.rpc.pdumodel.Controller.StatusChangedEvent, self).__init__(source)
            if oldStatus is None:
                oldStatus = raritan.rpc.pdumodel.Controller.Status.OK
            if newStatus is None:
                newStatus = raritan.rpc.pdumodel.Controller.Status.OK
            typecheck.is_enum(oldStatus, raritan.rpc.pdumodel.Controller.Status, AssertionError)
            typecheck.is_enum(newStatus, raritan.rpc.pdumodel.Controller.Status, AssertionError)

            self.oldStatus = oldStatus
            self.newStatus = newStatus

        def encode(self):
            json = super(raritan.rpc.pdumodel.Controller.StatusChangedEvent, self).encode()
            json['oldStatus'] = raritan.rpc.pdumodel.Controller.Status.encode(self.oldStatus)
            json['newStatus'] = raritan.rpc.pdumodel.Controller.Status.encode(self.newStatus)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldStatus = raritan.rpc.pdumodel.Controller.Status.decode(json['oldStatus']),
                newStatus = raritan.rpc.pdumodel.Controller.Status.decode(json['newStatus']),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldStatus", "newStatus"]
            elements = elements + super(raritan.rpc.pdumodel.Controller.StatusChangedEvent, self).listElements()
            return elements

    # value object
    class MetaDataChangedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.Controller_5_0_0.MetaDataChangedEvent:1.0.0"

        def __init__(self, oldMetaData=None, newMetaData=None, source=None):
            super(raritan.rpc.pdumodel.Controller.MetaDataChangedEvent, self).__init__(source)
            if oldMetaData is None:
                oldMetaData = raritan.rpc.pdumodel.Controller.MetaData()
            if newMetaData is None:
                newMetaData = raritan.rpc.pdumodel.Controller.MetaData()
            typecheck.is_struct(oldMetaData, raritan.rpc.pdumodel.Controller.MetaData, AssertionError)
            typecheck.is_struct(newMetaData, raritan.rpc.pdumodel.Controller.MetaData, AssertionError)

            self.oldMetaData = oldMetaData
            self.newMetaData = newMetaData

        def encode(self):
            json = super(raritan.rpc.pdumodel.Controller.MetaDataChangedEvent, self).encode()
            json['oldMetaData'] = raritan.rpc.pdumodel.Controller.MetaData.encode(self.oldMetaData)
            json['newMetaData'] = raritan.rpc.pdumodel.Controller.MetaData.encode(self.newMetaData)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldMetaData = raritan.rpc.pdumodel.Controller.MetaData.decode(json['oldMetaData'], agent),
                newMetaData = raritan.rpc.pdumodel.Controller.MetaData.decode(json['newMetaData'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldMetaData", "newMetaData"]
            elements = elements + super(raritan.rpc.pdumodel.Controller.MetaDataChangedEvent, self).listElements()
            return elements

    class _getCommunicationStatus(Interface.Method):
        name = 'getCommunicationStatus'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Controller.Status.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.pdumodel.Controller.Status, DecodeException)
            return _ret_

    class _getStatistics(Interface.Method):
        name = 'getStatistics'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.CtrlStatistic.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.CtrlStatistic, DecodeException)
            return _ret_

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Controller.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Controller.MetaData, DecodeException)
            return _ret_

    class _reset(Interface.Method):
        name = 'reset'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Controller, self).__init__(target, agent)
        self.getCommunicationStatus = Controller._getCommunicationStatus(self)
        self.getStatistics = Controller._getStatistics(self)
        self.getMetaData = Controller._getMetaData(self)
        self.reset = Controller._reset(self)

#
# Section generated by IdlC from "Waveform.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException

# structure
class Waveform(Structure):
    idlType = "pdumodel.Waveform:1.0.0"
    elements = ["voltage", "current", "sampleRate"]

    def __init__(self, voltage=[], current=[], sampleRate=0):
        for x0 in voltage:
            typecheck.is_double(x0, AssertionError)
        for x0 in current:
            typecheck.is_double(x0, AssertionError)
        typecheck.is_int(sampleRate, AssertionError)

        self.voltage = voltage
        self.current = current
        self.sampleRate = sampleRate

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            voltage = [x0 for x0 in json['voltage']],
            current = [x0 for x0 in json['current']],
            sampleRate = json['sampleRate'],
        )
        return obj

    def encode(self):
        json = {}
        json['voltage'] = [x0 for x0 in self.voltage]
        json['current'] = [x0 for x0 in self.current]
        json['sampleRate'] = self.sampleRate
        return json

#
# Section generated by IdlC from "EDevice.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# interface
class EDevice(Interface):
    idlType = "pdumodel.EDevice:1.0.1"

    class _getParents(Interface.Method):
        name = 'getParents'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.EDevice, DecodeException)
            return _ret_

    class _getChildren(Interface.Method):
        name = 'getChildren'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.EDevice, DecodeException)
            return _ret_

    class _getWaveform(Interface.Method):
        name = 'getWaveform'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Waveform.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Waveform, DecodeException)
            return _ret_

    class _getPoleWaveform(Interface.Method):
        name = 'getPoleWaveform'

        @staticmethod
        def encode(line):
            typecheck.is_enum(line, raritan.rpc.pdumodel.PowerLine, AssertionError)
            args = {}
            args['line'] = raritan.rpc.pdumodel.PowerLine.encode(line)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Waveform.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Waveform, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(EDevice, self).__init__(target, agent)
        self.getParents = EDevice._getParents(self)
        self.getChildren = EDevice._getChildren(self)
        self.getWaveform = EDevice._getWaveform(self)
        self.getPoleWaveform = EDevice._getPoleWaveform(self)

#
# Section generated by IdlC from "Nameplate.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# structure
class Rating(Structure):
    idlType = "pdumodel.Rating:2.0.0"
    elements = ["current", "decimalCurrent", "minVoltage", "maxVoltage"]

    def __init__(self, current=0, decimalCurrent=0.0, minVoltage=0, maxVoltage=0):
        typecheck.is_int(current, AssertionError)
        typecheck.is_float(decimalCurrent, AssertionError)
        typecheck.is_int(minVoltage, AssertionError)
        typecheck.is_int(maxVoltage, AssertionError)

        self.current = current
        self.decimalCurrent = decimalCurrent
        self.minVoltage = minVoltage
        self.maxVoltage = maxVoltage

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            current = json['current'],
            decimalCurrent = json['decimalCurrent'],
            minVoltage = json['minVoltage'],
            maxVoltage = json['maxVoltage'],
        )
        return obj

    def encode(self):
        json = {}
        json['current'] = self.current
        json['decimalCurrent'] = self.decimalCurrent
        json['minVoltage'] = self.minVoltage
        json['maxVoltage'] = self.maxVoltage
        return json

# structure
class Nameplate(Structure):
    idlType = "pdumodel.Nameplate:2.0.0"
    elements = ["manufacturer", "brand", "model", "partNumber", "serialNumber", "rating", "imageFileURL"]

    def __init__(self, manufacturer="", brand="", model="", partNumber="", serialNumber="", rating=None, imageFileURL=""):
        if rating is None:
            rating = raritan.rpc.pdumodel.Nameplate.Rating()
        typecheck.is_string(manufacturer, AssertionError)
        typecheck.is_string(brand, AssertionError)
        typecheck.is_string(model, AssertionError)
        typecheck.is_string(partNumber, AssertionError)
        typecheck.is_string(serialNumber, AssertionError)
        typecheck.is_struct(rating, raritan.rpc.pdumodel.Nameplate.Rating, AssertionError)
        typecheck.is_string(imageFileURL, AssertionError)

        self.manufacturer = manufacturer
        self.brand = brand
        self.model = model
        self.partNumber = partNumber
        self.serialNumber = serialNumber
        self.rating = rating
        self.imageFileURL = imageFileURL

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            manufacturer = json['manufacturer'],
            brand = json['brand'],
            model = json['model'],
            partNumber = json['partNumber'],
            serialNumber = json['serialNumber'],
            rating = raritan.rpc.pdumodel.Nameplate.Rating.decode(json['rating'], agent),
            imageFileURL = json['imageFileURL'],
        )
        return obj

    def encode(self):
        json = {}
        json['manufacturer'] = self.manufacturer
        json['brand'] = self.brand
        json['model'] = self.model
        json['partNumber'] = self.partNumber
        json['serialNumber'] = self.serialNumber
        json['rating'] = raritan.rpc.pdumodel.Nameplate.Rating.encode(self.rating)
        json['imageFileURL'] = self.imageFileURL
        return json

    # structure
    class Rating(Structure):
        idlType = "pdumodel.Nameplate_2_0_0.Rating:1.0.0"
        elements = ["voltage", "current", "frequency", "power"]

        def __init__(self, voltage="", current="", frequency="", power=""):
            typecheck.is_string(voltage, AssertionError)
            typecheck.is_string(current, AssertionError)
            typecheck.is_string(frequency, AssertionError)
            typecheck.is_string(power, AssertionError)

            self.voltage = voltage
            self.current = current
            self.frequency = frequency
            self.power = power

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                voltage = json['voltage'],
                current = json['current'],
                frequency = json['frequency'],
                power = json['power'],
            )
            return obj

        def encode(self):
            json = {}
            json['voltage'] = self.voltage
            json['current'] = self.current
            json['frequency'] = self.frequency
            json['power'] = self.power
            return json

#
# Section generated by IdlC from "Inlet.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class Inlet(EDevice):
    idlType = "pdumodel.Inlet:3.0.2"

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.Inlet_3_0_2.MetaData:1.0.0"
        elements = ["label", "plugType", "namePlate", "rating", "hasWaveformSupport", "isDC"]

        def __init__(self, label="", plugType="", namePlate=None, rating=None, hasWaveformSupport=False, isDC=False):
            if namePlate is None:
                namePlate = raritan.rpc.pdumodel.Nameplate()
            if rating is None:
                rating = raritan.rpc.pdumodel.Rating()
            typecheck.is_string(label, AssertionError)
            typecheck.is_string(plugType, AssertionError)
            typecheck.is_struct(namePlate, raritan.rpc.pdumodel.Nameplate, AssertionError)
            typecheck.is_struct(rating, raritan.rpc.pdumodel.Rating, AssertionError)
            typecheck.is_bool(hasWaveformSupport, AssertionError)
            typecheck.is_bool(isDC, AssertionError)

            self.label = label
            self.plugType = plugType
            self.namePlate = namePlate
            self.rating = rating
            self.hasWaveformSupport = hasWaveformSupport
            self.isDC = isDC

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                label = json['label'],
                plugType = json['plugType'],
                namePlate = raritan.rpc.pdumodel.Nameplate.decode(json['namePlate'], agent),
                rating = raritan.rpc.pdumodel.Rating.decode(json['rating'], agent),
                hasWaveformSupport = json['hasWaveformSupport'],
                isDC = json['isDC'],
            )
            return obj

        def encode(self):
            json = {}
            json['label'] = self.label
            json['plugType'] = self.plugType
            json['namePlate'] = raritan.rpc.pdumodel.Nameplate.encode(self.namePlate)
            json['rating'] = raritan.rpc.pdumodel.Rating.encode(self.rating)
            json['hasWaveformSupport'] = self.hasWaveformSupport
            json['isDC'] = self.isDC
            return json

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.Inlet_3_0_2.Sensors:1.0.0"
        elements = ["voltage", "current", "peakCurrent", "residualCurrent", "residualACCurrent", "residualDCCurrent", "activePower", "reactivePower", "apparentPower", "powerFactor", "displacementPowerFactor", "activeEnergy", "apparentEnergy", "unbalancedCurrent", "unbalancedLineLineCurrent", "unbalancedVoltage", "unbalancedLineLineVoltage", "lineFrequency", "phaseAngle", "crestFactor", "voltageThd", "currentThd", "powerQuality", "surgeProtectorStatus", "residualCurrentStatus"]

        def __init__(self, voltage=None, current=None, peakCurrent=None, residualCurrent=None, residualACCurrent=None, residualDCCurrent=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, displacementPowerFactor=None, activeEnergy=None, apparentEnergy=None, unbalancedCurrent=None, unbalancedLineLineCurrent=None, unbalancedVoltage=None, unbalancedLineLineVoltage=None, lineFrequency=None, phaseAngle=None, crestFactor=None, voltageThd=None, currentThd=None, powerQuality=None, surgeProtectorStatus=None, residualCurrentStatus=None):
            typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualACCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualDCCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedLineLineCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedVoltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedLineLineVoltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(lineFrequency, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(voltageThd, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(currentThd, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerQuality, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(surgeProtectorStatus, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(residualCurrentStatus, raritan.rpc.pdumodel.ResidualCurrentStateSensor, AssertionError)

            self.voltage = voltage
            self.current = current
            self.peakCurrent = peakCurrent
            self.residualCurrent = residualCurrent
            self.residualACCurrent = residualACCurrent
            self.residualDCCurrent = residualDCCurrent
            self.activePower = activePower
            self.reactivePower = reactivePower
            self.apparentPower = apparentPower
            self.powerFactor = powerFactor
            self.displacementPowerFactor = displacementPowerFactor
            self.activeEnergy = activeEnergy
            self.apparentEnergy = apparentEnergy
            self.unbalancedCurrent = unbalancedCurrent
            self.unbalancedLineLineCurrent = unbalancedLineLineCurrent
            self.unbalancedVoltage = unbalancedVoltage
            self.unbalancedLineLineVoltage = unbalancedLineLineVoltage
            self.lineFrequency = lineFrequency
            self.phaseAngle = phaseAngle
            self.crestFactor = crestFactor
            self.voltageThd = voltageThd
            self.currentThd = currentThd
            self.powerQuality = powerQuality
            self.surgeProtectorStatus = surgeProtectorStatus
            self.residualCurrentStatus = residualCurrentStatus

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                voltage = Interface.decode(json['voltage'], agent),
                current = Interface.decode(json['current'], agent),
                peakCurrent = Interface.decode(json['peakCurrent'], agent),
                residualCurrent = Interface.decode(json['residualCurrent'], agent),
                residualACCurrent = Interface.decode(json['residualACCurrent'], agent),
                residualDCCurrent = Interface.decode(json['residualDCCurrent'], agent),
                activePower = Interface.decode(json['activePower'], agent),
                reactivePower = Interface.decode(json['reactivePower'], agent),
                apparentPower = Interface.decode(json['apparentPower'], agent),
                powerFactor = Interface.decode(json['powerFactor'], agent),
                displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent),
                activeEnergy = Interface.decode(json['activeEnergy'], agent),
                apparentEnergy = Interface.decode(json['apparentEnergy'], agent),
                unbalancedCurrent = Interface.decode(json['unbalancedCurrent'], agent),
                unbalancedLineLineCurrent = Interface.decode(json['unbalancedLineLineCurrent'], agent),
                unbalancedVoltage = Interface.decode(json['unbalancedVoltage'], agent),
                unbalancedLineLineVoltage = Interface.decode(json['unbalancedLineLineVoltage'], agent),
                lineFrequency = Interface.decode(json['lineFrequency'], agent),
                phaseAngle = Interface.decode(json['phaseAngle'], agent),
                crestFactor = Interface.decode(json['crestFactor'], agent),
                voltageThd = Interface.decode(json['voltageThd'], agent),
                currentThd = Interface.decode(json['currentThd'], agent),
                powerQuality = Interface.decode(json['powerQuality'], agent),
                surgeProtectorStatus = Interface.decode(json['surgeProtectorStatus'], agent),
                residualCurrentStatus = Interface.decode(json['residualCurrentStatus'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['voltage'] = Interface.encode(self.voltage)
            json['current'] = Interface.encode(self.current)
            json['peakCurrent'] = Interface.encode(self.peakCurrent)
            json['residualCurrent'] = Interface.encode(self.residualCurrent)
            json['residualACCurrent'] = Interface.encode(self.residualACCurrent)
            json['residualDCCurrent'] = Interface.encode(self.residualDCCurrent)
            json['activePower'] = Interface.encode(self.activePower)
            json['reactivePower'] = Interface.encode(self.reactivePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['powerFactor'] = Interface.encode(self.powerFactor)
            json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
            json['unbalancedCurrent'] = Interface.encode(self.unbalancedCurrent)
            json['unbalancedLineLineCurrent'] = Interface.encode(self.unbalancedLineLineCurrent)
            json['unbalancedVoltage'] = Interface.encode(self.unbalancedVoltage)
            json['unbalancedLineLineVoltage'] = Interface.encode(self.unbalancedLineLineVoltage)
            json['lineFrequency'] = Interface.encode(self.lineFrequency)
            json['phaseAngle'] = Interface.encode(self.phaseAngle)
            json['crestFactor'] = Interface.encode(self.crestFactor)
            json['voltageThd'] = Interface.encode(self.voltageThd)
            json['currentThd'] = Interface.encode(self.currentThd)
            json['powerQuality'] = Interface.encode(self.powerQuality)
            json['surgeProtectorStatus'] = Interface.encode(self.surgeProtectorStatus)
            json['residualCurrentStatus'] = Interface.encode(self.residualCurrentStatus)
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.Inlet_3_0_2.Settings:1.0.0"
        elements = ["name"]

        def __init__(self, name=""):
            typecheck.is_string(name, AssertionError)

            self.name = name

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Inlet_3_0_2.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Inlet.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.Inlet.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.Inlet.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.Inlet.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.Inlet.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Inlet.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.Inlet.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.Inlet.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.Inlet.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.pdumodel.Inlet.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.Inlet.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class EnableStateChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Inlet_3_0_2.EnableStateChangedEvent:1.0.0"

        def __init__(self, enabled=False, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Inlet.EnableStateChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_bool(enabled, AssertionError)

            self.enabled = enabled

        def encode(self):
            json = super(raritan.rpc.pdumodel.Inlet.EnableStateChangedEvent, self).encode()
            json['enabled'] = self.enabled
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                enabled = json['enabled'],
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["enabled"]
            elements = elements + super(raritan.rpc.pdumodel.Inlet.EnableStateChangedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Inlet.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Inlet.MetaData, DecodeException)
            return _ret_

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Inlet.Sensors.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Inlet.Sensors, DecodeException)
            return _ret_

    class _getPoles(Interface.Method):
        name = 'getPoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.pdumodel.Pole.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Pole, DecodeException)
            return _ret_

    class _getLinePairs(Interface.Method):
        name = 'getLinePairs'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.pdumodel.MeteredLinePair.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.MeteredLinePair, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Inlet.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Inlet.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Inlet.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Inlet.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setEnabled(Interface.Method):
        name = 'setEnabled'

        @staticmethod
        def encode(enabled):
            typecheck.is_bool(enabled, AssertionError)
            args = {}
            args['enabled'] = enabled
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _isEnabled(Interface.Method):
        name = 'isEnabled'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Inlet, self).__init__(target, agent)
        self.getMetaData = Inlet._getMetaData(self)
        self.getSensors = Inlet._getSensors(self)
        self.getPoles = Inlet._getPoles(self)
        self.getLinePairs = Inlet._getLinePairs(self)
        self.getSettings = Inlet._getSettings(self)
        self.setSettings = Inlet._setSettings(self)
        self.setEnabled = Inlet._setEnabled(self)
        self.isEnabled = Inlet._isEnabled(self)

#
# Section generated by IdlC from "Inlets.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# interface
class Inlets(Interface):
    idlType = "pdumodel.Inlets:1.0.0"

    # structure
    class Info(Structure):
        idlType = "pdumodel.Inlets.Info:1.0.0"
        elements = ["numberOfInlets"]

        def __init__(self, numberOfInlets=0):
            typecheck.is_int(numberOfInlets, AssertionError)

            self.numberOfInlets = numberOfInlets

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                numberOfInlets = json['numberOfInlets'],
            )
            return obj

        def encode(self):
            json = {}
            json['numberOfInlets'] = self.numberOfInlets
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Inlets.Info.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Inlets.Info, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Inlets, self).__init__(target, agent)
        self.getInfo = Inlets._getInfo(self)

#
# Section generated by IdlC from "MemoryMapController.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException

# interface
class MemoryMapController(Controller):
    idlType = "pdumodel.MemoryMapController:5.0.0"

    class _readMemory(Interface.Method):
        name = 'readMemory'

        @staticmethod
        def encode(address, size):
            typecheck.is_int(address, AssertionError)
            typecheck.is_int(size, AssertionError)
            args = {}
            args['address'] = address
            args['size'] = size
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            memory = [x0 for x0 in rsp['memory']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in memory:
                typecheck.is_byte(x0, DecodeException)
            return (_ret_, memory)

    class _writeMemory(Interface.Method):
        name = 'writeMemory'

        @staticmethod
        def encode(address, memory):
            typecheck.is_int(address, AssertionError)
            for x0 in memory:
                typecheck.is_byte(x0, AssertionError)
            args = {}
            args['address'] = address
            args['memory'] = [x0 for x0 in memory]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(MemoryMapController, self).__init__(target, agent)
        self.readMemory = MemoryMapController._readMemory(self)
        self.writeMemory = MemoryMapController._writeMemory(self)

#
# Section generated by IdlC from "OverCurrentProtector.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# structure
class CircuitBreakerStatistic(Structure):
    idlType = "pdumodel.CircuitBreakerStatistic:1.0.0"
    elements = ["tripCnt"]

    def __init__(self, tripCnt=0):
        typecheck.is_int(tripCnt, AssertionError)

        self.tripCnt = tripCnt

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            tripCnt = json['tripCnt'],
        )
        return obj

    def encode(self):
        json = {}
        json['tripCnt'] = self.tripCnt
        return json

# interface
class OverCurrentProtector(EDevice):
    idlType = "pdumodel.OverCurrentProtector:4.0.2"

    # enumeration
    class Type(Enumeration):
        idlType = "pdumodel.OverCurrentProtector_4_0_2.Type:1.0.0"
        values = ["BREAKER_1POLE", "BREAKER_2POLE", "BREAKER_3POLE", "FUSE", "FUSE_PAIR", "RCBO_2POLE", "RCBO_3POLE", "RCBO_4POLE"]

    Type.BREAKER_1POLE = Type(0)
    Type.BREAKER_2POLE = Type(1)
    Type.BREAKER_3POLE = Type(2)
    Type.FUSE = Type(3)
    Type.FUSE_PAIR = Type(4)
    Type.RCBO_2POLE = Type(5)
    Type.RCBO_3POLE = Type(6)
    Type.RCBO_4POLE = Type(7)

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.OverCurrentProtector_4_0_2.MetaData:1.0.0"
        elements = ["label", "namePlate", "rating", "type", "maxTripCnt"]

        def __init__(self, label="", namePlate=None, rating=None, type=None, maxTripCnt=0):
            if namePlate is None:
                namePlate = raritan.rpc.pdumodel.Nameplate()
            if rating is None:
                rating = raritan.rpc.pdumodel.Rating()
            if type is None:
                type = raritan.rpc.pdumodel.OverCurrentProtector.Type.BREAKER_1POLE
            typecheck.is_string(label, AssertionError)
            typecheck.is_struct(namePlate, raritan.rpc.pdumodel.Nameplate, AssertionError)
            typecheck.is_struct(rating, raritan.rpc.pdumodel.Rating, AssertionError)
            typecheck.is_enum(type, raritan.rpc.pdumodel.OverCurrentProtector.Type, AssertionError)
            typecheck.is_int(maxTripCnt, AssertionError)

            self.label = label
            self.namePlate = namePlate
            self.rating = rating
            self.type = type
            self.maxTripCnt = maxTripCnt

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                label = json['label'],
                namePlate = raritan.rpc.pdumodel.Nameplate.decode(json['namePlate'], agent),
                rating = raritan.rpc.pdumodel.Rating.decode(json['rating'], agent),
                type = raritan.rpc.pdumodel.OverCurrentProtector.Type.decode(json['type']),
                maxTripCnt = json['maxTripCnt'],
            )
            return obj

        def encode(self):
            json = {}
            json['label'] = self.label
            json['namePlate'] = raritan.rpc.pdumodel.Nameplate.encode(self.namePlate)
            json['rating'] = raritan.rpc.pdumodel.Rating.encode(self.rating)
            json['type'] = raritan.rpc.pdumodel.OverCurrentProtector.Type.encode(self.type)
            json['maxTripCnt'] = self.maxTripCnt
            return json

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.OverCurrentProtector_4_0_2.Sensors:1.0.0"
        elements = ["trip", "voltage", "current", "peakCurrent", "maximumCurrent", "activePower", "reactivePower", "apparentPower", "powerFactor", "displacementPowerFactor", "crestFactor", "activeEnergy", "apparentEnergy", "phaseAngle", "lineFrequency", "residualCurrent", "residualACCurrent", "residualDCCurrent", "residualCurrentStatus"]

        def __init__(self, trip=None, voltage=None, current=None, peakCurrent=None, maximumCurrent=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, displacementPowerFactor=None, crestFactor=None, activeEnergy=None, apparentEnergy=None, phaseAngle=None, lineFrequency=None, residualCurrent=None, residualACCurrent=None, residualDCCurrent=None, residualCurrentStatus=None):
            typecheck.is_interface(trip, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(maximumCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(lineFrequency, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualACCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualDCCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(residualCurrentStatus, raritan.rpc.pdumodel.ResidualCurrentStateSensor, AssertionError)

            self.trip = trip
            self.voltage = voltage
            self.current = current
            self.peakCurrent = peakCurrent
            self.maximumCurrent = maximumCurrent
            self.activePower = activePower
            self.reactivePower = reactivePower
            self.apparentPower = apparentPower
            self.powerFactor = powerFactor
            self.displacementPowerFactor = displacementPowerFactor
            self.crestFactor = crestFactor
            self.activeEnergy = activeEnergy
            self.apparentEnergy = apparentEnergy
            self.phaseAngle = phaseAngle
            self.lineFrequency = lineFrequency
            self.residualCurrent = residualCurrent
            self.residualACCurrent = residualACCurrent
            self.residualDCCurrent = residualDCCurrent
            self.residualCurrentStatus = residualCurrentStatus

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                trip = Interface.decode(json['trip'], agent),
                voltage = Interface.decode(json['voltage'], agent),
                current = Interface.decode(json['current'], agent),
                peakCurrent = Interface.decode(json['peakCurrent'], agent),
                maximumCurrent = Interface.decode(json['maximumCurrent'], agent),
                activePower = Interface.decode(json['activePower'], agent),
                reactivePower = Interface.decode(json['reactivePower'], agent),
                apparentPower = Interface.decode(json['apparentPower'], agent),
                powerFactor = Interface.decode(json['powerFactor'], agent),
                displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent),
                crestFactor = Interface.decode(json['crestFactor'], agent),
                activeEnergy = Interface.decode(json['activeEnergy'], agent),
                apparentEnergy = Interface.decode(json['apparentEnergy'], agent),
                phaseAngle = Interface.decode(json['phaseAngle'], agent),
                lineFrequency = Interface.decode(json['lineFrequency'], agent),
                residualCurrent = Interface.decode(json['residualCurrent'], agent),
                residualACCurrent = Interface.decode(json['residualACCurrent'], agent),
                residualDCCurrent = Interface.decode(json['residualDCCurrent'], agent),
                residualCurrentStatus = Interface.decode(json['residualCurrentStatus'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['trip'] = Interface.encode(self.trip)
            json['voltage'] = Interface.encode(self.voltage)
            json['current'] = Interface.encode(self.current)
            json['peakCurrent'] = Interface.encode(self.peakCurrent)
            json['maximumCurrent'] = Interface.encode(self.maximumCurrent)
            json['activePower'] = Interface.encode(self.activePower)
            json['reactivePower'] = Interface.encode(self.reactivePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['powerFactor'] = Interface.encode(self.powerFactor)
            json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
            json['crestFactor'] = Interface.encode(self.crestFactor)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
            json['phaseAngle'] = Interface.encode(self.phaseAngle)
            json['lineFrequency'] = Interface.encode(self.lineFrequency)
            json['residualCurrent'] = Interface.encode(self.residualCurrent)
            json['residualACCurrent'] = Interface.encode(self.residualACCurrent)
            json['residualDCCurrent'] = Interface.encode(self.residualDCCurrent)
            json['residualCurrentStatus'] = Interface.encode(self.residualCurrentStatus)
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.OverCurrentProtector_4_0_2.Settings:1.0.0"
        elements = ["name"]

        def __init__(self, name=""):
            typecheck.is_string(name, AssertionError)

            self.name = name

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.OverCurrentProtector_4_0_2.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.OverCurrentProtector.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.OverCurrentProtector.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.OverCurrentProtector.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.OverCurrentProtector.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.OverCurrentProtector.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.OverCurrentProtector.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.OverCurrentProtector.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.OverCurrentProtector.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.OverCurrentProtector.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.pdumodel.OverCurrentProtector.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.OverCurrentProtector.SettingsChangedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.OverCurrentProtector.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OverCurrentProtector.MetaData, DecodeException)
            return _ret_

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.OverCurrentProtector.Sensors.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OverCurrentProtector.Sensors, DecodeException)
            return _ret_

    class _getPoles(Interface.Method):
        name = 'getPoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.pdumodel.DoublePole.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.DoublePole, DecodeException)
            return _ret_

    class _getInlet(Interface.Method):
        name = 'getInlet'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.pdumodel.Inlet, DecodeException)
            return _ret_

    class _getOCP(Interface.Method):
        name = 'getOCP'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.pdumodel.OverCurrentProtector, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.OverCurrentProtector.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OverCurrentProtector.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.OverCurrentProtector.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.OverCurrentProtector.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(OverCurrentProtector, self).__init__(target, agent)
        self.getMetaData = OverCurrentProtector._getMetaData(self)
        self.getSensors = OverCurrentProtector._getSensors(self)
        self.getPoles = OverCurrentProtector._getPoles(self)
        self.getInlet = OverCurrentProtector._getInlet(self)
        self.getOCP = OverCurrentProtector._getOCP(self)
        self.getSettings = OverCurrentProtector._getSettings(self)
        self.setSettings = OverCurrentProtector._setSettings(self)

#
# Section generated by IdlC from "Outlet.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# structure
class OutletStatistic(Structure):
    idlType = "pdumodel.OutletStatistic:1.0.0"
    elements = ["relayCycleCnt", "relayFailCnt"]

    def __init__(self, relayCycleCnt=0, relayFailCnt=0):
        typecheck.is_int(relayCycleCnt, AssertionError)
        typecheck.is_int(relayFailCnt, AssertionError)

        self.relayCycleCnt = relayCycleCnt
        self.relayFailCnt = relayFailCnt

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            relayCycleCnt = json['relayCycleCnt'],
            relayFailCnt = json['relayFailCnt'],
        )
        return obj

    def encode(self):
        json = {}
        json['relayCycleCnt'] = self.relayCycleCnt
        json['relayFailCnt'] = self.relayFailCnt
        return json

# interface
class Outlet(EDevice):
    idlType = "pdumodel.Outlet:3.0.2"

    ERR_OUTLET_NOT_SWITCHABLE = 1

    ERR_LOAD_SHEDDING_ACTIVE = 2

    ERR_OUTLET_DISABLED = 3

    ERR_OUTLET_NOT_OFF = 4

    ERR_INVALID_PARAM = 1

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.Outlet_3_0_2.MetaData:1.0.0"
        elements = ["label", "receptacleType", "namePlate", "rating", "isSwitchable", "isLatching", "maxRelayCycleCnt", "hasWaveformSupport"]

        def __init__(self, label="", receptacleType="", namePlate=None, rating=None, isSwitchable=False, isLatching=False, maxRelayCycleCnt=0, hasWaveformSupport=False):
            if namePlate is None:
                namePlate = raritan.rpc.pdumodel.Nameplate()
            if rating is None:
                rating = raritan.rpc.pdumodel.Rating()
            typecheck.is_string(label, AssertionError)
            typecheck.is_string(receptacleType, AssertionError)
            typecheck.is_struct(namePlate, raritan.rpc.pdumodel.Nameplate, AssertionError)
            typecheck.is_struct(rating, raritan.rpc.pdumodel.Rating, AssertionError)
            typecheck.is_bool(isSwitchable, AssertionError)
            typecheck.is_bool(isLatching, AssertionError)
            typecheck.is_int(maxRelayCycleCnt, AssertionError)
            typecheck.is_bool(hasWaveformSupport, AssertionError)

            self.label = label
            self.receptacleType = receptacleType
            self.namePlate = namePlate
            self.rating = rating
            self.isSwitchable = isSwitchable
            self.isLatching = isLatching
            self.maxRelayCycleCnt = maxRelayCycleCnt
            self.hasWaveformSupport = hasWaveformSupport

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                label = json['label'],
                receptacleType = json['receptacleType'],
                namePlate = raritan.rpc.pdumodel.Nameplate.decode(json['namePlate'], agent),
                rating = raritan.rpc.pdumodel.Rating.decode(json['rating'], agent),
                isSwitchable = json['isSwitchable'],
                isLatching = json['isLatching'],
                maxRelayCycleCnt = json['maxRelayCycleCnt'],
                hasWaveformSupport = json['hasWaveformSupport'],
            )
            return obj

        def encode(self):
            json = {}
            json['label'] = self.label
            json['receptacleType'] = self.receptacleType
            json['namePlate'] = raritan.rpc.pdumodel.Nameplate.encode(self.namePlate)
            json['rating'] = raritan.rpc.pdumodel.Rating.encode(self.rating)
            json['isSwitchable'] = self.isSwitchable
            json['isLatching'] = self.isLatching
            json['maxRelayCycleCnt'] = self.maxRelayCycleCnt
            json['hasWaveformSupport'] = self.hasWaveformSupport
            return json

    # enumeration
    class PowerState(Enumeration):
        idlType = "pdumodel.Outlet_3_0_2.PowerState:1.0.0"
        values = ["PS_OFF", "PS_ON"]

    PowerState.PS_OFF = PowerState(0)
    PowerState.PS_ON = PowerState(1)

    # structure
    class LedState(Structure):
        idlType = "pdumodel.Outlet_3_0_2.LedState:1.0.0"
        elements = ["red", "green", "blinking"]

        def __init__(self, red=False, green=False, blinking=False):
            typecheck.is_bool(red, AssertionError)
            typecheck.is_bool(green, AssertionError)
            typecheck.is_bool(blinking, AssertionError)

            self.red = red
            self.green = green
            self.blinking = blinking

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                red = json['red'],
                green = json['green'],
                blinking = json['blinking'],
            )
            return obj

        def encode(self):
            json = {}
            json['red'] = self.red
            json['green'] = self.green
            json['blinking'] = self.blinking
            return json

    # structure
    class State(Structure):
        idlType = "pdumodel.Outlet_3_0_2.State:1.0.0"
        elements = ["available", "powerState", "switchOnInProgress", "cycleInProgress", "isLoadShed", "isSuspended", "hasInrushWaveform", "ledState", "lastPowerStateChange"]

        def __init__(self, available=False, powerState=None, switchOnInProgress=False, cycleInProgress=False, isLoadShed=False, isSuspended=False, hasInrushWaveform=False, ledState=None, lastPowerStateChange=None):
            if powerState is None:
                powerState = raritan.rpc.pdumodel.Outlet.PowerState.PS_OFF
            if ledState is None:
                ledState = raritan.rpc.pdumodel.Outlet.LedState()
            typecheck.is_bool(available, AssertionError)
            typecheck.is_enum(powerState, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            typecheck.is_bool(switchOnInProgress, AssertionError)
            typecheck.is_bool(cycleInProgress, AssertionError)
            typecheck.is_bool(isLoadShed, AssertionError)
            typecheck.is_bool(isSuspended, AssertionError)
            typecheck.is_bool(hasInrushWaveform, AssertionError)
            typecheck.is_struct(ledState, raritan.rpc.pdumodel.Outlet.LedState, AssertionError)
            typecheck.is_time(lastPowerStateChange, AssertionError)

            self.available = available
            self.powerState = powerState
            self.switchOnInProgress = switchOnInProgress
            self.cycleInProgress = cycleInProgress
            self.isLoadShed = isLoadShed
            self.isSuspended = isSuspended
            self.hasInrushWaveform = hasInrushWaveform
            self.ledState = ledState
            self.lastPowerStateChange = lastPowerStateChange

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                available = json['available'],
                powerState = raritan.rpc.pdumodel.Outlet.PowerState.decode(json['powerState']),
                switchOnInProgress = json['switchOnInProgress'],
                cycleInProgress = json['cycleInProgress'],
                isLoadShed = json['isLoadShed'],
                isSuspended = json['isSuspended'],
                hasInrushWaveform = json['hasInrushWaveform'],
                ledState = raritan.rpc.pdumodel.Outlet.LedState.decode(json['ledState'], agent),
                lastPowerStateChange = raritan.rpc.Time.decode(json['lastPowerStateChange']),
            )
            return obj

        def encode(self):
            json = {}
            json['available'] = self.available
            json['powerState'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(self.powerState)
            json['switchOnInProgress'] = self.switchOnInProgress
            json['cycleInProgress'] = self.cycleInProgress
            json['isLoadShed'] = self.isLoadShed
            json['isSuspended'] = self.isSuspended
            json['hasInrushWaveform'] = self.hasInrushWaveform
            json['ledState'] = raritan.rpc.pdumodel.Outlet.LedState.encode(self.ledState)
            json['lastPowerStateChange'] = raritan.rpc.Time.encode(self.lastPowerStateChange)
            return json

    # enumeration
    class StartupState(Enumeration):
        idlType = "pdumodel.Outlet_3_0_2.StartupState:1.0.0"
        values = ["SS_ON", "SS_OFF", "SS_LASTKNOWN", "SS_PDUDEF"]

    StartupState.SS_ON = StartupState(0)
    StartupState.SS_OFF = StartupState(1)
    StartupState.SS_LASTKNOWN = StartupState(2)
    StartupState.SS_PDUDEF = StartupState(3)

    # structure
    class Settings(Structure):
        idlType = "pdumodel.Outlet_3_0_2.Settings:1.0.0"
        elements = ["name", "startupState", "usePduCycleDelay", "cycleDelay", "nonCritical", "sequenceDelay"]

        def __init__(self, name="", startupState=None, usePduCycleDelay=False, cycleDelay=0, nonCritical=False, sequenceDelay=0):
            if startupState is None:
                startupState = raritan.rpc.pdumodel.Outlet.StartupState.SS_ON
            typecheck.is_string(name, AssertionError)
            typecheck.is_enum(startupState, raritan.rpc.pdumodel.Outlet.StartupState, AssertionError)
            typecheck.is_bool(usePduCycleDelay, AssertionError)
            typecheck.is_int(cycleDelay, AssertionError)
            typecheck.is_bool(nonCritical, AssertionError)
            typecheck.is_int(sequenceDelay, AssertionError)

            self.name = name
            self.startupState = startupState
            self.usePduCycleDelay = usePduCycleDelay
            self.cycleDelay = cycleDelay
            self.nonCritical = nonCritical
            self.sequenceDelay = sequenceDelay

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                startupState = raritan.rpc.pdumodel.Outlet.StartupState.decode(json['startupState']),
                usePduCycleDelay = json['usePduCycleDelay'],
                cycleDelay = json['cycleDelay'],
                nonCritical = json['nonCritical'],
                sequenceDelay = json['sequenceDelay'],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['startupState'] = raritan.rpc.pdumodel.Outlet.StartupState.encode(self.startupState)
            json['usePduCycleDelay'] = self.usePduCycleDelay
            json['cycleDelay'] = self.cycleDelay
            json['nonCritical'] = self.nonCritical
            json['sequenceDelay'] = self.sequenceDelay
            return json

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.Outlet_3_0_2.Sensors:1.0.0"
        elements = ["voltage", "current", "peakCurrent", "maximumCurrent", "unbalancedCurrent", "activePower", "reactivePower", "apparentPower", "powerFactor", "displacementPowerFactor", "activeEnergy", "apparentEnergy", "phaseAngle", "lineFrequency", "crestFactor", "voltageThd", "currentThd", "inrushCurrent", "outletState"]

        def __init__(self, voltage=None, current=None, peakCurrent=None, maximumCurrent=None, unbalancedCurrent=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, displacementPowerFactor=None, activeEnergy=None, apparentEnergy=None, phaseAngle=None, lineFrequency=None, crestFactor=None, voltageThd=None, currentThd=None, inrushCurrent=None, outletState=None):
            typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(peakCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(maximumCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(lineFrequency, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(voltageThd, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(currentThd, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(inrushCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(outletState, raritan.rpc.sensors.StateSensor, AssertionError)

            self.voltage = voltage
            self.current = current
            self.peakCurrent = peakCurrent
            self.maximumCurrent = maximumCurrent
            self.unbalancedCurrent = unbalancedCurrent
            self.activePower = activePower
            self.reactivePower = reactivePower
            self.apparentPower = apparentPower
            self.powerFactor = powerFactor
            self.displacementPowerFactor = displacementPowerFactor
            self.activeEnergy = activeEnergy
            self.apparentEnergy = apparentEnergy
            self.phaseAngle = phaseAngle
            self.lineFrequency = lineFrequency
            self.crestFactor = crestFactor
            self.voltageThd = voltageThd
            self.currentThd = currentThd
            self.inrushCurrent = inrushCurrent
            self.outletState = outletState

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                voltage = Interface.decode(json['voltage'], agent),
                current = Interface.decode(json['current'], agent),
                peakCurrent = Interface.decode(json['peakCurrent'], agent),
                maximumCurrent = Interface.decode(json['maximumCurrent'], agent),
                unbalancedCurrent = Interface.decode(json['unbalancedCurrent'], agent),
                activePower = Interface.decode(json['activePower'], agent),
                reactivePower = Interface.decode(json['reactivePower'], agent),
                apparentPower = Interface.decode(json['apparentPower'], agent),
                powerFactor = Interface.decode(json['powerFactor'], agent),
                displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent),
                activeEnergy = Interface.decode(json['activeEnergy'], agent),
                apparentEnergy = Interface.decode(json['apparentEnergy'], agent),
                phaseAngle = Interface.decode(json['phaseAngle'], agent),
                lineFrequency = Interface.decode(json['lineFrequency'], agent),
                crestFactor = Interface.decode(json['crestFactor'], agent),
                voltageThd = Interface.decode(json['voltageThd'], agent),
                currentThd = Interface.decode(json['currentThd'], agent),
                inrushCurrent = Interface.decode(json['inrushCurrent'], agent),
                outletState = Interface.decode(json['outletState'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['voltage'] = Interface.encode(self.voltage)
            json['current'] = Interface.encode(self.current)
            json['peakCurrent'] = Interface.encode(self.peakCurrent)
            json['maximumCurrent'] = Interface.encode(self.maximumCurrent)
            json['unbalancedCurrent'] = Interface.encode(self.unbalancedCurrent)
            json['activePower'] = Interface.encode(self.activePower)
            json['reactivePower'] = Interface.encode(self.reactivePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['powerFactor'] = Interface.encode(self.powerFactor)
            json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
            json['phaseAngle'] = Interface.encode(self.phaseAngle)
            json['lineFrequency'] = Interface.encode(self.lineFrequency)
            json['crestFactor'] = Interface.encode(self.crestFactor)
            json['voltageThd'] = Interface.encode(self.voltageThd)
            json['currentThd'] = Interface.encode(self.currentThd)
            json['inrushCurrent'] = Interface.encode(self.inrushCurrent)
            json['outletState'] = Interface.encode(self.outletState)
            return json

    # value object
    class PowerControlEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Outlet_3_0_2.PowerControlEvent:1.0.0"

        def __init__(self, state=None, cycle=False, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Outlet.PowerControlEvent, self).__init__(actUserName, actIpAddr, source)
            if state is None:
                state = raritan.rpc.pdumodel.Outlet.PowerState.PS_OFF
            typecheck.is_enum(state, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            typecheck.is_bool(cycle, AssertionError)

            self.state = state
            self.cycle = cycle

        def encode(self):
            json = super(raritan.rpc.pdumodel.Outlet.PowerControlEvent, self).encode()
            json['state'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(self.state)
            json['cycle'] = self.cycle
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                state = raritan.rpc.pdumodel.Outlet.PowerState.decode(json['state']),
                cycle = json['cycle'],
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["state", "cycle"]
            elements = elements + super(raritan.rpc.pdumodel.Outlet.PowerControlEvent, self).listElements()
            return elements

    # value object
    class StateChangedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.Outlet_3_0_2.StateChangedEvent:1.0.0"

        def __init__(self, oldState=None, newState=None, source=None):
            super(raritan.rpc.pdumodel.Outlet.StateChangedEvent, self).__init__(source)
            if oldState is None:
                oldState = raritan.rpc.pdumodel.Outlet.State()
            if newState is None:
                newState = raritan.rpc.pdumodel.Outlet.State()
            typecheck.is_struct(oldState, raritan.rpc.pdumodel.Outlet.State, AssertionError)
            typecheck.is_struct(newState, raritan.rpc.pdumodel.Outlet.State, AssertionError)

            self.oldState = oldState
            self.newState = newState

        def encode(self):
            json = super(raritan.rpc.pdumodel.Outlet.StateChangedEvent, self).encode()
            json['oldState'] = raritan.rpc.pdumodel.Outlet.State.encode(self.oldState)
            json['newState'] = raritan.rpc.pdumodel.Outlet.State.encode(self.newState)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldState = raritan.rpc.pdumodel.Outlet.State.decode(json['oldState'], agent),
                newState = raritan.rpc.pdumodel.Outlet.State.decode(json['newState'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldState", "newState"]
            elements = elements + super(raritan.rpc.pdumodel.Outlet.StateChangedEvent, self).listElements()
            return elements

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Outlet_3_0_2.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Outlet.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.Outlet.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.Outlet.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.Outlet.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.Outlet.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Outlet.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.Outlet.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.Outlet.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.Outlet.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.pdumodel.Outlet.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.Outlet.SettingsChangedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Outlet.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Outlet.MetaData, DecodeException)
            return _ret_

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Outlet.Sensors.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Outlet.Sensors, DecodeException)
            return _ret_

    class _getState(Interface.Method):
        name = 'getState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Outlet.State.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Outlet.State, DecodeException)
            return _ret_

    class _setPowerState(Interface.Method):
        name = 'setPowerState'

        @staticmethod
        def encode(pstate):
            typecheck.is_enum(pstate, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            args = {}
            args['pstate'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(pstate)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _cyclePowerState(Interface.Method):
        name = 'cyclePowerState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Outlet.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Outlet.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Outlet.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Outlet.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getIOP(Interface.Method):
        name = 'getIOP'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            i = Interface.decode(rsp['i'], agent)
            o = Interface.decode(rsp['o'], agent)
            p = [raritan.rpc.pdumodel.Pole.decode(x0, agent) for x0 in rsp['p']]
            typecheck.is_interface(i, raritan.rpc.pdumodel.Inlet, DecodeException)
            typecheck.is_interface(o, raritan.rpc.pdumodel.OverCurrentProtector, DecodeException)
            for x0 in p:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Pole, DecodeException)
            return (i, o, p)

    class _getController(Interface.Method):
        name = 'getController'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.pdumodel.Controller, DecodeException)
            return _ret_

    class _getInrushWaveform(Interface.Method):
        name = 'getInrushWaveform'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Waveform.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Waveform, DecodeException)
            return _ret_

    class _unstick(Interface.Method):
        name = 'unstick'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Outlet, self).__init__(target, agent)
        self.getMetaData = Outlet._getMetaData(self)
        self.getSensors = Outlet._getSensors(self)
        self.getState = Outlet._getState(self)
        self.setPowerState = Outlet._setPowerState(self)
        self.cyclePowerState = Outlet._cyclePowerState(self)
        self.getSettings = Outlet._getSettings(self)
        self.setSettings = Outlet._setSettings(self)
        self.getIOP = Outlet._getIOP(self)
        self.getController = Outlet._getController(self)
        self.getInrushWaveform = Outlet._getInrushWaveform(self)
        self.unstick = Outlet._unstick(self)

#
# Section generated by IdlC from "OutletGroup.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class OutletGroup(Interface):
    idlType = "pdumodel.OutletGroup:1.1.8"

    ERR_INVALID_ARGUMENT = 1

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.OutletGroup_1_1_8.Sensors:1.0.0"
        elements = ["activePower", "apparentPower", "activeEnergy", "apparentEnergy"]

        def __init__(self, activePower=None, apparentPower=None, activeEnergy=None, apparentEnergy=None):
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.AccumulatingNumericSensor, AssertionError)
            typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.AccumulatingNumericSensor, AssertionError)

            self.activePower = activePower
            self.apparentPower = apparentPower
            self.activeEnergy = activeEnergy
            self.apparentEnergy = apparentEnergy

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                activePower = Interface.decode(json['activePower'], agent),
                apparentPower = Interface.decode(json['apparentPower'], agent),
                activeEnergy = Interface.decode(json['activeEnergy'], agent),
                apparentEnergy = Interface.decode(json['apparentEnergy'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['activePower'] = Interface.encode(self.activePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.OutletGroup_1_1_8.Settings:1.0.0"
        elements = ["name", "members"]

        def __init__(self, name="", members=[]):
            typecheck.is_string(name, AssertionError)
            for x0 in members:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Outlet, AssertionError)

            self.name = name
            self.members = members

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                members = [Interface.decode(x0, agent) for x0 in json['members']],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['members'] = [Interface.encode(x0) for x0 in self.members]
            return json

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.OutletGroup_1_1_8.MetaData:1.0.0"
        elements = ["groupId", "uniqueId"]

        def __init__(self, groupId=0, uniqueId=0):
            typecheck.is_int(groupId, AssertionError)
            typecheck.is_int(uniqueId, AssertionError)

            self.groupId = groupId
            self.uniqueId = uniqueId

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                groupId = json['groupId'],
                uniqueId = json['uniqueId'],
            )
            return obj

        def encode(self):
            json = {}
            json['groupId'] = self.groupId
            json['uniqueId'] = self.uniqueId
            return json

    # value object
    class SensorsChangedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.OutletGroup_1_1_8.SensorsChangedEvent:1.0.0"

        def __init__(self, oldSensors=None, newSensors=None, source=None):
            super(raritan.rpc.pdumodel.OutletGroup.SensorsChangedEvent, self).__init__(source)
            if oldSensors is None:
                oldSensors = raritan.rpc.pdumodel.OutletGroup.Sensors()
            if newSensors is None:
                newSensors = raritan.rpc.pdumodel.OutletGroup.Sensors()
            typecheck.is_struct(oldSensors, raritan.rpc.pdumodel.OutletGroup.Sensors, AssertionError)
            typecheck.is_struct(newSensors, raritan.rpc.pdumodel.OutletGroup.Sensors, AssertionError)

            self.oldSensors = oldSensors
            self.newSensors = newSensors

        def encode(self):
            json = super(raritan.rpc.pdumodel.OutletGroup.SensorsChangedEvent, self).encode()
            json['oldSensors'] = raritan.rpc.pdumodel.OutletGroup.Sensors.encode(self.oldSensors)
            json['newSensors'] = raritan.rpc.pdumodel.OutletGroup.Sensors.encode(self.newSensors)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSensors = raritan.rpc.pdumodel.OutletGroup.Sensors.decode(json['oldSensors'], agent),
                newSensors = raritan.rpc.pdumodel.OutletGroup.Sensors.decode(json['newSensors'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSensors", "newSensors"]
            elements = elements + super(raritan.rpc.pdumodel.OutletGroup.SensorsChangedEvent, self).listElements()
            return elements

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.OutletGroup_1_1_8.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.OutletGroup.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.OutletGroup.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.OutletGroup.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.OutletGroup.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.OutletGroup.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.OutletGroup.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.OutletGroup.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.OutletGroup.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.OutletGroup.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.pdumodel.OutletGroup.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.OutletGroup.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class PowerControlEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.OutletGroup_1_1_8.PowerControlEvent:1.0.0"

        def __init__(self, state=None, cycle=False, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.OutletGroup.PowerControlEvent, self).__init__(actUserName, actIpAddr, source)
            if state is None:
                state = raritan.rpc.pdumodel.Outlet.PowerState.PS_OFF
            typecheck.is_enum(state, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            typecheck.is_bool(cycle, AssertionError)

            self.state = state
            self.cycle = cycle

        def encode(self):
            json = super(raritan.rpc.pdumodel.OutletGroup.PowerControlEvent, self).encode()
            json['state'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(self.state)
            json['cycle'] = self.cycle
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                state = raritan.rpc.pdumodel.Outlet.PowerState.decode(json['state']),
                cycle = json['cycle'],
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["state", "cycle"]
            elements = elements + super(raritan.rpc.pdumodel.OutletGroup.PowerControlEvent, self).listElements()
            return elements

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.OutletGroup.Sensors.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OutletGroup.Sensors, DecodeException)
            return _ret_

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.OutletGroup.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OutletGroup.MetaData, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.OutletGroup.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OutletGroup.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.OutletGroup.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.OutletGroup.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setAllOutletPowerStates(Interface.Method):
        name = 'setAllOutletPowerStates'

        @staticmethod
        def encode(pstate):
            typecheck.is_enum(pstate, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            args = {}
            args['pstate'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(pstate)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _cycleAllOutletPowerStates(Interface.Method):
        name = 'cycleAllOutletPowerStates'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(OutletGroup, self).__init__(target, agent)
        self.getSensors = OutletGroup._getSensors(self)
        self.getMetaData = OutletGroup._getMetaData(self)
        self.getSettings = OutletGroup._getSettings(self)
        self.setSettings = OutletGroup._setSettings(self)
        self.setAllOutletPowerStates = OutletGroup._setAllOutletPowerStates(self)
        self.cycleAllOutletPowerStates = OutletGroup._cycleAllOutletPowerStates(self)

#
# Section generated by IdlC from "OutletGroupManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel


# interface
class OutletGroupManager(Interface):
    idlType = "pdumodel.OutletGroupManager:1.1.8"

    ERR_INVALID_ARGUMENT = 1

    ERR_NO_SUCH_ID = 2

    ERR_MAX_GROUP_COUNT_REACHED = 3

    # value object
    class GroupCreatedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.OutletGroupManager_1_1_8.GroupCreatedEvent:1.0.0"

        def __init__(self, id=0, uniqueId=0, group=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.OutletGroupManager.GroupCreatedEvent, self).__init__(actUserName, actIpAddr, source)
            if settings is None:
                settings = raritan.rpc.pdumodel.OutletGroup.Settings()
            typecheck.is_int(id, AssertionError)
            typecheck.is_int(uniqueId, AssertionError)
            typecheck.is_interface(group, raritan.rpc.pdumodel.OutletGroup, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.OutletGroup.Settings, AssertionError)

            self.id = id
            self.uniqueId = uniqueId
            self.group = group
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.OutletGroupManager.GroupCreatedEvent, self).encode()
            json['id'] = self.id
            json['uniqueId'] = self.uniqueId
            json['group'] = Interface.encode(self.group)
            json['settings'] = raritan.rpc.pdumodel.OutletGroup.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                id = json['id'],
                uniqueId = json['uniqueId'],
                group = Interface.decode(json['group'], agent),
                settings = raritan.rpc.pdumodel.OutletGroup.Settings.decode(json['settings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["id", "uniqueId", "group", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.OutletGroupManager.GroupCreatedEvent, self).listElements()
            return elements

    # value object
    class GroupDeletedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.OutletGroupManager_1_1_8.GroupDeletedEvent:1.0.0"

        def __init__(self, id=0, uniqueId=0, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.OutletGroupManager.GroupDeletedEvent, self).__init__(actUserName, actIpAddr, source)
            if settings is None:
                settings = raritan.rpc.pdumodel.OutletGroup.Settings()
            typecheck.is_int(id, AssertionError)
            typecheck.is_int(uniqueId, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.OutletGroup.Settings, AssertionError)

            self.id = id
            self.uniqueId = uniqueId
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.OutletGroupManager.GroupDeletedEvent, self).encode()
            json['id'] = self.id
            json['uniqueId'] = self.uniqueId
            json['settings'] = raritan.rpc.pdumodel.OutletGroup.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                id = json['id'],
                uniqueId = json['uniqueId'],
                settings = raritan.rpc.pdumodel.OutletGroup.Settings.decode(json['settings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["id", "uniqueId", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.OutletGroupManager.GroupDeletedEvent, self).listElements()
            return elements

    class _createGroup(Interface.Method):
        name = 'createGroup'

        @staticmethod
        def encode(name, members):
            typecheck.is_string(name, AssertionError)
            for x0 in members:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Outlet, AssertionError)
            args = {}
            args['name'] = name
            args['members'] = [Interface.encode(x0) for x0 in members]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            group = Interface.decode(rsp['group'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_interface(group, raritan.rpc.pdumodel.OutletGroup, DecodeException)
            return (_ret_, group)

    class _getAllGroups(Interface.Method):
        name = 'getAllGroups'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = dict([(
                elem['key'],
                Interface.decode(elem['value'], agent))
                for elem in rsp['_ret_']])
            return _ret_

    class _getGroup(Interface.Method):
        name = 'getGroup'

        @staticmethod
        def encode(id):
            typecheck.is_int(id, AssertionError)
            args = {}
            args['id'] = id
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            group = Interface.decode(rsp['group'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_interface(group, raritan.rpc.pdumodel.OutletGroup, DecodeException)
            return (_ret_, group)

    class _deleteGroup(Interface.Method):
        name = 'deleteGroup'

        @staticmethod
        def encode(id):
            typecheck.is_int(id, AssertionError)
            args = {}
            args['id'] = id
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(OutletGroupManager, self).__init__(target, agent)
        self.createGroup = OutletGroupManager._createGroup(self)
        self.getAllGroups = OutletGroupManager._getAllGroups(self)
        self.getGroup = OutletGroupManager._getGroup(self)
        self.deleteGroup = OutletGroupManager._deleteGroup(self)

#
# Section generated by IdlC from "Outlets.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# interface
class Outlets(Interface):
    idlType = "pdumodel.Outlets:1.0.0"

    # structure
    class Info(Structure):
        idlType = "pdumodel.Outlets.Info:1.0.0"
        elements = ["numberOfOutlets"]

        def __init__(self, numberOfOutlets=0):
            typecheck.is_int(numberOfOutlets, AssertionError)

            self.numberOfOutlets = numberOfOutlets

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                numberOfOutlets = json['numberOfOutlets'],
            )
            return obj

        def encode(self):
            json = {}
            json['numberOfOutlets'] = self.numberOfOutlets
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Outlets.Info.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Outlets.Info, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Outlets, self).__init__(target, agent)
        self.getInfo = Outlets._getInfo(self)

#
# Section generated by IdlC from "OverCurrentProtectorTripSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class OverCurrentProtectorTripSensor(raritan.rpc.sensors.StateSensor):
    idlType = "pdumodel.OverCurrentProtectorTripSensor:1.1.12"

    # structure
    class TripEventInformation(Structure):
        idlType = "pdumodel.OverCurrentProtectorTripSensor_1_1_12.TripEventInformation:1.0.0"
        elements = ["cause", "timestamp", "current"]

        def __init__(self, cause=None, timestamp=None, current=0.0):
            typecheck.is_interface(cause, raritan.rpc.pdumodel.Outlet, AssertionError)
            typecheck.is_time(timestamp, AssertionError)
            typecheck.is_double(current, AssertionError)

            self.cause = cause
            self.timestamp = timestamp
            self.current = current

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                cause = Interface.decode(json['cause'], agent),
                timestamp = raritan.rpc.Time.decode(json['timestamp']),
                current = json['current'],
            )
            return obj

        def encode(self):
            json = {}
            json['cause'] = Interface.encode(self.cause)
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['current'] = self.current
            return json

    # value object
    class TripStateChangedEvent(raritan.rpc.sensors.StateSensor.StateChangedEvent):
        idlType = "pdumodel.OverCurrentProtectorTripSensor_1_1_12.TripStateChangedEvent:1.0.0"

        def __init__(self, tripCause=None, tripInformation=None, oldState=None, newState=None, source=None):
            super(raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripStateChangedEvent, self).__init__(oldState, newState, source)
            if tripInformation is None:
                tripInformation = raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation()
            typecheck.is_interface(tripCause, raritan.rpc.pdumodel.Outlet, AssertionError)
            typecheck.is_struct(tripInformation, raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation, AssertionError)

            self.tripCause = tripCause
            self.tripInformation = tripInformation

        def encode(self):
            json = super(raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripStateChangedEvent, self).encode()
            json['tripCause'] = Interface.encode(self.tripCause)
            json['tripInformation'] = raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation.encode(self.tripInformation)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                tripCause = Interface.decode(json['tripCause'], agent),
                tripInformation = raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation.decode(json['tripInformation'], agent),
                # for sensors.StateSensor_4_0_6.StateChangedEvent
                oldState = raritan.rpc.sensors.StateSensor.State.decode(json['oldState'], agent),
                newState = raritan.rpc.sensors.StateSensor.State.decode(json['newState'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["tripCause", "tripInformation"]
            elements = elements + super(raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripStateChangedEvent, self).listElements()
            return elements

    class _getTripCause(Interface.Method):
        name = 'getTripCause'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.pdumodel.Outlet, DecodeException)
            return _ret_

    class _getTripEventInformation(Interface.Method):
        name = 'getTripEventInformation'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OverCurrentProtectorTripSensor.TripEventInformation, DecodeException)
            return _ret_

    class _getTripWaveform(Interface.Method):
        name = 'getTripWaveform'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Waveform.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Waveform, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(OverCurrentProtectorTripSensor, self).__init__(target, agent)
        self.getTripCause = OverCurrentProtectorTripSensor._getTripCause(self)
        self.getTripEventInformation = OverCurrentProtectorTripSensor._getTripEventInformation(self)
        self.getTripWaveform = OverCurrentProtectorTripSensor._getTripWaveform(self)

#
# Section generated by IdlC from "OverCurrentProtectors.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.pdumodel


# interface
class OverCurrentProtectors(Interface):
    idlType = "pdumodel.OverCurrentProtectors:1.0.0"

    # structure
    class Info(Structure):
        idlType = "pdumodel.OverCurrentProtectors.Info:1.0.0"
        elements = ["numberOfOCPs"]

        def __init__(self, numberOfOCPs=0):
            typecheck.is_int(numberOfOCPs, AssertionError)

            self.numberOfOCPs = numberOfOCPs

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                numberOfOCPs = json['numberOfOCPs'],
            )
            return obj

        def encode(self):
            json = {}
            json['numberOfOCPs'] = self.numberOfOCPs
            return json

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.OverCurrentProtectors.Info.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.OverCurrentProtectors.Info, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(OverCurrentProtectors, self).__init__(target, agent)
        self.getInfo = OverCurrentProtectors._getInfo(self)

#
# Section generated by IdlC from "PowerMeter.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class PowerMeter(Interface):
    idlType = "pdumodel.PowerMeter:2.0.2"

    ERR_INVALID_PARAM = 1

    ERR_MODBUS_UNIT_IN_USE = 2

    # enumeration
    class Type(Enumeration):
        idlType = "pdumodel.PowerMeter_2_0_2.Type:1.0.0"
        values = ["ONE_PHASE", "SPLIT_PHASE", "THREE_PHASE"]

    Type.ONE_PHASE = Type(0)
    Type.SPLIT_PHASE = Type(1)
    Type.THREE_PHASE = Type(2)

    # structure
    class Config(Structure):
        idlType = "pdumodel.PowerMeter_2_0_2.Config:1.0.0"
        elements = ["powerMeterId", "type"]

        def __init__(self, powerMeterId=0, type=None):
            if type is None:
                type = raritan.rpc.pdumodel.PowerMeter.Type.ONE_PHASE
            typecheck.is_int(powerMeterId, AssertionError)
            typecheck.is_enum(type, raritan.rpc.pdumodel.PowerMeter.Type, AssertionError)

            self.powerMeterId = powerMeterId
            self.type = type

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                powerMeterId = json['powerMeterId'],
                type = raritan.rpc.pdumodel.PowerMeter.Type.decode(json['type']),
            )
            return obj

        def encode(self):
            json = {}
            json['powerMeterId'] = self.powerMeterId
            json['type'] = raritan.rpc.pdumodel.PowerMeter.Type.encode(self.type)
            return json

    class _getConfig(Interface.Method):
        name = 'getConfig'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.PowerMeter.Config.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.PowerMeter.Config, DecodeException)
            return _ret_

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.PowerMeter_2_0_2.Sensors:1.0.0"
        elements = ["voltage", "lineFrequency", "current", "activePower", "reactivePower", "apparentPower", "powerFactor", "phaseAngle", "displacementPowerFactor", "activeEnergy", "unbalancedCurrent", "crestFactor", "activePowerDemand", "powerQuality"]

        def __init__(self, voltage=None, lineFrequency=None, current=None, activePower=None, reactivePower=None, apparentPower=None, powerFactor=None, phaseAngle=None, displacementPowerFactor=None, activeEnergy=None, unbalancedCurrent=None, crestFactor=None, activePowerDemand=None, powerQuality=None):
            typecheck.is_interface(voltage, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(lineFrequency, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(current, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(reactivePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(phaseAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(displacementPowerFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(unbalancedCurrent, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(crestFactor, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activePowerDemand, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(powerQuality, raritan.rpc.sensors.StateSensor, AssertionError)

            self.voltage = voltage
            self.lineFrequency = lineFrequency
            self.current = current
            self.activePower = activePower
            self.reactivePower = reactivePower
            self.apparentPower = apparentPower
            self.powerFactor = powerFactor
            self.phaseAngle = phaseAngle
            self.displacementPowerFactor = displacementPowerFactor
            self.activeEnergy = activeEnergy
            self.unbalancedCurrent = unbalancedCurrent
            self.crestFactor = crestFactor
            self.activePowerDemand = activePowerDemand
            self.powerQuality = powerQuality

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                voltage = Interface.decode(json['voltage'], agent),
                lineFrequency = Interface.decode(json['lineFrequency'], agent),
                current = Interface.decode(json['current'], agent),
                activePower = Interface.decode(json['activePower'], agent),
                reactivePower = Interface.decode(json['reactivePower'], agent),
                apparentPower = Interface.decode(json['apparentPower'], agent),
                powerFactor = Interface.decode(json['powerFactor'], agent),
                phaseAngle = Interface.decode(json['phaseAngle'], agent),
                displacementPowerFactor = Interface.decode(json['displacementPowerFactor'], agent),
                activeEnergy = Interface.decode(json['activeEnergy'], agent),
                unbalancedCurrent = Interface.decode(json['unbalancedCurrent'], agent),
                crestFactor = Interface.decode(json['crestFactor'], agent),
                activePowerDemand = Interface.decode(json['activePowerDemand'], agent),
                powerQuality = Interface.decode(json['powerQuality'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['voltage'] = Interface.encode(self.voltage)
            json['lineFrequency'] = Interface.encode(self.lineFrequency)
            json['current'] = Interface.encode(self.current)
            json['activePower'] = Interface.encode(self.activePower)
            json['reactivePower'] = Interface.encode(self.reactivePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['powerFactor'] = Interface.encode(self.powerFactor)
            json['phaseAngle'] = Interface.encode(self.phaseAngle)
            json['displacementPowerFactor'] = Interface.encode(self.displacementPowerFactor)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['unbalancedCurrent'] = Interface.encode(self.unbalancedCurrent)
            json['crestFactor'] = Interface.encode(self.crestFactor)
            json['activePowerDemand'] = Interface.encode(self.activePowerDemand)
            json['powerQuality'] = Interface.encode(self.powerQuality)
            return json

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.PowerMeter.Sensors.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.PowerMeter.Sensors, DecodeException)
            return _ret_

    class _getPoles(Interface.Method):
        name = 'getPoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.pdumodel.Pole.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.Pole, DecodeException)
            return _ret_

    class _getControllers(Interface.Method):
        name = 'getControllers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Controller, DecodeException)
            return _ret_

    # structure
    class Settings(Structure):
        idlType = "pdumodel.PowerMeter_2_0_2.Settings:1.0.0"
        elements = ["name", "currentRating", "phaseCtRating", "neutralCtRating", "earthCtRating", "modbusUnitAddress"]

        def __init__(self, name="", currentRating=0, phaseCtRating=0, neutralCtRating=0, earthCtRating=0, modbusUnitAddress=0):
            typecheck.is_string(name, AssertionError)
            typecheck.is_int(currentRating, AssertionError)
            typecheck.is_int(phaseCtRating, AssertionError)
            typecheck.is_int(neutralCtRating, AssertionError)
            typecheck.is_int(earthCtRating, AssertionError)
            typecheck.is_int(modbusUnitAddress, AssertionError)

            self.name = name
            self.currentRating = currentRating
            self.phaseCtRating = phaseCtRating
            self.neutralCtRating = neutralCtRating
            self.earthCtRating = earthCtRating
            self.modbusUnitAddress = modbusUnitAddress

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                currentRating = json['currentRating'],
                phaseCtRating = json['phaseCtRating'],
                neutralCtRating = json['neutralCtRating'],
                earthCtRating = json['earthCtRating'],
                modbusUnitAddress = json['modbusUnitAddress'],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['currentRating'] = self.currentRating
            json['phaseCtRating'] = self.phaseCtRating
            json['neutralCtRating'] = self.neutralCtRating
            json['earthCtRating'] = self.earthCtRating
            json['modbusUnitAddress'] = self.modbusUnitAddress
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.PowerMeter_2_0_2.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeter.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.PowerMeter.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.PowerMeter.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeter.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeter.SettingsChangedEvent, self).listElements()
            return elements

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.PowerMeter.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.PowerMeter.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    # structure
    class EnergyPulseSettings(Structure):
        idlType = "pdumodel.PowerMeter_2_0_2.EnergyPulseSettings:1.0.0"
        elements = ["pulseEnabled", "poles", "pulsesPerKWh"]

        def __init__(self, pulseEnabled=False, poles=[], pulsesPerKWh=0):
            typecheck.is_bool(pulseEnabled, AssertionError)
            for x0 in poles:
                typecheck.is_int(x0, AssertionError)
            typecheck.is_int(pulsesPerKWh, AssertionError)

            self.pulseEnabled = pulseEnabled
            self.poles = poles
            self.pulsesPerKWh = pulsesPerKWh

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                pulseEnabled = json['pulseEnabled'],
                poles = [x0 for x0 in json['poles']],
                pulsesPerKWh = json['pulsesPerKWh'],
            )
            return obj

        def encode(self):
            json = {}
            json['pulseEnabled'] = self.pulseEnabled
            json['poles'] = [x0 for x0 in self.poles]
            json['pulsesPerKWh'] = self.pulsesPerKWh
            return json

    # value object
    class EnergyPulseSettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.PowerMeter_2_0_2.EnergyPulseSettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettingsChangedEvent, self).listElements()
            return elements

    class _getEnergyPulseSettings(Interface.Method):
        name = 'getEnergyPulseSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings, DecodeException)
            return _ret_

    class _setEnergyPulseSettings(Interface.Method):
        name = 'setEnergyPulseSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.PowerMeter.EnergyPulseSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(PowerMeter, self).__init__(target, agent)
        self.getConfig = PowerMeter._getConfig(self)
        self.getSensors = PowerMeter._getSensors(self)
        self.getPoles = PowerMeter._getPoles(self)
        self.getControllers = PowerMeter._getControllers(self)
        self.getSettings = PowerMeter._getSettings(self)
        self.setSettings = PowerMeter._setSettings(self)
        self.getEnergyPulseSettings = PowerMeter._getEnergyPulseSettings(self)
        self.setEnergyPulseSettings = PowerMeter._setEnergyPulseSettings(self)

#
# Section generated by IdlC from "Panel.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel


# interface
class Panel(PowerMeter):
    idlType = "pdumodel.Panel:2.0.2"

    # enumeration
    class LabelingScheme(Enumeration):
        idlType = "pdumodel.Panel_2_0_2.LabelingScheme:1.0.0"
        values = ["SEQUENTIAL", "ODD_EVEN"]

    LabelingScheme.SEQUENTIAL = LabelingScheme(0)
    LabelingScheme.ODD_EVEN = LabelingScheme(1)

    # structure
    class PanelSettings(Structure):
        idlType = "pdumodel.Panel_2_0_2.PanelSettings:1.0.0"
        elements = ["meterCount", "panelSize", "columns", "labelingScheme"]

        def __init__(self, meterCount=0, panelSize=0, columns=0, labelingScheme=None):
            if labelingScheme is None:
                labelingScheme = raritan.rpc.pdumodel.Panel.LabelingScheme.SEQUENTIAL
            typecheck.is_int(meterCount, AssertionError)
            typecheck.is_int(panelSize, AssertionError)
            typecheck.is_int(columns, AssertionError)
            typecheck.is_enum(labelingScheme, raritan.rpc.pdumodel.Panel.LabelingScheme, AssertionError)

            self.meterCount = meterCount
            self.panelSize = panelSize
            self.columns = columns
            self.labelingScheme = labelingScheme

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                meterCount = json['meterCount'],
                panelSize = json['panelSize'],
                columns = json['columns'],
                labelingScheme = raritan.rpc.pdumodel.Panel.LabelingScheme.decode(json['labelingScheme']),
            )
            return obj

        def encode(self):
            json = {}
            json['meterCount'] = self.meterCount
            json['panelSize'] = self.panelSize
            json['columns'] = self.columns
            json['labelingScheme'] = raritan.rpc.pdumodel.Panel.LabelingScheme.encode(self.labelingScheme)
            return json

    # value object
    class PanelSettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Panel_2_0_2.PanelSettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Panel.PanelSettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.Panel.PanelSettings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.Panel.PanelSettings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Panel.PanelSettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.Panel.PanelSettings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.pdumodel.Panel.PanelSettings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.Panel.PanelSettingsChangedEvent, self).listElements()
            return elements

    class _getPanelSettings(Interface.Method):
        name = 'getPanelSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Panel.PanelSettings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Panel.PanelSettings, DecodeException)
            return _ret_

    class _setPanelSettings(Interface.Method):
        name = 'setPanelSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getCircuits(Interface.Method):
        name = 'getCircuits'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = dict([(
                elem['key'],
                Interface.decode(elem['value'], agent))
                for elem in rsp['_ret_']])
            return _ret_

    # value object
    class CircuitCreatedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Panel_2_0_2.CircuitCreatedEvent:1.0.0"

        def __init__(self, circuit=None, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Panel.CircuitCreatedEvent, self).__init__(actUserName, actIpAddr, source)
            if config is None:
                config = raritan.rpc.pdumodel.Circuit.Config()
            if settings is None:
                settings = raritan.rpc.pdumodel.Circuit.Settings()
            typecheck.is_interface(circuit, raritan.rpc.pdumodel.Circuit, AssertionError)
            typecheck.is_struct(config, raritan.rpc.pdumodel.Circuit.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)

            self.circuit = circuit
            self.config = config
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Panel.CircuitCreatedEvent, self).encode()
            json['circuit'] = Interface.encode(self.circuit)
            json['config'] = raritan.rpc.pdumodel.Circuit.Config.encode(self.config)
            json['settings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                circuit = Interface.decode(json['circuit'], agent),
                config = raritan.rpc.pdumodel.Circuit.Config.decode(json['config'], agent),
                settings = raritan.rpc.pdumodel.Circuit.Settings.decode(json['settings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["circuit", "config", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.Panel.CircuitCreatedEvent, self).listElements()
            return elements

    # value object
    class CircuitDeletedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Panel_2_0_2.CircuitDeletedEvent:1.0.0"

        def __init__(self, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Panel.CircuitDeletedEvent, self).__init__(actUserName, actIpAddr, source)
            if config is None:
                config = raritan.rpc.pdumodel.Circuit.Config()
            if settings is None:
                settings = raritan.rpc.pdumodel.Circuit.Settings()
            typecheck.is_struct(config, raritan.rpc.pdumodel.Circuit.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)

            self.config = config
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Panel.CircuitDeletedEvent, self).encode()
            json['config'] = raritan.rpc.pdumodel.Circuit.Config.encode(self.config)
            json['settings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                config = raritan.rpc.pdumodel.Circuit.Config.decode(json['config'], agent),
                settings = raritan.rpc.pdumodel.Circuit.Settings.decode(json['settings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["config", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.Panel.CircuitDeletedEvent, self).listElements()
            return elements

    class _createCircuit(Interface.Method):
        name = 'createCircuit'

        @staticmethod
        def encode(config, settings):
            typecheck.is_struct(config, raritan.rpc.pdumodel.Circuit.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Circuit.Settings, AssertionError)
            args = {}
            args['config'] = raritan.rpc.pdumodel.Circuit.Config.encode(config)
            args['settings'] = raritan.rpc.pdumodel.Circuit.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            circuit = Interface.decode(rsp['circuit'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_interface(circuit, raritan.rpc.pdumodel.Circuit, DecodeException)
            return (_ret_, circuit)

    class _deleteCircuit(Interface.Method):
        name = 'deleteCircuit'

        @staticmethod
        def encode(position):
            typecheck.is_int(position, AssertionError)
            args = {}
            args['position'] = position
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Panel, self).__init__(target, agent)
        self.getPanelSettings = Panel._getPanelSettings(self)
        self.setPanelSettings = Panel._setPanelSettings(self)
        self.getCircuits = Panel._getCircuits(self)
        self.createCircuit = Panel._createCircuit(self)
        self.deleteCircuit = Panel._deleteCircuit(self)

#
# Section generated by IdlC from "TransferSwitch.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class TransferSwitch(EDevice):
    idlType = "pdumodel.TransferSwitch:5.0.3"

    ERR_INVALID_PARAM = 1

    ERR_SWITCH_PREVENTED = 2

    ERR_SWITCH_FAILED = 3

    # enumeration
    class Type(Enumeration):
        idlType = "pdumodel.TransferSwitch_5_0_3.Type:1.0.0"
        values = ["STS", "ATS", "HTS"]

    Type.STS = Type(0)
    Type.ATS = Type(1)
    Type.HTS = Type(2)

    # enumeration
    class TransferReason(Enumeration):
        idlType = "pdumodel.TransferSwitch_5_0_3.TransferReason:1.0.0"
        values = ["REASON_UNKNOWN", "REASON_STARTUP", "REASON_MANUAL_TRANSFER", "REASON_AUTO_RETRANSFER", "REASON_POWER_FAILURE", "REASON_POWER_QUALITY", "REASON_OVERLOAD", "REASON_OVERHEAT", "REASON_INTERNAL_FAILURE"]

    TransferReason.REASON_UNKNOWN = TransferReason(0)
    TransferReason.REASON_STARTUP = TransferReason(1)
    TransferReason.REASON_MANUAL_TRANSFER = TransferReason(2)
    TransferReason.REASON_AUTO_RETRANSFER = TransferReason(3)
    TransferReason.REASON_POWER_FAILURE = TransferReason(4)
    TransferReason.REASON_POWER_QUALITY = TransferReason(5)
    TransferReason.REASON_OVERLOAD = TransferReason(6)
    TransferReason.REASON_OVERHEAT = TransferReason(7)
    TransferReason.REASON_INTERNAL_FAILURE = TransferReason(8)

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.TransferSwitch_5_0_3.MetaData:1.0.0"
        elements = ["label", "namePlate", "rating", "type", "sourceCount"]

        def __init__(self, label="", namePlate=None, rating=None, type=None, sourceCount=0):
            if namePlate is None:
                namePlate = raritan.rpc.pdumodel.Nameplate()
            if rating is None:
                rating = raritan.rpc.pdumodel.Rating()
            if type is None:
                type = raritan.rpc.pdumodel.TransferSwitch.Type.STS
            typecheck.is_string(label, AssertionError)
            typecheck.is_struct(namePlate, raritan.rpc.pdumodel.Nameplate, AssertionError)
            typecheck.is_struct(rating, raritan.rpc.pdumodel.Rating, AssertionError)
            typecheck.is_enum(type, raritan.rpc.pdumodel.TransferSwitch.Type, AssertionError)
            typecheck.is_int(sourceCount, AssertionError)

            self.label = label
            self.namePlate = namePlate
            self.rating = rating
            self.type = type
            self.sourceCount = sourceCount

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                label = json['label'],
                namePlate = raritan.rpc.pdumodel.Nameplate.decode(json['namePlate'], agent),
                rating = raritan.rpc.pdumodel.Rating.decode(json['rating'], agent),
                type = raritan.rpc.pdumodel.TransferSwitch.Type.decode(json['type']),
                sourceCount = json['sourceCount'],
            )
            return obj

        def encode(self):
            json = {}
            json['label'] = self.label
            json['namePlate'] = raritan.rpc.pdumodel.Nameplate.encode(self.namePlate)
            json['rating'] = raritan.rpc.pdumodel.Rating.encode(self.rating)
            json['type'] = raritan.rpc.pdumodel.TransferSwitch.Type.encode(self.type)
            json['sourceCount'] = self.sourceCount
            return json

    OPERATIONAL_STATE_OFF = 0

    OPERATIONAL_STATE_NORMAL = 1

    OPERATIONAL_STATE_STANDBY = 2

    OPERATIONAL_STATE_NON_REDUNDANT = 3

    SWITCH_FAULT_I1_SHORT = 1

    SWITCH_FAULT_I1_OPEN = 2

    SWITCH_FAULT_I2_SHORT = 4

    SWITCH_FAULT_I2_OPEN = 8

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.TransferSwitch_5_0_3.Sensors:1.0.0"
        elements = ["selectedSource", "operationalState", "sourceVoltagePhaseSyncAngle", "overloadAlarm", "phaseSyncAlarm", "switchFault", "selectedBypassSource"]

        def __init__(self, selectedSource=None, operationalState=None, sourceVoltagePhaseSyncAngle=None, overloadAlarm=None, phaseSyncAlarm=None, switchFault=None, selectedBypassSource=None):
            typecheck.is_interface(selectedSource, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(operationalState, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(sourceVoltagePhaseSyncAngle, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(overloadAlarm, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(phaseSyncAlarm, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(switchFault, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(selectedBypassSource, raritan.rpc.sensors.StateSensor, AssertionError)

            self.selectedSource = selectedSource
            self.operationalState = operationalState
            self.sourceVoltagePhaseSyncAngle = sourceVoltagePhaseSyncAngle
            self.overloadAlarm = overloadAlarm
            self.phaseSyncAlarm = phaseSyncAlarm
            self.switchFault = switchFault
            self.selectedBypassSource = selectedBypassSource

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                selectedSource = Interface.decode(json['selectedSource'], agent),
                operationalState = Interface.decode(json['operationalState'], agent),
                sourceVoltagePhaseSyncAngle = Interface.decode(json['sourceVoltagePhaseSyncAngle'], agent),
                overloadAlarm = Interface.decode(json['overloadAlarm'], agent),
                phaseSyncAlarm = Interface.decode(json['phaseSyncAlarm'], agent),
                switchFault = Interface.decode(json['switchFault'], agent),
                selectedBypassSource = Interface.decode(json['selectedBypassSource'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['selectedSource'] = Interface.encode(self.selectedSource)
            json['operationalState'] = Interface.encode(self.operationalState)
            json['sourceVoltagePhaseSyncAngle'] = Interface.encode(self.sourceVoltagePhaseSyncAngle)
            json['overloadAlarm'] = Interface.encode(self.overloadAlarm)
            json['phaseSyncAlarm'] = Interface.encode(self.phaseSyncAlarm)
            json['switchFault'] = Interface.encode(self.switchFault)
            json['selectedBypassSource'] = Interface.encode(self.selectedBypassSource)
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.TransferSwitch_5_0_3.Settings:1.0.0"
        elements = ["name", "preferredSource", "autoRetransfer", "noAutoRetransferIfPhaseFault", "autoRetransferWaitTime", "manualTransferEnabled", "phaseSyncSensorEnabled"]

        def __init__(self, name="", preferredSource=0, autoRetransfer=False, noAutoRetransferIfPhaseFault=False, autoRetransferWaitTime=0, manualTransferEnabled=False, phaseSyncSensorEnabled=False):
            typecheck.is_string(name, AssertionError)
            typecheck.is_int(preferredSource, AssertionError)
            typecheck.is_bool(autoRetransfer, AssertionError)
            typecheck.is_bool(noAutoRetransferIfPhaseFault, AssertionError)
            typecheck.is_int(autoRetransferWaitTime, AssertionError)
            typecheck.is_bool(manualTransferEnabled, AssertionError)
            typecheck.is_bool(phaseSyncSensorEnabled, AssertionError)

            self.name = name
            self.preferredSource = preferredSource
            self.autoRetransfer = autoRetransfer
            self.noAutoRetransferIfPhaseFault = noAutoRetransferIfPhaseFault
            self.autoRetransferWaitTime = autoRetransferWaitTime
            self.manualTransferEnabled = manualTransferEnabled
            self.phaseSyncSensorEnabled = phaseSyncSensorEnabled

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                preferredSource = json['preferredSource'],
                autoRetransfer = json['autoRetransfer'],
                noAutoRetransferIfPhaseFault = json['noAutoRetransferIfPhaseFault'],
                autoRetransferWaitTime = json['autoRetransferWaitTime'],
                manualTransferEnabled = json['manualTransferEnabled'],
                phaseSyncSensorEnabled = json['phaseSyncSensorEnabled'],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['preferredSource'] = self.preferredSource
            json['autoRetransfer'] = self.autoRetransfer
            json['noAutoRetransferIfPhaseFault'] = self.noAutoRetransferIfPhaseFault
            json['autoRetransferWaitTime'] = self.autoRetransferWaitTime
            json['manualTransferEnabled'] = self.manualTransferEnabled
            json['phaseSyncSensorEnabled'] = self.phaseSyncSensorEnabled
            return json

    # structure
    class Statistics(Structure):
        idlType = "pdumodel.TransferSwitch_5_0_3.Statistics:1.0.0"
        elements = ["transferCount", "powerFailDetectTime", "relayOpenTime", "totalTransferTime"]

        def __init__(self, transferCount=0, powerFailDetectTime=0, relayOpenTime=0, totalTransferTime=0):
            typecheck.is_int(transferCount, AssertionError)
            typecheck.is_int(powerFailDetectTime, AssertionError)
            typecheck.is_int(relayOpenTime, AssertionError)
            typecheck.is_int(totalTransferTime, AssertionError)

            self.transferCount = transferCount
            self.powerFailDetectTime = powerFailDetectTime
            self.relayOpenTime = relayOpenTime
            self.totalTransferTime = totalTransferTime

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                transferCount = json['transferCount'],
                powerFailDetectTime = json['powerFailDetectTime'],
                relayOpenTime = json['relayOpenTime'],
                totalTransferTime = json['totalTransferTime'],
            )
            return obj

        def encode(self):
            json = {}
            json['transferCount'] = self.transferCount
            json['powerFailDetectTime'] = self.powerFailDetectTime
            json['relayOpenTime'] = self.relayOpenTime
            json['totalTransferTime'] = self.totalTransferTime
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.TransferSwitch_5_0_3.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.TransferSwitch.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.TransferSwitch.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.TransferSwitch.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.TransferSwitch.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.TransferSwitch.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.TransferSwitch.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.TransferSwitch.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.TransferSwitch.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.TransferSwitch.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.pdumodel.TransferSwitch.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.TransferSwitch.SettingsChangedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.TransferSwitch.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.TransferSwitch.MetaData, DecodeException)
            return _ret_

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.TransferSwitch.Sensors.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.TransferSwitch.Sensors, DecodeException)
            return _ret_

    class _getPoles(Interface.Method):
        name = 'getPoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.pdumodel.ThrowPole.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.ThrowPole, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.TransferSwitch.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.TransferSwitch.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.TransferSwitch.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.TransferSwitch.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getStatistics(Interface.Method):
        name = 'getStatistics'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.TransferSwitch.Statistics.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.TransferSwitch.Statistics, DecodeException)
            return _ret_

    class _transferToSource(Interface.Method):
        name = 'transferToSource'

        @staticmethod
        def encode(source, faultOverride):
            typecheck.is_int(source, AssertionError)
            typecheck.is_bool(faultOverride, AssertionError)
            args = {}
            args['source'] = source
            args['faultOverride'] = faultOverride
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getLastTransferReason(Interface.Method):
        name = 'getLastTransferReason'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.TransferSwitch.TransferReason.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.pdumodel.TransferSwitch.TransferReason, DecodeException)
            return _ret_

    class _getLastTransferWaveform(Interface.Method):
        name = 'getLastTransferWaveform'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Waveform.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Waveform, DecodeException)
            return _ret_

    # structure
    class TransferLogEntry(Structure):
        idlType = "pdumodel.TransferSwitch_5_0_3.TransferLogEntry:1.0.0"
        elements = ["timestamp", "oldInlet", "newInlet", "reason", "waveform", "statistics", "switchFault"]

        def __init__(self, timestamp=None, oldInlet=0, newInlet=0, reason=None, waveform=None, statistics=None, switchFault=0):
            if reason is None:
                reason = raritan.rpc.pdumodel.TransferSwitch.TransferReason.REASON_UNKNOWN
            if waveform is None:
                waveform = raritan.rpc.pdumodel.Waveform()
            if statistics is None:
                statistics = raritan.rpc.pdumodel.TransferSwitch.Statistics()
            typecheck.is_time(timestamp, AssertionError)
            typecheck.is_int(oldInlet, AssertionError)
            typecheck.is_int(newInlet, AssertionError)
            typecheck.is_enum(reason, raritan.rpc.pdumodel.TransferSwitch.TransferReason, AssertionError)
            typecheck.is_struct(waveform, raritan.rpc.pdumodel.Waveform, AssertionError)
            typecheck.is_struct(statistics, raritan.rpc.pdumodel.TransferSwitch.Statistics, AssertionError)
            typecheck.is_int(switchFault, AssertionError)

            self.timestamp = timestamp
            self.oldInlet = oldInlet
            self.newInlet = newInlet
            self.reason = reason
            self.waveform = waveform
            self.statistics = statistics
            self.switchFault = switchFault

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                timestamp = raritan.rpc.Time.decode(json['timestamp']),
                oldInlet = json['oldInlet'],
                newInlet = json['newInlet'],
                reason = raritan.rpc.pdumodel.TransferSwitch.TransferReason.decode(json['reason']),
                waveform = raritan.rpc.pdumodel.Waveform.decode(json['waveform'], agent),
                statistics = raritan.rpc.pdumodel.TransferSwitch.Statistics.decode(json['statistics'], agent),
                switchFault = json['switchFault'],
            )
            return obj

        def encode(self):
            json = {}
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['oldInlet'] = self.oldInlet
            json['newInlet'] = self.newInlet
            json['reason'] = raritan.rpc.pdumodel.TransferSwitch.TransferReason.encode(self.reason)
            json['waveform'] = raritan.rpc.pdumodel.Waveform.encode(self.waveform)
            json['statistics'] = raritan.rpc.pdumodel.TransferSwitch.Statistics.encode(self.statistics)
            json['switchFault'] = self.switchFault
            return json

    class _getTransferLog(Interface.Method):
        name = 'getTransferLog'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.pdumodel.TransferSwitch.TransferLogEntry.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.TransferSwitch.TransferLogEntry, DecodeException)
            return _ret_

    class _getParameters(Interface.Method):
        name = 'getParameters'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = dict([(
                elem['key'],
                elem['value'])
                for elem in rsp['_ret_']])
            return _ret_

    class _setParameters(Interface.Method):
        name = 'setParameters'

        @staticmethod
        def encode(parameters):
            args = {}
            args['parameters'] = [dict(
                key = k,
                value = v)
                for k, v in parameters.items()]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(TransferSwitch, self).__init__(target, agent)
        self.getMetaData = TransferSwitch._getMetaData(self)
        self.getSensors = TransferSwitch._getSensors(self)
        self.getPoles = TransferSwitch._getPoles(self)
        self.getSettings = TransferSwitch._getSettings(self)
        self.setSettings = TransferSwitch._setSettings(self)
        self.getStatistics = TransferSwitch._getStatistics(self)
        self.transferToSource = TransferSwitch._transferToSource(self)
        self.getLastTransferReason = TransferSwitch._getLastTransferReason(self)
        self.getLastTransferWaveform = TransferSwitch._getLastTransferWaveform(self)
        self.getTransferLog = TransferSwitch._getTransferLog(self)
        self.getParameters = TransferSwitch._getParameters(self)
        self.setParameters = TransferSwitch._setParameters(self)

#
# Section generated by IdlC from "Pdu.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.hmi

import raritan.rpc.idl

import raritan.rpc.pdumodel

import raritan.rpc.peripheral

import raritan.rpc.portsmodel

import raritan.rpc.sensors


# interface
class Pdu(Interface):
    idlType = "pdumodel.Pdu:6.3.3"

    ERR_INVALID_PARAM = 1

    # enumeration
    class PduOrientation(Enumeration):
        idlType = "pdumodel.Pdu_6_3_3.PduOrientation:1.0.0"
        values = ["PO_NONE", "PO_BOTTOMFEED", "PO_TOPFEED"]

    PduOrientation.PO_NONE = PduOrientation(0)
    PduOrientation.PO_BOTTOMFEED = PduOrientation(1)
    PduOrientation.PO_TOPFEED = PduOrientation(2)

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.Pdu_6_3_3.MetaData:1.0.0"
        elements = ["nameplate", "ctrlBoardSerial", "hwRevision", "fwRevision", "macAddress", "hasSwitchableOutlets", "hasMeteredOutlets", "hasLatchingOutletRelays", "isInlineMeter", "isEnergyPulseSupported", "hasDCInlets", "pduOrientation"]

        def __init__(self, nameplate=None, ctrlBoardSerial="", hwRevision="", fwRevision="", macAddress="", hasSwitchableOutlets=False, hasMeteredOutlets=False, hasLatchingOutletRelays=False, isInlineMeter=False, isEnergyPulseSupported=False, hasDCInlets=False, pduOrientation=None):
            if nameplate is None:
                nameplate = raritan.rpc.pdumodel.Nameplate()
            if pduOrientation is None:
                pduOrientation = raritan.rpc.pdumodel.Pdu.PduOrientation.PO_NONE
            typecheck.is_struct(nameplate, raritan.rpc.pdumodel.Nameplate, AssertionError)
            typecheck.is_string(ctrlBoardSerial, AssertionError)
            typecheck.is_string(hwRevision, AssertionError)
            typecheck.is_string(fwRevision, AssertionError)
            typecheck.is_string(macAddress, AssertionError)
            typecheck.is_bool(hasSwitchableOutlets, AssertionError)
            typecheck.is_bool(hasMeteredOutlets, AssertionError)
            typecheck.is_bool(hasLatchingOutletRelays, AssertionError)
            typecheck.is_bool(isInlineMeter, AssertionError)
            typecheck.is_bool(isEnergyPulseSupported, AssertionError)
            typecheck.is_bool(hasDCInlets, AssertionError)
            typecheck.is_enum(pduOrientation, raritan.rpc.pdumodel.Pdu.PduOrientation, AssertionError)

            self.nameplate = nameplate
            self.ctrlBoardSerial = ctrlBoardSerial
            self.hwRevision = hwRevision
            self.fwRevision = fwRevision
            self.macAddress = macAddress
            self.hasSwitchableOutlets = hasSwitchableOutlets
            self.hasMeteredOutlets = hasMeteredOutlets
            self.hasLatchingOutletRelays = hasLatchingOutletRelays
            self.isInlineMeter = isInlineMeter
            self.isEnergyPulseSupported = isEnergyPulseSupported
            self.hasDCInlets = hasDCInlets
            self.pduOrientation = pduOrientation

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                nameplate = raritan.rpc.pdumodel.Nameplate.decode(json['nameplate'], agent),
                ctrlBoardSerial = json['ctrlBoardSerial'],
                hwRevision = json['hwRevision'],
                fwRevision = json['fwRevision'],
                macAddress = json['macAddress'],
                hasSwitchableOutlets = json['hasSwitchableOutlets'],
                hasMeteredOutlets = json['hasMeteredOutlets'],
                hasLatchingOutletRelays = json['hasLatchingOutletRelays'],
                isInlineMeter = json['isInlineMeter'],
                isEnergyPulseSupported = json['isEnergyPulseSupported'],
                hasDCInlets = json['hasDCInlets'],
                pduOrientation = raritan.rpc.pdumodel.Pdu.PduOrientation.decode(json['pduOrientation']),
            )
            return obj

        def encode(self):
            json = {}
            json['nameplate'] = raritan.rpc.pdumodel.Nameplate.encode(self.nameplate)
            json['ctrlBoardSerial'] = self.ctrlBoardSerial
            json['hwRevision'] = self.hwRevision
            json['fwRevision'] = self.fwRevision
            json['macAddress'] = self.macAddress
            json['hasSwitchableOutlets'] = self.hasSwitchableOutlets
            json['hasMeteredOutlets'] = self.hasMeteredOutlets
            json['hasLatchingOutletRelays'] = self.hasLatchingOutletRelays
            json['isInlineMeter'] = self.isInlineMeter
            json['isEnergyPulseSupported'] = self.isEnergyPulseSupported
            json['hasDCInlets'] = self.hasDCInlets
            json['pduOrientation'] = raritan.rpc.pdumodel.Pdu.PduOrientation.encode(self.pduOrientation)
            return json

    # structure
    class Sensors(Structure):
        idlType = "pdumodel.Pdu_6_3_3.Sensors:1.0.0"
        elements = ["powerSupplyStatus", "activePower", "apparentPower", "activeEnergy", "apparentEnergy"]

        def __init__(self, powerSupplyStatus=[], activePower=None, apparentPower=None, activeEnergy=None, apparentEnergy=None):
            for x0 in powerSupplyStatus:
                typecheck.is_interface(x0, raritan.rpc.sensors.StateSensor, AssertionError)
            typecheck.is_interface(activePower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentPower, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(activeEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)
            typecheck.is_interface(apparentEnergy, raritan.rpc.sensors.NumericSensor, AssertionError)

            self.powerSupplyStatus = powerSupplyStatus
            self.activePower = activePower
            self.apparentPower = apparentPower
            self.activeEnergy = activeEnergy
            self.apparentEnergy = apparentEnergy

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                powerSupplyStatus = [Interface.decode(x0, agent) for x0 in json['powerSupplyStatus']],
                activePower = Interface.decode(json['activePower'], agent),
                apparentPower = Interface.decode(json['apparentPower'], agent),
                activeEnergy = Interface.decode(json['activeEnergy'], agent),
                apparentEnergy = Interface.decode(json['apparentEnergy'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['powerSupplyStatus'] = [Interface.encode(x0) for x0 in self.powerSupplyStatus]
            json['activePower'] = Interface.encode(self.activePower)
            json['apparentPower'] = Interface.encode(self.apparentPower)
            json['activeEnergy'] = Interface.encode(self.activeEnergy)
            json['apparentEnergy'] = Interface.encode(self.apparentEnergy)
            return json

    # structure
    class Statistic(Structure):
        idlType = "pdumodel.Pdu_6_3_3.Statistic:1.0.0"
        elements = ["cbStats", "ctrlStats", "outletStats", "peripheralStats"]

        def __init__(self, cbStats=[], ctrlStats=[], outletStats=[], peripheralStats=None):
            if peripheralStats is None:
                peripheralStats = raritan.rpc.peripheral.DeviceManager.Statistics()
            for x0 in cbStats:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.CircuitBreakerStatistic, AssertionError)
            for x0 in ctrlStats:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.CtrlStatistic, AssertionError)
            for x0 in outletStats:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.OutletStatistic, AssertionError)
            typecheck.is_struct(peripheralStats, raritan.rpc.peripheral.DeviceManager.Statistics, AssertionError)

            self.cbStats = cbStats
            self.ctrlStats = ctrlStats
            self.outletStats = outletStats
            self.peripheralStats = peripheralStats

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                cbStats = [raritan.rpc.pdumodel.CircuitBreakerStatistic.decode(x0, agent) for x0 in json['cbStats']],
                ctrlStats = [raritan.rpc.pdumodel.CtrlStatistic.decode(x0, agent) for x0 in json['ctrlStats']],
                outletStats = [raritan.rpc.pdumodel.OutletStatistic.decode(x0, agent) for x0 in json['outletStats']],
                peripheralStats = raritan.rpc.peripheral.DeviceManager.Statistics.decode(json['peripheralStats'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['cbStats'] = [raritan.rpc.pdumodel.CircuitBreakerStatistic.encode(x0) for x0 in self.cbStats]
            json['ctrlStats'] = [raritan.rpc.pdumodel.CtrlStatistic.encode(x0) for x0 in self.ctrlStats]
            json['outletStats'] = [raritan.rpc.pdumodel.OutletStatistic.encode(x0) for x0 in self.outletStats]
            json['peripheralStats'] = raritan.rpc.peripheral.DeviceManager.Statistics.encode(self.peripheralStats)
            return json

    # enumeration
    class StartupState(Enumeration):
        idlType = "pdumodel.Pdu_6_3_3.StartupState:1.0.0"
        values = ["SS_ON", "SS_OFF", "SS_LASTKNOWN"]

    StartupState.SS_ON = StartupState(0)
    StartupState.SS_OFF = StartupState(1)
    StartupState.SS_LASTKNOWN = StartupState(2)

    # structure
    class Settings(Structure):
        idlType = "pdumodel.Pdu_6_3_3.Settings:1.0.0"
        elements = ["name", "startupState", "cycleDelay", "inRushGuardDelay", "outletPowerStateSequence", "powerOnDelay", "latchingRelays", "energyPulseEnabled", "energyPulsesPerKWh", "demandUpdateInterval", "demandAveragingIntervals", "suspendTripCauseOutlets"]

        def __init__(self, name="", startupState=None, cycleDelay=0, inRushGuardDelay=0, outletPowerStateSequence=[], powerOnDelay=0, latchingRelays=False, energyPulseEnabled=False, energyPulsesPerKWh=0, demandUpdateInterval=0, demandAveragingIntervals=0, suspendTripCauseOutlets=False):
            if startupState is None:
                startupState = raritan.rpc.pdumodel.Pdu.StartupState.SS_ON
            typecheck.is_string(name, AssertionError)
            typecheck.is_enum(startupState, raritan.rpc.pdumodel.Pdu.StartupState, AssertionError)
            typecheck.is_int(cycleDelay, AssertionError)
            typecheck.is_int(inRushGuardDelay, AssertionError)
            for x0 in outletPowerStateSequence:
                typecheck.is_int(x0, AssertionError)
            typecheck.is_int(powerOnDelay, AssertionError)
            typecheck.is_bool(latchingRelays, AssertionError)
            typecheck.is_bool(energyPulseEnabled, AssertionError)
            typecheck.is_int(energyPulsesPerKWh, AssertionError)
            typecheck.is_int(demandUpdateInterval, AssertionError)
            typecheck.is_int(demandAveragingIntervals, AssertionError)
            typecheck.is_bool(suspendTripCauseOutlets, AssertionError)

            self.name = name
            self.startupState = startupState
            self.cycleDelay = cycleDelay
            self.inRushGuardDelay = inRushGuardDelay
            self.outletPowerStateSequence = outletPowerStateSequence
            self.powerOnDelay = powerOnDelay
            self.latchingRelays = latchingRelays
            self.energyPulseEnabled = energyPulseEnabled
            self.energyPulsesPerKWh = energyPulsesPerKWh
            self.demandUpdateInterval = demandUpdateInterval
            self.demandAveragingIntervals = demandAveragingIntervals
            self.suspendTripCauseOutlets = suspendTripCauseOutlets

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                startupState = raritan.rpc.pdumodel.Pdu.StartupState.decode(json['startupState']),
                cycleDelay = json['cycleDelay'],
                inRushGuardDelay = json['inRushGuardDelay'],
                outletPowerStateSequence = [x0 for x0 in json['outletPowerStateSequence']],
                powerOnDelay = json['powerOnDelay'],
                latchingRelays = json['latchingRelays'],
                energyPulseEnabled = json['energyPulseEnabled'],
                energyPulsesPerKWh = json['energyPulsesPerKWh'],
                demandUpdateInterval = json['demandUpdateInterval'],
                demandAveragingIntervals = json['demandAveragingIntervals'],
                suspendTripCauseOutlets = json['suspendTripCauseOutlets'],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['startupState'] = raritan.rpc.pdumodel.Pdu.StartupState.encode(self.startupState)
            json['cycleDelay'] = self.cycleDelay
            json['inRushGuardDelay'] = self.inRushGuardDelay
            json['outletPowerStateSequence'] = [x0 for x0 in self.outletPowerStateSequence]
            json['powerOnDelay'] = self.powerOnDelay
            json['latchingRelays'] = self.latchingRelays
            json['energyPulseEnabled'] = self.energyPulseEnabled
            json['energyPulsesPerKWh'] = self.energyPulsesPerKWh
            json['demandUpdateInterval'] = self.demandUpdateInterval
            json['demandAveragingIntervals'] = self.demandAveragingIntervals
            json['suspendTripCauseOutlets'] = self.suspendTripCauseOutlets
            return json

    # structure
    class OutletSequenceState(Structure):
        idlType = "pdumodel.Pdu_6_3_3.OutletSequenceState:1.0.0"
        elements = ["sequenceRunning", "nextOutletToSwitch", "timeUntilNextSwitch", "outletsRemaining", "cancelableOutletsRemaining"]

        def __init__(self, sequenceRunning=False, nextOutletToSwitch=0, timeUntilNextSwitch=0, outletsRemaining=0, cancelableOutletsRemaining=0):
            typecheck.is_bool(sequenceRunning, AssertionError)
            typecheck.is_int(nextOutletToSwitch, AssertionError)
            typecheck.is_int(timeUntilNextSwitch, AssertionError)
            typecheck.is_int(outletsRemaining, AssertionError)
            typecheck.is_int(cancelableOutletsRemaining, AssertionError)

            self.sequenceRunning = sequenceRunning
            self.nextOutletToSwitch = nextOutletToSwitch
            self.timeUntilNextSwitch = timeUntilNextSwitch
            self.outletsRemaining = outletsRemaining
            self.cancelableOutletsRemaining = cancelableOutletsRemaining

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                sequenceRunning = json['sequenceRunning'],
                nextOutletToSwitch = json['nextOutletToSwitch'],
                timeUntilNextSwitch = json['timeUntilNextSwitch'],
                outletsRemaining = json['outletsRemaining'],
                cancelableOutletsRemaining = json['cancelableOutletsRemaining'],
            )
            return obj

        def encode(self):
            json = {}
            json['sequenceRunning'] = self.sequenceRunning
            json['nextOutletToSwitch'] = self.nextOutletToSwitch
            json['timeUntilNextSwitch'] = self.timeUntilNextSwitch
            json['outletsRemaining'] = self.outletsRemaining
            json['cancelableOutletsRemaining'] = self.cancelableOutletsRemaining
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Pdu_6_3_3.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Pdu.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldSettings is None:
                oldSettings = raritan.rpc.pdumodel.Pdu.Settings()
            if newSettings is None:
                newSettings = raritan.rpc.pdumodel.Pdu.Settings()
            typecheck.is_struct(oldSettings, raritan.rpc.pdumodel.Pdu.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.pdumodel.Pdu.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.Pdu.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.pdumodel.Pdu.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.pdumodel.Pdu.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.pdumodel.Pdu.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.pdumodel.Pdu.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.pdumodel.Pdu.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class LoadSheddingModeChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Pdu_6_3_3.LoadSheddingModeChangedEvent:1.0.0"

        def __init__(self, enabled=False, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Pdu.LoadSheddingModeChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_bool(enabled, AssertionError)

            self.enabled = enabled

        def encode(self):
            json = super(raritan.rpc.pdumodel.Pdu.LoadSheddingModeChangedEvent, self).encode()
            json['enabled'] = self.enabled
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                enabled = json['enabled'],
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["enabled"]
            elements = elements + super(raritan.rpc.pdumodel.Pdu.LoadSheddingModeChangedEvent, self).listElements()
            return elements

    # value object
    class OutletSequenceStateChangedEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.Pdu_6_3_3.OutletSequenceStateChangedEvent:1.0.0"

        def __init__(self, newState=None, source=None):
            super(raritan.rpc.pdumodel.Pdu.OutletSequenceStateChangedEvent, self).__init__(source)
            if newState is None:
                newState = raritan.rpc.pdumodel.Pdu.OutletSequenceState()
            typecheck.is_struct(newState, raritan.rpc.pdumodel.Pdu.OutletSequenceState, AssertionError)

            self.newState = newState

        def encode(self):
            json = super(raritan.rpc.pdumodel.Pdu.OutletSequenceStateChangedEvent, self).encode()
            json['newState'] = raritan.rpc.pdumodel.Pdu.OutletSequenceState.encode(self.newState)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                newState = raritan.rpc.pdumodel.Pdu.OutletSequenceState.decode(json['newState'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["newState"]
            elements = elements + super(raritan.rpc.pdumodel.Pdu.OutletSequenceStateChangedEvent, self).listElements()
            return elements

    class _getNameplate(Interface.Method):
        name = 'getNameplate'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Nameplate.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Nameplate, DecodeException)
            return _ret_

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Pdu.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Pdu.MetaData, DecodeException)
            return _ret_

    class _getSensors(Interface.Method):
        name = 'getSensors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Pdu.Sensors.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Pdu.Sensors, DecodeException)
            return _ret_

    class _getSensorLogger(Interface.Method):
        name = 'getSensorLogger'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.sensors.Logger, DecodeException)
            return _ret_

    class _getAlertedSensorManager(Interface.Method):
        name = 'getAlertedSensorManager'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.sensors.AlertedSensorManager, DecodeException)
            return _ret_

    class _getControllers(Interface.Method):
        name = 'getControllers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Controller, DecodeException)
            return _ret_

    class _getOutlets(Interface.Method):
        name = 'getOutlets'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Outlet, DecodeException)
            return _ret_

    class _getOverCurrentProtectors(Interface.Method):
        name = 'getOverCurrentProtectors'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.OverCurrentProtector, DecodeException)
            return _ret_

    class _getInlets(Interface.Method):
        name = 'getInlets'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.Inlet, DecodeException)
            return _ret_

    class _getTransferSwitches(Interface.Method):
        name = 'getTransferSwitches'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.pdumodel.TransferSwitch, DecodeException)
            return _ret_

    class _getPeripheralDeviceManager(Interface.Method):
        name = 'getPeripheralDeviceManager'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.peripheral.DeviceManager, DecodeException)
            return _ret_

    class _getBeeper(Interface.Method):
        name = 'getBeeper'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.hmi.InternalBeeper, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Pdu.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Pdu.Settings, DecodeException)
            return _ret_

    class _isLoadSheddingActive(Interface.Method):
        name = 'isLoadSheddingActive'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Pdu.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Pdu.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setLoadSheddingActive(Interface.Method):
        name = 'setLoadSheddingActive'

        @staticmethod
        def encode(active):
            typecheck.is_bool(active, AssertionError)
            args = {}
            args['active'] = active
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _getFeaturePorts(Interface.Method):
        name = 'getFeaturePorts'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.portsmodel.Port, DecodeException)
            return _ret_

    class _getSensorPorts(Interface.Method):
        name = 'getSensorPorts'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.portsmodel.Port, DecodeException)
            return _ret_

    class _getRemoteHubPorts(Interface.Method):
        name = 'getRemoteHubPorts'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.portsmodel.Port, DecodeException)
            return _ret_

    class _enterRS485ConfigModeAndAssignCtrlBoardAddress(Interface.Method):
        name = 'enterRS485ConfigModeAndAssignCtrlBoardAddress'

        @staticmethod
        def encode(addr):
            typecheck.is_int(addr, AssertionError)
            args = {}
            args['addr'] = addr
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _enterRS485ConfigModeAndAssignSCBoardAddress(Interface.Method):
        name = 'enterRS485ConfigModeAndAssignSCBoardAddress'

        @staticmethod
        def encode(deviceId, addr):
            typecheck.is_int(deviceId, AssertionError)
            typecheck.is_int(addr, AssertionError)
            args = {}
            args['deviceId'] = deviceId
            args['addr'] = addr
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _leaveRS485ConfigMode(Interface.Method):
        name = 'leaveRS485ConfigMode'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setAllOutletPowerStates(Interface.Method):
        name = 'setAllOutletPowerStates'

        @staticmethod
        def encode(pstate):
            typecheck.is_enum(pstate, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            args = {}
            args['pstate'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(pstate)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setMultipleOutletPowerStates(Interface.Method):
        name = 'setMultipleOutletPowerStates'

        @staticmethod
        def encode(outletNumbers, state, respectSequence):
            for x0 in outletNumbers:
                typecheck.is_int(x0, AssertionError)
            typecheck.is_enum(state, raritan.rpc.pdumodel.Outlet.PowerState, AssertionError)
            typecheck.is_bool(respectSequence, AssertionError)
            args = {}
            args['outletNumbers'] = [x0 for x0 in outletNumbers]
            args['state'] = raritan.rpc.pdumodel.Outlet.PowerState.encode(state)
            args['respectSequence'] = respectSequence
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _cycleAllOutletPowerStates(Interface.Method):
        name = 'cycleAllOutletPowerStates'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _cycleMultipleOutletPowerStates(Interface.Method):
        name = 'cycleMultipleOutletPowerStates'

        @staticmethod
        def encode(outletNumbers, respectSequence):
            for x0 in outletNumbers:
                typecheck.is_int(x0, AssertionError)
            typecheck.is_bool(respectSequence, AssertionError)
            args = {}
            args['outletNumbers'] = [x0 for x0 in outletNumbers]
            args['respectSequence'] = respectSequence
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getStatistic(Interface.Method):
        name = 'getStatistic'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Pdu.Statistic.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Pdu.Statistic, DecodeException)
            return _ret_

    class _getOutletSequenceState(Interface.Method):
        name = 'getOutletSequenceState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Pdu.OutletSequenceState.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Pdu.OutletSequenceState, DecodeException)
            return _ret_

    class _cancelOutletSequence(Interface.Method):
        name = 'cancelOutletSequence'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None
    def __init__(self, target, agent):
        super(Pdu, self).__init__(target, agent)
        self.getNameplate = Pdu._getNameplate(self)
        self.getMetaData = Pdu._getMetaData(self)
        self.getSensors = Pdu._getSensors(self)
        self.getSensorLogger = Pdu._getSensorLogger(self)
        self.getAlertedSensorManager = Pdu._getAlertedSensorManager(self)
        self.getControllers = Pdu._getControllers(self)
        self.getOutlets = Pdu._getOutlets(self)
        self.getOverCurrentProtectors = Pdu._getOverCurrentProtectors(self)
        self.getInlets = Pdu._getInlets(self)
        self.getTransferSwitches = Pdu._getTransferSwitches(self)
        self.getPeripheralDeviceManager = Pdu._getPeripheralDeviceManager(self)
        self.getBeeper = Pdu._getBeeper(self)
        self.getSettings = Pdu._getSettings(self)
        self.isLoadSheddingActive = Pdu._isLoadSheddingActive(self)
        self.setSettings = Pdu._setSettings(self)
        self.setLoadSheddingActive = Pdu._setLoadSheddingActive(self)
        self.getFeaturePorts = Pdu._getFeaturePorts(self)
        self.getSensorPorts = Pdu._getSensorPorts(self)
        self.getRemoteHubPorts = Pdu._getRemoteHubPorts(self)
        self.enterRS485ConfigModeAndAssignCtrlBoardAddress = Pdu._enterRS485ConfigModeAndAssignCtrlBoardAddress(self)
        self.enterRS485ConfigModeAndAssignSCBoardAddress = Pdu._enterRS485ConfigModeAndAssignSCBoardAddress(self)
        self.leaveRS485ConfigMode = Pdu._leaveRS485ConfigMode(self)
        self.setAllOutletPowerStates = Pdu._setAllOutletPowerStates(self)
        self.setMultipleOutletPowerStates = Pdu._setMultipleOutletPowerStates(self)
        self.cycleAllOutletPowerStates = Pdu._cycleAllOutletPowerStates(self)
        self.cycleMultipleOutletPowerStates = Pdu._cycleMultipleOutletPowerStates(self)
        self.getStatistic = Pdu._getStatistic(self)
        self.getOutletSequenceState = Pdu._getOutletSequenceState(self)
        self.cancelOutletSequence = Pdu._cancelOutletSequence(self)

#
# Section generated by IdlC from "PowerMeterController.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel


# interface
class PowerMeterController(Interface):
    idlType = "pdumodel.PowerMeterController:1.2.10"

    ERR_INVALID_PARAM = 1

    ERR_METER_BOARD_BUSY = 2

    # structure
    class ScanResult(Structure):
        idlType = "pdumodel.PowerMeterController_1_2_10.ScanResult:1.0.0"
        elements = ["present", "meterCount"]

        def __init__(self, present=False, meterCount=0):
            typecheck.is_bool(present, AssertionError)
            typecheck.is_int(meterCount, AssertionError)

            self.present = present
            self.meterCount = meterCount

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                present = json['present'],
                meterCount = json['meterCount'],
            )
            return obj

        def encode(self):
            json = {}
            json['present'] = self.present
            json['meterCount'] = self.meterCount
            return json

    class _scanMeterBoard(Interface.Method):
        name = 'scanMeterBoard'

        @staticmethod
        def encode(powerMeterId):
            typecheck.is_int(powerMeterId, AssertionError)
            args = {}
            args['powerMeterId'] = powerMeterId
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            result = raritan.rpc.pdumodel.PowerMeterController.ScanResult.decode(rsp['result'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_struct(result, raritan.rpc.pdumodel.PowerMeterController.ScanResult, DecodeException)
            return (_ret_, result)

    # value object
    class PowerMeterCreatedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.PowerMeterController_1_2_10.PowerMeterCreatedEvent:1.0.0"

        def __init__(self, powerMeter=None, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterCreatedEvent, self).__init__(actUserName, actIpAddr, source)
            if config is None:
                config = raritan.rpc.pdumodel.PowerMeter.Config()
            if settings is None:
                settings = raritan.rpc.pdumodel.PowerMeter.Settings()
            typecheck.is_interface(powerMeter, raritan.rpc.pdumodel.PowerMeter, AssertionError)
            typecheck.is_struct(config, raritan.rpc.pdumodel.PowerMeter.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)

            self.powerMeter = powerMeter
            self.config = config
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterCreatedEvent, self).encode()
            json['powerMeter'] = Interface.encode(self.powerMeter)
            json['config'] = raritan.rpc.pdumodel.PowerMeter.Config.encode(self.config)
            json['settings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                powerMeter = Interface.decode(json['powerMeter'], agent),
                config = raritan.rpc.pdumodel.PowerMeter.Config.decode(json['config'], agent),
                settings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['settings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["powerMeter", "config", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterCreatedEvent, self).listElements()
            return elements

    # value object
    class PowerMeterDeletedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.PowerMeterController_1_2_10.PowerMeterDeletedEvent:1.0.0"

        def __init__(self, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterDeletedEvent, self).__init__(actUserName, actIpAddr, source)
            if config is None:
                config = raritan.rpc.pdumodel.PowerMeter.Config()
            if settings is None:
                settings = raritan.rpc.pdumodel.PowerMeter.Settings()
            typecheck.is_struct(config, raritan.rpc.pdumodel.PowerMeter.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)

            self.config = config
            self.settings = settings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterDeletedEvent, self).encode()
            json['config'] = raritan.rpc.pdumodel.PowerMeter.Config.encode(self.config)
            json['settings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(self.settings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                config = raritan.rpc.pdumodel.PowerMeter.Config.decode(json['config'], agent),
                settings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['settings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["config", "settings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeterController.PowerMeterDeletedEvent, self).listElements()
            return elements

    # value object
    class PanelCreatedEvent(PowerMeterCreatedEvent):
        idlType = "pdumodel.PowerMeterController_1_2_10.PanelCreatedEvent:1.0.0"

        def __init__(self, panelSettings=None, powerMeter=None, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeterController.PanelCreatedEvent, self).__init__(powerMeter, config, settings, actUserName, actIpAddr, source)
            if panelSettings is None:
                panelSettings = raritan.rpc.pdumodel.Panel.PanelSettings()
            typecheck.is_struct(panelSettings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)

            self.panelSettings = panelSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeterController.PanelCreatedEvent, self).encode()
            json['panelSettings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(self.panelSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                panelSettings = raritan.rpc.pdumodel.Panel.PanelSettings.decode(json['panelSettings'], agent),
                # for pdumodel.PowerMeterController_1_2_10.PowerMeterCreatedEvent
                powerMeter = Interface.decode(json['powerMeter'], agent),
                config = raritan.rpc.pdumodel.PowerMeter.Config.decode(json['config'], agent),
                settings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['settings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["panelSettings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeterController.PanelCreatedEvent, self).listElements()
            return elements

    # value object
    class PanelDeletedEvent(PowerMeterDeletedEvent):
        idlType = "pdumodel.PowerMeterController_1_2_10.PanelDeletedEvent:1.0.0"

        def __init__(self, panelSettings=None, config=None, settings=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.PowerMeterController.PanelDeletedEvent, self).__init__(config, settings, actUserName, actIpAddr, source)
            if panelSettings is None:
                panelSettings = raritan.rpc.pdumodel.Panel.PanelSettings()
            typecheck.is_struct(panelSettings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)

            self.panelSettings = panelSettings

        def encode(self):
            json = super(raritan.rpc.pdumodel.PowerMeterController.PanelDeletedEvent, self).encode()
            json['panelSettings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(self.panelSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                panelSettings = raritan.rpc.pdumodel.Panel.PanelSettings.decode(json['panelSettings'], agent),
                # for pdumodel.PowerMeterController_1_2_10.PowerMeterDeletedEvent
                config = raritan.rpc.pdumodel.PowerMeter.Config.decode(json['config'], agent),
                settings = raritan.rpc.pdumodel.PowerMeter.Settings.decode(json['settings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["panelSettings"]
            elements = elements + super(raritan.rpc.pdumodel.PowerMeterController.PanelDeletedEvent, self).listElements()
            return elements

    class _getPowerMeters(Interface.Method):
        name = 'getPowerMeters'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = dict([(
                elem['key'],
                Interface.decode(elem['value'], agent))
                for elem in rsp['_ret_']])
            return _ret_

    class _createPowerMeter(Interface.Method):
        name = 'createPowerMeter'

        @staticmethod
        def encode(config, settings):
            typecheck.is_struct(config, raritan.rpc.pdumodel.PowerMeter.Config, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)
            args = {}
            args['config'] = raritan.rpc.pdumodel.PowerMeter.Config.encode(config)
            args['settings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            powerMeter = Interface.decode(rsp['powerMeter'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_interface(powerMeter, raritan.rpc.pdumodel.PowerMeter, DecodeException)
            return (_ret_, powerMeter)

    class _createPanel(Interface.Method):
        name = 'createPanel'

        @staticmethod
        def encode(config, powerMeterSettings, panelSettings):
            typecheck.is_struct(config, raritan.rpc.pdumodel.PowerMeter.Config, AssertionError)
            typecheck.is_struct(powerMeterSettings, raritan.rpc.pdumodel.PowerMeter.Settings, AssertionError)
            typecheck.is_struct(panelSettings, raritan.rpc.pdumodel.Panel.PanelSettings, AssertionError)
            args = {}
            args['config'] = raritan.rpc.pdumodel.PowerMeter.Config.encode(config)
            args['powerMeterSettings'] = raritan.rpc.pdumodel.PowerMeter.Settings.encode(powerMeterSettings)
            args['panelSettings'] = raritan.rpc.pdumodel.Panel.PanelSettings.encode(panelSettings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            panel = Interface.decode(rsp['panel'], agent)
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_interface(panel, raritan.rpc.pdumodel.Panel, DecodeException)
            return (_ret_, panel)

    class _deletePowerMeter(Interface.Method):
        name = 'deletePowerMeter'

        @staticmethod
        def encode(powerMeterId):
            typecheck.is_int(powerMeterId, AssertionError)
            args = {}
            args['powerMeterId'] = powerMeterId
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(PowerMeterController, self).__init__(target, agent)
        self.scanMeterBoard = PowerMeterController._scanMeterBoard(self)
        self.getPowerMeters = PowerMeterController._getPowerMeters(self)
        self.createPowerMeter = PowerMeterController._createPowerMeter(self)
        self.createPanel = PowerMeterController._createPanel(self)
        self.deletePowerMeter = PowerMeterController._deletePowerMeter(self)

#
# Section generated by IdlC from "PowerQualitySensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.sensors


# interface
class PowerQualitySensor(raritan.rpc.sensors.StateSensor):
    idlType = "pdumodel.PowerQualitySensor:2.0.6"

    STATE_NORMAL = 0

    STATE_WARNING = 1

    STATE_CRITICAL = 2

#
# Section generated by IdlC from "TypeBResidualCurrentNumericSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.sensors


# interface
class TypeBResidualCurrentNumericSensor(raritan.rpc.sensors.NumericSensor):
    idlType = "pdumodel.TypeBResidualCurrentNumericSensor:1.0.6"

    class _degauss(Interface.Method):
        name = 'degauss'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None
    def __init__(self, target, agent):
        super(TypeBResidualCurrentNumericSensor, self).__init__(target, agent)
        self.degauss = TypeBResidualCurrentNumericSensor._degauss(self)

#
# Section generated by IdlC from "Unit.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.pdumodel


# interface
class Unit(Interface):
    idlType = "pdumodel.Unit:2.0.1"

    ERR_INVALID_PARAM = 1

    # enumeration
    class Orientation(Enumeration):
        idlType = "pdumodel.Unit_2_0_1.Orientation:1.0.0"
        values = ["NORMAL", "FLIPPED"]

    Orientation.NORMAL = Orientation(0)
    Orientation.FLIPPED = Orientation(1)

    # structure
    class MetaData(Structure):
        idlType = "pdumodel.Unit_2_0_1.MetaData:1.0.0"
        elements = ["hasOrientationSensor", "supportedDisplayOrientations"]

        def __init__(self, hasOrientationSensor=False, supportedDisplayOrientations=[]):
            typecheck.is_bool(hasOrientationSensor, AssertionError)
            for x0 in supportedDisplayOrientations:
                typecheck.is_enum(x0, raritan.rpc.pdumodel.Unit.Orientation, AssertionError)

            self.hasOrientationSensor = hasOrientationSensor
            self.supportedDisplayOrientations = supportedDisplayOrientations

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                hasOrientationSensor = json['hasOrientationSensor'],
                supportedDisplayOrientations = [raritan.rpc.pdumodel.Unit.Orientation.decode(x0) for x0 in json['supportedDisplayOrientations']],
            )
            return obj

        def encode(self):
            json = {}
            json['hasOrientationSensor'] = self.hasOrientationSensor
            json['supportedDisplayOrientations'] = [raritan.rpc.pdumodel.Unit.Orientation.encode(x0) for x0 in self.supportedDisplayOrientations]
            return json

    # structure
    class Settings(Structure):
        idlType = "pdumodel.Unit_2_0_1.Settings:1.0.0"
        elements = ["buzzerMuted", "autoDisplayOrientation", "displayOrientation"]

        def __init__(self, buzzerMuted=False, autoDisplayOrientation=False, displayOrientation=None):
            if displayOrientation is None:
                displayOrientation = raritan.rpc.pdumodel.Unit.Orientation.NORMAL
            typecheck.is_bool(buzzerMuted, AssertionError)
            typecheck.is_bool(autoDisplayOrientation, AssertionError)
            typecheck.is_enum(displayOrientation, raritan.rpc.pdumodel.Unit.Orientation, AssertionError)

            self.buzzerMuted = buzzerMuted
            self.autoDisplayOrientation = autoDisplayOrientation
            self.displayOrientation = displayOrientation

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                buzzerMuted = json['buzzerMuted'],
                autoDisplayOrientation = json['autoDisplayOrientation'],
                displayOrientation = raritan.rpc.pdumodel.Unit.Orientation.decode(json['displayOrientation']),
            )
            return obj

        def encode(self):
            json = {}
            json['buzzerMuted'] = self.buzzerMuted
            json['autoDisplayOrientation'] = self.autoDisplayOrientation
            json['displayOrientation'] = raritan.rpc.pdumodel.Unit.Orientation.encode(self.displayOrientation)
            return json

    # value object
    class IdentificationStartedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.Unit_2_0_1.IdentificationStartedEvent:1.0.0"

        def __init__(self, duration=0, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.Unit.IdentificationStartedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_int(duration, AssertionError)

            self.duration = duration

        def encode(self):
            json = super(raritan.rpc.pdumodel.Unit.IdentificationStartedEvent, self).encode()
            json['duration'] = self.duration
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                duration = json['duration'],
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["duration"]
            elements = elements + super(raritan.rpc.pdumodel.Unit.IdentificationStartedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Unit.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Unit.MetaData, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Unit.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.Unit.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.pdumodel.Unit.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.pdumodel.Unit.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _identify(Interface.Method):
        name = 'identify'

        @staticmethod
        def encode(seconds):
            typecheck.is_int(seconds, AssertionError)
            args = {}
            args['seconds'] = seconds
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _muteBuzzer(Interface.Method):
        name = 'muteBuzzer'

        @staticmethod
        def encode(mute):
            typecheck.is_bool(mute, AssertionError)
            args = {}
            args['mute'] = mute
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _getDisplayOrientation(Interface.Method):
        name = 'getDisplayOrientation'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.Unit.Orientation.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.pdumodel.Unit.Orientation, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Unit, self).__init__(target, agent)
        self.getMetaData = Unit._getMetaData(self)
        self.getSettings = Unit._getSettings(self)
        self.setSettings = Unit._setSettings(self)
        self.identify = Unit._identify(self)
        self.muteBuzzer = Unit._muteBuzzer(self)
        self.getDisplayOrientation = Unit._getDisplayOrientation(self)

#
# Section generated by IdlC from "VoltageMonitoringSensor.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.pdumodel

import raritan.rpc.sensors


# interface
class VoltageMonitoringSensor(raritan.rpc.sensors.NumericSensor):
    idlType = "pdumodel.VoltageMonitoringSensor:1.0.2"

    # enumeration
    class EventType(Enumeration):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_2.EventType:1.0.0"
        values = ["DIP", "SWELL", "UNKNOWN"]

    EventType.DIP = EventType(0)
    EventType.SWELL = EventType(1)
    EventType.UNKNOWN = EventType(2)
    EventType._fallback = EventType.UNKNOWN

    # structure
    class DipSwellThresholds(Structure):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_2.DipSwellThresholds:1.0.0"
        elements = ["dipActive", "dipThreshold", "swellActive", "swellThreshold", "deassertionHysteresis"]

        def __init__(self, dipActive=False, dipThreshold=0.0, swellActive=False, swellThreshold=0.0, deassertionHysteresis=0.0):
            typecheck.is_bool(dipActive, AssertionError)
            typecheck.is_double(dipThreshold, AssertionError)
            typecheck.is_bool(swellActive, AssertionError)
            typecheck.is_double(swellThreshold, AssertionError)
            typecheck.is_float(deassertionHysteresis, AssertionError)

            self.dipActive = dipActive
            self.dipThreshold = dipThreshold
            self.swellActive = swellActive
            self.swellThreshold = swellThreshold
            self.deassertionHysteresis = deassertionHysteresis

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                dipActive = json['dipActive'],
                dipThreshold = json['dipThreshold'],
                swellActive = json['swellActive'],
                swellThreshold = json['swellThreshold'],
                deassertionHysteresis = json['deassertionHysteresis'],
            )
            return obj

        def encode(self):
            json = {}
            json['dipActive'] = self.dipActive
            json['dipThreshold'] = self.dipThreshold
            json['swellActive'] = self.swellActive
            json['swellThreshold'] = self.swellThreshold
            json['deassertionHysteresis'] = self.deassertionHysteresis
            return json

    # structure
    class Event(Structure):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_2.Event:1.0.0"
        elements = ["type", "timestamp", "duration", "voltage", "waveform"]

        def __init__(self, type=None, timestamp=None, duration=0, voltage=0.0, waveform=None):
            if type is None:
                type = raritan.rpc.pdumodel.VoltageMonitoringSensor.EventType.DIP
            if waveform is None:
                waveform = raritan.rpc.pdumodel.Waveform()
            typecheck.is_enum(type, raritan.rpc.pdumodel.VoltageMonitoringSensor.EventType, AssertionError)
            typecheck.is_time(timestamp, AssertionError)
            typecheck.is_int(duration, AssertionError)
            typecheck.is_double(voltage, AssertionError)
            typecheck.is_struct(waveform, raritan.rpc.pdumodel.Waveform, AssertionError)

            self.type = type
            self.timestamp = timestamp
            self.duration = duration
            self.voltage = voltage
            self.waveform = waveform

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                type = raritan.rpc.pdumodel.VoltageMonitoringSensor.EventType.decode(json['type']),
                timestamp = raritan.rpc.Time.decode(json['timestamp']),
                duration = json['duration'],
                voltage = json['voltage'],
                waveform = raritan.rpc.pdumodel.Waveform.decode(json['waveform'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.pdumodel.VoltageMonitoringSensor.EventType.encode(self.type)
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['duration'] = self.duration
            json['voltage'] = self.voltage
            json['waveform'] = raritan.rpc.pdumodel.Waveform.encode(self.waveform)
            return json

    # value object
    class EventOccurredEvent(raritan.rpc.idl.Event):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_2.EventOccurredEvent:1.0.0"

        def __init__(self, event=None, source=None):
            super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventOccurredEvent, self).__init__(source)
            if event is None:
                event = raritan.rpc.pdumodel.VoltageMonitoringSensor.Event()
            typecheck.is_struct(event, raritan.rpc.pdumodel.VoltageMonitoringSensor.Event, AssertionError)

            self.event = event

        def encode(self):
            json = super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventOccurredEvent, self).encode()
            json['event'] = raritan.rpc.pdumodel.VoltageMonitoringSensor.Event.encode(self.event)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                event = raritan.rpc.pdumodel.VoltageMonitoringSensor.Event.decode(json['event'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["event"]
            elements = elements + super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventOccurredEvent, self).listElements()
            return elements

    # value object
    class EventListClearedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_2.EventListClearedEvent:1.0.0"

        def __init__(self, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventListClearedEvent, self).__init__(actUserName, actIpAddr, source)

        def encode(self):
            json = super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventListClearedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.pdumodel.VoltageMonitoringSensor.EventListClearedEvent, self).listElements()
            return elements

    # value object
    class DipSwellThresholdsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "pdumodel.VoltageMonitoringSensor_1_0_2.DipSwellThresholdsChangedEvent:1.0.0"

        def __init__(self, oldThresholds=None, newThresholds=None, actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholdsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            if oldThresholds is None:
                oldThresholds = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds()
            if newThresholds is None:
                newThresholds = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds()
            typecheck.is_struct(oldThresholds, raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds, AssertionError)
            typecheck.is_struct(newThresholds, raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds, AssertionError)

            self.oldThresholds = oldThresholds
            self.newThresholds = newThresholds

        def encode(self):
            json = super(raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholdsChangedEvent, self).encode()
            json['oldThresholds'] = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.encode(self.oldThresholds)
            json['newThresholds'] = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.encode(self.newThresholds)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldThresholds = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.decode(json['oldThresholds'], agent),
                newThresholds = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.decode(json['newThresholds'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldThresholds", "newThresholds"]
            elements = elements + super(raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholdsChangedEvent, self).listElements()
            return elements

    class _getRecentEvents(Interface.Method):
        name = 'getRecentEvents'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.pdumodel.VoltageMonitoringSensor.Event.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.pdumodel.VoltageMonitoringSensor.Event, DecodeException)
            return _ret_

    class _clearRecentEvents(Interface.Method):
        name = 'clearRecentEvents'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _getDipSwellThresholds(Interface.Method):
        name = 'getDipSwellThresholds'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds, DecodeException)
            return _ret_

    class _setDipSwellThresholds(Interface.Method):
        name = 'setDipSwellThresholds'

        @staticmethod
        def encode(thresholds):
            typecheck.is_struct(thresholds, raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds, AssertionError)
            args = {}
            args['thresholds'] = raritan.rpc.pdumodel.VoltageMonitoringSensor.DipSwellThresholds.encode(thresholds)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(VoltageMonitoringSensor, self).__init__(target, agent)
        self.getRecentEvents = VoltageMonitoringSensor._getRecentEvents(self)
        self.clearRecentEvents = VoltageMonitoringSensor._clearRecentEvents(self)
        self.getDipSwellThresholds = VoltageMonitoringSensor._getDipSwellThresholds(self)
        self.setDipSwellThresholds = VoltageMonitoringSensor._setDipSwellThresholds(self)

# from raritan/rpc/pdumodel/__extend__.py
def download_eto(agent):
    """
    Method to download the eto descriptor

    **parameters**

    :param agent: An agent instance from the device where the eto descriptor should be downloaded
    :return: returns the eto descriptor data

    **Example**
        :Example:

        from raritan import rpc
        from raritan.rpc import pdumodel

        agent = rpc.Agent("https", "my-pdu.example.com", "admin", "raritan")
        # download
        eto_desc = pdumodel.download_eto(agent)
        print(eto_desc)
    """
    target = "cgi-bin/eto_desc.cgi"
    return agent.get(target)

def download_powermeter_csv(agent):
    """
    Method to download a CSV list of mains sensor readings for all configured power meters and panels

    **parameters**

    :param agent: An agent instance from the device where the pmc data should be downloaded
    :return: returns the pmc data in csv format

    **Example**
        :Example:

        from raritan import rpc
        from raritan.rpc import pdumodel

        agent = rpc.Agent("https", "my-pdu.example.com", "admin", "raritan")
        # download
        pmc_data = pdumodel.download_powermeter_csv(agent)
        print(pmc_data)

    """
    target = "cgi-bin/export_pmc.cgi"
    return agent.get(target)

def download_panel_csv(agent, panelid):
    """
    Method to download the pmc data

    **parameters**

    :param agent: An agent instance from the device where the pmc data should be downloaded
    :param panelid: Get the CSV list of main sensors from this panel id (range from 1 - 8)
    :return: returns the pmc data in csv format

    **Example**
        :Example:

        from raritan import rpc
        from raritan.rpc import pdumodel

        agent = rpc.Agent("https", "my-pdu.example.com", "admin", "raritan")
        # download
        pmc_data = pdumodel.download_panel_csv(agent, 1)
        print(pmc_data)

    """
    target = "cgi-bin/export_pmc.cgi?panelid=%i" % panelid
    return agent.get(target)

def upload_pmc_config(agent, data):
    """
    Method to upload pmc config files

    **parameters**, **return**

    :param agent: An agent instance for the device where the config should be uploaded
    :param data: The binary data of the pmc config file
    :return: return upload response

    **Example**
        :Example:

        from raritan import rpc
        from raritan.rpc import pdumodel

        agent = rpc.Agent("https", "my-pdu.example.com", "admin", "raritan")

        # read file in binary mode
        cfgFile = open("config.csv", "rb")
        # upload
        resp = pdumodel.upload_pmc_config(agent, cfgFile.read())
        # view response
        print(resp)

    """
    target = "cgi-bin/upload_pmc_config.cgi"
    formdata = dict(data=data, filename="config.csv", formname="config_file", mimetype="application/octet-stream")
    response = agent.form_data_file(target, [formdata])
    return response["body"]
