; RUN: llvm-ml %s /Fo - | llvm-readobj --section-headers - | FileCheck %s

t1 SEGMENT BYTE
t1 ENDS
; CHECK-LABEL: Name: t1
; CHECK-NOT: }
; CHECK: IMAGE_SCN_ALIGN_1BYTES

t2 SEGMENT WORD
t2 ENDS
; CHECK-LABEL: Name: t2
; CHECK-NOT: }
; CHECK: IMAGE_SCN_ALIGN_2BYTES

t3 SEGMENT DWORD
t3 ENDS
; CHECK-LABEL: Name: t3
; CHECK-NOT: }
; CHECK: IMAGE_SCN_ALIGN_4BYTES

t4 SEGMENT PARA
t4 ENDS
; CHECK-LABEL: Name: t4
; CHECK-NOT: }
; CHECK: IMAGE_SCN_ALIGN_16BYTES

t5 SEGMENT PAGE
t5 ENDS
; CHECK-LABEL: Name: t5
; CHECK-NOT: }
; CHECK: IMAGE_SCN_ALIGN_256BYTES

; Default alignment (should match PARA)
t6 SEGMENT
t6 ENDS
; CHECK-LABEL: Name: t6
; CHECK-NOT: }
; CHECK: IMAGE_SCN_ALIGN_16BYTES

; Unnamed alignment
t7 SEGMENT ALIGN(32)
t7 ENDS
; CHECK-LABEL: Name: t7
; CHECK-NOT: }
; CHECK: IMAGE_SCN_ALIGN_32BYTES

t8 SEGMENT ALIAS('t8_alias')
t8 ENDS
; CHECK-LABEL: Name: t8_alias

t9 SEGMENT 'DATA'
t9 ENDS
; CHECK-LABEL: Name: t9
; CHECK-NOT: }
; CHECK-DAG: IMAGE_SCN_CNT_INITIALIZED_DATA
; CHECK-DAG: IMAGE_SCN_MEM_READ
; CHECK-DAG: IMAGE_SCN_MEM_WRITE
; CHECK: }

t10 SEGMENT 'CODE'
t10 ENDS
; CHECK-LABEL: Name: t10
; CHECK-NOT: }
; CHECK-NOT: IMAGE_SCN_MEM_WRITE
; CHECK-DAG: IMAGE_SCN_CNT_CODE
; CHECK-DAG: IMAGE_SCN_MEM_EXECUTE
; CHECK-DAG: IMAGE_SCN_MEM_READ
; CHECK-NOT: IMAGE_SCN_MEM_WRITE
; CHECK: }

t11 SEGMENT 'CONST'
t11 ENDS
; CHECK-LABEL: Name: t11
; CHECK-NOT: }
; CHECK-DAG: IMAGE_SCN_CNT_INITIALIZED_DATA
; CHECK-DAG: IMAGE_SCN_MEM_READ
; CHECK-DAG: IMAGE_SCN_MEM_WRITE
; CHECK: }

t12 SEGMENT 'STACK'
t12 ENDS
; CHECK-LABEL: Name: t12
; CHECK-NOT: }
; CHECK-DAG: IMAGE_SCN_CNT_INITIALIZED_DATA
; CHECK-DAG: IMAGE_SCN_MEM_READ
; CHECK-DAG: IMAGE_SCN_MEM_WRITE
; CHECK: }

t13 SEGMENT 'DOESNTEXIST'
t13 ENDS
; CHECK-LABEL: Name: t13
; CHECK-NOT: }
; CHECK-DAG: IMAGE_SCN_CNT_INITIALIZED_DATA
; CHECK-DAG: IMAGE_SCN_MEM_READ
; CHECK-DAG: IMAGE_SCN_MEM_WRITE
; CHECK: }

t14 SEGMENT READONLY 'CONST'
t14 ENDS
; CHECK-LABEL: Name: t14
; CHECK-NOT: }
; CHECK-NOT: IMAGE_SCN_MEM_WRITE
; CHECK-DAG: IMAGE_SCN_CNT_INITIALIZED_DATA
; CHECK-DAG: IMAGE_SCN_MEM_READ
; CHECK-NOT: IMAGE_SCN_MEM_WRITE
; CHECK: }

t15 SEGMENT WRITE
t15 ENDS
; CHECK-LABEL: Name: t15
; CHECK-NOT: }
; CHECK-NOT: IMAGE_SCN_MEM_READ
; CHECK-DAG: IMAGE_SCN_CNT_INITIALIZED_DATA
; CHECK-DAG: IMAGE_SCN_MEM_WRITE
; CHECK-NOT: IMAGE_SCN_MEM_READ
; CHECK: }

t16 SEGMENT SHARED NOPAGE NOCACHE INFO READ WRITE EXECUTE DISCARD
t16 ENDS
; CHECK-LABEL: Name: t16
; CHECK-NOT: }
; CHECK-DAG: IMAGE_SCN_LNK_INFO
; CHECK-DAG: IMAGE_SCN_MEM_READ
; CHECK-DAG: IMAGE_SCN_MEM_WRITE
; CHECK-DAG: IMAGE_SCN_MEM_EXECUTE
; CHECK-DAG: IMAGE_SCN_MEM_SHARED
; CHECK-DAG: IMAGE_SCN_MEM_NOT_PAGED
; CHECK-DAG: IMAGE_SCN_MEM_NOT_CACHED
; CHECK-DAG: IMAGE_SCN_MEM_DISCARDABLE
; CHECK: }

_TEXT SEGMENT
_TEXT ENDS
; CHECK-LABEL: Name: .text
; CHECK-NOT: }
; CHECK-NOT: IMAGE_SCN_MEM_WRITE
; CHECK-DAG: IMAGE_SCN_CNT_CODE
; CHECK-DAG: IMAGE_SCN_MEM_EXECUTE
; CHECK-DAG: IMAGE_SCN_MEM_READ
; CHECK-NOT: IMAGE_SCN_MEM_WRITE
; CHECK: }

END
