# rand_core

[![Build Status](https://travis-ci.org/rust-random/rand.svg)](https://travis-ci.org/rust-random/rand)
[![Build Status](https://ci.appveyor.com/api/projects/status/github/rust-random/rand?svg=true)](https://ci.appveyor.com/project/rust-random/rand)
[![Latest version](https://img.shields.io/crates/v/rand_core.svg)](https://crates.io/crates/rand_core)
[![Book](https://img.shields.io/badge/book-master-yellow.svg)](https://rust-random.github.io/book/)
[![API](https://img.shields.io/badge/api-master-yellow.svg)](https://rust-random.github.io/rand/rand_core)
[![API](https://docs.rs/rand_core/badge.svg)](https://docs.rs/rand_core)
[![Minimum rustc version](https://img.shields.io/badge/rustc-1.22+-lightgray.svg)](https://github.com/rust-random/rand#rust-version-requirements)

Core traits and error types of the [rand] library, plus tools for implementing
RNGs.

This crate is intended for use when implementing the core trait, `RngCore`; it
defines the core traits to be implemented as well as several small functions to
aid in their implementation and types required for error handling.

The main [rand] crate re-exports most items defined in this crate, along with
tools to convert the integer samples generated by `RngCore` to many different
applications (including sampling from restricted ranges, conversion to floating
point, list permutations and secure initialisation of RNGs). Most users should
prefer to use the main [rand] crate.

Links:

-   [API documentation (master)](https://rust-random.github.io/rand/rand_core)
-   [API documentation (docs.rs)](https://docs.rs/rand_core)
-   [Changelog](CHANGELOG.md)

[rand]: https://crates.io/crates/rand


## Functionality

The `rand_core` crate provides:

-   base random number generator traits
-   error-reporting types
-   functionality to aid implementation of RNGs

The traits and error types are also available via `rand`.

## Crate Features

`rand_core` supports `no_std` and `alloc`-only configurations, as well as full
`std` functionality. The differences between `no_std` and full `std` are small,
comprising `RngCore` support for `Box<R>` types where `R: RngCore`,
`std::io::Read` support for types supporting `RngCore`, and
extensions to the `Error` type's functionality.

The `std` feature is *not enabled by default*. This is primarily to avoid build
problems where one crate implicitly requires `rand_core` with `std` support and
another crate requires `rand` *without* `std` support. However, the `rand` crate
continues to enable `std` support by default, both for itself and `rand_core`.

The `serde1` feature can be used to derive `Serialize` and `Deserialize` for RNG
implementations that use the `BlockRng` or `BlockRng64` wrappers.


# License

`rand_core` is distributed under the terms of both the MIT license and the
Apache License (Version 2.0).

See [LICENSE-APACHE](LICENSE-APACHE) and [LICENSE-MIT](LICENSE-MIT), and
[COPYRIGHT](COPYRIGHT) for details.
