A `#[marker]` trait contained an associated item.

Erroneous code example:

```compile_fail,E0714
#![feature(marker_trait_attr)]
#![feature(associated_type_defaults)]

#[marker]
trait MarkerConst {
    const N: usize; // error!
}

fn main() {}
```

The items of marker traits cannot be overridden, so there's no need to have them
when they cannot be changed per-type anyway.  If you wanted them for ergonomic
reasons, consider making an extension trait instead.
