/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010-2010 - DIGITEO - Clement DAVID <clement.david@scilab.org>
 * Copyright (C) 2011-2013 - Scilab Enterprises - Clement DAVID
 *
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at
 * http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.txt
 *
 */

package org.scilab.modules.xcos.modelica.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;


/**
 * Partial tree of a structured content. Each node of a this type must not be a leaf.
 *
 * <p>Java class for Struct complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="Struct">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="subnodes">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;sequence>
 *                   &lt;choice maxOccurs="unbounded" minOccurs="0">
 *                     &lt;element name="struct" type="{}Struct"/>
 *                     &lt;element name="terminal" type="{}Terminal"/>
 *                   &lt;/choice>
 *                 &lt;/sequence>
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Struct", propOrder = {
    "name",
    "subnodes"
})
public class Struct {

    @XmlElement(required = true)
    protected String name;
    @XmlElement(required = true)
    protected Struct.Subnodes subnodes;

    /**
     * Gets the value of the name property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the subnodes property.
     *
     * @return
     *     possible object is
     *     {@link Struct.Subnodes }
     *
     */
    public Struct.Subnodes getSubnodes() {
        return subnodes;
    }

    /**
     * Sets the value of the subnodes property.
     *
     * @param value
     *     allowed object is
     *     {@link Struct.Subnodes }
     *
     */
    public void setSubnodes(Struct.Subnodes value) {
        this.subnodes = value;
    }


    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;sequence>
     *         &lt;choice maxOccurs="unbounded" minOccurs="0">
     *           &lt;element name="struct" type="{}Struct"/>
     *           &lt;element name="terminal" type="{}Terminal"/>
     *         &lt;/choice>
     *       &lt;/sequence>
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     *
     *
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "structOrTerminal"
    })
    public static class Subnodes {

        @XmlElements({
            @XmlElement(name = "terminal", type = Terminal.class),
            @XmlElement(name = "struct", type = Struct.class)
        })
        protected List<Object> structOrTerminal;

        /**
         * Gets the value of the structOrTerminal property.
         *
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the structOrTerminal property.
         *
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getStructOrTerminal().add(newItem);
         * </pre>
         *
         *
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link Terminal }
         * {@link Struct }
         *
         *
         */
        public List<Object> getStructOrTerminal() {
            if (structOrTerminal == null) {
                structOrTerminal = new ArrayList<Object>();
            }
            return this.structOrTerminal;
        }

    }

}
