# - Find smartcardpp
# Find the native SMARTCARDPP includes and library
#
#  SMARTCARDPP_INCLUDE_DIR - where to find smartcardpp.h, etc.
#  SMARTCARDPP_LIBRARIES   - List of libraries when using smartcardpp.
#  SMARTCARDPP_FOUND       - True if smartcardpp found.


IF (SMARTCARDPP_INCLUDE_DIR)
  # Already in cache, be silent
  SET(SMARTCARDPP_FIND_QUIETLY TRUE)
ENDIF (SMARTCARDPP_INCLUDE_DIR)

IF (NOT WIN32)
  # try using pkg-config to get the directories and then use these values
  # in the FIND_PATH() and FIND_LIBRARY() calls
  FIND_PACKAGE(PkgConfig)
  PKG_CHECK_MODULES(PC_SMARTCARDPP smartcardpp)
ENDIF (NOT WIN32)

FIND_PATH(SMARTCARDPP_INCLUDE_DIR smartcardpp/smartcardpp.h
  HINTS
  ${PC_SMARTCARDPP_INCLUDEDIR}
  ${PC_SMARTCARDPP_INCLUDE_DIRS}
  )

SET(SMARTCARDPP_NAMES smartcardpp)
FIND_LIBRARY(SMARTCARDPP_LIBRARY NAMES ${SMARTCARDPP_NAMES}
  HINTS
  ${PC_SMARTCARDPP_LIBDIR}
  ${PC_SMARTCARDPP_LIBRARY_DIRS}
  )

# handle the QUIETLY and REQUIRED arguments and set SMARTCARDPP_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(SmartCardpp DEFAULT_MSG SMARTCARDPP_LIBRARY SMARTCARDPP_INCLUDE_DIR)

IF(SMARTCARDPP_FOUND)
  SET( SMARTCARDPP_INCLUDE_DIRS ${SMARTCARDPP_INCLUDE_DIR} ${PC_SMARTCARDPP_INCLUDE_DIRS})
  SET( SMARTCARDPP_LIBRARIES ${SMARTCARDPP_LIBRARY} )
ELSE(SMARTCARDPP_FOUND)
  SET( SMARTCARDPP_INCLUDE_DIRS )
  SET( SMARTCARDPP_LIBRARIES )
ENDIF(SMARTCARDPP_FOUND)

MARK_AS_ADVANCED( SMARTCARDPP_LIBRARY SMARTCARDPP_INCLUDE_DIR )
