/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.FlatHashIterator;
import cds.healpix.ListOfHash;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class FlatHashList
implements ListOfHash {
    final int depth;
    final long[] hList;
    int size = 0;

    public FlatHashList(int depth, int capacity) {
        this.depth = depth;
        this.hList = new long[capacity];
    }

    public int capacity() {
        return this.hList.length;
    }

    public void clear() {
        this.size = 0;
    }

    public FlatHashList put(long hash) {
        this.hList[this.size++] = hash;
        return this;
    }

    public FlatHashList put(ListOfHash hashes) {
        hashes.arraycopy(0, this.hList, this.size, hashes.size());
        this.size += hashes.size();
        return this;
    }

    public void sortByHashAsc() {
        Arrays.sort(this.hList, 0, this.size);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long get(int i) {
        if (i >= this.size) {
            throw new IndexOutOfBoundsException("i: " + i + " ; size: " + this.size);
        }
        return this.hList[i];
    }

    @Override
    public void arraycopy(int srcPos, long[] dest, int destPos, int length) {
        if (srcPos + length > this.size) {
            throw new IndexOutOfBoundsException("srcPos + length > source size");
        }
        System.arraycopy(this.hList, srcPos, dest, destPos, length);
    }

    @Override
    public FlatHashIterator iterator() {
        return new FlatHashIterator(){
            private int i = 0;

            @Override
            public int depth() {
                return FlatHashList.this.depth;
            }

            @Override
            public boolean hasNext() {
                return this.i < FlatHashList.this.size;
            }

            @Override
            public long next() {
                if (this.i >= FlatHashList.this.size) {
                    throw new NoSuchElementException();
                }
                return FlatHashList.this.hList[this.i++];
            }
        };
    }

    public String toString() {
        return Arrays.toString(Arrays.copyOf(this.hList, this.size));
    }
}

