/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.htm.client;

import edu.jhu.htm.core.Convex;
import edu.jhu.htm.core.HTMindexImp;
import edu.jhu.htm.core.HTMrange;
import edu.jhu.htm.core.HTMrangeIterator;
import edu.jhu.htm.core.Vector3d;
import java.io.Writer;

public class IntersectBean {
    protected double[] RAs;
    protected double[] Decs;
    protected Vector3d[] vecs = null;
    protected int level;
    protected int olevel;
    protected String htmId;
    protected long htmIdNumber;
    protected HTMrange range = new HTMrange();
    protected boolean symbolic = true;
    protected boolean expand;

    public void setExpand(String string) {
        this.expand = string.startsWith("t") || string.startsWith("T");
    }

    public void setExpand(boolean bl) {
        this.expand = bl;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public void setHtmId(String string) {
        this.htmId = string;
    }

    public void setRAs(double[] dArray) {
        this.RAs = dArray;
    }

    public void setDecs(double[] dArray) {
        this.Decs = dArray;
    }

    public void setRAs(String[] stringArray) {
        this.RAs = stringArray[3].length() > 0 ? new double[stringArray.length] : new double[3];
        IntersectBean.convertDouble(stringArray, this.RAs);
    }

    public void setDecs(String[] stringArray) {
        this.Decs = stringArray[3].length() > 0 ? new double[stringArray.length] : new double[3];
        IntersectBean.convertDouble(stringArray, this.Decs);
    }

    public void setLevel(int n) {
        this.level = n;
        this.olevel = n;
    }

    public double[] getRAs() {
        return this.RAs;
    }

    public double[] getDecs() {
        return this.Decs;
    }

    public long getLevel() {
        return this.level;
    }

    public void computeIntersect() {
        this.fillVecs();
        HTMindexImp hTMindexImp = new HTMindexImp(this.level, 3);
        Convex convex = null;
        convex = this.vecs.length == 3 ? new Convex(this.vecs[0], this.vecs[1], this.vecs[2]) : new Convex(this.vecs[0], this.vecs[1], this.vecs[2], this.vecs[3]);
        this.range.purge();
        convex.setOlevel(this.olevel);
        convex.intersect(hTMindexImp, this.range, false);
    }

    public void outputHtms(Writer writer) {
        try {
            if (this.expand) {
                HTMrangeIterator hTMrangeIterator = new HTMrangeIterator(this.range, this.symbolic);
                while (hTMrangeIterator.hasNext()) {
                    writer.write(hTMrangeIterator.next().toString());
                    writer.write(10);
                    writer.flush();
                }
            } else {
                writer.write(this.range.toString(this.symbolic));
                writer.write(10);
                writer.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static final void convertDouble(String[] stringArray, double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = Double.parseDouble(stringArray[n].trim());
            ++n;
        }
    }

    protected void fillVecs() {
        this.vecs = new Vector3d[this.RAs.length];
        int n = 0;
        while (n < this.RAs.length) {
            this.vecs[n] = new Vector3d(this.RAs[n], this.Decs[n]);
            ++n;
        }
    }
}

