## Purpose

A primary goal of our community, our user groups and mailing lists, symposia and other events is to be inclusive to the largest number of contributors, with the most varied and diverse backgrounds possible. As such, we are committed to providing a friendly, safe and welcoming environment for all.

This Code of Conduct outlines our expectations for all those who participate in our community, as well as the consequences for unacceptable behavior.

We invite all those who participate in our community to help us create safe and positive experiences for everyone.

## Diversity Statement

We encourage everyone to participate and are committed to building a community for all. Although we will fail at times, we seek to treat everyone both as fairly and equally as possible. Whenever a participant has made a mistake, we expect them to take responsibility for it. If someone has been harmed or offended, it is our responsibility to listen carefully and respectfully, and do our best to right the wrong.

Although this list cannot be exhaustive, we explicitly honor diversity in age, gender, gender identity or expression, culture, ethnicity, language, national origin, political beliefs, profession, race, colour, immigration status, education level, size, family status, religion, sexual orientation, class, socioeconomic status, and technical ability. We will not tolerate discrimination based on any of the protected characteristics above, including discrimination against participants with disabilities.

We are aware that the definitions and examples for diversity and discrimination have a strong cultural bias and are likely to change over time. They mirror the sensitivities of the SuperCollider community at the time of writing. We welcome suggestions as to how to extend our understanding of discrimination and exclusivism.

## Open [Source/Culture/Tech] Citizenship

A supplemental goal of this Code of Conduct is to increase free and open [source/culture/tech] citizenship by encouraging participants to recognize and strengthen the relationships between our actions and their effects on our community.

Communities mirror the societies in which they exist and positive action is essential to counteract the many forms of inequality and abuses of power that exist in society.

If you see someone who is making an extra effort to ensure our community is welcoming and friendly, and encourages all participants to contribute to the fullest extent, we want to know.

### The SuperCollider community strives to be:

* Friendly and patient.
* Welcoming: We strive to be a community that welcomes and supports people of all backgrounds and identities.
* Considerate: Your work will be used by other people, and you in turn will depend on the work of others. Any decision you take will affect users and colleagues, and you should take those consequences into account when making decisions. Remember that we’re a world-wide community, so you might not be communicating in someone else’s primary language.
* Respectful: Not all of us will agree all the time, but disagreement is no excuse for poor behavior and poor manners. We might all experience some frustration now and then, but we cannot allow that frustration to turn into a personal attack. It’s important to remember that a community where people feel uncomfortable or threatened is not a productive one.
* Understanding of differences of opinion: Disagreements, both social and technical, happen all the time. It is important that we resolve disagreements and differing views constructively. Remember that we’re different. The strength of our community comes from its diversity. Different people have different perspectives on issues. Being unable to understand why someone holds a viewpoint doesn’t mean that they’re wrong. Don’t forget that it is human to err and blaming each other doesn’t get us anywhere. Instead, focus on helping to resolve issues and learning from mistakes.

## Expected Behavior

* Participate in an authentic and active way. In doing so, you contribute to the health and longevity of this community.
* Exercise consideration and respect in your speech and actions.
* Attempt collaboration before conflict.
* Refrain from demeaning, discriminatory, or harassing behavior and speech.
* Be mindful of your surroundings and of your fellow participants. Alert community leaders if you notice a dangerous situation, someone in distress, or violations of this Code of Conduct, even if they seem inconsequential.

### Self-Promotion

* You are invited to use the SuperCollider mailing lists and forums to share your own projects and events, commercial or noncommercial, that directly involve SuperCollider. Posting your artistic projects is specifically encouraged.
* You may also share news of projects and events that are only topically related to SuperCollider, provided that they are noncommercial.
* Avoid using the community as a platform to advertise commercial products that lack direct connections to the software.
* Self-promotion postings should be in courteous volumes and preferably include good descriptions.

## Unacceptable Behavior

Unacceptable behaviors include: intimidating, harassing, abusive, culturally appropriative, discriminatory, derogatory or demeaning speech or actions by any participant in our community online, at all related events and in one-on-one communications carried out in the context of community business. Community event venues may be shared with members of the public; please be respectful to all patrons of these locations.

Harassment includes, but is not limited to:

* Harmful or prejudicial verbal or written comments related to gender, gender identity and expression, sexual orientation, disability, mental illness, neuro(a)typicality, physical appearance, body size, race, ethnicity, age, regional discrimination, political or religious affiliation
* Unwelcome comments regarding a person’s lifestyle choices and practices, including those related to food, health, parenting, drugs, and employment
* Deliberate misgendering. This includes deadnaming or persistently using a pronoun that does not correctly reflect a person’s gender identity. You must address people by the name they give you when not addressing them by their username or handle
* Physical contact and simulated physical contact (eg, textual descriptions like “backrub”) without consent or after a request to stop
* Inappropriate depictions of violence (including presentation slides)
* Threats of violence, both physical and psychological
* Incitement of violence towards any individual, including encouraging a person to commit suicide or to engage in self-harm
* Deliberate intimidation
* Stalking or following
* Harassing photography or recording, including logging online activity for harassment purposes
* Sustained disruption of discussion
* Unwelcome sexual attention, including gratuitous or off-topic sexual images or behaviour
* Pattern of inappropriate social contact, such as requesting/assuming inappropriate levels of intimacy with others
* Continued one-on-one communication after requests to cease
* Deliberate “outing” of any aspect of a person’s identity without their consent except as necessary to protect others from intentional abuse
* Publication of non-harassing private communication

The SuperCollider community prioritizes marginalized people’s safety over privileged people’s comfort. We will not act on complaints regarding:
* ‘Reverse’ -isms, including ‘reverse racism,’ ‘reverse sexism,’ and ‘cisphobia’
* Reasonable communication of boundaries, such as “leave me alone,” “go away,” or “I’m not discussing this with you”
* Refusal to explain or debate social justice concepts
* Criticizing racist, sexist, cissexist, or otherwise oppressive behavior or assumptions

## Consequences of Unacceptable Behavior

Unacceptable behavior from any community member, including sponsors and those with decision-making authority, will not be tolerated. Anyone asked to stop unacceptable behavior is expected to comply immediately.

If a community member engages in unacceptable behavior, the community organizers may take any action they deem appropriate, up to and including a temporary ban or permanent expulsion from the community without warning (and without refund in the case of a paid event).

## If You Witness or Are Subject to Unacceptable Behavior

If you are subject to or witness unacceptable behavior, or have any other concerns, please notify a community organizer as soon as possible. Additionally, community organizers are available to help community members engage with local law enforcement or to otherwise help those experiencing unacceptable behavior feel safe. In the context of in-person events, organizers will also provide escorts as desired by the person experiencing distress.

## Addressing Grievances

If you feel you have been falsely or unfairly accused of violating this Code of Conduct, you should notify one of the event or community organizers with a concise description of your grievance. Your grievance will be handled in accordance with our existing governing policies.

## Scope

We expect all community participants (contributors, paid or otherwise; sponsors; and other guests) to abide by this Code of Conduct in all community venues—online and in-person—as well as in all one-on-one communications pertaining to community business.

## License and attribution

The SuperCollider Code of Conduct is distributed under a [Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)](https://creativecommons.org/licenses/by-sa/4.0/) license. It is based on the [Berlin Code of Conduct](http://berlincodeofconduct.org/), the [Open Code of Conduct](https://github.com/todogroup/opencodeofconduct), and the [Geek Feminism Code of Conduct](http://geekfeminism.org/about/code-of-conduct/).
