CHANGELOG for 5.1.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 5.1 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v5.1.0...v5.1.1

* 5.1.10 (2020-12-18)

 * bug #39545 [Notifier] [Mattermost] Host is required (OskarStark)
 * bug #39538 [Notifier] Fix parsing Dsn with empty user/password (OskarStark)
 * bug #39531 [Mailer] Fix parsing Dsn with empty user/password (OskarStark)
 * bug #39518 [Ldap] Incorrect determination of RelativeDistinguishedName for the "move" operation (astepin)
 * bug #39510 [Notifier]  [Free Mobile] Could not use custom host in DSN (OskarStark)
 * bug #39514 [Notifier] Fix wrong package names (OskarStark)
 * bug #39494 Add missing symfony/deprecation-contracts requirement (jderusse)
 * bug #39476 [Lock] Prevent store exception break combined store (dzubchik)
 * bug #39456 [Notifier] [Free Mobile] Fix wrong scheme in mapping (OskarStark)
 * bug #39299 [PropertyInfo][Serializer] Fixed extracting ignored properties for Serializer (javer)
 * bug #39433 [Cache] fix setting "read_timeout" when using Redis (nicolas-grekas)
 * bug #39420 [Cache] Prevent notice on case matching metadata trick (bastnic)
 * bug #39203 [DI] Fix not working if only "default_index_method" used (malteschlueter)
 * bug #39409 [Notifier] [Twilio] Add tests (OskarStark)
 * bug #39142 [Config] Stop treating multiline resources as globs (michaelKaefer)
 * bug #39341 [Form] Fixed StringUtil::trim() to trim ZERO WIDTH SPACE (U+200B) and SOFT HYPHEN (U+00AD) (pmishev)
 * bug #39334 [Config][TwigBundle] Fixed syntax error in config (Nyholm)
 * bug #39196 [DI] Fix Xdebug 3.0 detection (vertexvaar)
 * bug #39226 [PhpUnitBridge] Fix disabling DeprecationErrorHandler from PHPUnit configuration file (fancyweb)
 * bug #39361 [FrameworkBundle] acces public-deprecated services via the private container to remove false-positive deprecations (nicolas-grekas)
 * bug #39357 [FrameworkBundle] fix preserving some special chars in the query string (nicolas-grekas)
 * bug #39271 [HttpFoundation] Fix TypeError: Argument 1 passed to JsonResponse::setJson() must be of the type string, object given (sidz)
 * bug #39251 [DependencyInjection] Fix container linter for union types (derrabus)
 * bug #39336 [Config] YamlReferenceDumper: No default value required for VariableNode with array example (Nyholm)
 * bug #39333 [Form] do not apply the Valid constraint on scalar form data (lchrusciel, xabbuh)
 * bug #39331 [PhpUnitBridge] Fixed PHPunit 9.5 compatibility (wouterj)
 * bug #39220 [HttpKernel] Fix bug with whitespace in Kernel::stripComments() (ausi)
 * bug #39252 [Mime] Leverage PHP 8's detection of CSV files (derrabus)
 * bug #39313 [FrameworkBundle] TextDescriptor::formatControllerLink checked method… (fjogeleit)
 * bug #39286 [HttpClient] throw clearer error when no scheme is provided (BackEndTea)
 * bug #39267 [Yaml] fix lexing backslashes in single quoted strings (xabbuh)
 * bug #39151 [DependencyInjection] Fixed incorrect report for private services if required service does not exist (Islam93)
 * bug #39274 [Yaml] fix lexing mapping values with trailing whitespaces (xabbuh)
 * bug #39244 [String] Fix Notice when argument is empty string (moldman)
 * bug #39270 [Inflector] Fix Notice when argument is empty string (moldman)
 * bug #39247 [Security] remove return type definition in order to avoid type juggling (adeptofvoltron)
 * bug #39223 [Console] Re-enable hyperlinks in Konsole/Yakuake (OndraM)
 * bug #39241 [Yaml] fix lexing inline sequences/mappings with trailing whitespaces (Nyholm, xabbuh)
 * bug #39243 [Filesystem] File existence check before calling unlink method (gechetspr)

* 5.1.9 (2020-11-29)

 * bug #39166 [Messenger] Fix mssql compatibility for doctrine transport. (bill moll)
 * bug #39211 [HttpClient] fix binding to network interfaces (nicolas-grekas)
 * bug #39129 [DependencyInjection] Fix circular in DI with lazy + byContruct loop (jderusse)
 * bug #39068 [DependencyInjection][Translator] Silent deprecation triggered by libxml_disable_entity_loader (jderusse)
 * bug #39119 [Form] prevent duplicated error message for file upload limits (xabbuh)
 * bug #39099 [Form] ignore the pattern attribute for textareas (xabbuh)
 * bug #39154 [Yaml] fix lexing strings containing escaped quotation characters (xabbuh)
 * bug #39180 [Serializer] Fix denormalizing scalar with UnwrappingDenormalizer (camilledejoye)
 * bug #38597 [PhpUnitBridge] Fix qualification of deprecations triggered by the debug class loader (fancyweb)
 * bug #39160 [Console] Use a partial buffer in SymfonyStyle (jderusse)
 * bug #39168 [Console] Fix console closing tag (jderusse)
 * bug #39155 [VarDumper] fix casting resources turned into objects on PHP 8 (nicolas-grekas)
 * bug #39131 [Cache] Fix CI because of Couchbase version (jderusse)
 * bug #39115 [HttpClient] don't fallback to HTTP/1.1 when HTTP/2 streams break (nicolas-grekas)
 * bug #33763 [Yaml] fix lexing nested sequences/mappings (xabbuh)
 * bug #39083 [Dotenv] Check if method inheritEnvironmentVariables exists (Chi-teck)
 * bug #39094 [Ldap] Fix undefined variable $con (derrabus)
 * bug #39091 [Config] Recheck glob brace support after GlobResource was serialized (wouterj)
 * bug #39092 Fix critical extension when reseting paged control (jderusse)
 * bug #38614 [HttpFoundation] Fix for virtualhosts based on URL path (mvorisek)
 * bug #39072 [FrameworkBundle] [Notifier] fix firebase transport factory DI tag type (xabbuh)
 * bug #38387 [Validator] prevent hash collisions caused by reused object hashes (fancyweb, xabbuh)
 * bug #38999 [DependencyInjection] autoconfigure behavior describing tags on decorators (xabbuh)
 * bug #39058 [DependencyInjection] Fix circular detection with multiple paths (jderusse)
 * bug #39059 [Filesystem] fix cleaning up tmp files when dumpFile() fails (nicolas-grekas)
 * bug #38628 [DoctrineBridge]  indexBy could reference to association columns (juanmiguelbesada)
 * bug #39021  [DependencyInjection] Optimize circular collection by removing flattening (jderusse)
 * bug #39031 [Ldap] Fix pagination (jderusse)
 * bug #39038 [DoctrineBridge]    also reset id readers (xabbuh)
 * bug #39026 [Messenger] Fix DBAL deprecations in PostgreSqlConnection (chalasr)
 * bug #39025 [DoctrineBridge] Fix DBAL deprecations in middlewares (derrabus)
 * bug #38991 [Console] Fix ANSI when stdErr is not a tty (jderusse)
 * bug #38980 [DependencyInjection] Fix circular reference with Factory + Lazy Iterrator (jderusse)
 * bug #38977 [HttpClient] Check status code before decoding content in TraceableResponse (chalasr)
 * bug #38971 [PhpUnitBridge] fix replaying skipped tests (nicolas-grekas)
 * bug #38910 [HttpKernel] Fix session initialized several times (jderusse)
 * bug #38882 [DependencyInjection] Improve performances in CircualReference detection (jderusse)
 * bug #38950 [Process] Dont test TTY if there is no TTY support (Nyholm)
 * bug #38921 [PHPUnitBridge] Fixed crash on Windows with PHP 8 (villfa)
 * bug #38869 [SecurityBundle] inject only compatible token storage implementations for usage tracking (xabbuh)
 * bug #38894 [HttpKernel] Remove Symfony 3 compatibility code (derrabus)
 * bug #38895 [PhpUnitBridge] Fix wrong check for exporter in ConstraintTrait (alcaeus)
 * bug #38879 [Cache] Fixed expiry could be int in ChainAdapter due to race conditions (phamviet)
 * bug #38867 [FrameworkBundle] Fixing TranslationUpdateCommand failure when using "--no-backup" (liarco)
 * bug #38856 [Cache] Add missing use statement (fabpot)

* 5.1.8 (2020-10-28)

 * bug #38713 [DI] Fix Preloader exception when preloading a class with an unknown parent/interface (rgeraads)
 * bug #38647 [HttpClient] relax auth bearer format requirements (xabbuh)
 * bug #38699 [DependencyInjection] Preload classes with union types correctly (derrabus)
 * bug #38669 [Serializer] fix decoding float XML attributes starting with 0 (Marcin Kruk)
 * bug #38680 [PhpUnitBridge] Support new expect methods in test case polyfill (alcaeus)
 * bug #38681 [PHPUnitBridge] Support PHPUnit 8 and PHPUnit 9 in constraint compatibility trait (alcaeus)
 * bug #38686 [TwigBridge] Remove "transchoice" from the code base (nicolas-grekas)
 * bug #38678 [String] fix before/after[Last]() returning the empty string instead of the original one on non-match (nicolas-grekas)
 * bug #38679 [PhpUnitBridge] Add missing exporter function for PHPUnit 7 (alcaeus)
 * bug #38659 [String] fix slicing in UnicodeString (nicolas-grekas)
 * bug #38595 [TwigBridge] do not translate null placeholders or titles (xabbuh)
 * bug #38635 [Cache] Use correct expiry in ChainAdapter (Nyholm)
 * bug #38652 [Filesystem] Check if failed unlink was caused by permission denied (Nyholm)
 * bug #38645 [PropertyAccess] forward the caught exception (xabbuh)
 * bug #38612 [Messenger/Amqp] Allow setting option "login" in DSN (W0rma)
 * bug #38618 [Messenger][Doctrine] Avoid early db access for pgsql detection (chalasr)
 * bug #38604 [DoctrineBridge] indexBy does not refer to attributes, but to column names (xabbuh)
 * bug #38606 [WebProfilerBundle] Hide debug toolbar in print view (jt2k)
 * bug #38582 [DI] Fix Reflection file name with eval()\'d code (maxime-aknin)
 * bug #38578 Add missing use statement (jderusse)
 * bug #38516 [HttpFoundation] Fix Range Requests (BattleRattle)
 * bug #38553 [Lock] Reset Key lifetime time before we acquire it (Nyholm)
 * bug #38551 Remove content-type check on toArray methods (jderusse)
 * bug #38546 [String] fix "is too large" ValueError on PHP 8 (nicolas-grekas)
 * bug #38544 [DI] fix dumping env vars (nicolas-grekas)
 * bug #38533 [TwigBridge] Fix preload hint and remove "unlinked class class@anonymous" warning (burned42)
 * bug #38530 [HttpClient] fix reading the body after a ClientException (nicolas-grekas)
 * bug #38510 [PropertyInfo] Support for the mixed type (derrabus)
 * bug #38493 [HttpClient] Fix CurlHttpClient memory leak (HypeMC)
 * bug #38456 [Cache] skip igbinary < 3.1.6 (nicolas-grekas)
 * bug #38392 [Ldap] Bypass the use of `ldap_control_paged_result` on PHP >= 7.3 (lucasaba)
 * bug #38444 [PhpUnitBridge] fix running parallel tests with phpunit 9 (nicolas-grekas)
 * bug #38446 [PropertyInfo] Extract from default value doesn't set collection boolean (Korbeil)
 * bug #38442 [VarDumper] fix truncating big arrays (nicolas-grekas)
 * bug #38433 [Mime] Fix serialization of RawMessage (gilbertsoft)

* 5.1.7 (2020-10-04)

 * bug #38396 Handle consecutive supports() calls in the RememberMeAuthenticator (wouterj)
 * bug #36291 [Lock] Fix StoreFactory to accept same DSN syntax as AbstractAdapter (Jontsa)
 * bug #38390 [Serializer][Minor] Fix circular reference exception message (bad limit displayed) (l-vo)
 * bug #38388 [HttpClient] Always "buffer" empty responses (nicolas-grekas)
 * bug #38384 [PhpUnitBridge] Fix Deprecation file when it comes from the TestsListener (fancyweb)
 * bug #38380 [Form] propagate validation groups to subforms (johanderuijter, xabbuh)
 * bug #38377  Ignore more deprecations for Mockery mocks (fancyweb)
 * bug #38375 [HttpClient] fix using proxies with NativeHttpClient (nicolas-grekas)
 * bug #38372 [Routing] fix using !important and defaults/reqs in inline route definitions (nicolas-grekas)
 * bug #38373 [ErrorHandler][DebugClassLoader] Do not check Mockery mocks classes (fancyweb)
 * bug #38368 [HttpClient] Fix using https with proxies (bohanyang)
 * bug #38350 [TwigBundle] Only remove kernel exception listener if twig is used (dmolineus)
 * bug #38360 [BrowserKit] Cookie expiration at current timestamp (iquito)
 * bug #38357 [DI] fix dumping non-shared lazy services (nicolas-grekas)
 * bug #38358 [Messenger] Fix redis connection error message (alexander-schranz)
 * bug #38343 Revert "bug #38063 [FrameworkBundle] generate preload.php in src/ to make opcache.preload predictable" (nicolas-grekas)
 * bug #38348 [FrameworkBundle] Add Mailjet definition (michaelKaefer)
 * bug #38336 [PhpUnitBridge] Fixed class_alias() for PHPUnit\Framework\Error\Error (stevegrunwell)

* 5.1.6 (2020-09-27)

 * bug #38291 [OptionsResolver] Fix deprecation message access (fancyweb)
 * bug #38248 [HttpClient] Allow bearer token with colon (stephanvierkant)
 * bug #37837 [Form] Fix custom formats deprecation with HTML5 widgets (fancyweb)
 * bug #38285 [Contracts][Translation] Optional Intl dependency (ro0NL)
 * bug #38283 [Translator] Optional Intl dependency (ro0NL)
 * bug #38271 [ErrorHandler] Escape JSON encoded log context (ro0NL)
 * bug #38284 [Cache][Lock][Messenger] fix compatibility with Doctrine DBAL 3 (xabbuh)
 * bug #38228 [Yaml Parser] Fix edge cases when parsing multiple documents (digilist)
 * bug #38226 [FrameworkBundle] loadRoutes shoud receive RoutingPhpFileLoader (grachevko)
 * bug #38229 [Yaml] fix parsing comments not prefixed by a space (xabbuh)
 * bug #38127 [Translator] Make sure a null locale is handled properly (jschaedl)
 * bug #38221 [Cache] Allow cache tags to be objects implementing __toString() (lstrojny)
 * bug #38212 [HttpKernel] Do not override max_redirects option in HttpClientKernel (dmolineus)
 * bug #38215 [HttpClient] Support for CURLOPT_LOCALPORT (derrabus)
 * bug #38202 [FrameworkBundle] Fix xsd definition which prevent to add more than one workflow metadata (l-vo)
 * bug #38195 [String] improve slugger's portability accross implementations of iconv() (nicolas-grekas)
 * bug #38166 [Console] work around disabled putenv() (SenTisso)
 * bug #38190 [Notifier] Fix errors parsing in FirebaseTransport (jderusse)
 * bug #38173 [HttpClient][HttpClientTrait] don't calculate alternatives if option is auth_ntlm (ybenhssaien)
 * bug #38169 [PhpUnitBridge] Internal classes are not legacy (derrabus)
 * feature #38160 [Security] In the new authenticator system, no auth listener is valid (weaverryan)
 * bug #38156 [Cache] fix ProxyAdapter not persisting items with infinite expiration (dmaicher)
 * bug #38148 [HttpClient] fail properly when the server replies with HTTP/0.9 (nicolas-grekas)
 * bug #38131 [Validator] allow consumers to mock all methods (xabbuh)
 * bug #38140 [DI] dump OS-indepent paths in the preload file (nicolas-grekas)
 * bug #38139 [DI] dump OS-indepent paths in the compiled container (nicolas-grekas)
 * bug #38147 [Mailer] Fixed Mailgun API bridge JsonException when API response is not applicaton/json (asprega)
 * bug #38126 [Cache] Limit cache version character range (lstrojny)
 * bug #38136 [Messenger] Run postgres setup trigger in transaction (akondas)
 * bug #38142 [FrameworkBundle] adopt src/.preload.php (nicolas-grekas)
 * bug #38108 [Cache] Fix key encoding issue in Memcached adapter (lstrojny)
 * bug #38122 [HttpClient] Fix Array to string conversion notice when parsing JSON error body with non-scalar detail property (emarref)
 * bug #37097 DateTime validator support for trailing data (stefankleff)
 * bug #38116 [Console] Silence warnings on sapi_windows_cp_set() call (chalasr)
 * bug #38114 [Console] guard $argv + $token against null, preventing unnecessary exceptions (bilogic)
 * bug #38094 [PhpUnitBridge] Skip internal classes in CoverageListenerTrait (sanmai)
 * bug #38101 [VarExporter] unserialize() might throw an Exception on php 8 (derrabus)
 * bug #38100 [ErrorHandler] Parse "x not found" errors correctly on php 8 (derrabus)
 * bug #38099 Prevent parsing invalid octal digits as octal numbers (julienfalque)
 * bug #38095 [Mailer] Remove unnecessary check for  existing request (jschaedl)
 * bug #38091 [DI] fix ContainerBuilder on PHP8 (nicolas-grekas)
 * bug #38086 [HttpClient] with "bindto" with NativeHttpClient (nicolas-grekas)
 * bug #38063 [FrameworkBundle] generate preload.php in src/ to make opcache.preload predictable (nicolas-grekas)
 * bug #38080 [Console] Make sure $maxAttempts is an int or null (derrabus)
 * bug #38075 esmtp error not being thrown properly (Anton Zagorskii)
 * bug #38040 [Yaml Parser] fixed Parser to skip comments when inlining sequences (korve)
 * bug #38073 [VarDumper] Fix caster for invalid SplFileInfo objects on php 8 (derrabus)
 * bug #38074 [Messenger] Remove DelaySeconds parameter for FIFO queues (netbull)
 * bug #38071 [PhpUnitBridge] Adjust output parsing of CoverageListenerTrait for PHPUnit 9.3 (sanmai, derrabus)
 * bug #38062 [DI] fix generating preload file when cache_dir is outside project_dir (nicolas-grekas)
 * bug #38059 [Cache] Fix CacheCollectorPass with decorated cache pools (shyim)
 * bug #38054 [PhpUnitBridge] CoverageListenerTrait update for PHPUnit 8.5/9.x (sanmai)
 * bug #38049 [Debug] Parse "x not found" errors correctly on php 8 (derrabus)
 * bug #38041 [PropertyInfo] Fix typed collections in PHP 7.4 (ndench)
 * bug #38013 [PHPUnitBridge] Fix deprecation type detection when trigger_deprecation is used (l-vo)
 * bug #37959 [PhpunitBridge] Fix deprecation type detection (when several autoload files are used) (l-vo)
 * bug #38031 Allow Drupal to wrap the Symfony test listener (5.1 backport) (fabpot, alexpott)

* 5.1.5 (2020-09-02)

 * security #cve-2020-15094 Remove headers with internal meaning from HttpClient responses (mpdude)
 * bug #38024 [Console] Fix undefined index for inconsistent command name definition (chalasr)
 * bug #38023 [DI] fix inlining of non-shared services (nicolas-grekas)
 * bug #38022 Missed AbstractArgument (a-menshchikov)
 * bug #38020 [PhpUnitBridge] swallow deprecations (xabbuh)
 * bug #37961 [Mailer] Fixed 'verify_peer' option in mailer DSN being ignored (SnakePin)
 * bug #38010 [Cache] Psr16Cache does not handle Proxy cache items (alex-dev)
 * bug #37937 [Serializer] fixed fix encoding of cache keys with anonymous classes (michaelzangerle)
 * bug #38002 [Validator] Fix PhpUnitBridge version constraint (derrabus)
 * bug #38001 Fix symfony/amazon-mailer constraint (Michał Jusięga)

* 5.1.4 (2020-08-31)

 * bug #37966 [HttpClient][MockHttpClient][DX] Throw when the response factory callable does not return a valid response (fancyweb)
 * bug #37971 [PropertyInfo] Backport support for typed properties (PHP 7.4) (dunglas)
 * bug #37970 [PhpUnitBridge] Polyfill new phpunit 9.1 assertions (phpfour)
 * bug #37960 [PhpUnit] Add polyfill for assertMatchesRegularExpression() (dunglas)
 * bug #37941 [TwigBridge] allow null for $message of filter method `trans` (Flinsch)
 * bug #37622 [PropertyAccess] Fix accessing dynamic properties (andreyserdjuk)
 * bug #37927 [HttpClient] fix chaining promises returned by HttplugClient (CthulhuDen)
 * bug #37953 [DI] fix dumping lazy non-shared services (nicolas-grekas)
 * bug #37949 [Yaml] fix more numeric cases changing in PHP 8 (xabbuh)
 * bug #37943 [Security] Fixed RememberMeAuthenticator::autoLogin() logic in the authenticator (wouterj)
 * bug #37921 [Yaml] account for is_numeric() behavior changes in PHP 8 (xabbuh)
 * bug #37913 [Mailer] Support Return-Path in SesApiAsyncAwsTransport (cvmiert)
 * bug #37912 [ExpressionLanguage] fix passing arguments to call_user_func_array() on PHP 8 (xabbuh)
 * bug #37907 [Messenger] stop using the deprecated schema synchronizer API (xabbuh)
 * bug #37899 [Mailer] Support reply-to in SesApiAsyncAwsTransport (cvmiert)
 * bug #37900 [Mailer] Fixed mandrill api header structure (wulff)
 * bug #37890 [Notifier] Fixed base_uri while call auth/time API (leblanc-simon)
 * bug #37888 [Mailer] Reorder headers used to determine Sender (cvmiert)
 * bug #37857 [PropertyInfo] Fix ReflectionExtractor + minor tweaks (ogizanagi)
 * bug #37868 [Lock] MongoDbStore handle duplicate querystring keys in mongodb uri when stripping (kralos)
 * bug #37872 [Sendgrid-Mailer] Fixed envelope recipients on sendgridApiTransport (arendjantetteroo)
 * bug #37860 [Serializer][ClassDiscriminatorMapping] Fix getMappedObjectType() when a discriminator child extends another one (fancyweb)
 * bug #37826 [Messenger] Fix BC layer for stamps moved into separate packages (ogizanagi)
 * bug #37853 [Validator] ensure that the validator is a mock object for backwards-compatibility (xabbuh)
 * bug #36340 [Serializer] Fix configuration of the cache key (dunglas)
 * bug #36810 [Messenger] Do not stack retry stamp (jderusse)
 * bug #37849 [FrameworkBundle] Add missing mailer transports in xsd (l-vo)
 * bug #37218 [Lock] MongoDbStore skim non-standard options from uri (kralos)
 * bug #37586 [ErrorHandler][DebugClassLoader] Add mixed and static return types support (fancyweb)
 * bug #37845 [Serializer] Fix variadic support when using type hints (fabpot)
 * bug #37841 [VarDumper] Backport handler lock when using VAR_DUMPER_FORMAT (ogizanagi)
 * bug #37821 Postpone Range BC layer removal to 6.0. (l-vo)
 * bug #37725 [Form] Fix Guess phpdoc return type (franmomu)
 * bug #37771 Use PHPUnit 9.3 on php 8 (derrabus)
 * bug #36140 [Validator] Add BC layer for notInRangeMessage when min and max are set (l-vo)
 * bug #35843 [Validator] Add target guards for Composite nested constraints (ogizanagi)
 * bug #37803 Fix for issue #37681 (Rav)
 * bug #37744 [Yaml] Fix for #36624; Allow PHP constant as first key in block (jnye)
 * bug #37767 [Form] fix mapping errors from unmapped forms (xabbuh)
 * bug #37731 [Console] Table: support cells with newlines after a cell with colspan >= 2 (GMTA)
 * bug #37791 Fix redis connect with empty password (alexander-schranz)
 * bug #37790 Fix deprecated libxml_disable_entity_loader (fabpot)
 * bug #37763 Fix deprecated libxml_disable_entity_loader (jderusse)
 * bug #37774 [Console] Make sure we pass a numeric array of arguments to call_user_func_array() (derrabus)
 * bug #37770 [String] We cannot have a "provides" function in test cases (derrabus)
 * bug #37729 [FrameworkBundle] fail properly when the required service is not defined (xabbuh)
 * bug #37701 [Serializer] Fix that it will never reach DOMNode (TNAJanssen)
 * bug #37671 [Cache] fix saving no-expiry items with ArrayAdapter (philipp-kolesnikov)
 * bug #37102 [WebProfilerBundle] Fix error with custom function and web profiler routing tab (JakeFr)
 * bug #37560 [Finder] Fix GitIgnore parser when dealing with (sub)directories and take order of lines into account (Jeroeny)
 * bug #37700 [VarDumper] Improve previous fix on light array coloration (l-vo)
 * bug #37654 [Messenger] Fix invalid option sslmode in AmazonSqs bridge (jderusse)
 * bug #37705 [Mailer] Added the missing reset tag to mailer.logger_message_listener (vudaltsov)
 * bug #37697 [Messenger] reduce column length for MySQL 5.6 compatibility (xabbuh)
 * bug #37690 HttpClient profiler error (noniagriconomie)

* 5.1.3 (2020-07-24)

 * bug #37590 Allows RedisClusterProxy instance in Lock RedisStore (jderusse)
 * bug #37583 [Mime] Fix EmailHeaderSame to make use of decoded value (evertharmeling)
 * bug #37569 [Messenger] Allow same middleware to be used multiple times with different arguments (HypeMC)
 * bug #37624 [Cache] Connect to RedisCluster with password auth (mforbak)
 * bug #37635 [Cache] fix catching auth errors (nicolas-grekas)
 * bug #37628 [Serializer] Support multiple levels of discriminator mapping (jeroennoten)
 * bug #37629 [Messenger] fix ignored account & endpoint options amazon sqs connection (surikman)
 * bug #37572 [FrameworkBundle] set default session.handler alias if handler_id is not provided (Youssef BENHSSAIEN)
 * bug #37558 Removed @internal from Composite (vudaltsov)
 * bug #37607 Fix checks for phpunit releases on Composer 2 (colinodell)
 * bug #37611 [Mailer] Fix failover transport (fabpot)
 * bug #37594 Use hexadecimal numerals instead of hexadecimals in strings to repres… (arekzb)
 * bug #37576 [WebProfilerBundle] modified url generation to use absolute urls (smatyas)
 * bug #36888 [Mailer] Fix mandrill raw http request setting from email/name (JohJohan)
 * bug #37527 [Mailer] Fix reply-to functionality in the SendgridApiTransport (jt2k)
 * bug #37581 [Mime] Fix compat with HTTP requests (fabpot)
 * bug #37580 [Mime] Keep Sender full address when used by non-SMTP transports (fabpot)
 * bug #37511 [DependencyInjection][Config] Use several placeholder unique prefixes for dynamic placeholder values (fancyweb)
 * bug #37562 [Cache] Use the default expiry when saving (not when creating) items (philipp-kolesnikov)
 * bug #37563 Fix DBAL deprecation (nicolas-grekas)
 * bug #37521 [Form] Fix ChoiceType translation domain (VincentLanglet)
 * bug #37550 [OptionsResolver] Fix force prepend normalizer (hason)
 * bug #37520 [Form] silently ignore uninitialized properties when mapping data to forms (ph-fritsche)
 * bug #37543 [PhpUnitBridge] consider traits imported in parent classes (xabbuh)
 * bug #37515 [PhpUnitBridge] Fix expectDeprecation() in isolation (alexpott)
 * bug #37526 [Cache][Config] ensure compatibility with PHP 8 stack traces (xabbuh)
 * bug #37513 [PhpUnitBridge] ExcludeList usage for PHPUnit 9.4 (gennadigennadigennadi)
 * bug #37514 [String] throw when Alpine is used and translit fails (nicolas-grekas)
 * bug #37504 [Security\Http] Skip remember-me logout on empty token (chalasr)
 * bug #37461 [Process] Fix Permission Denied error when writing sf_proc_00 lock files on Windows (JasonStephensTAMU)
 * bug #37505 [Form] fix handling null as empty data (xabbuh)
 * bug #37385 [Console] Fixes question input encoding on Windows (YaFou)
 * bug #37499 [Form] Missing return in loadValuesForChoices method (yceruto)
 * bug #37491 [HttpClient] Fix promise behavior in HttplugClient (brentybh)
 * bug #37469 [Console] always use stty when possible to ask hidden questions (nicolas-grekas)
 * bug #37486 [HttpClient] fix parsing response headers in CurlResponse (nicolas-grekas)
 * bug #37484 [HttpClient][CurlHttpClient] Fix http_version option usage (fancyweb)
 * bug #37447 [Validator] fix validating lazy properties that evaluate to null (xabbuh)
 * bug #37464 [ErrorHandler] fix throwing from __toString() (nicolas-grekas)
 * bug #37449 [Translation] Fix caching of parent locales file in translator (jvasseur)
 * bug #37440 [HttpClient] fix casting TraceableResponse to php streams (nicolas-grekas)
 * bug #37418 [PhpUnitBridge] Fix compatibility with phpunit 9.3 (Gennadi Janzen)
 * bug #37441 [DoctrineBridge] work around Connection::ping() deprecation (nicolas-grekas)
 * bug #37291 [MimeType] Duplicated MimeType due to PHP Bug (juanmrad)
 * bug #37435 [DI] fix minor perf regression when creating non-shared services (nicolas-grekas)
 * bug #37429 [DI] fix parsing of argument type=binary in xml (Tobion)
 * bug #37425 [Form] fix guessing form types for DateTime types (xabbuh)
 * bug #37392 [Validator] fix handling typed properties as constraint options (xabbuh)
 * bug #37325 Fix the supports() method argument type of the security voter (francoispluchino)
 * bug #37358 Directly use the driverConnection executeUpdate method (TristanPouliquen)
 * bug #37389 [HttpFondation] Change file extension of "audio/mpeg" from "mpga" to "mp3" (YaFou)
 * bug #37379 [HttpClient] Support for cURL handler objects (derrabus)
 * bug #37383 [VarDumper] Support for cURL handler objects (derrabus)
 * bug #37395 add .body wrapper element (Nemo64)
 * bug #37400 [HttpClient] unset activity list when creating CurlResponse (nicolas-grekas)
 * bug #37396 [DI] Fix call to sprintf in ServicesConfigurator::stack() (dunglas)
 * bug #37368 [Security] Resolve event bubbling of logout + new events in a compiler pass (wouterj)
 * bug #36304 Check whether path is file in DataPart::fromPath() (freiondrej)
 * bug #37366 [SecurityBundle] Fix UserCheckerListener registration with custom user checker (wouterj)
 * bug #37364 [Messenger] fixed queue_name option on amazon sqs connection (ck-developer)
 * bug #37345 [Form] collect all transformation failures (xabbuh)
 * bug #37362 [SecurityBundle] Drop cache.security_expression_language service if invalid (chalasr)
 * bug #37353 [DI] disable preload.php on the CLI (nicolas-grekas)
 * bug #37268 [Messenger] Fix precedence of DSN options for 4.4 (jderusse)
 * bug #37269 [Lock][Messenger] Fix precedence of DSN options for 5.1 (jderusse)
 * bug #37341  Fix support for PHP8 union types (nicolas-grekas)
 * bug #37271 [FrameworkBundle] preserve dots in query-string when redirecting (nicolas-grekas)
 * bug #37340  Fix support for PHP8 union types (nicolas-grekas)
 * bug #37275 [DI] tighten detection of local dirs to prevent false positives (nicolas-grekas)
 * bug #37090 [PhpUnitBridge] Streamline ansi/no-ansi of composer according to phpunit --colors option (kick-the-bucket)
 * bug #36230 [VarDumper] Fix CliDumper coloration on light arrays (l-vo)
 * bug #37270 [FrameworkBundle] preserve dots in query-string when redirecting (nicolas-grekas)
 * bug #37312 Fix package rename when releasing (94noni)
 * bug #37319 [HttpClient] Convert CurlHttpClient::handlePush() to instance method (mpesari)
 * bug #37342 [Cache] fix compat with DBAL v3 (nicolas-grekas)
 * bug #37327 [HttpFoundation] Allow `null` in InputBag@set (taylorotwell)

* 5.1.2 (2020-06-15)

 * bug #37265 [HttpFoundation] use InputBag for Request::$request only if data is coming from a form (nicolas-grekas)
 * bug #37283 [SecurityBundle] Fix CookieClearingLogoutListener DI configuration (wouterj)
 * bug #37160 Reset question validator attempts only for actual stdin (ostrolucky)
 * bug #36975 [PropertyInfo] Make PhpDocExtractor compatible with phpDocumentor v5 (DerManoMann)
 * bug #37279 [Form] Fixed prototype block prefixes hierarchy of the CollectionType (yceruto)
 * bug #37276 [Form] Fixed block prefixes hierarchy of the CollectionType (yceruto)
 * bug #37261 Fix register csrf protection listener (Ne-Lexa)

* 5.1.1 (2020-06-12)

 * bug #37227 [DependencyInjection][CheckTypeDeclarationsPass] Handle unresolved parameters pointing to environment variables (fancyweb)
 * bug #37103 [Form] switch the context when validating nested forms (xabbuh)
 * bug #37182 [HttpKernel] Fix regression where Store does not return response body correctly (mpdude)
 * bug #37193 [DependencyInjection][CheckTypeDeclarationsPass] Always resolve parameters (fancyweb)
 * bug #37044 [DependencyInjection] Apply ExpressionLanguageProviderPass to router.default (wizhippo)
 * bug #37054 [String] Fix ellipsis of truncate when not using cut option (DuboisS)
 * bug #37190 [HttpClient] disable AMP's inactivity timeout, we deal with it on our own already (nicolas-grekas)
 * bug #37191 [HttpClient] fix offset computation for data chunks (nicolas-grekas)
 * bug #37176 [Routing] Keeping routes priorities after add a name prefix to the collection (yceruto)
 * bug #37140 [Lock] Fixed reading locks from replica set secondary nodes (kralos)
 * bug #37177 [Ldap] fix refreshUser() ignoring extra_fields (arkste)
 * bug #37181 [Mailer] Remove an internal annot (fabpot)
 * bug #36913 [FrameworkBundle] fix type annotation on ControllerTrait::addFlash() (ThomasLandauer)
 * bug #37153 [PhpUnitBridge] Fix ExpectDeprecationTrait::expectDeprecation() conflict (fancyweb)
 * bug #37162 [Mailer] added the reply-to addresses to the API SES transport request. (ribeiropaulor)
 * bug #37144 [DI] Add check around class_alias for generated proxy classes (enumag)
 * bug #37167 [Mime] use fromString when creating a new Address (fabpot)
 * bug #37169 [Cache] fix forward compatibility with Doctrine DBAL 3 (xabbuh)
 * bug #37159 [Mailer] Fixed generator bug when creating multiple transports using Transport::fromDsn (atailouloute)
 * bug #37154 [FrameworkBundle] Remove reference to APP_SECRET in MicroKernelTrait (nicolas-grekas)
 * bug #37126 [SecurityBundle] Fix the session listener registration under the new authentication manager (johnvandeweghe)
 * bug #37130 [Console] allow cursor to be used even when STDIN is not defined (xabbuh)
 * bug #37053 [PropertyAccess] Fix getter call order BC (1ed)
 * bug #37117 [Messenger/DoctrineBridge] set column length for mysql 5.6 compatibility (Nemo64)
 * bug #37127 [Messenger/AmazonSqsBridge] Fixed left-over debug statement (sstok)
 * bug #37048 [HttpClient] fix monitoring timeouts when other streams are active (nicolas-grekas)
 * bug #37085 [Form] properly cascade validation to child forms (xabbuh)
 * bug #37095 [PhpUnitBridge] Fix undefined index when output of "composer show" cannot be parsed (nicolas-grekas)
 * bug #37092 [PhpUnitBridge] fix undefined var on version 3.4 (nicolas-grekas)
 * bug #37022 [DependencyInjection] Improve missing package/version deprecation (acrobat)
 * bug #37038 Fix invalid char in SQS Headers (jderusse)
 * bug #37047 [SecurityBundle] Only register CSRF protection listener if CSRF is available (wouterj)
 * bug #37065 [HttpClient] Throw JsonException instead of TransportException on empty response in Response::toArray() (jeroennoten)
 * bug #37058 [FrameworkBundle] Extension Serializer issue (Korbeil)
 * bug #37077 [WebProfilerBundle] Move ajax clear event listener initialization on loadToolbar (Bruno BOUTAREL)
 * bug #37056 [DoctrineBridge] register event listeners depending on the installed packages (xabbuh)
 * bug #37020 [ExpressionLanguage] reset the internal state when the parser is finished (xabbuh)
 * bug #37049 [Serializer] take into account the context when preserving empty array objects (xabbuh)
 * bug #37031 [Security] Fixed PUBLIC_ACCESS in authenticated sessions (wouterj)
 * bug #37028 [FrameworkBundle] Fix enabled_locales behavior (tgalopin)

* 5.1.0 (2020-05-31)

 * bug #37009 [Validator] use "allowedVariables" to configure the ExpressionLanguageSyntax constraint (xabbuh)
 * bug #37008 [Security] Fixed AbstractToken::hasUserChanged() (wouterj)
 * bug #36894 [Validator] never directly validate Existence (Required/Optional) constraints (xabbuh)
 * bug #37007 [Console] Fix QuestionHelper::disableStty() (chalasr)
 * bug #36865 [Form] validate subforms in all validation groups (xabbuh)
 * bug #36907 Fixes sprintf(): Too few arguments in form transformer (pedrocasado)
 * bug #36868 [Validator] Use Mime component to determine mime type for file validator (pierredup)
 * bug #37000 Add meaningful message when using ProcessHelper and Process is not installed (l-vo)
 * bug #36990 [Messenger] Change the default notify timeout value for PostgreSQL (fabpot)
 * bug #36995 [TwigBridge] fix fallback html-to-txt body converter (nicolas-grekas)
 * bug #36993 [ErrorHandler] fix setting $trace to null in FatalError (nicolas-grekas)
 * bug #36987 Handle fetch mode deprecation of DBAL 2.11. (derrabus)
 * bug #36984 [SecurityBundle] Fixed version constraint on security-core and security-guard (wouterj)
 * bug #36974 [Security] Fixed handling of CSRF logout error (wouterj)

* 5.1.0-RC2 (2020-05-26)

 * bug #36966 Fix extra SQL support in Doctrine migrations (fabpot)
 * bug #36960 [HttpClient] fix management of shorter-than-requested timeouts with AmpHttpClient (nicolas-grekas)
 * bug #36947 [Mime] Allow email message to have "To", "Cc", or "Bcc" header to be valid (Ernest Hymel)
 * bug #36943 [FrameworkBundle] Fix MicroKernelTrait for php 8 (derrabus)
 * bug #36938 Don't call method_exists() with non-objects. (derrabus)
 * bug #36936 [FrameworkBundle] don't use abstract methods in MicroKernelTrait, their semantics changed in PHP 8 (nicolas-grekas)
 * bug #36935 [HttpClient] Adjust AmpResponse to the stricter trait handling in php 8 (derrabus)
 * bug #36914 Parse and render anonymous classes correctly on php 8 (derrabus)
 * bug #36921 [OptionsResolver][Serializer] Remove calls to deprecated ReflectionParameter::getClass() (derrabus)
 * feature #36918 [Security] Removed "services" prototype node from "custom_authenticator" (wouterj)
 * bug #36920 [VarDumper] fix PHP 8 support (nicolas-grekas)
 * bug #36917 [Cache] Accessing undefined constants raises an Error in php8 (derrabus)
 * bug #36891 Address deprecation of ReflectionType::getClass() (derrabus)
 * bug #36899 [VarDumper] ReflectionFunction::isDisabled() is deprecated (derrabus)
 * bug #36905 [Validator] Catch expected ValueError (derrabus)
 * bug #36915 [DomCrawler] Catch expected ValueError (derrabus)
 * bug #36908 [Cache][HttpClient] Made method signatures compatible with their corresponding traits (derrabus)
 * bug #36906 [DomCrawler] Catch expected ValueError (derrabus)
 * bug #36904 [PropertyAccess] Parse php 8 TypeErrors correctly (derrabus)
 * bug #36839 [BrowserKit] Raw body with custom Content-Type header (azhurb)
 * bug #36869 [Form] don't add the inputmode attribute on fields whose type is the same (MatTheCat)
 * feature #36886 [Validator] Make ExpressionLanguageSyntax validator usable with annotation (jderusse)
 * bug #36896 [Config] Removed implicit cast of ReflectionProperty to string (derrabus)
 * bug #35944 [Security/Core] Fix wrong roles comparison (thlbaut)
 * bug #36873 [Messenger] Fixed check for allowed options in AwsSqs configuration (kroshilin)
 * bug #36882 [PhpUnitBridge] fix installing under PHP >= 8 (nicolas-grekas)
 * bug #36859 [Validator] allow passing a validator to Validation::createCallable() (nicolas-grekas)
 * bug #36833 [HttpKernel] Fix that the `Store` would not save responses with the X-Content-Digest header present (mpdude)
 * bug #36867 [PhpUnitBridge] fix bad detection of unsilenced deprecations (nicolas-grekas)
 * bug #36862 [Security] Unserialize $parentData, if needed, to avoid errors (rfaivre)
 * bug #36855 [HttpKernel] Fix error logger when stderr is redirected to /dev/null (fabpot)
 * bug #36838 [HttpKernel] Bring back the debug toolbar (derrabus)

* 5.1.0-RC1 (2020-05-16)

 * bug #36832 [Security] Improved upgrade path for custom remember me services (wouterj)
 * bug #36592 [BrowserKit] Allow Referer set by history to be overridden (Slamdunk)
 * bug #36800 [DI] Renamed some PHP-DSL functions (javiereguiluz)
 * bug #36806 RememberMeLogoutListener should depend on LogoutHandlerInterface (scheb)
 * bug #36805 [Security\Core] Fix NoopAuthenticationManager::authenticate() return value (chalasr)
 * bug #36823 [HttpClient] fix PHP warning + accept status code >= 600 (nicolas-grekas)
 * bug #36824 [Security/Core] fix compat of `NativePasswordEncoder` with pre-PHP74 values of `PASSWORD_*` consts (nicolas-grekas)
 * bug #36811 [DependencyInjection] Fix register event listeners compiler pass (X-Coder264)
 * bug #36789 Change priority of KernelEvents::RESPONSE subscriber (marcw)
 * bug #36794 [Serializer] fix issue with PHP 8 (nicolas-grekas)
 * bug #36786 [WebProfiler] Remove 'none' when appending CSP tokens (ndench)
 * bug #36796 [DI] Use require_once instead of require when appending cache warmer-returned files to preload file (ovrflo)
 * bug #36743 [Yaml] Fix escaped quotes in quoted multi-line string (ossinkine)
 * bug #36773 [HttpClient] preserve the identity of responses streamed by TraceableHttpClient (nicolas-grekas)
 * bug #36777 [TwigBundle] FormExtension does not have a constructor anymore since sf 4.0 (Tobion)
 * bug #36766 [HttpClient] add TimeoutExceptionInterface (nicolas-grekas)
 * bug #36716 [Mime] handle passing custom mime types as string (mcneely)
 * bug #36765 [HttpClient] fix dealing with informational response (nicolas-grekas)
 * bug #36747 Queue name is a required parameter (theravel)
 * bug #36751 [Mime] fix bad method call on `EmailAddressContains` (Kocal)
 * bug #36737 [Cache] fix accepting sub-second max-lifetimes in ArrayAdapter (nicolas-grekas)
 * bug #36749 [DI] give priority to container.hot_path over container.no_preload (nicolas-grekas)
 * bug #36721 [FrameworkBundle] remove getProjectDir method from MicroKernelTrait (garak)

* 5.1.0-BETA1 (2020-05-05)

 * feature #36711 [Form] deprecate `NumberToLocalizedStringTransformer::ROUND_*` constants (nicolas-grekas)
 * feature #36681 [FrameworkBundle] use the router context by default for assets (nicolas-grekas)
 * feature #35545 [Serializer] Allow to include the severity in ConstraintViolationList (dunglas)
 * feature #36471 [String] allow passing a string of custom characters to ByteString::fromRandom (azjezz)
 * feature #35092 [Inflector][String] Move Inflector in String (fancyweb)
 * feature #36302 [Form] Add the html5 option to ColorType to validate the input (fancyweb)
 * feature #36184 [FrameworkBundle] Deprecate renderView() in favor of renderTemplate() (javiereguiluz)
 * feature #36655 Automatically provide Messenger Doctrine schema to "diff" (weaverryan)
 * feature #35849 [ExpressionLanguage] Added expression language syntax validator (Andrej-in-ua)
 * feature #36656 [Security/Core] Add CustomUserMessageAccountStatusException (VincentLanglet)
 * feature #36621 Log deprecations on a dedicated Monolog channel (l-vo)
 * feature #34813 [Yaml] support YAML 1.2 octal notation, deprecate YAML 1.1 one (xabbuh)
 * feature #36557 [Messenger] Add support for RecoverableException (jderusse)
 * feature #36470 [DependencyInjection] Add a mechanism to deprecate public services to private (fancyweb)
 * feature #36651 [FrameworkBundle] Allow configuring the default base URI with a DSN (nicolas-grekas)
 * feature #36600 [Security] Added LDAP support to Authenticator system (wouterj)
 * feature #35453 [Messenger] Add option to stop the worker after a message failed (micheh)
 * feature #36094 [AmazonSqsMessenger] Use AsyncAws to handle SQS communication (jderusse)
 * feature #36636 Add support of PHP8 static return type for withers (l-vo)
 * feature #36586 [DI] allow loading and dumping tags with an attribute named "name" (nicolas-grekas)
 * feature #36599 [HttpKernel] make kernels implementing `WarmableInterface` be part of the cache warmup stage (nicolas-grekas)
 * feature #35992 [Mailer] Use AsyncAws to handle SES requests (jderusse)
 * feature #36574 [Security] Removed anonymous in the new security system (wouterj)
 * feature #36666 [Security] Renamed VerifyAuthenticatorCredentialsEvent to CheckPassportEvent (wouterj)
 * feature #36575 [Security] Require entry_point to be configured with multiple authenticators (wouterj)
 * feature #36570 [Security] Integrated Guards with the Authenticator system (wouterj)
 * feature #36562 Revert "feature #30501 [FrameworkBundle][Routing] added Configurators to handle template and redirect controllers (HeahDude)" (nicolas-grekas)
 * feature #36373 [DI] add syntax to stack decorators (nicolas-grekas)
 * feature #36545 [DI] fix definition and usage of AbstractArgument (nicolas-grekas)
 * feature #28744 [Serializer] Add an @Ignore annotation (dunglas)
 * feature #36456 [String] Add locale-sensitive map for slugging symbols (lmasforne)
 * feature #36535 [DI] skip preloading dependencies of non-preloaded services (nicolas-grekas)
 * feature #36525 Improve SQS interoperability (jderusse)
 * feature #36516 [Notifier] Throw an exception when the Slack DSN is not valid (fabpot)
 * feature #35690 [Notifier] Add Free Mobile notifier (noniagriconomie)
 * feature #33558 [Security] AuthenticatorManager to make "authenticators" first-class security (wouterj)
 * feature #36187 [Routing] Deal with hosts per locale (odolbeau)
 * feature #36464 [RedisMessengerBridge] Add a delete_after_ack option (Seldaek)
 * feature #36431 [Messenger] Add FIFO support to the SQS transport (cv65kr)
 * feature #36455 [Cache] Added context to log messages (Nyholm)
 * feature #34363 [HttpFoundation] Add InputBag (azjezz)
 * feature #36445 [WebProfilerBundle] Make a difference between queued and sent emails (fabpot)
 * feature #36424 [Mailer][Messenger] add return statement for MessageHandler (ottaviano)
 * feature #36426 [Form] Deprecated unused old `ServerParams` util (HeahDude)
 * feature #36433 [Console] cursor tweaks (fabpot)
 * feature #35828 [Notifier][Slack] Send messages using Incoming Webhooks (birkof, fabpot)
 * feature #27444 [Console] Add Cursor class to control the cursor in the terminal (pierredup)
 * feature #31390 [Serializer] UnwrappingDenormalizer (nonanerz)
 * feature #36390 [DI] remove restriction and allow mixing "parent" and instanceof-conditionals/defaults/bindings (nicolas-grekas)
 * feature #36388 [DI] deprecate the `inline()` function from the PHP-DSL in favor of `service()` (nicolas-grekas)
 * feature #36389 [DI] allow decorators to reference their decorated service using the special `.inner` id (nicolas-grekas)
 * feature #36345 [OptionsResolver] Improve the deprecation feature by handling package and version (atailouloute)
 * feature #36372 [VarCloner] Cut Logger in dump (lyrixx)
 * feature #35748 [HttpFoundation] Add support for all core response http control directives (azjezz)
 * feature #36270 [FrameworkBundle] Add file links to named controllers in debug:router (chalasr)
 * feature #35762 [Asset] Allows to download asset manifest over HTTP (GromNaN)
 * feature #36195 [DI] add tags `container.preload`/`.no_preload` to declare extra classes to preload/services to not preload (nicolas-grekas)
 * feature #36209 [HttpKernel] allow cache warmers to add to the list of preloaded classes and files (nicolas-grekas)
 * feature #36243 [Security] Refactor logout listener to dispatch an event instead (wouterj)
 * feature #36185 [Messenger] Add a \Throwable argument in RetryStrategyInterface methods (Benjamin Dos Santos)
 * feature #35871 [Config] Improve the deprecation features by handling package and version (atailouloute)
 * feature #35879 [DependencyInjection] Deprecate ContainerInterface aliases (fancyweb)
 * feature #36273 [FrameworkBundle] Deprecate flashbag and attributebag services (William Arslett)
 * feature #36257 [HttpKernel] Deprecate single-colon notation for controllers (chalasr)
 * feature #35778 [DI] Improve the deprecation features by handling package and version (atailouloute)
 * feature #36129 [HttpFoundation][HttpKernel][Security] Improve UnexpectedSessionUsageException backtrace (mtarld)
 * feature #36186 [FrameworkBundle] Dump kernel extension configuration (guillbdx)
 * feature #34984 [Form] Allowing plural message on extra data validation failure (popnikos)
 * feature #36154 [Notifier][Slack] Add fields on Slack Section block (birkof)
 * feature #36148 [Mailer][Mailgun] Support more headers (Nyholm)
 * feature #36144 [FrameworkBundle][Routing] Add link to source to router:match (l-vo)
 * feature #36117 [PropertyAccess][DX] Added an `UninitializedPropertyException` (HeahDude)
 * feature #36088 [Form] Added "collection_entry" block prefix to CollectionType entries (HeahDude)
 * feature #35936 [String] Add AbstractString::containsAny() (nicolas-grekas)
 * feature #35744 [Validator] Add AtLeastOne constraint and validator (przemyslaw-bogusz)
 * feature #35729 [Form] Correctly round model with PercentType and add a rounding_mode option (VincentLanglet)
 * feature #35733 [Form] Added a "choice_filter" option to ChoiceType (HeahDude)
 * feature #36003 [ErrorHandler][FrameworkBundle] better error messages in failing tests (guillbdx)
 * feature #36034 [PhpUnitBridge] Deprecate @expectedDeprecation annotation (hkdobrev)
 * feature #35924 [HttpClient] make `HttpClient::create()` return an `AmpHttpClient` when `amphp/http-client` is found but curl is not or too old (nicolas-grekas)
 * feature #36072 [SecurityBundle] Added XSD for the extension configuration (HeahDude)
 * feature #36074 [Uid] add AbstractUid and interop with base-58/32/RFC4122 encodings (nicolas-grekas)
 * feature #36066 [Uid] use one class per type of UUID (nicolas-grekas)
 * feature #36042 [Uid] add support for Ulid (nicolas-grekas)
 * feature #35995 [FrameworkBundle] add --deprecations on debug:container command (Simperfit, noemi-salaun)
 * feature #36059 [String] leverage Stringable from PHP 8 (nicolas-grekas)
 * feature #35940 [UID] Added the component + Added support for UUID (lyrixx)
 * feature #31375 [Form] Add label_html attribute (przemyslaw-bogusz)
 * feature #35997 [DX][Testing] Added a loginUser() method to test protected resources (javiereguiluz, wouterj)
 * feature #35978 [Messenger] Show message & handler(s) class description in debug:messenger (ogizanagi)
 * feature #35960 [Security/Http] Hash Persistent RememberMe token (guillbdx)
 * feature #35115 [HttpClient] Add portable HTTP/2 implementation based on Amp's HTTP client (nicolas-grekas)
 * feature #35913 [LDAP] Add error code in exceptions generated by ldap (Victor Garcia)
 * feature #35782 [Routing] Add stateless route attribute (mtarld)
 * feature #35732 [FrameworkBundle][HttpKernel] Add session usage reporting in stateless mode (mtarld)
 * feature #35815 [Validator] Allow Sequentially constraints on classes + target guards (ogizanagi)
 * feature #35747 [Routing][FrameworkBundle] Allow using env() in route conditions (atailouloute)
 * feature #35857 [Routing] deprecate RouteCompiler::REGEX_DELIMITER (nicolas-grekas)
 * feature #35804 [HttpFoundation] Added MarshallingSessionHandler (atailouloute)
 * feature #35858 [Security] Deprecated ROLE_PREVIOUS_ADMIN (wouterj)
 * feature #35848 [Validator] add alpha3 option to Language constraint (xabbuh)
 * feature #31189 [Security] Add IS_IMPERSONATOR, IS_ANONYMOUS and IS_REMEMBERED (HeahDude)
 * feature #30994 [Form] Added support for caching choice lists based on options (HeahDude)
 * feature #35783 [Validator] Add the divisibleBy option to the Count constraint (fancyweb)
 * feature #35649 [String] Allow to keep the last word when truncating a text (franmomu)
 * feature #34654 [Notifier] added Sinch texter transport (imiroslavov)
 * feature #35673 [Process] Add getter for process starttime (dompie)
 * feature #35689 [String] Transliterate & to and (Warxcell)
 * feature #34550 [Form] Added an AbstractChoiceLoader to simplify implementations and handle global optimizations (HeahDude)
 * feature #35688 [Notifier] Simplify OVH implementation (fabpot)
 * feature #34540 [Notifier] add OvhCloud bridge (antiseptikk)
 * feature #35192 [PhpUnitBridge] Add the ability to expect a deprecation inside a test (fancyweb)
 * feature #35667 [DomCrawler] Rename UriExpander.php -> UriResolver (lyrixx)
 * feature #35611 [Console] Moved estimated & remaining calculation logic to separate get method (peterjaap)
 * feature #33968 [Notifier] Add Firebase bridge (Jeroeny)
 * feature #34022 [Notifier] add RocketChat bridge (Jeroeny)
 * feature #32454 [Messenger] Add SQS transport (jderusse)
 * feature #33875 Add Mattermost notifier bridge (thePanz)
 * feature #35400 [RFC][DX][OptionsResolver] Allow setting info message per option (yceruto)
 * feature #30501 [FrameworkBundle][Routing] added Configurators to handle template and redirect controllers (HeahDude)
 * feature #35373 [Translation] Support name attribute on the xliff2 translator loader (Taluu)
 * feature #35550 Leverage trigger_deprecation() from symfony/deprecation-contracts (nicolas-grekas)
 * feature #35648 [Contracts/Deprecation] don't use assert(), rename to trigger_deprecation() (nicolas-grekas)
 * feature #33456 [MonologBridge] Add Mailer handler (BoShurik)
 * feature #35384 [Messenger] Add receiving of old pending messages (redis) (toooni)
 * feature #34456 [Validator] Add a constraint to sequentially validate a set of constraints (ogizanagi)
 * feature #34334 [Validator] Allow to define a reusable set of constraints (ogizanagi)
 * feature #35642 [HttpFoundation] Make dependency on Mime component optional (atailouloute)
 * feature #35635 [HttpKernel] Make ErrorListener unaware of the event dispatcher (derrabus)
 * feature #35019 [Cache] add SodiumMarshaller (atailouloute)
 * feature #35625 [String] Add the s() helper method (fancyweb)
 * feature #35624 [String] Remove the @experimental status (fancyweb)
 * feature #33848 [OptionsResolver] Add new OptionConfigurator class to define options with fluent interface (lmillucci, yceruto)
 * feature #35076 [DI] added possibility to define services with abstract arguments (Islam93)
 * feature #35608 [Routing] add priority option to annotated routes (nicolas-grekas)
 * feature #35526 [Contracts/Deprecation] Provide a generic function and convention to trigger deprecation notices (nicolas-grekas)
 * feature #32747 [Form] Add "is empty callback" to form config (fancyweb)
 * feature #34884 [DI] Enable auto alias compiler pass by default (X-Coder264)
 * feature #35596 [Serializer] Add support for stdClass (dunglas)
 * feature #34278 Update bootstrap_4_layout.html.twig (CoalaJoe)
 * feature #31309 [SecurityBundle] add "service" option in remember_me firewall (Pchol)
 * feature #31429 [Messenger] add support for abstract handlers (timiTao)
 * feature #31466 [Validator] add Validation::createCallable() (janvernieuwe)
 * feature #34747 [Notifier] Added possibility to extract path from provided DSN (espectrio)
 * feature #35534 [FrameworkBundle] Use MailerAssertionsTrait in KernelTestCase (adrienfr)
 * feature #35590 [FrameworkBundle] use framework.translator.enabled_locales to build routes' default "_locale" requirement (nicolas-grekas)
 * feature #35167 [Notifier] Remove superfluous parameters in *Message::fromNotification() (fancyweb)
 * feature #35415 Extracted code to expand an URI to `UriExpander` (lyrixx)
 * feature #35485 [Messenger] Add support for PostgreSQL LISTEN/NOTIFY (dunglas)
 * feature #32039 [Cache] Add couchbase cache adapter (ajcerezo)
 * feature #32433 [Translation] Introduce a way to configure the enabled locales (javiereguiluz)
 * feature #33003 [Filesystem] Add $suffix argument to tempnam() (jdufresne)
 * feature #35347 [VarDumper] Add a RdKafka caster  (romainneutron)
 * feature #34925 Messenger: validate options for AMQP and Redis Connections (nikophil)
 * feature #33315 [WebProfiler] Improve HttpClient Panel (ismail1432)
 * feature #34298 [String] add LazyString to provide memoizing stringable objects (nicolas-grekas)
 * feature #35368 [Yaml] Deprecate using the object and const tag without a value (fancyweb)
 * feature #35566 [HttpClient] adding NoPrivateNetworkHttpClient decorator (hallboav)
 * feature #35560 [HttpKernel] allow using public aliases to reference controllers (nicolas-grekas)
 * feature #34871 [HttpClient] Allow pass array of callable to the mocking http client (Koc)
 * feature #30704 [PropertyInfo] Add accessor and mutator extractor interface and implementation on reflection (joelwurtz, Korbeil)
 * feature #35525 [Mailer] Randomize the first transport used by the RoundRobin transport (fabpot)
 * feature #35116 [Validator] Add alpha3 option to country constraint (maxperrimond)
 * feature #29139 [FrameworkBundle][TranslationDebug] Return non-zero exit code on failure (DAcodedBEAT)
 * feature #35050 [Mailer] added tag/metadata support (kbond)
 * feature #35215 [HttpFoundation] added withers to Cookie class (ns3777k)
 * feature #35514 [DI][Routing] add wither to configure the path of PHP-DSL configurators (nicolas-grekas)
 * feature #35519 [Mailer] Make default factories public (fabpot)
 * feature #35156 [String] Made AbstractString::width() follow POSIX.1-2001 (fancyweb)
 * feature #35308 [Dotenv] Add Dotenv::bootEnv() to check for .env.local.php before calling Dotenv::loadEnv() (nicolas-grekas)
 * feature #35271 [PHPUnitBridge] Improved deprecations display (greg0ire)
 * feature #35478 [Console] Add constants for main exit codes (Chi-teck)
 * feature #35503 [Messenger] Add TLS option to Redis transport's DSN (Nyholm)
 * feature #35262 [Mailer] add ability to disable the TLS peer verification via DSN (Aurélien Fontaine)
 * feature #35194 [Mailer] read default timeout from ini configurations  (azjezz)
 * feature #35422 [Messenger] Move Transports to separate packages (Nyholm)
 * feature #35425 [CssSelector] Added cache on top of CssSelectorConverter (lyrixx)
 * feature #35362 [Cache] Add LRU + max-lifetime capabilities to ArrayCache (nicolas-grekas)
 * feature #35402 [Console] Set Command::setHidden() final for adding default param in SF 6.0 (lyrixx)
 * feature #35407 [HttpClient] collect the body of responses when possible (nicolas-grekas)
 * feature #35391 [WebProfilerBundle][HttpClient] Added profiler links in the Web Profiler -> Http Client panel (cristagu)
 * feature #35295 [Messenger] Messenger redis local sock dsn (JJarrie)
 * feature #35322 [Workflow] Added a way to not fire the announce event (lyrixx)
 * feature #35321 [Workflow] Make many internal services as hidden (lyrixx)
 * feature #35235 [Serializer] Added scalar denormalization (a-menshchikov)
 * feature #35310 [FrameworkBundle] Deprecate *not* setting the "framework.router.utf8" option (nicolas-grekas)
 * feature #34387 [Yaml] Added yaml-lint binary (jschaedl)
 * feature #35257 [FrameworkBundle] TemplateController should accept extra arguments to be sent to the template (Benjamin RICHARD)
 * feature #34980 [Messenger] remove several messages with command messenger:failed:remove (nikophil)
 * feature #35298 Make sure the UriSigner can be autowired (Toflar)
 * feature #31518 [Validator] Added HostnameValidator (karser)
 * feature #35284 Simplify UriSigner when working with HttpFoundation's Request (Toflar)
 * feature #35285 [FrameworkBundle] Adding better output to secrets:decrypt-to-local command (weaverryan)
 * feature #35273 [HttpClient] Add LoggerAwareInterface to ScopingHttpClient and TraceableHttpClient (pierredup)
 * feature #34865 [FrameworkBundle][ContainerLintCommand] Style messages (fancyweb)
 * feature #34847 Add support for safe HTTP preference - RFC 8674 (pyrech)
 * feature #34880 [Twig][Form] Twig theme for Foundation 6 (Lyssal)
 * feature #35281 [FrameworkBundle] Configure RequestContext through router config (benji07)
 * feature #34819 [Console] Add SingleCommandApplication to ease creation of Single Command Application (lyrixx)
 * feature #35104 [Messenger] Log sender alias in SendMessageMiddleware (ruudk)
 * feature #35205 [Form] derive the view timezone from the model timezone (xabbuh)
 * feature #34986 [Form] Added default `inputmode` attribute to Search, Email and Tel form types (fre5h)
 * feature #35091 [String] Add the reverse() method (fancyweb)
 * feature #35029 [DI] allow "." and "-" in env processor lines (nicolas-grekas)
 * feature #34548 Added access decision strategy to respect voter priority (aschempp)
 * feature #34881 [FrameworkBundle] Allow using the kernel as a registry of controllers and service factories (nicolas-grekas)
 * feature #34977 [EventDispatcher] Deprecate LegacyEventDispatcherProxy (derrabus)
 * feature #34873 [FrameworkBundle] Allow using a ContainerConfigurator in MicroKernelTrait::configureContainer() (nicolas-grekas)
 * feature #34872 [FrameworkBundle] Added flex-compatible default implementations for `MicroKernelTrait::registerBundles()` and `getProjectDir()` (nicolas-grekas)
 * feature #34916 [DI] Add support for defining method calls in InlineServiceConfigurator (Lctrs)
 * feature #31889 [Lock] add mongodb store (kralos)
 * feature #34924 [ErrorHandler] Enabled the dark theme for exception pages (javiereguiluz)
 * feature #34769 [DependencyInjection] Autowire public typed properties (Plopix)
 * feature #34856 [Validator] mark the Composite constraint as internal (xabbuh)
 * feature #34771 Deprecate *Response::create() methods (fabpot)
 * feature #32388 [Form] Allow to translate each language into its language in LanguageType (javiereguiluz)
 * feature #34119 [Mime] Added MimeType for "msg" (LIBERT Jérémy)
 * feature #34648 [Mailer] Allow to configure or disable the message bus to use (ogizanagi)
 * feature #34705 [Validator] Label regex in date validator (kristofvc)
 * feature #34591 [Workflow] Added `Registry::has()` to check if a workflow exists (lyrixx)
 * feature #32937 [Routing] Deprecate RouteCollectionBuilder (vudaltsov)
 * feature #34557 [PropertyInfo] Add support for typed properties (PHP 7.4) (dunglas)
 * feature #34573 [DX] [Workflow] Added a way to specify a message when blocking a transition + better default message in case it is not set (lyrixx)
 * feature #34457 Added context to exceptions thrown in apply method (koenreiniers)

