# Scrollbar-size

The `scrollbar-size` style defines the width of the scrollbars.

## Syntax

--8<-- "docs/snippets/syntax_block_start.md"
scrollbar-size: <a href="../../css_types/integer">&lt;integer&gt;</a> <a href="../../css_types/integer">&lt;integer&gt;</a>;
              # horizontal vertical

scrollbar-size-horizontal: <a href="../../css_types/integer">&lt;integer&gt;</a>;
scrollbar-size-vertical: <a href="../../css_types/integer">&lt;integer&gt;</a>;
--8<-- "docs/snippets/syntax_block_end.md"

The `scrollbar-size` style takes two [`<integer>`](../css_types/integer.md) to set the horizontal and vertical scrollbar sizes, respectively.
This customisable size is the width of the scrollbar, given that its length will always be 100% of the container.

The scrollbar widths may also be set individually with `scrollbar-size-horizontal` and `scrollbar-size-vertical`.

## Examples

### Basic usage

In this example we modify the size of the widget's scrollbar to be _much_ larger than usual.

=== "Output"

    ```{.textual path="docs/examples/styles/scrollbar_size.py"}
    ```

=== "scrollbar_size.py"

    ```python
    --8<-- "docs/examples/styles/scrollbar_size.py"
    ```

=== "scrollbar_size.tcss"

    ```css hl_lines="13"
    --8<-- "docs/examples/styles/scrollbar_size.tcss"
    ```

### Scrollbar sizes comparison

In the next example we show three containers with differently sized scrollbars.

!!! tip

    If you want to hide the scrollbar but still allow the container to scroll
    using the mousewheel or keyboard, you can set the scrollbar size to `0`.

=== "Output"

    ```{.textual path="docs/examples/styles/scrollbar_size2.py"}
    ```

=== "scrollbar_size2.py"

    ```python
    --8<-- "docs/examples/styles/scrollbar_size2.py"
    ```

=== "scrollbar_size2.tcss"

    ```css hl_lines="6 11 16"
    --8<-- "docs/examples/styles/scrollbar_size2.tcss"
    ```

## CSS

```css
/* Set horizontal scrollbar to 10, and vertical scrollbar to 4 */
scrollbar-size: 10 4;

/* Set horizontal scrollbar to 10 */
scrollbar-size-horizontal: 10;

/* Set vertical scrollbar to 4 */
scrollbar-size-vertical: 4;
```

## Python

The style `scrollbar-size` has no Python equivalent.
The scrollbar sizes must be set independently:

```py
# Set horizontal scrollbar to 10:
widget.styles.scrollbar_size_horizontal = 10
# Set vertical scrollbar to 4:
widget.styles.scrollbar_size_vertical = 4
```
