/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean lock_used;
};


static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

#define VALA_FIELD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FIELD, ValaFieldPrivate))
static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_field_real_get_lock_used (ValaLockable* base);
static void vala_field_real_set_lock_used (ValaLockable* base,
                                    gboolean used);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);


/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}


ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}


static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}


static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}


static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaField*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean used)
{
	ValaField * self;
	self = (ValaField*) base;
	self->priv->lock_used = used;
}


static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaTypeSymbol* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaDataType* _tmp34_;
	ValaTypeSymbol* _tmp35_;
	ValaTypeSymbol* _tmp36_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	ValaSemanticAnalyzer* _tmp63_;
	ValaSemanticAnalyzer* _tmp64_;
	ValaDataType* _tmp65_;
	ValaDataType* _tmp66_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp77_;
	ValaDataType* _tmp78_;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	gboolean _tmp81_ = FALSE;
	ValaArrayType* _tmp82_;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_ = FALSE;
	ValaArrayType* _tmp96_;
	ValaExpression* _tmp105_;
	ValaExpression* _tmp106_;
	gboolean _tmp231_ = FALSE;
	ValaMemberBinding _tmp232_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp237_;
	ValaSymbol* _tmp238_;
	gboolean _tmp247_ = FALSE;
	gboolean _tmp248_ = FALSE;
	gboolean _tmp249_;
	gboolean _tmp250_;
	ValaSemanticAnalyzer* _tmp265_;
	ValaSemanticAnalyzer* _tmp266_;
	ValaSourceFile* _tmp267_;
	ValaSemanticAnalyzer* _tmp268_;
	ValaSemanticAnalyzer* _tmp269_;
	ValaSymbol* _tmp270_;
	gboolean _tmp271_;
	gboolean _tmp272_;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_data_type_get_data_type (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->va_list_type;
	_tmp35_ = vala_data_type_get_data_type (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp31_ == _tmp36_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_get_data_type (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strdup_printf ("`%s' not supported as field type", _tmp44_);
		_tmp46_ = _tmp45_;
		vala_report_error (_tmp38_, _tmp46_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp47_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp48_ = _tmp47_;
	vala_code_node_check ((ValaCodeNode*) _tmp48_, context);
	_tmp49_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp50_ = _tmp49_;
	if (!_tmp50_) {
		ValaDataType* _tmp51_;
		ValaDataType* _tmp52_;
		ValaTypeSymbol* _tmp53_;
		ValaTypeSymbol* _tmp54_;
		_tmp51_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_data_type_get_data_type (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaDataType* _tmp55_;
			ValaDataType* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			ValaVersionAttribute* _tmp59_;
			ValaVersionAttribute* _tmp60_;
			ValaSourceReference* _tmp61_;
			ValaSourceReference* _tmp62_;
			_tmp55_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_data_type_get_data_type (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_symbol_get_version ((ValaSymbol*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp62_ = _tmp61_;
			vala_version_attribute_check (_tmp60_, _tmp62_);
		}
	}
	_tmp63_ = vala_code_context_get_analyzer (context);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp66_ = _tmp65_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp64_, (ValaSymbol*) self, _tmp66_)) {
		ValaSourceReference* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaDataType* _tmp69_;
		ValaDataType* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_code_node_to_string ((ValaCodeNode*) _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_strdup_printf ("field type `%s` is less accessible than field `%s`", _tmp72_, _tmp74_);
		_tmp76_ = _tmp75_;
		vala_report_error (_tmp68_, _tmp76_);
		_g_free0 (_tmp76_);
		_g_free0 (_tmp74_);
		_g_free0 (_tmp72_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp77_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp78_ = _tmp77_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp78_) ? ((ValaArrayType*) _tmp78_) : NULL;
	_tmp82_ = variable_array_type;
	if (_tmp82_ != NULL) {
		ValaArrayType* _tmp83_;
		gboolean _tmp84_;
		gboolean _tmp85_;
		_tmp83_ = variable_array_type;
		_tmp84_ = vala_array_type_get_inline_allocated (_tmp83_);
		_tmp85_ = _tmp84_;
		_tmp81_ = _tmp85_;
	} else {
		_tmp81_ = FALSE;
	}
	if (_tmp81_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		_tmp86_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp87_ = _tmp86_;
		_tmp80_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp87_);
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaInitializerList* _tmp90_;
		ValaInitializerList* _tmp91_;
		_tmp88_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp89_ = _tmp88_;
		_tmp90_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp91_ = _tmp90_;
		_tmp79_ = _tmp91_ == NULL;
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		ValaSourceReference* _tmp92_;
		ValaSourceReference* _tmp93_;
		_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp93_ = _tmp92_;
		vala_report_warning (_tmp93_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp96_ = variable_array_type;
	if (_tmp96_ != NULL) {
		ValaArrayType* _tmp97_;
		gboolean _tmp98_;
		gboolean _tmp99_;
		_tmp97_ = variable_array_type;
		_tmp98_ = vala_array_type_get_inline_allocated (_tmp97_);
		_tmp99_ = _tmp98_;
		_tmp95_ = _tmp99_;
	} else {
		_tmp95_ = FALSE;
	}
	if (_tmp95_) {
		ValaArrayType* _tmp100_;
		gboolean _tmp101_;
		gboolean _tmp102_;
		_tmp100_ = variable_array_type;
		_tmp101_ = vala_array_type_get_fixed_length (_tmp100_);
		_tmp102_ = _tmp101_;
		_tmp94_ = !_tmp102_;
	} else {
		_tmp94_ = FALSE;
	}
	if (_tmp94_) {
		ValaSourceReference* _tmp103_;
		ValaSourceReference* _tmp104_;
		_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp104_ = _tmp103_;
		vala_report_error (_tmp104_, "Inline allocated array as field requires to have fixed length");
	}
	_tmp105_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp106_ = _tmp105_;
	if (_tmp106_ != NULL) {
		ValaExpression* _tmp107_;
		ValaExpression* _tmp108_;
		ValaDataType* _tmp109_;
		ValaDataType* _tmp110_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp111_;
		ValaExpression* _tmp112_;
		ValaExpression* _tmp117_;
		ValaExpression* _tmp118_;
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaDataType* _tmp121_;
		ValaDataType* _tmp122_;
		ValaExpression* _tmp125_;
		ValaExpression* _tmp126_;
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		ValaDataType* _tmp129_;
		ValaDataType* _tmp130_;
		gboolean _tmp145_ = FALSE;
		gboolean _tmp146_ = FALSE;
		gboolean _tmp147_ = FALSE;
		ValaArrayType* _tmp148_;
		gboolean _tmp164_ = FALSE;
		gboolean _tmp165_ = FALSE;
		ValaArrayType* _tmp166_;
		ValaExpression* _tmp176_;
		ValaExpression* _tmp177_;
		ValaDataType* _tmp178_;
		ValaDataType* _tmp179_;
		gboolean _tmp189_ = FALSE;
		ValaSymbol* _tmp190_;
		ValaSymbol* _tmp191_;
		gboolean _tmp196_ = FALSE;
		gboolean _tmp197_ = FALSE;
		ValaSymbol* _tmp198_;
		ValaSymbol* _tmp199_;
		gboolean _tmp213_ = FALSE;
		gboolean _tmp214_ = FALSE;
		gboolean _tmp215_ = FALSE;
		ValaMemberBinding _tmp216_;
		gboolean _tmp227_;
		gboolean _tmp228_;
		_tmp107_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp108_ = _tmp107_;
		_tmp109_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp110_ = _tmp109_;
		vala_expression_set_target_type (_tmp108_, _tmp110_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp111_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp112_ = _tmp111_;
		if (VALA_IS_INITIALIZER_LIST (_tmp112_)) {
			ValaExpression* _tmp113_;
			ValaExpression* _tmp114_;
			gint _tmp115_;
			gint _tmp116_;
			_tmp113_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp114_ = _tmp113_;
			_tmp115_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp116_ = _tmp115_;
			initializer_size = _tmp116_;
			is_initializer_list = TRUE;
		}
		_tmp117_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp118_ = _tmp117_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp118_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp119_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_expression_get_value_type (_tmp120_);
		_tmp122_ = _tmp121_;
		if (_tmp122_ == NULL) {
			ValaSourceReference* _tmp123_;
			ValaSourceReference* _tmp124_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp124_ = _tmp123_;
			vala_report_error (_tmp124_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp125_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp126_ = _tmp125_;
		_tmp127_ = vala_expression_get_value_type (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp130_ = _tmp129_;
		if (!vala_data_type_compatible (_tmp128_, _tmp130_)) {
			ValaSourceReference* _tmp131_;
			ValaSourceReference* _tmp132_;
			ValaExpression* _tmp133_;
			ValaExpression* _tmp134_;
			ValaDataType* _tmp135_;
			ValaDataType* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			ValaDataType* _tmp139_;
			ValaDataType* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp134_ = _tmp133_;
			_tmp135_ = vala_expression_get_value_type (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_code_node_to_string ((ValaCodeNode*) _tmp136_);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_code_node_to_string ((ValaCodeNode*) _tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp138_, _tmp142_);
			_tmp144_ = _tmp143_;
			vala_report_error (_tmp132_, _tmp144_);
			_g_free0 (_tmp144_);
			_g_free0 (_tmp142_);
			_g_free0 (_tmp138_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp148_ = variable_array_type;
		if (_tmp148_ != NULL) {
			ValaArrayType* _tmp149_;
			gboolean _tmp150_;
			gboolean _tmp151_;
			_tmp149_ = variable_array_type;
			_tmp150_ = vala_array_type_get_inline_allocated (_tmp149_);
			_tmp151_ = _tmp150_;
			_tmp147_ = _tmp151_;
		} else {
			_tmp147_ = FALSE;
		}
		if (_tmp147_) {
			ValaArrayType* _tmp152_;
			gboolean _tmp153_;
			gboolean _tmp154_;
			_tmp152_ = variable_array_type;
			_tmp153_ = vala_array_type_get_fixed_length (_tmp152_);
			_tmp154_ = _tmp153_;
			_tmp146_ = !_tmp154_;
		} else {
			_tmp146_ = FALSE;
		}
		if (_tmp146_) {
			gboolean _tmp155_;
			_tmp155_ = is_initializer_list;
			_tmp145_ = _tmp155_;
		} else {
			_tmp145_ = FALSE;
		}
		if (_tmp145_) {
			ValaArrayType* _tmp156_;
			gint _tmp157_;
			gchar* _tmp158_;
			gchar* _tmp159_;
			ValaIntegerLiteral* _tmp160_;
			ValaIntegerLiteral* _tmp161_;
			ValaArrayType* _tmp162_;
			ValaArrayType* _tmp163_;
			_tmp156_ = variable_array_type;
			_tmp157_ = initializer_size;
			_tmp158_ = g_strdup_printf ("%i", _tmp157_);
			_tmp159_ = _tmp158_;
			_tmp160_ = vala_integer_literal_new (_tmp159_, NULL);
			_tmp161_ = _tmp160_;
			vala_array_type_set_length (_tmp156_, (ValaExpression*) _tmp161_);
			_vala_code_node_unref0 (_tmp161_);
			_g_free0 (_tmp159_);
			_tmp162_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp162_, TRUE);
			_tmp163_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp163_, FALSE);
		}
		_tmp166_ = variable_array_type;
		if (_tmp166_ != NULL) {
			ValaArrayType* _tmp167_;
			gboolean _tmp168_;
			gboolean _tmp169_;
			_tmp167_ = variable_array_type;
			_tmp168_ = vala_array_type_get_inline_allocated (_tmp167_);
			_tmp169_ = _tmp168_;
			_tmp165_ = _tmp169_;
		} else {
			_tmp165_ = FALSE;
		}
		if (_tmp165_) {
			ValaExpression* _tmp170_;
			ValaExpression* _tmp171_;
			ValaDataType* _tmp172_;
			ValaDataType* _tmp173_;
			_tmp170_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_expression_get_value_type (_tmp171_);
			_tmp173_ = _tmp172_;
			_tmp164_ = !VALA_IS_ARRAY_TYPE (_tmp173_);
		} else {
			_tmp164_ = FALSE;
		}
		if (_tmp164_) {
			ValaSourceReference* _tmp174_;
			ValaSourceReference* _tmp175_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp175_ = _tmp174_;
			vala_report_error (_tmp175_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp176_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_expression_get_value_type (_tmp177_);
		_tmp179_ = _tmp178_;
		if (vala_data_type_is_disposable (_tmp179_)) {
			gboolean _tmp180_ = FALSE;
			ValaDataType* _tmp181_;
			ValaDataType* _tmp182_;
			_tmp181_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp182_ = _tmp181_;
			if (!VALA_IS_POINTER_TYPE (_tmp182_)) {
				ValaDataType* _tmp183_;
				ValaDataType* _tmp184_;
				gboolean _tmp185_;
				gboolean _tmp186_;
				_tmp183_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_data_type_get_value_owned (_tmp184_);
				_tmp186_ = _tmp185_;
				_tmp180_ = !_tmp186_;
			} else {
				_tmp180_ = FALSE;
			}
			if (_tmp180_) {
				ValaSourceReference* _tmp187_;
				ValaSourceReference* _tmp188_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp188_ = _tmp187_;
				vala_report_error (_tmp188_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp190_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp191_ = _tmp190_;
		if (VALA_IS_NAMESPACE (_tmp191_)) {
			ValaExpression* _tmp192_;
			ValaExpression* _tmp193_;
			_tmp192_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp193_ = _tmp192_;
			_tmp189_ = !vala_expression_is_constant (_tmp193_);
		} else {
			_tmp189_ = FALSE;
		}
		if (_tmp189_) {
			ValaSourceReference* _tmp194_;
			ValaSourceReference* _tmp195_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp195_ = _tmp194_;
			vala_report_error (_tmp195_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp199_ = _tmp198_;
		if (VALA_IS_NAMESPACE (_tmp199_)) {
			ValaExpression* _tmp200_;
			ValaExpression* _tmp201_;
			_tmp200_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp201_ = _tmp200_;
			_tmp197_ = vala_expression_is_constant (_tmp201_);
		} else {
			_tmp197_ = FALSE;
		}
		if (_tmp197_) {
			ValaExpression* _tmp202_;
			ValaExpression* _tmp203_;
			_tmp202_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp203_ = _tmp202_;
			_tmp196_ = vala_expression_is_non_null (_tmp203_);
		} else {
			_tmp196_ = FALSE;
		}
		if (_tmp196_) {
			gboolean _tmp204_ = FALSE;
			ValaDataType* _tmp205_;
			ValaDataType* _tmp206_;
			_tmp205_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp206_ = _tmp205_;
			if (vala_data_type_is_disposable (_tmp206_)) {
				ValaDataType* _tmp207_;
				ValaDataType* _tmp208_;
				gboolean _tmp209_;
				gboolean _tmp210_;
				_tmp207_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_data_type_get_value_owned (_tmp208_);
				_tmp210_ = _tmp209_;
				_tmp204_ = _tmp210_;
			} else {
				_tmp204_ = FALSE;
			}
			if (_tmp204_) {
				ValaSourceReference* _tmp211_;
				ValaSourceReference* _tmp212_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp212_ = _tmp211_;
				vala_report_error (_tmp212_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp216_ = self->priv->_binding;
		if (_tmp216_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp217_;
			ValaSymbol* _tmp218_;
			_tmp217_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp218_ = _tmp217_;
			_tmp215_ = VALA_IS_CLASS (_tmp218_);
		} else {
			_tmp215_ = FALSE;
		}
		if (_tmp215_) {
			ValaSymbol* _tmp219_;
			ValaSymbol* _tmp220_;
			gboolean _tmp221_;
			gboolean _tmp222_;
			_tmp219_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp220_ = _tmp219_;
			_tmp221_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp220_, VALA_TYPE_CLASS, ValaClass));
			_tmp222_ = _tmp221_;
			_tmp214_ = _tmp222_;
		} else {
			_tmp214_ = FALSE;
		}
		if (_tmp214_) {
			ValaExpression* _tmp223_;
			ValaExpression* _tmp224_;
			_tmp223_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp224_ = _tmp223_;
			_tmp213_ = !vala_expression_is_constant (_tmp224_);
		} else {
			_tmp213_ = FALSE;
		}
		if (_tmp213_) {
			ValaSourceReference* _tmp225_;
			ValaSourceReference* _tmp226_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp226_ = _tmp225_;
			vala_report_error (_tmp226_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp227_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp228_ = _tmp227_;
		if (_tmp228_) {
			ValaSourceReference* _tmp229_;
			ValaSourceReference* _tmp230_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp229_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp230_ = _tmp229_;
			vala_report_error (_tmp230_, "External fields cannot use initializers");
		}
	}
	_tmp232_ = self->priv->_binding;
	if (_tmp232_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp233_;
		ValaSymbol* _tmp234_;
		_tmp233_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp234_ = _tmp233_;
		_tmp231_ = VALA_IS_INTERFACE (_tmp234_);
	} else {
		_tmp231_ = FALSE;
	}
	if (_tmp231_) {
		ValaSourceReference* _tmp235_;
		ValaSourceReference* _tmp236_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp236_ = _tmp235_;
		vala_report_error (_tmp236_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp237_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp238_ = _tmp237_;
	if (VALA_IS_CLASS (_tmp238_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp239_;
		ValaSymbol* _tmp240_;
		ValaClass* _tmp241_;
		gboolean _tmp242_ = FALSE;
		ValaClass* _tmp243_;
		gboolean _tmp244_;
		gboolean _tmp245_;
		_tmp239_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp240_ = _tmp239_;
		_tmp241_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp240_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp241_;
		_tmp243_ = cl;
		_tmp244_ = vala_class_get_is_compact (_tmp243_);
		_tmp245_ = _tmp244_;
		if (_tmp245_) {
			ValaClass* _tmp246_;
			_tmp246_ = cl;
			_tmp242_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp246_);
		} else {
			_tmp242_ = FALSE;
		}
		if (_tmp242_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp249_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp250_ = _tmp249_;
	if (!_tmp250_) {
		gboolean _tmp251_;
		gboolean _tmp252_;
		_tmp251_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp252_ = _tmp251_;
		_tmp248_ = !_tmp252_;
	} else {
		_tmp248_ = FALSE;
	}
	if (_tmp248_) {
		ValaSymbol* _tmp253_;
		ValaSymbol* _tmp254_;
		_tmp253_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp254_ = _tmp253_;
		_tmp247_ = _tmp254_ != NULL;
		_vala_code_node_unref0 (_tmp254_);
	} else {
		_tmp247_ = FALSE;
	}
	if (_tmp247_) {
		ValaSourceReference* _tmp255_;
		ValaSourceReference* _tmp256_;
		gchar* _tmp257_;
		gchar* _tmp258_;
		ValaSymbol* _tmp259_;
		ValaSymbol* _tmp260_;
		gchar* _tmp261_;
		gchar* _tmp262_;
		gchar* _tmp263_;
		gchar* _tmp264_;
		_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp256_ = _tmp255_;
		_tmp257_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp258_ = _tmp257_;
		_tmp259_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp260_ = _tmp259_;
		_tmp261_ = vala_symbol_get_full_name (_tmp260_);
		_tmp262_ = _tmp261_;
		_tmp263_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp258_, _tmp262_);
		_tmp264_ = _tmp263_;
		vala_report_warning (_tmp256_, _tmp264_);
		_g_free0 (_tmp264_);
		_g_free0 (_tmp262_);
		_vala_code_node_unref0 (_tmp260_);
		_g_free0 (_tmp258_);
	}
	_tmp265_ = vala_code_context_get_analyzer (context);
	_tmp266_ = _tmp265_;
	_tmp267_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp266_, _tmp267_);
	_tmp268_ = vala_code_context_get_analyzer (context);
	_tmp269_ = _tmp268_;
	_tmp270_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp269_, _tmp270_);
	_tmp271_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp272_ = _tmp271_;
	result = !_tmp272_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_volatile;
	result = _tmp0_;
	return result;
}


void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}


static void
vala_field_class_init (ValaFieldClass * klass)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_add_private (klass, sizeof (ValaFieldPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}


static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*) (ValaLockable*)) vala_field_real_get_lock_used;
	iface->set_lock_used = (void (*) (ValaLockable*, gboolean)) vala_field_real_set_lock_used;
}


static void
vala_field_instance_init (ValaField * self)
{
	self->priv = VALA_FIELD_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	self->priv->lock_used = FALSE;
}


static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}


/**
 * Represents a type or namespace field.
 */
GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_field_type_id;
		vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}



