(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require bool.Bool.
Require int.Int.
Require map.Map.
Require list.List.
Require list.Length.
Require list.Mem.
Require list.Append.

(* Why3 assumption *)
Inductive datatype :=
  | TYunit : datatype
  | TYint : datatype
  | TYbool : datatype.
Axiom datatype_WhyType : WhyType datatype.
Existing Instance datatype_WhyType.

(* Why3 assumption *)
Inductive value :=
  | Vvoid : value
  | Vint : Z -> value
  | Vbool : bool -> value.
Axiom value_WhyType : WhyType value.
Existing Instance value_WhyType.

(* Why3 assumption *)
Inductive operator :=
  | Oplus : operator
  | Ominus : operator
  | Omult : operator
  | Ole : operator.
Axiom operator_WhyType : WhyType operator.
Existing Instance operator_WhyType.

Axiom mident : Type.
Parameter mident_WhyType : WhyType mident.
Existing Instance mident_WhyType.

Axiom mident_decide : forall (m1:mident) (m2:mident), (m1 = m2) \/
  ~ (m1 = m2).

Axiom ident : Type.
Parameter ident_WhyType : WhyType ident.
Existing Instance ident_WhyType.

Axiom ident_decide : forall (m1:ident) (m2:ident), (m1 = m2) \/ ~ (m1 = m2).

(* Why3 assumption *)
Inductive term :=
  | Tvalue : value -> term
  | Tvar : ident -> term
  | Tderef : mident -> term
  | Tbin : term -> operator -> term -> term.
Axiom term_WhyType : WhyType term.
Existing Instance term_WhyType.

(* Why3 assumption *)
Inductive fmla :=
  | Fterm : term -> fmla
  | Fand : fmla -> fmla -> fmla
  | Fnot : fmla -> fmla
  | Fimplies : fmla -> fmla -> fmla
  | Flet : ident -> term -> fmla -> fmla
  | Fforall : ident -> datatype -> fmla -> fmla.
Axiom fmla_WhyType : WhyType fmla.
Existing Instance fmla_WhyType.

(* Why3 assumption *)
Inductive stmt :=
  | Sskip : stmt
  | Sassign : mident -> term -> stmt
  | Sseq : stmt -> stmt -> stmt
  | Sif : term -> stmt -> stmt -> stmt
  | Sassert : fmla -> stmt
  | Swhile : term -> fmla -> stmt -> stmt.
Axiom stmt_WhyType : WhyType stmt.
Existing Instance stmt_WhyType.

Axiom decide_is_skip : forall (s:stmt), (s = Sskip) \/ ~ (s = Sskip).

(* Why3 assumption *)
Definition env := (map.Map.map mident value).

(* Why3 assumption *)
Definition stack := (list (ident* value)%type).

Parameter get_stack: ident -> (list (ident* value)%type) -> value.

Axiom get_stack_def : forall (i:ident) (pi:(list (ident* value)%type)),
  match pi with
  | Init.Datatypes.nil => ((get_stack i pi) = Vvoid)
  | (Init.Datatypes.cons (x, v) r) => ((x = i) -> ((get_stack i pi) = v)) /\
      ((~ (x = i)) -> ((get_stack i pi) = (get_stack i r)))
  end.

Axiom get_stack_eq : forall (x:ident) (v:value) (r:(list (ident*
  value)%type)), ((get_stack x (Init.Datatypes.cons (x, v) r)) = v).

Axiom get_stack_neq : forall (x:ident) (i:ident) (v:value) (r:(list (ident*
  value)%type)), (~ (x = i)) -> ((get_stack i (Init.Datatypes.cons (x,
  v) r)) = (get_stack i r)).

Parameter eval_bin: value -> operator -> value -> value.

Axiom eval_bin_def : forall (x:value) (op:operator) (y:value), match (x,
  y) with
  | ((Vint x1), (Vint y1)) =>
      match op with
      | Oplus => ((eval_bin x op y) = (Vint (x1 + y1)%Z))
      | Ominus => ((eval_bin x op y) = (Vint (x1 - y1)%Z))
      | Omult => ((eval_bin x op y) = (Vint (x1 * y1)%Z))
      | Ole => ((x1 <= y1)%Z -> ((eval_bin x op y) = (Vbool true))) /\
          ((~ (x1 <= y1)%Z) -> ((eval_bin x op y) = (Vbool false)))
      end
  | (_, _) => ((eval_bin x op y) = Vvoid)
  end.

(* Why3 assumption *)
Fixpoint eval_term (sigma:(map.Map.map mident value)) (pi:(list (ident*
  value)%type)) (t:term) {struct t}: value :=
  match t with
  | (Tvalue v) => v
  | (Tvar id) => (get_stack id pi)
  | (Tderef id) => (map.Map.get sigma id)
  | (Tbin t1 op t2) => (eval_bin (eval_term sigma pi t1) op (eval_term sigma
      pi t2))
  end.

(* Why3 assumption *)
Fixpoint eval_fmla (sigma:(map.Map.map mident value)) (pi:(list (ident*
  value)%type)) (f:fmla) {struct f}: Prop :=
  match f with
  | (Fterm t) => ((eval_term sigma pi t) = (Vbool true))
  | (Fand f1 f2) => (eval_fmla sigma pi f1) /\ (eval_fmla sigma pi f2)
  | (Fnot f1) => ~ (eval_fmla sigma pi f1)
  | (Fimplies f1 f2) => (eval_fmla sigma pi f1) -> (eval_fmla sigma pi f2)
  | (Flet x t f1) => (eval_fmla sigma (Init.Datatypes.cons (x,
      (eval_term sigma pi t)) pi) f1)
  | (Fforall x TYint f1) => forall (n:Z), (eval_fmla sigma
      (Init.Datatypes.cons (x, (Vint n)) pi) f1)
  | (Fforall x TYbool f1) => forall (b:bool), (eval_fmla sigma
      (Init.Datatypes.cons (x, (Vbool b)) pi) f1)
  | (Fforall x TYunit f1) => (eval_fmla sigma (Init.Datatypes.cons (x,
      Vvoid) pi) f1)
  end.

(* Why3 assumption *)
Definition valid_fmla (p:fmla): Prop := forall (sigma:(map.Map.map mident
  value)) (pi:(list (ident* value)%type)), (eval_fmla sigma pi p).

(* Why3 assumption *)
Inductive one_step: (map.Map.map mident value) -> (list (ident*
  value)%type) -> stmt -> (map.Map.map mident value) -> (list (ident*
  value)%type) -> stmt -> Prop :=
  | one_step_assign : forall (sigma:(map.Map.map mident value))
      (sigma':(map.Map.map mident value)) (pi:(list (ident* value)%type))
      (x:mident) (t:term), (sigma' = (map.Map.set sigma x (eval_term sigma pi
      t))) -> (one_step sigma pi (Sassign x t) sigma' pi Sskip)
  | one_step_seq_noskip : forall (sigma:(map.Map.map mident value))
      (sigma':(map.Map.map mident value)) (pi:(list (ident* value)%type))
      (pi':(list (ident* value)%type)) (s1:stmt) (s1':stmt) (s2:stmt),
      (one_step sigma pi s1 sigma' pi' s1') -> (one_step sigma pi (Sseq s1
      s2) sigma' pi' (Sseq s1' s2))
  | one_step_seq_skip : forall (sigma:(map.Map.map mident value))
      (pi:(list (ident* value)%type)) (s:stmt), (one_step sigma pi
      (Sseq Sskip s) sigma pi s)
  | one_step_if_true : forall (sigma:(map.Map.map mident value))
      (pi:(list (ident* value)%type)) (t:term) (s1:stmt) (s2:stmt),
      ((eval_term sigma pi t) = (Vbool true)) -> (one_step sigma pi (Sif t s1
      s2) sigma pi s1)
  | one_step_if_false : forall (sigma:(map.Map.map mident value))
      (pi:(list (ident* value)%type)) (t:term) (s1:stmt) (s2:stmt),
      ((eval_term sigma pi t) = (Vbool false)) -> (one_step sigma pi (Sif t
      s1 s2) sigma pi s2)
  | one_step_assert : forall (sigma:(map.Map.map mident value))
      (pi:(list (ident* value)%type)) (f:fmla), (eval_fmla sigma pi f) ->
      (one_step sigma pi (Sassert f) sigma pi Sskip)
  | one_step_while_true : forall (sigma:(map.Map.map mident value))
      (pi:(list (ident* value)%type)) (cond:term) (inv:fmla) (body:stmt),
      ((eval_fmla sigma pi inv) /\ ((eval_term sigma pi
      cond) = (Vbool true))) -> (one_step sigma pi (Swhile cond inv body)
      sigma pi (Sseq body (Swhile cond inv body)))
  | one_step_while_false : forall (sigma:(map.Map.map mident value))
      (pi:(list (ident* value)%type)) (cond:term) (inv:fmla) (body:stmt),
      ((eval_fmla sigma pi inv) /\ ((eval_term sigma pi
      cond) = (Vbool false))) -> (one_step sigma pi (Swhile cond inv body)
      sigma pi Sskip).

(* Why3 assumption *)
Inductive many_steps: (map.Map.map mident value) -> (list (ident*
  value)%type) -> stmt -> (map.Map.map mident value) -> (list (ident*
  value)%type) -> stmt -> Z -> Prop :=
  | many_steps_refl : forall (sigma:(map.Map.map mident value))
      (pi:(list (ident* value)%type)) (s:stmt), (many_steps sigma pi s sigma
      pi s 0%Z)
  | many_steps_trans : forall (sigma1:(map.Map.map mident value))
      (sigma2:(map.Map.map mident value)) (sigma3:(map.Map.map mident value))
      (pi1:(list (ident* value)%type)) (pi2:(list (ident* value)%type))
      (pi3:(list (ident* value)%type)) (s1:stmt) (s2:stmt) (s3:stmt) (n:Z),
      (one_step sigma1 pi1 s1 sigma2 pi2 s2) -> ((many_steps sigma2 pi2 s2
      sigma3 pi3 s3 n) -> (many_steps sigma1 pi1 s1 sigma3 pi3 s3
      (n + 1%Z)%Z)).

Axiom steps_non_neg : forall (sigma1:(map.Map.map mident value))
  (sigma2:(map.Map.map mident value)) (pi1:(list (ident* value)%type))
  (pi2:(list (ident* value)%type)) (s1:stmt) (s2:stmt) (n:Z), (many_steps
  sigma1 pi1 s1 sigma2 pi2 s2 n) -> (0%Z <= n)%Z.

(* Why3 assumption *)
Definition reductible (sigma:(map.Map.map mident value)) (pi:(list (ident*
  value)%type)) (s:stmt): Prop := exists sigma':(map.Map.map mident value),
  exists pi':(list (ident* value)%type), exists s':stmt, (one_step sigma pi s
  sigma' pi' s').

(* Why3 assumption *)
Definition type_value (v:value): datatype :=
  match v with
  | Vvoid => TYunit
  | (Vint _) => TYint
  | (Vbool _) => TYbool
  end.

(* Why3 assumption *)
Inductive type_operator: operator -> datatype -> datatype -> datatype ->
  Prop :=
  | Type_plus : (type_operator Oplus TYint TYint TYint)
  | Type_minus : (type_operator Ominus TYint TYint TYint)
  | Type_mult : (type_operator Omult TYint TYint TYint)
  | Type_le : (type_operator Ole TYint TYint TYbool).

(* Why3 assumption *)
Definition type_stack := (list (ident* datatype)%type).

Parameter get_vartype: ident -> (list (ident* datatype)%type) -> datatype.

Axiom get_vartype_def : forall (i:ident) (pi:(list (ident* datatype)%type)),
  match pi with
  | Init.Datatypes.nil => ((get_vartype i pi) = TYunit)
  | (Init.Datatypes.cons (x, ty) r) => ((x = i) -> ((get_vartype i
      pi) = ty)) /\ ((~ (x = i)) -> ((get_vartype i pi) = (get_vartype i r)))
  end.

(* Why3 assumption *)
Definition type_env := (map.Map.map mident datatype).

(* Why3 assumption *)
Inductive type_term: (map.Map.map mident datatype) -> (list (ident*
  datatype)%type) -> term -> datatype -> Prop :=
  | Type_value : forall (sigma:(map.Map.map mident datatype))
      (pi:(list (ident* datatype)%type)) (v:value), (type_term sigma pi
      (Tvalue v) (type_value v))
  | Type_var : forall (sigma:(map.Map.map mident datatype)) (pi:(list (ident*
      datatype)%type)) (v:ident) (ty:datatype), ((get_vartype v pi) = ty) ->
      (type_term sigma pi (Tvar v) ty)
  | Type_deref : forall (sigma:(map.Map.map mident datatype))
      (pi:(list (ident* datatype)%type)) (v:mident) (ty:datatype),
      ((map.Map.get sigma v) = ty) -> (type_term sigma pi (Tderef v) ty)
  | Type_bin : forall (sigma:(map.Map.map mident datatype)) (pi:(list (ident*
      datatype)%type)) (t1:term) (t2:term) (op:operator) (ty1:datatype)
      (ty2:datatype) (ty:datatype), ((type_term sigma pi t1 ty1) /\
      ((type_term sigma pi t2 ty2) /\ (type_operator op ty1 ty2 ty))) ->
      (type_term sigma pi (Tbin t1 op t2) ty).

(* Why3 assumption *)
Inductive type_fmla: (map.Map.map mident datatype) -> (list (ident*
  datatype)%type) -> fmla -> Prop :=
  | Type_term : forall (sigma:(map.Map.map mident datatype))
      (pi:(list (ident* datatype)%type)) (t:term), (type_term sigma pi t
      TYbool) -> (type_fmla sigma pi (Fterm t))
  | Type_conj : forall (sigma:(map.Map.map mident datatype))
      (pi:(list (ident* datatype)%type)) (f1:fmla) (f2:fmla), ((type_fmla
      sigma pi f1) /\ (type_fmla sigma pi f2)) -> (type_fmla sigma pi
      (Fand f1 f2))
  | Type_neg : forall (sigma:(map.Map.map mident datatype)) (pi:(list (ident*
      datatype)%type)) (f:fmla), (type_fmla sigma pi f) -> (type_fmla sigma
      pi (Fnot f))
  | Type_implies : forall (sigma:(map.Map.map mident datatype))
      (pi:(list (ident* datatype)%type)) (f1:fmla) (f2:fmla), (type_fmla
      sigma pi f1) -> ((type_fmla sigma pi f2) -> (type_fmla sigma pi
      (Fimplies f1 f2)))
  | Type_let : forall (sigma:(map.Map.map mident datatype)) (pi:(list (ident*
      datatype)%type)) (x:ident) (t:term) (f:fmla) (ty:datatype), (type_term
      sigma pi t ty) -> ((type_fmla sigma (Init.Datatypes.cons (x, ty) pi)
      f) -> (type_fmla sigma pi (Flet x t f)))
  | Type_forall : forall (sigma:(map.Map.map mident datatype))
      (pi:(list (ident* datatype)%type)) (x:ident) (f:fmla) (ty:datatype),
      (type_fmla sigma (Init.Datatypes.cons (x, ty) pi) f) -> (type_fmla
      sigma pi (Fforall x ty f)).

(* Why3 assumption *)
Inductive type_stmt: (map.Map.map mident datatype) -> (list (ident*
  datatype)%type) -> stmt -> Prop :=
  | Type_skip : forall (sigma:(map.Map.map mident datatype))
      (pi:(list (ident* datatype)%type)), (type_stmt sigma pi Sskip)
  | Type_seq : forall (sigma:(map.Map.map mident datatype)) (pi:(list (ident*
      datatype)%type)) (s1:stmt) (s2:stmt), (type_stmt sigma pi s1) ->
      ((type_stmt sigma pi s2) -> (type_stmt sigma pi (Sseq s1 s2)))
  | Type_assigns : forall (sigma:(map.Map.map mident datatype))
      (pi:(list (ident* datatype)%type)) (x:mident) (t:term) (ty:datatype),
      ((map.Map.get sigma x) = ty) -> ((type_term sigma pi t ty) ->
      (type_stmt sigma pi (Sassign x t)))
  | Type_if : forall (sigma:(map.Map.map mident datatype)) (pi:(list (ident*
      datatype)%type)) (t:term) (s1:stmt) (s2:stmt), (type_term sigma pi t
      TYbool) -> ((type_stmt sigma pi s1) -> ((type_stmt sigma pi s2) ->
      (type_stmt sigma pi (Sif t s1 s2))))
  | Type_assert : forall (sigma:(map.Map.map mident datatype))
      (pi:(list (ident* datatype)%type)) (p:fmla), (type_fmla sigma pi p) ->
      (type_stmt sigma pi (Sassert p))
  | Type_while : forall (sigma:(map.Map.map mident datatype))
      (pi:(list (ident* datatype)%type)) (cond:term) (body:stmt) (inv:fmla),
      (type_fmla sigma pi inv) -> ((type_term sigma pi cond TYbool) ->
      ((type_stmt sigma pi body) -> (type_stmt sigma pi (Swhile cond inv
      body)))).

(* Why3 assumption *)
Definition compatible_env (sigma:(map.Map.map mident value))
  (sigmat:(map.Map.map mident datatype)) (pi:(list (ident* value)%type))
  (pit:(list (ident* datatype)%type)): Prop := (forall (id:mident),
  ((type_value (map.Map.get sigma id)) = (map.Map.get sigmat id))) /\
  forall (id:ident), ((type_value (get_stack id pi)) = (get_vartype id pit)).

Axiom type_inversion : forall (v:value),
  match (type_value v) with
  | TYbool => exists b:bool, (v = (Vbool b))
  | TYint => exists n:Z, (v = (Vint n))
  | TYunit => (v = Vvoid)
  end.

Axiom eval_type_term : forall (t:term) (sigma:(map.Map.map mident value))
  (pi:(list (ident* value)%type)) (sigmat:(map.Map.map mident datatype))
  (pit:(list (ident* datatype)%type)) (ty:datatype), (compatible_env sigma
  sigmat pi pit) -> ((type_term sigmat pit t ty) ->
  ((type_value (eval_term sigma pi t)) = ty)).

Axiom type_preservation : forall (s1:stmt) (s2:stmt) (sigma1:(map.Map.map
  mident value)) (sigma2:(map.Map.map mident value)) (pi1:(list (ident*
  value)%type)) (pi2:(list (ident* value)%type)) (sigmat:(map.Map.map mident
  datatype)) (pit:(list (ident* datatype)%type)), ((type_stmt sigmat pit
  s1) /\ ((compatible_env sigma1 sigmat pi1 pit) /\ (one_step sigma1 pi1 s1
  sigma2 pi2 s2))) -> ((type_stmt sigmat pit s2) /\ (compatible_env sigma2
  sigmat pi2 pit)).

Axiom Cons_append : forall {a:Type} {a_WT:WhyType a}, forall (a1:a)
  (l1:(list a)) (l2:(list a)),
  ((Init.Datatypes.cons a1 (Init.Datatypes.app l1 l2)) = (Init.Datatypes.app (Init.Datatypes.cons a1 l1) l2)).

Axiom Append_nil_l : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a)),
  ((Init.Datatypes.app Init.Datatypes.nil l) = l).

Parameter msubst_term: term -> mident -> ident -> term.

Axiom msubst_term_def : forall (t:term) (x:mident) (v:ident),
  match t with
  | ((Tvalue _)|(Tvar _)) => ((msubst_term t x v) = t)
  | (Tderef y) => ((x = y) -> ((msubst_term t x v) = (Tvar v))) /\
      ((~ (x = y)) -> ((msubst_term t x v) = t))
  | (Tbin t1 op t2) => ((msubst_term t x v) = (Tbin (msubst_term t1 x v) op
      (msubst_term t2 x v)))
  end.

(* Why3 assumption *)
Fixpoint msubst (f:fmla) (x:mident) (v:ident) {struct f}: fmla :=
  match f with
  | (Fterm e) => (Fterm (msubst_term e x v))
  | (Fand f1 f2) => (Fand (msubst f1 x v) (msubst f2 x v))
  | (Fnot f1) => (Fnot (msubst f1 x v))
  | (Fimplies f1 f2) => (Fimplies (msubst f1 x v) (msubst f2 x v))
  | (Flet y t f1) => (Flet y (msubst_term t x v) (msubst f1 x v))
  | (Fforall y ty f1) => (Fforall y ty (msubst f1 x v))
  end.

(* Why3 assumption *)
Fixpoint fresh_in_term (id:ident) (t:term) {struct t}: Prop :=
  match t with
  | ((Tvalue _)|(Tderef _)) => True
  | (Tvar i) => ~ (id = i)
  | (Tbin t1 _ t2) => (fresh_in_term id t1) /\ (fresh_in_term id t2)
  end.

(* Why3 assumption *)
Fixpoint fresh_in_fmla (id:ident) (f:fmla) {struct f}: Prop :=
  match f with
  | (Fterm e) => (fresh_in_term id e)
  | ((Fand f1 f2)|(Fimplies f1 f2)) => (fresh_in_fmla id f1) /\
      (fresh_in_fmla id f2)
  | (Fnot f1) => (fresh_in_fmla id f1)
  | (Flet y t f1) => (~ (id = y)) /\ ((fresh_in_term id t) /\ (fresh_in_fmla
      id f1))
  | (Fforall y _ f1) => (~ (id = y)) /\ (fresh_in_fmla id f1)
  end.

Axiom eval_msubst_term : forall (e:term) (sigma:(map.Map.map mident value))
  (pi:(list (ident* value)%type)) (x:mident) (v:ident), (fresh_in_term v
  e) -> ((eval_term sigma pi (msubst_term e x
  v)) = (eval_term (map.Map.set sigma x (get_stack v pi)) pi e)).

Axiom eval_msubst : forall (f:fmla) (sigma:(map.Map.map mident value))
  (pi:(list (ident* value)%type)) (x:mident) (v:ident), (fresh_in_fmla v
  f) -> ((eval_fmla sigma pi (msubst f x v)) <-> (eval_fmla
  (map.Map.set sigma x (get_stack v pi)) pi f)).

Axiom eval_swap_term : forall (t:term) (sigma:(map.Map.map mident value))
  (pi:(list (ident* value)%type)) (l:(list (ident* value)%type)) (id1:ident)
  (id2:ident) (v1:value) (v2:value), (~ (id1 = id2)) -> ((eval_term sigma
  (Init.Datatypes.app l (Init.Datatypes.cons (id1, v1) (Init.Datatypes.cons (
  id2, v2) pi))) t) = (eval_term sigma
  (Init.Datatypes.app l (Init.Datatypes.cons (id2, v2) (Init.Datatypes.cons (
  id1, v1) pi))) t)).

Axiom eval_swap_gen : forall (f:fmla) (sigma:(map.Map.map mident value))
  (pi:(list (ident* value)%type)) (l:(list (ident* value)%type)) (id1:ident)
  (id2:ident) (v1:value) (v2:value), (~ (id1 = id2)) -> ((eval_fmla sigma
  (Init.Datatypes.app l (Init.Datatypes.cons (id1, v1) (Init.Datatypes.cons (
  id2, v2) pi))) f) <-> (eval_fmla sigma
  (Init.Datatypes.app l (Init.Datatypes.cons (id2, v2) (Init.Datatypes.cons (
  id1, v1) pi))) f)).

Axiom eval_swap : forall (f:fmla) (sigma:(map.Map.map mident value))
  (pi:(list (ident* value)%type)) (id1:ident) (id2:ident) (v1:value)
  (v2:value), (~ (id1 = id2)) -> ((eval_fmla sigma (Init.Datatypes.cons (id1,
  v1) (Init.Datatypes.cons (id2, v2) pi)) f) <-> (eval_fmla sigma
  (Init.Datatypes.cons (id2, v2) (Init.Datatypes.cons (id1, v1) pi)) f)).

Axiom eval_term_change_free : forall (t:term) (sigma:(map.Map.map mident
  value)) (pi:(list (ident* value)%type)) (id:ident) (v:value),
  (fresh_in_term id t) -> ((eval_term sigma (Init.Datatypes.cons (id, v) pi)
  t) = (eval_term sigma pi t)).

Axiom eval_change_free : forall (f:fmla) (sigma:(map.Map.map mident value))
  (pi:(list (ident* value)%type)) (id:ident) (v:value), (fresh_in_fmla id
  f) -> ((eval_fmla sigma (Init.Datatypes.cons (id, v) pi) f) <-> (eval_fmla
  sigma pi f)).

Parameter fresh_from: fmla -> ident.

Axiom fresh_from_fmla : forall (f:fmla), (fresh_in_fmla (fresh_from f) f).

Parameter abstract_effects: stmt -> fmla -> fmla.

Axiom abstract_effects_specialize : forall (sigma:(map.Map.map mident value))
  (pi:(list (ident* value)%type)) (s:stmt) (f:fmla), (eval_fmla sigma pi
  (abstract_effects s f)) -> (eval_fmla sigma pi f).

Axiom abstract_effects_distrib_conj : forall (s:stmt) (p:fmla) (q:fmla)
  (sigma:(map.Map.map mident value)) (pi:(list (ident* value)%type)),
  ((eval_fmla sigma pi (abstract_effects s p)) /\ (eval_fmla sigma pi
  (abstract_effects s q))) -> (eval_fmla sigma pi (abstract_effects s (Fand p
  q))).

Axiom abstract_effects_monotonic : forall (s:stmt) (p:fmla) (q:fmla),
  (valid_fmla (Fimplies p q)) -> forall (sigma:(map.Map.map mident value))
  (pi:(list (ident* value)%type)), (eval_fmla sigma pi (abstract_effects s
  p)) -> (eval_fmla sigma pi (abstract_effects s q)).

(* Why3 assumption *)
Fixpoint wp (s:stmt) (q:fmla) {struct s}: fmla :=
  match s with
  | Sskip => q
  | (Sassert f) => (Fand f (Fimplies f q))
  | (Sseq s1 s2) => (wp s1 (wp s2 q))
  | (Sassign x t) => let id := (fresh_from q) in (Flet id t (msubst q x id))
  | (Sif t s1 s2) => (Fand (Fimplies (Fterm t) (wp s1 q))
      (Fimplies (Fnot (Fterm t)) (wp s2 q)))
  | (Swhile cond inv body) => (Fand inv (abstract_effects body
      (Fand (Fimplies (Fand (Fterm cond) inv) (wp body inv))
      (Fimplies (Fand (Fnot (Fterm cond)) inv) q))))
  end.

Axiom abstract_effects_writes : forall (sigma:(map.Map.map mident value))
  (pi:(list (ident* value)%type)) (body:stmt) (cond:term) (inv:fmla)
  (q:fmla), let f := (abstract_effects body
  (Fand (Fimplies (Fand (Fterm cond) inv) (wp body inv))
  (Fimplies (Fand (Fnot (Fterm cond)) inv) q))) in ((eval_fmla sigma pi f) ->
  (eval_fmla sigma pi (wp body f))).

(* Why3 goal *)
Theorem monotonicity : forall (s:stmt), forall (x:term) (x1:fmla) (x2:stmt),
  (s = (Swhile x x1 x2)) -> ((forall (p:fmla) (q:fmla), (valid_fmla
  (Fimplies p q)) -> (valid_fmla (Fimplies (wp x2 p) (wp x2 q)))) ->
  forall (p:fmla) (q:fmla), (valid_fmla (Fimplies p q)) -> (valid_fmla
  (Fimplies (wp s p) (wp s q)))).
(* Why3 intros s x x1 x2 h1 h2 p q h3. *)
intros s x x1 x2 H_;rewrite H_ in *.
unfold valid_fmla; simpl.
intros H1 p q H2; intuition.
apply abstract_effects_monotonic with (2:=H3).
unfold valid_fmla; simpl.
intuition.
Qed.

