csphinxtools.librarydescription
Library
q )q}q(X   nameqX   wx.svg-4.2.1qX   kindqK X   docsqX  The classes in this package facilitate the parsing, normalizing, drawing and
rasterizing of Scalable Vector Graphics (SVG) images. The primary interface to
this functionality is via the :class:`wx.svg.SVGimage` class, which provides
various integrations with wxPython. It, in turn, uses a set of wrappers around
the NanoSVG library (https://github.com/memononen/nanosvg) to do the low-level
work. There are a few features defined in the SVG spec that are not supported,
but all the commonly used ones seem to be there.

Example 1
---------
Drawing an SVG image to a window, scaled to fit the size of the window and using
a :class:`wx.GraphicsContext` can be done like this::

    def __init__(self, ...):
        ...
        self.img = wx.svg.SVGimage.CreateFromFile(svg_filename)
        self.Bind(wx.EVT_PAINT, self.OnPaint)

    def OnPaint(self, event):
        dc = wx.PaintDC(self)
        dc.SetBackground(wx.Brush('white'))
        dc.Clear()

        dcdim = min(self.Size.width, self.Size.height)
        imgdim = min(self.img.width, self.img.height)
        scale = dcdim / imgdim
        width = int(self.img.width * scale)
        height = int(self.img.height * scale)

        ctx = wx.GraphicsContext.Create(dc)
        self.img.RenderToGC(ctx, scale)

Since it is drawing the SVG shapes and paths using the equivalent GC primitives
then any existing transformations that may be active on the context will be
applied automatically to the SVG shapes.

Note that not all GraphicsContext backends are created equal. Specifically, the
GDI+ backend (the default on Windows) simply can not support some features that
are commonly used in SVG images, such as applying transforms to gradients. The
Direct2D backend on Windows does much better, and the Cairo backend on Windows
is also very good. The default backends on OSX and Linux do very good as well.

Example 2
---------
If you're not already using a ``wx.GraphicsContext`` then a :class:`wx.Bitmap`
can easily be created instead. For example, the last 2 lines in the code above
could be replaced by the following, and accomplish basically the same thing::

    bmp = self.img.ConvertToBitmap(scale=scale, width=width, height=height)
    dc.DrawBitmap(bmp, 0, 0)

Example 3
---------
The ``ConvertToBitmap`` shown above gives a lot of control around scaling,
translating and sizing the SVG image into a bitmap, but most of the time you
probably just want to get a bitmap of a certain size to use as an icon or
similar. The ``ConvertToScaledBitmap`` provides an easier API to do just that
for you. It automatically scales the SVG image into the requested size in
pixels.::

    bmp = img.ConvertToScaledBitmap(wx.Size(24,24))

Optionally, it can accept a window parameter that will automatically adjust the
size according to the Content Scale Factor of that window, if supported by the
platform and if the window is located on a HiDPI display the the bitmap's size
will be adjusted accordingly.::

    bmp = img.ConvertToScaledBitmap(wx.Size(24,24), self)qX   commentsqX  #----------------------------------------------------------------------
# Name:        wx.svg.__init__.py
# Purpose:     Python code to augment or extend the nanosvg wrappers,
#              and provide wxPython-specific integrations.
#
# Author:      Robin Dunn
#
# Created:     23-July-2019
# Copyright:   (c) 2019-2020 by Total Control Software
# Licence:     wxWindows license
#----------------------------------------------------------------------
q	X   is_redundantq
X   childrenq]q(csphinxtools.librarydescription
Module
q
)q}q(hX   wx.svg._nanosvgqhKhX  NanoSVG is a "simple stupid single-header-file SVG parser" from
https://github.com/memononen/nanosvg. The output of the parser is a collection
of data structures representing cubic bezier shapes.

NanoSVG supports a wide range of SVG features. The library is well suited for
anything from rendering scalable icons in your editor application to prototyping
a game. There is not a full coverage of the SVG specification, however the
features needed for typical icons or even more advanced vector images are
present.

The shapes in the SVG images are transformed by the viewBox and converted to
specified units. That is, you should get the same looking data as you designed
in your favorite app.

NanoSVG can return the paths in few different units. For example if you want to
render an image, you may choose to get the paths in pixels, or if you are
feeding the data into a CNC-cutter, you may want to use millimeters.

The units passed to NanoSVG should be one of: 'px', 'pt', 'pc' 'mm', 'cm', or
'in'. DPI (dots-per-inch) controls how the unit conversion is done.

If you don't know or care about the units stuff, "px" and 96 should get you
going.

This module implements a Cython-based wrapper for the NanoSVG code, providing
access to the parsed SVG data as a nested collection of objects and properties.
Note that these classes are essentially read-only. There is no support (yet?)
for manipulating the SVG shape info in memory.qhX    qh
h]q(csphinxtools.librarydescription
Class
q)q}q(hX   wx.svg._nanosvg.SVGfillRuleqhKhX   An enumeration.qhhh
h]q(csphinxtools.librarydescription
Attribute
q)q}q(hX0   wx.svg._nanosvg.SVGfillRule.SVG_FILLRULE_EVENODDqhK$X   orderqKhhhhh
X   valueqX%   <SVGfillRule.SVG_FILLRULE_EVENODD: 1>q X   specsq!X   SVGfillRuleq"X   obj_typeq#X	   Attributeq$X   parentq%hubh)q&}q'(hX0   wx.svg._nanosvg.SVGfillRule.SVG_FILLRULE_NONZEROq(hK$hKhhhhh
hX%   <SVGfillRule.SVG_FILLRULE_NONZERO: 0>q)h!X   SVGfillRuleq*h#h$h%hubeX
   class_treeq+]q,(]q-X   objectq.a]q/(]q0X   intq1a]q2(]q3X   IntEnumq4a]q5]q6X   SVGfillRuleq7aae]q8X   Enumq9a]q:(]q;h4a]q<]q=h7aaeeeX
   subClassesq>]q?X   superClassesq@]qAX
   <enum IntEnumqBaX	   signatureqCX   SVGfillRule(<enum IntEnum)qDX   inheritance_diagramqENhKh#X   ClassqFX   sphinx_fileqGXN   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGfillRule.txtqHh%hubh)qI}qJ(hX   wx.svg._nanosvg.SVGflagsqKhKhhhhh
h]qLh)qM}qN(hX*   wx.svg._nanosvg.SVGflags.SVG_FLAGS_VISIBLEqOhK$hKhhhhh
hX   <SVGflags.SVG_FLAGS_VISIBLE: 1>qPh!X   SVGflagsqQh#h$h%hIubah+]qR(]qSX   objectqTa]qU(]qVX   intqWa]qX(]qYh4a]qZ]q[X   SVGflagsq\aae]q]h9a]q^(]q_h4a]q`]qah\aaeeeh>]qbh@]qcX
   <enum IntEnumqdahCX   SVGflags(<enum IntEnum)qehENhKh#hFhGXK   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGflags.txtqfh%hubh)qg}qh(hX   wx.svg._nanosvg.SVGgradientqihKhX[   A gradient is a method used to fade from one color to another, either
linearly or radially.qjhhh
h]qk(csphinxtools.librarydescription
Property
ql)qm}qn(hX   wx.svg._nanosvg.SVGgradient.fxqohKhKhhhhh
X   getterqphX   setterqqhX   deleterqrhh#X   Propertyqsh%hgubhl)qt}qu(hX   wx.svg._nanosvg.SVGgradient.fyqvhKhKhhhhh
hphhqhhrhh#hsh%hgubhl)qw}qx(hX"   wx.svg._nanosvg.SVGgradient.spreadqyhKhKhhhhh
hphhqhhrhh#hsh%hgubhl)qz}q{(hX!   wx.svg._nanosvg.SVGgradient.stopsq|hKhKhX`   A generator that iterates over the :class:`SVGgradientStop` objects contained in the SVGgradientq}hhh
hphhqhhrhh#hsh%hgubhl)q~}q(hX!   wx.svg._nanosvg.SVGgradient.xformqhKhKhX   The gradient's transformqhhh
hphhqhhrhh#hsh%hgubeh+]q(]qX   objectqa]q]qX   SVGgradientqaaeh>]qh@]qhCX   SVGgradient(object)qhEcsphinxtools.inheritance
InheritanceDiagram
q)q}q(X
   class_infoq]qX   wx.svg._nanosvg.SVGgradientq]qqaX   specialsq]qX   wx.svg._nanosvg.SVGgradientqaX
   main_classqhgubhKh#hFhGXN   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGgradient.txtqh%hX   method_listq]qX   basesqhubh)q}q(hX   wx.svg._nanosvg.SVGgradientStopqhKhXO   A Gradient stop is an offset and a color, which is used when drawing gradients.qhhh
h]q(hl)q}q(hX%   wx.svg._nanosvg.SVGgradientStop.colorqhKhKhhhhh
hphhqhhrhh#hsh%hubhl)q}q(hX*   wx.svg._nanosvg.SVGgradientStop.color_rgbaqhKhKhX   Returns color as a RGBA tuple qhhh
hphhqhhrhh#hsh%hubhl)q}q(hX&   wx.svg._nanosvg.SVGgradientStop.offsetqhKhKhhhhh
hphhqhhrhh#hsh%hubeh+]q(]qX   objectqa]q]qX   SVGgradientStopqaaeh>]qh@]qhCX   SVGgradientStop(object)qhEh)q}q(h]qX   wx.svg._nanosvg.SVGgradientStopq]qqah]qX   wx.svg._nanosvg.SVGgradientStopqahhubhKh#hFhGXR   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGgradientStop.txtqh%hh]qhhubh)q}q(hX   wx.svg._nanosvg.SVGimageBaseqhKhX  A SVGimageBase can be created either from an SVG file or from an in-memory
buffer containing the SVG XML code. The result is a collection of cubic
bezier shapes, with fill, stroke, gradients, paths and other information.

This class is a Cython-based wrapper around the nanosvg ``NSVGimage`` structure,
providing just the basic wrapped functionality from nanosvg. Please see the
:class:`wx.svg.SVGimage` class for a derived implementation that adds
functionality for integrating with wxPython.qhhh
h]q(csphinxtools.librarydescription
Method
q)q}q(hX,   wx.svg._nanosvg.SVGimageBase.CreateFromBytesqhK
hKhXo  Loads an SVG image from a bytes object.

:param bytes `buffer`: object containing the SVG data
:param str `units`: One of: 'px', 'pt', 'pc' 'mm', 'cm', or 'in'
:param float `dpi`: controls how the unit conversion is done
:param bool `do_copy`: indicates if the given bytes object should be
    copied to avoid in-place modification. This should be set to True
    if the given `buffer` object may ever be reused in any capacity.
    If the given `buffer` will only be used once, and the cost of copying
    it is problematic, then `do_copy` can be set to False.

:rtype: An instance of ``cls`` (usually a :class:`SVGimage`)qhhh
X	   argumentsq]qhCXX   CreateFromBytes(type cls, bytes buffer, str units='px', float dpi=96, bool do_copy=True)qh#X   Method/Functionqh%hubh)q}q(hX+   wx.svg._nanosvg.SVGimageBase.CreateFromFileqhK
hKhX  Loads an SVG image from a file.

:param str `filename`: Name of the file to load the SVG image from
:param str `units`: One of: 'px', 'pt', 'pc' 'mm', 'cm', or 'in'
:param float `dpi`: controls how the unit conversion is done

:rtype: An instance of ``cls`` (usually a :class:`SVGimage`)qhhh
h]qhCXD   CreateFromFile(type cls, str filename, str units='px', float dpi=96)qh#hh%hubh)q}q(hX&   wx.svg._nanosvg.SVGimageBase.RasterizeqhKhKhXL  Renders the SVG image to a ``bytes`` object as a series of RGBA values.

:param float `tx`: Image horizontal offset (applied after scaling)
:param float `ty`: Image vertical offset (applied after scaling)
:param float `scale`: Image scale
:param int `width`: width of the image to render, defaults to width from the SVG file
:param int `height`: height of the image to render, defaults to height from the SVG file
:param int `stride`: number of bytes per scan line in the destination buffer, typically ``width * 4``

:returns: A bytearray object containing the raw RGBA pixel color valuesqhhh
h]qhCXq   Rasterize(self, float tx=0.0, float ty=0.0, float scale=1.0, int width=-1, int height=-1, int stride=-1) -> bytesqh#hh%hubh)q}q(hX.   wx.svg._nanosvg.SVGimageBase.RasterizeToBufferqhKhKhX  Renders the SVG image to an existing buffer as a series of RGBA values.

The buffer object must support the Python buffer-protocol, be writable,
and be at least ``width * height * 4`` bytes long. Possibilities include
bytearrays, memoryviews, numpy arrays, etc.

:param `buf`: An object supporting the buffer protocol where the RGBA bytes will be written
:param float `tx`: Image horizontal offset (applied after scaling)
:param float `ty`: Image vertical offset (applied after scaling)
:param float `scale`: Image scale
:param int `width`: width of the image to render, defaults to width from the SVG file
:param int `height`: height of the image to render, defaults to height from the SVG file
:param int `stride`: number of bytes per scan line in the destination buffer, typically ``width * 4``qhhh
h]qhCX~   RasterizeToBuffer(self, buf, float tx=0.0, float ty=0.0, float scale=1.0, int width=-1, int height=-1, int stride=-1) -> bytesqh#hh%hubhl)q}q(hX#   wx.svg._nanosvg.SVGimageBase.heightqhKhKhX#   Returns the height of the SVG imageqhhh
hphhqhhrhh#hsh%hubhl)q}q(hX#   wx.svg._nanosvg.SVGimageBase.shapesqhKhKhXX   A generator that iterates over the :class:`SVGshape` objects that comprise the SVG imageqhhh
hphhqhhrhh#hsh%hubhl)q}q(hX"   wx.svg._nanosvg.SVGimageBase.widthqhKhKhX"   Returns the width of the SVG imageqhhh
hphhqhhrhh#hsh%hubeh+]q(]qX   objectqa]q]qX   SVGimageBaseqaaeh>]qX   wx.svg.SVGimageqah@]qhCX   SVGimageBase(object)qhEh)q}q(h]qX   wx.svg._nanosvg.SVGimageBaseq]qqah]qX   wx.svg._nanosvg.SVGimageBaseqahhubhKh#hFhGXO   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGimageBase.txtqh%hh]q(X   CreateFromBytesqX   CreateFromFileqX	   RasterizeqX   RasterizeToBufferr   ehhubh)r  }r  (hX   wx.svg._nanosvg.SVGlineCapr  hKhhhhh
h]r  (h)r  }r  (hX'   wx.svg._nanosvg.SVGlineCap.SVG_CAP_BUTTr  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_BUTT: 0>r  h!X
   SVGlineCapr	  h#h$h%j  ubh)r
  }r  (hX(   wx.svg._nanosvg.SVGlineCap.SVG_CAP_ROUNDr  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_ROUND: 1>r
  h!X
   SVGlineCapr  h#h$h%j  ubh)r  }r  (hX)   wx.svg._nanosvg.SVGlineCap.SVG_CAP_SQUAREr  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_SQUARE: 2>r  h!X
   SVGlineCapr  h#h$h%j  ubeh+]r  (]r  X   objectr  a]r  (]r  X   intr  a]r  (]r  h4a]r  ]r  X
   SVGlineCapr  aae]r  h9a]r   (]r!  h4a]r"  ]r#  j  aaeeeh>]r$  h@]r%  X
   <enum IntEnumr&  ahCX   SVGlineCap(<enum IntEnum)r'  hENhKh#hFhGXM   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGlineCap.txtr(  h%hubh)r)  }r*  (hX   wx.svg._nanosvg.SVGlineJoinr+  hKhhhhh
h]r,  (h)r-  }r.  (hX*   wx.svg._nanosvg.SVGlineJoin.SVG_JOIN_BEVELr/  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_BEVEL: 2>r0  h!X   SVGlineJoinr1  h#h$h%j)  ubh)r2  }r3  (hX*   wx.svg._nanosvg.SVGlineJoin.SVG_JOIN_MITERr4  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_MITER: 0>r5  h!X   SVGlineJoinr6  h#h$h%j)  ubh)r7  }r8  (hX*   wx.svg._nanosvg.SVGlineJoin.SVG_JOIN_ROUNDr9  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_ROUND: 1>r:  h!X   SVGlineJoinr;  h#h$h%j)  ubeh+]r<  (]r=  X   objectr>  a]r?  (]r@  X   intrA  a]rB  (]rC  h4a]rD  ]rE  X   SVGlineJoinrF  aae]rG  h9a]rH  (]rI  h4a]rJ  ]rK  jF  aaeeeh>]rL  h@]rM  X
   <enum IntEnumrN  ahCX   SVGlineJoin(<enum IntEnum)rO  hENhKh#hFhGXN   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGlineJoin.txtrP  h%hubh)rQ  }rR  (hX   wx.svg._nanosvg.SVGpaintrS  hKhX   This class defines how to fill or stroke a shape when rendering the SVG
image. In other words, how to create the pen or brush. It can be a solid
color, linear or radial gradients, etc.rT  hhh
h]rU  (hl)rV  }rW  (hX   wx.svg._nanosvg.SVGpaint.colorrX  hKhKhhhhh
hphhqhhrhh#hsh%jQ  ubhl)rY  }rZ  (hX#   wx.svg._nanosvg.SVGpaint.color_rgbar[  hKhKhX   Returns color as a RGBA tupler\  hhh
hphhqhhrhh#hsh%jQ  ubhl)r]  }r^  (hX!   wx.svg._nanosvg.SVGpaint.gradientr_  hKhKhhhhh
hphhqhhrhh#hsh%jQ  ubhl)r`  }ra  (hX   wx.svg._nanosvg.SVGpaint.typerb  hKhKhXG   Flag indicating the type of paint info, solid color or type of gradientrc  hhh
hphhqhhrhh#hsh%jQ  ubeh+]rd  (]re  X   objectrf  a]rg  ]rh  X   SVGpaintri  aaeh>]rj  h@]rk  hCX   SVGpaint(object)rl  hEh)rm  }rn  (h]ro  X   wx.svg._nanosvg.SVGpaintrp  ]rq  rr  ah]rs  X   wx.svg._nanosvg.SVGpaintrt  ahjQ  ubhKh#hFhGXK   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGpaint.txtru  h%hh]rv  hjk  ubh)rw  }rx  (hX   wx.svg._nanosvg.SVGpaintTypery  hKhhhhh
h]rz  (h)r{  }r|  (hX,   wx.svg._nanosvg.SVGpaintType.SVG_PAINT_COLORr}  hK$hKhhhhh
hX!   <SVGpaintType.SVG_PAINT_COLOR: 1>r~  h!X   SVGpaintTyper  h#h$h%jw  ubh)r  }r  (hX6   wx.svg._nanosvg.SVGpaintType.SVG_PAINT_LINEAR_GRADIENTr  hK$hKhhhhh
hX+   <SVGpaintType.SVG_PAINT_LINEAR_GRADIENT: 2>r  h!X   SVGpaintTyper  h#h$h%jw  ubh)r  }r  (hX+   wx.svg._nanosvg.SVGpaintType.SVG_PAINT_NONEr  hK$hKhhhhh
hX    <SVGpaintType.SVG_PAINT_NONE: 0>r  h!X   SVGpaintTyper  h#h$h%jw  ubh)r  }r  (hX6   wx.svg._nanosvg.SVGpaintType.SVG_PAINT_RADIAL_GRADIENTr  hK$hKhhhhh
hX+   <SVGpaintType.SVG_PAINT_RADIAL_GRADIENT: 3>r  h!X   SVGpaintTyper  h#h$h%jw  ubeh+]r  (]r  X   objectr  a]r  (]r  X   intr  a]r  (]r  h4a]r  ]r  X   SVGpaintTyper  aae]r  h9a]r  (]r  h4a]r  ]r  j  aaeeeh>]r  h@]r  X
   <enum IntEnumr  ahCX   SVGpaintType(<enum IntEnum)r  hENhKh#hFhGXO   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGpaintType.txtr  h%hubh)r  }r  (hX   wx.svg._nanosvg.SVGpathr  hKhX   An SVGpath is essentially just a collection of bezier curves, defined by a
set of floating point coordinates. A collection of SVGpaths is accessible
from the `paths` attribute of SVGshape.r  hhh
h]r  (hl)r  }r  (hX   wx.svg._nanosvg.SVGpath.boundsr  hKhKhX5   Tight bounding box of the shape [minx,miny,maxx,maxy]r  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGpath.closedr  hKhKhX5   Flag indicating if shapes should be treated as closedr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGpath.maxxr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGpath.maxyr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGpath.minxr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGpath.minyr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGpath.nptsr  hKhKhX   Number of pointsr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGpath.pointsr  hKhKhX   Cubic bezier points: (x0,y0), [(cpx1,cpx1), (cpx2,cpy2), (x1,y1)], ...
The return value is a list of tuples, each containing an x-y pair.r  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGpath.ptsr  hKhKhXb   Cubic bezier points: x0,y0, [cpx1,cpx1,cpx2,cpy2,x1,y1], ...
The return value is a list of floats.r  hhh
hphhqhhrhh#hsh%j  ubeh+]r  (]r  X   objectr  a]r  ]r  X   SVGpathr  aaeh>]r  h@]r  hCX   SVGpath(object)r  hEh)r  }r  (h]r  X   wx.svg._nanosvg.SVGpathr  ]r  r  ah]r  X   wx.svg._nanosvg.SVGpathr  ahj  ubhKh#hFhGXJ   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGpath.txtr  h%hh]r  hj  ubh)r  }r  (hX   wx.svg._nanosvg.SVGshaper  hKhX   SVGshape is a set of attributes describing how to draw one shape in the SVG,
including stroke and fill styles, line styles, and paths. A collection of
SVGshapes is accessible from the ``shapes`` attribute of :class:`SVGimage`.r  hhh
h]r  (hl)r  }r  (hX   wx.svg._nanosvg.SVGshape.boundsr  hKhKhX5   Tight bounding box of the shape [minx,miny,maxx,maxy]r  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGshape.fillr  hKhKhX   :class:`SVGpaint` for the fillr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX!   wx.svg._nanosvg.SVGshape.fillRuler  hKhKhX	   Fill ruler  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGshape.flagsr  hKhKhX   Logical OR of SVG_FLAGS_* flagsr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGshape.idr  hKhKhX,   Optional 'id' attr of the shape or its groupr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGshape.maxxr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGshape.maxyr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGshape.minxr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg._nanosvg.SVGshape.minyr   hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX#   wx.svg._nanosvg.SVGshape.miterLimitr  hKhKhX   Miter limitr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX    wx.svg._nanosvg.SVGshape.opacityr  hKhKhX   Opacity of the shaper  hhh
hphhqhhrhh#hsh%j  ubhl)r	  }r
  (hX   wx.svg._nanosvg.SVGshape.pathsr  hKhKhXU   A generator that iterates over the :class:`SVGpath` objects contained in the SVGshaper  hhh
hphhqhhrhh#hsh%j  ubhl)r
  }r  (hX   wx.svg._nanosvg.SVGshape.stroker  hKhKhX    :class:`SVGpaint` for the stroker  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX(   wx.svg._nanosvg.SVGshape.strokeDashArrayr  hKhKhX   Stroke dash array (scaled)r  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX)   wx.svg._nanosvg.SVGshape.strokeDashOffsetr  hKhKhX   Stroke dash offset (scaled)r  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX&   wx.svg._nanosvg.SVGshape.strokeLineCapr  hKhKhX   Stroke cap typer  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX'   wx.svg._nanosvg.SVGshape.strokeLineJoinr  hKhKhX   Stroke join typer   hhh
hphhqhhrhh#hsh%j  ubhl)r!  }r"  (hX$   wx.svg._nanosvg.SVGshape.strokeWidthr#  hKhKhX   Stroke width (scaled)r$  hhh
hphhqhhrhh#hsh%j  ubeh+]r%  (]r&  X   objectr'  a]r(  ]r)  X   SVGshaper*  aaeh>]r+  h@]r,  hCX   SVGshape(object)r-  hEh)r.  }r/  (h]r0  X   wx.svg._nanosvg.SVGshaper1  ]r2  r3  ah]r4  X   wx.svg._nanosvg.SVGshaper5  ahj  ubhKh#hFhGXK   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGshape.txtr6  h%hh]r7  hj,  ubh)r8  }r9  (hX   wx.svg._nanosvg.SVGspreadTyper:  hKhhhhh
h]r;  (h)r<  }r=  (hX,   wx.svg._nanosvg.SVGspreadType.SVG_SPREAD_PADr>  hK$hKhhhhh
hX!   <SVGspreadType.SVG_SPREAD_PAD: 0>r?  h!X
   SVGspreadTyper@  h#h$h%j8  ubh)rA  }rB  (hX0   wx.svg._nanosvg.SVGspreadType.SVG_SPREAD_REFLECTrC  hK$hKhhhhh
hX%   <SVGspreadType.SVG_SPREAD_REFLECT: 1>rD  h!X
   SVGspreadTyperE  h#h$h%j8  ubh)rF  }rG  (hX/   wx.svg._nanosvg.SVGspreadType.SVG_SPREAD_REPEATrH  hK$hKhhhhh
hX$   <SVGspreadType.SVG_SPREAD_REPEAT: 2>rI  h!X
   SVGspreadTyperJ  h#h$h%j8  ubeh+]rK  (]rL  X   objectrM  a]rN  (]rO  X   intrP  a]rQ  (]rR  h4a]rS  ]rT  X
   SVGspreadTyperU  aae]rV  h9a]rW  (]rX  h4a]rY  ]rZ  jU  aaeeeh>]r[  h@]r\  X
   <enum IntEnumr]  ahCX   SVGspreadType(<enum IntEnum)r^  hENhKh#hFhGXP   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.SVGspreadType.txtr_  h%hubh)r`  }ra  (hX   wx.svg._nanosvg.__test__rb  hKhKhXr  dict() -> new empty dictionary
dict(mapping) -> new dictionary initialized from a mapping object's
    (key, value) pairs
dict(iterable) -> new dictionary initialized as if via:
    d = {}
    for k, v in iterable:
        d[k] = v
dict(**kwargs) -> new dictionary initialized with the name=value pairs
    in the keyword argument list.  For example:  dict(one=1, two=2)rc  hhh
hX   {}rd  h!X   dictre  h#h$h%hubh)rf  }rg  (hX   wx.svg._nanosvg.PY2rh  hKhKhX   bool(x) -> bool

Returns True when the argument x is true, False otherwise.
The builtins True and False are the only two instances of the class bool.
The class bool is a subclass of the class int, and cannot be subclassed.ri  hhh
hX   Falserj  h!X   boolrk  h#h$h%hubh)rl  }rm  (hX   wx.svg._nanosvg.SVG_CAP_BUTTrn  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_BUTT: 0>ro  h!X
   SVGlineCaprp  h#h$h%hubh)rq  }rr  (hX   wx.svg._nanosvg.SVG_CAP_ROUNDrs  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_ROUND: 1>rt  h!X
   SVGlineCapru  h#h$h%hubh)rv  }rw  (hX   wx.svg._nanosvg.SVG_CAP_SQUARErx  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_SQUARE: 2>ry  h!X
   SVGlineCaprz  h#h$h%hubh)r{  }r|  (hX$   wx.svg._nanosvg.SVG_FILLRULE_EVENODDr}  hK$hKhhhhh
hX%   <SVGfillRule.SVG_FILLRULE_EVENODD: 1>r~  h!X   SVGfillRuler  h#h$h%hubh)r  }r  (hX$   wx.svg._nanosvg.SVG_FILLRULE_NONZEROr  hK$hKhhhhh
hX%   <SVGfillRule.SVG_FILLRULE_NONZERO: 0>r  h!X   SVGfillRuler  h#h$h%hubh)r  }r  (hX!   wx.svg._nanosvg.SVG_FLAGS_VISIBLEr  hK$hKhhhhh
hX   <SVGflags.SVG_FLAGS_VISIBLE: 1>r  h!X   SVGflagsr  h#h$h%hubh)r  }r  (hX   wx.svg._nanosvg.SVG_JOIN_BEVELr  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_BEVEL: 2>r  h!X   SVGlineJoinr  h#h$h%hubh)r  }r  (hX   wx.svg._nanosvg.SVG_JOIN_MITERr  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_MITER: 0>r  h!X   SVGlineJoinr  h#h$h%hubh)r  }r  (hX   wx.svg._nanosvg.SVG_JOIN_ROUNDr  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_ROUND: 1>r  h!X   SVGlineJoinr  h#h$h%hubh)r  }r  (hX   wx.svg._nanosvg.SVG_PAINT_COLORr  hK$hKhhhhh
hX!   <SVGpaintType.SVG_PAINT_COLOR: 1>r  h!X   SVGpaintTyper  h#h$h%hubh)r  }r  (hX)   wx.svg._nanosvg.SVG_PAINT_LINEAR_GRADIENTr  hK$hKhhhhh
hX+   <SVGpaintType.SVG_PAINT_LINEAR_GRADIENT: 2>r  h!X   SVGpaintTyper  h#h$h%hubh)r  }r  (hX   wx.svg._nanosvg.SVG_PAINT_NONEr  hK$hKhhhhh
hX    <SVGpaintType.SVG_PAINT_NONE: 0>r  h!X   SVGpaintTyper  h#h$h%hubh)r  }r  (hX)   wx.svg._nanosvg.SVG_PAINT_RADIAL_GRADIENTr  hK$hKhhhhh
hX+   <SVGpaintType.SVG_PAINT_RADIAL_GRADIENT: 3>r  h!X   SVGpaintTyper  h#h$h%hubh)r  }r  (hX   wx.svg._nanosvg.SVG_SPREAD_PADr  hK$hKhhhhh
hX!   <SVGspreadType.SVG_SPREAD_PAD: 0>r  h!X
   SVGspreadTyper  h#h$h%hubh)r  }r  (hX"   wx.svg._nanosvg.SVG_SPREAD_REFLECTr  hK$hKhhhhh
hX%   <SVGspreadType.SVG_SPREAD_REFLECT: 1>r  h!X
   SVGspreadTyper  h#h$h%hubh)r  }r  (hX!   wx.svg._nanosvg.SVG_SPREAD_REPEATr  hK$hKhhhhh
hX$   <SVGspreadType.SVG_SPREAD_REPEAT: 2>r  h!X
   SVGspreadTyper  h#h$h%hubeX   filenamer  XR   /home/wxpy/bb2/dist-src-py37/build/wx/svg/_nanosvg.cpython-37m-x86_64-linux-gnu.sor  hGXB   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg._nanosvg.txtr  hKh#X
   Pyd_Moduler  hEh)r  }r  (h]r  (X   wx.svg._nanosvg.SVGgradientr  ]r  r  X   wx.svg._nanosvg.SVGgradientStopr  ]r  r  X   wx.svg._nanosvg.SVGimageBaser  ]r  r  X   wx.svg._nanosvg.SVGpaintr  ]r  r  X   wx.svg._nanosvg.SVGpathr  ]r  r  X   wx.svg._nanosvg.SVGshaper  ]r  r  eh]r  (X   wx.svg._nanosvg.SVGgradientr  X   wx.svg._nanosvg.SVGgradientStopr  X   wx.svg._nanosvg.SVGimageBaser  X   wx.svg._nanosvg.SVGpaintr  X   wx.svg._nanosvg.SVGpathr  X   wx.svg._nanosvg.SVGshaper  ehhubh%hubh)r  }r  (hX   wx.svg.SVGfillRuler  hKhhhhh
h]r  (h)r  }r  (hX'   wx.svg.SVGfillRule.SVG_FILLRULE_EVENODDr  hK$hKhhhhh
hX%   <SVGfillRule.SVG_FILLRULE_EVENODD: 1>r  h!X   SVGfillRuler  h#h$h%j  ubh)r  }r  (hX'   wx.svg.SVGfillRule.SVG_FILLRULE_NONZEROr  hK$hKhhhhh
hX%   <SVGfillRule.SVG_FILLRULE_NONZERO: 0>r  h!X   SVGfillRuler  h#h$h%j  ubeh+]r  (]r  X   objectr  a]r  (]r  X   intr  a]r  (]r  h4a]r  ]r  h7aae]r  h9a]r  (]r  h4a]r  ]r  h7aaeeeh>]r  h@]r  X
   <enum IntEnumr  ahCX   SVGfillRule(<enum IntEnum)r  hENhKh#hFhGXE   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGfillRule.txtr  h%hubh)r  }r  (hX   wx.svg.SVGflagsr   hKhhhhh
h]r  h)r  }r  (hX!   wx.svg.SVGflags.SVG_FLAGS_VISIBLEr  hK$hKhhhhh
hX   <SVGflags.SVG_FLAGS_VISIBLE: 1>r  h!X   SVGflagsr  h#h$h%j  ubah+]r  (]r  X   objectr	  a]r
  (]r  X   intr  a]r
  (]r  h4a]r  ]r  h\aae]r  h9a]r  (]r  h4a]r  ]r  h\aaeeeh>]r  h@]r  X
   <enum IntEnumr  ahCX   SVGflags(<enum IntEnum)r  hENhKh#hFhGXB   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGflags.txtr  h%hubh)r  }r  (hX   wx.svg.SVGgradientr  hKhX[   A gradient is a method used to fade from one color to another, either
linearly or radially.r  hhh
h]r  (hl)r   }r!  (hX   wx.svg.SVGgradient.fxr"  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r#  }r$  (hX   wx.svg.SVGgradient.fyr%  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r&  }r'  (hX   wx.svg.SVGgradient.spreadr(  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r)  }r*  (hX   wx.svg.SVGgradient.stopsr+  hKhKhX`   A generator that iterates over the :class:`SVGgradientStop` objects contained in the SVGgradientr,  hhh
hphhqhhrhh#hsh%j  ubhl)r-  }r.  (hX   wx.svg.SVGgradient.xformr/  hKhKhX   The gradient's transformr0  hhh
hphhqhhrhh#hsh%j  ubeh+]r1  (]r2  X   objectr3  a]r4  ]r5  X   SVGgradientr6  aaeh>]r7  h@]r8  hCX   SVGgradient(object)r9  hENhKh#hFhGXE   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGgradient.txtr:  h%hubh)r;  }r<  (hX   wx.svg.SVGgradientStopr=  hKhXO   A Gradient stop is an offset and a color, which is used when drawing gradients.r>  hhh
h]r?  (hl)r@  }rA  (hX   wx.svg.SVGgradientStop.colorrB  hKhKhhhhh
hphhqhhrhh#hsh%j;  ubhl)rC  }rD  (hX!   wx.svg.SVGgradientStop.color_rgbarE  hKhKhX   Returns color as a RGBA tuple rF  hhh
hphhqhhrhh#hsh%j;  ubhl)rG  }rH  (hX   wx.svg.SVGgradientStop.offsetrI  hKhKhhhhh
hphhqhhrhh#hsh%j;  ubeh+]rJ  (]rK  X   objectrL  a]rM  ]rN  X   SVGgradientStoprO  aaeh>]rP  h@]rQ  hCX   SVGgradientStop(object)rR  hENhKh#hFhGXI   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGgradientStop.txtrS  h%hubh)rT  }rU  (hX   wx.svg.SVGimagerV  hKhX]   The SVGimage class provides various ways to load and use SVG images
in wxPython applications.rW  hhh
h]rX  (h)rY  }rZ  (hX   wx.svg.SVGimage.ConvertToBitmapr[  hKhKhX(  Creates a :class:`wx.Bitmap` containing a rasterized version of the SVG image.

:param float `tx`: Image horizontal offset (applied after scaling)
:param float `ty`: Image vertical offset (applied after scaling)
:param float `scale`: Image scale
:param int `width`: width of the image to render, defaults to width from the SVG file
:param int `height`: height of the image to render, defaults to height from the SVG file
:param int `stride`: number of bytes per scan line in the destination buffer, typically ``width * 4``

:returns: :class:`wx.Bitmap`r\  hhh
h]r]  (X   txr^  X   0.0r_  X   0.0r`  ra  X   tyrb  X   0.0rc  X   0.0rd  re  X   scalerf  X   1.0rg  X   1.0rh  ri  X   widthrj  X   -1rk  X   -1rl  rm  X   heightrn  X   -1ro  X   -1rp  rq  X   striderr  X   -1rs  X   -1rt  ru  ehCXP   ConvertToBitmap(self, tx=0.0, ty=0.0, scale=1.0, width=-1, height=-1, stride=-1)rv  h#hX   number_linesrw  X   18rx  h%jT  ubh)ry  }rz  (hX%   wx.svg.SVGimage.ConvertToScaledBitmapr{  hKhKhXr  Automatically scales the SVG image so it will fit in the given size,
and creates a :class:`wx.Bitmap` of that size, containing a rasterized
version of the SVG image. If a window is passed then the size of the
bitmap will automatically be adjusted to the content scale factor of
that window. For example, if a (32,32) pixel bitmap is requested for a
window on a Retina display, then a (64,64) pixel bitmap will be created.

:param wx.Size `size`: Size of the bitmap to create, in pixels
:param wx.Window `window`: Adjust the size by this window's content scale factor, if supported on the platform

:returns: :class:`wx.Bitmap`r|  hhh
h]r}  (X   sizer~  hhr  X   windowr  X   Noner  X   Noner  r  ehCX.   ConvertToScaledBitmap(self, size, window=None)r  h#hjw  X   27r  h%jT  ubh)r  }r  (hX   wx.svg.SVGimage.RenderToGCr  hKhKhX  Draw the collection of shapes and paths in the SVG image
onto the given :class:`wx.GraphicsContext` using the drawing primitives
provided by the context. The Context's state is saved and restored so
any transformations done while rendering the SVG will be undone.

:param wx.GraphicsContext `ctx`: The context to draw upon
:param float `scale`: If given, apply to the context's scale.
:param (float, float) `size`: If given, scale the image's width and height
    to that provided in this parameter. Ignored if ``scale`` is also specified.

.. note::
    Some GraphicsContext backends perform better than others.
    The default GDI+ backend on Windows is the most glitchy, but the
    Direct2D backend works well.r  hhh
h]r  (X   ctxr  hhr  X   scaler  X   Noner  X   Noner  r  X   sizer  X   Noner  X   Noner  r  ehCX,   RenderToGC(self, ctx, scale=None, size=None)r  h#hjw  X   59r  h%jT  ubeh+]r  (]r  X   objectr  a]r  (]r  X   SVGimageBaser  a]r  ]r  X   SVGimager  aaeeh>]r  h@]r  X   wx.svg._nanosvg.SVGimageBaser  ahCX   SVGimage(SVGimageBase)r  hEh)r  }r  (h]r  (X   wx.svg.SVGimager  ]r  X   wx.svg._nanosvg.SVGimageBaser  ar  X   wx.svg._nanosvg.SVGimageBaser  ]r  r  eh]r  X   wx.svg.SVGimager  ahjT  ubhKh#hFhGXB   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGimage.txtr  h%hjw  X   264r  h]r  (X   ConvertToBitmapr  X   ConvertToScaledBitmapr  X
   RenderToGCr  ehj  ubh)r  }r  (hX   wx.svg.SVGimageBaser  hKhX  A SVGimageBase can be created either from an SVG file or from an in-memory
buffer containing the SVG XML code. The result is a collection of cubic
bezier shapes, with fill, stroke, gradients, paths and other information.

This class is a Cython-based wrapper around the nanosvg ``NSVGimage`` structure,
providing just the basic wrapped functionality from nanosvg. Please see the
:class:`wx.svg.SVGimage` class for a derived implementation that adds
functionality for integrating with wxPython.r  hhh
h]r  (h)r  }r  (hX#   wx.svg.SVGimageBase.CreateFromBytesr  hK
hKhXo  Loads an SVG image from a bytes object.

:param bytes `buffer`: object containing the SVG data
:param str `units`: One of: 'px', 'pt', 'pc' 'mm', 'cm', or 'in'
:param float `dpi`: controls how the unit conversion is done
:param bool `do_copy`: indicates if the given bytes object should be
    copied to avoid in-place modification. This should be set to True
    if the given `buffer` object may ever be reused in any capacity.
    If the given `buffer` will only be used once, and the cost of copying
    it is problematic, then `do_copy` can be set to False.

:rtype: An instance of ``cls`` (usually a :class:`SVGimage`)r  hhh
h]r  hCXX   CreateFromBytes(type cls, bytes buffer, str units='px', float dpi=96, bool do_copy=True)r  h#hh%j  ubh)r  }r  (hX"   wx.svg.SVGimageBase.CreateFromFiler  hK
hKhX  Loads an SVG image from a file.

:param str `filename`: Name of the file to load the SVG image from
:param str `units`: One of: 'px', 'pt', 'pc' 'mm', 'cm', or 'in'
:param float `dpi`: controls how the unit conversion is done

:rtype: An instance of ``cls`` (usually a :class:`SVGimage`)r  hhh
h]r  hCXD   CreateFromFile(type cls, str filename, str units='px', float dpi=96)r  h#hh%j  ubh)r  }r  (hX   wx.svg.SVGimageBase.Rasterizer  hKhKhXL  Renders the SVG image to a ``bytes`` object as a series of RGBA values.

:param float `tx`: Image horizontal offset (applied after scaling)
:param float `ty`: Image vertical offset (applied after scaling)
:param float `scale`: Image scale
:param int `width`: width of the image to render, defaults to width from the SVG file
:param int `height`: height of the image to render, defaults to height from the SVG file
:param int `stride`: number of bytes per scan line in the destination buffer, typically ``width * 4``

:returns: A bytearray object containing the raw RGBA pixel color valuesr  hhh
h]r  hCXq   Rasterize(self, float tx=0.0, float ty=0.0, float scale=1.0, int width=-1, int height=-1, int stride=-1) -> bytesr  h#hh%j  ubh)r  }r  (hX%   wx.svg.SVGimageBase.RasterizeToBufferr  hKhKhX  Renders the SVG image to an existing buffer as a series of RGBA values.

The buffer object must support the Python buffer-protocol, be writable,
and be at least ``width * height * 4`` bytes long. Possibilities include
bytearrays, memoryviews, numpy arrays, etc.

:param `buf`: An object supporting the buffer protocol where the RGBA bytes will be written
:param float `tx`: Image horizontal offset (applied after scaling)
:param float `ty`: Image vertical offset (applied after scaling)
:param float `scale`: Image scale
:param int `width`: width of the image to render, defaults to width from the SVG file
:param int `height`: height of the image to render, defaults to height from the SVG file
:param int `stride`: number of bytes per scan line in the destination buffer, typically ``width * 4``r  hhh
h]r  hCX~   RasterizeToBuffer(self, buf, float tx=0.0, float ty=0.0, float scale=1.0, int width=-1, int height=-1, int stride=-1) -> bytesr  h#hh%j  ubhl)r  }r  (hX   wx.svg.SVGimageBase.heightr  hKhKhX#   Returns the height of the SVG imager  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGimageBase.shapesr  hKhKhXX   A generator that iterates over the :class:`SVGshape` objects that comprise the SVG imager  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGimageBase.widthr  hKhKhX"   Returns the width of the SVG imager  hhh
hphhqhhrhh#hsh%j  ubeh+]r  (]r  X   objectr  a]r  ]r  X   SVGimageBaser  aaeh>]r  X   wx.svg.SVGimager  ah@]r  hCX   SVGimageBase(object)r  hENhKh#hFhGXF   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGimageBase.txtr  h%hubh)r  }r  (hX   wx.svg.SVGlineCapr  hKhhhhh
h]r  (h)r  }r  (hX   wx.svg.SVGlineCap.SVG_CAP_BUTTr  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_BUTT: 0>r  h!X
   SVGlineCapr  h#h$h%j  ubh)r  }r  (hX   wx.svg.SVGlineCap.SVG_CAP_ROUNDr  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_ROUND: 1>r  h!X
   SVGlineCapr  h#h$h%j  ubh)r  }r  (hX    wx.svg.SVGlineCap.SVG_CAP_SQUAREr  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_SQUARE: 2>r  h!X
   SVGlineCapr  h#h$h%j  ubeh+]r  (]r  X   objectr  a]r   (]r  X   intr  a]r  (]r  h4a]r  ]r  j  aae]r  h9a]r  (]r	  h4a]r
  ]r  j  aaeeeh>]r  h@]r
  X
   <enum IntEnumr  ahCX   SVGlineCap(<enum IntEnum)r  hENhKh#hFhGXD   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGlineCap.txtr  h%hubh)r  }r  (hX   wx.svg.SVGlineJoinr  hKhhhhh
h]r  (h)r  }r  (hX!   wx.svg.SVGlineJoin.SVG_JOIN_BEVELr  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_BEVEL: 2>r  h!X   SVGlineJoinr  h#h$h%j  ubh)r  }r  (hX!   wx.svg.SVGlineJoin.SVG_JOIN_MITERr  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_MITER: 0>r  h!X   SVGlineJoinr  h#h$h%j  ubh)r  }r   (hX!   wx.svg.SVGlineJoin.SVG_JOIN_ROUNDr!  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_ROUND: 1>r"  h!X   SVGlineJoinr#  h#h$h%j  ubeh+]r$  (]r%  X   objectr&  a]r'  (]r(  X   intr)  a]r*  (]r+  h4a]r,  ]r-  jF  aae]r.  h9a]r/  (]r0  h4a]r1  ]r2  jF  aaeeeh>]r3  h@]r4  X
   <enum IntEnumr5  ahCX   SVGlineJoin(<enum IntEnum)r6  hENhKh#hFhGXE   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGlineJoin.txtr7  h%hubh)r8  }r9  (hX   wx.svg.SVGpaintr:  hKhX   This class defines how to fill or stroke a shape when rendering the SVG
image. In other words, how to create the pen or brush. It can be a solid
color, linear or radial gradients, etc.r;  hhh
h]r<  (hl)r=  }r>  (hX   wx.svg.SVGpaint.colorr?  hKhKhhhhh
hphhqhhrhh#hsh%j8  ubhl)r@  }rA  (hX   wx.svg.SVGpaint.color_rgbarB  hKhKhX   Returns color as a RGBA tuplerC  hhh
hphhqhhrhh#hsh%j8  ubhl)rD  }rE  (hX   wx.svg.SVGpaint.gradientrF  hKhKhhhhh
hphhqhhrhh#hsh%j8  ubhl)rG  }rH  (hX   wx.svg.SVGpaint.typerI  hKhKhXG   Flag indicating the type of paint info, solid color or type of gradientrJ  hhh
hphhqhhrhh#hsh%j8  ubeh+]rK  (]rL  X   objectrM  a]rN  ]rO  X   SVGpaintrP  aaeh>]rQ  h@]rR  hCX   SVGpaint(object)rS  hENhKh#hFhGXB   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGpaint.txtrT  h%hubh)rU  }rV  (hX   wx.svg.SVGpaintTyperW  hKhhhhh
h]rX  (h)rY  }rZ  (hX#   wx.svg.SVGpaintType.SVG_PAINT_COLORr[  hK$hKhhhhh
hX!   <SVGpaintType.SVG_PAINT_COLOR: 1>r\  h!X   SVGpaintTyper]  h#h$h%jU  ubh)r^  }r_  (hX-   wx.svg.SVGpaintType.SVG_PAINT_LINEAR_GRADIENTr`  hK$hKhhhhh
hX+   <SVGpaintType.SVG_PAINT_LINEAR_GRADIENT: 2>ra  h!X   SVGpaintTyperb  h#h$h%jU  ubh)rc  }rd  (hX"   wx.svg.SVGpaintType.SVG_PAINT_NONEre  hK$hKhhhhh
hX    <SVGpaintType.SVG_PAINT_NONE: 0>rf  h!X   SVGpaintTyperg  h#h$h%jU  ubh)rh  }ri  (hX-   wx.svg.SVGpaintType.SVG_PAINT_RADIAL_GRADIENTrj  hK$hKhhhhh
hX+   <SVGpaintType.SVG_PAINT_RADIAL_GRADIENT: 3>rk  h!X   SVGpaintTyperl  h#h$h%jU  ubeh+]rm  (]rn  X   objectro  a]rp  (]rq  X   intrr  a]rs  (]rt  h4a]ru  ]rv  j  aae]rw  h9a]rx  (]ry  h4a]rz  ]r{  j  aaeeeh>]r|  h@]r}  X
   <enum IntEnumr~  ahCX   SVGpaintType(<enum IntEnum)r  hENhKh#hFhGXF   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGpaintType.txtr  h%hubh)r  }r  (hX   wx.svg.SVGpathr  hKhX   An SVGpath is essentially just a collection of bezier curves, defined by a
set of floating point coordinates. A collection of SVGpaths is accessible
from the `paths` attribute of SVGshape.r  hhh
h]r  (hl)r  }r  (hX   wx.svg.SVGpath.boundsr  hKhKhX5   Tight bounding box of the shape [minx,miny,maxx,maxy]r  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGpath.closedr  hKhKhX5   Flag indicating if shapes should be treated as closedr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGpath.maxxr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGpath.maxyr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGpath.minxr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGpath.minyr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGpath.nptsr  hKhKhX   Number of pointsr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGpath.pointsr  hKhKhX   Cubic bezier points: (x0,y0), [(cpx1,cpx1), (cpx2,cpy2), (x1,y1)], ...
The return value is a list of tuples, each containing an x-y pair.r  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGpath.ptsr  hKhKhXb   Cubic bezier points: x0,y0, [cpx1,cpx1,cpx2,cpy2,x1,y1], ...
The return value is a list of floats.r  hhh
hphhqhhrhh#hsh%j  ubeh+]r  (]r  X   objectr  a]r  ]r  X   SVGpathr  aaeh>]r  h@]r  hCX   SVGpath(object)r  hENhKh#hFhGXA   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGpath.txtr  h%hubh)r  }r  (hX   wx.svg.SVGshaper  hKhX   SVGshape is a set of attributes describing how to draw one shape in the SVG,
including stroke and fill styles, line styles, and paths. A collection of
SVGshapes is accessible from the ``shapes`` attribute of :class:`SVGimage`.r  hhh
h]r  (hl)r  }r  (hX   wx.svg.SVGshape.boundsr  hKhKhX5   Tight bounding box of the shape [minx,miny,maxx,maxy]r  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.fillr  hKhKhX   :class:`SVGpaint` for the fillr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.fillRuler  hKhKhX	   Fill ruler  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.flagsr  hKhKhX   Logical OR of SVG_FLAGS_* flagsr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.idr  hKhKhX,   Optional 'id' attr of the shape or its groupr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.maxxr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.maxyr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.minxr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.minyr  hKhKhhhhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.miterLimitr  hKhKhX   Miter limitr  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.opacityr  hKhKhX   Opacity of the shaper  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.pathsr  hKhKhXU   A generator that iterates over the :class:`SVGpath` objects contained in the SVGshaper  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.stroker  hKhKhX    :class:`SVGpaint` for the stroker  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.strokeDashArrayr  hKhKhX   Stroke dash array (scaled)r  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX    wx.svg.SVGshape.strokeDashOffsetr  hKhKhX   Stroke dash offset (scaled)r  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.strokeLineCapr  hKhKhX   Stroke cap typer  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.strokeLineJoinr  hKhKhX   Stroke join typer  hhh
hphhqhhrhh#hsh%j  ubhl)r  }r  (hX   wx.svg.SVGshape.strokeWidthr  hKhKhX   Stroke width (scaled)r  hhh
hphhqhhrhh#hsh%j  ubeh+]r  (]r  X   objectr  a]r  ]r  X   SVGshaper  aaeh>]r  h@]r   hCX   SVGshape(object)r  hENhKh#hFhGXB   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGshape.txtr  h%hubh)r  }r  (hX   wx.svg.SVGspreadTyper  hKhhhhh
h]r  (h)r  }r  (hX#   wx.svg.SVGspreadType.SVG_SPREAD_PADr	  hK$hKhhhhh
hX!   <SVGspreadType.SVG_SPREAD_PAD: 0>r
  h!X
   SVGspreadTyper  h#h$h%j  ubh)r  }r
  (hX'   wx.svg.SVGspreadType.SVG_SPREAD_REFLECTr  hK$hKhhhhh
hX%   <SVGspreadType.SVG_SPREAD_REFLECT: 1>r  h!X
   SVGspreadTyper  h#h$h%j  ubh)r  }r  (hX&   wx.svg.SVGspreadType.SVG_SPREAD_REPEATr  hK$hKhhhhh
hX$   <SVGspreadType.SVG_SPREAD_REPEAT: 2>r  h!X
   SVGspreadTyper  h#h$h%j  ubeh+]r  (]r  X   objectr  a]r  (]r  X   intr  a]r  (]r  h4a]r  ]r  jU  aae]r   h9a]r!  (]r"  h4a]r#  ]r$  jU  aaeeeh>]r%  h@]r&  X
   <enum IntEnumr'  ahCX   SVGspreadType(<enum IntEnum)r(  hENhKh#hFhGXG   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.SVGspreadType.txtr)  h%hubh)r*  }r+  (hX   wx.svg.zip_longestr,  hKhX  zip_longest(iter1 [,iter2 [...]], [fillvalue=None]) --> zip_longest object

Return a zip_longest object whose .__next__() method returns a tuple where
the i-th element comes from the i-th iterable argument.  The .__next__()
method continues until the longest iterable in the argument sequence
is exhausted and then it raises StopIteration.  When the shorter iterables
are exhausted, the fillvalue is substituted in their place.  The fillvalue
defaults to None or can be specified by a keyword argument.r-  hhh
h]r.  h+]r/  (]r0  X   objectr1  a]r2  ]r3  X   zip_longestr4  aaeh>]r5  h@]r6  hCX   zip_longest(object)r7  hENhKh#hFhGXE   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.zip_longest.txtr8  h%hubh)r9  }r:  (hX*   wx.svg._RenderersWithoutGradientTransformsr;  hKhKhX   Built-in mutable sequence.

If no argument is given, the constructor creates a new empty list.
The argument must be an iterable if specified.r<  hhh
hX   []r=  h!X   listr>  h#h$h%hubh)r?  }r@  (hX
   wx.svg.PY2rA  hKhKhX   bool(x) -> bool

Returns True when the argument x is true, False otherwise.
The builtins True and False are the only two instances of the class bool.
The class bool is a subclass of the class int, and cannot be subclassed.rB  hhh
hjj  h!X   boolrC  h#h$h%hubh)rD  }rE  (hX   wx.svg.SVG_CAP_BUTTrF  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_BUTT: 0>rG  h!X
   SVGlineCaprH  h#h$h%hubh)rI  }rJ  (hX   wx.svg.SVG_CAP_ROUNDrK  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_ROUND: 1>rL  h!X
   SVGlineCaprM  h#h$h%hubh)rN  }rO  (hX   wx.svg.SVG_CAP_SQUARErP  hK$hKhhhhh
hX   <SVGlineCap.SVG_CAP_SQUARE: 2>rQ  h!X
   SVGlineCaprR  h#h$h%hubh)rS  }rT  (hX   wx.svg.SVG_FILLRULE_EVENODDrU  hK$hKhhhhh
hX%   <SVGfillRule.SVG_FILLRULE_EVENODD: 1>rV  h!X   SVGfillRulerW  h#h$h%hubh)rX  }rY  (hX   wx.svg.SVG_FILLRULE_NONZEROrZ  hK$hKhhhhh
hX%   <SVGfillRule.SVG_FILLRULE_NONZERO: 0>r[  h!X   SVGfillRuler\  h#h$h%hubh)r]  }r^  (hX   wx.svg.SVG_FLAGS_VISIBLEr_  hK$hKhhhhh
hX   <SVGflags.SVG_FLAGS_VISIBLE: 1>r`  h!X   SVGflagsra  h#h$h%hubh)rb  }rc  (hX   wx.svg.SVG_JOIN_BEVELrd  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_BEVEL: 2>re  h!X   SVGlineJoinrf  h#h$h%hubh)rg  }rh  (hX   wx.svg.SVG_JOIN_MITERri  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_MITER: 0>rj  h!X   SVGlineJoinrk  h#h$h%hubh)rl  }rm  (hX   wx.svg.SVG_JOIN_ROUNDrn  hK$hKhhhhh
hX   <SVGlineJoin.SVG_JOIN_ROUND: 1>ro  h!X   SVGlineJoinrp  h#h$h%hubh)rq  }rr  (hX   wx.svg.SVG_PAINT_COLORrs  hK$hKhhhhh
hX!   <SVGpaintType.SVG_PAINT_COLOR: 1>rt  h!X   SVGpaintTyperu  h#h$h%hubh)rv  }rw  (hX    wx.svg.SVG_PAINT_LINEAR_GRADIENTrx  hK$hKhhhhh
hX+   <SVGpaintType.SVG_PAINT_LINEAR_GRADIENT: 2>ry  h!X   SVGpaintTyperz  h#h$h%hubh)r{  }r|  (hX   wx.svg.SVG_PAINT_NONEr}  hK$hKhhhhh
hX    <SVGpaintType.SVG_PAINT_NONE: 0>r~  h!X   SVGpaintTyper  h#h$h%hubh)r  }r  (hX    wx.svg.SVG_PAINT_RADIAL_GRADIENTr  hK$hKhhhhh
hX+   <SVGpaintType.SVG_PAINT_RADIAL_GRADIENT: 3>r  h!X   SVGpaintTyper  h#h$h%hubh)r  }r  (hX   wx.svg.SVG_SPREAD_PADr  hK$hKhhhhh
hX!   <SVGspreadType.SVG_SPREAD_PAD: 0>r  h!X
   SVGspreadTyper  h#h$h%hubh)r  }r  (hX   wx.svg.SVG_SPREAD_REFLECTr  hK$hKhhhhh
hX%   <SVGspreadType.SVG_SPREAD_REFLECT: 1>r  h!X
   SVGspreadTyper  h#h$h%hubh)r  }r  (hX   wx.svg.SVG_SPREAD_REPEATr  hK$hKhhhhh
hX$   <SVGspreadType.SVG_SPREAD_REPEAT: 2>r  h!X
   SVGspreadTyper  h#h$h%hubeh%Nj  X5   /home/wxpy/bb2/dist-src-py37/build/wx/svg/__init__.pyr  hK h#X   Libraryr  X   python_versionr  X   3.7.16-finalr  hGX9   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.svg.txtr  X	   base_namer  X   wx.svgr  ub.