/*  sjis.h - tables for Unicode to Shift JIS, generated by "backend/tools/gen_eci_mb_h.php"
    from "https://unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/JIS/SHIFTJIS.TXT" */
/*
    libzint - the open source barcode library
    Copyright (C) 2009-2022 Robin Stuart <rstuart114@gmail.com>

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the project nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
    OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
 */
/* SPDX-License-Identifier: BSD-3-Clause */

#ifndef Z_SJIS_H
#define Z_SJIS_H

/* Unicode usage bit-flags for URO (U+4E00-U+9FFF) block */
static const unsigned short sjis_uro_u[1307] = {
    0x6F8B, 0x43F3, 0x2442, 0x9B46, 0xE82C, 0xE3E0, 0x0004, 0x400A,
    0x5F65, 0xDB36, 0x7977, 0x0449, 0xECD7, 0xE3F0, 0x6038, 0x08C5,
    0xE602, 0x3403, 0x8000, 0x3551, 0xE0C8, 0x7EAB, 0x8200, 0x9869,
    0xA948, 0x2942, 0xE803, 0x8060, 0x441C, 0xAD93, 0xC03A, 0x4568,
    0xAA60, 0x8656, 0x3F7A, 0x0240, 0x8388, 0x1461, 0x1020, 0x2174,
    0x2021, 0x0702, 0x3000, 0x40BC, 0xA624, 0x4462, 0x60A8, 0x0A20,
    0x0217, 0x8574, 0x0402, 0x9C84, 0x7BFB, 0x1415, 0x7F24, 0x11E2,
    0xB665, 0x02EF, 0x1F75, 0x20FF, 0x3A70, 0x3840, 0x26C3, 0x6763,
    0x4DD9, 0x2092, 0x46B0, 0x0FC9, 0xBC98, 0x4850, 0x8638, 0xA03F,
    0x2388, 0x8816, 0x3E09, 0x5232, 0x22AA, 0xE3A4, 0x00DD, 0xC72C,
    0xA166, 0x26E1, 0x840B, 0x8F0A, 0x27EB, 0x559E, 0xC241, 0x89BB,
    0x0014, 0x8540, 0x6361, 0x0849, 0x7F0C, 0x8AD0, 0xFF3E, 0x05CF,
    0xFF1A, 0xA803, 0x7A41, 0x7B40, 0x4745, 0x8002, 0x0500, 0x38EB,
    0xD851, 0x0005, 0x9934, 0x710C, 0x0397, 0x0100, 0x6366, 0x2404,
    0x80D0, 0x0051, 0xC000, 0x430A, 0x9071, 0x30C8, 0x0008, 0x5800,
    0x0E99, 0xF700, 0x5F80, 0x0041, 0x00B0, 0x9410, 0x0018, 0x6280,
    0x0240, 0x09D0, 0x8200, 0x0156, 0x5004, 0x0801, 0x1D10, 0x0510,
    0x84C1, 0x0010, 0x4025, 0x1050, 0x410F, 0x4D8A, 0x4009, 0xA60D,
    0xAB19, 0x914C, 0x21C0, 0x0981, 0xC485, 0x0003, 0x0652, 0x8000,
    0x0B04, 0x0008, 0x041D, 0x0009, 0x4849, 0x905C, 0x0009, 0x1690,
    0x0C65, 0x2220, 0x8412, 0x2433, 0x0C03, 0x4796, 0x0A04, 0x4225,
    0x0028, 0x9088, 0x4900, 0x4F08, 0x14A2, 0xD3AA, 0xD830, 0x3E87,
    0x8604, 0x1F61, 0x7EA4, 0x4186, 0xC390, 0x05B3, 0x57A5, 0x2118,
    0x241E, 0x2A48, 0x1128, 0x4A04, 0x0A40, 0x161B, 0x0D60, 0x8840,
    0x020A, 0x9502, 0x8221, 0x1060, 0x0243, 0x0400, 0x1444, 0x8000,
    0x0000, 0x0C04, 0x0000, 0x7000, 0x1A06, 0x00C1, 0x024A, 0x0C00,
    0x1A00, 0x0040, 0x1404, 0x4045, 0x0029, 0xBDB3, 0x0A78, 0x052B,
    0xBBA9, 0xBFA0, 0x407C, 0x8379, 0x12FC, 0xE81D, 0x4BF6, 0xC569,
    0xEFF6, 0x044A, 0x2115, 0xFF02, 0xED63, 0x402B, 0xD033, 0x0242,
    0x1000, 0x0013, 0x1B02, 0x59CA, 0x00A0, 0x0200, 0xA703, 0x2C41,
    0x4880, 0x8FF2, 0x0204, 0x0000, 0x5800, 0x1005, 0x9200, 0x0048,
    0x1894, 0x2001, 0x5004, 0x3480, 0x3200, 0x684C, 0x49EA, 0x68BE,
    0x184C, 0x2E42, 0xA820, 0x21C9, 0x50B9, 0x80B0, 0x001E, 0xFF7C,
    0x849A, 0x14E0, 0x28C1, 0x01E0, 0x870E, 0xAC49, 0x130F, 0xDDDB,
    0xBE1A, 0x89FB, 0xA2E0, 0x51A2, 0x5502, 0x32CA, 0x3E46, 0x928B,
    0x1DBF, 0x438F, 0x6703, 0x3218, 0x3028, 0x33C0, 0x0811, 0xA923,
    0xC000, 0x3A65, 0x8FE3, 0x0402, 0x2C4E, 0x8625, 0xBF3D, 0x00A1,
    0x3A1A, 0x8CD4, 0x06C9, 0x317C, 0x00E0, 0x950A, 0x018B, 0x0EDB,
    0xE34B, 0x8C20, 0x1182, 0xF010, 0x7D94, 0xA728, 0xC9AC, 0x40FB,
    0x4484, 0x0653, 0x5A90, 0x4444, 0x3FC8, 0x0001, 0x0048, 0xF5D4,
    0x7701, 0xEC57, 0xC442, 0x891D, 0x6B83, 0x4928, 0x4109, 0xD242,
    0x061D, 0x59FE, 0x1800, 0x3A22, 0xB7E4, 0x3B9F, 0xF003, 0xC0EA,
    0x1386, 0x8202, 0x8980, 0xE400, 0xB200, 0x10A1, 0x4B80, 0x0CC4,
    0xD309, 0x8944, 0x1FAF, 0x4834, 0x8259, 0x0C45, 0x420A, 0x0450,
    0xA040, 0x10C8, 0x3140, 0x4450, 0x4004, 0x0100, 0x8280, 0x0540,
    0x0108, 0x442C, 0x6A30, 0x1A05, 0x20A6, 0x0514, 0x90CF, 0x6456,
    0x0021, 0x3100, 0x9C18, 0xCBF0, 0xA120, 0x63E2, 0x104C, 0x01B5,
    0x538C, 0x9A83, 0xB8B2, 0x3281, 0x987A, 0x0A84, 0x33E7, 0x0C02,
    0xD4CC, 0x9018, 0xA1A1, 0x9070, 0x8A1E, 0xE004, 0xC3D4, 0x0451,
    0x439A, 0x21C2, 0x4844, 0x5310, 0x0292, 0x3640, 0x0241, 0xF3BD,
    0xAB09, 0xE8F0, 0x7DC0, 0xA5D2, 0xC242, 0xD24B, 0xA43F, 0xD0AF,
    0x1AA0, 0x34A1, 0x8247, 0x03D8, 0xC452, 0x651B, 0xD294, 0xC83A,
    0x001C, 0x40C8, 0x0E06, 0x3314, 0x614F, 0xB21B, 0x0088, 0xC0D0,
    0xA02A, 0xA898, 0xA1C5, 0x166B, 0x2E50, 0x85B4, 0xC08B, 0x0604,
    0xF933, 0x1E04, 0x056E, 0xA251, 0x0400, 0x7638, 0xEC07, 0x73B8,
    0x4406, 0x1832, 0x4081, 0xC816, 0x7C8A, 0x6309, 0x2980, 0xAA04,
    0x1C24, 0xCA9C, 0x4E0E, 0x2760, 0x0990, 0x8300, 0x0046, 0x8104,
    0x6011, 0x1081, 0x540D, 0x0908, 0x000E, 0xCC0A, 0x0500, 0x0C00,
    0x0430, 0xA044, 0x008B, 0x6784, 0x5288, 0x8A19, 0x865E, 0x8B18,
    0x2E59, 0x4160, 0x8C10, 0x9CBE, 0x6861, 0x891C, 0x9800, 0x0008,
    0x8100, 0x089A, 0x0018, 0x4190, 0x4007, 0xE4A1, 0x0505, 0x640D,
    0x310E, 0x0E4D, 0x4806, 0xFF0A, 0x1632, 0x2AA8, 0x852E, 0x000B,
    0x1800, 0xCA84, 0x0E20, 0x696C, 0x0032, 0x1600, 0x5658, 0x0390,
    0x5120, 0x1A28, 0x8000, 0x1124, 0x18E1, 0x4326, 0x5D52, 0x0EAA,
    0x0FA0, 0xAE28, 0xFA7B, 0x4500, 0x6408, 0x8940, 0xC880, 0xC044,
    0x9005, 0xB141, 0x8424, 0x24C4, 0x1A34, 0x603A, 0x9000, 0xC194,
    0x8246, 0x003A, 0x180D, 0xC106, 0x0022, 0x9910, 0xE050, 0x1511,
    0x4057, 0x0082, 0x041A, 0x020A, 0x004F, 0x8930, 0xD813, 0x444A,
    0x8A02, 0xED22, 0x10C0, 0x4005, 0x1000, 0x0102, 0x8808, 0x3101,
    0x4600, 0x0204, 0xF000, 0x0708, 0x8900, 0xA200, 0x0000, 0x2202,
    0x0200, 0x1610, 0x0042, 0x1040, 0x5200, 0x0260, 0x52F4, 0x2000,
    0x8510, 0x8230, 0x1100, 0x4202, 0x4308, 0x80B5, 0x70E1, 0x9A20,
    0x2040, 0x0801, 0x3500, 0xFC65, 0x19C1, 0xAB04, 0x0286, 0x6214,
    0x0087, 0x0044, 0x9085, 0x0244, 0x405C, 0x0A85, 0x3207, 0x3380,
    0x0400, 0xB8C0, 0xCE20, 0xC0D0, 0xC030, 0x0080, 0x0508, 0x0D25,
    0x0A90, 0x0040, 0x0200, 0x080C, 0x6505, 0x4000, 0x6421, 0x4102,
    0x0268, 0x0000, 0x0024, 0x847C, 0x0002, 0xDE20, 0x8619, 0x4049,
    0x0808, 0x4000, 0x0084, 0x2001, 0x8400, 0x1010, 0x42CD, 0x01C7,
    0x7038, 0xD52A, 0x1968, 0x1D8F, 0xBE50, 0x3E12, 0x2EF5, 0x81D9,
    0xCEC4, 0x2412, 0x0828, 0x732E, 0x24AC, 0x4B34, 0x020C, 0xD41D,
    0x2A02, 0x8000, 0x0097, 0x0811, 0x11C4, 0x1144, 0x1786, 0x7D45,
    0x49D9, 0x0649, 0x4000, 0x8791, 0x254C, 0xD8C4, 0x44BA, 0x4914,
    0x1B92, 0xC800, 0x0271, 0x1580, 0x0081, 0x0C00, 0x096A, 0xC200,
    0x4800, 0x4002, 0x3021, 0xBA49, 0x2080, 0x1C80, 0xE2AC, 0x1008,
    0x1004, 0x0034, 0x00E1, 0x8414, 0x0020, 0x2000, 0x9800, 0x1014,
    0x70C2, 0x04AA, 0x8688, 0x5420, 0x0C62, 0x0413, 0x9180, 0x2010,
    0x4082, 0x0206, 0x1C40, 0x5400, 0x0383, 0xE4E9, 0x2125, 0x8480,
    0xE433, 0x2000, 0x44C0, 0xE609, 0x0A03, 0x8126, 0x12DA, 0x0801,
    0x6901, 0x9790, 0x4001, 0xF886, 0xE24D, 0x0081, 0x0A0E, 0xA651,
    0x011A, 0x81EC, 0xC600, 0x8441, 0xADB8, 0xB62C, 0xA46F, 0x8741,
    0x8D54, 0x4B02, 0x1161, 0x0268, 0xBB60, 0x2057, 0x50A0, 0x0433,
    0xA8C0, 0xB7B4, 0x2402, 0x0112, 0x9AD3, 0x2000, 0x2271, 0x00C8,
    0x2081, 0x809E, 0x0C8A, 0xE180, 0xB009, 0x8151, 0x1031, 0x4028,
    0x2A0E, 0x89A5, 0x69B6, 0x620E, 0x4425, 0xD144, 0x8085, 0x4D54,
    0x2C75, 0x1FB1, 0xD807, 0x862D, 0xD87C, 0x4841, 0x414E, 0x226E,
    0x8200, 0x9E08, 0xF80C, 0xED37, 0x8C80, 0x7526, 0x9313, 0x0814,
    0x0E32, 0xC804, 0x484E, 0x6EA6, 0x2C4A, 0x6670, 0x26C0, 0xBA01,
    0xD30C, 0x185D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0540, 0x7020, 0x8133, 0x4F81, 0x03A5,
    0x55EC, 0x6410, 0xC318, 0x2344, 0x1462, 0x0034, 0x0A43, 0x1A09,
    0x187B, 0x13A5, 0x0102, 0xA848, 0x0440, 0xC544, 0x8106, 0xE2DD,
    0x1AF0, 0x2D48, 0xB626, 0x0416, 0x5058, 0x6E40, 0x8032, 0x3112,
    0x07E4, 0x0C00, 0x8208, 0x420A, 0x4840, 0x803B, 0x4860, 0x8713,
    0x850D, 0x3428, 0x0319, 0xE529, 0x2345, 0x870A, 0x25A9, 0x5C18,
    0x77A6, 0xD9C5, 0x5E00, 0x03E8, 0x0081, 0xA700, 0xCD54, 0x41C6,
    0x2800, 0xA204, 0xB860, 0x2B0A, 0x0020, 0xDA9E, 0x08EA, 0x0E1A,
    0x427C, 0x11C0, 0x8908, 0x0376, 0x8621, 0x0105, 0x0000, 0x18A8,
    0x46A0, 0xC448, 0x0D05, 0x2022, 0x5422, 0x9148, 0x8A01, 0x2897,
    0x7898, 0x0008, 0x1605, 0x3122, 0x4240, 0x0880, 0xFA4E, 0x06A2,
    0x0814, 0x9211, 0x2002, 0x9B04, 0x2E52, 0x0643, 0x5000, 0x9010,
    0x0041, 0x85BA, 0x3042, 0x2020, 0x4F0B, 0x05A0, 0x2708, 0x4080,
    0x0591, 0x1A93, 0xDF50, 0x0600, 0xA202, 0x3021, 0x0630, 0x4E80,
    0x0CC4, 0x04C8, 0xA004, 0x8001, 0x6000, 0xD431, 0x0880, 0x0A02,
    0x1C00, 0x0028, 0x8E18, 0x0041, 0x6AD0, 0xCA10, 0xF210, 0x4B00,
    0x274D, 0x1506, 0x0220, 0x8890, 0x5A00, 0x82A8, 0x4549, 0x8150,
    0x2004, 0x8000, 0x8804, 0x2C08, 0x08D1, 0x0005, 0x8001, 0x4AC4,
    0xE020, 0x0062, 0x008E, 0x0A42, 0x3055, 0x6A8C, 0x090E, 0xE0A5,
    0x2906, 0x42C4, 0x4814, 0x80B3, 0x803E, 0xB330, 0x0102, 0x731C,
    0x1494, 0x600D, 0x0C20, 0x0940, 0x301A, 0xC040, 0xA451, 0xC094,
    0x8DCA, 0x05C8, 0x96C2, 0xA40C, 0x0001, 0x3404, 0x00C8, 0x0110,
    0x550D, 0xA9C9, 0x2428, 0x1C5A, 0x0142, 0x4837, 0x7A4D, 0x100F,
    0x32B4, 0x452A, 0x317B, 0x9205, 0xB894, 0x5C44, 0x68D7, 0x458A,
    0x5097, 0x2ED1, 0x1943, 0x4208, 0xD202, 0x9D40, 0x9840, 0x2097,
    0x5409, 0x064D, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x8480, 0x5542, 0x0421, 0x1C06, 0x1700,
    0x7624, 0x6110, 0xFF87, 0xB9DD, 0x659F, 0x5C0A, 0x245D, 0x3C00,
    0xADB0, 0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x28D0, 0x009B,
    0x0422, 0x0200, 0x0108, 0x4408, 0x9804, 0xAC40, 0x8D0A, 0x9028,
    0x8700, 0xE001, 0x0400, 0x0031, 0x1794, 0x8221, 0x0019, 0x1054,
    0x2CB2, 0x021A, 0x9C02, 0x4003, 0x3D60, 0x8804, 0x080C, 0x7900,
    0x1628, 0xBA3C, 0x8640, 0xCB08, 0x7274, 0x9080, 0x001E, 0x0000,
    0x0000, 0xD800, 0xE188, 0x9C87, 0x4034, 0x0412, 0xAE64, 0x2791,
    0xE86B, 0xE6FB, 0x408F, 0x5366, 0xEEA6, 0x537F, 0xE32B, 0xB5E4,
    0x869F, 0x0002, 0x8548, 0x0122, 0x4402, 0x0800, 0x2116, 0x20A0,
    0x0004, 0x0204, 0x2000, 0x0005, 0x7E00, 0x0154, 0x162C, 0x01AC,
    0x2A84, 0x1085, 0x8C14, 0x0530, 0xFBC3, 0xB943, 0x00CA, 0x9060,
    0x6000, 0x4032, 0x1200, 0x8090, 0x0B30, 0x4C81, 0x0054, 0x4002,
    0x0029, 0x1D6A, 0x2000, 0x0280, 0x8000, 0x0004, 0x2610, 0x150C,
    0x8040, 0x0701, 0xD94D, 0x0C24, 0x2810, 0x1850, 0x5001, 0x5020,
    0x1000, 0x04D0, 0x7080, 0x0201, 0x0108, 0x21C3, 0x0132, 0x0000,
    0x0088, 0x0719, 0x0802, 0x0560, 0x0012, 0x4C0E, 0x0405, 0xF0A1,
    0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0080,
    0x8E8D, 0x035A, 0x21BD, 0x5A04, 0x3488, 0x1170, 0x0026, 0x0000,
    0x0000, 0x1000, 0xC502, 0x8804, 0xB815, 0xF801, 0x147C, 0x25ED,
    0xED60, 0x1BB0, 0x0589, 0x1BD7, 0x7AF3, 0x1A62, 0x0D0C, 0x0AC5,
    0xE5D1, 0x524A, 0x0490, 0x6305, 0x0354, 0x5244, 0x2B57, 0x1612,
    0xA872, 0x1101, 0x2949, 0x0018, 0x0948, 0x1008, 0x6000, 0x886C,
    0x916E, 0x058F, 0x3012, 0x3990, 0xF840, 0x4930, 0x8880, 0x001B,
    0x0000, 0x0000, 0x8500, 0x0042, 0x0058, 0x9800, 0xEA04, 0x7014,
    0x1628, 0x611D, 0x5113, 0x6000, 0x1A24, 0x00A7, 0x0000, 0x0000,
    0x0000, 0x03C0, 0x7120, 0x1018, 0x0172, 0xA927, 0x6004, 0x8906,
    0xC022, 0x020C, 0x0900, 0x4081, 0x202D, 0x8CA0, 0x0E34, 0x0000,
    0x0000, 0x0000, 0x2100, 0x1101, 0x8011, 0xC11A, 0xEC4C, 0x0892,
    0x0040, 0x8500, 0xC7AC, 0x1806, 0xE03E, 0x0512, 0x8000, 0x0010,
    0x4008, 0x80CE, 0x6D01, 0x0210, 0x8641, 0x0856, 0x011E, 0x0027,
    0x3750, 0x083D, 0xE032, 0x4E05, 0x01C0, 0x0484, 0x0081, 0x0140,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1AA0, 0x0059,
    0x43C8, 0x8824, 0x1D48, 0xC800, 0x0152, 0x7203, 0x9013, 0x0404,
    0x8280, 0x0400, 0x8A10, 0x0D14, 0x8056, 0x0208, 0xA040, 0x2704,
    0x0000, 0x4C00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xA320,
    0x1902, 0xA0AE, 0x2660, 0xDF00, 0xF010, 0x7B15, 0x8121, 0x3AD0,
    0x4180, 0x0028, 0x1003, 0x4800, 0xCC00, 0x8014, 0x14CF, 0x00C4,
    0x2000, 0x3020, 0x0001,
};

/* Multibyte indexes for URO (U+4E00-U+9FFF) block */
static const unsigned short sjis_uro_mb_ind[1307] = {
      434,   444,   453,   457,   465,   472,   480,   481,
      484,   494,   504,   515,   519,   530,   539,   544,
      549,   555,   560,   561,   568,   574,   585,   587,
      594,   600,   605,   611,   614,   619,   628,   634,
      640,   646,   653,   664,   666,   671,   676,   678,
      684,   687,   691,   693,   699,   705,   710,   715,
      718,   723,   730,   732,   738,   751,   756,   765,
      771,   780,   788,   798,   807,   814,   818,   825,
      834,   843,   847,   853,   861,   869,   873,   879,
      887,   892,   897,   904,   910,   916,   924,   930,
      938,   945,   952,   957,   964,   974,   983,   988,
      997,   999,  1003,  1010,  1014,  1023,  1029,  1042,
     1050,  1061,  1066,  1073,  1080,  1087,  1089,  1091,
     1100,  1107,  1109,  1116,  1122,  1129,  1130,  1138,
     1141,  1145,  1148,  1150,  1155,  1161,  1166,  1167,
     1170,  1177,  1184,  1191,  1193,  1196,  1200,  1202,
     1206,  1208,  1213,  1215,  1220,  1223,  1225,  1230,
     1233,  1238,  1239,  1243,  1246,  1252,  1259,  1262,
     1269,  1277,  1283,  1287,  1291,  1297,  1299,  1304,
     1305,  1309,  1310,  1315,  1317,  1322,  1328,  1330,
     1335,  1341,  1344,  1348,  1354,  1358,  1366,  1369,
     1374,  1376,  1380,  1383,  1389,  1394,  1403,  1409,
     1418,  1422,  1430,  1439,  1444,  1450,  1457,  1466,
     1470,  1476,  1481,  1485,  1489,  1492,  1499,  1504,
     1507,  1510,  1515,  1519,  1522,  1526,  1527,  1531,
     1532,  1532,  1535,  1535,  1538,  1543,  1546,  1550,
     1552,  1555,  1556,  1559,  1563,  1566,  1577,  1583,
     1589,  1599,  1608,  1614,  1622,  1630,  1638,  1648,
     1656,  1669,  1673,  1678,  1687,  1697,  1702,  1709,
     1712,  1713,  1716,  1721,  1729,  1731,  1732,  1739,
     1744,  1747,  1757,  1759,  1759,  1762,  1765,  1768,
     1770,  1775,  1777,  1780,  1784,  1787,  1793,  1801,
     1810,  1815,  1821,  1825,  1831,  1838,  1842,  1846,
     1859,  1865,  1870,  1875,  1879,  1886,  1893,  1900,
     1912,  1921,  1931,  1937,  1943,  1948,  1955,  1963,
     1970,  1981,  1989,  1996,  2001,  2005,  2011,  2014,
     2021,  2023,  2031,  2041,  2043,  2050,  2056,  2068,
     2071,  2078,  2085,  2091,  2099,  2102,  2108,  2113,
     2122,  2131,  2135,  2139,  2144,  2153,  2160,  2168,
     2176,  2180,  2186,  2192,  2196,  2205,  2206,  2208,
     2218,  2225,  2235,  2240,  2247,  2255,  2260,  2264,
     2270,  2276,  2287,  2289,  2295,  2305,  2316,  2322,
     2329,  2335,  2338,  2342,  2346,  2350,  2354,  2359,
     2364,  2371,  2376,  2387,  2392,  2398,  2403,  2407,
     2410,  2413,  2417,  2421,  2425,  2427,  2428,  2431,
     2434,  2436,  2441,  2447,  2452,  2457,  2461,  2469,
     2476,  2478,  2481,  2487,  2496,  2500,  2508,  2512,
     2518,  2525,  2532,  2540,  2545,  2553,  2557,  2567,
     2570,  2578,  2582,  2588,  2593,  2600,  2604,  2612,
     2616,  2623,  2628,  2632,  2637,  2641,  2646,  2649,
     2661,  2668,  2676,  2684,  2692,  2697,  2705,  2714,
     2723,  2728,  2734,  2740,  2746,  2752,  2760,  2767,
     2774,  2777,  2781,  2786,  2792,  2800,  2808,  2810,
     2815,  2820,  2826,  2833,  2841,  2847,  2854,  2860,
     2863,  2873,  2878,  2885,  2891,  2892,  2900,  2908,
     2917,  2921,  2926,  2929,  2935,  2943,  2949,  2953,
     2958,  2963,  2971,  2978,  2984,  2988,  2991,  2994,
     2997,  3001,  3004,  3010,  3013,  3016,  3022,  3024,
     3026,  3029,  3033,  3037,  3044,  3049,  3055,  3063,
     3069,  3077,  3081,  3085,  3095,  3101,  3107,  3110,
     3111,  3113,  3118,  3120,  3124,  3128,  3135,  3139,
     3145,  3151,  3158,  3162,  3172,  3178,  3184,  3191,
     3194,  3196,  3202,  3206,  3214,  3217,  3220,  3227,
     3231,  3235,  3240,  3241,  3245,  3251,  3257,  3265,
     3272,  3278,  3285,  3297,  3300,  3304,  3308,  3312,
     3316,  3320,  3326,  3330,  3335,  3341,  3347,  3349,
     3355,  3360,  3364,  3369,  3374,  3376,  3381,  3386,
     3391,  3397,  3399,  3403,  3406,  3411,  3416,  3423,
     3428,  3432,  3440,  3443,  3446,  3447,  3449,  3452,
     3456,  3459,  3461,  3465,  3469,  3472,  3475,  3475,
     3478,  3479,  3483,  3485,  3487,  3490,  3493,  3501,
     3502,  3506,  3510,  3512,  3515,  3519,  3525,  3532,
     3537,  3539,  3541,  3545,  3555,  3561,  3567,  3571,
     3576,  3580,  3582,  3587,  3590,  3595,  3600,  3606,
     3611,  3612,  3618,  3624,  3629,  3633,  3634,  3637,
     3643,  3647,  3648,  3649,  3652,  3658,  3659,  3664,
     3667,  3671,  3671,  3673,  3680,  3681,  3688,  3694,
     3698,  3700,  3701,  3703,  3705,  3707,  3709,  3716,
     3722,  3728,  3736,  3742,  3751,  3759,  3766,  3776,
     3783,  3791,  3795,  3798,  3807,  3813,  3820,  3823,
     3831,  3835,  3836,  3841,  3844,  3849,  3853,  3860,
     3869,  3877,  3882,  3883,  3890,  3896,  3903,  3910,
     3915,  3922,  3925,  3930,  3934,  3936,  3938,  3944,
     3947,  3949,  3951,  3955,  3963,  3965,  3969,  3977,
     3979,  3981,  3984,  3988,  3992,  3993,  3994,  3997,
     4000,  4006,  4011,  4016,  4020,  4025,  4029,  4033,
     4035,  4038,  4041,  4045,  4048,  4053,  4062,  4067,
     4070,  4078,  4079,  4083,  4090,  4094,  4099,  4106,
     4108,  4113,  4120,  4122,  4130,  4138,  4140,  4145,
     4152,  4156,  4163,  4167,  4171,  4180,  4188,  4197,
     4203,  4210,  4215,  4220,  4224,  4232,  4238,  4242,
     4247,  4252,  4262,  4265,  4268,  4277,  4278,  4284,
     4287,  4290,  4296,  4301,  4306,  4311,  4316,  4320,
     4323,  4329,  4336,  4345,  4351,  4356,  4362,  4366,
     4373,  4381,  4390,  4397,  4404,  4413,  4417,  4423,
     4430,  4432,  4438,  4445,  4456,  4460,  4468,  4475,
     4478,  4484,  4488,  4494,  4503,  4509,  4516,  4521,
     4527,  4534,  4541,  4541,  4541,  4541,  4541,  4541,
     4541,  4541,  4541,  4541,  4544,  4548,  4554,  4561,
     4567,  4576,  4580,  4586,  4591,  4596,  4599,  4604,
     4609,  4617,  4624,  4626,  4631,  4633,  4639,  4643,
     4653,  4660,  4666,  4674,  4678,  4683,  4689,  4693,
     4698,  4705,  4707,  4710,  4714,  4717,  4723,  4727,
     4734,  4740,  4745,  4750,  4758,  4764,  4770,  4777,
     4783,  4793,  4802,  4807,  4813,  4815,  4820,  4828,
     4834,  4836,  4840,  4846,  4852,  4853,  4863,  4869,
     4875,  4882,  4886,  4890,  4897,  4902,  4905,  4905,
     4910,  4915,  4920,  4925,  4928,  4933,  4938,  4942,
     4949,  4956,  4957,  4962,  4967,  4970,  4972,  4982,
     4987,  4990,  4995,  4997,  5003,  5010,  5015,  5017,
     5020,  5022,  5030,  5034,  5036,  5044,  5048,  5053,
     5055,  5060,  5067,  5076,  5078,  5082,  5086,  5090,
     5095,  5100,  5104,  5107,  5109,  5111,  5118,  5120,
     5123,  5126,  5128,  5134,  5136,  5143,  5148,  5154,
     5158,  5166,  5171,  5173,  5177,  5181,  5186,  5192,
     5196,  5198,  5199,  5202,  5206,  5211,  5213,  5215,
     5221,  5225,  5228,  5232,  5236,  5242,  5249,  5254,
     5261,  5266,  5271,  5275,  5281,  5287,  5294,  5296,
     5304,  5309,  5314,  5317,  5320,  5325,  5328,  5334,
     5339,  5347,  5352,  5359,  5364,  5365,  5369,  5372,
     5374,  5381,  5389,  5393,  5400,  5403,  5410,  5419,
     5424,  5431,  5437,  5446,  5451,  5458,  5464,  5473,
     5479,  5486,  5494,  5500,  5503,  5508,  5514,  5518,
     5524,  5529,  5535,  5535,  5535,  5535,  5535,  5535,
     5535,  5535,  5535,  5535,  5538,  5544,  5547,  5552,
     5556,  5563,  5567,  5579,  5590,  5600,  5606,  5613,
     5617,  5625,  5629,  5629,  5629,  5629,  5629,  5634,
     5639,  5642,  5643,  5645,  5648,  5652,  5657,  5663,
     5667,  5671,  5675,  5676,  5679,  5686,  5690,  5693,
     5697,  5704,  5708,  5713,  5716,  5723,  5726,  5729,
     5734,  5739,  5748,  5752,  5758,  5766,  5769,  5773,
     5773,  5773,  5777,  5783,  5791,  5795,  5798,  5806,
     5813,  5822,  5834,  5840,  5848,  5858,  5869,  5878,
     5887,  5896,  5897,  5902,  5905,  5908,  5909,  5914,
     5917,  5918,  5920,  5921,  5923,  5929,  5933,  5939,
     5944,  5949,  5953,  5958,  5962,  5973,  5981,  5985,
     5989,  5991,  5995,  5997,  6000,  6005,  6010,  6013,
     6015,  6018,  6026,  6027,  6029,  6030,  6031,  6035,
     6040,  6042,  6046,  6055,  6059,  6062,  6066,  6069,
     6072,  6073,  6077,  6081,  6083,  6085,  6091,  6095,
     6095,  6097,  6103,  6105,  6109,  6111,  6117,  6120,
     6127,  6128,  6128,  6128,  6128,  6128,  6128,  6128,
     6128,  6128,  6128,  6128,  6128,  6128,  6128,  6128,
     6129,  6137,  6143,  6151,  6156,  6161,  6166,  6169,
     6169,  6169,  6170,  6175,  6178,  6185,  6191,  6198,
     6207,  6215,  6222,  6227,  6237,  6248,  6254,  6259,
     6265,  6274,  6280,  6283,  6289,  6294,  6299,  6308,
     6313,  6320,  6323,  6329,  6331,  6335,  6337,  6339,
     6345,  6353,  6360,  6364,  6370,  6376,  6381,  6384,
     6388,  6388,  6388,  6391,  6393,  6396,  6399,  6405,
     6410,  6415,  6422,  6428,  6430,  6435,  6440,  6440,
     6440,  6440,  6444,  6449,  6452,  6457,  6465,  6468,
     6473,  6477,  6480,  6482,  6485,  6490,  6495,  6501,
     6501,  6501,  6501,  6503,  6506,  6509,  6515,  6523,
     6527,  6528,  6531,  6540,  6544,  6552,  6556,  6557,
     6558,  6560,  6566,  6572,  6574,  6579,  6584,  6589,
     6593,  6600,  6606,  6612,  6618,  6621,  6624,  6626,
     6628,  6628,  6628,  6628,  6628,  6628,  6628,  6633,
     6637,  6643,  6647,  6653,  6656,  6660,  6666,  6671,
     6673,  6676,  6677,  6681,  6686,  6691,  6693,  6696,
     6701,  6701,  6704,  6704,  6704,  6704,  6704,  6704,
     6709,  6713,  6720,  6725,  6732,  6737,  6746,  6750,
     6757,  6760,  6762,  6765,  6767,  6771,  6774,  6782,
     6785,  6786,  6789,
};

/* Unicode codepoints sorted */
static const unsigned short sjis_u[588] = {
    0x005C, 0x00A2, 0x00A3, 0x00A5, 0x00A7, 0x00A8, 0x00AC, 0x00B0,
    0x00B1, 0x00B4, 0x00B6, 0x00D7, 0x00F7, 0x0391, 0x0392, 0x0393,
    0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039A, 0x039B,
    0x039C, 0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A3, 0x03A4,
    0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9, 0x03B1, 0x03B2, 0x03B3,
    0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB,
    0x03BC, 0x03BD, 0x03BE, 0x03BF, 0x03C0, 0x03C1, 0x03C3, 0x03C4,
    0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9, 0x0401, 0x0410, 0x0411,
    0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417, 0x0418, 0x0419,
    0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F, 0x0420, 0x0421,
    0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429,
    0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F, 0x0430, 0x0431,
    0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437, 0x0438, 0x0439,
    0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F, 0x0440, 0x0441,
    0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449,
    0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 0x0451, 0x2010,
    0x2015, 0x2016, 0x2018, 0x2019, 0x201C, 0x201D, 0x2020, 0x2021,
    0x2025, 0x2026, 0x2030, 0x2032, 0x2033, 0x203B, 0x203E, 0x2103,
    0x212B, 0x2190, 0x2191, 0x2192, 0x2193, 0x21D2, 0x21D4, 0x2200,
    0x2202, 0x2203, 0x2207, 0x2208, 0x220B, 0x2212, 0x221A, 0x221D,
    0x221E, 0x2220, 0x2227, 0x2228, 0x2229, 0x222A, 0x222B, 0x222C,
    0x2234, 0x2235, 0x223D, 0x2252, 0x2260, 0x2261, 0x2266, 0x2267,
    0x226A, 0x226B, 0x2282, 0x2283, 0x2286, 0x2287, 0x22A5, 0x2312,
    0x2500, 0x2501, 0x2502, 0x2503, 0x250C, 0x250F, 0x2510, 0x2513,
    0x2514, 0x2517, 0x2518, 0x251B, 0x251C, 0x251D, 0x2520, 0x2523,
    0x2524, 0x2525, 0x2528, 0x252B, 0x252C, 0x252F, 0x2530, 0x2533,
    0x2534, 0x2537, 0x2538, 0x253B, 0x253C, 0x253F, 0x2542, 0x254B,
    0x25A0, 0x25A1, 0x25B2, 0x25B3, 0x25BC, 0x25BD, 0x25C6, 0x25C7,
    0x25CB, 0x25CE, 0x25CF, 0x25EF, 0x2605, 0x2606, 0x2640, 0x2642,
    0x266A, 0x266D, 0x266F, 0x3000, 0x3001, 0x3002, 0x3003, 0x3005,
    0x3006, 0x3007, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C, 0x300D,
    0x300E, 0x300F, 0x3010, 0x3011, 0x3012, 0x3013, 0x3014, 0x3015,
    0x301C, 0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047,
    0x3048, 0x3049, 0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F,
    0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057,
    0x3058, 0x3059, 0x305A, 0x305B, 0x305C, 0x305D, 0x305E, 0x305F,
    0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067,
    0x3068, 0x3069, 0x306A, 0x306B, 0x306C, 0x306D, 0x306E, 0x306F,
    0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077,
    0x3078, 0x3079, 0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F,
    0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087,
    0x3088, 0x3089, 0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F,
    0x3090, 0x3091, 0x3092, 0x3093, 0x309B, 0x309C, 0x309D, 0x309E,
    0x30A1, 0x30A2, 0x30A3, 0x30A4, 0x30A5, 0x30A6, 0x30A7, 0x30A8,
    0x30A9, 0x30AA, 0x30AB, 0x30AC, 0x30AD, 0x30AE, 0x30AF, 0x30B0,
    0x30B1, 0x30B2, 0x30B3, 0x30B4, 0x30B5, 0x30B6, 0x30B7, 0x30B8,
    0x30B9, 0x30BA, 0x30BB, 0x30BC, 0x30BD, 0x30BE, 0x30BF, 0x30C0,
    0x30C1, 0x30C2, 0x30C3, 0x30C4, 0x30C5, 0x30C6, 0x30C7, 0x30C8,
    0x30C9, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE, 0x30CF, 0x30D0,
    0x30D1, 0x30D2, 0x30D3, 0x30D4, 0x30D5, 0x30D6, 0x30D7, 0x30D8,
    0x30D9, 0x30DA, 0x30DB, 0x30DC, 0x30DD, 0x30DE, 0x30DF, 0x30E0,
    0x30E1, 0x30E2, 0x30E3, 0x30E4, 0x30E5, 0x30E6, 0x30E7, 0x30E8,
    0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EE, 0x30EF, 0x30F0,
    0x30F1, 0x30F2, 0x30F3, 0x30F4, 0x30F5, 0x30F6, 0x30FB, 0x30FC,
    0x30FD, 0x30FE, 0xFF01, 0xFF03, 0xFF04, 0xFF05, 0xFF06, 0xFF08,
    0xFF09, 0xFF0A, 0xFF0B, 0xFF0C, 0xFF0E, 0xFF0F, 0xFF10, 0xFF11,
    0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17, 0xFF18, 0xFF19,
    0xFF1A, 0xFF1B, 0xFF1C, 0xFF1D, 0xFF1E, 0xFF1F, 0xFF20, 0xFF21,
    0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 0xFF28, 0xFF29,
    0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 0xFF30, 0xFF31,
    0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 0xFF37, 0xFF38, 0xFF39,
    0xFF3A, 0xFF3B, 0xFF3D, 0xFF3E, 0xFF3F, 0xFF40, 0xFF41, 0xFF42,
    0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 0xFF48, 0xFF49, 0xFF4A,
    0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 0xFF52,
    0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A,
    0xFF5B, 0xFF5C, 0xFF5D, 0xFF61, 0xFF62, 0xFF63, 0xFF64, 0xFF65,
    0xFF66, 0xFF67, 0xFF68, 0xFF69, 0xFF6A, 0xFF6B, 0xFF6C, 0xFF6D,
    0xFF6E, 0xFF6F, 0xFF70, 0xFF71, 0xFF72, 0xFF73, 0xFF74, 0xFF75,
    0xFF76, 0xFF77, 0xFF78, 0xFF79, 0xFF7A, 0xFF7B, 0xFF7C, 0xFF7D,
    0xFF7E, 0xFF7F, 0xFF80, 0xFF81, 0xFF82, 0xFF83, 0xFF84, 0xFF85,
    0xFF86, 0xFF87, 0xFF88, 0xFF89, 0xFF8A, 0xFF8B, 0xFF8C, 0xFF8D,
    0xFF8E, 0xFF8F, 0xFF90, 0xFF91, 0xFF92, 0xFF93, 0xFF94, 0xFF95,
    0xFF96, 0xFF97, 0xFF98, 0xFF99, 0xFF9A, 0xFF9B, 0xFF9C, 0xFF9D,
    0xFF9E, 0xFF9F, 0xFFE3, 0xFFE5,
};

/* Multibyte values sorted in Unicode order */
static const unsigned short sjis_mb[6944] = {
    0x815F, 0x8191, 0x8192, 0x005C, 0x8198, 0x814E, 0x81CA, 0x818B,
    0x817D, 0x814C, 0x81F7, 0x817E, 0x8180, 0x839F, 0x83A0, 0x83A1,
    0x83A2, 0x83A3, 0x83A4, 0x83A5, 0x83A6, 0x83A7, 0x83A8, 0x83A9,
    0x83AA, 0x83AB, 0x83AC, 0x83AD, 0x83AE, 0x83AF, 0x83B0, 0x83B1,
    0x83B2, 0x83B3, 0x83B4, 0x83B5, 0x83B6, 0x83BF, 0x83C0, 0x83C1,
    0x83C2, 0x83C3, 0x83C4, 0x83C5, 0x83C6, 0x83C7, 0x83C8, 0x83C9,
    0x83CA, 0x83CB, 0x83CC, 0x83CD, 0x83CE, 0x83CF, 0x83D0, 0x83D1,
    0x83D2, 0x83D3, 0x83D4, 0x83D5, 0x83D6, 0x8446, 0x8440, 0x8441,
    0x8442, 0x8443, 0x8444, 0x8445, 0x8447, 0x8448, 0x8449, 0x844A,
    0x844B, 0x844C, 0x844D, 0x844E, 0x844F, 0x8450, 0x8451, 0x8452,
    0x8453, 0x8454, 0x8455, 0x8456, 0x8457, 0x8458, 0x8459, 0x845A,
    0x845B, 0x845C, 0x845D, 0x845E, 0x845F, 0x8460, 0x8470, 0x8471,
    0x8472, 0x8473, 0x8474, 0x8475, 0x8477, 0x8478, 0x8479, 0x847A,
    0x847B, 0x847C, 0x847D, 0x847E, 0x8480, 0x8481, 0x8482, 0x8483,
    0x8484, 0x8485, 0x8486, 0x8487, 0x8488, 0x8489, 0x848A, 0x848B,
    0x848C, 0x848D, 0x848E, 0x848F, 0x8490, 0x8491, 0x8476, 0x815D,
    0x815C, 0x8161, 0x8165, 0x8166, 0x8167, 0x8168, 0x81F5, 0x81F6,
    0x8164, 0x8163, 0x81F1, 0x818C, 0x818D, 0x81A6, 0x007E, 0x818E,
    0x81F0, 0x81A9, 0x81AA, 0x81A8, 0x81AB, 0x81CB, 0x81CC, 0x81CD,
    0x81DD, 0x81CE, 0x81DE, 0x81B8, 0x81B9, 0x817C, 0x81E3, 0x81E5,
    0x8187, 0x81DA, 0x81C8, 0x81C9, 0x81BF, 0x81BE, 0x81E7, 0x81E8,
    0x8188, 0x81E6, 0x81E4, 0x81E0, 0x8182, 0x81DF, 0x8185, 0x8186,
    0x81E1, 0x81E2, 0x81BC, 0x81BD, 0x81BA, 0x81BB, 0x81DB, 0x81DC,
    0x849F, 0x84AA, 0x84A0, 0x84AB, 0x84A1, 0x84AC, 0x84A2, 0x84AD,
    0x84A4, 0x84AF, 0x84A3, 0x84AE, 0x84A5, 0x84BA, 0x84B5, 0x84B0,
    0x84A7, 0x84BC, 0x84B7, 0x84B2, 0x84A6, 0x84B6, 0x84BB, 0x84B1,
    0x84A8, 0x84B8, 0x84BD, 0x84B3, 0x84A9, 0x84B9, 0x84BE, 0x84B4,
    0x81A1, 0x81A0, 0x81A3, 0x81A2, 0x81A5, 0x81A4, 0x819F, 0x819E,
    0x819B, 0x819D, 0x819C, 0x81FC, 0x819A, 0x8199, 0x818A, 0x8189,
    0x81F4, 0x81F3, 0x81F2, 0x8140, 0x8141, 0x8142, 0x8156, 0x8158,
    0x8159, 0x815A, 0x8171, 0x8172, 0x8173, 0x8174, 0x8175, 0x8176,
    0x8177, 0x8178, 0x8179, 0x817A, 0x81A7, 0x81AC, 0x816B, 0x816C,
    0x8160, 0x829F, 0x82A0, 0x82A1, 0x82A2, 0x82A3, 0x82A4, 0x82A5,
    0x82A6, 0x82A7, 0x82A8, 0x82A9, 0x82AA, 0x82AB, 0x82AC, 0x82AD,
    0x82AE, 0x82AF, 0x82B0, 0x82B1, 0x82B2, 0x82B3, 0x82B4, 0x82B5,
    0x82B6, 0x82B7, 0x82B8, 0x82B9, 0x82BA, 0x82BB, 0x82BC, 0x82BD,
    0x82BE, 0x82BF, 0x82C0, 0x82C1, 0x82C2, 0x82C3, 0x82C4, 0x82C5,
    0x82C6, 0x82C7, 0x82C8, 0x82C9, 0x82CA, 0x82CB, 0x82CC, 0x82CD,
    0x82CE, 0x82CF, 0x82D0, 0x82D1, 0x82D2, 0x82D3, 0x82D4, 0x82D5,
    0x82D6, 0x82D7, 0x82D8, 0x82D9, 0x82DA, 0x82DB, 0x82DC, 0x82DD,
    0x82DE, 0x82DF, 0x82E0, 0x82E1, 0x82E2, 0x82E3, 0x82E4, 0x82E5,
    0x82E6, 0x82E7, 0x82E8, 0x82E9, 0x82EA, 0x82EB, 0x82EC, 0x82ED,
    0x82EE, 0x82EF, 0x82F0, 0x82F1, 0x814A, 0x814B, 0x8154, 0x8155,
    0x8340, 0x8341, 0x8342, 0x8343, 0x8344, 0x8345, 0x8346, 0x8347,
    0x8348, 0x8349, 0x834A, 0x834B, 0x834C, 0x834D, 0x834E, 0x834F,
    0x8350, 0x8351, 0x8352, 0x8353, 0x8354, 0x8355, 0x8356, 0x8357,
    0x8358, 0x8359, 0x835A, 0x835B, 0x835C, 0x835D, 0x835E, 0x835F,
    0x8360, 0x8361, 0x8362, 0x8363, 0x8364, 0x8365, 0x8366, 0x8367,
    0x8368, 0x8369, 0x836A, 0x836B, 0x836C, 0x836D, 0x836E, 0x836F,
    0x8370, 0x8371, 0x8372, 0x8373, 0x8374, 0x8375, 0x8376, 0x8377,
    0x8378, 0x8379, 0x837A, 0x837B, 0x837C, 0x837D, 0x837E, 0x8380,
    0x8381, 0x8382, 0x8383, 0x8384, 0x8385, 0x8386, 0x8387, 0x8388,
    0x8389, 0x838A, 0x838B, 0x838C, 0x838D, 0x838E, 0x838F, 0x8390,
    0x8391, 0x8392, 0x8393, 0x8394, 0x8395, 0x8396, 0x8145, 0x815B,
    0x8152, 0x8153, 0x88EA, 0x929A, 0x8EB5, 0x969C, 0x8FE4, 0x8E4F,
    0x8FE3, 0x89BA, 0x9573, 0x975E, 0x98A0, 0x894E, 0x8A8E, 0x98A1,
    0x90A2, 0x99C0, 0x8B75, 0x95B8, 0x8FE5, 0x97BC, 0x95C0, 0x98A2,
    0x9286, 0x98A3, 0x8BF8, 0x98A4, 0x8ADB, 0x924F, 0x8EE5, 0x98A5,
    0x98A6, 0x98A7, 0x9454, 0x8B76, 0x9456, 0x93E1, 0x8CC1, 0x9652,
    0xE568, 0x98A8, 0x8FE6, 0x98A9, 0x89B3, 0x8BE3, 0x8CEE, 0x96E7,
    0x9BA4, 0x9790, 0x93FB, 0x8AA3, 0x8B54, 0x98AA, 0x98AB, 0x97B9,
    0x975C, 0x9188, 0x98AD, 0x8E96, 0x93F1, 0x98B0, 0x895D, 0x8CDD,
    0x8CDC, 0x88E4, 0x986A, 0x9869, 0x8DB1, 0x889F, 0x98B1, 0x98B2,
    0x98B3, 0x9653, 0x98B4, 0x8CF0, 0x88E5, 0x9692, 0x8B9C, 0x8B9D,
    0x8B9E, 0x92E0, 0x97BA, 0x98B5, 0x98B6, 0x98B7, 0x906C, 0x8F59,
    0x906D, 0x98BC, 0x98BA, 0x98BB, 0x8B77, 0x8DA1, 0x89EE, 0x98B9,
    0x98B8, 0x95A7, 0x8E65, 0x8E64, 0x91BC, 0x98BD, 0x9574, 0x90E5,
    0x8157, 0x98BE, 0x98C0, 0x91E3, 0x97DF, 0x88C8, 0x98BF, 0x89BC,
    0x8BC2, 0x9287, 0x8C8F, 0x98C1, 0x9443, 0x8AE9, 0x98C2, 0x88C9,
    0x8CDE, 0x8AEA, 0x959A, 0x94B0, 0x8B78, 0x89EF, 0x98E5, 0x9360,
    0x948C, 0x98C4, 0x94BA, 0x97E0, 0x904C, 0x8E66, 0x8E97, 0x89BE,
    0x92CF, 0x9241, 0x98C8, 0x88CA, 0x92E1, 0x8F5A, 0x8DB2, 0x9743,
    0x91CC, 0x89BD, 0x98C7, 0x975D, 0x98C3, 0x98C5, 0x8DEC, 0x98C6,
    0x9B43, 0x98CE, 0x98D1, 0x98CF, 0x89C0, 0x95B9, 0x98C9, 0x98CD,
    0x8CF1, 0x8E67, 0x8AA4, 0x98D2, 0x98CA, 0x97E1, 0x8E98, 0x98CB,
    0x98D0, 0x98D3, 0x98CC, 0x8B9F, 0x88CB, 0x8BA0, 0x89BF, 0x9B44,
    0x9699, 0x958E, 0x8CF2, 0x904E, 0x97B5, 0x95D6, 0x8C57, 0x91A3,
    0x89E2, 0x8F72, 0x98D7, 0x98DC, 0x98DA, 0x98D5, 0x91AD, 0x98D8,
    0x98DB, 0x98D9, 0x95DB, 0x98D6, 0x904D, 0x9693, 0x98DD, 0x98DE,
    0x8F43, 0x98EB, 0x946F, 0x9555, 0x98E6, 0x95EE, 0x89B4, 0x98EA,
    0x98E4, 0x98ED, 0x9171, 0x8CC2, 0x947B, 0xE0C5, 0x98EC, 0x937C,
    0x98E1, 0x8CF4, 0x8CF3, 0x98DF, 0x8ED8, 0x98E7, 0x95ED, 0x926C,
    0x98E3, 0x8C91, 0x98E0, 0x98E8, 0x98E2, 0x97CF, 0x98E9, 0x9860,
    0x8BE4, 0x8C90, 0x98EE, 0x98EF, 0x98F3, 0x88CC, 0x95CE, 0x98F2,
    0x98F1, 0x98F5, 0x98F4, 0x92E2, 0x8C92, 0x98F6, 0x8EC3, 0x91A4,
    0x92E3, 0x8BF4, 0x98F7, 0x8B55, 0x98F8, 0x98FA, 0x9654, 0x8C86,
    0x8E50, 0x94F5, 0x98F9, 0x8DC3, 0x9762, 0x98FC, 0x9942, 0x98FB,
    0x8DC2, 0x8F9D, 0x8C58, 0x9943, 0x8BCD, 0x9940, 0x9941, 0x93AD,
    0x919C, 0x8BA1, 0x966C, 0x9944, 0x97BB, 0x9945, 0x9948, 0x9946,
    0x916D, 0x9947, 0x9949, 0x994B, 0x994A, 0x95C6, 0x8B56, 0x994D,
    0x994E, 0x89AD, 0x994C, 0x8EF2, 0x9951, 0x9950, 0x994F, 0x98D4,
    0x9952, 0x8F9E, 0x9953, 0x9744, 0x96D7, 0x9955, 0x9954, 0x9957,
    0x9956, 0x9958, 0x9959, 0x88F2, 0x8CB3, 0x8C5A, 0x8F5B, 0x929B,
    0x8BA2, 0x90E6, 0x8CF5, 0x8D8E, 0x995B, 0x96C6, 0x9365, 0x8E99,
    0x995A, 0x995C, 0x937D, 0x8A95, 0x995D, 0x93FC, 0x9153, 0x995F,
    0x9960, 0x94AA, 0x8CF6, 0x985A, 0x9961, 0x8BA4, 0x95BA, 0x91B4,
    0x8BEF, 0x9354, 0x8C93, 0x9962, 0x9963, 0x93E0, 0x897E, 0x9966,
    0x8DFB, 0x9965, 0x8DC4, 0x9967, 0xE3EC, 0x9968, 0x9660, 0x9969,
    0x996A, 0x996B, 0x8FE7, 0x8ECA, 0x8AA5, 0x996E, 0x996C, 0x96BB,
    0x996D, 0x9579, 0x996F, 0x9970, 0x9971, 0x937E, 0x9975, 0x9973,
    0x9974, 0x9972, 0x8DE1, 0x9976, 0x96E8, 0x97E2, 0x9977, 0x90A6,
    0x9978, 0x8F79, 0x9979, 0x929C, 0x97BD, 0x9380, 0x99C3, 0x997A,
    0xEAA3, 0x8BC3, 0x997B, 0x967D, 0x8F88, 0x91FA, 0x997D, 0x93E2,
    0x997E, 0x9980, 0x8A4D, 0x9981, 0x8BA5, 0x93CA, 0x899A, 0x8F6F,
    0x949F, 0x9982, 0x9381, 0x906E, 0x9983, 0x95AA, 0x90D8, 0x8AA0,
    0x8AA7, 0x9984, 0x9986, 0x8C59, 0x9985, 0x97F1, 0x8F89, 0x94BB,
    0x95CA, 0x9987, 0x9798, 0x9988, 0x9989, 0x939E, 0x998A, 0x90A7,
    0x8DFC, 0x8C94, 0x998B, 0x8E68, 0x8D8F, 0x92E4, 0x998D, 0x91A5,
    0x8DED, 0x998E, 0x998F, 0x914F, 0x998C, 0x9991, 0x9655, 0x8D84,
    0x9990, 0x8C95, 0x8DDC, 0x948D, 0x9994, 0x9992, 0x959B, 0x8FE8,
    0x999B, 0x8A84, 0x9995, 0x9993, 0x916E, 0x9997, 0x9996, 0x8A63,
    0x8C80, 0x999C, 0x97AB, 0x9998, 0x999D, 0x999A, 0x9999, 0x97CD,
    0x8CF7, 0x89C1, 0x97F2, 0x8F95, 0x9377, 0x8D85, 0x99A0, 0x99A1,
    0x97E3, 0x984A, 0x99A3, 0x8CF8, 0x99A2, 0x8A4E, 0x99A4, 0x9675,
    0x92BA, 0x9745, 0x95D7, 0x99A5, 0xE8D3, 0x93AE, 0x99A6, 0x8AA8,
    0x96B1, 0x8F9F, 0x99A7, 0x95E5, 0x99AB, 0x90A8, 0x99A8, 0x8BCE,
    0x99A9, 0x8AA9, 0x8C4D, 0x99AC, 0x99AD, 0x99AE, 0x99AF, 0x8ED9,
    0x8CF9, 0x96DC, 0x96E6, 0x93F5, 0x95EF, 0x99B0, 0x99B1, 0x99B3,
    0x99B5, 0x99B4, 0x99B6, 0x89BB, 0x966B, 0x8DFA, 0x99B7, 0x9178,
    0x8FA0, 0x8BA7, 0x99B8, 0x94D9, 0x99B9, 0x99BA, 0x99BB, 0x99BC,
    0x9543, 0x8BE6, 0x88E3, 0x93BD, 0x99BD, 0x8F5C, 0x90E7, 0x99BF,
    0x99BE, 0x8FA1, 0x8CDF, 0x99C1, 0x94BC, 0x99C2, 0x94DA, 0x91B2,
    0x91EC, 0x8BA6, 0x93EC, 0x9250, 0x948E, 0x966D, 0x99C4, 0x90E8,
    0x8C54, 0x99C5, 0x99C6, 0x894B, 0x88F3, 0x8AEB, 0x91A6, 0x8B70,
    0x9791, 0x99C9, 0x89B5, 0x99C8, 0x8BA8, 0x99CA, 0x96EF, 0x99CB,
    0x97D0, 0x8CFA, 0x8CB4, 0x99CC, 0x99CE, 0x99CD, 0x907E, 0x8958,
    0x897D, 0x99CF, 0x99D0, 0x8CB5, 0x99D1, 0x8B8E, 0x8E51, 0x99D2,
    0x9694, 0x8DB3, 0x8B79, 0x9746, 0x916F, 0x94BD, 0x8EFB, 0x8F66,
    0x8EE6, 0x8EF3, 0x8F96, 0x94BE, 0x99D5, 0x8962, 0x9170, 0x8CFB,
    0x8CC3, 0x8BE5, 0x99D9, 0x9240, 0x91FC, 0x8BA9, 0x8FA2, 0x99DA,
    0x99D8, 0x89C2, 0x91E4, 0x8EB6, 0x8E6A, 0x8945, 0x8A90, 0x8D86,
    0x8E69, 0x99DB, 0x99DC, 0x8B68, 0x8A65, 0x8D87, 0x8B67, 0x92DD,
    0x8944, 0x93AF, 0x96BC, 0x8D40, 0x9799, 0x9366, 0x8CFC, 0x8C4E,
    0x99E5, 0x8BE1, 0x9669, 0x94DB, 0x99E4, 0x8ADC, 0x99DF, 0x99E0,
    0x99E2, 0x99E3, 0x8B7A, 0x9081, 0x95AB, 0x99E1, 0x99DD, 0x8CE1,
    0x99DE, 0x9843, 0x95F0, 0x92E6, 0x8CE0, 0x8D90, 0x99E6, 0x93DB,
    0x99EA, 0x8EFC, 0x8EF4, 0x99ED, 0x99EB, 0x96A1, 0x99E8, 0x99F1,
    0x99EC, 0x99EF, 0x8CC4, 0x96BD, 0x99F0, 0x99F2, 0x99F4, 0x8DEE,
    0x9861, 0x99E9, 0x99E7, 0x99F3, 0x99EE, 0x99F6, 0x9A42, 0x99F8,
    0x99FC, 0x9A40, 0x99F9, 0x9A5D, 0x8DE7, 0x8A50, 0x99F7, 0x9A44,
    0x88F4, 0x9A43, 0x88A3, 0x9569, 0x9A41, 0x99FA, 0x99F5, 0x99FB,
    0x8DC6, 0x9A45, 0x88F5, 0x9A4E, 0x9A46, 0x9A47, 0x8FA3, 0x9689,
    0x9A4C, 0x9A4B, 0x934E, 0x9A4D, 0x9A4A, 0x8953, 0x8DB4, 0x904F,
    0x9A48, 0x9382, 0x9A49, 0x88A0, 0x9A53, 0x9742, 0x8FA5, 0x9A59,
    0x9A58, 0x9A4F, 0x91C1, 0x9A50, 0x91ED, 0x9A55, 0x8FA4, 0x9A52,
    0x96E2, 0x8C5B, 0x9A56, 0x9A57, 0x9A54, 0x9A5A, 0x9A51, 0x9A60,
    0x9A65, 0x9A61, 0x9A5C, 0x9A66, 0x9150, 0x9A68, 0x8D41, 0x9A5E,
    0x929D, 0x9A62, 0x9A5B, 0x8AAB, 0x8AEC, 0x8A85, 0x9A63, 0x9A5F,
    0x8C96, 0x9A69, 0x9A67, 0x9172, 0x8B69, 0x8BAA, 0x9A64, 0x8BF2,
    0x8963, 0x9A6D, 0x9A6B, 0x9AA5, 0x9A70, 0x9A6A, 0x9A6E, 0x9A6C,
    0x8E6B, 0x9A6F, 0x9A72, 0x9A77, 0x9A75, 0x9A74, 0x9251, 0x89C3,
    0x9A71, 0x9A73, 0x8FA6, 0x8952, 0x9A76, 0x89DC, 0x9A82, 0x8FFA,
    0x9A7D, 0x9A7B, 0x9A7C, 0x9A7E, 0x895C, 0x9158, 0x9A78, 0x9A79,
    0x8A9A, 0x9A81, 0x8AED, 0x9A84, 0x9A80, 0x9A83, 0x95AC, 0x93D3,
    0x94B6, 0x9A86, 0x9A85, 0x8A64, 0x9A87, 0x9A8A, 0x9A89, 0x9A88,
    0x9458, 0x9A8B, 0x9A8C, 0x9A8E, 0x9A8D, 0x9A90, 0x9A93, 0x9A91,
    0x9A8F, 0x9A92, 0x9A94, 0x9A95, 0x9A96, 0x9A97, 0x9A98, 0x9964,
    0x8EFA, 0x8E6C, 0x89F1, 0x88F6, 0x9263, 0x9A99, 0x8DA2, 0x88CD,
    0x907D, 0x9A9A, 0x8CC5, 0x8D91, 0x9A9C, 0x9A9B, 0x95DE, 0x9A9D,
    0x9A9F, 0x9A9E, 0x9AA0, 0x9AA1, 0x8C97, 0x8980, 0x9AA2, 0x9AA4,
    0x9AA3, 0x9AA6, 0x9379, 0x9AA7, 0x88B3, 0x8DDD, 0x8C5C, 0x926E,
    0x9AA8, 0x9AA9, 0x9AAB, 0x9AAC, 0x8DE2, 0x8BCF, 0x9656, 0x9AAA,
    0x9AAD, 0x8DBF, 0x8D42, 0x9AB1, 0x8DA3, 0x9252, 0x9AAE, 0x92D8,
    0x9AB2, 0x9082, 0x9AB0, 0x9AB3, 0x8C5E, 0x9AB4, 0x9AB5, 0x8D43,
    0x8A5F, 0x9AB7, 0x9AB8, 0x9AB9, 0x9AB6, 0x9AAF, 0x9ABA, 0x9ABB,
    0x9684, 0x8FE9, 0x9ABD, 0x9ABE, 0x9ABC, 0x9AC0, 0x9457, 0x88E6,
    0x9575, 0x9AC1, 0x8FFB, 0x8EB7, 0x947C, 0x8AEE, 0x8DE9, 0x9678,
    0x93B0, 0x8C98, 0x91CD, 0x9ABF, 0x9AC2, 0x91C2, 0x9AC3, 0x9AC4,
    0x9AC6, 0x92E7, 0x8AAC, 0xEA9F, 0x8981, 0x95F1, 0x8FEA, 0x9367,
    0x8DE4, 0x9ACC, 0x95BB, 0x97DB, 0x89F2, 0x9AC8, 0x9159, 0x9ACB,
    0x9383, 0x9368, 0x9384, 0x94B7, 0x92CB, 0x8DC7, 0x9AC7, 0x8996,
    0x9355, 0x9AC9, 0x9AC5, 0x906F, 0x9ACD, 0x8F6D, 0x8BAB, 0x9ACE,
    0x95E6, 0x919D, 0x92C4, 0x9AD0, 0x966E, 0x9AD1, 0x9AD6, 0x95AD,
    0x9AD5, 0x9ACF, 0x9AD2, 0x9AD4, 0x8DA4, 0x95C7, 0x9AD7, 0x9264,
    0x89F3, 0x8FEB, 0x9AD9, 0x9AD8, 0x8D88, 0x9ADA, 0x9ADC, 0x9ADB,
    0x9ADE, 0x9AD3, 0x9AE0, 0x9ADF, 0x9ADD, 0x8E6D, 0x9070, 0x9173,
    0x9AE1, 0x90BA, 0x88EB, 0x9484, 0x92D9, 0x9AE3, 0x9AE2, 0x9AE4,
    0x9AE5, 0x9AE6, 0x9AE7, 0x95CF, 0x9AE8, 0x89C4, 0x9AE9, 0x975B,
    0x8A4F, 0x99C7, 0x8F67, 0x91BD, 0x9AEA, 0x96E9, 0x96B2, 0x9AEC,
    0x91E5, 0x9356, 0x91BE, 0x9576, 0x9AED, 0x9AEE, 0x899B, 0x8EB8,
    0x9AEF, 0x88CE, 0x9AF0, 0x9AF1, 0x8982, 0x8AEF, 0x93DE, 0x95F2,
    0x9AF5, 0x9174, 0x9AF4, 0x8C5F, 0x967A, 0x9AF3, 0x9385, 0x9AF7,
    0x9AF6, 0x9AF9, 0x9AF8, 0x899C, 0x9AFA, 0x8FA7, 0x9AFC, 0x9244,
    0x9AFB, 0x95B1, 0x8F97, 0x937A, 0x9B40, 0x8D44, 0x9B41, 0x9440,
    0x94DC, 0x96CF, 0x9444, 0x9B4A, 0x8B57, 0x9764, 0x96AD, 0x9BAA,
    0x9B42, 0x9B45, 0x91C3, 0x9657, 0x9369, 0x9B46, 0x9685, 0x8DC8,
    0x8FA8, 0x9B47, 0x8E6F, 0x8E6E, 0x88B7, 0x8CC6, 0x90A9, 0x88CF,
    0x9B4B, 0x9B4C, 0x9B49, 0x8957, 0x8AAD, 0x9B48, 0x96C3, 0x9550,
    0x88A6, 0x88F7, 0x8E70, 0x88D0, 0x88A1, 0x9B51, 0x9B4F, 0x96BA,
    0x9B52, 0x9B50, 0x9B4E, 0x9050, 0x9B4D, 0x95D8, 0x8CE2, 0x9B56,
    0x9B57, 0x8FA9, 0x9B53, 0x984B, 0x946B, 0x9B55, 0x8DA5, 0x9B58,
    0x9577, 0x9B59, 0x9B54, 0x96B9, 0x947D, 0x9B5A, 0x9551, 0x9B5B,
    0x9B5F, 0x9B5C, 0x89C5, 0x9B5E, 0x8EB9, 0x9B5D, 0x8C99, 0x9B6B,
    0x9B64, 0x9B61, 0x9284, 0x9B60, 0x9B62, 0x9B63, 0x9B65, 0x9B66,
    0x8AF0, 0x9B68, 0x9B67, 0x9B69, 0x8FEC, 0x9B6C, 0x92DA, 0x8964,
    0x9B6A, 0x9B6D, 0x9B6E, 0x9B71, 0x9B6F, 0x9B70, 0x8E71, 0x9B72,
    0x8D45, 0x9B73, 0x8E9A, 0x91B6, 0x9B74, 0x9B75, 0x8E79, 0x8D46,
    0x96D0, 0x8B47, 0x8CC7, 0x9B76, 0x8A77, 0x9B77, 0x91B7, 0x9B78,
    0x9BA1, 0x9B79, 0x9B7A, 0x9B7B, 0x9B7D, 0x9B7E, 0x9B80, 0x91EE,
    0x8946, 0x8EE7, 0x88C0, 0x9176, 0x8AAE, 0x8EB3, 0x8D47, 0x9386,
    0x8F40, 0x8AAF, 0x9288, 0x92E8, 0x88B6, 0x8B58, 0x95F3, 0x8EC0,
    0x8B71, 0x90E9, 0x8EBA, 0x9747, 0x9B81, 0x8B7B, 0x8DC9, 0x8A51,
    0x8983, 0x8FAA, 0x89C6, 0x9B82, 0x9765, 0x8F68, 0x8EE2, 0x9B83,
    0x8AF1, 0x93D0, 0x96A7, 0x9B84, 0x9B85, 0x9578, 0x9B87, 0x8AA6,
    0x8BF5, 0x9B86, 0x8AB0, 0x9051, 0x9B8B, 0x8E40, 0x89C7, 0x9B8A,
    0x9B88, 0x9B8C, 0x9B89, 0x944A, 0x9ECB, 0x9052, 0x9B8D, 0x97BE,
    0x9B8E, 0x9B90, 0x929E, 0x9B8F, 0x90A1, 0x8E9B, 0x91CE, 0x8EF5,
    0x9595, 0x90EA, 0x8ECB, 0x9B91, 0x8FAB, 0x9B92, 0x9B93, 0x88D1,
    0x91B8, 0x9071, 0x9B94, 0x93B1, 0x8FAC, 0x8FAD, 0x9B95, 0x90EB,
    0x8FAE, 0x9B96, 0x9B97, 0x96DE, 0x9B98, 0x8BC4, 0x8F41, 0x9B99,
    0x9B9A, 0x8EDA, 0x904B, 0x93F2, 0x9073, 0x94F6, 0x9441, 0x8BC7,
    0x9B9B, 0x8B8F, 0x9B9C, 0x8BFC, 0x93CD, 0x89AE, 0x8E72, 0x9B9D,
    0x9BA0, 0x9B9F, 0x8BFB, 0x9B9E, 0x9357, 0x91AE, 0x936A, 0x8EC6,
    0x9177, 0x979A, 0x9BA2, 0x9BA3, 0x93D4, 0x8E52, 0x9BA5, 0x9BA6,
    0x9BA7, 0x8AF2, 0x9BA8, 0x9BA9, 0x89AA, 0x915A, 0x8AE2, 0x9BAB,
    0x96A6, 0x91D0, 0x8A78, 0x9BAD, 0x9BAF, 0x8ADD, 0x9BAC, 0x9BAE,
    0x9BB1, 0x9BB0, 0x9BB2, 0x9BB3, 0x93BB, 0x8BAC, 0x89E3, 0x9BB4,
    0x9BB9, 0x9BB7, 0x95F5, 0x95F4, 0x9387, 0x9BB6, 0x8F73, 0x9BB5,
    0x9092, 0x9BBA, 0x8DE8, 0x9BC0, 0x9BC1, 0x9BBB, 0x8A52, 0x9BBC,
    0x9BC5, 0x9BC4, 0x9BC3, 0x9BBF, 0x9BBE, 0x9BC2, 0x95F6, 0x9BC9,
    0x9BC6, 0x9BC8, 0x9792, 0x9BC7, 0x9BBD, 0x9093, 0x9BCA, 0x8DB5,
    0x9BCB, 0x9BCC, 0x9BCF, 0x9BCE, 0x9BCD, 0x9388, 0x9BB8, 0x9BD5,
    0x9BD1, 0x9BD0, 0x9BD2, 0x9BD3, 0x9BD6, 0x97E4, 0x9BD7, 0x9BD4,
    0x9BD8, 0x8ADE, 0x9BD9, 0x9BDB, 0x9BDA, 0x9BDC, 0x9BDD, 0x90EC,
    0x8F42, 0x8F84, 0x9183, 0x8D48, 0x8DB6, 0x8D49, 0x8B90, 0x9BDE,
    0x8DB7, 0x8CC8, 0x9BDF, 0x96A4, 0x9462, 0x9BE0, 0x8D4A, 0x8AAA,
    0x9246, 0x8BD0, 0x8E73, 0x957A, 0x94BF, 0x9BE1, 0x8AF3, 0x9BE4,
    0x929F, 0x9BE3, 0x9BE2, 0x9BE5, 0x92E9, 0x9083, 0x8E74, 0x90C8,
    0x91D1, 0x8B41, 0x92A0, 0x9BE6, 0x9BE7, 0x8FED, 0x9658, 0x9BEA,
    0x9BE9, 0x9BE8, 0x959D, 0x9BF1, 0x9679, 0x9BEB, 0x9BED, 0x968B,
    0x9BEC, 0x9BEE, 0x94A6, 0x9BEF, 0x95BC, 0x9BF0, 0x8AB1, 0x95BD,
    0x944E, 0x9BF2, 0x9BF3, 0x8D4B, 0x8AB2, 0x9BF4, 0x8CB6, 0x9763,
    0x9748, 0x8AF4, 0x9BF6, 0x92A1, 0x8D4C, 0x8FAF, 0x94DD, 0x8FB0,
    0x8F98, 0x92EA, 0x95F7, 0x9358, 0x8D4D, 0x957B, 0x9BF7, 0x9378,
    0x8DC0, 0x8CC9, 0x92EB, 0x88C1, 0x8F8E, 0x8D4E, 0x9766, 0x9BF8,
    0x9BF9, 0x9470, 0x9BFA, 0x97F5, 0x984C, 0x9BFC, 0x9BFB, 0x8A66,
    0x9C40, 0x9C43, 0x9C44, 0x9C42, 0x955F, 0x8FB1, 0x9C46, 0x9C45,
    0x9C41, 0x9C47, 0x9C48, 0x9C49, 0x9C4C, 0x9C4A, 0x9C4B, 0x9C4D,
    0x8984, 0x92EC, 0x9C4E, 0x8C9A, 0x89F4, 0x9455, 0x9C4F, 0x93F9,
    0x95D9, 0x9C50, 0x984D, 0x9C51, 0x95BE, 0x9C54, 0x989F, 0x98AF,
    0x8EAE, 0x93F3, 0x9C55, 0x8B7C, 0x92A2, 0x88F8, 0x9C56, 0x95A4,
    0x8D4F, 0x926F, 0x92ED, 0x96ED, 0x8CB7, 0x8CCA, 0x9C57, 0x9C58,
    0x9C5E, 0x8EE3, 0x92A3, 0x8BAD, 0x9C59, 0x954A, 0x9265, 0x9C5A,
    0x9C5B, 0x8BAE, 0x9C5C, 0x9C5D, 0x9C5F, 0x9396, 0x9C60, 0x9C61,
    0x9C62, 0x9C53, 0x9C52, 0x9C63, 0x8C60, 0x9546, 0x8DCA, 0x9556,
    0x92A4, 0x956A, 0x9C64, 0x8FB2, 0x8965, 0x9C65, 0x9C66, 0x96F0,
    0x94DE, 0x9C69, 0x899D, 0x90AA, 0x9C68, 0x9C67, 0x8C61, 0x91D2,
    0x9C6D, 0x9C6B, 0x9C6A, 0x97A5, 0x8CE3, 0x8F99, 0x9C6C, 0x936B,
    0x8F5D, 0x93BE, 0x9C70, 0x9C6F, 0x9C6E, 0x9C71, 0x8CE4, 0x9C72,
    0x959C, 0x8F7A, 0x9C73, 0x94F7, 0x93BF, 0x92A5, 0x934F, 0x9C74,
    0x8B4A, 0x9053, 0x954B, 0x8AF5, 0x9445, 0x9C75, 0x8E75, 0x9659,
    0x965A, 0x899E, 0x9C7A, 0x9289, 0x9C77, 0x89F5, 0x9CAB, 0x9C79,
    0x944F, 0x9C78, 0x9C76, 0x8D9A, 0x9C7C, 0x9C83, 0x9C89, 0x9C81,
    0x937B, 0x9C86, 0x957C, 0x9C80, 0x9C85, 0x97E5, 0x8E76, 0x91D3,
    0x9C7D, 0x8B7D, 0x9C88, 0x90AB, 0x8985, 0x9C82, 0x89F6, 0x9C87,
    0x8BAF, 0x9C84, 0x9C8A, 0x9C8C, 0x9C96, 0x9C94, 0x9C91, 0x9C90,
    0x97F6, 0x9C92, 0x8BB0, 0x8D50, 0x8F9A, 0x9C99, 0x9C8B, 0x9C8F,
    0x9C7E, 0x89F8, 0x9C93, 0x9C95, 0x9270, 0x8DA6, 0x89B6, 0x9C8D,
    0x9C98, 0x9C97, 0x8BB1, 0x91A7, 0x8A86, 0x8C62, 0x9C8E, 0x9C9A,
    0x9C9D, 0x9C9F, 0x8EBB, 0x9CA5, 0x92EE, 0x9C9B, 0x9CA3, 0x89F7,
    0x9CA1, 0x9CA2, 0x9C9E, 0x9CA0, 0x8CE5, 0x9749, 0x8AB3, 0x8978,
    0x9CA4, 0x9459, 0x88AB, 0x94DF, 0x9C7B, 0x9CAA, 0x9CAE, 0x96E3,
    0x9CA7, 0x9389, 0x9CAC, 0x8FEE, 0x9CAD, 0x93D5, 0x9866, 0x9CA9,
    0x9CAF, 0x8D9B, 0x90C9, 0x88D2, 0x9CA8, 0x9CA6, 0x9179, 0x9C9C,
    0x8E53, 0x91C4, 0x9CBB, 0x917A, 0x9CB6, 0x9CB3, 0x9CB4, 0x8EE4,
    0x9CB7, 0x9CBA, 0x9CB5, 0x8F44, 0x9CB8, 0x9CB2, 0x96FA, 0x96F9,
    0x9CBC, 0x9CBD, 0x88D3, 0x9CB1, 0x8BF0, 0x88A4, 0x8AB4, 0x9CB9,
    0x9CC1, 0x9CC0, 0x9CC5, 0x9CC6, 0x9CC4, 0x9CC7, 0x9CBF, 0x9CC3,
    0x9CC8, 0x9CC9, 0x9CBE, 0x8E9C, 0x9CC2, 0x91D4, 0x8D51, 0x9CB0,
    0x9054, 0x9CD6, 0x95E7, 0x9CCC, 0x9CCD, 0x9CCE, 0x9CD5, 0x9CD4,
    0x969D, 0x8AB5, 0x9CD2, 0x8C64, 0x8A53, 0x9CCF, 0x97B6, 0x9CD1,
    0x88D4, 0x9CD3, 0x9CCA, 0x9CD0, 0x9CD7, 0x8C63, 0x9CCB, 0x977C,
    0x974A, 0x9CDA, 0x9CDE, 0x919E, 0x97F7, 0x9CDF, 0x9CDC, 0x9CD9,
    0x9CD8, 0x9CDD, 0x95AE, 0x93B2, 0x8C65, 0x9CE0, 0x9CDB, 0x9CE1,
    0x8C9B, 0x89AF, 0x9CE9, 0x8AB6, 0x9CE7, 0x9CE8, 0x8DA7, 0x9CE6,
    0x9CE4, 0x9CE3, 0x9CEA, 0x9CE2, 0x9CEC, 0x89F9, 0x9CEE, 0x9CED,
    0x92A6, 0x9CF1, 0x9CEF, 0x9CE5, 0x8C9C, 0x9CF0, 0x9CF4, 0x9CF3,
    0x9CF5, 0x9CF2, 0x9CF6, 0x9CF7, 0x9CF8, 0x95E8, 0x9CFA, 0x9CF9,
    0x8F5E, 0x90AC, 0x89E4, 0x89FA, 0x9CFB, 0x88BD, 0x90CA, 0x9CFC,
    0xE6C1, 0x9D40, 0x8C81, 0x9D41, 0x90ED, 0x9D42, 0x9D43, 0x8B59,
    0x9D44, 0x9D45, 0x9D46, 0x91D5, 0x8CCB, 0x96DF, 0x965B, 0x8F8A,
    0x9D47, 0x90EE, 0xE7BB, 0x94E0, 0x8EE8, 0x8DCB, 0x9D48, 0x91C5,
    0x95A5, 0x91EF, 0x9D4B, 0x9D49, 0x9D4C, 0x9D4A, 0x9D4D, 0x95AF,
    0x88B5, 0x957D, 0x94E1, 0x9D4E, 0x9D51, 0x8FB3, 0x8B5A, 0x9D4F,
    0x9D56, 0x8FB4, 0x9D50, 0x9463, 0x977D, 0x9D52, 0x9D53, 0x9D57,
    0x938A, 0x9D54, 0x8D52, 0x90DC, 0x9D65, 0x94B2, 0x91F0, 0x94E2,
    0x9DAB, 0x95F8, 0x92EF, 0x9695, 0x9D5A, 0x899F, 0x928A, 0x9D63,
    0x9253, 0x9D5D, 0x9D64, 0x9D5F, 0x9D66, 0x9D62, 0x9D61, 0x948F,
    0x9D5B, 0x89FB, 0x9D59, 0x8B91, 0x91F1, 0x9D55, 0x9D58, 0x8D53,
    0x90D9, 0x8FB5, 0x9D60, 0x9471, 0x8B92, 0x8A67, 0x8A87, 0x9040,
    0x9D68, 0x9D6D, 0x9D69, 0x8C9D, 0x9D6E, 0x8E41, 0x8D89, 0x8F45,
    0x9D5C, 0x8E9D, 0x9D6B, 0x8E77, 0x9D6C, 0x88C2, 0x9D67, 0x92A7,
    0x8B93, 0x8BB2, 0x9D6A, 0x88A5, 0x8DC1, 0x9055, 0x92F0, 0x94D2,
    0x9D70, 0x917D, 0x91A8, 0x8E4A, 0x9D71, 0x9D73, 0x9D6F, 0x95DF,
    0x92BB, 0x917B, 0x95F9, 0x8ECC, 0x9D80, 0x9D7E, 0x9098, 0x8C9E,
    0x9D78, 0x8FB7, 0x93E6, 0x9450, 0x9D76, 0x917C, 0x8EF6, 0x9D7B,
    0x8FB6, 0x9D75, 0x9D7A, 0x9472, 0x9D74, 0x8C40, 0x8A7C, 0x9D7C,
    0x97A9, 0x8DCC, 0x9254, 0x9D79, 0x90DA, 0x8D54, 0x9084, 0x8986,
    0x915B, 0x9D77, 0x8B64, 0x8C66, 0x92CD, 0x9D7D, 0x917E, 0x9D81,
    0x9D83, 0x91B5, 0x9D89, 0x9D84, 0x9D86, 0x9560, 0x92F1, 0x9D87,
    0x974B, 0x9767, 0x8AB7, 0x88AC, 0x9D85, 0x9D82, 0x8AF6, 0x8987,
    0x9D88, 0x9768, 0x9D8C, 0x91B9, 0x9D93, 0x9D8D, 0x9D8A, 0x9D91,
    0x9D72, 0x9D8E, 0x9D92, 0x94C0, 0x938B, 0x9D8B, 0x9D8F, 0x8C67,
    0x8DEF, 0x90DB, 0x9D97, 0x9345, 0x9D94, 0x9680, 0x9D95, 0x9D96,
    0x96CC, 0x90A0, 0x8C82, 0x9D9D, 0x8E54, 0x9D9A, 0x9D99, 0x9451,
    0x93B3, 0x9350, 0x9D9B, 0x9D9C, 0x958F, 0x9464, 0x8E42, 0x90EF,
    0x966F, 0x8A68, 0x9DA3, 0x9D9E, 0x9769, 0x9DA5, 0x9DA1, 0x9DA2,
    0x9180, 0x9DA0, 0x9D5E, 0x9DA4, 0x9D9F, 0x9DA9, 0x9DAA, 0x9346,
    0x9DAC, 0x8E43, 0x9DA7, 0x8B5B, 0x9DAD, 0x9DA6, 0x9DB1, 0x9DB0,
    0x9DAF, 0x9DB2, 0x9DB4, 0x8FEF, 0x9DB3, 0x9DB7, 0x9DB5, 0x9DB6,
    0x9D90, 0x9DB9, 0x9DB8, 0x9D98, 0x9DBA, 0x9DAE, 0x8E78, 0x9DBB,
    0x9DBC, 0x9DBE, 0x9DBD, 0x9DBF, 0x89FC, 0x8D55, 0x95FA, 0x90AD,
    0x8CCC, 0x9DC1, 0x9DC4, 0x9571, 0x8B7E, 0x9DC3, 0x9DC2, 0x9473,
    0x9DC5, 0x8BB3, 0x9DC7, 0x9DC6, 0x8AB8, 0x8E55, 0x93D6, 0x8C68,
    0x9094, 0x9DC8, 0x90AE, 0x9347, 0x957E, 0x9DC9, 0x9DCA, 0x9DCB,
    0x95B6, 0x9B7C, 0x90C4, 0x956B, 0x8DD6, 0x94E3, 0x94C1, 0x936C,
    0x97BF, 0x9DCD, 0x8ECE, 0x9DCE, 0x88B4, 0x8BD2, 0x90CB, 0x9580,
    0x9DCF, 0x8E61, 0x9266, 0x8E7A, 0x9056, 0x9DD0, 0x95FB, 0x8997,
    0x8E7B, 0x9DD3, 0x9DD1, 0x9DD4, 0x97B7, 0x9DD2, 0x90F9, 0x9DD5,
    0x91B0, 0x9DD6, 0x8AF8, 0x9DD8, 0x9DD7, 0x9DD9, 0x9DDA, 0x8AF9,
    0x93FA, 0x9255, 0x8B8C, 0x8E7C, 0x9181, 0x8F7B, 0x88AE, 0x9DDB,
    0x89A0, 0x9DDF, 0x8D56, 0x9DDE, 0x8DA9, 0x8FB8, 0x9DDD, 0x8FB9,
    0x96BE, 0x8DA8, 0x88D5, 0x90CC, 0x9DE4, 0x90AF, 0x8966, 0x8F74,
    0x9686, 0x8DF0, 0x8FBA, 0x90A5, 0x9DE3, 0x9DE1, 0x9DE2, 0x928B,
    0x9E45, 0x9DE8, 0x8E9E, 0x8D57, 0x9DE6, 0x9DE7, 0x9057, 0x9DE5,
    0x8E4E, 0x9DEA, 0x9DE9, 0x9DEE, 0x9DEF, 0x9DEB, 0x8A41, 0x9DEC,
    0x9DED, 0x94D3, 0x9581, 0x8C69, 0x9DF0, 0x90B0, 0x8FBB, 0x9271,
    0x8BC5, 0x9DF1, 0x9DF5, 0x89C9, 0x9DF2, 0x9DF4, 0x9DF3, 0x8F8B,
    0x9267, 0x88C3, 0x9DF6, 0x9DF7, 0x92A8, 0x97EF, 0x8E62, 0x95E9,
    0x965C, 0x9E41, 0x9DF9, 0x9DFC, 0x9DFB, 0x9DF8, 0x9E40, 0x93DC,
    0x9DFA, 0x9E42, 0x8F8C, 0x9E43, 0x976A, 0x9498, 0x9E44, 0x9E46,
    0x9E47, 0x9E48, 0x8BC8, 0x8967, 0x8D58, 0x9E49, 0x9E4A, 0x8F91,
    0x9182, 0x99D6, 0x915D, 0x915C, 0x91D6, 0x8DC5, 0x98F0, 0x8C8E,
    0x974C, 0x95FC, 0x959E, 0x9E4B, 0x8DF1, 0x92BD, 0x9E4C, 0x984E,
    0x965D, 0x92A9, 0x9E4D, 0x8AFA, 0x9E4E, 0x9E4F, 0x96D8, 0x96A2,
    0x9696, 0x967B, 0x8E44, 0x9E51, 0x8EE9, 0x9670, 0x9E53, 0x9E56,
    0x9E55, 0x8AF7, 0x8B80, 0x9E52, 0x9E54, 0x9E57, 0x9099, 0x979B,
    0x88C7, 0x8DDE, 0x91BA, 0x8EDB, 0x8FF1, 0x9E5A, 0x936D, 0x9E58,
    0x91A9, 0x9E59, 0x8FF0, 0x96DB, 0x9E5B, 0x9E5C, 0x9788, 0x9E61,
    0x8D59, 0x9474, 0x9E5E, 0x938C, 0x9DDC, 0x9DE0, 0x8B6E, 0x9466,
    0x9E60, 0x8FBC, 0x94C2, 0x9E66, 0x94F8, 0x9E5D, 0x9E63, 0x9E62,
    0x90CD, 0x968D, 0x97D1, 0x9687, 0x89CA, 0x8E7D, 0x9867, 0x9E65,
    0x9095, 0x9E64, 0x9E5F, 0x8CCD, 0x9E6B, 0x9E69, 0x89CB, 0x9E67,
    0x9E6D, 0x9E73, 0x91C6, 0x95BF, 0x9E75, 0x9541, 0x9E74, 0x9490,
    0x965E, 0x8AB9, 0x90F5, 0x8F5F, 0x92D1, 0x974D, 0x9E70, 0x9E6F,
    0x9E71, 0x9E6E, 0x9E76, 0x9E6C, 0x9E6A, 0x9E72, 0x9E68, 0x928C,
    0x96F6, 0x8EC4, 0x8DF2, 0x8DB8, 0x968F, 0x8A60, 0x92CC, 0x93C8,
    0x8968, 0x90F0, 0x90B2, 0x8C49, 0x9E78, 0x8D5A, 0x8A9C, 0x9E7A,
    0x8A94, 0x9E81, 0x9E7D, 0x90F1, 0x8A6A, 0x8DAA, 0x8A69, 0x8DCD,
    0x9E7B, 0x8C85, 0x8C6A, 0x938D, 0x9E79, 0x88C4, 0x9E7C, 0x9E7E,
    0x8BCB, 0x8C4B, 0x8ABA, 0x8B6A, 0x9E82, 0x8DF7, 0x9691, 0x8E56,
    0x9E83, 0x954F, 0x9E8F, 0x89B1, 0x9E84, 0x9E95, 0x9E85, 0x97C0,
    0x9E8C, 0x947E, 0x9E94, 0x9E87, 0x88B2, 0x9E89, 0x8D5B, 0x9E8B,
    0x9E8A, 0x9E86, 0x9E91, 0x8FBD, 0x9AEB, 0x8CE6, 0x979C, 0x9E88,
    0x92F2, 0x8A42, 0x8DAB, 0x9E80, 0x9E90, 0x8A81, 0x9E8E, 0x9E92,
    0x938E, 0x8AFC, 0x9EB0, 0x96C7, 0x9E97, 0x8AFB, 0x9E9E, 0x965F,
    0x9E9F, 0x9EA1, 0x9EA5, 0x9E99, 0x9249, 0x938F, 0x9EA9, 0x9E9C,
    0x9EA6, 0x9EA0, 0x9058, 0x9EAA, 0x90B1, 0x9EA8, 0x8ABB, 0x986F,
    0x9E96, 0x9EA4, 0x88D6, 0x9E98, 0x96B8, 0x9E9D, 0x9041, 0x92C5,
    0x9E93, 0x9EA3, 0x909A, 0x9EAD, 0x8A91, 0x8C9F, 0x9EAF, 0x9E9A,
    0x9EAE, 0x9EA7, 0x9E9B, 0x9EAB, 0x9EAC, 0x9EBD, 0x93CC, 0x9EA2,
    0x9EB9, 0x9EBB, 0x92D6, 0x976B, 0x9596, 0x9EB6, 0x91C8, 0x9EBC,
    0x915E, 0x9EB3, 0x9EC0, 0x9EBF, 0x93ED, 0x9EBE, 0x93E8, 0x9EC2,
    0x9EB5, 0x8BC6, 0x9EB8, 0x8F7C, 0x9480, 0x9EBA, 0x8BC9, 0x9EB2,
    0x9EB4, 0x9EB1, 0x984F, 0x8A79, 0x9EB7, 0x9EC1, 0x8A54, 0x8DE5,
    0x897C, 0x9ED2, 0x9850, 0x9ED5, 0x9059, 0x9ED4, 0x9ED3, 0x9ED0,
    0x9EC4, 0x9EE1, 0x9EC3, 0x9ED6, 0x9ECE, 0x9EC9, 0x9EC6, 0x9EC7,
    0x9ECF, 0xEAA0, 0x9ECC, 0x8D5C, 0x92C6, 0x9184, 0x9ECA, 0x9EC5,
    0x9EC8, 0x976C, 0x968A, 0x9ECD, 0x9ED7, 0x9EDF, 0x9ED8, 0x9EE5,
    0x9EE3, 0x9EDE, 0x9EDD, 0x92CE, 0x9185, 0x9EDB, 0x9ED9, 0x9EE0,
    0x9EE6, 0x94F3, 0x9EEC, 0x9EE7, 0x9EEA, 0x9EE4, 0x9294, 0x9557,
    0x9EDA, 0x9EE2, 0x8FBE, 0x96CD, 0x9EF6, 0x9EE9, 0x8CA0, 0x89A1,
    0x8A7E, 0x9ED1, 0x8FBF, 0x9EEE, 0x9EF5, 0x8EF7, 0x8A92, 0x924D,
    0x9EEB, 0x9EF0, 0x9EF4, 0x8BB4, 0x8B6B, 0x9EF2, 0x8B40, 0x93C9,
    0x9EF1, 0x9EF3, 0x9EED, 0x9EEF, 0x8A80, 0x9268, 0x9EFA, 0x9EF8,
    0x8CE7, 0x9EF7, 0x9F40, 0x9E77, 0x9EF9, 0x9EFB, 0x9EFC, 0x9F4B,
    0x9F47, 0x9E8D, 0x9F46, 0x9F45, 0x9F42, 0x9EE8, 0x9F44, 0x9F43,
    0x9F49, 0x9845, 0x9F4C, 0x8BF9, 0x9F48, 0x9F4A, 0x94A5, 0x9F4D,
    0x9F51, 0x9F4E, 0x9793, 0x9F4F, 0x9EDC, 0x9F52, 0x9F53, 0x8954,
    0x9F55, 0x8C87, 0x8E9F, 0x8BD3, 0x89A2, 0x977E, 0x9F57, 0x9F56,
    0x9F59, 0x8B5C, 0x8BD4, 0x8ABC, 0x9F5C, 0x9F5B, 0x9F5D, 0x89CC,
    0x9256, 0x9F5E, 0x8ABD, 0x9F60, 0x9F5F, 0x9F61, 0x9F62, 0x9F63,
    0x8E7E, 0x90B3, 0x8D9F, 0x9590, 0x95E0, 0x9863, 0x8E95, 0x8DCE,
    0x97F0, 0x9F64, 0x9F65, 0x8E80, 0x9F66, 0x9F67, 0x9F69, 0x9F68,
    0x9677, 0x8F7D, 0x8EEA, 0x8E63, 0x9F6A, 0x9F6C, 0x9042, 0x9F6B,
    0x9F6D, 0x9F6E, 0x9F6F, 0x9F70, 0x9F71, 0x9F73, 0x9F72, 0x9F74,
    0x89A3, 0x9269, 0x9F75, 0x8E45, 0x8A6B, 0x9F76, 0x9361, 0x9ACA,
    0x8B42, 0x9F77, 0x9F78, 0x95EA, 0x9688, 0x93C5, 0x9F79, 0x94E4,
    0x94F9, 0x96D1, 0x9F7A, 0x9F7C, 0x9F7B, 0x9F7E, 0x9F7D, 0x9F81,
    0x8E81, 0x96AF, 0x9F82, 0x9F83, 0x8B43, 0x9F84, 0x9F86, 0x9F85,
    0x9085, 0x9558, 0x8969, 0x94C3, 0x92F3, 0x8F60, 0x8B81, 0x94C4,
    0x8EAC, 0x9F88, 0x8ABE, 0x8998, 0x93F0, 0x9F87, 0x8D5D, 0x9272,
    0x9F89, 0x9F91, 0x9F8A, 0x91BF, 0x8B82, 0x9F92, 0x8C88, 0x8B44,
    0x9F90, 0x9F8E, 0x9F8B, 0x9780, 0x92BE, 0x93D7, 0x9F8C, 0x9F94,
    0x9F93, 0x8C42, 0x89AB, 0x8DB9, 0x9F8D, 0x9F8F, 0x9676, 0x91F2,
    0x9697, 0x9F9C, 0x9F9D, 0x89CD, 0x95A6, 0x96FB, 0x9F9F, 0x8EA1,
    0x8FC0, 0x9F98, 0x9F9E, 0x8988, 0x8BB5, 0x9F95, 0x9F9A, 0x90F2,
    0x9491, 0x94E5, 0x9F97, 0x9640, 0x9F99, 0x9FA2, 0x9FA0, 0x9F9B,
    0x9641, 0x9467, 0x8B83, 0x9344, 0x928D, 0x9FA3, 0x9FA1, 0x91D7,
    0x9F96, 0x896A, 0x976D, 0x9FAE, 0x9FAD, 0x90F4, 0x9FAA, 0x978C,
    0x93B4, 0x9FA4, 0x92C3, 0x896B, 0x8D5E, 0x9FA7, 0x8F46, 0x9FAC,
    0x9FAB, 0x9FA6, 0x9FA9, 0x8A88, 0x9FA8, 0x9468, 0x97AC, 0x8FF2,
    0x90F3, 0x9FB4, 0x9FB2, 0x956C, 0x9FAF, 0x9FB1, 0x8959, 0x8D5F,
    0x9851, 0x8A5C, 0x9582, 0x9781, 0x8A43, 0x905A, 0x9FB3, 0x9FB8,
    0x8FC1, 0x974F, 0x9FB5, 0x9FB0, 0x9FB6, 0x97DC, 0x9393, 0x93C0,
    0x8A55, 0x8974, 0x9FBC, 0x9FBF, 0x97C1, 0x9784, 0x9FC6, 0x9FC0,
    0x9FBD, 0x97D2, 0x9FC3, 0x8F69, 0x9FC5, 0x9FCA, 0x9391, 0x9FC8,
    0x9FC2, 0x9257, 0x9FC9, 0x9FBE, 0x9FC4, 0x9FCB, 0x88FA, 0x9FC1,
    0x9FCC, 0x905B, 0x8F7E, 0x95A3, 0x8DAC, 0x9FB9, 0x9FC7, 0x9359,
    0x90B4, 0x8A89, 0x8DCF, 0x8FC2, 0x9FBB, 0x8F61, 0x8C6B, 0x9FBA,
    0x9FD0, 0x8F8D, 0x8CB8, 0x9FDF, 0x9FD9, 0x8B94, 0x936E, 0x9FD4,
    0x9FDD, 0x88AD, 0x8951, 0x89B7, 0x9FD6, 0x91AA, 0x9FCD, 0x9FCF,
    0x8D60, 0x9FE0, 0x9FDB, 0x9FD3, 0x9FDA, 0x96A9, 0x9FD8, 0x9FDC,
    0x8CCE, 0x8FC3, 0x9258, 0x9FD2, 0x974E, 0x9FD5, 0x9FCE, 0x9392,
    0x9FD1, 0x9FD7, 0x9870, 0x8EBC, 0x969E, 0x9FE1, 0x94AC, 0x9FED,
    0x8CB9, 0x8F80, 0x9FE3, 0x97AD, 0x8D61, 0x9FF0, 0x88EC, 0x9FEE,
    0x9FE2, 0x9FE8, 0x9FEA, 0x976E, 0x9FE5, 0x934D, 0x9FE7, 0x9FEF,
    0x9FE9, 0x96C5, 0x9FE4, 0x8EA0, 0x9FFC, 0x8A8A, 0x9FE6, 0x9FEB,
    0x9FEC, 0x91EA, 0x91D8, 0x9FF4, 0x9FFA, 0x9FF8, 0x9348, 0xE042,
    0x9FF5, 0x9FF6, 0x9FDE, 0x8B99, 0x9559, 0x8EBD, 0x8D97, 0x9852,
    0x9FF2, 0xE041, 0x8989, 0x9186, 0x9499, 0x8ABF, 0x97F8, 0x969F,
    0x92D0, 0x9FF9, 0x9FFB, 0x9151, 0xE040, 0x9FF7, 0x9FF1, 0x8AC1,
    0x8C89, 0xE04E, 0xE049, 0x90F6, 0x8A83, 0x8F81, 0xE052, 0xE04B,
    0x92AA, 0xE048, 0x92D7, 0xE06B, 0xE045, 0xE044, 0xE04D, 0xE047,
    0xE046, 0xE04C, 0x909F, 0xE043, 0xE04F, 0xE050, 0x8AC0, 0xE055,
    0xE054, 0xE056, 0xE059, 0x9362, 0xE053, 0xE057, 0x8C83, 0x91F7,
    0xE051, 0x945A, 0xE058, 0xE05D, 0xE05B, 0xE05E, 0xE061, 0xE05A,
    0x8D8A, 0x9447, 0x9FB7, 0x9794, 0xE05C, 0xE060, 0x91F3, 0xE05F,
    0xE04A, 0xE889, 0xE064, 0xE068, 0xE066, 0xE062, 0xE063, 0xE067,
    0xE065, 0x956D, 0xE06D, 0xE06A, 0xE069, 0xE06C, 0x93D2, 0xE06E,
    0x9295, 0x91EB, 0x90A3, 0xE06F, 0xE071, 0xE070, 0x9FF3, 0xE072,
    0x93E5, 0xE073, 0x89CE, 0x9394, 0x8A44, 0x8B84, 0x8EDC, 0x8DD0,
    0x9846, 0x9086, 0x898A, 0xE075, 0xE074, 0xE078, 0x9259, 0xE07B,
    0xE076, 0xE07A, 0xE079, 0x935F, 0x88D7, 0x97F3, 0xE07D, 0x8947,
    0xE080, 0xE07E, 0xE07C, 0xE077, 0x9642, 0xE082, 0xE081, 0x898B,
    0xE084, 0x95B0, 0xE083, 0x96B3, 0x8FC5, 0x9152, 0x8FC4, 0x97F9,
    0xE08A, 0x90F7, 0xE086, 0xE08B, 0x898C, 0xE089, 0x9481, 0xE085,
    0xE088, 0x8FC6, 0x94CF, 0xE08C, 0x8ECF, 0x90F8, 0xE08F, 0xE087,
    0x8C46, 0xE08D, 0x976F, 0xE090, 0xEAA4, 0x8F6E, 0xE091, 0xE092,
    0x944D, 0xE094, 0xE095, 0x9452, 0x9395, 0xE097, 0xE099, 0x97D3,
    0xE096, 0xE098, 0x898D, 0xE093, 0x9A7A, 0xE09A, 0x9187, 0x8E57,
    0xE09C, 0xE09B, 0x9043, 0x99D7, 0xE09D, 0xE09F, 0xE08E, 0xE09E,
    0xE0A0, 0x949A, 0xE0A1, 0xE0A2, 0xE0A3, 0xE0A4, 0x92DC, 0xE0A6,
    0xE0A5, 0xE0A7, 0xE0A8, 0x8EDD, 0x9583, 0x96EA, 0xE0A9, 0xE0AA,
    0x9175, 0x8EA2, 0xE0AB, 0xE0AC, 0xE0AD, 0x95D0, 0x94C5, 0xE0AE,
    0x9476, 0x92AB, 0xE0AF, 0x89E5, 0x8B8D, 0x96C4, 0x96B4, 0x89B2,
    0x9853, 0x9671, 0x95A8, 0x90B5, 0xE0B0, 0x93C1, 0x8CA1, 0xE0B1,
    0x8DD2, 0xE0B3, 0xE0B2, 0xE0B4, 0xE0B5, 0xE0B6, 0x8B5D, 0xE0B7,
    0xE0B8, 0x8CA2, 0x94C6, 0xE0BA, 0x8FF3, 0xE0B9, 0x8BB6, 0xE0BB,
    0xE0BD, 0xE0BC, 0xE0BE, 0x8CCF, 0xE0BF, 0x8BE7, 0x915F, 0x8D9D,
    0xE0C1, 0xE0C2, 0xE0C0, 0x8EEB, 0x93C6, 0x8BB7, 0xE0C4, 0x924B,
    0xE0C3, 0x9854, 0x9482, 0xE0C7, 0xE0C9, 0xE0C6, 0x96D2, 0xE0C8,
    0xE0CA, 0x97C2, 0xE0CE, 0xE0CD, 0x9296, 0x944C, 0x8CA3, 0xE0CC,
    0xE0CB, 0x9750, 0x9751, 0xE0CF, 0x898E, 0x8D96, 0x8E82, 0xE0D0,
    0xE0D1, 0xE0D3, 0x8F62, 0xE0D5, 0xE0D4, 0xE0D6, 0x8A6C, 0xE0D8,
    0xE0D7, 0xE0DA, 0xE0D9, 0x8CBA, 0x97A6, 0x8BCA, 0x89A4, 0x8BE8,
    0x8ADF, 0x97E6, 0xE0DC, 0xE0DE, 0xE0DF, 0x89CF, 0xE0DB, 0x8E58,
    0x92BF, 0xE0DD, 0xE0E2, 0x8EEC, 0xE0E0, 0x8C5D, 0x94C7, 0xE0E1,
    0xE0FC, 0xE0E7, 0x8CBB, 0x8B85, 0xE0E4, 0x979D, 0x97AE, 0x91F4,
    0xE0E6, 0xE0E8, 0x97D4, 0x8BD5, 0x94FA, 0x9469, 0xE0E9, 0xE0EB,
    0xE0EE, 0xE0EA, 0xE0ED, 0x8CE8, 0x896C, 0xE0EF, 0x9090, 0xE0EC,
    0x97DA, 0xE0F2, 0xEAA2, 0xE0F0, 0xE0F3, 0xE0E5, 0xE0F1, 0x8DBA,
    0xE0F4, 0xE0F5, 0x979E, 0xE0F6, 0xE0F7, 0xE0E3, 0xE0F8, 0x8AC2,
    0x8EA3, 0xE0F9, 0xE0FA, 0xE0FB, 0x895A, 0xE140, 0x955A, 0xE141,
    0x8AA2, 0xE142, 0xE143, 0xE144, 0xE146, 0xE147, 0xE145, 0x9572,
    0xE149, 0xE148, 0xE14B, 0xE14A, 0xE14C, 0xE14D, 0xE14F, 0xE14E,
    0x8D99, 0xE151, 0xE150, 0x8AC3, 0x9072, 0x935B, 0xE152, 0x90B6,
    0x8E59, 0x8999, 0xE153, 0x9770, 0x95E1, 0xE154, 0x9363, 0x9752,
    0x8D62, 0x905C, 0x926A, 0x99B2, 0x92AC, 0x89E6, 0xE155, 0xE156,
    0xE15B, 0xE159, 0xE158, 0x9DC0, 0x8A45, 0xE157, 0x88D8, 0x94A8,
    0x94C8, 0x97AF, 0xE15C, 0xE15A, 0x927B, 0x90A4, 0x94A9, 0x954C,
    0xE15E, 0x97AA, 0x8C6C, 0xE15F, 0xE15D, 0x94D4, 0xE160, 0xE161,
    0x88D9, 0x8FF4, 0xE166, 0xE163, 0x93EB, 0xE162, 0x8B45, 0xE169,
    0xE164, 0xE165, 0xE168, 0xE167, 0x9544, 0x9161, 0x9160, 0x8B5E,
    0xE16A, 0xE16B, 0xE16C, 0xE16E, 0xE16D, 0x8975, 0xE176, 0x94E6,
    0xE170, 0xE172, 0xE174, 0x905D, 0xE175, 0xE173, 0x8EBE, 0xE16F,
    0xE171, 0x9561, 0x8FC7, 0xE178, 0xE177, 0xE179, 0x8EA4, 0x8DAD,
    0x9397, 0xE17A, 0x92C9, 0xE17C, 0x979F, 0xE17B, 0x9189, 0xE182,
    0xE184, 0xE185, 0x9273, 0xE183, 0xE180, 0xE17D, 0xE17E, 0xE181,
    0xE188, 0xE186, 0xE187, 0xE189, 0xE18B, 0xE18C, 0xE18D, 0xE18E,
    0xE18A, 0xE190, 0xE18F, 0xE191, 0x97C3, 0xE194, 0xE192, 0xE193,
    0x8AE0, 0x96FC, 0x95C8, 0xE196, 0xE195, 0xE197, 0xE198, 0xE19C,
    0xE199, 0xE19A, 0xE19B, 0xE19D, 0xE19E, 0xE19F, 0xE1A0, 0xE1A1,
    0x94AD, 0x936F, 0xE1A2, 0x9492, 0x9553, 0xE1A3, 0xE1A4, 0x9349,
    0x8A46, 0x8D63, 0xE1A5, 0xE1A6, 0xE1A7, 0x8E48, 0xE1A9, 0xE1A8,
    0xE1AA, 0xE1AB, 0x94E7, 0xE1AC, 0xE1AD, 0xEA89, 0xE1AE, 0xE1AF,
    0xE1B0, 0x8E4D, 0xE1B1, 0x9475, 0x967E, 0x896D, 0x8976, 0xE1B2,
    0xE1B4, 0xE1B3, 0x9390, 0x90B7, 0x9F58, 0xE1B5, 0x96BF, 0xE1B6,
    0x8AC4, 0x94D5, 0xE1B7, 0xE1B8, 0xE1B9, 0x96DA, 0x96D3, 0x92BC,
    0x918A, 0xE1BB, 0x8F82, 0x8FC8, 0xE1BE, 0xE1BD, 0xE1BC, 0x94FB,
    0x8AC5, 0x8CA7, 0xE1C4, 0xE1C1, 0x905E, 0x96B0, 0xE1C0, 0xE1C2,
    0xE1C3, 0xE1BF, 0xE1C5, 0xE1C6, 0x92AD, 0x8AE1, 0x9285, 0xE1C7,
    0xE1C8, 0xE1CB, 0x9087, 0x93C2, 0xE1CC, 0x9672, 0xE1C9, 0xE1CA,
    0xE1CF, 0xE1CE, 0xE1CD, 0xE1D1, 0xE1D0, 0xE1D2, 0xE1D4, 0xE1D3,
    0x95CB, 0x8F75, 0x97C4, 0xE1D5, 0x93B5, 0xE1D6, 0xE1D7, 0xE1DB,
    0xE1D9, 0xE1DA, 0xE1D8, 0xE1DC, 0xE1DD, 0xE1DE, 0xE1DF, 0x96B5,
    0xE1E0, 0x96EE, 0xE1E1, 0x926D, 0x948A, 0x8BE9, 0x925A, 0xE1E2,
    0x8BB8, 0x90CE, 0xE1E3, 0x8DBB, 0xE1E4, 0xE1E5, 0x8CA4, 0x8DD3,
    0xE1E7, 0x9375, 0x8DD4, 0x8B6D, 0x9643, 0x946A, 0x9376, 0x8D7B,
    0xE1E9, 0x8FC9, 0x97B0, 0x8D64, 0x8CA5, 0x94A1, 0xE1EB, 0xE1ED,
    0x8CE9, 0xE1EC, 0x92F4, 0xE1EF, 0x8A56, 0xE1EA, 0x94E8, 0x894F,
    0x8DEA, 0x9871, 0xE1EE, 0xE1F0, 0x95C9, 0x90D7, 0xE1F2, 0xE1F3,
    0xE1F1, 0x8A6D, 0xE1F9, 0xE1F8, 0x8EA5, 0xE1FA, 0xE1F5, 0xE1FB,
    0xE1F6, 0x94D6, 0xE1F4, 0xE1F7, 0xE241, 0xE240, 0x9681, 0xE1FC,
    0x88E9, 0xE243, 0xE242, 0x8FCA, 0xE244, 0x9162, 0xE246, 0xE245,
    0xE247, 0xE1E6, 0xE1E8, 0xE249, 0xE248, 0x8EA6, 0x97E7, 0x8ED0,
    0xE24A, 0x8C56, 0x8B5F, 0x8B46, 0x8E83, 0x9753, 0xE250, 0xE24F,
    0x9163, 0xE24C, 0xE24E, 0x8F6A, 0x905F, 0xE24D, 0xE24B, 0x9449,
    0x8FCB, 0x955B, 0x8DD5, 0x9398, 0xE251, 0xE252, 0xE268, 0x8BD6,
    0x985C, 0x9154, 0xE253, 0x89D0, 0x92F5, 0x959F, 0xE254, 0x8B9A,
    0xE255, 0xE257, 0xE258, 0x9448, 0xE259, 0xE25A, 0xE25B, 0x8BD7,
    0x89D1, 0x93C3, 0x8F47, 0x8E84, 0xE25C, 0x8F48, 0x89C8, 0x9562,
    0xE25D, 0x94E9, 0x9164, 0xE260, 0xE261, 0x9489, 0x9060, 0xE25E,
    0x9281, 0xE25F, 0x8FCC, 0x88DA, 0x8B48, 0xE262, 0x92F6, 0xE263,
    0x90C5, 0x96AB, 0x9542, 0xE264, 0xE265, 0x9274, 0x97C5, 0xE267,
    0xE266, 0x8EED, 0xE269, 0x88EE, 0xE26C, 0xE26A, 0x89D2, 0x8C6D,
    0xE26B, 0x8D65, 0x8D92, 0x95E4, 0xE26D, 0x9673, 0xE26F, 0x90CF,
    0x896E, 0x89B8, 0x88AA, 0xE26E, 0xE270, 0xE271, 0x8FF5, 0xE272,
    0x8A6E, 0xE274, 0x8C8A, 0x8B86, 0xE275, 0x8BF3, 0xE276, 0x90FA,
    0x93CB, 0x90DE, 0x8DF3, 0xE277, 0x9282, 0x918B, 0xE279, 0xE27B,
    0xE278, 0xE27A, 0x8C41, 0xE27C, 0x8C45, 0x8B87, 0x9771, 0xE27E,
    0xE280, 0x894D, 0xE283, 0x8A96, 0xE282, 0xE281, 0xE285, 0xE27D,
    0xE286, 0x97A7, 0xE287, 0xE288, 0x9AF2, 0xE28A, 0xE289, 0xE28B,
    0xE28C, 0x97B3, 0xE28D, 0xE8ED, 0x8FCD, 0xE28E, 0xE28F, 0x8F76,
    0x93B6, 0xE290, 0x9247, 0xE291, 0x925B, 0xE292, 0x8BA3, 0x995E,
    0x927C, 0x8EB1, 0x8AC6, 0xE293, 0xE2A0, 0xE296, 0x8B88, 0xE295,
    0xE2A2, 0xE294, 0x8FCE, 0xE298, 0xE299, 0x934A, 0xE29A, 0x8A7D,
    0x9079, 0x9584, 0xE29C, 0x91E6, 0xE297, 0xE29B, 0xE29D, 0x8DF9,
    0xE2A4, 0x954D, 0x94A4, 0x9399, 0x8BD8, 0xE2A3, 0xE2A1, 0x94B3,
    0xE29E, 0x927D, 0x939B, 0x939A, 0x8DF4, 0xE2B6, 0xE2A6, 0xE2A8,
    0xE2AB, 0xE2AC, 0xE2A9, 0xE2AA, 0xE2A7, 0xE2A5, 0xE29F, 0x95CD,
    0x89D3, 0xE2B3, 0xE2B0, 0xE2B5, 0xE2B4, 0x9493, 0x96A5, 0x8E5A,
    0xE2AE, 0xE2B7, 0xE2B2, 0xE2B1, 0xE2AD, 0xE2AF, 0x8AC7, 0x925C,
    0x90FB, 0x94A0, 0xE2BC, 0x94A2, 0x90DF, 0xE2B9, 0x94CD, 0xE2BD,
    0x95D1, 0x927A, 0xE2B8, 0xE2BA, 0xE2BB, 0xE2BE, 0x8EC2, 0x93C4,
    0xE2C3, 0xE2C2, 0xE2BF, 0x9855, 0xE2C8, 0xE2CC, 0xE2C9, 0xE2C5,
    0xE2C6, 0xE2CB, 0xE2C0, 0x99D3, 0xE2C7, 0xE2C1, 0xE2CA, 0xE2D0,
    0x8AC8, 0xE2CD, 0xE2CE, 0xE2CF, 0xE2D2, 0xE2D1, 0x94F4, 0xE2D3,
    0x97FA, 0x95EB, 0xE2D8, 0xE2D5, 0xE2D4, 0x90D0, 0xE2D7, 0xE2D9,
    0xE2D6, 0xE2DD, 0xE2DA, 0xE2DB, 0xE2C4, 0xE2DC, 0xE2DE, 0xE2DF,
    0x95C4, 0xE2E0, 0x96E0, 0x8BCC, 0x8C48, 0xE2E1, 0x95B2, 0x9088,
    0x96AE, 0xE2E2, 0x97B1, 0x9494, 0x9165, 0x9453, 0x8F6C, 0x88BE,
    0xE2E7, 0xE2E5, 0xE2E3, 0x8A9F, 0x8FCF, 0xE2E8, 0xE2E6, 0xE2E4,
    0xE2EC, 0xE2EB, 0xE2EA, 0xE2E9, 0xE2ED, 0xE2EE, 0x90B8, 0xE2EF,
    0xE2F1, 0xE2F0, 0x8CD0, 0x9157, 0xE2F3, 0x939C, 0xE2F2, 0xE2F4,
    0x95B3, 0x918C, 0x8D66, 0xE2F5, 0x97C6, 0xE2F7, 0xE2F8, 0xE2F9,
    0xE2FA, 0x8E85, 0xE2FB, 0x8C6E, 0x8B8A, 0x8B49, 0xE340, 0x96F1,
    0x8D67, 0xE2FC, 0xE343, 0x96E4, 0x945B, 0x9552, 0x8F83, 0xE342,
    0x8ED1, 0x8D68, 0x8E86, 0x8B89, 0x95B4, 0xE341, 0x9166, 0x9661,
    0x8DF5, 0x8E87, 0x92DB, 0xE346, 0x97DD, 0x8DD7, 0xE347, 0x9061,
    0xE349, 0x8FD0, 0x8DAE, 0xE348, 0x8F49, 0x8CBC, 0x9167, 0xE344,
    0xE34A, 0xE345, 0x8C6F, 0xE34D, 0xE351, 0x8C8B, 0xE34C, 0xE355,
    0x8D69, 0x978D, 0x88BA, 0xE352, 0x8B8B, 0xE34F, 0xE350, 0x939D,
    0xE34E, 0xE34B, 0x8A47, 0x90E2, 0x8CA6, 0xE357, 0xE354, 0xE356,
    0xE353, 0x8C70, 0x91B1, 0xE358, 0x918E, 0xE365, 0xE361, 0xE35B,
    0xE35F, 0x8EF8, 0x88DB, 0xE35A, 0xE362, 0xE366, 0x8D6A, 0x96D4,
    0x92D4, 0xE35C, 0xE364, 0xE359, 0x925D, 0xE35E, 0x88BB, 0x96C8,
    0xE35D, 0x8BD9, 0x94EA, 0x918D, 0x97CE, 0x8F8F, 0xE38E, 0xE367,
    0x90FC, 0xE363, 0xE368, 0xE36A, 0x92F7, 0xE36D, 0xE369, 0x95D2,
    0x8AC9, 0x96C9, 0x88DC, 0xE36C, 0x97FB, 0xE36B, 0x898F, 0x93EA,
    0xE36E, 0xE375, 0xE36F, 0xE376, 0xE372, 0x949B, 0x8EC8, 0xE374,
    0xE371, 0xE377, 0xE370, 0x8F63, 0x9644, 0x8F6B, 0xE373, 0xE380,
    0xE37B, 0xE37E, 0xE37C, 0xE381, 0xE37A, 0xE360, 0x90D1, 0x94C9,
    0xE37D, 0xE378, 0x9140, 0x8C71, 0x8F4A, 0x9044, 0x9155, 0xE384,
    0xE386, 0xE387, 0xE383, 0xE385, 0xE379, 0xE382, 0xE38A, 0xE389,
    0x969A, 0x8C4A, 0xE388, 0xE38C, 0xE38B, 0xE38F, 0xE391, 0x8E5B,
    0xE38D, 0xE392, 0xE393, 0xE394, 0xE39A, 0x935A, 0xE396, 0xE395,
    0xE397, 0xE398, 0xE399, 0xE39B, 0xE39C, 0x8ACA, 0xE39D, 0xE39E,
    0xE39F, 0xE3A0, 0xE3A1, 0xE3A2, 0xE3A3, 0xE3A4, 0xE3A6, 0xE3A5,
    0xE3A7, 0xE3A8, 0xE3A9, 0xE3AC, 0xE3AA, 0xE3AB, 0x8DDF, 0x8C72,
    0x9275, 0x94B1, 0x8F90, 0x946C, 0x94EB, 0xE3AD, 0x9CEB, 0xE3AE,
    0xE3B0, 0x9785, 0xE3AF, 0xE3B2, 0xE3B1, 0x9772, 0xE3B3, 0x94FC,
    0xE3B4, 0xE3B7, 0xE3B6, 0xE3B5, 0xE3B8, 0x8C51, 0x9141, 0x8B60,
    0xE3BC, 0xE3B9, 0xE3BA, 0xE3BD, 0xE3BE, 0xE3BB, 0x8948, 0x89A5,
    0xE3C0, 0xE3C1, 0xE3C2, 0x9782, 0x8F4B, 0xE3C4, 0xE3C3, 0x9089,
    0xE3C5, 0xE3C6, 0xE3C7, 0x8AE3, 0x8ACB, 0xE3C8, 0xE3C9, 0x967C,
    0x9783, 0x9773, 0x9856, 0x8D6C, 0xE3CC, 0x8ED2, 0xE3CB, 0xE3CD,
    0x8EA7, 0x91CF, 0xE3CE, 0x8D6B, 0x96D5, 0xE3CF, 0xE3D0, 0xE3D1,
    0xE3D2, 0xE3D3, 0x8EA8, 0x96EB, 0xE3D5, 0x925E, 0xE3D4, 0xE3D7,
    0xE3D6, 0xE3D8, 0x90B9, 0xE3D9, 0xE3DA, 0x95B7, 0xE3DB, 0x918F,
    0xE3DC, 0xE3DD, 0x97FC, 0xE3E0, 0xE3DF, 0xE3DE, 0x92AE, 0xE3E1,
    0x9045, 0xE3E2, 0xE3E3, 0x9857, 0xE3E4, 0xE3E5, 0xE3E7, 0xE3E6,
    0x94A3, 0x93F7, 0x985D, 0x94A7, 0xE3E9, 0x8FD1, 0x9549, 0xE3EA,
    0xE3E8, 0x8ACC, 0x8CD2, 0x8E88, 0x94EC, 0x8CA8, 0x9662, 0xE3ED,
    0xE3EB, 0x8D6D, 0x8D6E, 0x88E7, 0x8DE6, 0x9478, 0x88DD, 0xE3F2,
    0x925F, 0x9477, 0x91D9, 0xE3F4, 0xE3F0, 0xE3F3, 0xE3EE, 0xE3F1,
    0x9645, 0x8CD3, 0x88FB, 0xE3EF, 0xE3F6, 0xE3F7, 0x93B7, 0x8BB9,
    0xE445, 0x945C, 0x8E89, 0x8BBA, 0x90C6, 0x9865, 0x96AC, 0xE3F5,
    0x90D2, 0x8B72, 0xE3F8, 0xE3FA, 0xE3F9, 0xE3FB, 0x9245, 0x945D,
    0x92AF, 0xE442, 0xE441, 0xE3FC, 0x9074, 0x9585, 0xE444, 0xE443,
    0x8D6F, 0x9872, 0xE454, 0xE448, 0xE449, 0x8EEE, 0xE447, 0x8D98,
    0xE446, 0xE44A, 0x92B0, 0x95A0, 0x9142, 0x91DA, 0xE44E, 0xE44F,
    0xE44B, 0xE44C, 0xE44D, 0x8D70, 0xE455, 0xE451, 0x9586, 0x968C,
    0x9547, 0xE450, 0xE453, 0xE452, 0x9663, 0xE456, 0xE457, 0x9156,
    0xE458, 0xE45A, 0xE45E, 0xE45B, 0xE459, 0x945E, 0xE45C, 0xE45D,
    0x89B0, 0xE464, 0xE45F, 0xE460, 0xE461, 0x919F, 0xE463, 0xE462,
    0xE465, 0xE466, 0xE467, 0x9062, 0x89E7, 0xE468, 0x97D5, 0x8EA9,
    0x8F4C, 0x8E8A, 0x9276, 0xE469, 0xE46A, 0x8950, 0xE46B, 0xE46C,
    0xE46D, 0xE46E, 0xE46F, 0x8BBB, 0x9DA8, 0xE470, 0x90E3, 0xE471,
    0x8EC9, 0xE472, 0x98AE, 0xE473, 0x95DC, 0x8ADA, 0x9143, 0x8F77,
    0x9591, 0x8F4D, 0xE474, 0x8D71, 0xE475, 0x94CA, 0xE484, 0xE477,
    0x91C7, 0x9495, 0x8CBD, 0xE476, 0x9144, 0xE478, 0x92F8, 0xE47A,
    0xE479, 0xE47C, 0xE47B, 0xE47D, 0xE480, 0xE47E, 0x8ACD, 0xE481,
    0xE482, 0xE483, 0x8DAF, 0x97C7, 0xE485, 0x9046, 0x8990, 0xE486,
    0xE487, 0xE488, 0x88F0, 0xE489, 0xE48A, 0x9587, 0x8EC5, 0xE48C,
    0x8A48, 0x88B0, 0xE48B, 0xE48E, 0x946D, 0x9063, 0x89D4, 0x9646,
    0x8C7C, 0x8BDA, 0xE48D, 0x89E8, 0x8AA1, 0x8991, 0xE492, 0x97E8,
    0x91DB, 0x9563, 0xE49E, 0x89D5, 0xE49C, 0xE49A, 0xE491, 0xE48F,
    0xE490, 0x8EE1, 0x8BEA, 0x9297, 0x93CF, 0x8970, 0xE494, 0xE493,
    0xE499, 0xE495, 0xE498, 0x96CE, 0xE497, 0x89D6, 0x8A9D, 0xE49B,
    0xE49D, 0x8C73, 0xE4A1, 0xE4AA, 0xE4AB, 0x88A9, 0xE4B2, 0x88EF,
    0xE4A9, 0xE4A8, 0xE4A3, 0xE4A2, 0xE4A0, 0xE49F, 0x9283, 0x91F9,
    0xE4A5, 0xE4A4, 0xE4A7, 0x9190, 0x8C74, 0x8960, 0xE4A6, 0x8D72,
    0x9191, 0xE4B8, 0xE4B9, 0x89D7, 0x89AC, 0xE4B6, 0xE4AC, 0xE4B4,
    0xE4BB, 0xE4B5, 0xE4B3, 0xE496, 0xE4B1, 0xE4AD, 0x8ACE, 0xE4AF,
    0xE4BA, 0xE4B0, 0xE4BC, 0xE4AE, 0x949C, 0x9789, 0xE4B7, 0xE4CD,
    0xE4C5, 0x909B, 0x8B65, 0x8BDB, 0xE4C0, 0x89D9, 0x8FD2, 0xE4C3,
    0x8DD8, 0x9370, 0xE4C8, 0x95EC, 0xE4BF, 0x89D8, 0x8CD4, 0x9548,
    0xE4C9, 0xE4BD, 0xE4C6, 0xE4D0, 0xE4C1, 0xE4C2, 0x93B8, 0xE4C7,
    0xE4C4, 0x9647, 0xE4CA, 0x88DE, 0xE4BE, 0xE4CC, 0xE4CB, 0x948B,
    0xE4D2, 0xE4DD, 0x8A9E, 0xE4E0, 0xE4CE, 0xE4D3, 0x978E, 0xE4DC,
    0x9774, 0x97A8, 0x9298, 0x8A8B, 0x9592, 0xE4E2, 0x939F, 0x88AF,
    0xE4DB, 0xE4D7, 0x9192, 0xE4D1, 0xE4D9, 0xE4DE, 0x944B, 0x88A8,
    0xE4D6, 0xE4DF, 0x9598, 0xE4DA, 0xE4D5, 0x8FD3, 0x8F4E, 0x8EAA,
    0x96D6, 0x9566, 0xE4E5, 0xE4EE, 0xE4D8, 0x8A97, 0x8FF6, 0xE4E3,
    0xE4E8, 0x9193, 0xE4E4, 0xE4EB, 0x927E, 0xE4EC, 0x9775, 0xE4E1,
    0x8A57, 0xE4E7, 0xE4EA, 0x96AA, 0xE4ED, 0xE4E6, 0xE4E9, 0x9648,
    0x9840, 0xE4F1, 0xE4F8, 0xE4F0, 0x8EC1, 0xE4CF, 0x95CC, 0x96A0,
    0xE4F7, 0xE4F6, 0xE4F2, 0xE4F3, 0x8955, 0xE4F5, 0xE4EF, 0x92D3,
    0xE4F4, 0x88FC, 0x91A0, 0x95C1, 0xE4F9, 0xE540, 0x94D7, 0xE4FC,
    0x8FD4, 0x8EC7, 0xE542, 0x8BBC, 0xE543, 0x9599, 0xE4FB, 0xE4D4,
    0xE4FA, 0x986E, 0x93A0, 0x9593, 0xE54A, 0xE550, 0xE551, 0xE544,
    0x9496, 0xE54E, 0xE546, 0xE548, 0xE552, 0xE547, 0xE54B, 0x8992,
    0x93E3, 0xE54C, 0xE54F, 0xE545, 0x9145, 0xE549, 0x8E46, 0x9064,
    0x8C4F, 0x96F2, 0x96F7, 0x8F92, 0xE556, 0xE554, 0x986D, 0xE553,
    0x9795, 0xE555, 0xE557, 0xE558, 0xE55B, 0xE559, 0x93A1, 0xE55A,
    0x94CB, 0xE54D, 0x8F93, 0xE55C, 0xE561, 0x9194, 0xE560, 0xE541,
    0xE562, 0x9168, 0xE55D, 0xE55F, 0xE55E, 0x9F50, 0x9F41, 0xE564,
    0xE563, 0x9796, 0xE1BA, 0xE565, 0xE566, 0xE567, 0x8CD5, 0x8B73,
    0xE569, 0x997C, 0x8B95, 0x97B8, 0x8BF1, 0xE56A, 0xE56B, 0x928E,
    0xE56C, 0x93F8, 0x88B8, 0x89E1, 0xE571, 0xE572, 0xE56D, 0x8E5C,
    0xE56E, 0x9461, 0xE56F, 0xE570, 0xE57A, 0xE574, 0xE577, 0xE573,
    0xE575, 0xE576, 0x8ED6, 0xE578, 0x9260, 0x8C75, 0x8A61, 0xE57B,
    0x8A5E, 0xE581, 0xE57C, 0xE580, 0x94B8, 0xE57D, 0xE57E, 0x9567,
    0x94D8, 0xE582, 0x91FB, 0xE58C, 0xE588, 0x89E9, 0xE586, 0x9649,
    0xE587, 0xE584, 0xE585, 0xE58A, 0xE58D, 0xE58B, 0xE589, 0xE583,
    0x9277, 0xE594, 0x96A8, 0xE592, 0xE593, 0xE58E, 0xE590, 0xE591,
    0xE58F, 0x90E4, 0x9858, 0xE598, 0xE599, 0xE59F, 0x9049, 0xE59B,
    0xE59E, 0xE596, 0xE595, 0xE5A0, 0x89DA, 0xE59C, 0xE5A1, 0xE59D,
    0xE59A, 0x92B1, 0xE597, 0x9488, 0xE5A5, 0x975A, 0xE5A4, 0xE5A3,
    0xE5AC, 0xE5A6, 0xE5AE, 0x9786, 0xE5B1, 0xE5A8, 0xE5A9, 0xE5AD,
    0xE5B0, 0xE5AF, 0xE5A7, 0xE5AA, 0xE5BB, 0xE5B4, 0xE5B2, 0xE5B3,
    0xE5B8, 0xE5B9, 0x8A49, 0x8B61, 0xE5B7, 0xE5A2, 0xE5B6, 0xE5BA,
    0xE5B5, 0xE5BC, 0xE5BE, 0xE5BD, 0xE5C0, 0xE5BF, 0xE579, 0xE5C4,
    0xE5C1, 0xE5C2, 0xE5C3, 0xE5C5, 0x8C8C, 0xE5C7, 0xE5C6, 0x8F4F,
    0x8D73, 0x9FA5, 0xE5C8, 0x8F70, 0x8A58, 0xE5C9, 0x8971, 0x8FD5,
    0xE5CA, 0x8D74, 0xE5CB, 0x88DF, 0x955C, 0xE5CC, 0x908A, 0xE5D3,
    0xE5D0, 0x928F, 0xE5D1, 0xE5CE, 0x8BDC, 0xE5CD, 0xE5D4, 0x8C55,
    0x91DC, 0xE5DA, 0xE5D6, 0x91B3, 0xE5D5, 0xE5D8, 0xE5CF, 0xE5D9,
    0xE5DB, 0x94ED, 0xE5D7, 0xE5DC, 0xE5DE, 0x8CD1, 0xE5D2, 0x88BF,
    0xE5DD, 0x8DD9, 0x97F4, 0xE5DF, 0xE5E0, 0x9195, 0x97A0, 0xE5E1,
    0x9754, 0xE5E2, 0xE5E3, 0x95E2, 0xE5E4, 0x8DBE, 0x97A1, 0xE5E9,
    0xE5EA, 0x8FD6, 0xE5E8, 0x9787, 0xE5E5, 0xE5E7, 0x90BB, 0x909E,
    0xE5E6, 0xE5EB, 0x95A1, 0xE5ED, 0xE5EC, 0x8A8C, 0x964A, 0xE5EE,
    0xE5FA, 0xE5F0, 0xE5F1, 0xE5F2, 0xE5F3, 0xE5F7, 0xE5F8, 0xE5F6,
    0xE5F4, 0xE5EF, 0xE5F5, 0xE5F9, 0xE8B5, 0x89A6, 0xE5FC, 0x8BDD,
    0xE5FB, 0xE641, 0xE640, 0xE643, 0xE642, 0xE644, 0x8F50, 0xE645,
    0xE646, 0xE647, 0x90BC, 0x9776, 0xE648, 0x95A2, 0x9465, 0xE649,
    0xE64A, 0x8CA9, 0x8B4B, 0xE64B, 0x8E8B, 0x9460, 0xE64C, 0x8A6F,
    0xE64D, 0xE64F, 0x9797, 0xE64E, 0x9065, 0xE650, 0xE651, 0xE652,
    0x8ACF, 0xE653, 0xE654, 0xE655, 0xE656, 0x8A70, 0xE657, 0xE658,
    0xE659, 0x89F0, 0x9047, 0xE65A, 0xE65B, 0xE65C, 0x8CBE, 0x92F9,
    0xE65D, 0x8C76, 0x9075, 0xE660, 0x93A2, 0xE65F, 0x8C50, 0xE65E,
    0x91F5, 0x8B4C, 0xE661, 0xE662, 0x8FD7, 0x8C8D, 0xE663, 0x964B,
    0x90DD, 0x8B96, 0x96F3, 0x9169, 0xE664, 0x9066, 0x9290, 0x8FD8,
    0xE665, 0xE668, 0xE669, 0x8DBC, 0x91C0, 0xE667, 0x8FD9, 0x955D,
    0xE666, 0x8E8C, 0x8972, 0xE66D, 0x8C77, 0x8E8E, 0x8E8D, 0x986C,
    0xE66C, 0xE66B, 0x9146, 0x8B6C, 0x9862, 0x8A59, 0x8FDA, 0xE66A,
    0xE66F, 0xE670, 0xE66E, 0x8CD6, 0x975F, 0x8E8F, 0x9446, 0xE673,
    0x90BE, 0x9261, 0x9755, 0xE676, 0x8CEA, 0x90BD, 0xE672, 0xE677,
    0x8CEB, 0xE674, 0xE675, 0xE671, 0x90E0, 0x93C7, 0x924E, 0x89DB,
    0x94EE, 0x8B62, 0x92B2, 0xE67A, 0xE678, 0x926B, 0x90BF, 0x8AD0,
    0xE679, 0x907A, 0x97C8, 0x985F, 0xE67B, 0xE687, 0x92B3, 0xE686,
    0xE683, 0xE68B, 0xE684, 0xE680, 0x92FA, 0xE67E, 0xE67C, 0x9740,
    0x8E90, 0xE681, 0xE67D, 0xE685, 0x8F94, 0x8CBF, 0x91F8, 0x9664,
    0x8979, 0x88E0, 0x93A3, 0xE689, 0xE688, 0x93E4, 0xE68D, 0xE682,
    0xE68C, 0xE68E, 0x8CAA, 0xE68A, 0x8D75, 0x8ED3, 0xE68F, 0x9777,
    0xE692, 0xE695, 0xE693, 0x9554, 0xE690, 0x8BDE, 0xE694, 0xE696,
    0xE69A, 0xE697, 0xE699, 0xE698, 0xE69B, 0x8EAF, 0xE69D, 0xE69C,
    0x9588, 0xE69F, 0x8C78, 0xE69E, 0xE6A0, 0xE6A1, 0x8B63, 0xE3BF,
    0x8FF7, 0xE6A2, 0x8CEC, 0xE6A3, 0xE6A4, 0x8E5D, 0x9DCC, 0xE6A5,
    0xE6A6, 0x8F51, 0xE6A7, 0xE6A8, 0xE6A9, 0xE6AA, 0xE6AB, 0x924A,
    0xE6AC, 0xE6AE, 0xE6AD, 0x93A4, 0xE6AF, 0x964C, 0xE6B0, 0xE6B1,
    0xE6B2, 0xE6B3, 0x93D8, 0x8FDB, 0xE6B4, 0x8D8B, 0x98AC, 0xE6B5,
    0xE6B6, 0x955E, 0xE6B7, 0xE6BF, 0xE6B8, 0xE6BA, 0xE6B9, 0xE6BB,
    0x9665, 0xE6BC, 0xE6BD, 0xE6BE, 0xE6C0, 0x8A4C, 0x92E5, 0x9589,
    0x8DE0, 0x8D76, 0x956E, 0x89DD, 0x94CC, 0xE6C3, 0x8AD1, 0x90D3,
    0xE6C2, 0xE6C7, 0x9299, 0x96E1, 0xE6C5, 0xE6C6, 0x8B4D, 0xE6C8,
    0x9483, 0x91DD, 0x94EF, 0x935C, 0xE6C4, 0x9666, 0x89EA, 0xE6CA,
    0x9847, 0x92C0, 0x9864, 0x8E91, 0xE6C9, 0x91AF, 0xE6DA, 0x9147,
    0x93F6, 0x956F, 0xE6CD, 0x8E5E, 0x8E92, 0x8FDC, 0x9485, 0x8CAB,
    0xE6CC, 0xE6CB, 0x958A, 0x8EBF, 0x9371, 0xE6CF, 0xE6D0, 0x8D77,
    0xE6CE, 0xE6D1, 0xE6D2, 0xE6D4, 0x91A1, 0xE6D3, 0x8AE4, 0xE6D6,
    0xE6D5, 0xE6D7, 0xE6D9, 0xE6DB, 0xE6DC, 0x90D4, 0x8ECD, 0xE6DD,
    0x8A71, 0xE6DE, 0x9196, 0xE6DF, 0xE6E0, 0x958B, 0x8B4E, 0xE6E1,
    0x92B4, 0x897A, 0xE6E2, 0x8EEF, 0x9096, 0x91AB, 0xE6E5, 0xE6E4,
    0xE6E3, 0xE6EB, 0xE6E9, 0xE6E6, 0xE6E8, 0xE6E7, 0xE6EA, 0x8B97,
    0xE6EE, 0x90D5, 0xE6EF, 0x8CD7, 0xE6EC, 0xE6ED, 0x9848, 0x92B5,
    0x9148, 0xE6F0, 0xE6F3, 0xE6F1, 0xE6F2, 0x9778, 0x93A5, 0xE6F6,
    0xE6F4, 0xE6F5, 0xE6F7, 0xE748, 0xE6FA, 0xE6FB, 0xE6F9, 0xE6F8,
    0x92FB, 0xE740, 0xE744, 0xE741, 0xE6FC, 0xE742, 0xE743, 0xE74A,
    0xE745, 0x90D6, 0xE747, 0xE749, 0xE746, 0xE74C, 0x8F52, 0xE74B,
    0xE74D, 0xE74E, 0xE751, 0xE750, 0xE74F, 0xE753, 0xE752, 0x96F4,
    0xE755, 0xE754, 0xE756, 0xE757, 0xE759, 0xE758, 0x9067, 0xE75A,
    0x8BEB, 0xE75B, 0xE75D, 0xE75E, 0xE75F, 0xE75C, 0xE760, 0x8ED4,
    0xE761, 0x8B4F, 0x8C52, 0x8CAC, 0xE762, 0x93EE, 0x935D, 0xE763,
    0xE766, 0x8EB2, 0xE765, 0xE764, 0x8C79, 0xE767, 0x8A72, 0xE769,
    0x8DDA, 0xE768, 0xE771, 0xE76B, 0xE76D, 0x95E3, 0xE76A, 0xE76C,
    0xE770, 0xE76E, 0x8B50, 0xE76F, 0xE772, 0x9479, 0x97D6, 0x8F53,
    0xE773, 0x9741, 0xE775, 0xE774, 0xE778, 0x9760, 0xE777, 0x8A8D,
    0xE776, 0xE77B, 0xE77A, 0xE779, 0x9351, 0xE77C, 0xE77D, 0xE77E,
    0x8D8C, 0x8C44, 0xE780, 0xE781, 0xE782, 0x9068, 0xE783, 0x8EAB,
    0xE784, 0xE785, 0x999F, 0x999E, 0xE786, 0xE390, 0xE787, 0x9243,
    0x904A, 0x945F, 0xE788, 0x95D3, 0x92D2, 0x8D9E, 0x9248, 0x8949,
    0x9698, 0x9076, 0x8C7D, 0x8BDF, 0x95D4, 0xE789, 0xE78B, 0xE78A,
    0x89DE, 0x93F4, 0xE78C, 0x9497, 0x9352, 0xE78D, 0x8F71, 0xE78F,
    0x96C0, 0xE79E, 0xE791, 0xE792, 0x92C7, 0x91DE, 0x9197, 0x93A6,
    0xE790, 0x8B74, 0xE799, 0xE796, 0xE7A3, 0x93A7, 0x9280, 0xE793,
    0x92FC, 0x9372, 0xE794, 0xE798, 0x9080, 0x9487, 0x92CA, 0x90C0,
    0xE797, 0x91AC, 0x91A2, 0xE795, 0x88A7, 0x9841, 0xE79A, 0x91DF,
    0x8F54, 0x9069, 0xE79C, 0xE79B, 0x88ED, 0xE79D, 0x954E, 0xE7A5,
    0x93D9, 0x908B, 0x9278, 0x8BF6, 0xE7A4, 0x9756, 0x895E, 0x95D5,
    0x89DF, 0xE79F, 0xE7A0, 0xE7A1, 0xE7A2, 0x93B9, 0x9242, 0x88E1,
    0xE7A6, 0xE7A7, 0xEAA1, 0x91BB, 0xE7A8, 0x8993, 0x916B, 0x8CAD,
    0x9779, 0xE7A9, 0x934B, 0x9198, 0x8ED5, 0xE7AA, 0xE7AD, 0x8F85,
    0xE7AB, 0x914A, 0x9149, 0x88E2, 0x97C9, 0xE7AF, 0x94F0, 0xE7B1,
    0xE7B0, 0xE7AE, 0xE284, 0x8AD2, 0xE78E, 0xE7B3, 0xE7B2, 0xE7B4,
    0x9757, 0x93DF, 0x964D, 0xE7B5, 0x8ED7, 0xE7B6, 0xE7B7, 0xE7B8,
    0x9340, 0x88E8, 0x8D78, 0x9859, 0xE7BC, 0x8C53, 0xE7B9, 0xE7BA,
    0x9594, 0x8A73, 0x9758, 0x8BBD, 0x9373, 0xE7BD, 0xE7BE, 0xE7BF,
    0x9341, 0xE7C1, 0xE7C0, 0x93D1, 0xE7C2, 0x8F55, 0x8EDE, 0x947A,
    0x9291, 0x8EF0, 0x908C, 0xE7C3, 0xE7C4, 0x907C, 0xE7C5, 0xE7C6,
    0xE7C7, 0x978F, 0x8F56, 0xE7C9, 0xE7C8, 0x8D79, 0x8D93, 0x8E5F,
    0xE7CC, 0x8F86, 0xE7CB, 0xE7CA, 0x91E7, 0x8CED, 0x90C1, 0x94AE,
    0x8F58, 0xE7CD, 0x8FDD, 0xE7D0, 0xE7CE, 0xE7CF, 0xE7D2, 0xE7D1,
    0x8FF8, 0xE7D3, 0xE7D4, 0xE7D5, 0x94CE, 0x8DD1, 0x8EDF, 0xE7D6,
    0xE7D7, 0x97A2, 0x8F64, 0x96EC, 0x97CA, 0xE7D8, 0x8BE0, 0xE7D9,
    0x9342, 0xE7DC, 0x8A98, 0x906A, 0xE7DA, 0xE7DB, 0x92DE, 0x9674,
    0x8BFA, 0xE7DE, 0xE7DF, 0xE7DD, 0xE7E1, 0x93DD, 0x8A62, 0xE7E5,
    0xE7E2, 0xE7E4, 0xE7E0, 0xE86E, 0xE7E3, 0x97E9, 0x8CD8, 0xE7ED,
    0x9353, 0xE7E8, 0xE7EB, 0xE7E9, 0xE7EE, 0xE7EF, 0xE7E7, 0xE7F4,
    0x8994, 0xE7E6, 0x94AB, 0xE7EA, 0x8FDE, 0x8D7A, 0x9667, 0x8BE2,
    0x8F65, 0x93BA, 0x914C, 0xE7F2, 0xE7EC, 0xE7F1, 0x96C1, 0x92B6,
    0xE7F3, 0xE7F0, 0x914B, 0xE7F7, 0xE7F6, 0xE7F5, 0x964E, 0x8F9B,
    0xE7F8, 0x95DD, 0x8973, 0x9565, 0x9292, 0x8B98, 0xE7FA, 0x8D7C,
    0x8E4B, 0xE7F9, 0x908D, 0x908E, 0xE840, 0xE842, 0x8FF9, 0xE841,
    0xE843, 0x8BD1, 0x9564, 0x8EE0, 0x9842, 0xE7FC, 0x8DF6, 0x985E,
    0xE845, 0xE844, 0xE846, 0xE7FB, 0x93E7, 0x9374, 0x92D5, 0xE84B,
    0x9262, 0xE847, 0xE848, 0x8C4C, 0xE84A, 0x8CAE, 0xE849, 0x8FDF,
    0x8A99, 0xE84F, 0x8DBD, 0x9199, 0x92C8, 0x8A5A, 0xE84D, 0xE84E,
    0x92C1, 0xE84C, 0xE850, 0xE856, 0xE859, 0xE858, 0x934C, 0xE851,
    0xE852, 0xE855, 0xE857, 0x8BBE, 0xE85A, 0xE854, 0xE853, 0xE85E,
    0xE85F, 0xE860, 0xE85D, 0xE85C, 0x8FE0, 0x93A8, 0xE85B, 0xE864,
    0xE862, 0xE863, 0xE861, 0x91F6, 0xE865, 0xE866, 0xE868, 0x8AD3,
    0xE867, 0x96F8, 0xE873, 0xE869, 0xE86C, 0xE86A, 0xE86B, 0xE86D,
    0xE86F, 0xE870, 0xE871, 0xE874, 0xE872, 0xE875, 0xE877, 0xE876,
    0x92B7, 0x96E5, 0xE878, 0x914D, 0xE879, 0x95C2, 0xE87A, 0x8A4A,
    0x895B, 0x8AD5, 0x8AD4, 0xE87B, 0xE87C, 0xE87D, 0xE87E, 0xE880,
    0x8AD6, 0x8A74, 0x8D7D, 0x94B4, 0xE882, 0xE881, 0xE883, 0x897B,
    0xE886, 0xE885, 0xE884, 0xE887, 0xE88A, 0x88C5, 0xE888, 0xE88C,
    0xE88B, 0xE88E, 0xE88D, 0xE88F, 0x93AC, 0xE890, 0xE891, 0xE893,
    0xE892, 0x958C, 0xE894, 0xE895, 0x8DE3, 0xE896, 0xE897, 0x9668,
    0x916A, 0x88A2, 0x91C9, 0xE898, 0x958D, 0xE89B, 0xE899, 0x8D7E,
    0xE89A, 0x8CC0, 0x95C3, 0xE89D, 0xE89F, 0xE89E, 0xE8A0, 0x8940,
    0x9077, 0x8F9C, 0x8AD7, 0xE8A1, 0x9486, 0xE8A3, 0x8941, 0xE8A2,
    0x92C2, 0x97CB, 0x93A9, 0xE89C, 0x97A4, 0x8CAF, 0x977A, 0x8BF7,
    0x97B2, 0x8C47, 0x91E0, 0xE440, 0xE8A4, 0x8A4B, 0x908F, 0x8A75,
    0xE8A6, 0xE8A7, 0xE8A5, 0x8C84, 0x8DDB, 0x8FE1, 0x8942, 0x97D7,
    0xE8A9, 0xE7AC, 0xE8A8, 0xE8AC, 0xE8AA, 0xE8AB, 0xE8AD, 0xE8AE,
    0x97EA, 0xE8AF, 0xE8B0, 0x90C7, 0x94B9, 0x909D, 0x8AE5, 0x9759,
    0x89EB, 0x8F57, 0x8CD9, 0xE8B3, 0xE8B2, 0x8E93, 0xE8B4, 0xE8B1,
    0x8E47, 0xE8B8, 0xE5AB, 0x99D4, 0x9097, 0xE8B6, 0x97A3, 0x93EF,
    0x894A, 0x90E1, 0x8EB4, 0x95B5, 0x895F, 0x97EB, 0x978B, 0xE8B9,
    0x9364, 0x8EF9, 0xE8BA, 0xE8BB, 0x906B, 0xE8BC, 0x97EC, 0xE8B7,
    0xE8BE, 0xE8C0, 0xE8BF, 0xE8BD, 0xE8C1, 0xE8C2, 0x919A, 0x89E0,
    0xE8C3, 0x96B6, 0xE8C4, 0xE8C5, 0x9849, 0x9E50, 0xE8C6, 0xE8C7,
    0xE8C8, 0xE8CC, 0xE8C9, 0xE8CA, 0xE8CB, 0xE8CD, 0x90C2, 0x96F5,
    0x90C3, 0xE8CE, 0x94F1, 0xE8CF, 0xEA72, 0x96CA, 0xE8D0, 0xE8D1,
    0xE8D2, 0x8A76, 0xE8D4, 0x9078, 0xE8D5, 0x8C43, 0xE8D6, 0xE8DA,
    0xE8D8, 0xE8D9, 0x8A93, 0xE8D7, 0xE8DB, 0xE8DC, 0x88C6, 0xE8DD,
    0xE8DE, 0x8FE2, 0xE8DF, 0x8B66, 0xE8E2, 0xE8E1, 0xE8E0, 0xE691,
    0x95DA, 0xE8E3, 0xE8E4, 0xE8E5, 0xE8E6, 0xE8E7, 0xE8E8, 0x8AD8,
    0xE8E9, 0xE8EA, 0x9442, 0xE8EC, 0x89B9, 0xE8EF, 0xE8EE, 0x8943,
    0x8BBF, 0x95C5, 0x92B8, 0x8DA0, 0x8D80, 0x8F87, 0x907B, 0xE8F1,
    0xE8F0, 0x9761, 0x8AE6, 0x94D0, 0x93DA, 0x909C, 0x97CC, 0x8C7A,
    0xE8F4, 0xE8F3, 0x966A, 0x93AA, 0x896F, 0xE8F5, 0xE8F2, 0x9570,
    0x978A, 0xE8F6, 0xE8F7, 0xE8F9, 0x91E8, 0x8A7A, 0x8A7B, 0xE8F8,
    0x8AE7, 0x8CB0, 0x8AE8, 0x935E, 0x97DE, 0x8CDA, 0xE8FA, 0xE8FB,
    0xE8FC, 0xE940, 0xE942, 0xE941, 0x9597, 0xE943, 0xE944, 0xE945,
    0xE946, 0xE948, 0xE947, 0xE949, 0x94F2, 0xE3CA, 0x9048, 0x8B51,
    0xE94A, 0xE94B, 0x99AA, 0x9F5A, 0x94D1, 0x88F9, 0x88B9, 0x8E94,
    0x964F, 0x8FFC, 0xE94C, 0x96DD, 0xE94D, 0x977B, 0x8961, 0x8E60,
    0xE94E, 0x89EC, 0xE94F, 0xE950, 0xE952, 0xE953, 0xE955, 0xE951,
    0xE954, 0x8AD9, 0xE956, 0xE957, 0xE958, 0xE959, 0xE95A, 0xE95C,
    0xE95B, 0xE95E, 0xE961, 0xE95D, 0xE95F, 0xE960, 0xE962, 0x8BC0,
    0x8EF1, 0xE963, 0xE964, 0x8D81, 0xE965, 0x8A5D, 0x946E, 0xE966,
    0xE967, 0x9279, 0x93E9, 0xE968, 0x949D, 0x91CA, 0x8977, 0x8BEC,
    0x8BED, 0x9293, 0xE96D, 0x8BEE, 0x89ED, 0xE96C, 0xE96A, 0xE96B,
    0xE969, 0xE977, 0xE96E, 0xE96F, 0xE970, 0xE971, 0xE973, 0xE972,
    0x8F78, 0xE974, 0xE976, 0x8B52, 0xE975, 0x919B, 0x8CB1, 0xE978,
    0x91CB, 0xE979, 0x93AB, 0xE97A, 0xE980, 0xE97D, 0xE97C, 0xE97E,
    0xE97B, 0xE982, 0xE981, 0xE984, 0x8BC1, 0xE983, 0xE985, 0xE986,
    0xE988, 0xE987, 0xE989, 0xE98B, 0xE98A, 0x8D9C, 0xE98C, 0xE98D,
    0x8A5B, 0xE98E, 0xE98F, 0x9091, 0xE990, 0xE991, 0xE992, 0xE993,
    0x8D82, 0xE994, 0xE995, 0xE996, 0xE997, 0xE998, 0x94AF, 0xE99A,
    0x9545, 0xE99B, 0xE999, 0xE99D, 0xE99C, 0xE99E, 0xE99F, 0xE9A0,
    0xE9A1, 0xE9A2, 0xE9A3, 0xE9A4, 0xE9A5, 0xE9A6, 0xE9A7, 0xE9A8,
    0xE9A9, 0xE9AA, 0xE9AB, 0xE9AC, 0x9F54, 0xE9AD, 0xE2F6, 0x8B53,
    0x8A40, 0x8DB0, 0xE9AF, 0xE9AE, 0x96A3, 0xE9B1, 0xE9B2, 0xE9B0,
    0xE9B3, 0x9682, 0xE9B4, 0x8B9B, 0x9844, 0xE9B5, 0xE9B7, 0x88BC,
    0xE9B8, 0x95A9, 0xE9B6, 0xE9B9, 0xE9BA, 0xE9BB, 0xE9BC, 0xE9BD,
    0x968E, 0x8E4C, 0x8DF8, 0x914E, 0xE9BE, 0xE9C1, 0xE9BF, 0xE9C2,
    0x8CEF, 0xE9C0, 0xE9C3, 0xE9C4, 0xE9C5, 0xE9C9, 0x8E49, 0x91E2,
    0xE9CA, 0xE9C7, 0xE9C6, 0xE9C8, 0x8C7E, 0xE9CE, 0xE9CD, 0xE9CC,
    0x88B1, 0xE9D8, 0xE9D4, 0xE9D5, 0xE9D1, 0xE9D7, 0xE9D3, 0x8A82,
    0x986B, 0xE9D6, 0xE9D2, 0xE9D0, 0xE9CF, 0xE9DA, 0xE9DD, 0xE9DC,
    0xE9DB, 0x9568, 0xE9D9, 0x88F1, 0xE9DE, 0xE9E0, 0x8A8F, 0xE9CB,
    0x8956, 0xE9E2, 0xE9E1, 0xE9DF, 0x924C, 0x9690, 0x97D8, 0xE9E3,
    0xE9E4, 0xE9E5, 0xE9E6, 0xE9E7, 0x92B9, 0xE9E8, 0x94B5, 0xE9ED,
    0xE9E9, 0xE9EA, 0x9650, 0x96C2, 0x93CE, 0xE9EE, 0xE9EF, 0x93BC,
    0xE9EC, 0xE9EB, 0x89A8, 0xE9F7, 0xE9F6, 0x8995, 0xE9F4, 0xE9F3,
    0xE9F1, 0x8A9B, 0xE9F0, 0x8EB0, 0x89A7, 0x8D83, 0xE9FA, 0xE9F9,
    0xE9F8, 0xE9F5, 0xE9FB, 0xE9FC, 0xEA44, 0xEA43, 0xEA45, 0x894C,
    0xEA40, 0xEA41, 0x8D94, 0x96B7, 0xEA42, 0x9651, 0xEA4A, 0xEA46,
    0xEA4B, 0xEA48, 0xEA47, 0x8C7B, 0xEA4C, 0xEA4D, 0xEA4E, 0xEA49,
    0xE9F2, 0xEA4F, 0x92DF, 0xEA53, 0xEA54, 0xEA52, 0xEA51, 0xEA57,
    0xEA50, 0xEA55, 0xEA56, 0xEA59, 0xEA58, 0xEA5B, 0xEA5C, 0xEA5D,
    0x9868, 0xEA5A, 0x91E9, 0x8DEB, 0xEA5E, 0xEA5F, 0xEA60, 0xEA61,
    0xEA62, 0x8CB2, 0xEA63, 0xEA64, 0x8EAD, 0xEA65, 0xEA66, 0xEA67,
    0xEA68, 0xEA6B, 0xEA69, 0x985B, 0xEA6A, 0x97ED, 0xEA6C, 0x97D9,
    0xEA6D, 0x949E, 0xEA6E, 0xEA70, 0xEA71, 0xEA6F, 0x8D8D, 0x96CB,
    0x9683, 0x9BF5, 0x9F80, 0x969B, 0x89A9, 0xEA73, 0x8B6F, 0xEA74,
    0xEA75, 0xEA76, 0x8D95, 0xEA77, 0xE0D2, 0x96D9, 0x91E1, 0xEA78,
    0xEA7A, 0xEA79, 0xEA7B, 0xEA7C, 0xEA7D, 0xEA7E, 0xEA80, 0xEA81,
    0xEA82, 0xEA83, 0xEA84, 0xEA85, 0xEA86, 0xEA87, 0xEA88, 0x9343,
    0x8CDB, 0xEA8A, 0x916C, 0xEA8B, 0xEA8C, 0x9540, 0xEA8D, 0xEA8E,
    0xE256, 0xE6D8, 0xE8EB, 0xEA8F, 0xEA90, 0xEA92, 0xEA93, 0xEA94,
    0x97EE, 0xEA91, 0xEA95, 0xEA96, 0xEA98, 0xEA97, 0xEA9A, 0xEA9B,
    0xEA99, 0x97B4, 0xEA9C, 0xEA9D, 0xE273, 0xEA9E, 0x8149, 0x8194,
    0x8190, 0x8193, 0x8195, 0x8169, 0x816A, 0x8196, 0x817B, 0x8143,
    0x8144, 0x815E, 0x824F, 0x8250, 0x8251, 0x8252, 0x8253, 0x8254,
    0x8255, 0x8256, 0x8257, 0x8258, 0x8146, 0x8147, 0x8183, 0x8181,
    0x8184, 0x8148, 0x8197, 0x8260, 0x8261, 0x8262, 0x8263, 0x8264,
    0x8265, 0x8266, 0x8267, 0x8268, 0x8269, 0x826A, 0x826B, 0x826C,
    0x826D, 0x826E, 0x826F, 0x8270, 0x8271, 0x8272, 0x8273, 0x8274,
    0x8275, 0x8276, 0x8277, 0x8278, 0x8279, 0x816D, 0x816E, 0x814F,
    0x8151, 0x814D, 0x8281, 0x8282, 0x8283, 0x8284, 0x8285, 0x8286,
    0x8287, 0x8288, 0x8289, 0x828A, 0x828B, 0x828C, 0x828D, 0x828E,
    0x828F, 0x8290, 0x8291, 0x8292, 0x8293, 0x8294, 0x8295, 0x8296,
    0x8297, 0x8298, 0x8299, 0x829A, 0x816F, 0x8162, 0x8170, 0x00A1,
    0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 0x00A8, 0x00A9,
    0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 0x00B0, 0x00B1,
    0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7, 0x00B8, 0x00B9,
    0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF, 0x00C0, 0x00C1,
    0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 0x00C8, 0x00C9,
    0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF, 0x00D0, 0x00D1,
    0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7, 0x00D8, 0x00D9,
    0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF, 0x8150, 0x818F,
};

#endif /* Z_SJIS_H */
